/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.reader.series;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.execution.operator.source.AlignedSeriesScanUtil;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.SeriesScanOptions;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSource;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.series.AbstractAlignedSeriesScanTest;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.PlainDeviceID;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.Assert;
import org.junit.Test;

public class AlignedSingleColumnSeriesScanLimitOffsetPushDownTest
extends AbstractAlignedSeriesScanTest {
    private static final int TEST_LIMIT = 5;

    private AlignedSeriesScanUtil getAlignedSingleColumnSeriesScanUtil(long offset) throws IllegalPathException {
        AlignedPath scanPath = new AlignedPath(((PlainDeviceID)TEST_DEVICE).toStringID(), Collections.singletonList("s1"), Collections.singletonList(new MeasurementSchema("s1", TSDataType.INT32)));
        SeriesScanOptions.Builder scanOptionsBuilder = new SeriesScanOptions.Builder();
        scanOptionsBuilder.withAllSensors(new HashSet(scanPath.getMeasurementList()));
        scanOptionsBuilder.withPushDownLimit(5L);
        scanOptionsBuilder.withPushDownOffset(offset);
        AlignedSeriesScanUtil seriesScanUtil = new AlignedSeriesScanUtil((PartialPath)scanPath, Ordering.ASC, scanOptionsBuilder.build(), EnvironmentUtils.TEST_QUERY_FI_CONTEXT);
        seriesScanUtil.initQueryDataSource(new QueryDataSource(seqResources, unSeqResources));
        return seriesScanUtil;
    }

    @Test
    public void testSkipFile() throws IllegalPathException, IOException {
        AlignedSeriesScanUtil seriesScanUtil = this.getAlignedSingleColumnSeriesScanUtil(20L);
        Assert.assertTrue((boolean)seriesScanUtil.hasNextFile());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        TsBlock tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)0L, (long)tsBlock.getPositionCount());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextPage());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextFile());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)5L, (long)tsBlock.getPositionCount());
        long expectedTime = 24L;
        int size = tsBlock.getPositionCount();
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((long)expectedTime++, (long)tsBlock.getTimeByIndex(i));
        }
    }

    @Test
    public void testSkipChunk() throws IllegalPathException, IOException {
        int i;
        AlignedSeriesScanUtil seriesScanUtil = this.getAlignedSingleColumnSeriesScanUtil(30L);
        Assert.assertTrue((boolean)seriesScanUtil.hasNextFile());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        TsBlock tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)0L, (long)tsBlock.getPositionCount());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextPage());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextFile());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)2L, (long)tsBlock.getPositionCount());
        long expectedTime = 34L;
        int size = tsBlock.getPositionCount();
        for (i = 0; i < size; ++i) {
            Assert.assertEquals((long)expectedTime++, (long)tsBlock.getTimeByIndex(i));
        }
        Assert.assertFalse((boolean)seriesScanUtil.hasNextPage());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextFile());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)3L, (long)tsBlock.getPositionCount());
        expectedTime = 40L;
        size = tsBlock.getPositionCount();
        for (i = 0; i < size; ++i) {
            Assert.assertEquals((long)expectedTime++, (long)tsBlock.getTimeByIndex(i));
        }
        Assert.assertFalse((boolean)seriesScanUtil.hasNextPage());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextFile());
    }

    @Test
    public void testSkipPage() throws IllegalPathException, IOException {
        int i;
        AlignedSeriesScanUtil seriesScanUtil = this.getAlignedSingleColumnSeriesScanUtil(45L);
        Assert.assertTrue((boolean)seriesScanUtil.hasNextFile());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        TsBlock tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)0L, (long)tsBlock.getPositionCount());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextPage());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextFile());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)0L, (long)tsBlock.getPositionCount());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextPage());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextFile());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)3L, (long)tsBlock.getPositionCount());
        long expectedTime = 53L;
        int size = tsBlock.getPositionCount();
        for (i = 0; i < size; ++i) {
            Assert.assertEquals((long)expectedTime++, (long)tsBlock.getTimeByIndex(i));
        }
        Assert.assertFalse((boolean)seriesScanUtil.hasNextPage());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)2L, (long)tsBlock.getPositionCount());
        expectedTime = 60L;
        size = tsBlock.getPositionCount();
        for (i = 0; i < size; ++i) {
            Assert.assertEquals((long)expectedTime++, (long)tsBlock.getTimeByIndex(i));
        }
    }
}

