/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.reader.series;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.execution.operator.source.AlignedSeriesScanUtil;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.SeriesScanOptions;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSource;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.series.AbstractAlignedSeriesScanTest;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.PlainDeviceID;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterFactory;
import org.apache.iotdb.tsfile.read.filter.factory.TimeFilterApi;
import org.apache.iotdb.tsfile.read.filter.factory.ValueFilterApi;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.Assert;
import org.junit.Test;

public class AlignedSeriesScanPredicatePushDownTest
extends AbstractAlignedSeriesScanTest {
    private AlignedSeriesScanUtil getAlignedSeriesScanUtil(Filter globalTimeFilter, Filter pushDownFilter) throws IllegalPathException {
        AlignedPath scanPath = new AlignedPath(((PlainDeviceID)TEST_DEVICE).toStringID(), Arrays.asList("s1", "s2"), Arrays.asList(new MeasurementSchema("s1", TSDataType.INT32), new MeasurementSchema("s2", TSDataType.INT32)));
        SeriesScanOptions.Builder scanOptionsBuilder = new SeriesScanOptions.Builder();
        scanOptionsBuilder.withAllSensors(new HashSet(scanPath.getMeasurementList()));
        scanOptionsBuilder.withGlobalTimeFilter(globalTimeFilter);
        scanOptionsBuilder.withPushDownFilter(pushDownFilter);
        AlignedSeriesScanUtil seriesScanUtil = new AlignedSeriesScanUtil((PartialPath)scanPath, Ordering.ASC, scanOptionsBuilder.build(), EnvironmentUtils.TEST_QUERY_FI_CONTEXT);
        seriesScanUtil.initQueryDataSource(new QueryDataSource(seqResources, unSeqResources));
        return seriesScanUtil;
    }

    @Test
    public void testNoFilter() throws IllegalPathException, IOException {
        AlignedSeriesScanUtil seriesScanUtil = this.getAlignedSeriesScanUtil(null, null);
        Assert.assertTrue((boolean)seriesScanUtil.hasNextFile());
        Assert.assertTrue((boolean)seriesScanUtil.canUseCurrentFileStatistics());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.canUseCurrentChunkStatistics());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        Assert.assertTrue((boolean)seriesScanUtil.canUseCurrentPageStatistics());
        TsBlock tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)10L, (long)tsBlock.getPositionCount());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextPage());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextFile());
        Assert.assertTrue((boolean)seriesScanUtil.canUseCurrentFileStatistics());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.canUseCurrentChunkStatistics());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        Assert.assertTrue((boolean)seriesScanUtil.canUseCurrentPageStatistics());
        tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)10L, (long)tsBlock.getPositionCount());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextPage());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextFile());
        Assert.assertTrue((boolean)seriesScanUtil.canUseCurrentFileStatistics());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.canUseCurrentChunkStatistics());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        Assert.assertTrue((boolean)seriesScanUtil.canUseCurrentPageStatistics());
        tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)10L, (long)tsBlock.getPositionCount());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextPage());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.canUseCurrentChunkStatistics());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        Assert.assertTrue((boolean)seriesScanUtil.canUseCurrentPageStatistics());
        tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)10L, (long)tsBlock.getPositionCount());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextPage());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextFile());
        Assert.assertFalse((boolean)seriesScanUtil.canUseCurrentFileStatistics());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.canUseCurrentChunkStatistics());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        Assert.assertTrue((boolean)seriesScanUtil.canUseCurrentPageStatistics());
        tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)10L, (long)tsBlock.getPositionCount());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextPage());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        Assert.assertTrue((boolean)seriesScanUtil.canUseCurrentPageStatistics());
        tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)10L, (long)tsBlock.getPositionCount());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextPage());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        Assert.assertTrue((boolean)seriesScanUtil.canUseCurrentPageStatistics());
        tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)10L, (long)tsBlock.getPositionCount());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextPage());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertFalse((boolean)seriesScanUtil.canUseCurrentChunkStatistics());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        Assert.assertFalse((boolean)seriesScanUtil.canUseCurrentPageStatistics());
        tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)10L, (long)tsBlock.getPositionCount());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        Assert.assertTrue((boolean)seriesScanUtil.canUseCurrentPageStatistics());
        tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)10L, (long)tsBlock.getPositionCount());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextPage());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextFile());
    }

    @Test
    public void testSkipWithFilter() throws IllegalPathException, IOException {
        AlignedSeriesScanUtil seriesScanUtil = this.getAlignedSeriesScanUtil((Filter)TimeFilterApi.gt((long)10L), FilterFactory.and((Filter)ValueFilterApi.gtEq((int)0, (Comparable)Integer.valueOf(20)), (Filter)ValueFilterApi.lt((int)1, (Comparable)Integer.valueOf(30))));
        Assert.assertTrue((boolean)seriesScanUtil.hasNextFile());
        Assert.assertFalse((boolean)seriesScanUtil.canUseCurrentFileStatistics());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.canUseCurrentChunkStatistics());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        Assert.assertTrue((boolean)seriesScanUtil.canUseCurrentPageStatistics());
        TsBlock tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)10L, (long)tsBlock.getPositionCount());
        Assert.assertEquals((long)20L, (long)tsBlock.getTimeByIndex(0));
        Assert.assertFalse((boolean)seriesScanUtil.hasNextPage());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertFalse((boolean)seriesScanUtil.canUseCurrentChunkStatistics());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        Assert.assertFalse((boolean)seriesScanUtil.canUseCurrentPageStatistics());
        tsBlock = seriesScanUtil.nextPage();
        Assert.assertTrue((tsBlock == null || tsBlock.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        Assert.assertFalse((boolean)seriesScanUtil.canUseCurrentPageStatistics());
        tsBlock = seriesScanUtil.nextPage();
        Assert.assertTrue((tsBlock == null || tsBlock.isEmpty() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)seriesScanUtil.hasNextPage());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextFile());
    }
}

