/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.reader.series;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.execution.operator.source.AlignedSeriesScanUtil;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.SeriesScanOptions;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSource;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.series.AbstractAlignedSeriesScanTest;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.PlainDeviceID;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.Assert;
import org.junit.Test;

public class AlignedSeriesScanLimitOffsetPushDownTest
extends AbstractAlignedSeriesScanTest {
    private AlignedSeriesScanUtil getAlignedSeriesScanUtil(long limit, long offset) throws IllegalPathException {
        AlignedPath scanPath = new AlignedPath(((PlainDeviceID)TEST_DEVICE).toStringID(), Arrays.asList("s1", "s2"), Arrays.asList(new MeasurementSchema("s1", TSDataType.INT32), new MeasurementSchema("s2", TSDataType.INT32)));
        SeriesScanOptions.Builder scanOptionsBuilder = new SeriesScanOptions.Builder();
        scanOptionsBuilder.withAllSensors(new HashSet(scanPath.getMeasurementList()));
        scanOptionsBuilder.withPushDownLimit(limit);
        scanOptionsBuilder.withPushDownOffset(offset);
        AlignedSeriesScanUtil seriesScanUtil = new AlignedSeriesScanUtil((PartialPath)scanPath, Ordering.ASC, scanOptionsBuilder.build(), EnvironmentUtils.TEST_QUERY_FI_CONTEXT);
        seriesScanUtil.initQueryDataSource(new QueryDataSource(seqResources, unSeqResources));
        return seriesScanUtil;
    }

    @Test
    public void testSkipFile() throws IllegalPathException, IOException {
        AlignedSeriesScanUtil seriesScanUtil = this.getAlignedSeriesScanUtil(5L, 10L);
        Assert.assertTrue((boolean)seriesScanUtil.hasNextFile());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        TsBlock tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)5L, (long)tsBlock.getPositionCount());
        long expectedTime = 10L;
        int size = tsBlock.getPositionCount();
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((long)expectedTime++, (long)tsBlock.getTimeByIndex(i));
        }
        Assert.assertFalse((boolean)seriesScanUtil.hasNextPage());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextFile());
    }

    @Test
    public void testCannotSkipFile() throws IllegalPathException, IOException {
        AlignedSeriesScanUtil seriesScanUtil = this.getAlignedSeriesScanUtil(5L, 20L);
        Assert.assertTrue((boolean)seriesScanUtil.hasNextFile());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        TsBlock tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)0L, (long)tsBlock.getPositionCount());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextPage());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextFile());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)5L, (long)tsBlock.getPositionCount());
        long expectedTime = 20L;
        int size = tsBlock.getPositionCount();
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((long)expectedTime++, (long)tsBlock.getTimeByIndex(i));
        }
    }

    @Test
    public void testSkipChunk() throws IllegalPathException, IOException {
        AlignedSeriesScanUtil seriesScanUtil = this.getAlignedSeriesScanUtil(5L, 30L);
        Assert.assertTrue((boolean)seriesScanUtil.hasNextFile());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        TsBlock tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)0L, (long)tsBlock.getPositionCount());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextPage());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextFile());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)5L, (long)tsBlock.getPositionCount());
        long expectedTime = 30L;
        int size = tsBlock.getPositionCount();
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((long)expectedTime++, (long)tsBlock.getTimeByIndex(i));
        }
    }

    @Test
    public void testCannotSkipChunk() throws IllegalPathException, IOException {
        AlignedSeriesScanUtil seriesScanUtil = this.getAlignedSeriesScanUtil(5L, 40L);
        Assert.assertTrue((boolean)seriesScanUtil.hasNextFile());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        TsBlock tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)0L, (long)tsBlock.getPositionCount());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextPage());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextFile());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)0L, (long)tsBlock.getPositionCount());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextPage());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextFile());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)5L, (long)tsBlock.getPositionCount());
        long expectedTime = 40L;
        int size = tsBlock.getPositionCount();
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((long)expectedTime++, (long)tsBlock.getTimeByIndex(i));
        }
    }

    @Test
    public void testSkipPage() throws IllegalPathException, IOException {
        AlignedSeriesScanUtil seriesScanUtil = this.getAlignedSeriesScanUtil(5L, 50L);
        Assert.assertTrue((boolean)seriesScanUtil.hasNextFile());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        TsBlock tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)0L, (long)tsBlock.getPositionCount());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextPage());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextFile());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)0L, (long)tsBlock.getPositionCount());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextPage());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextFile());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)5L, (long)tsBlock.getPositionCount());
        long expectedTime = 50L;
        int size = tsBlock.getPositionCount();
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((long)expectedTime++, (long)tsBlock.getTimeByIndex(i));
        }
    }

    @Test
    public void testCannotSkipPage() throws IllegalPathException, IOException {
        AlignedSeriesScanUtil seriesScanUtil = this.getAlignedSeriesScanUtil(5L, 60L);
        Assert.assertTrue((boolean)seriesScanUtil.hasNextFile());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        TsBlock tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)0L, (long)tsBlock.getPositionCount());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextPage());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextFile());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)0L, (long)tsBlock.getPositionCount());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextPage());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextFile());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)0L, (long)tsBlock.getPositionCount());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextPage());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)5L, (long)tsBlock.getPositionCount());
        long expectedTime = 60L;
        int size = tsBlock.getPositionCount();
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((long)expectedTime++, (long)tsBlock.getTimeByIndex(i));
        }
    }

    @Test
    public void testSkipPoint() throws IllegalPathException, IOException {
        int i;
        AlignedSeriesScanUtil seriesScanUtil = this.getAlignedSeriesScanUtil(10L, 75L);
        Assert.assertTrue((boolean)seriesScanUtil.hasNextFile());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        TsBlock tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)0L, (long)tsBlock.getPositionCount());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextPage());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextFile());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)0L, (long)tsBlock.getPositionCount());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextPage());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextFile());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)0L, (long)tsBlock.getPositionCount());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextPage());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)5L, (long)tsBlock.getPositionCount());
        long expectedTime = 75L;
        int size = tsBlock.getPositionCount();
        for (i = 0; i < size; ++i) {
            Assert.assertEquals((long)expectedTime++, (long)tsBlock.getTimeByIndex(i));
        }
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)5L, (long)tsBlock.getPositionCount());
        expectedTime = 80L;
        size = tsBlock.getPositionCount();
        for (i = 0; i < size; ++i) {
            Assert.assertEquals((long)expectedTime++, (long)tsBlock.getTimeByIndex(i));
        }
    }
}

