/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.reader.series;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.TsFileGeneratorUtils;
import org.apache.iotdb.db.storageengine.dataregion.read.control.FileReaderManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.PlainDeviceID;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.iotdb.tsfile.write.chunk.IChunkWriter;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;

public abstract class AbstractSeriesScanTest {
    protected static final String TEST_DATABASE = "root.sg_pd";
    protected static final IDeviceID TEST_DEVICE = new PlainDeviceID("root.sg_pd.d1");
    protected static final String TEST_PATH = ((PlainDeviceID)TEST_DEVICE).toStringID() + ".s1";
    protected static final List<TsFileResource> seqResources = new ArrayList<TsFileResource>();
    protected static final List<TsFileResource> unSeqResources = new ArrayList<TsFileResource>();

    @BeforeClass
    public static void setUp() throws IOException, WriteProcessException, IllegalPathException {
        List<PartialPath> writtenPaths = Collections.singletonList(new PartialPath(TEST_PATH));
        List<TSDataType> dataTypes = Collections.singletonList(TSDataType.INT32);
        List<TSEncoding> encodings = Collections.singletonList(TSEncoding.PLAIN);
        List<CompressionType> compressionTypes = Collections.singletonList(CompressionType.UNCOMPRESSED);
        File seqFile1 = new File(TestConstant.getTestTsFilePath((String)TEST_DATABASE, (long)0L, (long)0L, (long)1L));
        TsFileResource seqFileResource1 = new TsFileResource(seqFile1);
        if (!seqFile1.getParentFile().exists()) {
            Assert.assertTrue((boolean)seqFile1.getParentFile().mkdirs());
        }
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqFileResource1.getTsFile());){
            tsFileIOWriter.startChunkGroup(TEST_DEVICE);
            ArrayList<TimeRange> pages = new ArrayList<TimeRange>();
            pages.add(new TimeRange(0L, 9L));
            for (IChunkWriter chunkWriter : TsFileGeneratorUtils.createChunkWriter(writtenPaths, dataTypes, encodings, compressionTypes, false)) {
                TsFileGeneratorUtils.writeNonAlignedChunk((ChunkWriterImpl)chunkWriter, tsFileIOWriter, pages, true);
            }
            tsFileIOWriter.endChunkGroup();
            seqFileResource1.updateStartTime(TEST_DEVICE, 0L);
            seqFileResource1.updateEndTime(TEST_DEVICE, 9L);
            tsFileIOWriter.endFile();
        }
        seqFileResource1.setStatusForTest(TsFileResourceStatus.NORMAL);
        seqResources.add(seqFileResource1);
        File seqFile2 = new File(TestConstant.getTestTsFilePath((String)TEST_DATABASE, (long)0L, (long)0L, (long)2L));
        TsFileResource seqFileResource2 = new TsFileResource(seqFile2);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqFileResource2.getTsFile());){
            tsFileIOWriter.startChunkGroup(TEST_DEVICE);
            ArrayList<TimeRange> pages = new ArrayList<TimeRange>();
            pages.add(new TimeRange(10L, 19L));
            for (IChunkWriter chunkWriter : TsFileGeneratorUtils.createChunkWriter(writtenPaths, dataTypes, encodings, compressionTypes, false)) {
                TsFileGeneratorUtils.writeNonAlignedChunk((ChunkWriterImpl)chunkWriter, tsFileIOWriter, pages, true);
            }
            tsFileIOWriter.endChunkGroup();
            tsFileIOWriter.startChunkGroup(TEST_DEVICE);
            pages.clear();
            pages.add(new TimeRange(20L, 29L));
            for (IChunkWriter chunkWriter : TsFileGeneratorUtils.createChunkWriter(writtenPaths, dataTypes, encodings, compressionTypes, false)) {
                TsFileGeneratorUtils.writeNonAlignedChunk((ChunkWriterImpl)chunkWriter, tsFileIOWriter, pages, true);
            }
            tsFileIOWriter.endChunkGroup();
            seqFileResource2.updateStartTime(TEST_DEVICE, 10L);
            seqFileResource2.updateEndTime(TEST_DEVICE, 29L);
            tsFileIOWriter.endFile();
        }
        seqFileResource2.setStatusForTest(TsFileResourceStatus.NORMAL);
        seqResources.add(seqFileResource2);
        File seqFile3 = new File(TestConstant.getTestTsFilePath((String)TEST_DATABASE, (long)0L, (long)0L, (long)3L));
        TsFileResource seqFileResource3 = new TsFileResource(seqFile3);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqFileResource3.getTsFile());){
            tsFileIOWriter.startChunkGroup(TEST_DEVICE);
            ArrayList<TimeRange> pages = new ArrayList<TimeRange>();
            pages.add(new TimeRange(30L, 39L));
            pages.add(new TimeRange(40L, 49L));
            for (IChunkWriter chunkWriter : TsFileGeneratorUtils.createChunkWriter(writtenPaths, dataTypes, encodings, compressionTypes, false)) {
                TsFileGeneratorUtils.writeNonAlignedChunk((ChunkWriterImpl)chunkWriter, tsFileIOWriter, pages, true);
            }
            tsFileIOWriter.endChunkGroup();
            tsFileIOWriter.startChunkGroup(TEST_DEVICE);
            pages.clear();
            pages.add(new TimeRange(50L, 59L));
            for (IChunkWriter chunkWriter : TsFileGeneratorUtils.createChunkWriter(writtenPaths, dataTypes, encodings, compressionTypes, false)) {
                TsFileGeneratorUtils.writeNonAlignedChunk((ChunkWriterImpl)chunkWriter, tsFileIOWriter, pages, true);
            }
            tsFileIOWriter.endChunkGroup();
            seqFileResource3.updateStartTime(TEST_DEVICE, 30L);
            seqFileResource3.updateEndTime(TEST_DEVICE, 59L);
            tsFileIOWriter.endFile();
        }
        seqFileResource3.setStatusForTest(TsFileResourceStatus.NORMAL);
        seqResources.add(seqFileResource3);
        File unseqFile4 = new File(TestConstant.getTestTsFilePath((String)TEST_DATABASE, (long)0L, (long)0L, (long)4L));
        TsFileResource unseqFileResource4 = new TsFileResource(unseqFile4);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(unseqFileResource4.getTsFile());){
            tsFileIOWriter.startChunkGroup(TEST_DEVICE);
            ArrayList<TimeRange> pages = new ArrayList<TimeRange>();
            pages.add(new TimeRange(50L, 59L));
            pages.add(new TimeRange(60L, 69L));
            for (IChunkWriter chunkWriter : TsFileGeneratorUtils.createChunkWriter(writtenPaths, dataTypes, encodings, compressionTypes, false)) {
                TsFileGeneratorUtils.writeNonAlignedChunk((ChunkWriterImpl)chunkWriter, tsFileIOWriter, pages, true);
            }
            tsFileIOWriter.endChunkGroup();
            unseqFileResource4.updateStartTime(TEST_DEVICE, 50L);
            unseqFileResource4.updateEndTime(TEST_DEVICE, 69L);
            tsFileIOWriter.endFile();
        }
        unseqFileResource4.setStatusForTest(TsFileResourceStatus.NORMAL);
        unSeqResources.add(unseqFileResource4);
    }

    @AfterClass
    public static void tearDown() throws IOException {
        File[] resourceFiles;
        TsFileResource files;
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        for (TsFileResource tsFileResource : seqResources) {
            if (!tsFileResource.getTsFile().exists()) continue;
            tsFileResource.remove();
        }
        for (TsFileResource tsFileResource : unSeqResources) {
            if (!tsFileResource.getTsFile().exists()) continue;
            tsFileResource.remove();
        }
        for (File file : files = FSFactoryProducer.getFSFactory().listFilesBySuffix("target", ".tsfile")) {
            file.delete();
        }
        for (File resourceFile : resourceFiles = FSFactoryProducer.getFSFactory().listFilesBySuffix("target", ".resource")) {
            resourceFile.delete();
        }
        seqResources.clear();
        unSeqResources.clear();
        EnvironmentUtils.cleanAllDir();
    }
}

