/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.reader.series;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.storageengine.buffer.BloomFilterCache;
import org.apache.iotdb.db.storageengine.buffer.ChunkCache;
import org.apache.iotdb.db.storageengine.buffer.TimeSeriesMetadataCache;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.TsFileGeneratorUtils;
import org.apache.iotdb.db.storageengine.dataregion.read.control.FileReaderManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.PlainDeviceID;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.write.chunk.AlignedChunkWriterImpl;
import org.apache.iotdb.tsfile.write.chunk.IChunkWriter;
import org.apache.iotdb.tsfile.write.chunk.ValueChunkWriter;
import org.apache.iotdb.tsfile.write.page.TimePageWriter;
import org.apache.iotdb.tsfile.write.page.ValuePageWriter;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;

public abstract class AbstractAlignedSeriesScanTest {
    protected static final String TEST_DATABASE = "root.sg_pd";
    protected static final IDeviceID TEST_DEVICE = new PlainDeviceID("root.sg_pd.d1_aligned");
    protected static final List<TsFileResource> seqResources = new ArrayList<TsFileResource>();
    protected static final List<TsFileResource> unSeqResources = new ArrayList<TsFileResource>();

    @BeforeClass
    public static void setUp() throws IOException, WriteProcessException, IllegalPathException {
        long timestamp;
        List<PartialPath> writtenPaths = Arrays.asList(new AlignedPath(((PlainDeviceID)TEST_DEVICE).toStringID(), "s1"), new AlignedPath(((PlainDeviceID)TEST_DEVICE).toStringID(), "s2"), new AlignedPath(((PlainDeviceID)TEST_DEVICE).toStringID(), "s3"));
        List<TSDataType> dataTypes = Arrays.asList(TSDataType.INT32, TSDataType.INT32, TSDataType.INT32);
        List<TSEncoding> encodings = Arrays.asList(TSEncoding.PLAIN, TSEncoding.PLAIN, TSEncoding.PLAIN);
        List<CompressionType> compressionTypes = Arrays.asList(CompressionType.UNCOMPRESSED, CompressionType.UNCOMPRESSED, CompressionType.UNCOMPRESSED);
        File seqFile1 = new File(TestConstant.getTestTsFilePath((String)TEST_DATABASE, (long)0L, (long)0L, (long)1L));
        TsFileResource seqFileResource1 = new TsFileResource(seqFile1);
        if (!seqFile1.getParentFile().exists()) {
            Assert.assertTrue((boolean)seqFile1.getParentFile().mkdirs());
        }
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqFileResource1.getTsFile());){
            tsFileIOWriter.startChunkGroup(TEST_DEVICE);
            ArrayList<TimeRange> pages = new ArrayList<TimeRange>();
            pages.add(new TimeRange(0L, 9L));
            for (IChunkWriter chunkWriter : TsFileGeneratorUtils.createChunkWriter(writtenPaths, dataTypes, encodings, compressionTypes, true)) {
                TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)chunkWriter, tsFileIOWriter, pages, true);
            }
            tsFileIOWriter.endChunkGroup();
            seqFileResource1.updateStartTime(TEST_DEVICE, 0L);
            seqFileResource1.updateEndTime(TEST_DEVICE, 9L);
            tsFileIOWriter.endFile();
        }
        seqFileResource1.setStatusForTest(TsFileResourceStatus.NORMAL);
        seqResources.add(seqFileResource1);
        File seqFile2 = new File(TestConstant.getTestTsFilePath((String)TEST_DATABASE, (long)0L, (long)0L, (long)2L));
        TsFileResource seqFileResource2 = new TsFileResource(seqFile2);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqFileResource2.getTsFile());){
            long timestamp2;
            long timestamp3;
            long timestamp4;
            tsFileIOWriter.startChunkGroup(TEST_DEVICE);
            AlignedChunkWriterImpl alignedChunkWriter = (AlignedChunkWriterImpl)TsFileGeneratorUtils.createChunkWriter(writtenPaths, dataTypes, encodings, compressionTypes, true).get(0);
            TimePageWriter timePageWriter = alignedChunkWriter.getTimeChunkWriter().getPageWriter();
            for (long timestamp5 = 10L; timestamp5 <= 19L; ++timestamp5) {
                timePageWriter.write(timestamp5);
            }
            alignedChunkWriter.getTimeChunkWriter().sealCurrentPage();
            List valueChunkWriterList = alignedChunkWriter.getValueChunkWriterList();
            ValuePageWriter valuePageWriter1 = ((ValueChunkWriter)valueChunkWriterList.get(0)).getPageWriter();
            for (timestamp4 = 10L; timestamp4 <= 15L; ++timestamp4) {
                TsFileGeneratorUtils.writeAlignedPoint(valuePageWriter1, timestamp4, true);
            }
            for (timestamp4 = 16L; timestamp4 <= 19L; ++timestamp4) {
                TsFileGeneratorUtils.writeNullPoint(valuePageWriter1, timestamp4);
            }
            ((ValueChunkWriter)valueChunkWriterList.get(0)).sealCurrentPage();
            ValuePageWriter valuePageWriter2 = ((ValueChunkWriter)valueChunkWriterList.get(1)).getPageWriter();
            for (timestamp3 = 10L; timestamp3 <= 13L; ++timestamp3) {
                TsFileGeneratorUtils.writeNullPoint(valuePageWriter2, timestamp3);
            }
            for (timestamp3 = 14L; timestamp3 <= 19L; ++timestamp3) {
                TsFileGeneratorUtils.writeAlignedPoint(valuePageWriter2, timestamp3, true);
            }
            ((ValueChunkWriter)valueChunkWriterList.get(1)).sealCurrentPage();
            ValuePageWriter valuePageWriter3 = ((ValueChunkWriter)valueChunkWriterList.get(2)).getPageWriter();
            for (timestamp2 = 10L; timestamp2 <= 11L; ++timestamp2) {
                TsFileGeneratorUtils.writeNullPoint(valuePageWriter3, timestamp2);
            }
            for (timestamp2 = 12L; timestamp2 <= 17L; ++timestamp2) {
                TsFileGeneratorUtils.writeAlignedPoint(valuePageWriter3, timestamp2, true);
            }
            for (timestamp2 = 18L; timestamp2 <= 19L; ++timestamp2) {
                TsFileGeneratorUtils.writeNullPoint(valuePageWriter3, timestamp2);
            }
            ((ValueChunkWriter)valueChunkWriterList.get(2)).sealCurrentPage();
            alignedChunkWriter.writeToFileWriter(tsFileIOWriter);
            tsFileIOWriter.endChunkGroup();
            seqFileResource2.updateStartTime(TEST_DEVICE, 10L);
            seqFileResource2.updateEndTime(TEST_DEVICE, 19L);
            tsFileIOWriter.endFile();
        }
        seqFileResource2.setStatusForTest(TsFileResourceStatus.NORMAL);
        seqResources.add(seqFileResource2);
        File seqFile3 = new File(TestConstant.getTestTsFilePath((String)TEST_DATABASE, (long)0L, (long)0L, (long)3L));
        TsFileResource seqFileResource3 = new TsFileResource(seqFile3);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqFileResource3.getTsFile());){
            long timestamp6;
            long timestamp7;
            tsFileIOWriter.startChunkGroup(TEST_DEVICE);
            ArrayList<TimeRange> pages = new ArrayList<TimeRange>();
            pages.add(new TimeRange(20L, 29L));
            for (IChunkWriter chunkWriter : TsFileGeneratorUtils.createChunkWriter(writtenPaths, dataTypes, encodings, compressionTypes, true)) {
                TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)chunkWriter, tsFileIOWriter, pages, true);
            }
            tsFileIOWriter.endChunkGroup();
            tsFileIOWriter.startChunkGroup(TEST_DEVICE);
            AlignedChunkWriterImpl alignedChunkWriter = (AlignedChunkWriterImpl)TsFileGeneratorUtils.createChunkWriter(writtenPaths, dataTypes, encodings, compressionTypes, true).get(0);
            TimePageWriter timePageWriter = alignedChunkWriter.getTimeChunkWriter().getPageWriter();
            for (long timestamp8 = 30L; timestamp8 <= 39L; ++timestamp8) {
                timePageWriter.write(timestamp8);
            }
            alignedChunkWriter.getTimeChunkWriter().sealCurrentPage();
            List valueChunkWriterList = alignedChunkWriter.getValueChunkWriterList();
            ValuePageWriter valuePageWriter1 = ((ValueChunkWriter)valueChunkWriterList.get(0)).getPageWriter();
            for (timestamp7 = 30L; timestamp7 <= 35L; ++timestamp7) {
                TsFileGeneratorUtils.writeAlignedPoint(valuePageWriter1, timestamp7, true);
            }
            for (timestamp7 = 36L; timestamp7 <= 39L; ++timestamp7) {
                TsFileGeneratorUtils.writeNullPoint(valuePageWriter1, timestamp7);
            }
            ((ValueChunkWriter)valueChunkWriterList.get(0)).sealCurrentPage();
            ValuePageWriter valuePageWriter2 = ((ValueChunkWriter)valueChunkWriterList.get(1)).getPageWriter();
            for (timestamp6 = 30L; timestamp6 <= 33L; ++timestamp6) {
                TsFileGeneratorUtils.writeNullPoint(valuePageWriter2, timestamp6);
            }
            for (timestamp6 = 34L; timestamp6 <= 39L; ++timestamp6) {
                TsFileGeneratorUtils.writeAlignedPoint(valuePageWriter2, timestamp6, true);
            }
            ((ValueChunkWriter)valueChunkWriterList.get(1)).sealCurrentPage();
            ValuePageWriter valuePageWriter3 = ((ValueChunkWriter)valueChunkWriterList.get(2)).getPageWriter();
            for (timestamp = 30L; timestamp <= 31L; ++timestamp) {
                TsFileGeneratorUtils.writeNullPoint(valuePageWriter3, timestamp);
            }
            for (timestamp = 32L; timestamp <= 37L; ++timestamp) {
                TsFileGeneratorUtils.writeAlignedPoint(valuePageWriter3, timestamp, true);
            }
            for (timestamp = 38L; timestamp <= 39L; ++timestamp) {
                TsFileGeneratorUtils.writeNullPoint(valuePageWriter3, timestamp);
            }
            ((ValueChunkWriter)valueChunkWriterList.get(2)).sealCurrentPage();
            alignedChunkWriter.writeToFileWriter(tsFileIOWriter);
            tsFileIOWriter.endChunkGroup();
            seqFileResource3.updateStartTime(TEST_DEVICE, 20L);
            seqFileResource3.updateEndTime(TEST_DEVICE, 39L);
            tsFileIOWriter.endFile();
        }
        seqFileResource3.setStatusForTest(TsFileResourceStatus.NORMAL);
        seqResources.add(seqFileResource3);
        File seqFile4 = new File(TestConstant.getTestTsFilePath((String)TEST_DATABASE, (long)0L, (long)0L, (long)4L));
        TsFileResource seqFileResource4 = new TsFileResource(seqFile4);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqFileResource4.getTsFile());){
            long timestamp9;
            long timestamp10;
            tsFileIOWriter.startChunkGroup(TEST_DEVICE);
            ArrayList<TimeRange> pages = new ArrayList<TimeRange>();
            pages.add(new TimeRange(40L, 49L));
            for (IChunkWriter chunkWriter : TsFileGeneratorUtils.createChunkWriter(writtenPaths, dataTypes, encodings, compressionTypes, true)) {
                TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)chunkWriter, tsFileIOWriter, pages, true);
            }
            AlignedChunkWriterImpl alignedChunkWriter = (AlignedChunkWriterImpl)TsFileGeneratorUtils.createChunkWriter(writtenPaths, dataTypes, encodings, compressionTypes, true).get(0);
            TimePageWriter timePageWriter = alignedChunkWriter.getTimeChunkWriter().getPageWriter();
            for (long timestamp11 = 50L; timestamp11 <= 59L; ++timestamp11) {
                timePageWriter.write(timestamp11);
            }
            alignedChunkWriter.getTimeChunkWriter().sealCurrentPage();
            List valueChunkWriterList = alignedChunkWriter.getValueChunkWriterList();
            ValuePageWriter valuePageWriter1 = ((ValueChunkWriter)valueChunkWriterList.get(0)).getPageWriter();
            for (timestamp = 50L; timestamp <= 55L; ++timestamp) {
                TsFileGeneratorUtils.writeAlignedPoint(valuePageWriter1, timestamp, true);
            }
            for (timestamp = 56L; timestamp <= 59L; ++timestamp) {
                TsFileGeneratorUtils.writeNullPoint(valuePageWriter1, timestamp);
            }
            ((ValueChunkWriter)valueChunkWriterList.get(0)).sealCurrentPage();
            ValuePageWriter valuePageWriter2 = ((ValueChunkWriter)valueChunkWriterList.get(1)).getPageWriter();
            for (timestamp10 = 50L; timestamp10 <= 53L; ++timestamp10) {
                TsFileGeneratorUtils.writeNullPoint(valuePageWriter2, timestamp10);
            }
            for (timestamp10 = 54L; timestamp10 <= 59L; ++timestamp10) {
                TsFileGeneratorUtils.writeAlignedPoint(valuePageWriter2, timestamp10, true);
            }
            ((ValueChunkWriter)valueChunkWriterList.get(1)).sealCurrentPage();
            ValuePageWriter valuePageWriter3 = ((ValueChunkWriter)valueChunkWriterList.get(2)).getPageWriter();
            for (timestamp9 = 50L; timestamp9 <= 51L; ++timestamp9) {
                TsFileGeneratorUtils.writeNullPoint(valuePageWriter3, timestamp9);
            }
            for (timestamp9 = 52L; timestamp9 <= 57L; ++timestamp9) {
                TsFileGeneratorUtils.writeAlignedPoint(valuePageWriter3, timestamp9, true);
            }
            for (timestamp9 = 58L; timestamp9 <= 59L; ++timestamp9) {
                TsFileGeneratorUtils.writeNullPoint(valuePageWriter3, timestamp9);
            }
            ((ValueChunkWriter)valueChunkWriterList.get(2)).sealCurrentPage();
            alignedChunkWriter.writeToFileWriter(tsFileIOWriter);
            pages.clear();
            pages.add(new TimeRange(60L, 69L));
            for (IChunkWriter chunkWriter : TsFileGeneratorUtils.createChunkWriter(writtenPaths, dataTypes, encodings, compressionTypes, true)) {
                TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)chunkWriter, tsFileIOWriter, pages, true);
            }
            tsFileIOWriter.endChunkGroup();
            tsFileIOWriter.startChunkGroup(TEST_DEVICE);
            pages.clear();
            pages.add(new TimeRange(70L, 79L));
            for (IChunkWriter chunkWriter : TsFileGeneratorUtils.createChunkWriter(writtenPaths, dataTypes, encodings, compressionTypes, true)) {
                TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)chunkWriter, tsFileIOWriter, pages, true);
            }
            tsFileIOWriter.endChunkGroup();
            seqFileResource4.updateStartTime(TEST_DEVICE, 40L);
            seqFileResource4.updateEndTime(TEST_DEVICE, 79L);
            tsFileIOWriter.endFile();
        }
        seqFileResource4.setStatusForTest(TsFileResourceStatus.NORMAL);
        seqResources.add(seqFileResource4);
        File unseqFile5 = new File(TestConstant.getTestTsFilePath((String)TEST_DATABASE, (long)0L, (long)0L, (long)5L));
        TsFileResource unseqFileResource5 = new TsFileResource(unseqFile5);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(unseqFileResource5.getTsFile());){
            tsFileIOWriter.startChunkGroup(TEST_DEVICE);
            ArrayList<TimeRange> pages = new ArrayList<TimeRange>();
            pages.add(new TimeRange(70L, 79L));
            pages.add(new TimeRange(80L, 89L));
            for (IChunkWriter chunkWriter : TsFileGeneratorUtils.createChunkWriter(writtenPaths, dataTypes, encodings, compressionTypes, true)) {
                TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)chunkWriter, tsFileIOWriter, pages, true);
            }
            tsFileIOWriter.endChunkGroup();
            unseqFileResource5.updateStartTime(TEST_DEVICE, 70L);
            unseqFileResource5.updateEndTime(TEST_DEVICE, 89L);
            tsFileIOWriter.endFile();
        }
        unseqFileResource5.setStatusForTest(TsFileResourceStatus.NORMAL);
        unSeqResources.add(unseqFileResource5);
    }

    @AfterClass
    public static void tearDown() throws IOException {
        File[] resourceFiles;
        TsFileResource files;
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        for (TsFileResource tsFileResource : seqResources) {
            if (!tsFileResource.getTsFile().exists()) continue;
            tsFileResource.remove();
        }
        for (TsFileResource tsFileResource : unSeqResources) {
            if (!tsFileResource.getTsFile().exists()) continue;
            tsFileResource.remove();
        }
        for (File file : files = FSFactoryProducer.getFSFactory().listFilesBySuffix("target", ".tsfile")) {
            file.delete();
        }
        for (File resourceFile : resourceFiles = FSFactoryProducer.getFSFactory().listFilesBySuffix("target", ".resource")) {
            resourceFile.delete();
        }
        seqResources.clear();
        unSeqResources.clear();
        ChunkCache.getInstance().clear();
        TimeSeriesMetadataCache.getInstance().clear();
        BloomFilterCache.getInstance().clear();
        EnvironmentUtils.cleanAllDir();
    }
}

