/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.reader.common;

import java.io.IOException;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.common.FakedSeriesReader;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.common.PriorityMergeReader;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.reader.IPointReader;
import org.junit.Assert;
import org.junit.Test;

public class PriorityMergeReaderTest {
    @Test
    public void test2S() throws IOException {
        this.test(new long[]{1L, 2L, 3L, 4L, 5L, 6L}, new long[]{2L, 2L, 2L, 1L, 2L, 2L}, {1L, 2L, 3L, 4L, 5L}, {1L, 2L, 3L, 5L, 6L});
        this.test(new long[]{1L, 2L, 3L, 4L, 5L}, new long[]{1L, 1L, 1L, 1L, 1L}, {1L, 2L, 3L, 4L, 5L}, new long[0]);
        this.test(new long[]{1L, 2L, 3L, 4L, 5L}, new long[]{2L, 2L, 2L, 2L, 2L}, new long[0], {1L, 2L, 3L, 4L, 5L});
        this.test(new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L}, new long[]{1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L}, {1L, 2L, 3L, 4L, 5L}, {6L, 7L, 8L});
        this.test(new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L}, new long[]{3L, 3L, 3L, 1L, 3L, 2L, 3L}, {1L, 2L, 3L, 4L, 5L}, {1L, 2L, 3L, 5L, 6L}, {1L, 2L, 3L, 5L, 7L});
        this.test(new long[]{1L, 2L, 3L, 4L, 5L, 6L}, new long[]{1L, 1L, 2L, 3L, 2L, 3L}, {1L, 2L}, {3L, 5L}, {4L, 6L});
    }

    private void test(long[] retTimestamp, long[] retValue, long[] ... sources) throws IOException {
        int i;
        PriorityMergeReader priorityMergeReader = new PriorityMergeReader();
        for (i = 0; i < sources.length; ++i) {
            priorityMergeReader.addReader((IPointReader)new FakedSeriesReader(sources[i], i + 1), (long)(i + 1));
        }
        i = 0;
        while (priorityMergeReader.hasNextTimeValuePair()) {
            TimeValuePair timeValuePair = priorityMergeReader.nextTimeValuePair();
            Assert.assertEquals((long)retTimestamp[i], (long)timeValuePair.getTimestamp());
            Assert.assertEquals((Object)retValue[i], (Object)timeValuePair.getValue().getValue());
            ++i;
        }
    }
}

