/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk;

import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.MemPageReader;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.TimeFilterApi;
import org.apache.iotdb.tsfile.read.filter.factory.ValueFilterApi;
import org.apache.iotdb.tsfile.read.reader.series.PaginationController;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class MemPageReaderTest {
    private static final TsBlock tsBlock;
    private static final ChunkMetadata chunkMetadata;

    private MemPageReader generatePageReader() {
        return new MemPageReader(tsBlock, (IChunkMetadata)chunkMetadata, null);
    }

    @Test
    public void testNullFilter() throws IOException {
        MemPageReader pageReader = this.generatePageReader();
        TsBlock tsBlock = pageReader.getAllSatisfiedData();
        Assert.assertEquals((long)100L, (long)tsBlock.getPositionCount());
    }

    @Test
    public void testNullFilterAndLimitOffset() throws IOException {
        MemPageReader pageReader = this.generatePageReader();
        pageReader.setLimitOffset(new PaginationController(10L, 10L));
        TsBlock tsBlock = pageReader.getAllSatisfiedData();
        Assert.assertEquals((long)10L, (long)tsBlock.getPositionCount());
        Assert.assertEquals((long)10L, (long)tsBlock.getTimeByIndex(0));
        Assert.assertEquals((long)19L, (long)tsBlock.getTimeByIndex(9));
    }

    @Test
    public void testFilterAllSatisfy() throws IOException {
        MemPageReader pageReader = this.generatePageReader();
        pageReader.addRecordFilter((Filter)TimeFilterApi.gtEq((long)0L));
        TsBlock tsBlock = pageReader.getAllSatisfiedData();
        Assert.assertEquals((long)100L, (long)tsBlock.getPositionCount());
    }

    @Test
    public void testFilterAllSatisfyAndLimitOffset() throws IOException {
        MemPageReader pageReader = this.generatePageReader();
        pageReader.addRecordFilter((Filter)TimeFilterApi.gtEq((long)0L));
        pageReader.setLimitOffset(new PaginationController(10L, 10L));
        TsBlock tsBlock = pageReader.getAllSatisfiedData();
        Assert.assertEquals((long)10L, (long)tsBlock.getPositionCount());
        Assert.assertEquals((long)10L, (long)tsBlock.getTimeByIndex(0));
        Assert.assertEquals((long)19L, (long)tsBlock.getTimeByIndex(9));
    }

    @Test
    public void testFilter() throws IOException {
        MemPageReader pageReader = this.generatePageReader();
        pageReader.addRecordFilter((Filter)TimeFilterApi.gtEq((long)50L));
        pageReader.addRecordFilter((Filter)ValueFilterApi.lt((Comparable)Integer.valueOf(80)));
        TsBlock tsBlock = pageReader.getAllSatisfiedData();
        Assert.assertEquals((long)30L, (long)tsBlock.getPositionCount());
    }

    @Test
    public void testFilterAndLimitOffset() throws IOException {
        MemPageReader pageReader = this.generatePageReader();
        pageReader.addRecordFilter((Filter)TimeFilterApi.gtEq((long)50L));
        pageReader.addRecordFilter((Filter)ValueFilterApi.lt((Comparable)Integer.valueOf(80)));
        pageReader.setLimitOffset(new PaginationController(10L, 10L));
        TsBlock tsBlock = pageReader.getAllSatisfiedData();
        Assert.assertEquals((long)10L, (long)tsBlock.getPositionCount());
        Assert.assertEquals((long)60L, (long)tsBlock.getTimeByIndex(0));
        Assert.assertEquals((long)69L, (long)tsBlock.getTimeByIndex(9));
    }

    static {
        chunkMetadata = (ChunkMetadata)Mockito.mock(ChunkMetadata.class);
        TsBlockBuilder tsBlockBuilder = new TsBlockBuilder(Collections.singletonList(TSDataType.INT32));
        Statistics statistics = Statistics.getStatsByType((TSDataType)TSDataType.INT32);
        for (int i = 0; i < 100; ++i) {
            tsBlockBuilder.getTimeColumnBuilder().writeLong((long)i);
            tsBlockBuilder.getValueColumnBuilders()[0].writeInt(i);
            tsBlockBuilder.declarePosition();
            statistics.update((long)i, i);
        }
        tsBlock = tsBlockBuilder.build();
        Mockito.when((Object)chunkMetadata.getTimeStatistics()).thenReturn((Object)statistics);
        Mockito.when((Object)chunkMetadata.getMeasurementStatistics(0)).thenReturn(Optional.of(statistics));
        Mockito.when((Object)chunkMetadata.getDataType()).thenReturn((Object)TSDataType.INT32);
    }
}

