/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.storageengine.dataregion.memtable.ReadOnlyMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.MemChunkLoader;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.MemChunkReader;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.MemPageReader;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.reader.series.PaginationController;
import org.apache.iotdb.tsfile.utils.Binary;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class MemChunkLoaderTest {
    private static final String BINARY_STR = "ty love zm";

    @Test
    public void testBooleanMemChunkLoader() throws IOException {
        ReadOnlyMemChunk chunk = (ReadOnlyMemChunk)Mockito.mock(ReadOnlyMemChunk.class);
        ChunkMetadata chunkMetadata = (ChunkMetadata)Mockito.mock(ChunkMetadata.class);
        MemChunkLoader memChunkLoader = new MemChunkLoader(new QueryContext(), chunk);
        try {
            memChunkLoader.loadChunk(chunkMetadata);
            Assert.fail();
        }
        catch (UnsupportedOperationException e) {
            Assert.assertNull((Object)e.getMessage());
        }
        ChunkMetadata chunkMetadata1 = (ChunkMetadata)Mockito.mock(ChunkMetadata.class);
        Mockito.when((Object)chunk.getTsBlock()).thenReturn((Object)this.buildBooleanTsBlock());
        Mockito.when((Object)chunk.getChunkMetaData()).thenReturn((Object)chunkMetadata1);
        Mockito.when((Object)chunk.getPointReader()).thenReturn(null);
        Statistics statistics = (Statistics)Mockito.mock(Statistics.class);
        Mockito.when((Object)statistics.getCount()).thenReturn((Object)2L);
        Mockito.when((Object)chunkMetadata1.getStatistics()).thenReturn((Object)statistics);
        Mockito.when((Object)chunkMetadata1.getDataType()).thenReturn((Object)TSDataType.BOOLEAN);
        MemChunkReader chunkReader = (MemChunkReader)memChunkLoader.getChunkReader((IChunkMetadata)chunkMetadata1, null);
        List pageReaderList = chunkReader.loadPageReaderList();
        Assert.assertEquals((long)1L, (long)pageReaderList.size());
        MemPageReader pageReader = (MemPageReader)pageReaderList.get(0);
        pageReader.initTsBlockBuilder(Collections.singletonList(TSDataType.BOOLEAN));
        BatchData batchData = pageReader.getAllSatisfiedPageData();
        Assert.assertEquals((long)2L, (long)batchData.length());
        Assert.assertEquals((long)1L, (long)batchData.getTimeByIndex(0));
        Assert.assertEquals((long)2L, (long)batchData.getTimeByIndex(1));
        batchData = pageReader.getAllSatisfiedPageData(false);
        Assert.assertEquals((long)2L, (long)batchData.length());
        Assert.assertEquals((Object)BatchData.BatchDataType.DESC_READ, (Object)batchData.getBatchDataType());
        Assert.assertEquals((long)1L, (long)batchData.getTimeByIndex(0));
        Assert.assertEquals((long)2L, (long)batchData.getTimeByIndex(1));
        TsBlock tsBlock = pageReader.getAllSatisfiedData();
        Assert.assertEquals((long)2L, (long)tsBlock.getPositionCount());
        Assert.assertEquals((long)1L, (long)tsBlock.getTimeColumn().getLong(0));
        Assert.assertEquals((long)2L, (long)tsBlock.getTimeColumn().getLong(1));
        Assert.assertFalse((boolean)pageReader.isModified());
        pageReader.setLimitOffset(PaginationController.UNLIMITED_PAGINATION_CONTROLLER);
        pageReader.addRecordFilter(null);
        memChunkLoader.close();
    }

    private TsBlock buildBooleanTsBlock() {
        TsBlockBuilder builder = new TsBlockBuilder(Collections.singletonList(TSDataType.BOOLEAN));
        builder.getTimeColumnBuilder().writeLong(1L);
        builder.getColumnBuilder(0).writeBoolean(true);
        builder.declarePosition();
        builder.getTimeColumnBuilder().writeLong(2L);
        builder.getColumnBuilder(0).writeBoolean(false);
        builder.declarePosition();
        return builder.build();
    }

    @Test
    public void testInt32MemChunkLoader() throws IOException {
        ReadOnlyMemChunk chunk = (ReadOnlyMemChunk)Mockito.mock(ReadOnlyMemChunk.class);
        ChunkMetadata chunkMetadata = (ChunkMetadata)Mockito.mock(ChunkMetadata.class);
        MemChunkLoader memChunkLoader = new MemChunkLoader(new QueryContext(), chunk);
        try {
            memChunkLoader.loadChunk(chunkMetadata);
            Assert.fail();
        }
        catch (UnsupportedOperationException e) {
            Assert.assertNull((Object)e.getMessage());
        }
        ChunkMetadata chunkMetadata1 = (ChunkMetadata)Mockito.mock(ChunkMetadata.class);
        Mockito.when((Object)chunk.getTsBlock()).thenReturn((Object)this.buildInt32TsBlock());
        Mockito.when((Object)chunk.getChunkMetaData()).thenReturn((Object)chunkMetadata1);
        Mockito.when((Object)chunk.getPointReader()).thenReturn(null);
        Statistics statistics = (Statistics)Mockito.mock(Statistics.class);
        Mockito.when((Object)statistics.getCount()).thenReturn((Object)2L);
        Mockito.when((Object)chunkMetadata1.getStatistics()).thenReturn((Object)statistics);
        Mockito.when((Object)chunkMetadata1.getDataType()).thenReturn((Object)TSDataType.INT32);
        MemChunkReader chunkReader = (MemChunkReader)memChunkLoader.getChunkReader((IChunkMetadata)chunkMetadata1, null);
        List pageReaderList = chunkReader.loadPageReaderList();
        Assert.assertEquals((long)1L, (long)pageReaderList.size());
        MemPageReader pageReader = (MemPageReader)pageReaderList.get(0);
        pageReader.initTsBlockBuilder(Collections.singletonList(TSDataType.INT32));
        BatchData batchData = pageReader.getAllSatisfiedPageData();
        Assert.assertEquals((long)2L, (long)batchData.length());
        Assert.assertEquals((long)1L, (long)batchData.getTimeByIndex(0));
        Assert.assertEquals((long)2L, (long)batchData.getTimeByIndex(1));
        batchData = pageReader.getAllSatisfiedPageData(false);
        Assert.assertEquals((long)2L, (long)batchData.length());
        Assert.assertEquals((Object)BatchData.BatchDataType.DESC_READ, (Object)batchData.getBatchDataType());
        Assert.assertEquals((long)1L, (long)batchData.getTimeByIndex(0));
        Assert.assertEquals((long)2L, (long)batchData.getTimeByIndex(1));
        TsBlock tsBlock = pageReader.getAllSatisfiedData();
        Assert.assertEquals((long)2L, (long)tsBlock.getPositionCount());
        Assert.assertEquals((long)1L, (long)tsBlock.getTimeColumn().getLong(0));
        Assert.assertEquals((long)2L, (long)tsBlock.getTimeColumn().getLong(1));
        Assert.assertFalse((boolean)pageReader.isModified());
        pageReader.setLimitOffset(PaginationController.UNLIMITED_PAGINATION_CONTROLLER);
        pageReader.addRecordFilter(null);
        memChunkLoader.close();
    }

    private TsBlock buildInt32TsBlock() {
        TsBlockBuilder builder = new TsBlockBuilder(Collections.singletonList(TSDataType.INT32));
        builder.getTimeColumnBuilder().writeLong(1L);
        builder.getColumnBuilder(0).writeInt(1);
        builder.declarePosition();
        builder.getTimeColumnBuilder().writeLong(2L);
        builder.getColumnBuilder(0).writeInt(2);
        builder.declarePosition();
        return builder.build();
    }

    @Test
    public void testInt64MemChunkLoader() throws IOException {
        ReadOnlyMemChunk chunk = (ReadOnlyMemChunk)Mockito.mock(ReadOnlyMemChunk.class);
        ChunkMetadata chunkMetadata = (ChunkMetadata)Mockito.mock(ChunkMetadata.class);
        MemChunkLoader memChunkLoader = new MemChunkLoader(new QueryContext(), chunk);
        try {
            memChunkLoader.loadChunk(chunkMetadata);
            Assert.fail();
        }
        catch (UnsupportedOperationException e) {
            Assert.assertNull((Object)e.getMessage());
        }
        ChunkMetadata chunkMetadata1 = (ChunkMetadata)Mockito.mock(ChunkMetadata.class);
        Mockito.when((Object)chunk.getTsBlock()).thenReturn((Object)this.buildInt64TsBlock());
        Mockito.when((Object)chunk.getChunkMetaData()).thenReturn((Object)chunkMetadata1);
        Mockito.when((Object)chunk.getPointReader()).thenReturn(null);
        Statistics statistics = (Statistics)Mockito.mock(Statistics.class);
        Mockito.when((Object)statistics.getCount()).thenReturn((Object)2L);
        Mockito.when((Object)chunkMetadata1.getStatistics()).thenReturn((Object)statistics);
        Mockito.when((Object)chunkMetadata1.getDataType()).thenReturn((Object)TSDataType.INT64);
        MemChunkReader chunkReader = (MemChunkReader)memChunkLoader.getChunkReader((IChunkMetadata)chunkMetadata1, null);
        List pageReaderList = chunkReader.loadPageReaderList();
        Assert.assertEquals((long)1L, (long)pageReaderList.size());
        MemPageReader pageReader = (MemPageReader)pageReaderList.get(0);
        pageReader.initTsBlockBuilder(Collections.singletonList(TSDataType.INT64));
        BatchData batchData = pageReader.getAllSatisfiedPageData();
        Assert.assertEquals((long)2L, (long)batchData.length());
        Assert.assertEquals((long)1L, (long)batchData.getTimeByIndex(0));
        Assert.assertEquals((long)2L, (long)batchData.getTimeByIndex(1));
        batchData = pageReader.getAllSatisfiedPageData(false);
        Assert.assertEquals((long)2L, (long)batchData.length());
        Assert.assertEquals((Object)BatchData.BatchDataType.DESC_READ, (Object)batchData.getBatchDataType());
        Assert.assertEquals((long)1L, (long)batchData.getTimeByIndex(0));
        Assert.assertEquals((long)2L, (long)batchData.getTimeByIndex(1));
        TsBlock tsBlock = pageReader.getAllSatisfiedData();
        Assert.assertEquals((long)2L, (long)tsBlock.getPositionCount());
        Assert.assertEquals((long)1L, (long)tsBlock.getTimeColumn().getLong(0));
        Assert.assertEquals((long)2L, (long)tsBlock.getTimeColumn().getLong(1));
        Assert.assertFalse((boolean)pageReader.isModified());
        pageReader.setLimitOffset(PaginationController.UNLIMITED_PAGINATION_CONTROLLER);
        pageReader.addRecordFilter(null);
        memChunkLoader.close();
    }

    private TsBlock buildInt64TsBlock() {
        TsBlockBuilder builder = new TsBlockBuilder(Collections.singletonList(TSDataType.INT64));
        builder.getTimeColumnBuilder().writeLong(1L);
        builder.getColumnBuilder(0).writeLong(1L);
        builder.declarePosition();
        builder.getTimeColumnBuilder().writeLong(2L);
        builder.getColumnBuilder(0).writeLong(2L);
        builder.declarePosition();
        return builder.build();
    }

    @Test
    public void testFloatMemChunkLoader() throws IOException {
        ReadOnlyMemChunk chunk = (ReadOnlyMemChunk)Mockito.mock(ReadOnlyMemChunk.class);
        ChunkMetadata chunkMetadata = (ChunkMetadata)Mockito.mock(ChunkMetadata.class);
        MemChunkLoader memChunkLoader = new MemChunkLoader(new QueryContext(), chunk);
        try {
            memChunkLoader.loadChunk(chunkMetadata);
            Assert.fail();
        }
        catch (UnsupportedOperationException e) {
            Assert.assertNull((Object)e.getMessage());
        }
        ChunkMetadata chunkMetadata1 = (ChunkMetadata)Mockito.mock(ChunkMetadata.class);
        Mockito.when((Object)chunk.getTsBlock()).thenReturn((Object)this.buildFloatTsBlock());
        Mockito.when((Object)chunk.getChunkMetaData()).thenReturn((Object)chunkMetadata1);
        Mockito.when((Object)chunk.getPointReader()).thenReturn(null);
        Statistics statistics = (Statistics)Mockito.mock(Statistics.class);
        Mockito.when((Object)statistics.getCount()).thenReturn((Object)2L);
        Mockito.when((Object)chunkMetadata1.getStatistics()).thenReturn((Object)statistics);
        Mockito.when((Object)chunkMetadata1.getDataType()).thenReturn((Object)TSDataType.FLOAT);
        MemChunkReader chunkReader = (MemChunkReader)memChunkLoader.getChunkReader((IChunkMetadata)chunkMetadata1, null);
        List pageReaderList = chunkReader.loadPageReaderList();
        Assert.assertEquals((long)1L, (long)pageReaderList.size());
        MemPageReader pageReader = (MemPageReader)pageReaderList.get(0);
        pageReader.initTsBlockBuilder(Collections.singletonList(TSDataType.FLOAT));
        BatchData batchData = pageReader.getAllSatisfiedPageData();
        Assert.assertEquals((long)2L, (long)batchData.length());
        Assert.assertEquals((long)1L, (long)batchData.getTimeByIndex(0));
        Assert.assertEquals((long)2L, (long)batchData.getTimeByIndex(1));
        batchData = pageReader.getAllSatisfiedPageData(false);
        Assert.assertEquals((long)2L, (long)batchData.length());
        Assert.assertEquals((Object)BatchData.BatchDataType.DESC_READ, (Object)batchData.getBatchDataType());
        Assert.assertEquals((long)1L, (long)batchData.getTimeByIndex(0));
        Assert.assertEquals((long)2L, (long)batchData.getTimeByIndex(1));
        TsBlock tsBlock = pageReader.getAllSatisfiedData();
        Assert.assertEquals((long)2L, (long)tsBlock.getPositionCount());
        Assert.assertEquals((long)1L, (long)tsBlock.getTimeColumn().getLong(0));
        Assert.assertEquals((long)2L, (long)tsBlock.getTimeColumn().getLong(1));
        Assert.assertFalse((boolean)pageReader.isModified());
        pageReader.setLimitOffset(PaginationController.UNLIMITED_PAGINATION_CONTROLLER);
        pageReader.addRecordFilter(null);
        memChunkLoader.close();
    }

    private TsBlock buildFloatTsBlock() {
        TsBlockBuilder builder = new TsBlockBuilder(Collections.singletonList(TSDataType.FLOAT));
        builder.getTimeColumnBuilder().writeLong(1L);
        builder.getColumnBuilder(0).writeFloat(1.1f);
        builder.declarePosition();
        builder.getTimeColumnBuilder().writeLong(2L);
        builder.getColumnBuilder(0).writeFloat(2.1f);
        builder.declarePosition();
        return builder.build();
    }

    @Test
    public void testDoubleMemChunkLoader() throws IOException {
        ReadOnlyMemChunk chunk = (ReadOnlyMemChunk)Mockito.mock(ReadOnlyMemChunk.class);
        ChunkMetadata chunkMetadata = (ChunkMetadata)Mockito.mock(ChunkMetadata.class);
        MemChunkLoader memChunkLoader = new MemChunkLoader(new QueryContext(), chunk);
        try {
            memChunkLoader.loadChunk(chunkMetadata);
            Assert.fail();
        }
        catch (UnsupportedOperationException e) {
            Assert.assertNull((Object)e.getMessage());
        }
        ChunkMetadata chunkMetadata1 = (ChunkMetadata)Mockito.mock(ChunkMetadata.class);
        Mockito.when((Object)chunk.getTsBlock()).thenReturn((Object)this.buildDoubleTsBlock());
        Mockito.when((Object)chunk.getChunkMetaData()).thenReturn((Object)chunkMetadata1);
        Mockito.when((Object)chunk.getPointReader()).thenReturn(null);
        Statistics statistics = (Statistics)Mockito.mock(Statistics.class);
        Mockito.when((Object)statistics.getCount()).thenReturn((Object)2L);
        Mockito.when((Object)chunkMetadata1.getStatistics()).thenReturn((Object)statistics);
        Mockito.when((Object)chunkMetadata1.getDataType()).thenReturn((Object)TSDataType.DOUBLE);
        MemChunkReader chunkReader = (MemChunkReader)memChunkLoader.getChunkReader((IChunkMetadata)chunkMetadata1, null);
        List pageReaderList = chunkReader.loadPageReaderList();
        Assert.assertEquals((long)1L, (long)pageReaderList.size());
        MemPageReader pageReader = (MemPageReader)pageReaderList.get(0);
        pageReader.initTsBlockBuilder(Collections.singletonList(TSDataType.DOUBLE));
        BatchData batchData = pageReader.getAllSatisfiedPageData();
        Assert.assertEquals((long)2L, (long)batchData.length());
        Assert.assertEquals((long)1L, (long)batchData.getTimeByIndex(0));
        Assert.assertEquals((long)2L, (long)batchData.getTimeByIndex(1));
        batchData = pageReader.getAllSatisfiedPageData(false);
        Assert.assertEquals((long)2L, (long)batchData.length());
        Assert.assertEquals((Object)BatchData.BatchDataType.DESC_READ, (Object)batchData.getBatchDataType());
        Assert.assertEquals((long)1L, (long)batchData.getTimeByIndex(0));
        Assert.assertEquals((long)2L, (long)batchData.getTimeByIndex(1));
        TsBlock tsBlock = pageReader.getAllSatisfiedData();
        Assert.assertEquals((long)2L, (long)tsBlock.getPositionCount());
        Assert.assertEquals((long)1L, (long)tsBlock.getTimeColumn().getLong(0));
        Assert.assertEquals((long)2L, (long)tsBlock.getTimeColumn().getLong(1));
        Assert.assertFalse((boolean)pageReader.isModified());
        pageReader.setLimitOffset(PaginationController.UNLIMITED_PAGINATION_CONTROLLER);
        pageReader.addRecordFilter(null);
        memChunkLoader.close();
    }

    private TsBlock buildDoubleTsBlock() {
        TsBlockBuilder builder = new TsBlockBuilder(Collections.singletonList(TSDataType.DOUBLE));
        builder.getTimeColumnBuilder().writeLong(1L);
        builder.getColumnBuilder(0).writeDouble(1.1);
        builder.declarePosition();
        builder.getTimeColumnBuilder().writeLong(2L);
        builder.getColumnBuilder(0).writeDouble(2.1);
        builder.declarePosition();
        return builder.build();
    }

    @Test
    public void testTextMemChunkLoader() throws IOException {
        ReadOnlyMemChunk chunk = (ReadOnlyMemChunk)Mockito.mock(ReadOnlyMemChunk.class);
        ChunkMetadata chunkMetadata = (ChunkMetadata)Mockito.mock(ChunkMetadata.class);
        MemChunkLoader memChunkLoader = new MemChunkLoader(new QueryContext(), chunk);
        try {
            memChunkLoader.loadChunk(chunkMetadata);
            Assert.fail();
        }
        catch (UnsupportedOperationException e) {
            Assert.assertNull((Object)e.getMessage());
        }
        ChunkMetadata chunkMetadata1 = (ChunkMetadata)Mockito.mock(ChunkMetadata.class);
        Mockito.when((Object)chunk.getTsBlock()).thenReturn((Object)this.buildTextTsBlock());
        Mockito.when((Object)chunk.getChunkMetaData()).thenReturn((Object)chunkMetadata1);
        Mockito.when((Object)chunk.getPointReader()).thenReturn(null);
        Statistics statistics = (Statistics)Mockito.mock(Statistics.class);
        Mockito.when((Object)statistics.getCount()).thenReturn((Object)2L);
        Mockito.when((Object)chunkMetadata1.getStatistics()).thenReturn((Object)statistics);
        Mockito.when((Object)chunkMetadata1.getDataType()).thenReturn((Object)TSDataType.TEXT);
        MemChunkReader chunkReader = (MemChunkReader)memChunkLoader.getChunkReader((IChunkMetadata)chunkMetadata1, null);
        List pageReaderList = chunkReader.loadPageReaderList();
        Assert.assertEquals((long)1L, (long)pageReaderList.size());
        MemPageReader pageReader = (MemPageReader)pageReaderList.get(0);
        pageReader.initTsBlockBuilder(Collections.singletonList(TSDataType.TEXT));
        BatchData batchData = pageReader.getAllSatisfiedPageData();
        Assert.assertEquals((long)2L, (long)batchData.length());
        Assert.assertEquals((long)1L, (long)batchData.getTimeByIndex(0));
        Assert.assertEquals((long)2L, (long)batchData.getTimeByIndex(1));
        batchData = pageReader.getAllSatisfiedPageData(false);
        Assert.assertEquals((long)2L, (long)batchData.length());
        Assert.assertEquals((Object)BatchData.BatchDataType.DESC_READ, (Object)batchData.getBatchDataType());
        Assert.assertEquals((long)1L, (long)batchData.getTimeByIndex(0));
        Assert.assertEquals((long)2L, (long)batchData.getTimeByIndex(1));
        TsBlock tsBlock = pageReader.getAllSatisfiedData();
        Assert.assertEquals((long)2L, (long)tsBlock.getPositionCount());
        Assert.assertEquals((long)1L, (long)tsBlock.getTimeColumn().getLong(0));
        Assert.assertEquals((long)2L, (long)tsBlock.getTimeColumn().getLong(1));
        Assert.assertFalse((boolean)pageReader.isModified());
        pageReader.setLimitOffset(PaginationController.UNLIMITED_PAGINATION_CONTROLLER);
        pageReader.addRecordFilter(null);
        memChunkLoader.close();
    }

    private TsBlock buildTextTsBlock() {
        TsBlockBuilder builder = new TsBlockBuilder(Collections.singletonList(TSDataType.TEXT));
        builder.getTimeColumnBuilder().writeLong(1L);
        builder.getColumnBuilder(0).writeBinary(new Binary(BINARY_STR, TSFileConfig.STRING_CHARSET));
        builder.declarePosition();
        builder.getTimeColumnBuilder().writeLong(2L);
        builder.getColumnBuilder(0).writeBinary(new Binary(BINARY_STR, TSFileConfig.STRING_CHARSET));
        builder.declarePosition();
        return builder.build();
    }
}

