/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.storageengine.dataregion.memtable.AlignedReadOnlyMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.MemAlignedChunkLoader;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.MemAlignedChunkReader;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.MemAlignedPageReader;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.reader.series.PaginationController;
import org.apache.iotdb.tsfile.utils.Binary;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class MemAlignedChunkLoaderTest {
    private static final String BINARY_STR = "ty love zm";

    @Test
    public void testMemAlignedChunkLoader() throws IOException {
        AlignedReadOnlyMemChunk chunk = (AlignedReadOnlyMemChunk)Mockito.mock(AlignedReadOnlyMemChunk.class);
        ChunkMetadata chunkMetadata = (ChunkMetadata)Mockito.mock(ChunkMetadata.class);
        MemAlignedChunkLoader memAlignedChunkLoader = new MemAlignedChunkLoader(new QueryContext(), chunk);
        try {
            memAlignedChunkLoader.loadChunk(chunkMetadata);
            Assert.fail();
        }
        catch (UnsupportedOperationException e) {
            Assert.assertNull((Object)e.getMessage());
        }
        AlignedChunkMetadata chunkMetadata1 = (AlignedChunkMetadata)Mockito.mock(AlignedChunkMetadata.class);
        Mockito.when((Object)chunk.getTsBlock()).thenReturn((Object)this.buildTsBlock());
        Mockito.when((Object)chunk.getChunkMetaData()).thenReturn((Object)chunkMetadata1);
        Statistics statistics1 = (Statistics)Mockito.mock(Statistics.class);
        Mockito.when((Object)statistics1.hasNullValue(2L)).thenReturn((Object)true);
        Statistics statistics2 = (Statistics)Mockito.mock(Statistics.class);
        Mockito.when((Object)statistics2.hasNullValue(2L)).thenReturn((Object)true);
        Statistics statistics3 = (Statistics)Mockito.mock(Statistics.class);
        Mockito.when((Object)statistics3.hasNullValue(2L)).thenReturn((Object)true);
        Statistics statistics4 = (Statistics)Mockito.mock(Statistics.class);
        Mockito.when((Object)statistics4.hasNullValue(2L)).thenReturn((Object)true);
        Statistics statistics5 = (Statistics)Mockito.mock(Statistics.class);
        Mockito.when((Object)statistics5.hasNullValue(2L)).thenReturn((Object)true);
        Statistics statistics6 = (Statistics)Mockito.mock(Statistics.class);
        Mockito.when((Object)statistics6.hasNullValue(2L)).thenReturn((Object)true);
        Statistics timeStatistics = (Statistics)Mockito.mock(Statistics.class);
        Mockito.when((Object)timeStatistics.getCount()).thenReturn((Object)2L);
        Mockito.when((Object)chunkMetadata1.getStatistics()).thenReturn((Object)timeStatistics);
        Mockito.when((Object)chunkMetadata1.getTimeStatistics()).thenReturn((Object)timeStatistics);
        Mockito.when((Object)chunkMetadata1.getMeasurementStatistics(0)).thenReturn(Optional.of(statistics1));
        MemAlignedChunkReader chunkReader = (MemAlignedChunkReader)memAlignedChunkLoader.getChunkReader((IChunkMetadata)chunkMetadata1, null);
        try {
            chunkReader.hasNextSatisfiedPage();
            Assert.fail();
        }
        catch (IOException e) {
            Assert.assertEquals((Object)"mem chunk reader does not support this method", (Object)e.getMessage());
        }
        try {
            chunkReader.nextPageData();
            Assert.fail();
        }
        catch (IOException e) {
            Assert.assertEquals((Object)"mem chunk reader does not support this method", (Object)e.getMessage());
        }
        List pageReaderList = chunkReader.loadPageReaderList();
        Assert.assertEquals((long)1L, (long)pageReaderList.size());
        MemAlignedPageReader pageReader = (MemAlignedPageReader)pageReaderList.get(0);
        pageReader.initTsBlockBuilder(Arrays.asList(TSDataType.BOOLEAN, TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.DOUBLE, TSDataType.TEXT));
        BatchData batchData = pageReader.getAllSatisfiedPageData();
        Assert.assertEquals((long)2L, (long)batchData.length());
        Assert.assertEquals((long)1L, (long)batchData.getTimeByIndex(0));
        Assert.assertEquals((long)2L, (long)batchData.getTimeByIndex(1));
        batchData = pageReader.getAllSatisfiedPageData(false);
        Assert.assertEquals((long)2L, (long)batchData.length());
        Assert.assertEquals((Object)BatchData.BatchDataType.DESC_READ, (Object)batchData.getBatchDataType());
        Assert.assertEquals((long)1L, (long)batchData.getTimeByIndex(0));
        Assert.assertEquals((long)2L, (long)batchData.getTimeByIndex(1));
        TsBlock tsBlock = pageReader.getAllSatisfiedData();
        Assert.assertEquals((long)2L, (long)tsBlock.getPositionCount());
        Assert.assertEquals((long)1L, (long)tsBlock.getTimeColumn().getLong(0));
        Assert.assertEquals((long)2L, (long)tsBlock.getTimeColumn().getLong(1));
        Assert.assertEquals((Object)timeStatistics, (Object)pageReader.getStatistics());
        Assert.assertEquals((Object)statistics1, pageReader.getMeasurementStatistics(0).orElse(null));
        Assert.assertEquals((Object)timeStatistics, (Object)pageReader.getTimeStatistics());
        Assert.assertFalse((boolean)pageReader.isModified());
        pageReader.setLimitOffset(PaginationController.UNLIMITED_PAGINATION_CONTROLLER);
        pageReader.addRecordFilter(null);
        memAlignedChunkLoader.close();
    }

    private TsBlock buildTsBlock() {
        TsBlockBuilder builder = new TsBlockBuilder(Arrays.asList(TSDataType.BOOLEAN, TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.DOUBLE, TSDataType.TEXT));
        builder.getTimeColumnBuilder().writeLong(1L);
        builder.getColumnBuilder(0).writeBoolean(true);
        builder.getColumnBuilder(1).writeInt(1);
        builder.getColumnBuilder(2).writeLong(1L);
        builder.getColumnBuilder(3).writeFloat(1.1f);
        builder.getColumnBuilder(4).appendNull();
        builder.getColumnBuilder(5).writeBinary(new Binary(BINARY_STR, TSFileConfig.STRING_CHARSET));
        builder.declarePosition();
        builder.getTimeColumnBuilder().writeLong(2L);
        builder.getColumnBuilder(0).appendNull();
        builder.getColumnBuilder(1).appendNull();
        builder.getColumnBuilder(2).appendNull();
        builder.getColumnBuilder(3).appendNull();
        builder.getColumnBuilder(4).writeDouble(3.14);
        builder.getColumnBuilder(5).appendNull();
        builder.declarePosition();
        return builder.build();
    }
}

