/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.MemAlignedPageReader;
import org.apache.iotdb.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.IntegerStatistics;
import org.apache.iotdb.tsfile.file.metadata.statistics.TimeStatistics;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.TimeFilterApi;
import org.apache.iotdb.tsfile.read.filter.factory.ValueFilterApi;
import org.apache.iotdb.tsfile.read.filter.operator.TimeFilterOperators;
import org.apache.iotdb.tsfile.read.reader.series.PaginationController;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class AlignedMemPageReaderTest {
    private static final TsBlock tsBlock1;
    private static final AlignedChunkMetadata chunkMetadata1;
    private static final TsBlock tsBlock2;
    private static final AlignedChunkMetadata chunkMetadata2;

    private MemAlignedPageReader generateAlignedPageReader() {
        MemAlignedPageReader alignedPageReader = new MemAlignedPageReader(tsBlock1, chunkMetadata1, null);
        alignedPageReader.initTsBlockBuilder(Arrays.asList(TSDataType.INT32, TSDataType.INT32));
        return alignedPageReader;
    }

    private MemAlignedPageReader generateSingleColumnAlignedPageReader() {
        MemAlignedPageReader alignedPageReader = new MemAlignedPageReader(tsBlock2, chunkMetadata2, null);
        alignedPageReader.initTsBlockBuilder(Collections.singletonList(TSDataType.INT32));
        return alignedPageReader;
    }

    @Test
    public void testNullFilter() {
        MemAlignedPageReader alignedPageReader1 = this.generateAlignedPageReader();
        TsBlock tsBlock1 = alignedPageReader1.getAllSatisfiedData();
        Assert.assertEquals((long)100L, (long)tsBlock1.getPositionCount());
        MemAlignedPageReader alignedPageReader2 = this.generateSingleColumnAlignedPageReader();
        TsBlock tsBlock2 = alignedPageReader2.getAllSatisfiedData();
        Assert.assertEquals((long)80L, (long)tsBlock2.getPositionCount());
    }

    @Test
    public void testNullFilterWithLimitOffset() {
        MemAlignedPageReader alignedPageReader1 = this.generateAlignedPageReader();
        alignedPageReader1.setLimitOffset(new PaginationController(10L, 10L));
        TsBlock tsBlock1 = alignedPageReader1.getAllSatisfiedData();
        Assert.assertEquals((long)10L, (long)tsBlock1.getPositionCount());
        Assert.assertEquals((long)10L, (long)tsBlock1.getTimeByIndex(0));
        Assert.assertEquals((long)19L, (long)tsBlock1.getTimeByIndex(9));
        MemAlignedPageReader alignedPageReader2 = this.generateSingleColumnAlignedPageReader();
        alignedPageReader2.setLimitOffset(new PaginationController(10L, 10L));
        TsBlock tsBlock2 = alignedPageReader2.getAllSatisfiedData();
        Assert.assertEquals((long)10L, (long)tsBlock2.getPositionCount());
        Assert.assertEquals((long)20L, (long)tsBlock2.getTimeByIndex(0));
        Assert.assertEquals((long)29L, (long)tsBlock2.getTimeByIndex(9));
    }

    @Test
    public void testGlobalTimeFilterAllSatisfy() {
        TimeFilterOperators.TimeGtEq globalTimeFilter = TimeFilterApi.gtEq((long)0L);
        MemAlignedPageReader alignedPageReader1 = this.generateAlignedPageReader();
        alignedPageReader1.addRecordFilter((Filter)globalTimeFilter);
        alignedPageReader1.addRecordFilter((Filter)ValueFilterApi.gtEq((Comparable)Integer.valueOf(50)));
        TsBlock tsBlock1 = alignedPageReader1.getAllSatisfiedData();
        Assert.assertEquals((long)50L, (long)tsBlock1.getPositionCount());
        MemAlignedPageReader alignedPageReader2 = this.generateSingleColumnAlignedPageReader();
        alignedPageReader2.addRecordFilter((Filter)globalTimeFilter);
        alignedPageReader2.addRecordFilter((Filter)ValueFilterApi.gtEq((Comparable)Integer.valueOf(50)));
        TsBlock tsBlock2 = alignedPageReader2.getAllSatisfiedData();
        Assert.assertEquals((long)40L, (long)tsBlock2.getPositionCount());
    }

    @Test
    public void testGlobalTimeFilterAllSatisfyWithLimitOffset() {
        TimeFilterOperators.TimeGtEq globalTimeFilter = TimeFilterApi.gtEq((long)0L);
        MemAlignedPageReader alignedPageReader1 = this.generateAlignedPageReader();
        alignedPageReader1.addRecordFilter((Filter)globalTimeFilter);
        alignedPageReader1.addRecordFilter((Filter)ValueFilterApi.gtEq((Comparable)Integer.valueOf(50)));
        alignedPageReader1.setLimitOffset(new PaginationController(10L, 10L));
        TsBlock tsBlock1 = alignedPageReader1.getAllSatisfiedData();
        Assert.assertEquals((long)10L, (long)tsBlock1.getPositionCount());
        Assert.assertEquals((long)60L, (long)tsBlock1.getTimeByIndex(0));
        Assert.assertEquals((long)69L, (long)tsBlock1.getTimeByIndex(9));
        MemAlignedPageReader alignedPageReader2 = this.generateSingleColumnAlignedPageReader();
        alignedPageReader2.addRecordFilter((Filter)globalTimeFilter);
        alignedPageReader2.addRecordFilter((Filter)ValueFilterApi.gtEq((Comparable)Integer.valueOf(50)));
        alignedPageReader2.setLimitOffset(new PaginationController(10L, 10L));
        TsBlock tsBlock2 = alignedPageReader2.getAllSatisfiedData();
        Assert.assertEquals((long)10L, (long)tsBlock2.getPositionCount());
        Assert.assertEquals((long)60L, (long)tsBlock2.getTimeByIndex(0));
        Assert.assertEquals((long)69L, (long)tsBlock2.getTimeByIndex(9));
    }

    @Test
    public void testPushDownFilterAllSatisfy() {
        TimeFilterOperators.TimeGtEq globalTimeFilter = TimeFilterApi.gtEq((long)50L);
        MemAlignedPageReader alignedPageReader1 = this.generateAlignedPageReader();
        alignedPageReader1.addRecordFilter((Filter)globalTimeFilter);
        alignedPageReader1.addRecordFilter((Filter)ValueFilterApi.gtEq((Comparable)Integer.valueOf(0)));
        TsBlock tsBlock1 = alignedPageReader1.getAllSatisfiedData();
        Assert.assertEquals((long)50L, (long)tsBlock1.getPositionCount());
        MemAlignedPageReader alignedPageReader2 = this.generateSingleColumnAlignedPageReader();
        alignedPageReader2.addRecordFilter((Filter)globalTimeFilter);
        alignedPageReader2.addRecordFilter((Filter)ValueFilterApi.gtEq((Comparable)Integer.valueOf(0)));
        TsBlock tsBlock2 = alignedPageReader2.getAllSatisfiedData();
        Assert.assertEquals((long)40L, (long)tsBlock2.getPositionCount());
    }

    @Test
    public void testPushDownFilterAllSatisfyWithLimitOffset() {
        TimeFilterOperators.TimeGtEq globalTimeFilter = TimeFilterApi.gtEq((long)50L);
        MemAlignedPageReader alignedPageReader1 = this.generateAlignedPageReader();
        alignedPageReader1.addRecordFilter((Filter)globalTimeFilter);
        alignedPageReader1.addRecordFilter((Filter)ValueFilterApi.gtEq((Comparable)Integer.valueOf(0)));
        alignedPageReader1.setLimitOffset(new PaginationController(10L, 10L));
        TsBlock tsBlock1 = alignedPageReader1.getAllSatisfiedData();
        Assert.assertEquals((long)10L, (long)tsBlock1.getPositionCount());
        Assert.assertEquals((long)60L, (long)tsBlock1.getTimeByIndex(0));
        Assert.assertEquals((long)69L, (long)tsBlock1.getTimeByIndex(9));
        MemAlignedPageReader alignedPageReader2 = this.generateSingleColumnAlignedPageReader();
        alignedPageReader2.addRecordFilter((Filter)globalTimeFilter);
        alignedPageReader2.addRecordFilter((Filter)ValueFilterApi.gtEq((Comparable)Integer.valueOf(0)));
        alignedPageReader2.setLimitOffset(new PaginationController(10L, 10L));
        TsBlock tsBlock2 = alignedPageReader2.getAllSatisfiedData();
        Assert.assertEquals((long)10L, (long)tsBlock2.getPositionCount());
        Assert.assertEquals((long)60L, (long)tsBlock2.getTimeByIndex(0));
        Assert.assertEquals((long)69L, (long)tsBlock2.getTimeByIndex(9));
    }

    @Test
    public void testFilter() {
        TimeFilterOperators.TimeGtEq globalTimeFilter = TimeFilterApi.gtEq((long)30L);
        MemAlignedPageReader alignedPageReader1 = this.generateAlignedPageReader();
        alignedPageReader1.addRecordFilter((Filter)globalTimeFilter);
        alignedPageReader1.addRecordFilter((Filter)ValueFilterApi.lt((Comparable)Integer.valueOf(80)));
        TsBlock tsBlock1 = alignedPageReader1.getAllSatisfiedData();
        Assert.assertEquals((long)50L, (long)tsBlock1.getPositionCount());
        MemAlignedPageReader alignedPageReader2 = this.generateSingleColumnAlignedPageReader();
        alignedPageReader2.addRecordFilter((Filter)globalTimeFilter);
        alignedPageReader2.addRecordFilter((Filter)ValueFilterApi.lt((Comparable)Integer.valueOf(80)));
        TsBlock tsBlock2 = alignedPageReader2.getAllSatisfiedData();
        Assert.assertEquals((long)50L, (long)tsBlock2.getPositionCount());
    }

    @Test
    public void testFilterWithLimitOffset() {
        TimeFilterOperators.TimeGtEq globalTimeFilter = TimeFilterApi.gtEq((long)50L);
        MemAlignedPageReader alignedPageReader1 = this.generateAlignedPageReader();
        alignedPageReader1.addRecordFilter((Filter)globalTimeFilter);
        alignedPageReader1.addRecordFilter((Filter)ValueFilterApi.lt((Comparable)Integer.valueOf(80)));
        alignedPageReader1.setLimitOffset(new PaginationController(10L, 10L));
        TsBlock tsBlock1 = alignedPageReader1.getAllSatisfiedData();
        Assert.assertEquals((long)10L, (long)tsBlock1.getPositionCount());
        Assert.assertEquals((long)60L, (long)tsBlock1.getTimeByIndex(0));
        Assert.assertEquals((long)69L, (long)tsBlock1.getTimeByIndex(9));
        MemAlignedPageReader alignedPageReader2 = this.generateSingleColumnAlignedPageReader();
        alignedPageReader2.addRecordFilter((Filter)globalTimeFilter);
        alignedPageReader2.addRecordFilter((Filter)ValueFilterApi.lt((Comparable)Integer.valueOf(80)));
        alignedPageReader2.setLimitOffset(new PaginationController(10L, 10L));
        TsBlock tsBlock2 = alignedPageReader2.getAllSatisfiedData();
        Assert.assertEquals((long)10L, (long)tsBlock2.getPositionCount());
        Assert.assertEquals((long)60L, (long)tsBlock2.getTimeByIndex(0));
        Assert.assertEquals((long)69L, (long)tsBlock2.getTimeByIndex(9));
    }

    static {
        chunkMetadata1 = (AlignedChunkMetadata)Mockito.mock(AlignedChunkMetadata.class);
        chunkMetadata2 = (AlignedChunkMetadata)Mockito.mock(AlignedChunkMetadata.class);
        TsBlockBuilder tsBlockBuilder1 = new TsBlockBuilder(Arrays.asList(TSDataType.INT32, TSDataType.INT32));
        TsBlockBuilder tsBlockBuilder2 = new TsBlockBuilder(Collections.singletonList(TSDataType.INT32));
        TimeStatistics timeStatistics = new TimeStatistics();
        IntegerStatistics valueStatistics1 = new IntegerStatistics();
        IntegerStatistics valueStatistics2 = new IntegerStatistics();
        for (int i = 0; i < 100; ++i) {
            tsBlockBuilder1.getTimeColumnBuilder().writeLong((long)i);
            tsBlockBuilder2.getTimeColumnBuilder().writeLong((long)i);
            timeStatistics.update((long)i);
            tsBlockBuilder1.getValueColumnBuilders()[0].writeInt(i);
            valueStatistics1.update((long)i, i);
            if (i >= 10 && i < 90) {
                tsBlockBuilder1.getValueColumnBuilders()[1].writeInt(i);
                tsBlockBuilder2.getValueColumnBuilders()[0].writeInt(i);
                valueStatistics2.update((long)i, i);
            } else {
                tsBlockBuilder1.getValueColumnBuilders()[1].appendNull();
                tsBlockBuilder2.getValueColumnBuilders()[0].appendNull();
            }
            tsBlockBuilder1.declarePosition();
            tsBlockBuilder2.declarePosition();
        }
        tsBlock1 = tsBlockBuilder1.build();
        Mockito.when((Object)chunkMetadata1.getTimeStatistics()).thenReturn((Object)timeStatistics);
        Mockito.when((Object)chunkMetadata1.getMeasurementStatistics(0)).thenReturn(Optional.of(valueStatistics1));
        Mockito.when((Object)chunkMetadata1.getMeasurementStatistics(1)).thenReturn(Optional.of(valueStatistics2));
        tsBlock2 = tsBlockBuilder2.build();
        Mockito.when((Object)chunkMetadata2.getTimeStatistics()).thenReturn((Object)timeStatistics);
        Mockito.when((Object)chunkMetadata2.getMeasurementStatistics(0)).thenReturn(Optional.of(valueStatistics2));
    }
}

