/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.control;

import java.io.File;
import java.io.IOException;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.dataregion.read.control.FileReaderManager;
import org.apache.iotdb.db.storageengine.dataregion.read.control.QueryFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FileReaderManagerTest {
    private static final int MAX_FILE_SIZE = 10;
    private IoTDBConfig dbConfig = IoTDBDescriptor.getInstance().getConfig();
    private long cacheFileReaderClearPeriod;

    @Before
    public void setUp() {
        this.cacheFileReaderClearPeriod = this.dbConfig.getCacheFileReaderClearPeriod();
        this.dbConfig.setCacheFileReaderClearPeriod(3000L);
    }

    @After
    public void tearDown() {
        this.dbConfig.setCacheFileReaderClearPeriod(this.cacheFileReaderClearPeriod);
    }

    @Test
    public void test() throws IOException, InterruptedException {
        int i;
        String filePath = TestConstant.BASE_OUTPUT_PATH.concat("test.file");
        FileReaderManager manager = FileReaderManager.getInstance();
        QueryFileManager testManager = new QueryFileManager();
        TsFileResource[] tsFileResources = new TsFileResource[11];
        for (int i2 = 1; i2 <= 10; ++i2) {
            File file = SystemFileFactory.INSTANCE.getFile(filePath + i2);
            file.createNewFile();
            tsFileResources[i2] = new TsFileResource(file);
        }
        Thread t1 = new Thread(() -> {
            try {
                TsFileResource tsFile;
                int i;
                testManager.addQueryId(1L);
                for (i = 1; i <= 6; ++i) {
                    tsFile = tsFileResources[i];
                    testManager.addFilePathToMap(1L, tsFile, false);
                    manager.get(tsFile.getTsFilePath(), false);
                    Assert.assertTrue((boolean)manager.contains(tsFile, false));
                }
                for (i = 1; i <= 6; ++i) {
                    tsFile = tsFileResources[i];
                    manager.decreaseFileReaderReference(tsFile, false);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        t1.start();
        Thread t2 = new Thread(() -> {
            try {
                TsFileResource tsFile;
                int i;
                testManager.addQueryId(2L);
                for (i = 4; i <= 10; ++i) {
                    tsFile = tsFileResources[i];
                    testManager.addFilePathToMap(2L, tsFile, false);
                    manager.get(tsFile.getTsFilePath(), false);
                    Assert.assertTrue((boolean)manager.contains(tsFile, false));
                }
                for (i = 4; i <= 10; ++i) {
                    tsFile = tsFileResources[i];
                    manager.decreaseFileReaderReference(tsFile, false);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        t2.start();
        t1.join();
        t2.join();
        Thread.sleep(1000L);
        for (i = 1; i <= 10; ++i) {
            TsFileResource tsFile = new TsFileResource(SystemFileFactory.INSTANCE.getFile(filePath + i));
            Assert.assertFalse((boolean)manager.contains(tsFile, false));
        }
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        for (i = 1; i < 10; ++i) {
            boolean result;
            File file = SystemFileFactory.INSTANCE.getFile(filePath + i);
            boolean bl = result = !file.exists() || file.delete();
            if (result) continue;
            Assert.fail();
        }
    }
}

