/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.modification.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.storageengine.dataregion.modification.Deletion;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.storageengine.dataregion.modification.io.LocalTextModificationAccessor;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;

public class LocalTextModificationAccessorTest {
    private static Modification[] modifications = new Modification[]{new Deletion(new PartialPath(new String[]{"d1", "s1"}), 1L, 1L), new Deletion(new PartialPath(new String[]{"d1", "s2"}), 2L, 2L), new Deletion(new PartialPath(new String[]{"d1", "s3"}), 3L, 3L), new Deletion(new PartialPath(new String[]{"d1", "s4"}), 4L, 4L)};

    @AfterClass
    public static void tearDown() {
        modifications = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void writeMeetException() throws IOException {
        String tempFileName = TestConstant.BASE_OUTPUT_PATH.concat("mod.temp");
        long length = 0L;
        LocalTextModificationAccessor accessor = null;
        try {
            int i;
            accessor = new LocalTextModificationAccessor(tempFileName);
            for (i = 0; i < 2; ++i) {
                accessor.write(modifications[i]);
            }
            length = new File(tempFileName).length();
            accessor.writeMeetException(modifications[2]);
            for (i = 2; i < 4; ++i) {
                accessor.write(modifications[i]);
            }
            List modificationList = (List)accessor.read();
            Assert.assertEquals((long)4L, (long)modificationList.size());
            for (int i2 = 0; i2 < 4; ++i2) {
                Assert.assertEquals((Object)modifications[i2], modificationList.get(i2));
            }
        }
        catch (IOException e) {
            accessor.truncate(length);
        }
        finally {
            if (accessor != null) {
                accessor.close();
            }
            new File(tempFileName).delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void readMyWrite() {
        String tempFileName = TestConstant.BASE_OUTPUT_PATH.concat("mod.temp");
        try (LocalTextModificationAccessor accessor = new LocalTextModificationAccessor(tempFileName);){
            int i;
            for (int i2 = 0; i2 < 2; ++i2) {
                accessor.write(modifications[i2]);
            }
            List modificationList = (List)accessor.read();
            for (i = 0; i < 2; ++i) {
                Assert.assertEquals((Object)modifications[i], modificationList.get(i));
            }
            for (i = 2; i < 4; ++i) {
                accessor.write(modifications[i]);
            }
            modificationList = (List)accessor.read();
            for (i = 0; i < 4; ++i) {
                Assert.assertEquals((Object)modifications[i], modificationList.get(i));
            }
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        finally {
            new File(tempFileName).delete();
        }
    }

    @Test
    public void readNull() {
        String tempFileName = TestConstant.BASE_OUTPUT_PATH.concat("mod.temp");
        try (LocalTextModificationAccessor accessor = new LocalTextModificationAccessor(tempFileName);){
            new File(tempFileName).delete();
            Collection modifications = accessor.read();
            Assert.assertEquals(new ArrayList(), (Object)modifications);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void readMeetError() {
        String tempFileName = TestConstant.BASE_OUTPUT_PATH.concat("mod.temp");
        File file = new File(tempFileName);
        if (file.exists()) {
            file.delete();
        }
        try (LocalTextModificationAccessor accessor = new LocalTextModificationAccessor(tempFileName);){
            int i;
            for (int i2 = 0; i2 < 4; ++i2) {
                accessor.write(modifications[i2]);
            }
            List modificationList = (List)accessor.read();
            for (i = 0; i < 4; ++i) {
                Assert.assertEquals((Object)modifications[i], modificationList.get(i));
            }
            accessor.writeInComplete(modifications[0]);
            modificationList = (List)accessor.read();
            Assert.assertEquals((long)4L, (long)modificationList.size());
            for (i = 0; i < 4; ++i) {
                System.out.println(modificationList);
                Assert.assertEquals((Object)modifications[i], modificationList.get(i));
            }
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        finally {
            file.delete();
        }
    }
}

