/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.modification;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.recover.CompactionRecoverManager;
import org.apache.iotdb.db.storageengine.dataregion.modification.Deletion;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModificationFile;
import org.apache.iotdb.db.storageengine.dataregion.modification.io.LocalTextModificationAccessor;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.junit.Assert;
import org.junit.Test;

public class ModificationFileTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void readMyWrite() {
        String tempFileName = TestConstant.BASE_OUTPUT_PATH.concat("mod.temp");
        Modification[] modifications = new Modification[]{new Deletion(new PartialPath(new String[]{"d1", "s1"}), 1L, 1L), new Deletion(new PartialPath(new String[]{"d1", "s2"}), 2L, 2L), new Deletion(new PartialPath(new String[]{"d1", "s3"}), 3L, 3L, 4L), new Deletion(new PartialPath(new String[]{"d1", "s41"}), 4L, 4L, 5L)};
        try (ModificationFile mFile = new ModificationFile(tempFileName);){
            int i;
            for (int i2 = 0; i2 < 2; ++i2) {
                mFile.write(modifications[i2]);
            }
            List modificationList = (List)mFile.getModifications();
            for (i = 0; i < 2; ++i) {
                Assert.assertEquals((Object)modifications[i], modificationList.get(i));
            }
            for (i = 2; i < 4; ++i) {
                mFile.write(modifications[i]);
            }
            modificationList = (List)mFile.getModifications();
            for (i = 0; i < 4; ++i) {
                Assert.assertEquals((Object)modifications[i], modificationList.get(i));
            }
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        finally {
            new File(tempFileName).delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void writeVerifyTest() {
        String tempFileName = TestConstant.BASE_OUTPUT_PATH.concat("mod.temp");
        Modification[] modifications = new Modification[]{new Deletion(new PartialPath(new String[]{"d1", "s1"}), 1L, 1L), new Deletion(new PartialPath(new String[]{"d1", "s2"}), 2L, 2L)};
        try (ModificationFile mFile = new ModificationFile(tempFileName);){
            mFile.write(modifications[0]);
            try (LocalTextModificationAccessor accessor = new LocalTextModificationAccessor(tempFileName);){
                accessor.writeInComplete(modifications[1]);
            }
            mFile.write(modifications[1]);
            List modificationList = (List)mFile.getModifications();
            Assert.assertEquals((long)2L, (long)modificationList.size());
            for (int i = 0; i < 2; ++i) {
                Assert.assertEquals((Object)modifications[i], modificationList.get(i));
            }
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        finally {
            new File(tempFileName).delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompact01() {
        String tempFileName = TestConstant.BASE_OUTPUT_PATH.concat("compact01.mods");
        long time = 1000L;
        try (ModificationFile modificationFile = new ModificationFile(tempFileName);){
            while (modificationFile.getSize() < 0x100000L) {
                modificationFile.write((Modification)new Deletion(new PartialPath(new String[]{"root", "sg", "d1"}), 1000L, Long.MIN_VALUE, time += 5000L));
            }
            modificationFile.compact();
            ArrayList modificationList = new ArrayList(modificationFile.getModifications());
            Assert.assertEquals((long)1L, (long)modificationList.size());
            Deletion deletion = (Deletion)modificationList.get(0);
            Assert.assertEquals((long)time, (long)deletion.getEndTime());
            Assert.assertEquals((long)Long.MIN_VALUE, (long)deletion.getStartTime());
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        finally {
            new File(tempFileName).delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompact02() {
        String tempFileName = TestConstant.BASE_OUTPUT_PATH.concat("compact02.mods");
        long time = 1000L;
        try (ModificationFile modificationFile = new ModificationFile(tempFileName);){
            while (modificationFile.getSize() < 102400L) {
                modificationFile.write((Modification)new Deletion(new PartialPath(new String[]{"root", "sg", "d1"}), 1000L, Long.MIN_VALUE, time += 5000L));
            }
            modificationFile.compact();
            ArrayList modificationList = new ArrayList(modificationFile.getModifications());
            Assert.assertTrue((modificationList.size() > 1 ? 1 : 0) != 0);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        finally {
            new File(tempFileName).delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompact03() {
        String tempFileName = TestConstant.BASE_OUTPUT_PATH.concat("compact03.mods");
        try (ModificationFile modificationFile = new ModificationFile(tempFileName);){
            while (modificationFile.getSize() < 0x100000L) {
                modificationFile.write((Modification)new Deletion(new PartialPath(new String[]{"root", "sg", "d1"}), 1000L, Long.MIN_VALUE, Long.MAX_VALUE));
            }
            modificationFile.compact();
            ArrayList modificationList = new ArrayList(modificationFile.getModifications());
            Assert.assertEquals((long)1L, (long)modificationList.size());
            Deletion deletion = (Deletion)modificationList.get(0);
            Assert.assertEquals((long)Long.MAX_VALUE, (long)deletion.getEndTime());
            Assert.assertEquals((long)Long.MIN_VALUE, (long)deletion.getStartTime());
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        finally {
            new File(tempFileName).delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompact04() {
        String tempFileName = TestConstant.BASE_OUTPUT_PATH.concat("compact04.mods");
        try (ModificationFile modificationFile = new ModificationFile(tempFileName);){
            long time = 0L;
            while (modificationFile.getSize() < 0x100000L) {
                for (int i = 0; i < 5; ++i) {
                    modificationFile.write((Modification)new Deletion(new PartialPath(new String[]{"root", "sg", "d1"}), 1000L, Long.MIN_VALUE, time += 5000L));
                    modificationFile.write((Modification)new Deletion(new PartialPath(new String[]{"root", "sg", "*"}), 1000L, Long.MIN_VALUE, time += 5000L));
                }
            }
            modificationFile.compact();
            ArrayList modificationList = new ArrayList(modificationFile.getModifications());
            Assert.assertEquals((long)2L, (long)modificationList.size());
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        finally {
            new File(tempFileName).delete();
        }
    }

    @Test
    public void testRecover01() {
        String modsFileName = TestConstant.BASE_OUTPUT_PATH.concat("compact01.mods");
        String modsSettleFileName = TestConstant.BASE_OUTPUT_PATH.concat("compact01.mods.settle");
        try (ModificationFile modsFile = new ModificationFile(modsFileName);
             ModificationFile modsSettleFile = new ModificationFile(modsSettleFileName);){
            modsFile.write((Modification)new Deletion(new PartialPath(new String[]{"root", "sg", "d1"}), 1000L, Long.MIN_VALUE, Long.MAX_VALUE));
            modsSettleFile.write((Modification)new Deletion(new PartialPath(new String[]{"root", "sg", "d1"}), 1000L, Long.MIN_VALUE, Long.MAX_VALUE));
            modsFile.close();
            modsSettleFile.close();
            new CompactionRecoverManager(null, null, null).recoverModSettleFile(new File(TestConstant.BASE_OUTPUT_PATH).toPath());
            Assert.assertTrue((boolean)modsFile.exists());
            Assert.assertFalse((boolean)modsSettleFile.exists());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                Files.delete(new File(modsFileName).toPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Test
    public void testRecover02() {
        String modsSettleFileName = TestConstant.BASE_OUTPUT_PATH.concat("compact02.mods.settle");
        String originModsFileName = TestConstant.BASE_OUTPUT_PATH.concat("compact02.mods");
        try (ModificationFile modsSettleFile = new ModificationFile(modsSettleFileName);){
            modsSettleFile.write((Modification)new Deletion(new PartialPath(new String[]{"root", "sg", "d1"}), 1000L, Long.MIN_VALUE, Long.MAX_VALUE));
            modsSettleFile.close();
            new CompactionRecoverManager(null, null, null).recoverModSettleFile(new File(TestConstant.BASE_OUTPUT_PATH).toPath());
            Assert.assertFalse((boolean)modsSettleFile.exists());
            Assert.assertTrue((boolean)new File(originModsFileName).exists());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                Files.delete(new File(originModsFileName).toPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

