/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.memtable;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.DataRegionException;
import org.apache.iotdb.db.exception.TsFileProcessorException;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowsNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.storageengine.dataregion.DataRegionInfo;
import org.apache.iotdb.db.storageengine.dataregion.DataRegionTest;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IMemTable;
import org.apache.iotdb.db.storageengine.dataregion.memtable.ReadOnlyMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.memtable.TsFileProcessor;
import org.apache.iotdb.db.storageengine.dataregion.memtable.TsFileProcessorInfo;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.rescon.memory.SystemInfo;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.reader.IPointReader;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileProcessorTest {
    private TsFileProcessor processor;
    private final String storageGroup = "root.vehicle";
    private DataRegionInfo sgInfo;
    private final String filePath = TestConstant.getTestTsFilePath((String)"root.vehicle", (long)0L, (long)0L, (long)0L);
    private final String deviceId = "root.vehicle.d0";
    private final String measurementId = "s0";
    private final TSDataType dataType = TSDataType.INT32;
    private final TSEncoding encoding = TSEncoding.RLE;
    private final Map<String, String> props = Collections.emptyMap();
    private QueryContext context;
    private final String systemDir = TestConstant.OUTPUT_DATA_DIR.concat("info");
    private static final Logger logger = LoggerFactory.getLogger(TsFileProcessorTest.class);

    @Before
    public void setUp() throws DataRegionException {
        File file = new File(this.filePath);
        if (!file.getParentFile().exists()) {
            Assert.assertTrue((boolean)file.getParentFile().mkdirs());
        }
        EnvironmentUtils.envSetUp();
        this.sgInfo = new DataRegionInfo((DataRegion)new DataRegionTest.DummyDataRegion(this.systemDir, "root.vehicle"));
        this.context = EnvironmentUtils.TEST_QUERY_CONTEXT;
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
        EnvironmentUtils.cleanDir(TestConstant.OUTPUT_DATA_DIR);
    }

    @Test
    public void testWriteAndFlush() throws IOException, WriteProcessException, MetadataException {
        logger.info("testWriteAndFlush begin..");
        this.processor = new TsFileProcessor("root.vehicle", SystemFileFactory.INSTANCE.getFile(this.filePath), this.sgInfo, this::closeTsFileProcessor, (tsFileProcessor, updateMap, systemFlushTime) -> {}, true);
        TsFileProcessorInfo tsFileProcessorInfo = new TsFileProcessorInfo(this.sgInfo);
        this.processor.setTsFileProcessorInfo(tsFileProcessorInfo);
        this.sgInfo.initTsFileProcessorInfo(this.processor);
        SystemInfo.getInstance().reportStorageGroupStatus(this.sgInfo, this.processor);
        ArrayList tsfileResourcesForQuery = new ArrayList();
        MeasurementPath fullPath = new MeasurementPath("root.vehicle.d0", "s0", (IMeasurementSchema)new MeasurementSchema("s0", this.dataType, this.encoding, CompressionType.UNCOMPRESSED, this.props));
        this.processor.query(Collections.singletonList(fullPath), this.context, tsfileResourcesForQuery);
        TestCase.assertTrue((boolean)tsfileResourcesForQuery.isEmpty());
        for (int i = 1; i <= 100; ++i) {
            TSRecord record = new TSRecord((long)i, "root.vehicle.d0");
            record.addTuple(DataPoint.getDataPoint((TSDataType)this.dataType, (String)"s0", (String)String.valueOf(i)));
            this.processor.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record), new long[4]);
        }
        tsfileResourcesForQuery.clear();
        this.processor.query(Collections.singletonList(fullPath), this.context, tsfileResourcesForQuery);
        TsFileResource tsFileResource = (TsFileResource)tsfileResourcesForQuery.get(0);
        Assert.assertFalse((boolean)tsFileResource.getReadOnlyMemChunk((PartialPath)fullPath).isEmpty());
        List memChunks = tsFileResource.getReadOnlyMemChunk((PartialPath)fullPath);
        for (ReadOnlyMemChunk chunk : memChunks) {
            IPointReader iterator = chunk.getPointReader();
            for (int num = 1; num <= 100; ++num) {
                iterator.hasNextTimeValuePair();
                TimeValuePair timeValuePair = iterator.nextTimeValuePair();
                Assert.assertEquals((long)num, (long)timeValuePair.getTimestamp());
                Assert.assertEquals((long)num, (long)timeValuePair.getValue().getInt());
            }
        }
        this.processor.syncFlush();
        tsfileResourcesForQuery.clear();
        this.processor.query(Collections.singletonList(fullPath), this.context, tsfileResourcesForQuery);
        TestCase.assertTrue((boolean)((TsFileResource)tsfileResourcesForQuery.get(0)).getReadOnlyMemChunk((PartialPath)fullPath).isEmpty());
        this.processor.syncClose();
    }

    @Test
    public void testWriteAndRestoreMetadata() throws IOException, WriteProcessException, MetadataException {
        logger.info("testWriteAndRestoreMetadata begin..");
        this.processor = new TsFileProcessor("root.vehicle", SystemFileFactory.INSTANCE.getFile(this.filePath), this.sgInfo, this::closeTsFileProcessor, (tsFileProcessor, updateMap, systemFlushTime) -> {}, true);
        TsFileProcessorInfo tsFileProcessorInfo = new TsFileProcessorInfo(this.sgInfo);
        this.processor.setTsFileProcessorInfo(tsFileProcessorInfo);
        this.sgInfo.initTsFileProcessorInfo(this.processor);
        SystemInfo.getInstance().reportStorageGroupStatus(this.sgInfo, this.processor);
        ArrayList tsfileResourcesForQuery = new ArrayList();
        MeasurementPath fullPath = new MeasurementPath("root.vehicle.d0", "s0", (IMeasurementSchema)new MeasurementSchema("s0", this.dataType, this.encoding, CompressionType.UNCOMPRESSED, this.props));
        this.processor.query(Collections.singletonList(fullPath), this.context, tsfileResourcesForQuery);
        TestCase.assertTrue((boolean)tsfileResourcesForQuery.isEmpty());
        for (int i = 1; i <= 100; ++i) {
            TSRecord record = new TSRecord((long)i, "root.vehicle.d0");
            record.addTuple(DataPoint.getDataPoint((TSDataType)this.dataType, (String)"s0", (String)String.valueOf(i)));
            this.processor.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record), new long[4]);
        }
        tsfileResourcesForQuery.clear();
        this.processor.query(Collections.singletonList(fullPath), this.context, tsfileResourcesForQuery);
        Assert.assertFalse((boolean)((TsFileResource)tsfileResourcesForQuery.get(0)).getReadOnlyMemChunk((PartialPath)fullPath).isEmpty());
        int num = 1;
        List memChunks = ((TsFileResource)tsfileResourcesForQuery.get(0)).getReadOnlyMemChunk((PartialPath)fullPath);
        for (ReadOnlyMemChunk chunk : memChunks) {
            IPointReader iterator = chunk.getPointReader();
            while (num <= 100) {
                iterator.hasNextTimeValuePair();
                TimeValuePair timeValuePair = iterator.nextTimeValuePair();
                Assert.assertEquals((long)num, (long)timeValuePair.getTimestamp());
                Assert.assertEquals((long)num, (long)timeValuePair.getValue().getInt());
                ++num;
            }
        }
        logger.info("syncFlush..");
        this.processor.syncFlush();
        tsfileResourcesForQuery.clear();
        this.processor.query(Collections.singletonList(fullPath), this.context, tsfileResourcesForQuery);
        TestCase.assertTrue((boolean)((TsFileResource)tsfileResourcesForQuery.get(0)).getReadOnlyMemChunk((PartialPath)fullPath).isEmpty());
        RestorableTsFileIOWriter tsFileIOWriter = this.processor.getWriter();
        Map chunkMetaDataListInChunkGroups = tsFileIOWriter.getDeviceChunkMetadataMap();
        RestorableTsFileIOWriter restorableTsFileIOWriter = new RestorableTsFileIOWriter(SystemFileFactory.INSTANCE.getFile(this.filePath));
        Map restoredChunkMetaDataListInChunkGroups = restorableTsFileIOWriter.getDeviceChunkMetadataMap();
        Assert.assertEquals((long)chunkMetaDataListInChunkGroups.size(), (long)restoredChunkMetaDataListInChunkGroups.size());
        for (Map.Entry entry1 : chunkMetaDataListInChunkGroups.entrySet()) {
            for (Map.Entry entry2 : restoredChunkMetaDataListInChunkGroups.entrySet()) {
                Assert.assertEquals(entry1.getKey(), entry2.getKey());
                Assert.assertEquals((long)((List)entry1.getValue()).size(), (long)((List)entry2.getValue()).size());
                for (int i = 0; i < ((List)entry1.getValue()).size(); ++i) {
                    ChunkMetadata chunkMetaData = (ChunkMetadata)((List)entry1.getValue()).get(i);
                    chunkMetaData.setVersion(0L);
                    ChunkMetadata chunkMetadataRestore = (ChunkMetadata)((List)entry2.getValue()).get(i);
                    chunkMetadataRestore.setVersion(0L);
                }
            }
        }
        restorableTsFileIOWriter.close();
        logger.info("syncClose..");
        this.processor.syncClose();
    }

    @Test
    public void testMultiFlush() throws IOException, WriteProcessException, MetadataException {
        logger.info("testWriteAndRestoreMetadata begin..");
        this.processor = new TsFileProcessor("root.vehicle", SystemFileFactory.INSTANCE.getFile(this.filePath), this.sgInfo, this::closeTsFileProcessor, (tsFileProcessor, updateMap, systemFlushTime) -> {}, true);
        TsFileProcessorInfo tsFileProcessorInfo = new TsFileProcessorInfo(this.sgInfo);
        this.processor.setTsFileProcessorInfo(tsFileProcessorInfo);
        this.sgInfo.initTsFileProcessorInfo(this.processor);
        SystemInfo.getInstance().reportStorageGroupStatus(this.sgInfo, this.processor);
        ArrayList tsfileResourcesForQuery = new ArrayList();
        MeasurementPath fullPath = new MeasurementPath("root.vehicle.d0", "s0", (IMeasurementSchema)new MeasurementSchema("s0", this.dataType, this.encoding, CompressionType.UNCOMPRESSED, this.props));
        this.processor.query(Collections.singletonList(fullPath), this.context, tsfileResourcesForQuery);
        TestCase.assertTrue((boolean)tsfileResourcesForQuery.isEmpty());
        for (int flushId = 0; flushId < 10; ++flushId) {
            for (int i = 1; i <= 10; ++i) {
                TSRecord record = new TSRecord((long)i, "root.vehicle.d0");
                record.addTuple(DataPoint.getDataPoint((TSDataType)this.dataType, (String)"s0", (String)String.valueOf(i)));
                this.processor.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record), new long[4]);
            }
            this.processor.asyncFlush();
        }
        this.processor.syncFlush();
        tsfileResourcesForQuery.clear();
        this.processor.query(Collections.singletonList(fullPath), this.context, tsfileResourcesForQuery);
        Assert.assertFalse((boolean)tsfileResourcesForQuery.isEmpty());
        TestCase.assertTrue((boolean)((TsFileResource)tsfileResourcesForQuery.get(0)).getReadOnlyMemChunk((PartialPath)fullPath).isEmpty());
        this.processor.syncClose();
    }

    @Test
    public void alignedTvListRamCostTest() throws MetadataException, WriteProcessException, IOException {
        this.processor = new TsFileProcessor("root.vehicle", SystemFileFactory.INSTANCE.getFile(this.filePath), this.sgInfo, this::closeTsFileProcessor, (tsFileProcessor, updateMap, systemFlushTime) -> {}, true);
        TsFileProcessorInfo tsFileProcessorInfo = new TsFileProcessorInfo(this.sgInfo);
        this.processor.setTsFileProcessorInfo(tsFileProcessorInfo);
        this.sgInfo.initTsFileProcessorInfo(this.processor);
        SystemInfo.getInstance().reportStorageGroupStatus(this.sgInfo, this.processor);
        this.processor.insertTablet(this.genInsertTableNode(0L, true), 0, 10, new TSStatus[10]);
        IMemTable memTable = this.processor.getWorkMemTable();
        Assert.assertEquals((long)1596808L, (long)memTable.getTVListsRamCost());
        this.processor.insertTablet(this.genInsertTableNode(100L, true), 0, 10, new TSStatus[10]);
        Assert.assertEquals((long)1596808L, (long)memTable.getTVListsRamCost());
        this.processor.insertTablet(this.genInsertTableNode(200L, true), 0, 10, new TSStatus[10]);
        Assert.assertEquals((long)1596808L, (long)memTable.getTVListsRamCost());
        Assert.assertEquals((long)90000L, (long)memTable.getTotalPointsNum());
        Assert.assertEquals((long)720360L, (long)memTable.memSize());
        for (int i = 1; i <= 100; ++i) {
            TSRecord record = new TSRecord((long)i, "root.vehicle.d0");
            record.addTuple(DataPoint.getDataPoint((TSDataType)this.dataType, (String)"s0", (String)String.valueOf(i)));
            this.processor.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record), new long[4]);
        }
        Assert.assertEquals((long)1598424L, (long)memTable.getTVListsRamCost());
        Assert.assertEquals((long)90100L, (long)memTable.getTotalPointsNum());
        Assert.assertEquals((long)721560L, (long)memTable.memSize());
    }

    @Test
    public void alignedTvListRamCostTest2() throws MetadataException, WriteProcessException, IOException {
        TSRecord record;
        int i;
        this.processor = new TsFileProcessor("root.vehicle", SystemFileFactory.INSTANCE.getFile(this.filePath), this.sgInfo, this::closeTsFileProcessor, (tsFileProcessor, updateMap, systemFlushTime) -> {}, true);
        TsFileProcessorInfo tsFileProcessorInfo = new TsFileProcessorInfo(this.sgInfo);
        this.processor.setTsFileProcessorInfo(tsFileProcessorInfo);
        this.sgInfo.initTsFileProcessorInfo(this.processor);
        SystemInfo.getInstance().reportStorageGroupStatus(this.sgInfo, this.processor);
        this.processor.insertTablet(this.genInsertTableNode(0L, true), 0, 10, new TSStatus[10]);
        IMemTable memTable = this.processor.getWorkMemTable();
        Assert.assertEquals((long)1596808L, (long)memTable.getTVListsRamCost());
        this.processor.insertTablet(this.genInsertTableNodeFors3000ToS6000(0L, true), 0, 10, new TSStatus[10]);
        Assert.assertEquals((long)3192808L, (long)memTable.getTVListsRamCost());
        this.processor.insertTablet(this.genInsertTableNode(100L, true), 0, 10, new TSStatus[10]);
        Assert.assertEquals((long)3192808L, (long)memTable.getTVListsRamCost());
        this.processor.insertTablet(this.genInsertTableNodeFors3000ToS6000(100L, true), 0, 10, new TSStatus[10]);
        Assert.assertEquals((long)3192808L, (long)memTable.getTVListsRamCost());
        this.processor.insertTablet(this.genInsertTableNode(200L, true), 0, 10, new TSStatus[10]);
        Assert.assertEquals((long)3192808L, (long)memTable.getTVListsRamCost());
        this.processor.insertTablet(this.genInsertTableNodeFors3000ToS6000(200L, true), 0, 10, new TSStatus[10]);
        Assert.assertEquals((long)3192808L, (long)memTable.getTVListsRamCost());
        this.processor.insertTablet(this.genInsertTableNode(300L, true), 0, 10, new TSStatus[10]);
        Assert.assertEquals((long)6385616L, (long)memTable.getTVListsRamCost());
        this.processor.insertTablet(this.genInsertTableNodeFors3000ToS6000(300L, true), 0, 10, new TSStatus[10]);
        Assert.assertEquals((long)6385616L, (long)memTable.getTVListsRamCost());
        Assert.assertEquals((long)240000L, (long)memTable.getTotalPointsNum());
        Assert.assertEquals((long)1920960L, (long)memTable.memSize());
        for (i = 1; i <= 100; ++i) {
            record = new TSRecord((long)i, "root.vehicle.d0");
            record.addTuple(DataPoint.getDataPoint((TSDataType)this.dataType, (String)"s0", (String)String.valueOf(i)));
            this.processor.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record), new long[4]);
        }
        Assert.assertEquals((long)6387232L, (long)memTable.getTVListsRamCost());
        for (i = 1; i <= 100; ++i) {
            record = new TSRecord((long)i, "root.vehicle.d0");
            record.addTuple(DataPoint.getDataPoint((TSDataType)this.dataType, (String)"s1", (String)String.valueOf(i)));
            this.processor.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record), new long[4]);
        }
        Assert.assertEquals((long)6388848L, (long)memTable.getTVListsRamCost());
        Assert.assertEquals((long)240200L, (long)memTable.getTotalPointsNum());
        Assert.assertEquals((long)1923360L, (long)memTable.memSize());
    }

    @Test
    public void nonAlignedTvListRamCostTest() throws MetadataException, WriteProcessException, IOException {
        this.processor = new TsFileProcessor("root.vehicle", SystemFileFactory.INSTANCE.getFile(this.filePath), this.sgInfo, this::closeTsFileProcessor, (tsFileProcessor, updateMap, systemFlushTime) -> {}, true);
        TsFileProcessorInfo tsFileProcessorInfo = new TsFileProcessorInfo(this.sgInfo);
        this.processor.setTsFileProcessorInfo(tsFileProcessorInfo);
        this.sgInfo.initTsFileProcessorInfo(this.processor);
        SystemInfo.getInstance().reportStorageGroupStatus(this.sgInfo, this.processor);
        this.processor.insertTablet(this.genInsertTableNode(0L, false), 0, 10, new TSStatus[10]);
        IMemTable memTable = this.processor.getWorkMemTable();
        Assert.assertEquals((long)3192000L, (long)memTable.getTVListsRamCost());
        this.processor.insertTablet(this.genInsertTableNode(100L, false), 0, 10, new TSStatus[10]);
        Assert.assertEquals((long)3192000L, (long)memTable.getTVListsRamCost());
        this.processor.insertTablet(this.genInsertTableNode(200L, false), 0, 10, new TSStatus[10]);
        Assert.assertEquals((long)3192000L, (long)memTable.getTVListsRamCost());
        Assert.assertEquals((long)90000L, (long)memTable.getTotalPointsNum());
        Assert.assertEquals((long)1440000L, (long)memTable.memSize());
        for (int i = 1; i <= 100; ++i) {
            TSRecord record = new TSRecord((long)i, "root.vehicle.d0");
            record.addTuple(DataPoint.getDataPoint((TSDataType)this.dataType, (String)"s0", (String)String.valueOf(i)));
            this.processor.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record), new long[4]);
        }
        Assert.assertEquals((long)3193616L, (long)memTable.getTVListsRamCost());
        Assert.assertEquals((long)90100L, (long)memTable.getTotalPointsNum());
        Assert.assertEquals((long)1441200L, (long)memTable.memSize());
    }

    @Test
    public void testRamCostInsertSameNonAlignedDataBy2Ways() throws MetadataException, WriteProcessException, IOException {
        TSRecord record;
        TsFileProcessor processor1 = new TsFileProcessor("root.vehicle", SystemFileFactory.INSTANCE.getFile(this.filePath), this.sgInfo, this::closeTsFileProcessor, (tsFileProcessor, updateMap, systemFlushTime) -> {}, true);
        TsFileProcessorInfo tsFileProcessorInfo1 = new TsFileProcessorInfo(this.sgInfo);
        processor1.setTsFileProcessorInfo(tsFileProcessorInfo1);
        this.sgInfo.initTsFileProcessorInfo(processor1);
        SystemInfo.getInstance().reportStorageGroupStatus(this.sgInfo, processor1);
        for (int i = 1; i <= 100; ++i) {
            TSRecord record2 = new TSRecord((long)i, "root.vehicle.d0");
            record2.addTuple(DataPoint.getDataPoint((TSDataType)this.dataType, (String)"s0", (String)String.valueOf(i)));
            processor1.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record2), new long[4]);
        }
        IMemTable memTable1 = processor1.getWorkMemTable();
        TsFileProcessor processor2 = new TsFileProcessor("root.vehicle", SystemFileFactory.INSTANCE.getFile(this.filePath), this.sgInfo, this::closeTsFileProcessor, (tsFileProcessor, updateMap, systemFlushTime) -> {}, true);
        TsFileProcessorInfo tsFileProcessorInfo2 = new TsFileProcessorInfo(this.sgInfo);
        processor2.setTsFileProcessorInfo(tsFileProcessorInfo2);
        this.sgInfo.initTsFileProcessorInfo(processor2);
        SystemInfo.getInstance().reportStorageGroupStatus(this.sgInfo, processor2);
        InsertRowsNode insertRowsNode = new InsertRowsNode(new PlanNodeId(""));
        for (int i = 1; i <= 100; ++i) {
            record = new TSRecord((long)i, "root.vehicle.d0");
            record.addTuple(DataPoint.getDataPoint((TSDataType)this.dataType, (String)"s0", (String)String.valueOf(i)));
            insertRowsNode.addOneInsertRowNode(DataRegionTest.buildInsertRowNodeByTSRecord(record), i - 1);
        }
        processor2.insert(insertRowsNode, new long[4]);
        IMemTable memTable2 = processor2.getWorkMemTable();
        Assert.assertEquals((long)memTable1.getTVListsRamCost(), (long)memTable2.getTVListsRamCost());
        Assert.assertEquals((long)memTable1.getTotalPointsNum(), (long)memTable2.getTotalPointsNum());
        Assert.assertEquals((long)memTable1.memSize(), (long)memTable2.memSize());
        record = new TSRecord(101L, "root.vehicle.d0");
        record.addTuple(DataPoint.getDataPoint((TSDataType)this.dataType, (String)"s0", (String)"1"));
        InsertRowNode insertRowNode1 = DataRegionTest.buildInsertRowNodeByTSRecord(record);
        processor1.insert(insertRowNode1, new long[4]);
        record = new TSRecord(101L, "root.vehicle.d0");
        record.addTuple(DataPoint.getDataPoint((TSDataType)this.dataType, (String)"s99", (String)"1"));
        InsertRowNode insertRowNode2 = DataRegionTest.buildInsertRowNodeByTSRecord(record);
        processor1.insert(insertRowNode2, new long[4]);
        record = new TSRecord(102L, "root.vehicle.d0");
        record.addTuple(DataPoint.getDataPoint((TSDataType)this.dataType, (String)"s99", (String)"1"));
        InsertRowNode insertRowNode3 = DataRegionTest.buildInsertRowNodeByTSRecord(record);
        processor1.insert(insertRowNode3, new long[4]);
        record = new TSRecord(102L, "root.vehicle.d2");
        record.addTuple(DataPoint.getDataPoint((TSDataType)this.dataType, (String)"s0", (String)"1"));
        InsertRowNode insertRowNode4 = DataRegionTest.buildInsertRowNodeByTSRecord(record);
        processor1.insert(insertRowNode4, new long[4]);
        insertRowsNode = new InsertRowsNode(new PlanNodeId(""));
        insertRowsNode.addOneInsertRowNode(insertRowNode1, 0);
        insertRowsNode.addOneInsertRowNode(insertRowNode2, 1);
        insertRowsNode.addOneInsertRowNode(insertRowNode3, 2);
        insertRowsNode.addOneInsertRowNode(insertRowNode4, 3);
        processor2.insert(insertRowsNode, new long[4]);
        Assert.assertEquals((long)memTable1.getTVListsRamCost(), (long)memTable2.getTVListsRamCost());
        Assert.assertEquals((long)memTable1.getTotalPointsNum(), (long)memTable2.getTotalPointsNum());
        Assert.assertEquals((long)memTable1.memSize(), (long)memTable2.memSize());
        insertRowsNode = new InsertRowsNode(new PlanNodeId(""));
        insertRowNode1.setDataTypes(new TSDataType[1]);
        insertRowNode1.setMeasurements(new String[1]);
        insertRowNode1.setValues((Object[])new String[1]);
        insertRowsNode.addOneInsertRowNode(insertRowNode1, 0);
        processor2.insert(insertRowsNode, new long[4]);
        processor1.insert(insertRowNode1, new long[4]);
        Assert.assertEquals((long)memTable1.getTVListsRamCost(), (long)memTable2.getTVListsRamCost());
        Assert.assertEquals((long)memTable1.getTotalPointsNum(), (long)memTable2.getTotalPointsNum());
        Assert.assertEquals((long)memTable1.memSize(), (long)memTable2.memSize());
    }

    @Test
    public void testRamCostInsertSameAlignedDataBy2Ways() throws MetadataException, WriteProcessException, IOException {
        TSRecord record;
        TsFileProcessor processor1 = new TsFileProcessor("root.vehicle", SystemFileFactory.INSTANCE.getFile(this.filePath), this.sgInfo, this::closeTsFileProcessor, (tsFileProcessor, updateMap, systemFlushTime) -> {}, true);
        TsFileProcessorInfo tsFileProcessorInfo1 = new TsFileProcessorInfo(this.sgInfo);
        processor1.setTsFileProcessorInfo(tsFileProcessorInfo1);
        this.sgInfo.initTsFileProcessorInfo(processor1);
        SystemInfo.getInstance().reportStorageGroupStatus(this.sgInfo, processor1);
        for (int i = 1; i <= 100; ++i) {
            TSRecord record2 = new TSRecord((long)i, "root.vehicle.d0");
            record2.addTuple(DataPoint.getDataPoint((TSDataType)this.dataType, (String)"s0", (String)String.valueOf(i)));
            InsertRowNode node = DataRegionTest.buildInsertRowNodeByTSRecord(record2);
            node.setAligned(true);
            processor1.insert(node, new long[4]);
        }
        IMemTable memTable1 = processor1.getWorkMemTable();
        TsFileProcessor processor2 = new TsFileProcessor("root.vehicle", SystemFileFactory.INSTANCE.getFile(this.filePath), this.sgInfo, this::closeTsFileProcessor, (tsFileProcessor, updateMap, systemFlushTime) -> {}, true);
        TsFileProcessorInfo tsFileProcessorInfo2 = new TsFileProcessorInfo(this.sgInfo);
        processor2.setTsFileProcessorInfo(tsFileProcessorInfo2);
        this.sgInfo.initTsFileProcessorInfo(processor2);
        SystemInfo.getInstance().reportStorageGroupStatus(this.sgInfo, processor2);
        InsertRowsNode insertRowsNode = new InsertRowsNode(new PlanNodeId(""));
        insertRowsNode.setAligned(true);
        for (int i = 1; i <= 100; ++i) {
            record = new TSRecord((long)i, "root.vehicle.d0");
            record.addTuple(DataPoint.getDataPoint((TSDataType)this.dataType, (String)"s0", (String)String.valueOf(i)));
            InsertRowNode node = DataRegionTest.buildInsertRowNodeByTSRecord(record);
            node.setAligned(true);
            insertRowsNode.addOneInsertRowNode(node, i - 1);
        }
        processor2.insert(insertRowsNode, new long[4]);
        IMemTable memTable2 = processor2.getWorkMemTable();
        Assert.assertEquals((long)memTable1.getTVListsRamCost(), (long)memTable2.getTVListsRamCost());
        Assert.assertEquals((long)memTable1.getTotalPointsNum(), (long)memTable2.getTotalPointsNum());
        Assert.assertEquals((long)memTable1.memSize(), (long)memTable2.memSize());
        record = new TSRecord(101L, "root.vehicle.d0");
        record.addTuple(DataPoint.getDataPoint((TSDataType)this.dataType, (String)"s0", (String)"1"));
        InsertRowNode insertRowNode1 = DataRegionTest.buildInsertRowNodeByTSRecord(record);
        insertRowNode1.setAligned(true);
        processor1.insert(insertRowNode1, new long[4]);
        record = new TSRecord(101L, "root.vehicle.d0");
        record.addTuple(DataPoint.getDataPoint((TSDataType)this.dataType, (String)"s99", (String)"1"));
        InsertRowNode insertRowNode2 = DataRegionTest.buildInsertRowNodeByTSRecord(record);
        insertRowNode2.setAligned(true);
        processor1.insert(insertRowNode2, new long[4]);
        record = new TSRecord(102L, "root.vehicle.d0");
        record.addTuple(DataPoint.getDataPoint((TSDataType)this.dataType, (String)"s99", (String)"1"));
        InsertRowNode insertRowNode3 = DataRegionTest.buildInsertRowNodeByTSRecord(record);
        insertRowNode3.setAligned(true);
        processor1.insert(insertRowNode3, new long[4]);
        record = new TSRecord(102L, "root.vehicle.d2");
        record.addTuple(DataPoint.getDataPoint((TSDataType)this.dataType, (String)"s0", (String)"1"));
        InsertRowNode insertRowNode4 = DataRegionTest.buildInsertRowNodeByTSRecord(record);
        insertRowNode4.setAligned(true);
        processor1.insert(insertRowNode4, new long[4]);
        insertRowsNode = new InsertRowsNode(new PlanNodeId(""));
        insertRowsNode.addOneInsertRowNode(insertRowNode1, 0);
        insertRowsNode.addOneInsertRowNode(insertRowNode2, 1);
        insertRowsNode.addOneInsertRowNode(insertRowNode3, 2);
        insertRowsNode.addOneInsertRowNode(insertRowNode4, 3);
        insertRowsNode.setAligned(true);
        processor2.insert(insertRowsNode, new long[4]);
        Assert.assertEquals((long)memTable1.getTVListsRamCost(), (long)memTable2.getTVListsRamCost());
        Assert.assertEquals((long)memTable1.getTotalPointsNum(), (long)memTable2.getTotalPointsNum());
        Assert.assertEquals((long)memTable1.memSize(), (long)memTable2.memSize());
        insertRowsNode = new InsertRowsNode(new PlanNodeId(""));
        insertRowNode1.setDataTypes(new TSDataType[1]);
        insertRowNode1.setMeasurements(new String[1]);
        insertRowNode1.setValues((Object[])new String[1]);
        insertRowsNode.addOneInsertRowNode(insertRowNode1, 0);
        insertRowsNode.setAligned(true);
        processor2.insert(insertRowsNode, new long[4]);
        processor1.insert(insertRowNode1, new long[4]);
        Assert.assertEquals((long)memTable1.getTVListsRamCost(), (long)memTable2.getTVListsRamCost());
        Assert.assertEquals((long)memTable1.getTotalPointsNum(), (long)memTable2.getTotalPointsNum());
        Assert.assertEquals((long)memTable1.memSize(), (long)memTable2.memSize());
    }

    @Test
    public void testWriteAndClose() throws IOException, WriteProcessException, MetadataException {
        logger.info("testWriteAndRestoreMetadata begin..");
        this.processor = new TsFileProcessor("root.vehicle", SystemFileFactory.INSTANCE.getFile(this.filePath), this.sgInfo, this::closeTsFileProcessor, (tsFileProcessor, updateMap, systemFlushTime) -> {}, true);
        TsFileProcessorInfo tsFileProcessorInfo = new TsFileProcessorInfo(this.sgInfo);
        this.processor.setTsFileProcessorInfo(tsFileProcessorInfo);
        this.sgInfo.initTsFileProcessorInfo(this.processor);
        SystemInfo.getInstance().reportStorageGroupStatus(this.sgInfo, this.processor);
        ArrayList tsfileResourcesForQuery = new ArrayList();
        MeasurementPath fullPath = new MeasurementPath("root.vehicle.d0", "s0", (IMeasurementSchema)new MeasurementSchema("s0", this.dataType, this.encoding, CompressionType.UNCOMPRESSED, this.props));
        this.processor.query(Collections.singletonList(fullPath), this.context, tsfileResourcesForQuery);
        TestCase.assertTrue((boolean)tsfileResourcesForQuery.isEmpty());
        for (int i = 1; i <= 100; ++i) {
            TSRecord record = new TSRecord((long)i, "root.vehicle.d0");
            record.addTuple(DataPoint.getDataPoint((TSDataType)this.dataType, (String)"s0", (String)String.valueOf(i)));
            this.processor.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record), new long[4]);
        }
        tsfileResourcesForQuery.clear();
        this.processor.query(Collections.singletonList(fullPath), this.context, tsfileResourcesForQuery);
        Assert.assertFalse((boolean)tsfileResourcesForQuery.isEmpty());
        Assert.assertFalse((boolean)((TsFileResource)tsfileResourcesForQuery.get(0)).getReadOnlyMemChunk((PartialPath)fullPath).isEmpty());
        List memChunks = ((TsFileResource)tsfileResourcesForQuery.get(0)).getReadOnlyMemChunk((PartialPath)fullPath);
        for (ReadOnlyMemChunk chunk : memChunks) {
            IPointReader iterator = chunk.getPointReader();
            for (int num = 1; num <= 100; ++num) {
                iterator.hasNextTimeValuePair();
                TimeValuePair timeValuePair = iterator.nextTimeValuePair();
                Assert.assertEquals((long)num, (long)timeValuePair.getTimestamp());
                Assert.assertEquals((long)num, (long)timeValuePair.getValue().getInt());
            }
        }
        this.processor.syncClose();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        TestCase.assertTrue((boolean)this.processor.getTsFileResource().isClosed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeTsFileProcessor(TsFileProcessor unsealedTsFileProcessor) throws TsFileProcessorException {
        TsFileResource resource;
        TsFileResource tsFileResource = resource = unsealedTsFileProcessor.getTsFileResource();
        synchronized (tsFileResource) {
            for (IDeviceID deviceId : resource.getDevices()) {
                resource.updateEndTime(deviceId, resource.getStartTime(deviceId));
            }
            try {
                resource.close();
            }
            catch (IOException e) {
                throw new TsFileProcessorException((Exception)e);
            }
        }
    }

    private InsertTabletNode genInsertTableNode(long startTime, boolean isAligned) throws IllegalPathException {
        String deviceId = "root.sg.device5";
        String[] measurements = new String[3000];
        TSDataType[] dataTypes = new TSDataType[3000];
        TSEncoding[] encodings = new TSEncoding[3000];
        MeasurementSchema[] schemas = new MeasurementSchema[3000];
        for (int i = 0; i < 3000; ++i) {
            measurements[i] = "s" + i;
            dataTypes[i] = TSDataType.INT64;
            encodings[i] = TSEncoding.PLAIN;
            schemas[i] = new MeasurementSchema(measurements[i], dataTypes[i], encodings[i]);
        }
        long[] times = new long[10];
        Object[] columns = new Object[3000];
        for (int i = 0; i < 3000; ++i) {
            columns[i] = new long[10];
        }
        for (long r = 0L; r < 10L; ++r) {
            times[(int)r] = r + startTime;
            for (int i = 0; i < 3000; ++i) {
                ((long[])columns[i])[(int)r] = r;
            }
        }
        InsertTabletNode insertTabletNode = new InsertTabletNode(new QueryId("test_write").genPlanNodeId(), new PartialPath(deviceId), isAligned, measurements, dataTypes, times, null, columns, times.length);
        insertTabletNode.setMeasurementSchemas(schemas);
        return insertTabletNode;
    }

    private InsertTabletNode genInsertTableNodeFors3000ToS6000(long startTime, boolean isAligned) throws IllegalPathException {
        String deviceId = "root.sg.device5";
        String[] measurements = new String[3000];
        TSDataType[] dataTypes = new TSDataType[3000];
        TSEncoding[] encodings = new TSEncoding[3000];
        MeasurementSchema[] schemas = new MeasurementSchema[3000];
        for (int i = 0; i < 3000; ++i) {
            measurements[i] = "s" + i + 3000;
            dataTypes[i] = TSDataType.INT64;
            encodings[i] = TSEncoding.PLAIN;
            schemas[i] = new MeasurementSchema(measurements[i], dataTypes[i], encodings[i]);
        }
        long[] times = new long[10];
        Object[] columns = new Object[3000];
        for (int i = 0; i < 3000; ++i) {
            columns[i] = new long[10];
        }
        for (long r = 0L; r < 10L; ++r) {
            times[(int)r] = r + startTime;
            for (int i = 0; i < 3000; ++i) {
                ((long[])columns[i])[(int)r] = r;
            }
        }
        InsertTabletNode insertTabletNode = new InsertTabletNode(new QueryId("test_write").genPlanNodeId(), new PartialPath(deviceId), isAligned, measurements, dataTypes, times, null, columns, times.length);
        insertTabletNode.setMeasurementSchemas(schemas);
        return insertTabletNode;
    }
}

