/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.memtable;

import java.util.Collections;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.storageengine.dataregion.memtable.DeviceIDFactory;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IMemTable;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.PlainDeviceID;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.Schema;

public class MemTableTestUtils {
    public static IDeviceID deviceId0 = new PlainDeviceID("d0");
    public static String measurementId0 = "s0";
    public static TSDataType dataType0 = TSDataType.INT32;
    private static Schema schema = new Schema();

    public static void produceData(IMemTable iMemTable, long startTime, long endTime, IDeviceID deviceId, String measurementId, TSDataType dataType) throws IllegalPathException {
        if (startTime > endTime) {
            throw new RuntimeException(String.format("start time %d > end time %d", startTime, endTime));
        }
        for (long l = startTime; l <= endTime; ++l) {
            iMemTable.write(DeviceIDFactory.getInstance().getDeviceID(new PartialPath(deviceId)), Collections.singletonList(new MeasurementSchema(measurementId, dataType, TSEncoding.PLAIN)), l, new Object[]{(int)l});
        }
    }

    public static void produceVectorData(IMemTable iMemTable) throws IllegalPathException, WriteProcessException {
        iMemTable.insertTablet(MemTableTestUtils.genInsertTableNode(), 1, 101);
    }

    private static InsertTabletNode genInsertTableNode() throws IllegalPathException {
        String[] measurements = new String[]{"sensor0", "sensor1"};
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.BOOLEAN, TSDataType.INT64};
        long[] times = new long[101];
        Object[] columns = new Object[]{new boolean[101], new long[101]};
        for (long r = 0L; r < 101L; ++r) {
            times[(int)r] = r;
            ((boolean[])columns[0])[(int)r] = false;
            ((long[])columns[1])[(int)r] = r;
        }
        TSEncoding[] encodings = new TSEncoding[]{TSEncoding.PLAIN, TSEncoding.GORILLA};
        MeasurementSchema[] schemas = new MeasurementSchema[]{new MeasurementSchema(measurements[0], dataTypes[0], encodings[0]), new MeasurementSchema(measurements[1], dataTypes[1], encodings[1])};
        InsertTabletNode node = new InsertTabletNode(new PlanNodeId("0"), new PartialPath(deviceId0), true, measurements, dataTypes, times, null, columns, times.length);
        node.setMeasurementSchemas(schemas);
        return node;
    }

    public static void produceNullableVectorData(IMemTable iMemTable) throws IllegalPathException, WriteProcessException {
        InsertTabletNode node = MemTableTestUtils.genInsertTableNode();
        BitMap[] bitMaps = new BitMap[2];
        bitMaps[1] = new BitMap(101);
        for (int r = 0; r < 101; ++r) {
            if (r % 2 != 1) continue;
            bitMaps[1].mark(r);
        }
        node.setBitMaps(bitMaps);
        iMemTable.insertTablet(node, 1, 101);
    }

    public static Schema getSchema() {
        return schema;
    }

    static {
        schema.registerTimeseries(new Path(deviceId0), new MeasurementSchema(measurementId0, dataType0, TSEncoding.PLAIN));
    }
}

