/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.flush;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.dataregion.flush.CompressionRatio;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.utils.FilePathUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompressionRatioTest {
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private CompressionRatio compressionRatio = CompressionRatio.getInstance();
    private static final String directory = FilePathUtils.regularizePath((String)CONFIG.getSystemDir()) + "compression_ratio";

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.envSetUp();
        FileUtils.forceMkdir((File)new File(directory));
        this.compressionRatio.reset();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testCompressionRatio() throws IOException {
        long totalMemorySize = 10L;
        long totalDiskSize = 5L;
        for (int i = 0; i < 5; ++i) {
            this.compressionRatio.updateRatio(10L, 5L);
            if (!new File(directory, String.format(Locale.ENGLISH, "Compress-%d-%d", totalMemorySize, totalDiskSize)).exists()) {
                Assert.fail();
            }
            Assert.assertEquals((double)2.0, (double)this.compressionRatio.getRatio(), (double)0.1);
            totalMemorySize += 10L;
            totalDiskSize += 5L;
        }
    }

    @Test
    public void testRestore() throws IOException {
        Files.createFile(new File(directory, String.format(Locale.ENGLISH, "Compress-%d-%d", 1000, 100)).toPath(), new FileAttribute[0]);
        Files.createFile(new File(directory, String.format(Locale.ENGLISH, "Compress-%d-%d", 1000, 200)).toPath(), new FileAttribute[0]);
        Files.createFile(new File(directory, String.format(Locale.ENGLISH, "Compress-%d-%d", 1000, 500)).toPath(), new FileAttribute[0]);
        this.compressionRatio.restore();
        Assert.assertEquals((double)2.0, (double)this.compressionRatio.getRatio(), (double)0.1);
    }
}

