/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.CompactionTestFileWriter;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.write.chunk.AlignedChunkWriterImpl;
import org.apache.iotdb.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.iotdb.tsfile.write.chunk.IChunkWriter;
import org.apache.iotdb.tsfile.write.chunk.ValueChunkWriter;
import org.apache.iotdb.tsfile.write.page.PageWriter;
import org.apache.iotdb.tsfile.write.page.TimePageWriter;
import org.apache.iotdb.tsfile.write.page.ValuePageWriter;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;

public class TsFileGeneratorUtils {
    public static final String testStorageGroup = "root.testsg";

    public static List<IChunkWriter> createChunkWriter(List<PartialPath> timeseriesPaths, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressionTypes, boolean isAligned) {
        ArrayList<IChunkWriter> iChunkWriters = new ArrayList<IChunkWriter>();
        if (!isAligned) {
            for (int i = 0; i < timeseriesPaths.size(); ++i) {
                PartialPath path = timeseriesPaths.get(i);
                MeasurementSchema schema = new MeasurementSchema(path.getMeasurement(), dataTypes.get(i), encodings.get(i), compressionTypes.get(i));
                iChunkWriters.add((IChunkWriter)new ChunkWriterImpl((IMeasurementSchema)schema));
            }
        } else {
            ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
            for (int i = 0; i < timeseriesPaths.size(); ++i) {
                AlignedPath alignedPath = (AlignedPath)timeseriesPaths.get(i);
                schemas.add(new MeasurementSchema((String)alignedPath.getMeasurementList().get(0), dataTypes.get(i), encodings.get(i), compressionTypes.get(i)));
            }
            MeasurementSchema timeSchema = new MeasurementSchema("", TSFileDescriptor.getInstance().getConfig().getTimeSeriesDataType(), TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getTimeEncoder()), CompressionType.GZIP);
            iChunkWriters.add((IChunkWriter)new AlignedChunkWriterImpl((IMeasurementSchema)timeSchema, schemas));
        }
        return iChunkWriters;
    }

    public static List<PartialPath> createTimeseries(int deviceIndex, List<Integer> meausurementIndex, List<TSDataType> dataTypes, boolean isAligned) throws IllegalPathException {
        ArrayList<PartialPath> timeseriesPath = new ArrayList<PartialPath>();
        for (int i : meausurementIndex) {
            if (!isAligned) {
                timeseriesPath.add((PartialPath)new MeasurementPath("root.testsg.d" + deviceIndex + "." + "s" + i, dataTypes.get(i)));
                continue;
            }
            timeseriesPath.add((PartialPath)new AlignedPath("root.testsg.d" + deviceIndex, Collections.singletonList("s" + i), Collections.singletonList(new MeasurementSchema("s" + i, dataTypes.get(i)))));
        }
        return timeseriesPath;
    }

    public static List<PartialPath> createTimeseries(int deviceNum, int measurementNum, boolean isAligned) throws IllegalPathException {
        ArrayList<PartialPath> timeseriesPath = new ArrayList<PartialPath>();
        for (int d = 0; d < deviceNum; ++d) {
            for (int i = 0; i < measurementNum; ++i) {
                TSDataType dataType = TsFileGeneratorUtils.getDataType(i);
                if (!isAligned) {
                    timeseriesPath.add((PartialPath)new MeasurementPath("root.testsg.d" + d + "." + "s" + i, dataType));
                    continue;
                }
                timeseriesPath.add((PartialPath)new AlignedPath("root.testsg.d" + d, Collections.singletonList("s" + i), Collections.singletonList(new MeasurementSchema("s" + i, dataType))));
            }
        }
        return timeseriesPath;
    }

    public static void writeOneAlignedPage(AlignedChunkWriterImpl alignedChunkWriter, List<TimeRange> timeRanges, boolean isSeq) {
        TimePageWriter timePageWriter = alignedChunkWriter.getTimeChunkWriter().getPageWriter();
        for (TimeRange timeRange : timeRanges) {
            for (long timestamp = timeRange.getMin(); timestamp <= timeRange.getMax(); ++timestamp) {
                timePageWriter.write(timestamp);
            }
        }
        for (ValueChunkWriter valueChunkWriter : alignedChunkWriter.getValueChunkWriterList()) {
            ValuePageWriter valuePageWriter = valueChunkWriter.getPageWriter();
            for (TimeRange timeRange : timeRanges) {
                for (long timestamp = timeRange.getMin(); timestamp <= timeRange.getMax(); ++timestamp) {
                    TsFileGeneratorUtils.writeAlignedPoint(valuePageWriter, timestamp, isSeq);
                }
            }
        }
        alignedChunkWriter.sealCurrentPage();
    }

    public static void writeOneNonAlignedPage(ChunkWriterImpl chunkWriter, List<TimeRange> timeRanges, boolean isSeq) {
        PageWriter pageWriter = chunkWriter.getPageWriter();
        for (TimeRange timeRange : timeRanges) {
            for (long timestamp = timeRange.getMin(); timestamp <= timeRange.getMax(); ++timestamp) {
                TsFileGeneratorUtils.writeNonAlignedPoint(pageWriter, timestamp, isSeq);
            }
        }
        chunkWriter.sealCurrentPage();
    }

    public static void writeNonAlignedPoint(PageWriter pageWriter, long timestamp, boolean isSeq) {
        switch (pageWriter.getStatistics().getType()) {
            case TEXT: {
                pageWriter.write(timestamp, new Binary(isSeq ? "seqText" : "unSeqText", TSFileConfig.STRING_CHARSET));
                break;
            }
            case DOUBLE: {
                pageWriter.write(timestamp, isSeq ? (double)timestamp + 0.01 : 100000.01 + (double)timestamp);
                break;
            }
            case BOOLEAN: {
                pageWriter.write(timestamp, isSeq);
                break;
            }
            case INT64: {
                pageWriter.write(timestamp, isSeq ? timestamp : 100000L + timestamp);
                break;
            }
            case INT32: {
                pageWriter.write(timestamp, isSeq ? (int)timestamp : (int)(100000L + timestamp));
                break;
            }
            case FLOAT: {
                pageWriter.write(timestamp, isSeq ? (float)((double)timestamp + 0.1) : (float)(100000.1 + (double)timestamp));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown data type " + pageWriter.getStatistics().getType());
            }
        }
    }

    public static void writeNonAlignedChunk(ChunkWriterImpl chunkWriter, TsFileIOWriter tsFileIOWriter, List<TimeRange> pages, boolean isSeq) throws IOException {
        PageWriter pageWriter = chunkWriter.getPageWriter();
        for (TimeRange page : pages) {
            for (long timestamp = page.getMin(); timestamp <= page.getMax(); ++timestamp) {
                TsFileGeneratorUtils.writeNonAlignedPoint(pageWriter, timestamp, isSeq);
            }
            chunkWriter.sealCurrentPage();
        }
        chunkWriter.writeToFileWriter(tsFileIOWriter);
    }

    public static void writeNullPoint(ValuePageWriter valuePageWriter, long timestamp) {
        valuePageWriter.write(timestamp, null, true);
    }

    public static void writeAlignedPoint(ValuePageWriter valuePageWriter, long timestamp, boolean isSeq) {
        switch (valuePageWriter.getStatistics().getType()) {
            case TEXT: {
                valuePageWriter.write(timestamp, new Binary(isSeq ? "seqText" : "unSeqText", TSFileConfig.STRING_CHARSET), false);
                break;
            }
            case DOUBLE: {
                valuePageWriter.write(timestamp, isSeq ? (double)timestamp + 0.01 : 100000.01 + (double)timestamp, false);
                break;
            }
            case BOOLEAN: {
                valuePageWriter.write(timestamp, isSeq, false);
                break;
            }
            case INT64: {
                valuePageWriter.write(timestamp, isSeq ? timestamp : 100000L + timestamp, false);
                break;
            }
            case INT32: {
                valuePageWriter.write(timestamp, isSeq ? (int)timestamp : (int)(100000L + timestamp), false);
                break;
            }
            case FLOAT: {
                valuePageWriter.write(timestamp, isSeq ? (float)timestamp + 0.1f : (float)(100000.1 + (double)timestamp), false);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown data type " + valuePageWriter.getStatistics().getType());
            }
        }
    }

    public static void writeAlignedChunk(AlignedChunkWriterImpl alignedChunkWriter, TsFileIOWriter tsFileIOWriter, List<TimeRange> pages, boolean isSeq) throws IOException {
        TimePageWriter timePageWriter = alignedChunkWriter.getTimeChunkWriter().getPageWriter();
        for (TimeRange page : pages) {
            for (long timestamp = page.getMin(); timestamp <= page.getMax(); ++timestamp) {
                timePageWriter.write(timestamp);
            }
            alignedChunkWriter.getTimeChunkWriter().sealCurrentPage();
            for (ValueChunkWriter valueChunkWriter : alignedChunkWriter.getValueChunkWriterList()) {
                ValuePageWriter valuePageWriter = valueChunkWriter.getPageWriter();
                for (long timestamp = page.getMin(); timestamp <= page.getMax(); ++timestamp) {
                    TsFileGeneratorUtils.writeAlignedPoint(valuePageWriter, timestamp, isSeq);
                }
                valueChunkWriter.sealCurrentPage();
            }
        }
        alignedChunkWriter.writeToFileWriter(tsFileIOWriter);
    }

    public static List<TSEncoding> createEncodingType(int num) {
        ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>();
        block4: for (int i = 0; i < num; ++i) {
            int j = i % 6;
            switch (j) {
                case 0: {
                    encodings.add(TSEncoding.RLE);
                    continue block4;
                }
                case 5: {
                    encodings.add(TSEncoding.DICTIONARY);
                    continue block4;
                }
                default: {
                    encodings.add(TSEncoding.GORILLA);
                }
            }
        }
        return encodings;
    }

    public static List<CompressionType> createCompressionType(int num) {
        ArrayList<CompressionType> compressionTypes = new ArrayList<CompressionType>();
        block6: for (int i = 0; i < num; ++i) {
            switch (i % 6) {
                case 0: {
                    compressionTypes.add(CompressionType.UNCOMPRESSED);
                    continue block6;
                }
                case 1: {
                    compressionTypes.add(CompressionType.SNAPPY);
                    continue block6;
                }
                case 2: {
                    compressionTypes.add(CompressionType.GZIP);
                    continue block6;
                }
                case 3: {
                    compressionTypes.add(CompressionType.LZ4);
                    continue block6;
                }
                default: {
                    compressionTypes.add(CompressionType.ZSTD);
                }
            }
        }
        return compressionTypes;
    }

    public static TSDataType getDataType(int num) {
        switch (num % 6) {
            case 0: {
                return TSDataType.BOOLEAN;
            }
            case 1: {
                return TSDataType.INT32;
            }
            case 2: {
                return TSDataType.INT64;
            }
            case 3: {
                return TSDataType.FLOAT;
            }
            case 4: {
                return TSDataType.DOUBLE;
            }
            case 5: {
                return TSDataType.TEXT;
            }
        }
        throw new IllegalArgumentException("Invalid input: " + num % 6);
    }

    public static List<TSDataType> createDataType(int num) {
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        block8: for (int i = 0; i < num; ++i) {
            switch (i % 6) {
                case 0: {
                    dataTypes.add(TSDataType.BOOLEAN);
                    continue block8;
                }
                case 1: {
                    dataTypes.add(TSDataType.INT32);
                    continue block8;
                }
                case 2: {
                    dataTypes.add(TSDataType.INT64);
                    continue block8;
                }
                case 3: {
                    dataTypes.add(TSDataType.FLOAT);
                    continue block8;
                }
                case 4: {
                    dataTypes.add(TSDataType.DOUBLE);
                    continue block8;
                }
                case 5: {
                    dataTypes.add(TSDataType.TEXT);
                }
            }
        }
        return dataTypes;
    }

    public static TsFileResource generateSingleNonAlignedSeriesFile(String device, String measurement, TimeRange[] chunkTimeRanges, TSEncoding encoding, CompressionType compressionType, String filePath) throws IOException {
        TsFileResource seqResource1 = new TsFileResource(new File(filePath));
        CompactionTestFileWriter writer1 = new CompactionTestFileWriter(seqResource1);
        writer1.startChunkGroup(device);
        writer1.generateSimpleNonAlignedSeriesToCurrentDevice(measurement, chunkTimeRanges, encoding, compressionType);
        writer1.endChunkGroup();
        writer1.endFile();
        writer1.close();
        return seqResource1;
    }

    public static TsFileResource generateSingleNonAlignedSeriesFile(String device, String measurement, TimeRange[][] chunkTimeRanges, TSEncoding encoding, CompressionType compressionType, String filePath) throws IOException {
        TsFileResource seqResource1 = new TsFileResource(new File(filePath));
        CompactionTestFileWriter writer1 = new CompactionTestFileWriter(seqResource1);
        writer1.startChunkGroup(device);
        writer1.generateSimpleNonAlignedSeriesToCurrentDevice(measurement, chunkTimeRanges, encoding, compressionType);
        writer1.endChunkGroup();
        writer1.endFile();
        writer1.close();
        return seqResource1;
    }

    public static TsFileResource generateSingleNonAlignedSeriesFile(String device, String measurement, TimeRange[][][] chunkTimeRanges, TSEncoding encoding, CompressionType compressionType, boolean isSeq, String filePath) throws IOException {
        TsFileResource seqResource1 = new TsFileResource(new File(filePath));
        CompactionTestFileWriter writer1 = new CompactionTestFileWriter(seqResource1);
        writer1.startChunkGroup(device);
        writer1.generateSimpleNonAlignedSeriesToCurrentDevice(measurement, chunkTimeRanges, encoding, compressionType);
        writer1.endChunkGroup();
        writer1.endFile();
        writer1.close();
        return seqResource1;
    }

    public static TsFileResource generateSingleAlignedSeriesFile(String device, List<String> measurement, TimeRange[] chunkTimeRanges, TSEncoding encoding, CompressionType compressionType, String filePath) throws IOException {
        TsFileResource seqResource1 = new TsFileResource(new File(filePath));
        CompactionTestFileWriter writer1 = new CompactionTestFileWriter(seqResource1);
        writer1.startChunkGroup(device);
        writer1.generateSimpleAlignedSeriesToCurrentDevice(measurement, chunkTimeRanges, encoding, compressionType);
        writer1.endChunkGroup();
        writer1.endFile();
        writer1.close();
        return seqResource1;
    }

    public static TsFileResource generateSingleAlignedSeriesFile(String device, List<String> measurement, TimeRange[][] chunkTimeRanges, TSEncoding encoding, CompressionType compressionType, String filePath) throws IOException {
        TsFileResource seqResource1 = new TsFileResource(new File(filePath));
        CompactionTestFileWriter writer1 = new CompactionTestFileWriter(seqResource1);
        writer1.startChunkGroup(device);
        writer1.generateSimpleAlignedSeriesToCurrentDevice(measurement, chunkTimeRanges, encoding, compressionType);
        writer1.endChunkGroup();
        writer1.endFile();
        writer1.close();
        return seqResource1;
    }

    public static TsFileResource generateSingleAlignedSeriesFile(String device, List<String> measurement, TimeRange[][][] chunkTimeRanges, TSEncoding encoding, CompressionType compressionType, String filePath) throws IOException {
        TsFileResource seqResource1 = new TsFileResource(new File(filePath));
        CompactionTestFileWriter writer1 = new CompactionTestFileWriter(seqResource1);
        writer1.startChunkGroup(device);
        writer1.generateSimpleAlignedSeriesToCurrentDevice(measurement, chunkTimeRanges, encoding, compressionType);
        writer1.endChunkGroup();
        writer1.endFile();
        writer1.close();
        return seqResource1;
    }
}

