/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.AbstractCompactionTest;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.ICompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.FastCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.ReadChunkCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.ReadPointCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.InnerSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.subtask.FastCompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.MultiTsFileDeviceIterator;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.CompactionFileGeneratorUtils;
import org.apache.iotdb.db.storageengine.dataregion.read.control.FileReaderManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.PlainDeviceID;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.TsFileGeneratorUtils;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultiTsFileDeviceIteratorTest
extends AbstractCompactionTest {
    private final String oldThreadName = Thread.currentThread().getName();

    @Override
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException, InterruptedException {
        super.setUp();
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkSize(1024L);
        Thread.currentThread().setName("pool-1-IoTDB-Compaction-Worker-1");
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        super.tearDown();
        for (TsFileResource tsFileResource : this.seqResources) {
            FileReaderManager.getInstance().closeFileAndRemoveReader(tsFileResource.getTsFilePath());
        }
        for (TsFileResource tsFileResource : this.unseqResources) {
            FileReaderManager.getInstance().closeFileAndRemoveReader(tsFileResource.getTsFilePath());
        }
        Thread.currentThread().setName(this.oldThreadName);
    }

    @Test
    public void getNonAlignedDevicesFromDifferentFilesWithFourLayersInNodeTreeTest() throws MetadataException, IOException, WriteProcessException {
        TSFileDescriptor.getInstance().getConfig().setMaxDegreeOfIndexNode(3);
        this.registerTimeseriesInMManger(30, 3, false);
        this.createFiles(3, 10, 3, 100, 0, 0, 50, 50, false, true);
        this.createFiles(4, 5, 3, 100, 1000, 0, 50, 50, false, true);
        this.createFiles(2, 15, 3, 100, 1000, 0, 50, 50, false, false);
        this.createFiles(3, 30, 3, 100, 1000, 0, 50, 50, false, false);
        ArrayList<PlainDeviceID> deviceIds = new ArrayList<PlainDeviceID>();
        for (int i = 0; i < 30; ++i) {
            deviceIds.add(new PlainDeviceID("root.testsg.d" + i));
        }
        deviceIds.sort(Comparable::compareTo);
        int deviceNum = 0;
        try (MultiTsFileDeviceIterator multiTsFileDeviceIterator = new MultiTsFileDeviceIterator(this.seqResources, this.unseqResources);){
            while (multiTsFileDeviceIterator.hasNextDevice()) {
                Pair deviceInfo = multiTsFileDeviceIterator.nextDevice();
                Assert.assertEquals(deviceIds.get(deviceNum), (Object)deviceInfo.left);
                Assert.assertFalse((boolean)((Boolean)deviceInfo.right));
                ++deviceNum;
            }
        }
        Assert.assertEquals((long)30L, (long)deviceNum);
    }

    @Test
    public void getAlignedDevicesFromDifferentFilesWithOneLayerInNodeTreeTest() throws MetadataException, IOException, WriteProcessException {
        this.registerTimeseriesInMManger(30, 3, false);
        this.createFiles(3, 10, 3, 100, 0, 0, 50, 50, true, true);
        this.createFiles(4, 5, 3, 100, 1000, 0, 50, 50, true, true);
        this.createFiles(2, 15, 3, 100, 1000, 0, 50, 50, true, false);
        this.createFiles(3, 30, 3, 100, 1000, 0, 50, 50, true, false);
        ArrayList<PlainDeviceID> deviceIds = new ArrayList<PlainDeviceID>();
        for (int i = 0; i < 30; ++i) {
            deviceIds.add(new PlainDeviceID("root.testsg.d" + (i + TsFileGeneratorUtils.getAlignDeviceOffset())));
        }
        deviceIds.sort(Comparable::compareTo);
        int deviceNum = 0;
        try (MultiTsFileDeviceIterator multiTsFileDeviceIterator = new MultiTsFileDeviceIterator(this.seqResources, this.unseqResources);){
            while (multiTsFileDeviceIterator.hasNextDevice()) {
                Pair deviceInfo = multiTsFileDeviceIterator.nextDevice();
                Assert.assertEquals(deviceIds.get(deviceNum), (Object)deviceInfo.left);
                Assert.assertTrue((boolean)((Boolean)deviceInfo.right));
                ++deviceNum;
            }
        }
        Assert.assertEquals((long)30L, (long)deviceNum);
    }

    @Test
    public void getNonAlignedDevicesFromDifferentFilesWithFourLayersInNodeTreeTestUsingFileTimeIndex() throws MetadataException, IOException, WriteProcessException {
        TSFileDescriptor.getInstance().getConfig().setMaxDegreeOfIndexNode(3);
        this.registerTimeseriesInMManger(30, 3, false);
        this.createFiles(3, 10, 3, 100, 0, 0, 50, 50, false, true);
        this.createFiles(4, 5, 3, 100, 1000, 0, 50, 50, false, true);
        this.createFiles(2, 15, 3, 100, 1000, 0, 50, 50, false, false);
        this.createFiles(3, 30, 3, 100, 1000, 0, 50, 50, false, false);
        for (TsFileResource resource : this.seqResources) {
            resource.degradeTimeIndex();
        }
        for (TsFileResource resource : this.unseqResources) {
            resource.degradeTimeIndex();
        }
        ArrayList<PlainDeviceID> deviceIds = new ArrayList<PlainDeviceID>();
        for (int i = 0; i < 30; ++i) {
            deviceIds.add(new PlainDeviceID("root.testsg.d" + i));
        }
        deviceIds.sort(Comparable::compareTo);
        int deviceNum = 0;
        try (MultiTsFileDeviceIterator multiTsFileDeviceIterator = new MultiTsFileDeviceIterator(this.seqResources, this.unseqResources);){
            while (multiTsFileDeviceIterator.hasNextDevice()) {
                Pair deviceInfo = multiTsFileDeviceIterator.nextDevice();
                Assert.assertEquals(deviceIds.get(deviceNum), (Object)deviceInfo.left);
                Assert.assertFalse((boolean)((Boolean)deviceInfo.right));
                ++deviceNum;
            }
        }
        Assert.assertEquals((long)30L, (long)deviceNum);
    }

    @Test
    public void getAlignedDevicesFromDifferentFilesWithOneLayerInNodeTreeTestUsingFileTimeIndex() throws MetadataException, IOException, WriteProcessException {
        this.registerTimeseriesInMManger(30, 3, false);
        this.createFiles(3, 10, 3, 100, 0, 0, 50, 50, true, true);
        this.createFiles(4, 5, 3, 100, 1000, 0, 50, 50, true, true);
        this.createFiles(2, 15, 3, 100, 1000, 0, 50, 50, true, false);
        this.createFiles(3, 30, 3, 100, 1000, 0, 50, 50, true, false);
        for (TsFileResource resource : this.seqResources) {
            resource.degradeTimeIndex();
        }
        for (TsFileResource resource : this.unseqResources) {
            resource.degradeTimeIndex();
        }
        ArrayList<PlainDeviceID> deviceIds = new ArrayList<PlainDeviceID>();
        for (int i = 0; i < 30; ++i) {
            deviceIds.add(new PlainDeviceID("root.testsg.d" + (i + TsFileGeneratorUtils.getAlignDeviceOffset())));
        }
        deviceIds.sort(Comparable::compareTo);
        int deviceNum = 0;
        try (MultiTsFileDeviceIterator multiTsFileDeviceIterator = new MultiTsFileDeviceIterator(this.seqResources, this.unseqResources);){
            while (multiTsFileDeviceIterator.hasNextDevice()) {
                Pair deviceInfo = multiTsFileDeviceIterator.nextDevice();
                Assert.assertEquals(deviceIds.get(deviceNum), (Object)deviceInfo.left);
                Assert.assertTrue((boolean)((Boolean)deviceInfo.right));
                ++deviceNum;
            }
        }
        Assert.assertEquals((long)30L, (long)deviceNum);
    }

    @Test
    public void getDeletedDevicesWithSameNameFromDifferentFilesWithFourLayersInNodeTreeTest() throws MetadataException, IOException, WriteProcessException {
        TSFileDescriptor.getInstance().getConfig().setMaxDegreeOfIndexNode(3);
        int oldAlignedDeviceOffset = TsFileGeneratorUtils.alignDeviceOffset;
        TsFileGeneratorUtils.alignDeviceOffset = 0;
        this.registerTimeseriesInMManger(30, 5, false);
        this.createFiles(3, 10, 5, 100, 0, 0, 50, 50, false, true);
        this.createFiles(4, 5, 5, 100, 1000, 0, 50, 50, false, true);
        ArrayList<String> seriesPaths = new ArrayList<String>();
        for (int i = 0; i < 15; ++i) {
            for (int j = 0; j < 5; ++j) {
                seriesPaths.add(COMPACTION_TEST_SG + '.' + "d" + i + '.' + "s" + j);
            }
        }
        this.generateModsFile(seriesPaths, this.seqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        this.generateModsFile(seriesPaths, this.unseqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        this.deleteTimeseriesInMManager(seriesPaths);
        this.createFiles(2, 7, 5, 100, 1600, 1600, 50, 50, true, true);
        this.createFiles(3, 30, 3, 100, 1000, 0, 50, 50, true, false);
        ArrayList<PlainDeviceID> deviceIds = new ArrayList<PlainDeviceID>();
        for (int i = 0; i < 30; ++i) {
            deviceIds.add(new PlainDeviceID("root.testsg.d" + (i + TsFileGeneratorUtils.getAlignDeviceOffset())));
        }
        deviceIds.sort(Comparable::compareTo);
        int deviceNum = 0;
        try (MultiTsFileDeviceIterator multiTsFileDeviceIterator = new MultiTsFileDeviceIterator(this.seqResources, this.unseqResources);){
            while (multiTsFileDeviceIterator.hasNextDevice()) {
                Pair deviceInfo = multiTsFileDeviceIterator.nextDevice();
                Assert.assertEquals(deviceIds.get(deviceNum), (Object)deviceInfo.left);
                Assert.assertTrue((boolean)((Boolean)deviceInfo.right));
                ++deviceNum;
            }
        }
        Assert.assertEquals((long)30L, (long)deviceNum);
        TsFileGeneratorUtils.alignDeviceOffset = oldAlignedDeviceOffset;
    }

    @Test
    public void getDeletedDevicesWithSameNameFromSeqFilesWithFourLayersInNodeTreeTest() throws MetadataException, IOException, WriteProcessException {
        TSFileDescriptor.getInstance().getConfig().setMaxDegreeOfIndexNode(3);
        int oldAlignedDeviceOffset = TsFileGeneratorUtils.alignDeviceOffset;
        TsFileGeneratorUtils.alignDeviceOffset = 0;
        this.registerTimeseriesInMManger(30, 5, false);
        this.createFiles(3, 10, 5, 100, 0, 0, 50, 50, false, true);
        this.createFiles(4, 30, 5, 100, 1000, 0, 50, 50, false, true);
        ArrayList<String> seriesPaths = new ArrayList<String>();
        for (int i = 0; i < 15; ++i) {
            for (int j = 0; j < 5; ++j) {
                seriesPaths.add(COMPACTION_TEST_SG + '.' + "d" + i + '.' + "s" + j);
            }
        }
        this.generateModsFile(seriesPaths, this.seqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        this.generateModsFile(seriesPaths, this.unseqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        this.deleteTimeseriesInMManager(seriesPaths);
        this.createFiles(2, 10, 5, 100, 2000, 2000, 50, 50, true, true);
        this.resetFileName((TsFileResource)this.seqResources.get(7), 100);
        this.resetFileName((TsFileResource)this.seqResources.get(8), 101);
        ArrayList<PlainDeviceID> deviceIds = new ArrayList<PlainDeviceID>();
        for (int i = 0; i < 30; ++i) {
            deviceIds.add(new PlainDeviceID("root.testsg.d" + (i + TsFileGeneratorUtils.getAlignDeviceOffset())));
        }
        deviceIds.sort(Comparable::compareTo);
        int deviceNum = 0;
        try (MultiTsFileDeviceIterator multiTsFileDeviceIterator = new MultiTsFileDeviceIterator(this.seqResources);){
            while (multiTsFileDeviceIterator.hasNextDevice()) {
                Pair deviceInfo = multiTsFileDeviceIterator.nextDevice();
                Assert.assertEquals(deviceIds.get(deviceNum), (Object)deviceInfo.left);
                if (Integer.parseInt(((PlainDeviceID)deviceInfo.left).toStringID().substring(13)) < 10) {
                    Assert.assertTrue((boolean)((Boolean)deviceInfo.right));
                } else {
                    Assert.assertFalse((boolean)((Boolean)deviceInfo.right));
                }
                ++deviceNum;
            }
        }
        Assert.assertEquals((long)30L, (long)deviceNum);
        TsFileGeneratorUtils.alignDeviceOffset = oldAlignedDeviceOffset;
    }

    @Test
    public void getDeletedDevicesWithSameNameFromSeqFilesByReadChunkPerformer() throws MetadataException, IOException, WriteProcessException, StorageEngineException, InterruptedException {
        int j;
        int i;
        TSFileDescriptor.getInstance().getConfig().setMaxDegreeOfIndexNode(3);
        int oldAlignedDeviceOffset = TsFileGeneratorUtils.alignDeviceOffset;
        TsFileGeneratorUtils.alignDeviceOffset = 0;
        this.registerTimeseriesInMManger(30, 5, false);
        this.createFiles(3, 10, 5, 100, 0, 0, 50, 50, false, true);
        this.createFiles(4, 30, 5, 100, 1000, 0, 50, 50, false, true);
        ArrayList<String> seriesPaths = new ArrayList<String>();
        for (int i2 = 0; i2 < 10; ++i2) {
            for (int j2 = 0; j2 < 5; ++j2) {
                seriesPaths.add(COMPACTION_TEST_SG + '.' + "d" + i2 + '.' + "s" + j2);
            }
        }
        this.generateModsFile(seriesPaths, this.seqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        this.generateModsFile(seriesPaths, this.unseqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        this.deleteTimeseriesInMManager(seriesPaths);
        this.createFiles(2, 10, 15, 100, 2000, 2000, 50, 50, true, true);
        this.resetFileName((TsFileResource)this.seqResources.get(7), 100);
        this.resetFileName((TsFileResource)this.seqResources.get(8), 101);
        this.tsFileManager.addAll(this.seqResources, true);
        ArrayList<PlainDeviceID> deviceIds = new ArrayList<PlainDeviceID>();
        for (int i3 = 0; i3 < 30; ++i3) {
            deviceIds.add(new PlainDeviceID("root.testsg.d" + (i3 + TsFileGeneratorUtils.getAlignDeviceOffset())));
        }
        deviceIds.sort(Comparable::compareTo);
        int deviceNum = 0;
        try (MultiTsFileDeviceIterator multiTsFileDeviceIterator = new MultiTsFileDeviceIterator(this.tsFileManager.getTsFileList(true));){
            while (multiTsFileDeviceIterator.hasNextDevice()) {
                Pair deviceInfo = multiTsFileDeviceIterator.nextDevice();
                Assert.assertEquals(deviceIds.get(deviceNum), (Object)deviceInfo.left);
                if (Integer.parseInt(((PlainDeviceID)deviceInfo.left).toStringID().substring(13)) < 10) {
                    Assert.assertTrue((boolean)((Boolean)deviceInfo.right));
                } else {
                    Assert.assertFalse((boolean)((Boolean)deviceInfo.right));
                }
                ++deviceNum;
            }
        }
        Assert.assertEquals((long)30L, (long)deviceNum);
        ArrayList<PartialPath> timeseriesPaths = new ArrayList<PartialPath>();
        for (int i4 = 0; i4 < 30; ++i4) {
            for (int j3 = 0; j3 < 15; ++j3) {
                if (i4 < 10) {
                    timeseriesPaths.add((PartialPath)new AlignedPath(COMPACTION_TEST_SG + '.' + "d" + i4, Collections.singletonList("s" + j3), Collections.singletonList(new MeasurementSchema("s" + j3, TSDataType.INT64))));
                    continue;
                }
                timeseriesPaths.add((PartialPath)new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i4 + '.' + "s" + j3, TSDataType.INT64));
            }
        }
        Map<PartialPath, List<TimeValuePair>> sourceData = this.readSourceFiles(timeseriesPaths, Collections.emptyList());
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.tsFileManager.getTsFileList(true), true, (ICompactionPerformer)new ReadChunkCompactionPerformer(), 0L);
        Assert.assertTrue((boolean)task.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceData, Collections.emptyList());
        seriesPaths.clear();
        for (i = 0; i < 10; ++i) {
            for (j = 0; j < 15; ++j) {
                seriesPaths.add(COMPACTION_TEST_SG + '.' + "d" + i + '.' + "s" + j);
            }
        }
        this.generateModsFile(seriesPaths, this.tsFileManager.getTsFileList(true), Long.MIN_VALUE, Long.MAX_VALUE);
        this.deleteTimeseriesInMManager(seriesPaths);
        this.createFiles(1, 10, 5, 100, 2000, 2000, 50, 50, false, true);
        this.tsFileManager.add((TsFileResource)this.seqResources.get(this.seqResources.size() - 1), true);
        timeseriesPaths.clear();
        for (i = 0; i < 30; ++i) {
            for (j = 0; j < 15; ++j) {
                timeseriesPaths.add((PartialPath)new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i + '.' + "s" + j, TSDataType.INT64));
            }
        }
        sourceData = this.readSourceFiles(timeseriesPaths, Collections.emptyList());
        deviceNum = 0;
        try (MultiTsFileDeviceIterator multiTsFileDeviceIterator = new MultiTsFileDeviceIterator(this.tsFileManager.getTsFileList(true));){
            while (multiTsFileDeviceIterator.hasNextDevice()) {
                Pair deviceInfo = multiTsFileDeviceIterator.nextDevice();
                Assert.assertEquals(deviceIds.get(deviceNum), (Object)deviceInfo.left);
                Assert.assertFalse((boolean)((Boolean)deviceInfo.right));
                ++deviceNum;
            }
        }
        Assert.assertEquals((long)30L, (long)deviceNum);
        TsFileGeneratorUtils.alignDeviceOffset = oldAlignedDeviceOffset;
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getInnerCompactionTargetTsFileResources(this.tsFileManager.getTsFileList(true), true);
        ReadChunkCompactionPerformer performer = new ReadChunkCompactionPerformer(this.tsFileManager.getTsFileList(true), targetResources.get(0));
        performer.setSummary(new CompactionTaskSummary());
        performer.perform();
        CompactionUtils.moveTargetFile(targetResources, (boolean)true, (String)COMPACTION_TEST_SG);
        this.tsFileManager.replace(this.tsFileManager.getTsFileList(true), Collections.emptyList(), targetResources, 0L);
        ((TsFileResource)this.tsFileManager.getTsFileList(true).get(0)).setStatusForTest(TsFileResourceStatus.NORMAL);
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceData, Collections.emptyList());
    }

    @Test
    public void getDeletedDevicesWithSameNameFromSeqFilesByReadChunkPerformer2() throws MetadataException, IOException, WriteProcessException, StorageEngineException, InterruptedException {
        int j;
        int i;
        TSFileDescriptor.getInstance().getConfig().setMaxDegreeOfIndexNode(3);
        int oldAlignedDeviceOffset = TsFileGeneratorUtils.alignDeviceOffset;
        TsFileGeneratorUtils.alignDeviceOffset = 0;
        this.registerTimeseriesInMManger(30, 5, true);
        this.createFiles(3, 10, 5, 100, 0, 0, 50, 50, true, true);
        this.createFiles(4, 30, 5, 100, 1000, 0, 50, 50, true, true);
        ArrayList<String> seriesPaths = new ArrayList<String>();
        for (int i2 = 0; i2 < 10; ++i2) {
            for (int j2 = 0; j2 < 5; ++j2) {
                seriesPaths.add(COMPACTION_TEST_SG + '.' + "d" + i2 + '.' + "s" + j2);
            }
        }
        this.generateModsFile(seriesPaths, this.seqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        this.generateModsFile(seriesPaths, this.unseqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        this.deleteTimeseriesInMManager(seriesPaths);
        this.createFiles(2, 10, 15, 100, 2000, 2000, 50, 50, false, true);
        this.resetFileName((TsFileResource)this.seqResources.get(7), 100);
        this.resetFileName((TsFileResource)this.seqResources.get(8), 101);
        this.tsFileManager.addAll(this.seqResources, true);
        ArrayList<PlainDeviceID> deviceIds = new ArrayList<PlainDeviceID>();
        for (int i3 = 0; i3 < 30; ++i3) {
            deviceIds.add(new PlainDeviceID("root.testsg.d" + (i3 + TsFileGeneratorUtils.getAlignDeviceOffset())));
        }
        deviceIds.sort(Comparable::compareTo);
        int deviceNum = 0;
        try (MultiTsFileDeviceIterator multiTsFileDeviceIterator = new MultiTsFileDeviceIterator(this.tsFileManager.getTsFileList(true));){
            while (multiTsFileDeviceIterator.hasNextDevice()) {
                Pair deviceInfo = multiTsFileDeviceIterator.nextDevice();
                Assert.assertEquals(deviceIds.get(deviceNum), (Object)deviceInfo.left);
                if (Integer.parseInt(((PlainDeviceID)deviceInfo.left).toStringID().substring(13)) < 10) {
                    Assert.assertFalse((boolean)((Boolean)deviceInfo.right));
                } else {
                    Assert.assertTrue((boolean)((Boolean)deviceInfo.right));
                }
                ++deviceNum;
            }
        }
        Assert.assertEquals((long)30L, (long)deviceNum);
        ArrayList<PartialPath> timeseriesPaths = new ArrayList<PartialPath>();
        for (int i4 = 0; i4 < 30; ++i4) {
            for (int j3 = 0; j3 < 15; ++j3) {
                if (i4 >= 10) {
                    timeseriesPaths.add((PartialPath)new AlignedPath(COMPACTION_TEST_SG + '.' + "d" + i4, Collections.singletonList("s" + j3), Collections.singletonList(new MeasurementSchema("s" + j3, TSDataType.INT64))));
                    continue;
                }
                timeseriesPaths.add((PartialPath)new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i4 + '.' + "s" + j3, TSDataType.INT64));
            }
        }
        Map<PartialPath, List<TimeValuePair>> sourceData = this.readSourceFiles(timeseriesPaths, Collections.emptyList());
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.tsFileManager.getTsFileList(true), true, (ICompactionPerformer)new ReadChunkCompactionPerformer(), 0L);
        Assert.assertTrue((boolean)task.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceData, Collections.emptyList());
        seriesPaths.clear();
        for (i = 0; i < 10; ++i) {
            for (j = 0; j < 15; ++j) {
                seriesPaths.add(COMPACTION_TEST_SG + '.' + "d" + i + '.' + "s" + j);
            }
        }
        this.generateModsFile(seriesPaths, this.tsFileManager.getTsFileList(true), Long.MIN_VALUE, Long.MAX_VALUE);
        this.deleteTimeseriesInMManager(seriesPaths);
        this.createFiles(1, 10, 5, 100, 2000, 2000, 50, 50, true, true);
        this.tsFileManager.add((TsFileResource)this.seqResources.get(this.seqResources.size() - 1), true);
        timeseriesPaths.clear();
        for (i = 0; i < 30; ++i) {
            for (j = 0; j < 15; ++j) {
                timeseriesPaths.add((PartialPath)new AlignedPath(COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), Collections.singletonList(new MeasurementSchema("s" + j, TSDataType.INT64))));
            }
        }
        sourceData = this.readSourceFiles(timeseriesPaths, Collections.emptyList());
        deviceNum = 0;
        try (MultiTsFileDeviceIterator multiTsFileDeviceIterator = new MultiTsFileDeviceIterator(this.tsFileManager.getTsFileList(true));){
            while (multiTsFileDeviceIterator.hasNextDevice()) {
                Pair deviceInfo = multiTsFileDeviceIterator.nextDevice();
                Assert.assertEquals(deviceIds.get(deviceNum), (Object)deviceInfo.left);
                Assert.assertTrue((boolean)((Boolean)deviceInfo.right));
                ++deviceNum;
            }
        }
        Assert.assertEquals((long)30L, (long)deviceNum);
        TsFileGeneratorUtils.alignDeviceOffset = oldAlignedDeviceOffset;
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getInnerCompactionTargetTsFileResources(this.tsFileManager.getTsFileList(true), true);
        ReadChunkCompactionPerformer performer = new ReadChunkCompactionPerformer(this.tsFileManager.getTsFileList(true), targetResources.get(0));
        performer.setSummary(new CompactionTaskSummary());
        performer.perform();
        CompactionUtils.moveTargetFile(targetResources, (boolean)true, (String)COMPACTION_TEST_SG);
        this.tsFileManager.replace(this.tsFileManager.getTsFileList(true), Collections.emptyList(), targetResources, 0L);
        ((TsFileResource)this.tsFileManager.getTsFileList(true).get(0)).setStatusForTest(TsFileResourceStatus.NORMAL);
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceData, Collections.emptyList());
    }

    @Test
    public void getDeletedDevicesWithSameNameFromSeqFilesByReadPointPerformer() throws Exception {
        int j;
        int i;
        TSFileDescriptor.getInstance().getConfig().setMaxDegreeOfIndexNode(3);
        int oldAlignedDeviceOffset = TsFileGeneratorUtils.alignDeviceOffset;
        TsFileGeneratorUtils.alignDeviceOffset = 0;
        this.registerTimeseriesInMManger(30, 5, false);
        this.createFiles(3, 10, 5, 100, 0, 0, 50, 50, false, true);
        this.createFiles(4, 30, 5, 100, 1000, 0, 50, 50, false, true);
        ArrayList<String> seriesPaths = new ArrayList<String>();
        for (int i2 = 0; i2 < 10; ++i2) {
            for (int j2 = 0; j2 < 5; ++j2) {
                seriesPaths.add(COMPACTION_TEST_SG + '.' + "d" + i2 + '.' + "s" + j2);
            }
        }
        this.generateModsFile(seriesPaths, this.seqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        this.generateModsFile(seriesPaths, this.unseqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        this.deleteTimeseriesInMManager(seriesPaths);
        this.createFiles(2, 10, 15, 100, 2000, 2000, 50, 50, true, true);
        this.resetFileName((TsFileResource)this.seqResources.get(7), 100);
        this.resetFileName((TsFileResource)this.seqResources.get(8), 101);
        this.tsFileManager.addAll(this.seqResources, true);
        ArrayList<PlainDeviceID> deviceIds = new ArrayList<PlainDeviceID>();
        for (int i3 = 0; i3 < 30; ++i3) {
            deviceIds.add(new PlainDeviceID("root.testsg.d" + (i3 + TsFileGeneratorUtils.getAlignDeviceOffset())));
        }
        deviceIds.sort(Comparable::compareTo);
        int deviceNum = 0;
        try (MultiTsFileDeviceIterator multiTsFileDeviceIterator = new MultiTsFileDeviceIterator(this.tsFileManager.getTsFileList(true));){
            while (multiTsFileDeviceIterator.hasNextDevice()) {
                Pair deviceInfo = multiTsFileDeviceIterator.nextDevice();
                Assert.assertEquals(deviceIds.get(deviceNum), (Object)deviceInfo.left);
                if (Integer.parseInt(((PlainDeviceID)deviceInfo.left).toStringID().substring(13)) < 10) {
                    Assert.assertTrue((boolean)((Boolean)deviceInfo.right));
                } else {
                    Assert.assertFalse((boolean)((Boolean)deviceInfo.right));
                }
                ++deviceNum;
            }
        }
        Assert.assertEquals((long)30L, (long)deviceNum);
        ArrayList<PartialPath> timeseriesPaths = new ArrayList<PartialPath>();
        for (int i4 = 0; i4 < 30; ++i4) {
            for (int j3 = 0; j3 < 15; ++j3) {
                if (i4 < 10) {
                    timeseriesPaths.add((PartialPath)new AlignedPath(COMPACTION_TEST_SG + '.' + "d" + i4, Collections.singletonList("s" + j3), Collections.singletonList(new MeasurementSchema("s" + j3, TSDataType.INT64))));
                    continue;
                }
                timeseriesPaths.add((PartialPath)new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i4 + '.' + "s" + j3, TSDataType.INT64));
            }
        }
        Map<PartialPath, List<TimeValuePair>> sourceData = this.readSourceFiles(timeseriesPaths, Collections.emptyList());
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.tsFileManager.getTsFileList(true), true, (ICompactionPerformer)new ReadPointCompactionPerformer(), 0L);
        Assert.assertTrue((boolean)task.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceData, Collections.emptyList());
        seriesPaths.clear();
        for (i = 0; i < 10; ++i) {
            for (j = 0; j < 15; ++j) {
                seriesPaths.add(COMPACTION_TEST_SG + '.' + "d" + i + '.' + "s" + j);
            }
        }
        this.generateModsFile(seriesPaths, this.tsFileManager.getTsFileList(true), Long.MIN_VALUE, Long.MAX_VALUE);
        this.deleteTimeseriesInMManager(seriesPaths);
        this.createFiles(1, 10, 5, 100, 2000, 2000, 50, 50, false, true);
        this.tsFileManager.add((TsFileResource)this.seqResources.get(this.seqResources.size() - 1), true);
        timeseriesPaths.clear();
        for (i = 0; i < 30; ++i) {
            for (j = 0; j < 15; ++j) {
                timeseriesPaths.add((PartialPath)new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i + '.' + "s" + j, TSDataType.INT64));
            }
        }
        sourceData = this.readSourceFiles(timeseriesPaths, Collections.emptyList());
        deviceNum = 0;
        try (MultiTsFileDeviceIterator multiTsFileDeviceIterator = new MultiTsFileDeviceIterator(this.tsFileManager.getTsFileList(true));){
            while (multiTsFileDeviceIterator.hasNextDevice()) {
                Pair deviceInfo = multiTsFileDeviceIterator.nextDevice();
                Assert.assertEquals(deviceIds.get(deviceNum), (Object)deviceInfo.left);
                Assert.assertFalse((boolean)((Boolean)deviceInfo.right));
                ++deviceNum;
            }
        }
        Assert.assertEquals((long)30L, (long)deviceNum);
        TsFileGeneratorUtils.alignDeviceOffset = oldAlignedDeviceOffset;
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getInnerCompactionTargetTsFileResources(this.tsFileManager.getTsFileList(true), true);
        ReadPointCompactionPerformer performer = new ReadPointCompactionPerformer(this.tsFileManager.getTsFileList(true), Collections.emptyList(), targetResources);
        performer.setSummary(new CompactionTaskSummary());
        performer.perform();
        CompactionUtils.moveTargetFile(targetResources, (boolean)true, (String)COMPACTION_TEST_SG);
        this.tsFileManager.replace(this.tsFileManager.getTsFileList(true), Collections.emptyList(), targetResources, 0L);
        ((TsFileResource)this.tsFileManager.getTsFileList(true).get(0)).setStatusForTest(TsFileResourceStatus.NORMAL);
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceData, Collections.emptyList());
    }

    @Test
    public void getDeletedDevicesWithSameNameFromSeqFilesByReadPointPerformer2() throws Exception {
        int j;
        int i;
        TSFileDescriptor.getInstance().getConfig().setMaxDegreeOfIndexNode(3);
        int oldAlignedDeviceOffset = TsFileGeneratorUtils.alignDeviceOffset;
        TsFileGeneratorUtils.alignDeviceOffset = 0;
        this.registerTimeseriesInMManger(30, 5, true);
        this.createFiles(3, 10, 5, 100, 0, 0, 50, 50, true, true);
        this.createFiles(4, 30, 5, 100, 1000, 0, 50, 50, true, true);
        ArrayList<String> seriesPaths = new ArrayList<String>();
        for (int i2 = 0; i2 < 10; ++i2) {
            for (int j2 = 0; j2 < 5; ++j2) {
                seriesPaths.add(COMPACTION_TEST_SG + '.' + "d" + i2 + '.' + "s" + j2);
            }
        }
        this.generateModsFile(seriesPaths, this.seqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        this.generateModsFile(seriesPaths, this.unseqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        this.deleteTimeseriesInMManager(seriesPaths);
        this.createFiles(2, 10, 15, 100, 2000, 2000, 50, 50, false, true);
        this.resetFileName((TsFileResource)this.seqResources.get(7), 100);
        this.resetFileName((TsFileResource)this.seqResources.get(8), 101);
        this.tsFileManager.addAll(this.seqResources, true);
        ArrayList<PlainDeviceID> deviceIds = new ArrayList<PlainDeviceID>();
        for (int i3 = 0; i3 < 30; ++i3) {
            deviceIds.add(new PlainDeviceID("root.testsg.d" + (i3 + TsFileGeneratorUtils.getAlignDeviceOffset())));
        }
        deviceIds.sort(Comparable::compareTo);
        int deviceNum = 0;
        try (MultiTsFileDeviceIterator multiTsFileDeviceIterator = new MultiTsFileDeviceIterator(this.tsFileManager.getTsFileList(true));){
            while (multiTsFileDeviceIterator.hasNextDevice()) {
                Pair deviceInfo = multiTsFileDeviceIterator.nextDevice();
                Assert.assertEquals(deviceIds.get(deviceNum), (Object)deviceInfo.left);
                if (Integer.parseInt(((PlainDeviceID)deviceInfo.left).toStringID().substring(13)) < 10) {
                    Assert.assertFalse((boolean)((Boolean)deviceInfo.right));
                } else {
                    Assert.assertTrue((boolean)((Boolean)deviceInfo.right));
                }
                ++deviceNum;
            }
        }
        Assert.assertEquals((long)30L, (long)deviceNum);
        ArrayList<PartialPath> timeseriesPaths = new ArrayList<PartialPath>();
        for (int i4 = 0; i4 < 30; ++i4) {
            for (int j3 = 0; j3 < 15; ++j3) {
                if (i4 < 10) {
                    timeseriesPaths.add((PartialPath)new AlignedPath(COMPACTION_TEST_SG + '.' + "d" + i4, Collections.singletonList("s" + j3), Collections.singletonList(new MeasurementSchema("s" + j3, TSDataType.INT64))));
                    continue;
                }
                timeseriesPaths.add((PartialPath)new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i4 + '.' + "s" + j3, TSDataType.INT64));
            }
        }
        Map<PartialPath, List<TimeValuePair>> sourceData = this.readSourceFiles(timeseriesPaths, Collections.emptyList());
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.tsFileManager.getTsFileList(true), true, (ICompactionPerformer)new ReadPointCompactionPerformer(), 0L);
        Assert.assertTrue((boolean)task.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceData, Collections.emptyList());
        seriesPaths.clear();
        for (i = 0; i < 10; ++i) {
            for (j = 0; j < 15; ++j) {
                seriesPaths.add(COMPACTION_TEST_SG + '.' + "d" + i + '.' + "s" + j);
            }
        }
        this.generateModsFile(seriesPaths, this.tsFileManager.getTsFileList(true), Long.MIN_VALUE, Long.MAX_VALUE);
        this.deleteTimeseriesInMManager(seriesPaths);
        this.createFiles(1, 10, 5, 100, 2000, 2000, 50, 50, true, true);
        this.tsFileManager.add((TsFileResource)this.seqResources.get(this.seqResources.size() - 1), true);
        timeseriesPaths.clear();
        for (i = 0; i < 30; ++i) {
            for (j = 0; j < 15; ++j) {
                timeseriesPaths.add((PartialPath)new AlignedPath(COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), Collections.singletonList(new MeasurementSchema("s" + j, TSDataType.INT64))));
            }
        }
        sourceData = this.readSourceFiles(timeseriesPaths, Collections.emptyList());
        deviceIds = new ArrayList();
        for (i = 0; i < 30; ++i) {
            deviceIds.add(new PlainDeviceID("root.testsg.d" + (i + TsFileGeneratorUtils.getAlignDeviceOffset())));
        }
        deviceIds.sort(Comparable::compareTo);
        deviceNum = 0;
        try (MultiTsFileDeviceIterator multiTsFileDeviceIterator = new MultiTsFileDeviceIterator(this.tsFileManager.getTsFileList(true));){
            while (multiTsFileDeviceIterator.hasNextDevice()) {
                Pair deviceInfo = multiTsFileDeviceIterator.nextDevice();
                Assert.assertEquals(deviceIds.get(deviceNum), (Object)deviceInfo.left);
                Assert.assertTrue((boolean)((Boolean)deviceInfo.right));
                ++deviceNum;
            }
        }
        Assert.assertEquals((long)30L, (long)deviceNum);
        TsFileGeneratorUtils.alignDeviceOffset = oldAlignedDeviceOffset;
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getInnerCompactionTargetTsFileResources(this.tsFileManager.getTsFileList(true), true);
        ReadPointCompactionPerformer performer = new ReadPointCompactionPerformer(this.tsFileManager.getTsFileList(true), Collections.emptyList(), targetResources);
        performer.setSummary(new CompactionTaskSummary());
        performer.perform();
        CompactionUtils.moveTargetFile(targetResources, (boolean)true, (String)COMPACTION_TEST_SG);
        this.tsFileManager.replace(this.tsFileManager.getTsFileList(true), Collections.emptyList(), targetResources, 0L);
        ((TsFileResource)this.tsFileManager.getTsFileList(true).get(0)).setStatusForTest(TsFileResourceStatus.NORMAL);
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceData, Collections.emptyList());
    }

    @Test
    public void getDeletedDevicesWithSameNameFromSeqFilesByFastPerformer() throws Exception {
        int j;
        int i;
        TSFileDescriptor.getInstance().getConfig().setMaxDegreeOfIndexNode(3);
        int oldAlignedDeviceOffset = TsFileGeneratorUtils.alignDeviceOffset;
        TsFileGeneratorUtils.alignDeviceOffset = 0;
        this.registerTimeseriesInMManger(30, 5, false);
        this.createFiles(3, 10, 5, 100, 0, 0, 50, 50, false, true);
        this.createFiles(4, 30, 5, 100, 1000, 0, 50, 50, false, true);
        ArrayList<String> seriesPaths = new ArrayList<String>();
        for (int i2 = 0; i2 < 10; ++i2) {
            for (int j2 = 0; j2 < 5; ++j2) {
                seriesPaths.add(COMPACTION_TEST_SG + '.' + "d" + i2 + '.' + "s" + j2);
            }
        }
        this.generateModsFile(seriesPaths, this.seqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        this.generateModsFile(seriesPaths, this.unseqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        this.deleteTimeseriesInMManager(seriesPaths);
        this.createFiles(2, 10, 15, 100, 2000, 2000, 50, 50, true, true);
        this.resetFileName((TsFileResource)this.seqResources.get(7), 100);
        this.resetFileName((TsFileResource)this.seqResources.get(8), 101);
        this.tsFileManager.addAll(this.seqResources, true);
        ArrayList<PlainDeviceID> deviceIds = new ArrayList<PlainDeviceID>();
        for (int i3 = 0; i3 < 30; ++i3) {
            deviceIds.add(new PlainDeviceID("root.testsg.d" + (i3 + TsFileGeneratorUtils.getAlignDeviceOffset())));
        }
        deviceIds.sort(Comparable::compareTo);
        int deviceNum = 0;
        try (MultiTsFileDeviceIterator multiTsFileDeviceIterator = new MultiTsFileDeviceIterator(this.tsFileManager.getTsFileList(true));){
            while (multiTsFileDeviceIterator.hasNextDevice()) {
                Pair deviceInfo = multiTsFileDeviceIterator.nextDevice();
                Assert.assertEquals(deviceIds.get(deviceNum), (Object)deviceInfo.left);
                if (Integer.parseInt(((PlainDeviceID)deviceInfo.left).toStringID().substring(13)) < 10) {
                    Assert.assertTrue((boolean)((Boolean)deviceInfo.right));
                } else {
                    Assert.assertFalse((boolean)((Boolean)deviceInfo.right));
                }
                ++deviceNum;
            }
        }
        Assert.assertEquals((long)30L, (long)deviceNum);
        ArrayList<PartialPath> timeseriesPaths = new ArrayList<PartialPath>();
        for (int i4 = 0; i4 < 30; ++i4) {
            for (int j3 = 0; j3 < 15; ++j3) {
                if (i4 < 10) {
                    timeseriesPaths.add((PartialPath)new AlignedPath(COMPACTION_TEST_SG + '.' + "d" + i4, Collections.singletonList("s" + j3), Collections.singletonList(new MeasurementSchema("s" + j3, TSDataType.INT64))));
                    continue;
                }
                timeseriesPaths.add((PartialPath)new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i4 + '.' + "s" + j3, TSDataType.INT64));
            }
        }
        Map<PartialPath, List<TimeValuePair>> sourceData = this.readSourceFiles(timeseriesPaths, Collections.emptyList());
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.tsFileManager.getTsFileList(true), true, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertTrue((boolean)task.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceData, Collections.emptyList());
        seriesPaths.clear();
        for (i = 0; i < 10; ++i) {
            for (j = 0; j < 15; ++j) {
                seriesPaths.add(COMPACTION_TEST_SG + '.' + "d" + i + '.' + "s" + j);
            }
        }
        this.generateModsFile(seriesPaths, this.tsFileManager.getTsFileList(true), Long.MIN_VALUE, Long.MAX_VALUE);
        this.deleteTimeseriesInMManager(seriesPaths);
        this.createFiles(1, 10, 5, 100, 2000, 2000, 50, 50, false, true);
        this.tsFileManager.add((TsFileResource)this.seqResources.get(this.seqResources.size() - 1), true);
        timeseriesPaths.clear();
        for (i = 0; i < 30; ++i) {
            for (j = 0; j < 15; ++j) {
                timeseriesPaths.add((PartialPath)new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i + '.' + "s" + j, TSDataType.INT64));
            }
        }
        sourceData = this.readSourceFiles(timeseriesPaths, Collections.emptyList());
        deviceNum = 0;
        try (MultiTsFileDeviceIterator multiTsFileDeviceIterator = new MultiTsFileDeviceIterator(this.tsFileManager.getTsFileList(true));){
            while (multiTsFileDeviceIterator.hasNextDevice()) {
                Pair deviceInfo = multiTsFileDeviceIterator.nextDevice();
                Assert.assertEquals(deviceIds.get(deviceNum), (Object)deviceInfo.left);
                Assert.assertFalse((boolean)((Boolean)deviceInfo.right));
                ++deviceNum;
            }
        }
        Assert.assertEquals((long)30L, (long)deviceNum);
        TsFileGeneratorUtils.alignDeviceOffset = oldAlignedDeviceOffset;
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getInnerCompactionTargetTsFileResources(this.tsFileManager.getTsFileList(true), true);
        FastCompactionPerformer performer = new FastCompactionPerformer(this.tsFileManager.getTsFileList(true), Collections.emptyList(), targetResources);
        performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        performer.perform();
        CompactionUtils.moveTargetFile(targetResources, (boolean)true, (String)COMPACTION_TEST_SG);
        this.tsFileManager.replace(this.tsFileManager.getTsFileList(true), Collections.emptyList(), targetResources, 0L);
        ((TsFileResource)this.tsFileManager.getTsFileList(true).get(0)).setStatusForTest(TsFileResourceStatus.NORMAL);
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceData, Collections.emptyList());
    }

    @Test
    public void getDeletedDevicesWithSameNameFromSeqFilesByFastPerformer2() throws Exception {
        int j;
        int i;
        TSFileDescriptor.getInstance().getConfig().setMaxDegreeOfIndexNode(3);
        int oldAlignedDeviceOffset = TsFileGeneratorUtils.alignDeviceOffset;
        TsFileGeneratorUtils.alignDeviceOffset = 0;
        this.registerTimeseriesInMManger(30, 5, true);
        this.createFiles(3, 10, 5, 100, 0, 0, 50, 50, true, true);
        this.createFiles(4, 30, 5, 100, 1000, 0, 50, 50, true, true);
        ArrayList<String> seriesPaths = new ArrayList<String>();
        for (int i2 = 0; i2 < 10; ++i2) {
            for (int j2 = 0; j2 < 5; ++j2) {
                seriesPaths.add(COMPACTION_TEST_SG + '.' + "d" + i2 + '.' + "s" + j2);
            }
        }
        this.generateModsFile(seriesPaths, this.seqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        this.generateModsFile(seriesPaths, this.unseqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        this.deleteTimeseriesInMManager(seriesPaths);
        this.createFiles(2, 10, 15, 100, 2000, 2000, 50, 50, false, true);
        this.resetFileName((TsFileResource)this.seqResources.get(7), 100);
        this.resetFileName((TsFileResource)this.seqResources.get(8), 101);
        this.tsFileManager.addAll(this.seqResources, true);
        ArrayList<PlainDeviceID> deviceIds = new ArrayList<PlainDeviceID>();
        for (int i3 = 0; i3 < 30; ++i3) {
            deviceIds.add(new PlainDeviceID("root.testsg.d" + (i3 + TsFileGeneratorUtils.getAlignDeviceOffset())));
        }
        deviceIds.sort(Comparable::compareTo);
        int deviceNum = 0;
        try (MultiTsFileDeviceIterator multiTsFileDeviceIterator = new MultiTsFileDeviceIterator(this.tsFileManager.getTsFileList(true));){
            while (multiTsFileDeviceIterator.hasNextDevice()) {
                Pair deviceInfo = multiTsFileDeviceIterator.nextDevice();
                Assert.assertEquals(deviceIds.get(deviceNum), (Object)deviceInfo.left);
                if (Integer.parseInt(((PlainDeviceID)deviceInfo.left).toStringID().substring(13)) < 10) {
                    Assert.assertFalse((boolean)((Boolean)deviceInfo.right));
                } else {
                    Assert.assertTrue((boolean)((Boolean)deviceInfo.right));
                }
                ++deviceNum;
            }
        }
        Assert.assertEquals((long)30L, (long)deviceNum);
        ArrayList<PartialPath> timeseriesPaths = new ArrayList<PartialPath>();
        for (int i4 = 0; i4 < 30; ++i4) {
            for (int j3 = 0; j3 < 15; ++j3) {
                if (i4 < 10) {
                    timeseriesPaths.add((PartialPath)new AlignedPath(COMPACTION_TEST_SG + '.' + "d" + i4, Collections.singletonList("s" + j3), Collections.singletonList(new MeasurementSchema("s" + j3, TSDataType.INT64))));
                    continue;
                }
                timeseriesPaths.add((PartialPath)new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i4 + '.' + "s" + j3, TSDataType.INT64));
            }
        }
        Map<PartialPath, List<TimeValuePair>> sourceData = this.readSourceFiles(timeseriesPaths, Collections.emptyList());
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.tsFileManager.getTsFileList(true), true, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertTrue((boolean)task.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceData, Collections.emptyList());
        seriesPaths.clear();
        for (i = 0; i < 10; ++i) {
            for (j = 0; j < 15; ++j) {
                seriesPaths.add(COMPACTION_TEST_SG + '.' + "d" + i + '.' + "s" + j);
            }
        }
        this.generateModsFile(seriesPaths, this.tsFileManager.getTsFileList(true), Long.MIN_VALUE, Long.MAX_VALUE);
        this.deleteTimeseriesInMManager(seriesPaths);
        this.createFiles(1, 10, 5, 100, 2000, 2000, 50, 50, true, true);
        this.tsFileManager.add((TsFileResource)this.seqResources.get(this.seqResources.size() - 1), true);
        timeseriesPaths.clear();
        for (i = 0; i < 30; ++i) {
            for (j = 0; j < 15; ++j) {
                timeseriesPaths.add((PartialPath)new AlignedPath(COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), Collections.singletonList(new MeasurementSchema("s" + j, TSDataType.INT64))));
            }
        }
        sourceData = this.readSourceFiles(timeseriesPaths, Collections.emptyList());
        deviceIds = new ArrayList();
        for (i = 0; i < 30; ++i) {
            deviceIds.add(new PlainDeviceID("root.testsg.d" + (i + TsFileGeneratorUtils.getAlignDeviceOffset())));
        }
        deviceIds.sort(Comparable::compareTo);
        deviceNum = 0;
        try (MultiTsFileDeviceIterator multiTsFileDeviceIterator = new MultiTsFileDeviceIterator(this.tsFileManager.getTsFileList(true));){
            while (multiTsFileDeviceIterator.hasNextDevice()) {
                Pair deviceInfo = multiTsFileDeviceIterator.nextDevice();
                Assert.assertEquals(deviceIds.get(deviceNum), (Object)deviceInfo.left);
                Assert.assertTrue((boolean)((Boolean)deviceInfo.right));
                ++deviceNum;
            }
        }
        Assert.assertEquals((long)30L, (long)deviceNum);
        TsFileGeneratorUtils.alignDeviceOffset = oldAlignedDeviceOffset;
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getInnerCompactionTargetTsFileResources(this.tsFileManager.getTsFileList(true), true);
        FastCompactionPerformer performer = new FastCompactionPerformer(this.tsFileManager.getTsFileList(true), Collections.emptyList(), targetResources);
        performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        performer.perform();
        CompactionUtils.moveTargetFile(targetResources, (boolean)true, (String)COMPACTION_TEST_SG);
        this.tsFileManager.replace(this.tsFileManager.getTsFileList(true), Collections.emptyList(), targetResources, 0L);
        ((TsFileResource)this.tsFileManager.getTsFileList(true).get(0)).setStatusForTest(TsFileResourceStatus.NORMAL);
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceData, Collections.emptyList());
    }
}

