/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.utils;

import java.io.IOException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.service.metrics.FileMetrics;
import org.apache.iotdb.db.storageengine.dataregion.compaction.AbstractCompactionTest;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.ICompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.ICrossCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.FastCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.ReadChunkCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CrossSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.InnerSpaceCompactionTask;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompactionUpdateFileCountTest
extends AbstractCompactionTest {
    @Override
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException, InterruptedException {
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        super.tearDown();
    }

    @Test
    public void testSeqSpaceCompactionFileMetric() throws MetadataException, IOException, WriteProcessException {
        this.registerTimeseriesInMManger(2, 3, false);
        long initSeqFileNum = FileMetrics.getInstance().getFileCount(true);
        long initUnSeqFileNum = FileMetrics.getInstance().getFileCount(false);
        this.createFiles(1, 2, 3, 100, 1, 0, 50, 0, false, true);
        this.createFiles(1, 2, 3, 50, 200, 30000, 50, 50, false, true);
        this.tsFileManager.addAll(this.seqResources, true);
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, true, (ICompactionPerformer)new ReadChunkCompactionPerformer(), 0L);
        Assert.assertTrue((boolean)task.start());
        Assert.assertEquals((long)(initSeqFileNum - 1L), (long)FileMetrics.getInstance().getFileCount(true));
        Assert.assertEquals((long)initUnSeqFileNum, (long)FileMetrics.getInstance().getFileCount(false));
    }

    @Test
    public void testUnSeqSpaceCompactionFileMetric() throws MetadataException, IOException, WriteProcessException {
        this.registerTimeseriesInMManger(2, 3, false);
        long initSeqFileNum = FileMetrics.getInstance().getFileCount(true);
        long initUnSeqFileNum = FileMetrics.getInstance().getFileCount(false);
        this.createFiles(1, 2, 3, 100, 1, 0, 50, 0, false, false);
        this.createFiles(1, 2, 3, 50, 20, 10000, 50, 50, false, false);
        this.tsFileManager.addAll(this.unseqResources, false);
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.unseqResources, false, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertTrue((boolean)task.start());
        Assert.assertEquals((long)initSeqFileNum, (long)FileMetrics.getInstance().getFileCount(true));
        Assert.assertEquals((long)(initUnSeqFileNum - 1L), (long)FileMetrics.getInstance().getFileCount(false));
    }

    @Test
    public void testCrossSpaceCompactionFileMetric() throws MetadataException, IOException, WriteProcessException {
        this.registerTimeseriesInMManger(2, 3, false);
        long initSeqFileNum = FileMetrics.getInstance().getFileCount(true);
        long initUnSeqFileNum = FileMetrics.getInstance().getFileCount(false);
        this.createFiles(1, 2, 3, 100, 1, 0, 50, 0, false, true);
        this.createFiles(3, 2, 3, 50, 20, 10000, 50, 50, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionTask task = new CrossSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, this.unseqResources, (ICrossCompactionPerformer)new FastCompactionPerformer(true), 0L, 0L);
        Assert.assertTrue((boolean)task.start());
        Assert.assertEquals((long)initSeqFileNum, (long)FileMetrics.getInstance().getFileCount(true));
        Assert.assertEquals((long)(initUnSeqFileNum - 3L), (long)FileMetrics.getInstance().getFileCount(false));
    }
}

