/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.utils;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.PlainDeviceID;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.write.chunk.AlignedChunkWriterImpl;
import org.apache.iotdb.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.iotdb.tsfile.write.page.PageWriter;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;

public class CompactionTestFileWriter
implements Closeable {
    private TsFileResource resource;
    private TsFileIOWriter fileWriter;
    private static final String SG_NAME = "root.testsg";
    private IDeviceID currentDeviceId;
    private long currentDeviceStartTime;
    private long currentDeviceEndTime;

    public CompactionTestFileWriter(TsFileResource emptyFile) throws IOException {
        this.resource = emptyFile;
        this.fileWriter = new TsFileIOWriter(emptyFile.getTsFile());
    }

    public IDeviceID startChunkGroup(String deviceNameWithoutParentPath) throws IOException {
        this.currentDeviceId = new PlainDeviceID("root.testsg." + deviceNameWithoutParentPath);
        this.fileWriter.startChunkGroup(this.currentDeviceId);
        this.currentDeviceStartTime = Long.MAX_VALUE;
        this.currentDeviceEndTime = Long.MIN_VALUE;
        return this.currentDeviceId;
    }

    public void endChunkGroup() throws IOException {
        this.resource.updateStartTime(this.currentDeviceId, this.currentDeviceStartTime);
        this.resource.updateEndTime(this.currentDeviceId, this.currentDeviceEndTime);
        this.fileWriter.endChunkGroup();
    }

    public void endFile() throws IOException {
        this.fileWriter.endFile();
        this.resource.serialize();
    }

    @Override
    public void close() throws IOException {
        this.fileWriter.close();
    }

    public void generateSimpleNonAlignedSeriesToCurrentDevice(String measurementName, TimeRange[] toGenerateChunkTimeRanges, TSEncoding encoding, CompressionType compressionType) throws IOException {
        MeasurementSchema schema = new MeasurementSchema(measurementName, TSDataType.INT32, encoding, compressionType);
        for (TimeRange timeRange : toGenerateChunkTimeRanges) {
            ChunkWriterImpl chunkWriter = new ChunkWriterImpl((IMeasurementSchema)schema);
            this.currentDeviceStartTime = Math.min(timeRange.getMin(), this.currentDeviceStartTime);
            this.currentDeviceEndTime = Math.max(timeRange.getMax(), this.currentDeviceEndTime);
            for (long time = timeRange.getMin(); time <= timeRange.getMax(); ++time) {
                chunkWriter.write(time, new Random().nextInt());
            }
            chunkWriter.sealCurrentPage();
            chunkWriter.writeToFileWriter(this.fileWriter);
        }
    }

    public void generateSimpleNonAlignedSeriesToCurrentDevice(String measurementName, TimeRange[][] toGenerateChunkPageTimeRanges, TSEncoding encoding, CompressionType compressionType) throws IOException {
        MeasurementSchema schema = new MeasurementSchema(measurementName, TSDataType.INT32, encoding, compressionType);
        for (TimeRange[] toGenerateChunk : toGenerateChunkPageTimeRanges) {
            ChunkWriterImpl chunkWriter = new ChunkWriterImpl((IMeasurementSchema)schema);
            for (TimeRange toGeneratePage : toGenerateChunk) {
                PageWriter pageWriter = chunkWriter.getPageWriter();
                this.currentDeviceStartTime = Math.min(toGeneratePage.getMin(), this.currentDeviceStartTime);
                this.currentDeviceEndTime = Math.max(toGeneratePage.getMax(), this.currentDeviceEndTime);
                for (long time = toGeneratePage.getMin(); time <= toGeneratePage.getMax(); ++time) {
                    pageWriter.write(time, new Random().nextInt());
                }
                chunkWriter.sealCurrentPage();
            }
            chunkWriter.writeToFileWriter(this.fileWriter);
        }
    }

    public void generateSimpleNonAlignedSeriesToCurrentDevice(String measurementName, TimeRange[][][] toGenerateChunkPagePointsTimeRanges, TSEncoding encoding, CompressionType compressionType) throws IOException {
        MeasurementSchema schema = new MeasurementSchema(measurementName, TSDataType.INT32, encoding, compressionType);
        for (TimeRange[][] toGenerateChunk : toGenerateChunkPagePointsTimeRanges) {
            ChunkWriterImpl chunkWriter = new ChunkWriterImpl((IMeasurementSchema)schema);
            for (TimeRange[] toGeneratePage : toGenerateChunk) {
                PageWriter pageWriter = chunkWriter.getPageWriter();
                for (TimeRange pagePointTimeRange : toGeneratePage) {
                    this.currentDeviceStartTime = Math.min(pagePointTimeRange.getMin(), this.currentDeviceStartTime);
                    this.currentDeviceEndTime = Math.max(pagePointTimeRange.getMax(), this.currentDeviceEndTime);
                    for (long time = pagePointTimeRange.getMin(); time <= pagePointTimeRange.getMax(); ++time) {
                        pageWriter.write(time, new Random().nextInt());
                    }
                }
                chunkWriter.sealCurrentPage();
            }
            chunkWriter.writeToFileWriter(this.fileWriter);
        }
    }

    public void generateSimpleAlignedSeriesToCurrentDevice(List<String> measurementNames, TimeRange[] toGenerateChunkTimeRanges, TSEncoding encoding, CompressionType compressionType) throws IOException {
        ArrayList<MeasurementSchema> measurementSchemas = new ArrayList<MeasurementSchema>();
        for (String measurementName : measurementNames) {
            measurementSchemas.add(new MeasurementSchema(measurementName, TSDataType.INT32, encoding, compressionType));
        }
        for (TimeRange toGenerateChunk : toGenerateChunkTimeRanges) {
            AlignedChunkWriterImpl alignedChunkWriter = new AlignedChunkWriterImpl(measurementSchemas);
            this.currentDeviceStartTime = Math.min(toGenerateChunk.getMin(), this.currentDeviceStartTime);
            this.currentDeviceEndTime = Math.max(toGenerateChunk.getMax(), this.currentDeviceEndTime);
            for (long time = toGenerateChunk.getMin(); time <= toGenerateChunk.getMax(); ++time) {
                alignedChunkWriter.getTimeChunkWriter().write(time);
                for (int i = 0; i < measurementNames.size(); ++i) {
                    alignedChunkWriter.getValueChunkWriterByIndex(i).write(time, new Random().nextInt(), false);
                }
            }
            alignedChunkWriter.writeToFileWriter(this.fileWriter);
        }
    }

    public void generateSimpleAlignedSeriesToCurrentDeviceWithNullValue(List<String> measurementNames, TimeRange[] toGenerateChunkTimeRanges, TSEncoding encoding, CompressionType compressionType, List<Boolean> nullMeasurements) throws IOException {
        ArrayList<MeasurementSchema> measurementSchemas = new ArrayList<MeasurementSchema>();
        for (String measurementName : measurementNames) {
            measurementSchemas.add(new MeasurementSchema(measurementName, TSDataType.INT32, encoding, compressionType));
        }
        for (TimeRange toGenerateChunk : toGenerateChunkTimeRanges) {
            AlignedChunkWriterImpl alignedChunkWriter = new AlignedChunkWriterImpl(measurementSchemas);
            this.currentDeviceStartTime = Math.min(toGenerateChunk.getMin(), this.currentDeviceStartTime);
            this.currentDeviceEndTime = Math.max(toGenerateChunk.getMax(), this.currentDeviceEndTime);
            for (long time = toGenerateChunk.getMin(); time <= toGenerateChunk.getMax(); ++time) {
                alignedChunkWriter.getTimeChunkWriter().write(time);
                for (int i = 0; i < measurementNames.size(); ++i) {
                    alignedChunkWriter.getValueChunkWriterByIndex(i).write(time, new Random().nextInt(), nullMeasurements.get(i).booleanValue());
                }
            }
            alignedChunkWriter.writeToFileWriter(this.fileWriter);
        }
    }

    public void generateSimpleAlignedSeriesToCurrentDevice(List<String> measurementNames, TimeRange[][] toGenerateChunkPageTimeRanges, TSEncoding encoding, CompressionType compressionType) throws IOException {
        ArrayList<MeasurementSchema> measurementSchemas = new ArrayList<MeasurementSchema>();
        for (String measurementName : measurementNames) {
            measurementSchemas.add(new MeasurementSchema(measurementName, TSDataType.INT32, encoding, compressionType));
        }
        for (TimeRange[] toGenerateChunk : toGenerateChunkPageTimeRanges) {
            AlignedChunkWriterImpl alignedChunkWriter = new AlignedChunkWriterImpl(measurementSchemas);
            for (TimeRange toGeneratePageTimeRange : toGenerateChunk) {
                this.currentDeviceStartTime = Math.min(toGeneratePageTimeRange.getMin(), this.currentDeviceStartTime);
                this.currentDeviceEndTime = Math.max(toGeneratePageTimeRange.getMax(), this.currentDeviceEndTime);
                for (long time = toGeneratePageTimeRange.getMin(); time <= toGeneratePageTimeRange.getMax(); ++time) {
                    alignedChunkWriter.getTimeChunkWriter().getPageWriter().write(time);
                    for (int i = 0; i < measurementNames.size(); ++i) {
                        alignedChunkWriter.getValueChunkWriterByIndex(i).getPageWriter().write(time, new Random().nextInt(), false);
                    }
                }
                alignedChunkWriter.sealCurrentPage();
            }
            alignedChunkWriter.writeToFileWriter(this.fileWriter);
        }
    }

    public void generateSimpleAlignedSeriesToCurrentDeviceWithNullValue(List<String> measurementNames, TimeRange[][] toGenerateChunkPageTimeRanges, TSEncoding encoding, CompressionType compressionType, List<Boolean> nullMeasurement) throws IOException {
        ArrayList<MeasurementSchema> measurementSchemas = new ArrayList<MeasurementSchema>();
        for (String measurementName : measurementNames) {
            measurementSchemas.add(new MeasurementSchema(measurementName, TSDataType.INT32, encoding, compressionType));
        }
        for (TimeRange[] toGenerateChunk : toGenerateChunkPageTimeRanges) {
            AlignedChunkWriterImpl alignedChunkWriter = new AlignedChunkWriterImpl(measurementSchemas);
            for (TimeRange toGeneratePageTimeRange : toGenerateChunk) {
                this.currentDeviceStartTime = Math.min(toGeneratePageTimeRange.getMin(), this.currentDeviceStartTime);
                this.currentDeviceEndTime = Math.max(toGeneratePageTimeRange.getMax(), this.currentDeviceEndTime);
                for (long time = toGeneratePageTimeRange.getMin(); time <= toGeneratePageTimeRange.getMax(); ++time) {
                    alignedChunkWriter.getTimeChunkWriter().getPageWriter().write(time);
                    for (int i = 0; i < measurementNames.size(); ++i) {
                        alignedChunkWriter.getValueChunkWriterByIndex(i).getPageWriter().write(time, new Random().nextInt(), nullMeasurement.get(i).booleanValue());
                    }
                }
                alignedChunkWriter.sealCurrentPage();
            }
            alignedChunkWriter.writeToFileWriter(this.fileWriter);
        }
    }

    public void generateSimpleAlignedSeriesToCurrentDevice(List<String> measurementNames, TimeRange[][][] toGenerateChunkPageTimeRanges, TSEncoding encoding, CompressionType compressionType) throws IOException {
        ArrayList<MeasurementSchema> measurementSchemas = new ArrayList<MeasurementSchema>();
        for (String measurementName : measurementNames) {
            measurementSchemas.add(new MeasurementSchema(measurementName, TSDataType.INT32, encoding, compressionType));
        }
        for (TimeRange[][] toGenerateChunk : toGenerateChunkPageTimeRanges) {
            AlignedChunkWriterImpl alignedChunkWriter = new AlignedChunkWriterImpl(measurementSchemas);
            TimeRange[][] timeRangeArray = toGenerateChunk;
            int n = timeRangeArray.length;
            for (int i = 0; i < n; ++i) {
                TimeRange[] toGeneratePageTimeRanges;
                for (TimeRange pointsTimeRange : toGeneratePageTimeRanges = timeRangeArray[i]) {
                    this.currentDeviceStartTime = Math.min(pointsTimeRange.getMin(), this.currentDeviceStartTime);
                    this.currentDeviceEndTime = Math.max(pointsTimeRange.getMax(), this.currentDeviceEndTime);
                    for (long time = pointsTimeRange.getMin(); time <= pointsTimeRange.getMax(); ++time) {
                        alignedChunkWriter.getTimeChunkWriter().getPageWriter().write(time);
                        for (int i2 = 0; i2 < measurementNames.size(); ++i2) {
                            alignedChunkWriter.getValueChunkWriterByIndex(i2).getPageWriter().write(time, new Random().nextInt(), false);
                        }
                    }
                }
                alignedChunkWriter.sealCurrentPage();
            }
            alignedChunkWriter.writeToFileWriter(this.fileWriter);
        }
    }

    public void generateSimpleAlignedSeriesToCurrentDeviceWithNullValue(List<String> measurementNames, TimeRange[][][] toGenerateChunkPageTimeRanges, TSEncoding encoding, CompressionType compressionType, List<Boolean> nullMeasurements) throws IOException {
        ArrayList<MeasurementSchema> measurementSchemas = new ArrayList<MeasurementSchema>();
        for (String measurementName : measurementNames) {
            measurementSchemas.add(new MeasurementSchema(measurementName, TSDataType.INT32, encoding, compressionType));
        }
        for (TimeRange[][] toGenerateChunk : toGenerateChunkPageTimeRanges) {
            AlignedChunkWriterImpl alignedChunkWriter = new AlignedChunkWriterImpl(measurementSchemas);
            TimeRange[][] timeRangeArray = toGenerateChunk;
            int n = timeRangeArray.length;
            for (int i = 0; i < n; ++i) {
                TimeRange[] toGeneratePageTimeRanges;
                for (TimeRange pointsTimeRange : toGeneratePageTimeRanges = timeRangeArray[i]) {
                    this.currentDeviceStartTime = Math.min(pointsTimeRange.getMin(), this.currentDeviceStartTime);
                    this.currentDeviceEndTime = Math.max(pointsTimeRange.getMax(), this.currentDeviceEndTime);
                    for (long time = pointsTimeRange.getMin(); time <= pointsTimeRange.getMax(); ++time) {
                        alignedChunkWriter.getTimeChunkWriter().getPageWriter().write(time);
                        for (int i2 = 0; i2 < measurementNames.size(); ++i2) {
                            alignedChunkWriter.getValueChunkWriterByIndex(i2).getPageWriter().write(time, new Random().nextInt(), nullMeasurements.get(i2).booleanValue());
                        }
                    }
                }
                alignedChunkWriter.sealCurrentPage();
            }
            alignedChunkWriter.writeToFileWriter(this.fileWriter);
        }
    }

    public TsFileIOWriter getFileWriter() {
        return this.fileWriter;
    }
}

