/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.AbstractCompactionTest;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.ICompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.ReadChunkCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.AbstractCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.InnerSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionTaskQueue;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.comparator.DefaultCompactionTaskComparatorImpl;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.rescon.memory.SystemInfo;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class CompactionTaskQueueTest
extends AbstractCompactionTest {
    private final long originalMemorySizeForCompaction = SystemInfo.getInstance().getMemorySizeForCompaction();
    private final int originalFileNumLimitForCompaction = SystemInfo.getInstance().getTotalFileLimitForCompaction();

    @Before
    public void setup() {
        SystemInfo.getInstance().getCompactionMemoryCost().set(0L);
        SystemInfo.getInstance().getCompactionFileNumCost().set(0);
        SystemInfo.getInstance().setMemorySizeForCompaction(2000L);
        SystemInfo.getInstance().setTotalFileLimitForCompactionTask(50);
    }

    @After
    public void teardown() {
        SystemInfo.getInstance().getCompactionMemoryCost().set(0L);
        SystemInfo.getInstance().getCompactionFileNumCost().set(0);
        SystemInfo.getInstance().setMemorySizeForCompaction(this.originalMemorySizeForCompaction);
        SystemInfo.getInstance().setTotalFileLimitForCompactionTask(this.originalFileNumLimitForCompaction);
    }

    @Test
    public void testPutAndTake() throws InterruptedException, IOException, MetadataException, WriteProcessException {
        AbstractCompactionTask mockTask = this.prepareTask(1000L, 10);
        CompactionTaskQueue queue = new CompactionTaskQueue(50, (Comparator)new DefaultCompactionTaskComparatorImpl());
        queue.put((Object)mockTask);
        AbstractCompactionTask task = queue.take();
        Assert.assertNotNull((Object)task);
        this.releaseTaskOccupiedResources(task);
        Assert.assertEquals((long)0L, (long)SystemInfo.getInstance().getCompactionMemoryCost().get());
        Assert.assertEquals((long)0L, (long)SystemInfo.getInstance().getCompactionFileNumCost().get());
    }

    @Test
    public void testPutAndTakeWithTaskBlockedByMemoryLimit() throws InterruptedException, IOException, MetadataException, WriteProcessException {
        AbstractCompactionTask mockTask1 = this.prepareTask(1500L, 10);
        AbstractCompactionTask mockTask2 = this.prepareTask(200L, 10);
        AbstractCompactionTask mockTask3 = this.prepareTask(600L, 10);
        CompactionTaskQueue queue = new CompactionTaskQueue(50, (Comparator)new DefaultCompactionTaskComparatorImpl());
        queue.put((Object)mockTask1);
        queue.put((Object)mockTask2);
        queue.put((Object)mockTask3);
        AtomicInteger outTaskNum = new AtomicInteger(0);
        ArrayList<Thread> threadList = new ArrayList<Thread>();
        for (int i = 0; i < 10; ++i) {
            Thread thread = new Thread(() -> {
                AbstractCompactionTask task = null;
                try {
                    task = queue.take();
                    if (task != null) {
                        Thread.sleep(TimeUnit.SECONDS.toMillis(2L));
                        this.releaseTaskOccupiedResources(task);
                        outTaskNum.incrementAndGet();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
            threadList.add(thread);
            thread.start();
        }
        while (outTaskNum.get() != 3) {
            Thread.sleep(TimeUnit.MILLISECONDS.toMillis(100L));
        }
        Assert.assertEquals((long)0L, (long)SystemInfo.getInstance().getCompactionMemoryCost().get());
        Assert.assertEquals((long)0L, (long)SystemInfo.getInstance().getCompactionFileNumCost().get());
        for (Thread thread : threadList) {
            thread.interrupt();
            thread.join();
        }
    }

    @Test
    public void testPutAndTakeWithTaskBlockedByFileNumLimit() throws InterruptedException, IOException, MetadataException, WriteProcessException {
        AbstractCompactionTask mockTask1 = this.prepareTask(500L, 3);
        AbstractCompactionTask mockTask2 = this.prepareTask(200L, 40);
        AbstractCompactionTask mockTask3 = this.prepareTask(600L, 10);
        CompactionTaskQueue queue = new CompactionTaskQueue(50, (Comparator)new DefaultCompactionTaskComparatorImpl());
        queue.put((Object)mockTask1);
        queue.put((Object)mockTask2);
        queue.put((Object)mockTask3);
        AtomicInteger outTaskNum = new AtomicInteger(0);
        ArrayList<Thread> threadList = new ArrayList<Thread>();
        for (int i = 0; i < 10; ++i) {
            Thread thread = new Thread(() -> {
                AbstractCompactionTask task = null;
                try {
                    task = queue.take();
                    if (task != null) {
                        Thread.sleep(TimeUnit.SECONDS.toMillis(2L));
                        this.releaseTaskOccupiedResources(task);
                        outTaskNum.incrementAndGet();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
            threadList.add(thread);
            thread.start();
        }
        while (outTaskNum.get() != 3) {
            Thread.sleep(TimeUnit.MILLISECONDS.toMillis(100L));
        }
        Assert.assertEquals((long)0L, (long)SystemInfo.getInstance().getCompactionMemoryCost().get());
        Assert.assertEquals((long)0L, (long)SystemInfo.getInstance().getCompactionFileNumCost().get());
        for (Thread thread : threadList) {
            thread.interrupt();
            thread.join();
        }
    }

    private AbstractCompactionTask prepareTask(long memCost, int fileNum, long timePartition) throws IOException, MetadataException, WriteProcessException {
        this.createFiles(1, 1, 1, 1, 1, 1, 1, 1, true, true);
        ((TsFileResource)this.seqResources.get(this.seqResources.size() - 1)).setStatusForTest(TsFileResourceStatus.COMPACTION_CANDIDATE);
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(timePartition, this.tsFileManager, Collections.singletonList((TsFileResource)this.seqResources.get(this.seqResources.size() - 1)), true, (ICompactionPerformer)new ReadChunkCompactionPerformer(), 0L);
        InnerSpaceCompactionTask mockTask = (InnerSpaceCompactionTask)Mockito.spy((Object)task);
        ((InnerSpaceCompactionTask)Mockito.doReturn((Object)memCost).when((Object)mockTask)).getEstimatedMemoryCost();
        ((InnerSpaceCompactionTask)Mockito.doReturn((Object)fileNum).when((Object)mockTask)).getProcessedFileNum();
        ((InnerSpaceCompactionTask)Mockito.doReturn((Object)true).when((Object)mockTask)).isDiskSpaceCheckPassed();
        ((InnerSpaceCompactionTask)Mockito.doReturn((Object)1).when((Object)mockTask)).getSumOfCompactionCount();
        ((InnerSpaceCompactionTask)Mockito.doReturn((Object)true).when((Object)mockTask)).isCompactionAllowed();
        return mockTask;
    }

    private AbstractCompactionTask prepareTask(long memCost, int fileNum) throws IOException, MetadataException, WriteProcessException {
        return this.prepareTask(memCost, fileNum, 0L);
    }

    private void releaseTaskOccupiedResources(AbstractCompactionTask task) {
        SystemInfo.getInstance().resetCompactionMemoryCost(task.getCompactionTaskType(), task.getEstimatedMemoryCost());
        SystemInfo.getInstance().decreaseCompactionFileNumCost(task.getProcessedFileNum());
    }
}

