/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.utils;

import java.io.IOException;
import java.util.List;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.AbstractCompactionTest;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.FastCompactionInnerCompactionEstimator;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.FastCrossSpaceCompactionEstimator;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.ReadChunkInnerCompactionEstimator;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompactionTaskMemCostEstimatorTest
extends AbstractCompactionTest {
    @Override
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException, InterruptedException {
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        super.tearDown();
    }

    @Test
    public void testEstimateReadChunkInnerSpaceCompactionTaskMemCost() throws IOException, MetadataException, WriteProcessException {
        this.createFiles(3, 10, 5, 100000, 0, 0, 50, 50, true, true);
        this.tsFileManager.addAll(this.seqResources, true);
        List tsFileList = this.tsFileManager.getTsFileList(true);
        System.out.println(((TsFileResource)tsFileList.get(0)).getTsFile().getAbsolutePath());
        long cost = new ReadChunkInnerCompactionEstimator().estimateInnerCompactionMemory(tsFileList);
        Assert.assertTrue((cost > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testEstimateReadChunkInnerSpaceCompactionTaskMemCost2() throws IOException, MetadataException, WriteProcessException {
        this.createFiles(3, 10, 5, 100, 0, 0, 50, 50, false, true);
        this.tsFileManager.addAll(this.seqResources, true);
        List tsFileList = this.tsFileManager.getTsFileList(true);
        long cost = new ReadChunkInnerCompactionEstimator().estimateInnerCompactionMemory(tsFileList);
        Assert.assertTrue((cost > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testEstimateFastCompactionInnerSpaceCompactionTaskMemCost() throws IOException, MetadataException, WriteProcessException {
        this.createFiles(5, 10, 5, 10000, 0, 0, 50, 50, true, false);
        this.createFiles(10, 4, 5, 10000, 1000, 0, 30, 90, true, false);
        this.tsFileManager.addAll(this.unseqResources, false);
        long cost = new FastCompactionInnerCompactionEstimator().estimateInnerCompactionMemory(this.unseqResources);
        Assert.assertTrue((cost > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testEstimateFastCompactionInnerSpaceCompactionTaskMemCost2() throws IOException, MetadataException, WriteProcessException {
        this.createFiles(3, 10, 5, 100, 0, 0, 50, 50, false, true);
        this.tsFileManager.addAll(this.seqResources, true);
        List tsFileList = this.tsFileManager.getTsFileList(true);
        long cost = new FastCompactionInnerCompactionEstimator().estimateInnerCompactionMemory(tsFileList);
        Assert.assertTrue((cost > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testEstimateFastCompactionCrossSpaceCompactionTaskMemCost1() throws IOException, MetadataException, WriteProcessException {
        this.createFiles(3, 10, 5, 100, 0, 0, 50, 50, false, true);
        this.createFiles(4, 10, 5, 400, 0, 0, 30, 50, false, false);
        long cost = new FastCrossSpaceCompactionEstimator().estimateCrossCompactionMemory(this.seqResources, this.unseqResources);
        Assert.assertTrue((cost > 0L ? 1 : 0) != 0);
    }
}

