/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.storageengine.dataregion.modification.Deletion;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModificationFile;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.generator.TsFileNameGenerator;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.PlainDeviceID;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;

public class CompactionFileGeneratorUtils {
    private static Random random = new Random();

    public static TsFileResource getTargetTsFileResourceFromSourceResource(TsFileResource sourceResource) throws IOException {
        TsFileNameGenerator.TsFileName tsFileName = TsFileNameGenerator.getTsFileName((String)sourceResource.getTsFile().getName());
        return new TsFileResource(new File(TestConstant.BASE_OUTPUT_PATH.concat(tsFileName.getTime() + "-" + tsFileName.getVersion() + "-" + (tsFileName.getInnerCompactionCnt() + 1) + "-" + tsFileName.getCrossCompactionCnt() + ".inner")));
    }

    public static List<TsFileResource> getInnerCompactionTargetTsFileResources(List<TsFileResource> fileResources, boolean seq) throws IOException, DiskSpaceInsufficientException {
        ArrayList<TsFileResource> resources = new ArrayList<TsFileResource>();
        resources.add(TsFileNameGenerator.getInnerCompactionTargetFileResource(fileResources, (boolean)seq));
        return resources;
    }

    public static List<TsFileResource> getCrossCompactionTargetTsFileResources(List<TsFileResource> seqFileResources) throws IOException, DiskSpaceInsufficientException {
        return TsFileNameGenerator.getCrossCompactionTargetFileResources(seqFileResources);
    }

    public static TsFileResource generateTsFileResource(boolean sequence, int index) {
        return CompactionFileGeneratorUtils.generateTsFileResource(sequence, index, "default");
    }

    public static TsFileResource generateTsFileResource(boolean sequence, int index, String storageGroupName) {
        if (sequence) {
            return new TsFileResource(new File(TestConstant.BASE_OUTPUT_PATH.concat(File.separator).concat("data").concat(File.separator).concat("sequence").concat(File.separator).concat(storageGroupName).concat(File.separator).concat("0").concat(File.separator).concat("0").concat(File.separator).concat(index + "-" + index + "-" + 0 + "-" + 0 + ".tsfile")));
        }
        return new TsFileResource(new File(TestConstant.BASE_OUTPUT_PATH.concat(File.separator).concat("data").concat(File.separator).concat("unsequence").concat(File.separator).concat(storageGroupName).concat(File.separator).concat("0").concat(File.separator).concat("0").concat(File.separator).concat(index + 10000 + "-" + (index + 10000) + "-" + 0 + "-" + 0 + ".tsfile")));
    }

    public static void writeTsFile(Set<String> fullPaths, List<List<Long>> chunkPagePointsNum, long startTime, TsFileResource newTsFileResource) throws IOException, IllegalPathException {
        int prevMaxNumberOfPointsInPage = TSFileDescriptor.getInstance().getConfig().getMaxNumberOfPointsInPage();
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(Integer.MAX_VALUE);
        if (!newTsFileResource.getTsFile().getParentFile().exists()) {
            newTsFileResource.getTsFile().getParentFile().mkdirs();
        }
        RestorableTsFileIOWriter writer = new RestorableTsFileIOWriter(newTsFileResource.getTsFile());
        HashMap<IDeviceID, List> deviceMeasurementMap = new HashMap<IDeviceID, List>();
        for (String string : fullPaths) {
            PartialPath partialPath = new PartialPath(string);
            List sensors = deviceMeasurementMap.computeIfAbsent((IDeviceID)new PlainDeviceID(partialPath.getDevice()), s -> new ArrayList());
            sensors.add(partialPath.getMeasurement());
        }
        for (Map.Entry entry : deviceMeasurementMap.entrySet()) {
            IDeviceID device = (IDeviceID)entry.getKey();
            writer.startChunkGroup(device);
            for (String sensor : (List)entry.getValue()) {
                long currTime = startTime;
                for (List<Long> chunk : chunkPagePointsNum) {
                    ChunkWriterImpl chunkWriter = new ChunkWriterImpl((IMeasurementSchema)new MeasurementSchema(sensor, TSDataType.INT64), true);
                    for (Long page : chunk) {
                        for (long i = 0L; i < page; ++i) {
                            chunkWriter.write(currTime, currTime);
                            newTsFileResource.updateStartTime(device, currTime);
                            newTsFileResource.updateEndTime(device, currTime);
                            ++currTime;
                        }
                        chunkWriter.sealCurrentPage();
                    }
                    chunkWriter.writeToFileWriter((TsFileIOWriter)writer);
                }
            }
            writer.endChunkGroup();
        }
        newTsFileResource.serialize();
        writer.endFile();
        newTsFileResource.close();
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(prevMaxNumberOfPointsInPage);
    }

    public static void writeChunkToTsFileWithTimeRange(Set<String> fullPaths, List<List<long[][]>> chunkPagePointsNum, TsFileResource newTsFileResource) throws IOException, IllegalPathException {
        int prevMaxNumberOfPointsInPage = TSFileDescriptor.getInstance().getConfig().getMaxNumberOfPointsInPage();
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(Integer.MAX_VALUE);
        RestorableTsFileIOWriter writer = new RestorableTsFileIOWriter(newTsFileResource.getTsFile());
        HashMap<IDeviceID, List> deviceMeasurementMap = new HashMap<IDeviceID, List>();
        for (String fullPath : fullPaths) {
            PartialPath partialPath = new PartialPath(fullPath);
            List sensors = deviceMeasurementMap.computeIfAbsent((IDeviceID)new PlainDeviceID(partialPath.getDevice()), s -> new ArrayList());
            sensors.add(partialPath.getMeasurement());
        }
        int currChunksIndex = 0;
        for (Map.Entry deviceMeasurementEntry : deviceMeasurementMap.entrySet()) {
            IDeviceID device = (IDeviceID)deviceMeasurementEntry.getKey();
            writer.startChunkGroup(device);
            for (String sensor : (List)deviceMeasurementEntry.getValue()) {
                List<long[][]> chunks = chunkPagePointsNum.get(currChunksIndex);
                ChunkWriterImpl chunkWriter = new ChunkWriterImpl((IMeasurementSchema)new MeasurementSchema(sensor, TSDataType.INT64), true);
                for (long[][] pages : chunks) {
                    for (long[] starEndTime : pages) {
                        for (long i = starEndTime[0]; i < starEndTime[1]; ++i) {
                            chunkWriter.write(i, i);
                            newTsFileResource.updateStartTime(device, i);
                            newTsFileResource.updateEndTime(device, i);
                        }
                    }
                    chunkWriter.sealCurrentPage();
                }
                chunkWriter.writeToFileWriter((TsFileIOWriter)writer);
                ++currChunksIndex;
            }
            writer.endChunkGroup();
        }
        newTsFileResource.serialize();
        writer.endFile();
        newTsFileResource.close();
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(prevMaxNumberOfPointsInPage);
    }

    public static void generateMods(Map<String, Pair<Long, Long>> toDeleteTimeseriesAndTime, TsFileResource targetTsFileResource, boolean isCompactionMods) throws IllegalPathException, IOException {
        ModificationFile modificationFile = isCompactionMods ? ModificationFile.getCompactionMods((TsFileResource)targetTsFileResource) : ModificationFile.getNormalMods((TsFileResource)targetTsFileResource);
        for (Map.Entry<String, Pair<Long, Long>> toDeleteTimeseriesAndTimeEntry : toDeleteTimeseriesAndTime.entrySet()) {
            String fullPath = toDeleteTimeseriesAndTimeEntry.getKey();
            Pair<Long, Long> startTimeEndTime = toDeleteTimeseriesAndTimeEntry.getValue();
            Deletion deletion = new Deletion(new PartialPath(fullPath), Long.MAX_VALUE, ((Long)startTimeEndTime.left).longValue(), ((Long)startTimeEndTime.right).longValue());
            modificationFile.write((Modification)deletion);
        }
        modificationFile.close();
    }

    public static void writeTsFile(Set<String> fullPaths, List<List<Long>> chunkPagePointsNum, long startTime, TsFileResource newTsFileResource, TSEncoding encoding, CompressionType compressionType) throws IOException, IllegalPathException {
        int prevMaxNumberOfPointsInPage = TSFileDescriptor.getInstance().getConfig().getMaxNumberOfPointsInPage();
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(Integer.MAX_VALUE);
        if (!newTsFileResource.getTsFile().getParentFile().exists()) {
            newTsFileResource.getTsFile().getParentFile().mkdirs();
        }
        RestorableTsFileIOWriter writer = new RestorableTsFileIOWriter(newTsFileResource.getTsFile());
        HashMap<IDeviceID, List> deviceMeasurementMap = new HashMap<IDeviceID, List>();
        for (String string : fullPaths) {
            PartialPath partialPath = new PartialPath(string);
            List sensors = deviceMeasurementMap.computeIfAbsent((IDeviceID)new PlainDeviceID(partialPath.getDevice()), s -> new ArrayList());
            sensors.add(partialPath.getMeasurement());
        }
        for (Map.Entry entry : deviceMeasurementMap.entrySet()) {
            IDeviceID device = (IDeviceID)entry.getKey();
            writer.startChunkGroup(device);
            for (String sensor : (List)entry.getValue()) {
                long currTime = startTime;
                for (List<Long> chunk : chunkPagePointsNum) {
                    ChunkWriterImpl chunkWriter = new ChunkWriterImpl((IMeasurementSchema)new MeasurementSchema(sensor, TSDataType.INT64, encoding, compressionType), true);
                    for (Long page : chunk) {
                        for (long i = 0L; i < page; ++i) {
                            chunkWriter.write(currTime, random.nextLong());
                            newTsFileResource.updateStartTime(device, currTime);
                            newTsFileResource.updateEndTime(device, currTime);
                            ++currTime;
                        }
                        chunkWriter.sealCurrentPage();
                    }
                    chunkWriter.writeToFileWriter((TsFileIOWriter)writer);
                }
            }
            writer.endChunkGroup();
        }
        newTsFileResource.serialize();
        writer.endFile();
        newTsFileResource.close();
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(prevMaxNumberOfPointsInPage);
    }
}

