/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.utils;

import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.constant.CrossCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.constant.InnerSeqCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.constant.InnerUnseqCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.constant.CompactionPriority;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.constant.CrossCompactionSelector;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.constant.InnerSequenceCompactionSelector;

public class CompactionConfigRestorer {
    private boolean enableSeqSpaceCompaction = true;
    private boolean enableUnseqSpaceCompaction = false;
    private boolean enableCrossSpaceCompaction = true;
    private CrossCompactionSelector crossStrategy = CrossCompactionSelector.REWRITE;
    private InnerSequenceCompactionSelector innerStrategy = InnerSequenceCompactionSelector.SIZE_TIERED;
    private CompactionPriority priority = CompactionPriority.BALANCE;
    private long targetFileSize = 0x40000000L;
    private long targetChunkSize = 0x100000L;
    private long targetChunkPointNum = 100000L;
    private long chunkSizeLowerBoundInCompaction = 128L;
    private long chunkPointNumLowerBoundInCompaction = 100L;
    private int maxInnerCompactionCandidateFileNum = 30;
    private int maxCrossCompactionCandidateFileNum = 1000;
    private int concurrentCompactionThread = 10;
    private long compactionScheduleIntervalInMs = 60000L;
    private long compactionSubmissionIntervalInMs = 60000L;
    private int compactionWriteThroughputMbPerSec = 8;
    private CrossCompactionPerformer oldCrossPerformer = IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer();
    private InnerSeqCompactionPerformer oldInnerSeqPerformer = IoTDBDescriptor.getInstance().getConfig().getInnerSeqCompactionPerformer();
    private InnerUnseqCompactionPerformer oldInnerUnseqPerformer = IoTDBDescriptor.getInstance().getConfig().getInnerUnseqCompactionPerformer();
    private int oldMinCrossCompactionUnseqLevel = IoTDBDescriptor.getInstance().getConfig().getMinCrossCompactionUnseqFileLevel();

    public void restoreCompactionConfig() {
        IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
        config.setEnableSeqSpaceCompaction(this.enableSeqSpaceCompaction);
        config.setEnableUnseqSpaceCompaction(this.enableUnseqSpaceCompaction);
        config.setEnableCrossSpaceCompaction(this.enableCrossSpaceCompaction);
        config.setCrossCompactionSelector(this.crossStrategy);
        config.setInnerSequenceCompactionSelector(this.innerStrategy);
        config.setCompactionPriority(this.priority);
        config.setTargetCompactionFileSize(this.targetFileSize);
        config.setTargetChunkSize(this.targetChunkSize);
        config.setTargetChunkPointNum(this.targetChunkPointNum);
        config.setChunkSizeLowerBoundInCompaction(this.chunkSizeLowerBoundInCompaction);
        config.setChunkPointNumLowerBoundInCompaction(this.chunkPointNumLowerBoundInCompaction);
        config.setFileLimitPerInnerTask(this.maxInnerCompactionCandidateFileNum);
        config.setFileLimitPerCrossTask(this.maxCrossCompactionCandidateFileNum);
        config.setCompactionThreadCount(this.concurrentCompactionThread);
        config.setCompactionScheduleIntervalInMs(this.compactionScheduleIntervalInMs);
        config.setCompactionSubmissionIntervalInMs(this.compactionSubmissionIntervalInMs);
        config.setCompactionWriteThroughputMbPerSec(this.compactionWriteThroughputMbPerSec);
        config.setCrossCompactionPerformer(this.oldCrossPerformer);
        config.setInnerSeqCompactionPerformer(this.oldInnerSeqPerformer);
        config.setInnerUnseqCompactionPerformer(this.oldInnerUnseqPerformer);
        config.setMinCrossCompactionUnseqFileLevel(this.oldMinCrossCompactionUnseqLevel);
    }
}

