/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.tools;

import java.util.Map;
import org.apache.iotdb.db.storageengine.dataregion.compaction.tool.Interval;
import org.apache.iotdb.db.storageengine.dataregion.compaction.tool.UnseqSpaceStatistics;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.PlainDeviceID;
import org.junit.Assert;
import org.junit.Test;

public class UnseqSpaceStatisticsTest {
    @Test
    public void test01() {
        UnseqSpaceStatistics unseqSpaceStatistics = new UnseqSpaceStatistics();
        unseqSpaceStatistics.updateMeasurement((IDeviceID)new PlainDeviceID("root.db.d1"), "s1", new Interval(1L, 10L));
        unseqSpaceStatistics.updateMeasurement((IDeviceID)new PlainDeviceID("root.db.d1"), "s1", new Interval(5L, 15L));
        unseqSpaceStatistics.updateMeasurement((IDeviceID)new PlainDeviceID("root.db.d1"), "s2", new Interval(1L, 10L));
        unseqSpaceStatistics.updateMeasurement((IDeviceID)new PlainDeviceID("root.db.d2"), "s2", new Interval(1L, 10L));
        Assert.assertEquals((long)2L, (long)unseqSpaceStatistics.getChunkStatisticMap().size());
        Assert.assertEquals((long)2L, (long)((Map)unseqSpaceStatistics.getChunkStatisticMap().get(new PlainDeviceID("root.db.d1"))).size());
        Assert.assertEquals((long)1L, (long)((Map)unseqSpaceStatistics.getChunkStatisticMap().get(new PlainDeviceID("root.db.d2"))).size());
    }

    @Test
    public void test02() {
        UnseqSpaceStatistics unseqSpaceStatistics = new UnseqSpaceStatistics();
        unseqSpaceStatistics.updateMeasurement((IDeviceID)new PlainDeviceID("root.db.d1"), "s1", new Interval(1L, 10L));
        unseqSpaceStatistics.updateMeasurement((IDeviceID)new PlainDeviceID("root.db.d1"), "s1", new Interval(5L, 15L));
        unseqSpaceStatistics.updateMeasurement((IDeviceID)new PlainDeviceID("root.db.d1"), "s2", new Interval(1L, 10L));
        unseqSpaceStatistics.updateMeasurement((IDeviceID)new PlainDeviceID("root.db.d2"), "s2", new Interval(1L, 10L));
        Assert.assertTrue((boolean)unseqSpaceStatistics.chunkHasOverlap((IDeviceID)new PlainDeviceID("root.db.d1"), "s1", new Interval(1L, 10L)));
        Assert.assertFalse((boolean)unseqSpaceStatistics.chunkHasOverlap((IDeviceID)new PlainDeviceID("root.db.d1"), "s4", new Interval(1L, 10L)));
        Assert.assertFalse((boolean)unseqSpaceStatistics.chunkHasOverlap((IDeviceID)new PlainDeviceID("root.db.d2"), "s1", new Interval(1L, 10L)));
        Assert.assertFalse((boolean)unseqSpaceStatistics.chunkHasOverlap((IDeviceID)new PlainDeviceID("root.db.d3"), "s1", new Interval(1L, 10L)));
        Assert.assertFalse((boolean)unseqSpaceStatistics.chunkHasOverlap((IDeviceID)new PlainDeviceID("root.db.d1"), "s1", new Interval(21L, 30L)));
    }
}

