/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.tools;

import org.apache.iotdb.db.storageengine.dataregion.compaction.tool.Interval;
import org.apache.iotdb.db.storageengine.dataregion.compaction.tool.ListTimeRangeImpl;
import org.junit.Assert;
import org.junit.Test;

public class ListTimeRangeImplTest {
    ListTimeRangeImpl listTimeRange = new ListTimeRangeImpl();

    @Test
    public void test01() {
        this.listTimeRange.addInterval(new Interval(30L, 40L));
        Assert.assertEquals((long)1L, (long)this.listTimeRange.getIntervalList().size());
        Assert.assertEquals((long)30L, (long)((Interval)this.listTimeRange.getIntervalList().get(0)).getStart());
        Assert.assertEquals((long)40L, (long)((Interval)this.listTimeRange.getIntervalList().get(0)).getEnd());
    }

    @Test
    public void test02() {
        this.listTimeRange.addInterval(new Interval(30L, 40L));
        this.listTimeRange.addInterval(new Interval(10L, 20L));
        this.listTimeRange.addInterval(new Interval(15L, 20L));
        this.listTimeRange.addInterval(new Interval(50L, 60L));
        Assert.assertEquals((long)3L, (long)this.listTimeRange.getIntervalList().size());
    }

    @Test
    public void test03() {
        this.listTimeRange.addInterval(new Interval(30L, 40L));
        this.listTimeRange.addInterval(new Interval(10L, 20L));
        this.listTimeRange.addInterval(new Interval(15L, 20L));
        this.listTimeRange.addInterval(new Interval(50L, 60L));
        this.listTimeRange.addInterval(new Interval(1L, 100L));
        Assert.assertEquals((long)1L, (long)this.listTimeRange.getIntervalList().size());
        Assert.assertEquals((long)1L, (long)((Interval)this.listTimeRange.getIntervalList().get(0)).getStart());
        Assert.assertEquals((long)100L, (long)((Interval)this.listTimeRange.getIntervalList().get(0)).getEnd());
    }

    @Test
    public void test04() {
        this.listTimeRange.addInterval(new Interval(30L, 40L));
        this.listTimeRange.addInterval(new Interval(10L, 20L));
        this.listTimeRange.addInterval(new Interval(15L, 20L));
        this.listTimeRange.addInterval(new Interval(50L, 60L));
        this.listTimeRange.addInterval(new Interval(5L, 100L));
        Assert.assertFalse((boolean)this.listTimeRange.isOverlapped(new Interval(1L, 1L)));
        Assert.assertFalse((boolean)this.listTimeRange.isOverlapped(new Interval(101L, 103L)));
    }

    @Test
    public void test05() {
        this.listTimeRange.addInterval(new Interval(30L, 40L));
        this.listTimeRange.addInterval(new Interval(10L, 20L));
        this.listTimeRange.addInterval(new Interval(20L, 30L));
        Assert.assertEquals((long)1L, (long)this.listTimeRange.getIntervalList().size());
    }

    @Test
    public void test06() {
        this.listTimeRange.addInterval(new Interval(1L, 100L));
        this.listTimeRange.addInterval(new Interval(1L, 2000L));
        Assert.assertEquals((long)1L, (long)this.listTimeRange.getIntervalList().size());
    }

    @Test
    public void test07() {
        this.listTimeRange.addInterval(new Interval(1L, 10L));
        this.listTimeRange.addInterval(new Interval(60L, 70L));
        this.listTimeRange.addInterval(new Interval(51L, 55L));
        Assert.assertEquals((long)51L, (long)((Interval)this.listTimeRange.getIntervalList().get(1)).getStart());
    }

    @Test
    public void testNoOverlap() {
        ListTimeRangeImpl listTimeRange = new ListTimeRangeImpl();
        listTimeRange.addInterval(new Interval(3L, 5L));
        Assert.assertFalse((boolean)listTimeRange.isOverlapped(new Interval(6L, 10L)));
        Assert.assertFalse((boolean)listTimeRange.isOverlapped(new Interval(1L, 2L)));
    }

    @Test
    public void testStartTimeOverlap() {
        ListTimeRangeImpl listTimeRange = new ListTimeRangeImpl();
        listTimeRange.addInterval(new Interval(1L, 5L));
        Assert.assertTrue((boolean)listTimeRange.isOverlapped(new Interval(4L, 8L)));
    }

    @Test
    public void testEndTimeOverlap() {
        ListTimeRangeImpl listTimeRange = new ListTimeRangeImpl();
        listTimeRange.addInterval(new Interval(1L, 5L));
        Assert.assertTrue((boolean)listTimeRange.isOverlapped(new Interval(0L, 4L)));
    }

    @Test
    public void testFullyOverlap() {
        ListTimeRangeImpl listTimeRange = new ListTimeRangeImpl();
        listTimeRange.addInterval(new Interval(2L, 4L));
        Assert.assertTrue((boolean)listTimeRange.isOverlapped(new Interval(1L, 5L)));
    }

    @Test
    public void testIntervalInsideCurrentInterval() {
        ListTimeRangeImpl listTimeRange = new ListTimeRangeImpl();
        listTimeRange.addInterval(new Interval(1L, 5L));
        Assert.assertTrue((boolean)listTimeRange.isOverlapped(new Interval(2L, 4L)));
    }

    @Test
    public void testBoundary() {
        ListTimeRangeImpl listTimeRange = new ListTimeRangeImpl();
        listTimeRange.addInterval(new Interval(3L, 5L));
        Assert.assertTrue((boolean)listTimeRange.isOverlapped(new Interval(1L, 3L)));
        Assert.assertTrue((boolean)listTimeRange.isOverlapped(new Interval(5L, 6L)));
    }
}

