/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.settle;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSettleReq;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.DataRegionException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.TsFileProcessorException;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.storageengine.dataregion.DataRegionTest;
import org.apache.iotdb.db.storageengine.dataregion.compaction.settle.SettleRequestHandler;
import org.apache.iotdb.db.storageengine.dataregion.flush.FlushManager;
import org.apache.iotdb.db.storageengine.dataregion.flush.TsFileFlushPolicy;
import org.apache.iotdb.db.storageengine.dataregion.memtable.TsFileProcessor;
import org.apache.iotdb.db.storageengine.dataregion.wal.WALManager;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SettleRequestHandlerTest {
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private SettleRequestHandler reqHandler;
    private String storageGroup = "root.sg.d1";
    private String systemDir = TestConstant.OUTPUT_DATA_DIR.concat("info");
    private String deviceId = "root.sg.d1";
    private String measurementId = "s0";
    private List<String> paths = new ArrayList<String>();
    private DataRegion dataRegion;

    @Before
    public void setUp() throws DataRegionException, StartupException, IOException, StorageEngineException {
        EnvironmentUtils.cleanDir(TestConstant.OUTPUT_DATA_DIR);
        EnvironmentUtils.cleanEnv();
        EnvironmentUtils.envSetUp();
        this.reqHandler = SettleRequestHandler.getInstance();
        this.reqHandler.setTestMode(true);
        this.dataRegion = new DummyDataRegion(this.systemDir, this.storageGroup);
        StorageEngine.getInstance().setDataRegion(new DataRegionId(0), this.dataRegion);
        WALManager.getInstance().start();
        FlushManager.getInstance().start();
    }

    @After
    public void tearDown() throws StorageEngineException, IOException, TsFileProcessorException {
        WALManager.getInstance().stop();
        FlushManager.getInstance().stop();
        if (this.dataRegion != null) {
            this.dataRegion.syncDeleteDataFiles();
            StorageEngine.getInstance().deleteDataRegion(new DataRegionId(0));
        }
        EnvironmentUtils.cleanEnv();
        EnvironmentUtils.cleanDir(TestConstant.OUTPUT_DATA_DIR);
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testHandleSettleRequest() throws IllegalPathException, IOException, WriteProcessException {
        this.createTsFiles();
        Assert.assertEquals((long)3L, (long)this.paths.size());
        TSettleReq req = new TSettleReq();
        req.setPaths(this.paths);
        TSStatus result = this.reqHandler.handleSettleRequest(req);
        Assert.assertEquals((long)result.code, (long)TSStatusCode.SUCCESS_STATUS.getStatusCode());
        config.setEnableSeqSpaceCompaction(false);
        result = this.reqHandler.handleSettleRequest(req);
        Assert.assertEquals((long)result.code, (long)TSStatusCode.UNSUPPORTED_OPERATION.getStatusCode());
        config.setEnableSeqSpaceCompaction(true);
        int maxInnerCompactionCandidateFileNum = config.getFileLimitPerInnerTask();
        config.setFileLimitPerInnerTask(2);
        result = this.reqHandler.handleSettleRequest(req);
        Assert.assertEquals((long)result.code, (long)TSStatusCode.UNSUPPORTED_OPERATION.getStatusCode());
        String firstTsFilePath = this.paths.remove(0);
        result = this.reqHandler.handleSettleRequest(req);
        Assert.assertEquals((long)result.code, (long)TSStatusCode.SUCCESS_STATUS.getStatusCode());
        this.paths.add(0, firstTsFilePath);
        config.setFileLimitPerInnerTask(maxInnerCompactionCandidateFileNum);
        this.paths.remove(1);
        result = this.reqHandler.handleSettleRequest(req);
        Assert.assertEquals((long)result.code, (long)TSStatusCode.ILLEGAL_PARAMETER.getStatusCode());
        this.paths.remove(0);
        result = this.reqHandler.handleSettleRequest(req);
        Assert.assertEquals((long)result.code, (long)TSStatusCode.ILLEGAL_PARAMETER.getStatusCode());
    }

    private void createTsFiles() throws IllegalPathException, WriteProcessException, IOException {
        for (int i = 0; i < 3; ++i) {
            for (int j = 1; j <= 3; ++j) {
                long timestamp = 3L * (long)i + (long)j;
                TSRecord record = new TSRecord(timestamp, this.deviceId);
                record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(timestamp)));
                this.dataRegion.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record));
            }
            for (TsFileProcessor tsFileProcessor : this.dataRegion.getWorkSequenceTsFileProcessors()) {
                this.paths.add(tsFileProcessor.getTsFileResource().getTsFilePath());
            }
            this.dataRegion.syncCloseAllWorkingTsFileProcessors();
            if (i == 2) continue;
            this.dataRegion.deleteByDevice(new PartialPath(this.deviceId, this.measurementId), 3L * (long)i + 1L, 3L * (long)i + 1L, -1L);
        }
    }

    static class DummyDataRegion
    extends DataRegion {
        DummyDataRegion(String systemInfoDir, String storageGroupName) throws DataRegionException {
            super(systemInfoDir, "0", (TsFileFlushPolicy)new TsFileFlushPolicy.DirectFlushPolicy(), storageGroupName);
        }
    }
}

