/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.repair;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.ICompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.ICrossCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.FastCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.ReadChunkCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CrossSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.InnerSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.RepairUnsortedFileCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.repair.AbstractRepairDataTest;
import org.apache.iotdb.db.storageengine.dataregion.compaction.repair.RepairLogger;
import org.apache.iotdb.db.storageengine.dataregion.compaction.repair.RepairTimePartition;
import org.apache.iotdb.db.storageengine.dataregion.compaction.repair.UnsortedFileRepairTaskScheduler;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionScheduleSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionScheduleTaskManager;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionScheduler;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionTaskManager;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.CompactionTestFileWriter;
import org.apache.iotdb.db.storageengine.dataregion.modification.Deletion;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModificationFile;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileRepairStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.utils.TsFileResourceUtils;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.PlainDeviceID;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.reader.chunk.AlignedChunkReader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class RepairUnsortedFileCompactionTest
extends AbstractRepairDataTest {
    private boolean enableSeqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableSeqSpaceCompaction();
    private boolean enableUnSeqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqSpaceCompaction();
    private boolean enableCrossSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableCrossSpaceCompaction();

    @Override
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException, InterruptedException {
        super.setUp();
        Thread.currentThread().setName("pool-1-IoTDB-Compaction-Worker-1");
        IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(true);
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(true);
        IoTDBDescriptor.getInstance().getConfig().setEnableCrossSpaceCompaction(true);
        try {
            CompactionScheduleTaskManager.getInstance().start();
        }
        catch (StartupException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(this.enableSeqSpaceCompaction);
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(this.enableUnSeqSpaceCompaction);
        IoTDBDescriptor.getInstance().getConfig().setEnableCrossSpaceCompaction(this.enableCrossSpaceCompaction);
        super.tearDown();
    }

    @Test
    public void testRepairUnsortedDataBetweenPageWithNonAlignedSeries() throws IOException {
        TsFileResource resource = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(resource);){
            writer.startChunkGroup("d1");
            writer.generateSimpleNonAlignedSeriesToCurrentDevice("s1", new TimeRange[][]{{new TimeRange(10L, 20L), new TimeRange(5L, 30L)}}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        Assert.assertFalse((boolean)TsFileResourceUtils.validateTsFileDataCorrectness((TsFileResource)resource));
        RepairUnsortedFileCompactionTask task = new RepairUnsortedFileCompactionTask(0L, this.tsFileManager, resource, resource.isSeq(), 0L);
        task.start();
        Assert.assertEquals((long)0L, (long)this.tsFileManager.getTsFileList(true).size());
        Assert.assertEquals((long)1L, (long)this.tsFileManager.getTsFileList(false).size());
        Assert.assertTrue((boolean)TsFileResourceUtils.validateTsFileDataCorrectness((TsFileResource)((TsFileResource)this.tsFileManager.getTsFileList(false).get(0))));
    }

    @Test
    public void testRepairUnsortedDataBetweenPageWithAlignedSeries() throws IOException {
        TsFileResource resource = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(resource);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDevice(Arrays.asList("s1", "s2"), new TimeRange[][]{{new TimeRange(10L, 20L), new TimeRange(5L, 30L)}}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        Assert.assertFalse((boolean)TsFileResourceUtils.validateTsFileDataCorrectness((TsFileResource)resource));
        RepairUnsortedFileCompactionTask task = new RepairUnsortedFileCompactionTask(0L, this.tsFileManager, resource, resource.isSeq(), 0L);
        task.start();
        Assert.assertEquals((long)0L, (long)this.tsFileManager.getTsFileList(true).size());
        Assert.assertEquals((long)1L, (long)this.tsFileManager.getTsFileList(false).size());
        Assert.assertTrue((boolean)TsFileResourceUtils.validateTsFileDataCorrectness((TsFileResource)((TsFileResource)this.tsFileManager.getTsFileList(false).get(0))));
    }

    @Test
    public void testRepairUnsortedDataInOnePageWithNonAlignedSeries() throws IOException {
        TsFileResource resource = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(resource);){
            writer.startChunkGroup("d1");
            writer.generateSimpleNonAlignedSeriesToCurrentDevice("s1", new TimeRange[][][]{{{new TimeRange(10L, 20L), new TimeRange(29L, 30L), new TimeRange(21L, 25L)}}}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        Assert.assertFalse((boolean)TsFileResourceUtils.validateTsFileDataCorrectness((TsFileResource)resource));
        RepairUnsortedFileCompactionTask task = new RepairUnsortedFileCompactionTask(0L, this.tsFileManager, resource, resource.isSeq(), 0L);
        task.start();
        Assert.assertEquals((long)0L, (long)this.tsFileManager.getTsFileList(true).size());
        Assert.assertEquals((long)1L, (long)this.tsFileManager.getTsFileList(false).size());
        Assert.assertTrue((boolean)TsFileResourceUtils.validateTsFileDataCorrectness((TsFileResource)((TsFileResource)this.tsFileManager.getTsFileList(false).get(0))));
    }

    @Test
    public void testRepairUnsortedDataInOnePageWithMultiNonAlignedSeries() throws IOException {
        TsFileResource resource = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(resource);){
            writer.startChunkGroup("d1");
            for (int i = 0; i < 1000; ++i) {
                writer.generateSimpleNonAlignedSeriesToCurrentDevice("s" + i, new TimeRange[][][]{{{new TimeRange(10L, 20L), new TimeRange(29L, 30L), new TimeRange(21L, 25L)}}}, TSEncoding.PLAIN, CompressionType.LZ4);
            }
            writer.endChunkGroup();
            writer.endFile();
        }
        Assert.assertFalse((boolean)TsFileResourceUtils.validateTsFileDataCorrectness((TsFileResource)resource));
        RepairUnsortedFileCompactionTask task = new RepairUnsortedFileCompactionTask(0L, this.tsFileManager, resource, resource.isSeq(), 0L);
        task.start();
        Assert.assertEquals((long)0L, (long)this.tsFileManager.getTsFileList(true).size());
        Assert.assertEquals((long)1L, (long)this.tsFileManager.getTsFileList(false).size());
        Assert.assertTrue((boolean)TsFileResourceUtils.validateTsFileDataCorrectness((TsFileResource)((TsFileResource)this.tsFileManager.getTsFileList(false).get(0))));
    }

    @Test
    public void testRepairUnsortedDataInOnePageWithUnseqFile() throws IOException {
        TsFileResource resource = this.createEmptyFileAndResource(false);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(resource);){
            writer.startChunkGroup("d1");
            writer.generateSimpleNonAlignedSeriesToCurrentDevice("s1", new TimeRange[][][]{{{new TimeRange(10L, 20L), new TimeRange(29L, 30L), new TimeRange(21L, 25L)}}}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        Assert.assertFalse((boolean)TsFileResourceUtils.validateTsFileDataCorrectness((TsFileResource)resource));
        RepairUnsortedFileCompactionTask task = new RepairUnsortedFileCompactionTask(0L, this.tsFileManager, resource, resource.isSeq(), 0L);
        task.start();
        Assert.assertEquals((long)0L, (long)this.tsFileManager.getTsFileList(true).size());
        Assert.assertEquals((long)1L, (long)this.tsFileManager.getTsFileList(false).size());
        Assert.assertTrue((boolean)TsFileResourceUtils.validateTsFileDataCorrectness((TsFileResource)((TsFileResource)this.tsFileManager.getTsFileList(false).get(0))));
    }

    @Test
    public void testRepairUnsortedDataInOnePageWithAlignedSeries() throws IOException {
        TsFileResource resource = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(resource);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDevice(Arrays.asList("s1", "s2"), new TimeRange[][][]{{{new TimeRange(10L, 20L), new TimeRange(29L, 30L), new TimeRange(21L, 25L)}}}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        Assert.assertFalse((boolean)TsFileResourceUtils.validateTsFileDataCorrectness((TsFileResource)resource));
        RepairUnsortedFileCompactionTask task = new RepairUnsortedFileCompactionTask(0L, this.tsFileManager, resource, resource.isSeq(), 0L);
        task.start();
        Assert.assertEquals((long)0L, (long)this.tsFileManager.getTsFileList(true).size());
        Assert.assertEquals((long)1L, (long)this.tsFileManager.getTsFileList(false).size());
        Assert.assertTrue((boolean)TsFileResourceUtils.validateTsFileDataCorrectness((TsFileResource)((TsFileResource)this.tsFileManager.getTsFileList(false).get(0))));
        Assert.assertTrue((boolean)TsFileResourceUtils.validateTsFileResourcesHasNoOverlap((List)this.tsFileManager.getOrCreateSequenceListByTimePartition(0L)));
    }

    @Test
    public void testMarkFileAndRepairWithInnerSeqSpaceCompactionTask() throws IOException, InterruptedException {
        TsFileResource seqResource1 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqResource1);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDevice(Arrays.asList("s1", "s2"), new TimeRange[][][]{{{new TimeRange(10L, 20L), new TimeRange(29L, 30L), new TimeRange(21L, 25L)}}}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        TsFileResource seqResource2 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqResource2);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDevice(Arrays.asList("s1", "s2"), new TimeRange[][]{{new TimeRange(10L, 20L), new TimeRange(5L, 30L)}}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, Arrays.asList(seqResource1, seqResource2), true, (ICompactionPerformer)new ReadChunkCompactionPerformer(), 0L);
        Assert.assertFalse((boolean)task.start());
        for (TsFileResource resource : this.tsFileManager.getTsFileList(true)) {
            Assert.assertEquals((Object)resource.getTsFileRepairStatus(), (Object)TsFileRepairStatus.NEED_TO_REPAIR);
        }
        long initialFinishedCompactionTaskNum = CompactionTaskManager.getInstance().getFinishedTaskNum();
        CompactionScheduleSummary summary = new CompactionScheduleSummary();
        CompactionScheduler.scheduleCompaction((TsFileManager)this.tsFileManager, (long)0L, (CompactionScheduleSummary)summary);
        Assert.assertEquals((long)2L, (long)summary.getSubmitSeqInnerSpaceCompactionTaskNum());
        int waitSecond = 20;
        while (CompactionTaskManager.getInstance().getFinishedTaskNum() - initialFinishedCompactionTaskNum < 2L) {
            if (waitSecond == 0) {
                Assert.fail((String)"Exceed the max time to wait repair compaction");
            }
            try {
                Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
                --waitSecond;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        Assert.assertEquals((long)0L, (long)this.tsFileManager.getTsFileList(true).size());
        Assert.assertEquals((long)2L, (long)this.tsFileManager.getTsFileList(false).size());
        for (TsFileResource resource : this.tsFileManager.getTsFileList(false)) {
            TsFileResourceUtils.validateTsFileDataCorrectness((TsFileResource)resource);
        }
        Assert.assertTrue((boolean)TsFileResourceUtils.validateTsFileResourcesHasNoOverlap((List)this.tsFileManager.getOrCreateSequenceListByTimePartition(0L)));
    }

    @Test
    public void testMarkFileAndRepairWithInnerUnSeqSpaceCompactionTask() throws IOException, InterruptedException {
        TsFileResource unSeqResource1 = this.createEmptyFileAndResource(false);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(unSeqResource1);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDevice(Arrays.asList("s1", "s2"), new TimeRange[][][]{{{new TimeRange(10L, 20L), new TimeRange(29L, 30L), new TimeRange(21L, 25L)}}}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        TsFileResource unSeqResource2 = this.createEmptyFileAndResource(false);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(unSeqResource2);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDevice(Arrays.asList("s1", "s2"), new TimeRange[][]{{new TimeRange(10L, 20L), new TimeRange(5L, 30L)}}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, Arrays.asList(unSeqResource1, unSeqResource2), false, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertFalse((boolean)task.start());
        for (TsFileResource resource : this.tsFileManager.getTsFileList(true)) {
            Assert.assertEquals((Object)resource.getTsFileRepairStatus(), (Object)TsFileRepairStatus.NEED_TO_REPAIR);
        }
        long initialFinishedCompactionTaskNum = CompactionTaskManager.getInstance().getFinishedTaskNum();
        CompactionScheduleSummary summary = new CompactionScheduleSummary();
        CompactionScheduler.scheduleCompaction((TsFileManager)this.tsFileManager, (long)0L, (CompactionScheduleSummary)summary);
        Assert.assertEquals((long)2L, (long)summary.getSubmitUnseqInnerSpaceCompactionTaskNum());
        int waitSecond = 20;
        while (CompactionTaskManager.getInstance().getFinishedTaskNum() - initialFinishedCompactionTaskNum < 2L) {
            if (waitSecond == 0) {
                Assert.fail((String)"Exceed the max time to wait repair compaction");
            }
            try {
                Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
                --waitSecond;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        Assert.assertEquals((long)0L, (long)this.tsFileManager.getTsFileList(true).size());
        Assert.assertEquals((long)2L, (long)this.tsFileManager.getTsFileList(false).size());
        for (TsFileResource resource : this.tsFileManager.getTsFileList(false)) {
            TsFileResourceUtils.validateTsFileDataCorrectness((TsFileResource)resource);
        }
        Assert.assertTrue((boolean)TsFileResourceUtils.validateTsFileResourcesHasNoOverlap((List)this.tsFileManager.getOrCreateSequenceListByTimePartition(0L)));
    }

    @Test
    public void testMarkFileAndRepairWithCrossSpaceCompactionTask() throws IOException, InterruptedException {
        TsFileResource seqResource1 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqResource1);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDevice(Arrays.asList("s1", "s2"), new TimeRange[][][]{{{new TimeRange(10L, 20L), new TimeRange(29L, 30L), new TimeRange(21L, 25L)}}}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        TsFileResource unSeqResource1 = this.createEmptyFileAndResource(false);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(unSeqResource1);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDevice(Arrays.asList("s1", "s2"), new TimeRange[][]{{new TimeRange(10L, 20L), new TimeRange(5L, 30L)}}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        CrossSpaceCompactionTask task = new CrossSpaceCompactionTask(0L, this.tsFileManager, Collections.singletonList(seqResource1), Collections.singletonList(unSeqResource1), (ICrossCompactionPerformer)new FastCompactionPerformer(true), 0L, 0L);
        Assert.assertFalse((boolean)task.start());
        for (TsFileResource resource : this.tsFileManager.getTsFileList(true)) {
            Assert.assertEquals((Object)resource.getTsFileRepairStatus(), (Object)TsFileRepairStatus.NEED_TO_REPAIR);
        }
        long initialFinishedCompactionTaskNum = CompactionTaskManager.getInstance().getFinishedTaskNum();
        CompactionScheduleSummary summary = new CompactionScheduleSummary();
        CompactionScheduler.scheduleCompaction((TsFileManager)this.tsFileManager, (long)0L, (CompactionScheduleSummary)summary);
        Assert.assertEquals((long)1L, (long)summary.getSubmitSeqInnerSpaceCompactionTaskNum());
        Assert.assertEquals((long)1L, (long)summary.getSubmitUnseqInnerSpaceCompactionTaskNum());
        int waitSecond = 20;
        while (CompactionTaskManager.getInstance().getFinishedTaskNum() - initialFinishedCompactionTaskNum < 2L) {
            if (waitSecond == 0) {
                Assert.fail((String)"Exceed the max time to wait repair compaction");
            }
            try {
                Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
                --waitSecond;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        Assert.assertEquals((long)0L, (long)this.tsFileManager.getTsFileList(true).size());
        Assert.assertEquals((long)2L, (long)this.tsFileManager.getTsFileList(false).size());
        for (TsFileResource resource : this.tsFileManager.getTsFileList(false)) {
            TsFileResourceUtils.validateTsFileDataCorrectness((TsFileResource)resource);
        }
    }

    @Test
    public void testRepairOverlapBetweenFile() throws IOException {
        TsFileResource seqResource1 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqResource1);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDevice(Arrays.asList("s1", "s2"), new TimeRange[][]{{new TimeRange(10L, 20L), new TimeRange(25L, 30L)}}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        TsFileResource seqResource2 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqResource2);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDevice(Arrays.asList("s1", "s2"), new TimeRange[][]{{new TimeRange(20L, 30L), new TimeRange(35L, 40L)}}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        this.tsFileManager.addAll(this.seqResources, true);
        Assert.assertFalse((boolean)TsFileResourceUtils.validateTsFileResourcesHasNoOverlap((List)this.seqResources));
        RepairUnsortedFileCompactionTask task = new RepairUnsortedFileCompactionTask(0L, this.tsFileManager, seqResource2, true, false, 0L);
        Assert.assertTrue((boolean)task.start());
        Assert.assertEquals((long)1L, (long)this.tsFileManager.getTsFileList(true).size());
        Assert.assertEquals((long)1L, (long)this.tsFileManager.getTsFileList(false).size());
        Assert.assertTrue((boolean)TsFileResourceUtils.validateTsFileDataCorrectness((TsFileResource)((TsFileResource)this.tsFileManager.getTsFileList(false).get(0))));
        Assert.assertTrue((boolean)TsFileResourceUtils.validateTsFileResourceCorrectness((TsFileResource)((TsFileResource)this.tsFileManager.getTsFileList(false).get(0))));
    }

    @Test
    public void testRepairOverlapBetweenFileWithModFile() throws IOException, IllegalPathException {
        TsFileResource seqResource1 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqResource1);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDevice(Arrays.asList("s1", "s2"), new TimeRange[][]{{new TimeRange(10L, 20L), new TimeRange(25L, 30L)}}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        TsFileResource seqResource2 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqResource2);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDevice(Arrays.asList("s1", "s2"), new TimeRange[][]{{new TimeRange(20L, 30L), new TimeRange(35L, 40L)}}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        ModificationFile modFile = seqResource2.getModFile();
        Deletion writedModification = new Deletion(new PartialPath("root.testsg.d1.s1"), Long.MAX_VALUE, 15L);
        modFile.write((Modification)writedModification);
        modFile.close();
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        this.tsFileManager.addAll(this.seqResources, true);
        Assert.assertFalse((boolean)TsFileResourceUtils.validateTsFileResourcesHasNoOverlap((List)this.seqResources));
        RepairUnsortedFileCompactionTask task = new RepairUnsortedFileCompactionTask(0L, this.tsFileManager, seqResource2, true, false, 0L);
        Assert.assertTrue((boolean)task.start());
        Assert.assertEquals((long)1L, (long)this.tsFileManager.getTsFileList(true).size());
        Assert.assertEquals((long)1L, (long)this.tsFileManager.getTsFileList(false).size());
        TsFileResource targetResource = (TsFileResource)this.tsFileManager.getTsFileList(false).get(0);
        Assert.assertTrue((boolean)TsFileResourceUtils.validateTsFileDataCorrectness((TsFileResource)targetResource));
        Assert.assertTrue((boolean)TsFileResourceUtils.validateTsFileResourceCorrectness((TsFileResource)targetResource));
        Assert.assertTrue((boolean)targetResource.modFileExists());
        Assert.assertEquals((long)1L, (long)targetResource.getModFile().getModifications().size());
        Deletion modification = (Deletion)targetResource.getModFile().getModifications().iterator().next();
        Assert.assertEquals((long)writedModification.getFileOffset(), (long)modification.getFileOffset());
        Assert.assertEquals((long)writedModification.getEndTime(), (long)modification.getEndTime());
    }

    @Test
    public void testScheduleRepairInternalUnsortedFile() throws IOException {
        DataRegion mockDataRegion = (DataRegion)Mockito.mock(DataRegion.class);
        Mockito.when((Object)mockDataRegion.getTsFileManager()).thenReturn((Object)this.tsFileManager);
        Mockito.when((Object)mockDataRegion.getDatabaseName()).thenReturn((Object)"root.testsg");
        Mockito.when((Object)mockDataRegion.getDataRegionId()).thenReturn((Object)"0");
        Mockito.when((Object)mockDataRegion.getTimePartitions()).thenReturn(Collections.singletonList(0L));
        TsFileResource seqResource1 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqResource1);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDevice(Arrays.asList("s1", "s2"), new TimeRange[][]{{new TimeRange(10L, 20L), new TimeRange(15L, 30L)}}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        TsFileResource seqResource2 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqResource2);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDevice(Arrays.asList("s1", "s2"), new TimeRange[][]{{new TimeRange(40L, 50L), new TimeRange(55L, 60L)}}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        this.tsFileManager.addAll(this.seqResources, true);
        Assert.assertTrue((boolean)TsFileResourceUtils.validateTsFileResourcesHasNoOverlap((List)this.seqResources));
        File tempDir = this.getEmptyRepairDataLogDir();
        CompactionScheduleTaskManager.getRepairTaskManagerInstance().markRepairTaskStart();
        UnsortedFileRepairTaskScheduler scheduler = new UnsortedFileRepairTaskScheduler(Collections.singletonList(mockDataRegion), false, tempDir);
        scheduler.run();
        Assert.assertEquals((long)1L, (long)this.tsFileManager.getTsFileList(true).size());
        Assert.assertEquals((long)1L, (long)this.tsFileManager.getTsFileList(false).size());
    }

    @Test
    public void testScheduleRepairOverlapFile() throws IOException {
        DataRegion mockDataRegion = (DataRegion)Mockito.mock(DataRegion.class);
        Mockito.when((Object)mockDataRegion.getTsFileManager()).thenReturn((Object)this.tsFileManager);
        Mockito.when((Object)mockDataRegion.getDatabaseName()).thenReturn((Object)"root.testsg");
        Mockito.when((Object)mockDataRegion.getDataRegionId()).thenReturn((Object)"0");
        Mockito.when((Object)mockDataRegion.getTimePartitions()).thenReturn(Collections.singletonList(0L));
        TsFileResource seqResource1 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqResource1);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDevice(Arrays.asList("s1", "s2"), new TimeRange[][]{{new TimeRange(10L, 20L), new TimeRange(25L, 30L)}}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        TsFileResource seqResource2 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqResource2);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDevice(Arrays.asList("s1", "s2"), new TimeRange[][]{{new TimeRange(10L, 50L), new TimeRange(55L, 60L)}}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        this.tsFileManager.addAll(this.seqResources, true);
        Assert.assertFalse((boolean)TsFileResourceUtils.validateTsFileResourcesHasNoOverlap((List)this.seqResources));
        File tempDir = this.getEmptyRepairDataLogDir();
        CompactionScheduleTaskManager.getRepairTaskManagerInstance().markRepairTaskStart();
        UnsortedFileRepairTaskScheduler scheduler = new UnsortedFileRepairTaskScheduler(Collections.singletonList(mockDataRegion), false, tempDir);
        scheduler.run();
        Assert.assertEquals((long)1L, (long)this.tsFileManager.getTsFileList(true).size());
        Assert.assertEquals((long)1L, (long)this.tsFileManager.getTsFileList(false).size());
    }

    @Test
    public void testScheduleRepairOverlapFileAndInternalUnsortedFile() throws IOException {
        DataRegion mockDataRegion = (DataRegion)Mockito.mock(DataRegion.class);
        Mockito.when((Object)mockDataRegion.getTsFileManager()).thenReturn((Object)this.tsFileManager);
        Mockito.when((Object)mockDataRegion.getDatabaseName()).thenReturn((Object)"root.testsg");
        Mockito.when((Object)mockDataRegion.getDataRegionId()).thenReturn((Object)"0");
        Mockito.when((Object)mockDataRegion.getTimePartitions()).thenReturn(Collections.singletonList(0L));
        TsFileResource seqResource1 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqResource1);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDevice(Arrays.asList("s1", "s2"), new TimeRange[][]{{new TimeRange(10L, 20L), new TimeRange(15L, 30L)}}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        TsFileResource seqResource2 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqResource2);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDevice(Arrays.asList("s1", "s2"), new TimeRange[][]{{new TimeRange(10L, 50L), new TimeRange(55L, 60L)}}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        TsFileResource seqResource3 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqResource3);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDevice(Arrays.asList("s1", "s2"), new TimeRange[][]{{new TimeRange(40L, 80L)}}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        this.seqResources.add(seqResource3);
        this.tsFileManager.addAll(this.seqResources, true);
        Assert.assertFalse((boolean)TsFileResourceUtils.validateTsFileResourcesHasNoOverlap((List)this.seqResources));
        File tempDir = this.getEmptyRepairDataLogDir();
        CompactionScheduleTaskManager.getRepairTaskManagerInstance().markRepairTaskStart();
        UnsortedFileRepairTaskScheduler scheduler = new UnsortedFileRepairTaskScheduler(Collections.singletonList(mockDataRegion), false, tempDir);
        scheduler.run();
        Assert.assertEquals((long)1L, (long)this.tsFileManager.getTsFileList(true).size());
        Assert.assertEquals((long)2L, (long)this.tsFileManager.getTsFileList(false).size());
    }

    @Test
    public void testRecoverRepairScheduleSkipRepairedTimePartitionAndMarkFile() throws IOException {
        DataRegion mockDataRegion = (DataRegion)Mockito.mock(DataRegion.class);
        Mockito.when((Object)mockDataRegion.getTsFileManager()).thenReturn((Object)this.tsFileManager);
        Mockito.when((Object)mockDataRegion.getDatabaseName()).thenReturn((Object)"root.testsg");
        Mockito.when((Object)mockDataRegion.getDataRegionId()).thenReturn((Object)"0");
        Mockito.when((Object)mockDataRegion.getTimePartitions()).thenReturn(Collections.singletonList(0L));
        TsFileResource seqResource1 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqResource1);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDevice(Arrays.asList("s1", "s2"), new TimeRange[][]{{new TimeRange(10L, 20L), new TimeRange(15L, 30L)}}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        TsFileResource seqResource2 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqResource2);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDevice(Arrays.asList("s1", "s2"), new TimeRange[][]{{new TimeRange(10L, 50L), new TimeRange(55L, 60L)}}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        TsFileResource seqResource3 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqResource3);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDevice(Arrays.asList("s1", "s2"), new TimeRange[][]{{new TimeRange(40L, 80L)}}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        seqResource3.setTsFileRepairStatus(TsFileRepairStatus.CAN_NOT_REPAIR);
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        this.seqResources.add(seqResource3);
        this.tsFileManager.addAll(this.seqResources, true);
        Assert.assertFalse((boolean)TsFileResourceUtils.validateTsFileResourcesHasNoOverlap((List)this.seqResources));
        File tempDir = this.getEmptyRepairDataLogDir();
        try (RepairLogger logger = new RepairLogger(tempDir, false);){
            logger.recordRepairTaskStartTimeIfLogFileEmpty(System.currentTimeMillis());
            RepairTimePartition timePartition = new RepairTimePartition(mockDataRegion, 0L, System.currentTimeMillis());
            logger.recordRepairedTimePartition(timePartition);
        }
        seqResource3.setTsFileRepairStatus(TsFileRepairStatus.NORMAL);
        CompactionScheduleTaskManager.getRepairTaskManagerInstance().markRepairTaskStart();
        UnsortedFileRepairTaskScheduler scheduler = new UnsortedFileRepairTaskScheduler(Collections.singletonList(mockDataRegion), true, tempDir);
        scheduler.run();
        Assert.assertEquals((long)3L, (long)this.tsFileManager.getTsFileList(true).size());
        Assert.assertEquals((Object)TsFileRepairStatus.NEED_TO_REPAIR, (Object)seqResource3.getTsFileRepairStatus());
    }

    @Test
    public void testRecoverRepairScheduleSkipRepairedTimePartitionWithDeletedFile() throws IOException {
        DataRegion mockDataRegion = (DataRegion)Mockito.mock(DataRegion.class);
        Mockito.when((Object)mockDataRegion.getTsFileManager()).thenReturn((Object)this.tsFileManager);
        Mockito.when((Object)mockDataRegion.getDatabaseName()).thenReturn((Object)"root.testsg");
        Mockito.when((Object)mockDataRegion.getDataRegionId()).thenReturn((Object)"0");
        Mockito.when((Object)mockDataRegion.getTimePartitions()).thenReturn(Collections.singletonList(0L));
        TsFileResource seqResource1 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqResource1);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDevice(Arrays.asList("s1", "s2"), new TimeRange[][]{{new TimeRange(10L, 20L), new TimeRange(15L, 30L)}}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        TsFileResource seqResource2 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqResource2);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDevice(Arrays.asList("s1", "s2"), new TimeRange[][]{{new TimeRange(10L, 50L), new TimeRange(55L, 60L)}}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        TsFileResource seqResource3 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqResource3);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDevice(Arrays.asList("s1", "s2"), new TimeRange[][]{{new TimeRange(40L, 80L)}}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        seqResource3.setTsFileRepairStatus(TsFileRepairStatus.CAN_NOT_REPAIR);
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        this.seqResources.add(seqResource3);
        this.tsFileManager.addAll(this.seqResources, true);
        Assert.assertFalse((boolean)TsFileResourceUtils.validateTsFileResourcesHasNoOverlap((List)this.seqResources));
        File tempDir = this.getEmptyRepairDataLogDir();
        try (RepairLogger logger = new RepairLogger(tempDir, false);){
            logger.recordRepairTaskStartTimeIfLogFileEmpty(System.currentTimeMillis());
            RepairTimePartition timePartition = new RepairTimePartition(mockDataRegion, 0L, System.currentTimeMillis());
            logger.recordRepairedTimePartition(timePartition);
        }
        seqResource3.setTsFileRepairStatus(TsFileRepairStatus.NORMAL);
        this.tsFileManager.replace(Collections.singletonList(seqResource3), Collections.emptyList(), Collections.emptyList(), 0L);
        CompactionScheduleTaskManager.getRepairTaskManagerInstance().markRepairTaskStart();
        UnsortedFileRepairTaskScheduler scheduler = new UnsortedFileRepairTaskScheduler(Collections.singletonList(mockDataRegion), true, tempDir);
        scheduler.run();
        Assert.assertEquals((long)2L, (long)this.tsFileManager.getTsFileList(true).size());
    }

    @Test
    public void testTimePartitionFilterFiles() {
        DataRegion mockDataRegion = (DataRegion)Mockito.mock(DataRegion.class);
        Mockito.when((Object)mockDataRegion.getTsFileManager()).thenReturn((Object)this.tsFileManager);
        Mockito.when((Object)mockDataRegion.getTimePartitions()).thenReturn(Collections.singletonList(0L));
        TsFileResource seqResource1 = this.createEmptyFileAndResourceWithName("100-1-0-0.tsfile", 0L, true);
        TsFileResource seqResource2 = this.createEmptyFileAndResourceWithName("200-3-0-0.tsfile", 0L, true);
        TsFileResource seqResource3 = this.createEmptyFileAndResourceWithName("300-5-0-0.tsfile", 0L, true);
        TsFileResource unseqResource1 = this.createEmptyFileAndResourceWithName("101-2-0-0.tsfile", 0L, false);
        TsFileResource unseqResource2 = this.createEmptyFileAndResourceWithName("201-4-0-0.tsfile", 0L, false);
        TsFileResource unseqResource3 = this.createEmptyFileAndResourceWithName("301-6-0-0.tsfile", 0L, false);
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        this.seqResources.add(seqResource3);
        this.unseqResources.add(unseqResource1);
        this.unseqResources.add(unseqResource2);
        this.unseqResources.add(unseqResource3);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RepairTimePartition timePartition = new RepairTimePartition(mockDataRegion, 0L, 250L);
        Assert.assertEquals((long)4L, (long)timePartition.getAllFileSnapshot().size());
        Assert.assertEquals((long)2L, (long)timePartition.getSeqFileSnapshot().size());
        Assert.assertEquals((long)2L, (long)timePartition.getUnSeqFileSnapshot().size());
    }

    @Test
    public void testEstimateRepairCompactionMemory() throws IOException {
        TsFileResource resource = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(resource);){
            writer.startChunkGroup("d1");
            writer.generateSimpleNonAlignedSeriesToCurrentDevice("s1", new TimeRange[][]{{new TimeRange(10L, 20L), new TimeRange(5L, 30L)}}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        RepairUnsortedFileCompactionTask task = new RepairUnsortedFileCompactionTask(0L, this.tsFileManager, resource, true, true, 0L);
        Assert.assertTrue((task.getEstimatedMemoryCost() > 0L ? 1 : 0) != 0);
        task = new RepairUnsortedFileCompactionTask(0L, this.tsFileManager, resource, true, false, 0L);
        Assert.assertEquals((long)0L, (long)task.getEstimatedMemoryCost());
    }

    @Test
    public void testMergeAlignedSeriesPointWithSameTimestamp() throws IOException {
        TsFileResource resource = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(resource);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDeviceWithNullValue(Arrays.asList("s1", "s2", "s3"), new TimeRange[][]{{new TimeRange(10L, 20L)}}, TSEncoding.PLAIN, CompressionType.LZ4, Arrays.asList(true, false, false));
            writer.generateSimpleAlignedSeriesToCurrentDeviceWithNullValue(Arrays.asList("s1", "s2", "s3"), new TimeRange[][]{{new TimeRange(10L, 20L)}}, TSEncoding.PLAIN, CompressionType.LZ4, Arrays.asList(false, true, true));
            writer.endChunkGroup();
            writer.endFile();
        }
        RepairUnsortedFileCompactionTask task = new RepairUnsortedFileCompactionTask(0L, this.tsFileManager, resource, true, true, 0L);
        Assert.assertTrue((boolean)task.start());
        TsFileResource target = (TsFileResource)this.tsFileManager.getTsFileList(false).get(0);
        try (TsFileSequenceReader reader = new TsFileSequenceReader(target.getTsFilePath());){
            List chunkMetadataList = reader.getAlignedChunkMetadata((IDeviceID)new PlainDeviceID("root.testsg.d1"));
            for (AlignedChunkMetadata alignedChunkMetadata : chunkMetadataList) {
                ChunkMetadata timeChunkMetadata = (ChunkMetadata)alignedChunkMetadata.getTimeChunkMetadata();
                Chunk timeChunk = reader.readMemChunk(timeChunkMetadata);
                ArrayList<Chunk> valueChunks = new ArrayList<Chunk>();
                for (IChunkMetadata chunkMetadata : alignedChunkMetadata.getValueChunkMetadataList()) {
                    Chunk valueChunk = reader.readMemChunk((ChunkMetadata)chunkMetadata);
                    valueChunks.add(valueChunk);
                }
                AlignedChunkReader chunkReader = new AlignedChunkReader(timeChunk, valueChunks, null);
                while (chunkReader.hasNextSatisfiedPage()) {
                    BatchData batchData = chunkReader.nextPageData();
                    BatchData.BatchDataIterator pointReader = batchData.getBatchDataIterator();
                    while (pointReader.hasNextTimeValuePair()) {
                        TimeValuePair timeValuePair = pointReader.nextTimeValuePair();
                        for (Object value : timeValuePair.getValues()) {
                            if (value != null) continue;
                            Assert.fail();
                        }
                    }
                }
            }
        }
    }
}

