/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.repair;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.repair.AbstractRepairDataTest;
import org.apache.iotdb.db.storageengine.dataregion.compaction.repair.RepairLogger;
import org.apache.iotdb.db.storageengine.dataregion.compaction.repair.RepairTaskRecoverLogParser;
import org.apache.iotdb.db.storageengine.dataregion.compaction.repair.RepairTimePartition;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileRepairStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class RepairLoggerTest
extends AbstractRepairDataTest {
    @Override
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException, InterruptedException {
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        super.tearDown();
    }

    @Test
    public void testSimpleReadWriteLogFile() throws IOException {
        block6: {
            TsFileResource resource1 = this.createEmptyFileAndResource(true);
            TsFileResource resource2 = this.createEmptyFileAndResource(true);
            resource2.setTsFileRepairStatus(TsFileRepairStatus.CAN_NOT_REPAIR);
            RepairTimePartition mockRepairTimePartition = (RepairTimePartition)Mockito.mock(RepairTimePartition.class);
            Mockito.when((Object)mockRepairTimePartition.getDatabaseName()).thenReturn((Object)"root.testsg");
            Mockito.when((Object)mockRepairTimePartition.getDataRegionId()).thenReturn((Object)"0");
            Mockito.when((Object)mockRepairTimePartition.getTimePartitionId()).thenReturn((Object)0L);
            Mockito.when((Object)mockRepairTimePartition.getAllFileSnapshot()).thenReturn(Arrays.asList(resource1, resource2));
            File tempDir = this.getEmptyRepairDataLogDir();
            File logFile = null;
            try (RepairLogger logger = new RepairLogger(tempDir, false);){
                logFile = logger.getLogFile();
                logger.recordRepairTaskStartTimeIfLogFileEmpty(System.currentTimeMillis());
                logger.recordRepairedTimePartition(mockRepairTimePartition);
            }
            RepairTaskRecoverLogParser logParser = new RepairTaskRecoverLogParser(logFile);
            logParser.parse();
            Map repairedTimePartitionsWithCannotRepairFiles = logParser.getRepairedTimePartitionsWithCannotRepairFiles();
            Assert.assertEquals((long)1L, (long)repairedTimePartitionsWithCannotRepairFiles.size());
            Iterator iterator = repairedTimePartitionsWithCannotRepairFiles.entrySet().iterator();
            if (!iterator.hasNext()) break block6;
            Map.Entry entry = iterator.next();
            Assert.assertEquals((Object)mockRepairTimePartition.getDatabaseName(), (Object)((RepairTimePartition)entry.getKey()).getDatabaseName());
            Assert.assertEquals((Object)mockRepairTimePartition.getDataRegionId(), (Object)((RepairTimePartition)entry.getKey()).getDataRegionId());
            Assert.assertEquals((long)mockRepairTimePartition.getTimePartitionId(), (long)((RepairTimePartition)entry.getKey()).getTimePartitionId());
            Assert.assertTrue((boolean)((Set)entry.getValue()).contains(resource2.getTsFile().getName()));
        }
    }

    @Test
    public void testReadManyTimePartitionLogFile() throws IOException {
        RepairTimePartition mockRepairTimePartition = (RepairTimePartition)Mockito.mock(RepairTimePartition.class);
        Mockito.when((Object)mockRepairTimePartition.getDatabaseName()).thenReturn((Object)"root.testsg");
        Mockito.when((Object)mockRepairTimePartition.getDataRegionId()).thenReturn((Object)"0");
        Mockito.when((Object)mockRepairTimePartition.getTimePartitionId()).thenReturn((Object)0L, (Object[])new Long[]{1L, 2L});
        Mockito.when((Object)mockRepairTimePartition.getAllFileSnapshot()).thenReturn(Collections.emptyList());
        File tempDir = this.getEmptyRepairDataLogDir();
        File logFile = null;
        try (RepairLogger logger = new RepairLogger(tempDir, false);){
            logFile = logger.getLogFile();
            logger.recordRepairTaskStartTimeIfLogFileEmpty(System.currentTimeMillis());
            for (int i = 0; i < 3; ++i) {
                logger.markStartOfRepairedTimePartition(mockRepairTimePartition);
                logger.recordCannotRepairFiles(mockRepairTimePartition);
                logger.markEndOfRepairedTimePartition(mockRepairTimePartition);
            }
        }
        RepairTaskRecoverLogParser logParser = new RepairTaskRecoverLogParser(logFile);
        logParser.parse();
        Map repairedTimePartitionsWithCannotRepairFiles = logParser.getRepairedTimePartitionsWithCannotRepairFiles();
        Assert.assertEquals((long)3L, (long)repairedTimePartitionsWithCannotRepairFiles.size());
    }

    @Test
    public void testReadIncompleteLogFile() throws IOException {
        block6: {
            TsFileResource resource1 = this.createEmptyFileAndResource(true);
            TsFileResource resource2 = this.createEmptyFileAndResource(true);
            resource2.setTsFileRepairStatus(TsFileRepairStatus.CAN_NOT_REPAIR);
            RepairTimePartition mockRepairTimePartition = (RepairTimePartition)Mockito.mock(RepairTimePartition.class);
            Mockito.when((Object)mockRepairTimePartition.getDatabaseName()).thenReturn((Object)"root.testsg");
            Mockito.when((Object)mockRepairTimePartition.getDataRegionId()).thenReturn((Object)"0");
            Mockito.when((Object)mockRepairTimePartition.getTimePartitionId()).thenReturn((Object)0L);
            Mockito.when((Object)mockRepairTimePartition.getAllFileSnapshot()).thenReturn(Arrays.asList(resource1, resource2));
            File tempDir = this.getEmptyRepairDataLogDir();
            File logFile = null;
            try (RepairLogger logger = new RepairLogger(tempDir, false);){
                logger.recordRepairTaskStartTimeIfLogFileEmpty(System.currentTimeMillis());
                logFile = logger.getLogFile();
                logger.markStartOfRepairedTimePartition(mockRepairTimePartition);
                logger.recordCannotRepairFiles(mockRepairTimePartition);
            }
            RepairTaskRecoverLogParser logParser = new RepairTaskRecoverLogParser(logFile);
            logParser.parse();
            Map repairedTimePartitionsWithCannotRepairFiles = logParser.getRepairedTimePartitionsWithCannotRepairFiles();
            Assert.assertEquals((long)1L, (long)repairedTimePartitionsWithCannotRepairFiles.size());
            Iterator iterator = repairedTimePartitionsWithCannotRepairFiles.entrySet().iterator();
            if (!iterator.hasNext()) break block6;
            Map.Entry entry = iterator.next();
            Assert.assertEquals((Object)mockRepairTimePartition.getDatabaseName(), (Object)((RepairTimePartition)entry.getKey()).getDatabaseName());
            Assert.assertEquals((Object)mockRepairTimePartition.getDataRegionId(), (Object)((RepairTimePartition)entry.getKey()).getDataRegionId());
            Assert.assertEquals((long)mockRepairTimePartition.getTimePartitionId(), (long)((RepairTimePartition)entry.getKey()).getTimePartitionId());
            Assert.assertTrue((boolean)((Set)entry.getValue()).contains(resource2.getTsFile().getName()));
        }
    }
}

