/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.repair;

import java.io.IOException;
import java.util.Arrays;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.AbstractCompactionTest;
import org.apache.iotdb.db.storageengine.dataregion.compaction.repair.RepairDataFileScanUtil;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.CompactionTestFileWriter;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RepairDataFileScanUtilTest
extends AbstractCompactionTest {
    @Override
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException, InterruptedException {
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        super.tearDown();
    }

    @Test
    public void testScanNormalFile() throws IOException {
        TsFileResource resource = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(resource);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDeviceWithNullValue(Arrays.asList("s0", "s1", "s2"), new TimeRange[]{new TimeRange(10L, 40L)}, TSEncoding.PLAIN, CompressionType.LZ4, Arrays.asList(false, false, true));
            writer.endChunkGroup();
            writer.startChunkGroup("d2");
            writer.generateSimpleNonAlignedSeriesToCurrentDevice("s0", new TimeRange[]{new TimeRange(10L, 40L)}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.generateSimpleNonAlignedSeriesToCurrentDevice("s1", new TimeRange[]{new TimeRange(40L, 40L), new TimeRange(50L, 70L)}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        RepairDataFileScanUtil scanUtil = new RepairDataFileScanUtil(resource);
        scanUtil.scanTsFile();
        Assert.assertFalse((boolean)scanUtil.isBrokenFile());
        Assert.assertFalse((boolean)scanUtil.hasUnsortedData());
    }

    @Test
    public void testScanUnsortedFile() throws IOException {
        TsFileResource resource1 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(resource1);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDeviceWithNullValue(Arrays.asList("s0", "s1", "s2"), new TimeRange[]{new TimeRange(10L, 40L), new TimeRange(20L, 50L)}, TSEncoding.PLAIN, CompressionType.LZ4, Arrays.asList(false, false, true));
            writer.endChunkGroup();
            writer.startChunkGroup("d2");
            writer.generateSimpleAlignedSeriesToCurrentDeviceWithNullValue(Arrays.asList("s0", "s1", "s2"), new TimeRange[]{new TimeRange(10L, 40L)}, TSEncoding.PLAIN, CompressionType.LZ4, Arrays.asList(false, false, true));
            writer.endChunkGroup();
            writer.endFile();
        }
        RepairDataFileScanUtil scanUtil1 = new RepairDataFileScanUtil(resource1);
        scanUtil1.scanTsFile();
        Assert.assertFalse((boolean)scanUtil1.isBrokenFile());
        Assert.assertTrue((boolean)scanUtil1.hasUnsortedData());
        TsFileResource resource2 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(resource2);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDeviceWithNullValue(Arrays.asList("s0", "s1", "s2"), new TimeRange[]{new TimeRange(10L, 40L)}, TSEncoding.PLAIN, CompressionType.LZ4, Arrays.asList(false, false, true));
            writer.endChunkGroup();
            writer.startChunkGroup("d2");
            writer.generateSimpleNonAlignedSeriesToCurrentDevice("s0", new TimeRange[]{new TimeRange(10L, 40L), new TimeRange(50L, 60L)}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.generateSimpleNonAlignedSeriesToCurrentDevice("s1", new TimeRange[]{new TimeRange(10L, 40L), new TimeRange(20L, 50L)}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        RepairDataFileScanUtil scanUtil2 = new RepairDataFileScanUtil(resource2);
        scanUtil2.scanTsFile();
        Assert.assertFalse((boolean)scanUtil2.isBrokenFile());
        Assert.assertTrue((boolean)scanUtil2.hasUnsortedData());
    }

    @Test
    public void testScanFileWithDifferentCompressionTypes() throws IOException {
        TsFileResource resource = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(resource);){
            writer.startChunkGroup("d1");
            writer.generateSimpleNonAlignedSeriesToCurrentDevice("s0", new TimeRange[]{new TimeRange(10L, 40L), new TimeRange(50L, 60L)}, TSEncoding.PLAIN, CompressionType.SNAPPY);
            writer.generateSimpleNonAlignedSeriesToCurrentDevice("s0", new TimeRange[]{new TimeRange(10L, 40L), new TimeRange(50L, 60L)}, TSEncoding.PLAIN, CompressionType.GZIP);
            writer.generateSimpleNonAlignedSeriesToCurrentDevice("s1", new TimeRange[]{new TimeRange(10L, 40L), new TimeRange(20L, 50L)}, TSEncoding.PLAIN, CompressionType.ZSTD);
            writer.endChunkGroup();
            writer.endFile();
        }
        RepairDataFileScanUtil scanUtil = new RepairDataFileScanUtil(resource);
        scanUtil.scanTsFile();
        Assert.assertFalse((boolean)scanUtil.isBrokenFile());
        Assert.assertTrue((boolean)scanUtil.hasUnsortedData());
    }
}

