/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.repair;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.AbstractCompactionTest;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;

public class AbstractRepairDataTest
extends AbstractCompactionTest {
    private File repairDataLogDir;

    @Override
    public void setUp() throws IOException, WriteProcessException, MetadataException, InterruptedException {
        super.setUp();
        this.repairDataLogDir = new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "repair");
    }

    @Override
    public void tearDown() throws IOException, StorageEngineException {
        super.tearDown();
        this.deleteRepairDataLogDir();
    }

    public File getEmptyRepairDataLogDir() throws IOException {
        this.deleteRepairDataLogDir();
        Files.createDirectory(this.repairDataLogDir.toPath(), new FileAttribute[0]);
        return this.repairDataLogDir;
    }

    private void deleteRepairDataLogDir() throws IOException {
        if (this.repairDataLogDir.exists()) {
            if (this.repairDataLogDir.isDirectory()) {
                File[] files = this.repairDataLogDir.listFiles();
                for (File file : files == null ? new File[]{} : files) {
                    Files.deleteIfExists(file.toPath());
                }
            }
            Files.deleteIfExists(this.repairDataLogDir.toPath());
        }
    }
}

