/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.recover;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.DataRegionException;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.ICompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.FastCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.recover.CompactionRecoverTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.InnerSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.subtask.FastCompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.log.CompactionLogger;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.log.SimpleCompactionLogger;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionTaskManager;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.CompactionConfigRestorer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.CompactionFileGeneratorUtils;
import org.apache.iotdb.db.storageengine.dataregion.flush.TsFileFlushPolicy;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.generator.TsFileNameGenerator;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SizeTieredCompactionRecoverTest {
    private ICompactionPerformer performer = new FastCompactionPerformer(false);
    static final String COMPACTION_TEST_SG = "root.compactionTest";
    static final String SEQ_FILE_DIR = TestConstant.BASE_OUTPUT_PATH + File.separator + "data" + File.separator + "sequence" + File.separator + "root.compactionTest" + File.separator + "0" + File.separator + "0";
    static final String UNSEQ_FILE_DIR = TestConstant.BASE_OUTPUT_PATH + File.separator + "data" + File.separator + "unsequence" + File.separator + "root.compactionTest" + File.separator + "0" + File.separator + "0";
    static final TsFileManager tsFileManager = new TsFileManager("root.compactionTest", "0", TestConstant.BASE_OUTPUT_PATH);
    static final String[] fullPaths = new String[]{"root.compactionTest.device0.sensor0", "root.compactionTest.device0.sensor1", "root.compactionTest.device0.sensor2", "root.compactionTest.device0.sensor3", "root.compactionTest.device0.sensor4", "root.compactionTest.device0.sensor5", "root.compactionTest.device0.sensor6", "root.compactionTest.device0.sensor7", "root.compactionTest.device0.sensor8", "root.compactionTest.device0.sensor9", "root.compactionTest.device1.sensor0", "root.compactionTest.device1.sensor1", "root.compactionTest.device1.sensor2", "root.compactionTest.device1.sensor3", "root.compactionTest.device1.sensor4"};
    static final MeasurementSchema[] schemas = new MeasurementSchema[fullPaths.length];
    static String logFilePath = TestConstant.BASE_OUTPUT_PATH + File.separator + "test-compaction.compaction.log";
    static String[][] originDataDirs = null;
    static String[][] testDataDirs = new String[][]{{TestConstant.BASE_OUTPUT_PATH + "data"}};
    static IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();

    @Before
    public void setUp() throws Exception {
        CompactionTaskManager.getInstance().start();
        originDataDirs = config.getTierDataDirs();
        this.setDataDirs(testDataDirs);
        if (!new File(SEQ_FILE_DIR).exists()) {
            Assert.assertTrue((boolean)new File(SEQ_FILE_DIR).mkdirs());
        }
        if (!new File(UNSEQ_FILE_DIR).exists()) {
            Assert.assertTrue((boolean)new File(UNSEQ_FILE_DIR).mkdirs());
        }
        this.createTimeSeries();
    }

    @After
    public void tearDown() throws Exception {
        File logFile;
        new CompactionConfigRestorer().restoreCompactionConfig();
        CompactionTaskManager.getInstance().stop();
        this.setDataDirs(originDataDirs);
        File dataDir = new File(testDataDirs[0][0]);
        if (dataDir.exists()) {
            FileUtils.forceDelete((File)dataDir);
        }
        if ((logFile = new File(logFilePath)).exists()) {
            Assert.assertTrue((boolean)logFile.delete());
        }
        EnvironmentUtils.cleanEnv();
    }

    private void createTimeSeries() throws MetadataException {
        PartialPath[] deviceIds = new PartialPath[fullPaths.length];
        for (int i = 0; i < fullPaths.length; ++i) {
            SizeTieredCompactionRecoverTest.schemas[i] = new MeasurementSchema(fullPaths[i].split("\\.")[3], TSDataType.INT64, TSEncoding.RLE, CompressionType.UNCOMPRESSED);
            deviceIds[i] = new PartialPath(fullPaths[i].substring(0, 27));
        }
    }

    public void setDataDirs(String[][] dataDirs) throws Exception {
        Class<?> configClass = config.getClass();
        Field dataDirsField = configClass.getDeclaredField("tierDataDirs");
        dataDirsField.setAccessible(true);
        dataDirsField.set(config, dataDirs);
    }

    @Test
    public void testRecoverWithUncorrectTimePartionDir() throws StartupException {
        StorageEngine.getInstance().start();
        try {
            File timePartitionDir = new File(SEQ_FILE_DIR);
            File f = new File(timePartitionDir.getParent() + File.separator + "test.tmp");
            f.createNewFile();
            new DataRegion(TestConstant.BASE_OUTPUT_PATH + File.separator + "data" + File.separator + "sequence", "0", (TsFileFlushPolicy)new TsFileFlushPolicy.DirectFlushPolicy(), COMPACTION_TEST_SG);
        }
        catch (IOException | DataRegionException e) {
            Assert.fail((String)e.getMessage());
        }
        finally {
            StorageEngine.getInstance().stop();
        }
    }

    private List<TsFileResource> getSourceFiles() throws IllegalPathException, IOException {
        ArrayList<TsFileResource> sourceFiles = new ArrayList<TsFileResource>();
        for (int i = 0; i < 10; ++i) {
            HashSet<String> fullPath = new HashSet<String>(Arrays.asList(fullPaths));
            ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
            ArrayList<Long> pagePointsNum = new ArrayList<Long>();
            pagePointsNum.add(100L);
            chunkPagePointsNum.add(pagePointsNum);
            TsFileResource tsFileResource = new TsFileResource(new File(SEQ_FILE_DIR + File.separator.concat(i + "-" + i + "-" + 0 + "-" + 0 + ".tsfile")));
            CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 100, tsFileResource);
            sourceFiles.add(tsFileResource);
        }
        return sourceFiles;
    }

    @Test
    public void testRecoverWithCompleteTargetFileUsingFileInfo() throws Exception {
        List<TsFileResource> sourceFiles = this.getSourceFiles();
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource(sourceFiles, (boolean)true);
        CompactionLogger compactionLogger = new CompactionLogger(new File(logFilePath));
        compactionLogger.logFiles(sourceFiles, "source");
        compactionLogger.logFile(targetResource, "target");
        compactionLogger.close();
        this.performer.setSourceFiles(sourceFiles);
        this.performer.setTargetFiles(Collections.singletonList(targetResource));
        this.performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        this.performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)COMPACTION_TEST_SG);
        CompactionRecoverTask recoverTask = new CompactionRecoverTask(COMPACTION_TEST_SG, "0", tsFileManager, new File(logFilePath), true);
        recoverTask.doCompaction();
        for (TsFileResource resource : sourceFiles) {
            Assert.assertTrue((boolean)resource.getTsFile().exists());
        }
        Assert.assertFalse((boolean)targetResource.getTsFile().exists());
    }

    @Test
    public void testInnerRecoverWithCompleteTargetFileUsingFileInfo() throws Exception {
        List<TsFileResource> sourceFiles = this.getSourceFiles();
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource(sourceFiles, (boolean)true);
        SimpleCompactionLogger compactionLogger = new SimpleCompactionLogger(new File(logFilePath));
        compactionLogger.logSourceFiles(sourceFiles);
        compactionLogger.logTargetFile(targetResource);
        compactionLogger.close();
        this.performer.setSourceFiles(sourceFiles);
        this.performer.setTargetFiles(Collections.singletonList(targetResource));
        this.performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        this.performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)COMPACTION_TEST_SG);
        InnerSpaceCompactionTask innerSpaceCompactionTask = new InnerSpaceCompactionTask(COMPACTION_TEST_SG, "0", tsFileManager, new File(logFilePath));
        innerSpaceCompactionTask.recover();
        for (TsFileResource resource : sourceFiles) {
            Assert.assertTrue((boolean)resource.getTsFile().exists());
        }
        Assert.assertFalse((boolean)targetResource.getTsFile().exists());
    }

    @Test
    public void testRecoverWithIncompleteTargetFileUsingFileInfo() throws Exception {
        List<TsFileResource> sourceFiles = this.getSourceFiles();
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource(sourceFiles, (boolean)true);
        CompactionLogger compactionLogger = new CompactionLogger(new File(logFilePath));
        compactionLogger.logFiles(sourceFiles, "source");
        compactionLogger.logFiles(Collections.singletonList(targetResource), "target");
        compactionLogger.close();
        this.performer.setSourceFiles(sourceFiles);
        this.performer.setTargetFiles(Collections.singletonList(targetResource));
        this.performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        this.performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)COMPACTION_TEST_SG);
        FileOutputStream targetStream = new FileOutputStream(targetResource.getTsFile(), true);
        FileChannel channel = targetStream.getChannel();
        channel.truncate(targetResource.getTsFile().length() - 100L);
        channel.close();
        CompactionRecoverTask recoverTask = new CompactionRecoverTask(COMPACTION_TEST_SG, "0", tsFileManager, new File(logFilePath), true);
        recoverTask.doCompaction();
        for (TsFileResource resource : sourceFiles) {
            Assert.assertTrue((boolean)resource.getTsFile().exists());
        }
        Assert.assertFalse((boolean)targetResource.getTsFile().exists());
    }

    @Test
    public void testInnerRecoverWithIncompleteTargetFileUsingFileInfo() throws Exception {
        List<TsFileResource> sourceFiles = this.getSourceFiles();
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource(sourceFiles, (boolean)true);
        SimpleCompactionLogger compactionLogger = new SimpleCompactionLogger(new File(logFilePath));
        compactionLogger.logSourceFiles(sourceFiles);
        compactionLogger.logTargetFile(targetResource);
        compactionLogger.close();
        this.performer.setSourceFiles(sourceFiles);
        this.performer.setTargetFiles(Collections.singletonList(targetResource));
        this.performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        this.performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)COMPACTION_TEST_SG);
        FileOutputStream targetStream = new FileOutputStream(targetResource.getTsFile(), true);
        FileChannel channel = targetStream.getChannel();
        channel.truncate(targetResource.getTsFile().length() - 100L);
        channel.close();
        InnerSpaceCompactionTask recoverTask = new InnerSpaceCompactionTask(COMPACTION_TEST_SG, "0", tsFileManager, new File(logFilePath));
        recoverTask.recover();
        for (TsFileResource resource : sourceFiles) {
            Assert.assertTrue((boolean)resource.getTsFile().exists());
        }
        Assert.assertFalse((boolean)targetResource.getTsFile().exists());
    }

    @Test
    public void testRecoverWithCompleteTargetFileUsingFilePath() throws Exception {
        List<TsFileResource> sourceFiles = this.getSourceFiles();
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource(sourceFiles, (boolean)true);
        CompactionLogger logger = new CompactionLogger(new File(logFilePath));
        logger.logFiles(sourceFiles, "source");
        logger.logFiles(Collections.singletonList(targetResource), "target");
        logger.close();
        this.performer.setSourceFiles(sourceFiles);
        this.performer.setTargetFiles(Collections.singletonList(targetResource));
        this.performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        this.performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)COMPACTION_TEST_SG);
        CompactionRecoverTask recoverTask = new CompactionRecoverTask(COMPACTION_TEST_SG, "0", tsFileManager, new File(logFilePath), true);
        recoverTask.doCompaction();
        for (TsFileResource resource : sourceFiles) {
            Assert.assertTrue((boolean)resource.getTsFile().exists());
        }
        Assert.assertFalse((boolean)targetResource.getTsFile().exists());
    }

    @Test
    public void testInnerRecoverWithCompleteTargetFileUsingFilePath() throws Exception {
        List<TsFileResource> sourceFiles = this.getSourceFiles();
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource(sourceFiles, (boolean)true);
        SimpleCompactionLogger logger = new SimpleCompactionLogger(new File(logFilePath));
        logger.logSourceFiles(sourceFiles);
        logger.logTargetFile(targetResource);
        logger.close();
        this.performer.setSourceFiles(sourceFiles);
        this.performer.setTargetFiles(Collections.singletonList(targetResource));
        this.performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        this.performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)COMPACTION_TEST_SG);
        InnerSpaceCompactionTask innerSpaceCompactionTask = new InnerSpaceCompactionTask(COMPACTION_TEST_SG, "0", tsFileManager, new File(logFilePath));
        innerSpaceCompactionTask.recover();
        for (TsFileResource resource : sourceFiles) {
            Assert.assertTrue((boolean)resource.getTsFile().exists());
        }
        Assert.assertFalse((boolean)targetResource.getTsFile().exists());
    }

    @Test
    public void testRecoverWithIncompleteTargetFileUsingFilePath() throws Exception {
        List<TsFileResource> sourceFiles = this.getSourceFiles();
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource(sourceFiles, (boolean)true);
        CompactionLogger compactionLogger = new CompactionLogger(new File(logFilePath));
        compactionLogger.logFiles(sourceFiles, "source");
        compactionLogger.logFiles(Collections.singletonList(targetResource), "target");
        compactionLogger.close();
        this.performer.setSourceFiles(sourceFiles);
        this.performer.setTargetFiles(Collections.singletonList(targetResource));
        this.performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        this.performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)COMPACTION_TEST_SG);
        FileOutputStream targetStream = new FileOutputStream(targetResource.getTsFile(), true);
        FileChannel channel = targetStream.getChannel();
        channel.truncate(targetResource.getTsFile().length() - 100L);
        channel.close();
        CompactionRecoverTask recoverTask = new CompactionRecoverTask(COMPACTION_TEST_SG, "0", tsFileManager, new File(logFilePath), true);
        recoverTask.doCompaction();
        for (TsFileResource resource : sourceFiles) {
            Assert.assertTrue((boolean)resource.getTsFile().exists());
        }
        Assert.assertFalse((boolean)targetResource.getTsFile().exists());
    }

    @Test
    public void testInnerRecoverWithIncompleteTargetFileUsingFilePath() throws Exception {
        List<TsFileResource> sourceFiles = this.getSourceFiles();
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource(sourceFiles, (boolean)true);
        SimpleCompactionLogger compactionLogger = new SimpleCompactionLogger(new File(logFilePath));
        compactionLogger.logSourceFiles(sourceFiles);
        compactionLogger.logTargetFile(targetResource);
        compactionLogger.close();
        this.performer.setSourceFiles(sourceFiles);
        this.performer.setTargetFiles(Collections.singletonList(targetResource));
        this.performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        this.performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)COMPACTION_TEST_SG);
        FileOutputStream targetStream = new FileOutputStream(targetResource.getTsFile(), true);
        FileChannel channel = targetStream.getChannel();
        channel.truncate(targetResource.getTsFile().length() - 100L);
        channel.close();
        InnerSpaceCompactionTask innerSpaceCompactionTask = new InnerSpaceCompactionTask(COMPACTION_TEST_SG, "0", tsFileManager, new File(logFilePath));
        innerSpaceCompactionTask.recover();
        for (TsFileResource resource : sourceFiles) {
            Assert.assertTrue((boolean)resource.getTsFile().exists());
        }
        Assert.assertFalse((boolean)targetResource.getTsFile().exists());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRecoverWithCompleteTargetFileUsingFileInfoAndChangingDataDirs() throws Exception {
        try {
            List<TsFileResource> sourceFiles = this.getSourceFiles();
            ArrayList sourceFileNames = new ArrayList();
            sourceFiles.forEach(f -> sourceFileNames.add(f.getTsFile().getName()));
            TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource(sourceFiles, (boolean)true);
            CompactionLogger compactionLogger = new CompactionLogger(new File(logFilePath));
            compactionLogger.logFiles(sourceFiles, "source");
            compactionLogger.logFiles(Collections.singletonList(targetResource), "target");
            compactionLogger.close();
            this.performer.setSourceFiles(sourceFiles);
            this.performer.setTargetFiles(Collections.singletonList(targetResource));
            this.performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
            this.performer.perform();
            CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)COMPACTION_TEST_SG);
            FileUtils.moveDirectory((File)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data"), (File)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1"));
            this.setDataDirs(new String[][]{{TestConstant.BASE_OUTPUT_PATH + File.separator + "data1"}});
            CompactionRecoverTask recoverTask = new CompactionRecoverTask(COMPACTION_TEST_SG, "0", tsFileManager, new File(logFilePath), true);
            recoverTask.doCompaction();
            for (String sourceFileName : sourceFileNames) {
                Assert.assertTrue((boolean)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1" + File.separator + "sequence" + File.separator + COMPACTION_TEST_SG + File.separator + "0" + File.separator + "0", sourceFileName).exists());
            }
            File targetFileAfterMoved = new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1" + File.separator + "sequence" + File.separator + COMPACTION_TEST_SG + File.separator + "0" + File.separator + "0", targetResource.getTsFile().getName().replace(".inner", ".tsfile"));
            Assert.assertFalse((boolean)targetFileAfterMoved.exists());
        }
        finally {
            FileUtils.deleteDirectory((File)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInnerRecoverWithCompleteTargetFileUsingFileInfoAndChangingDataDirs() throws Exception {
        try {
            List<TsFileResource> sourceFiles = this.getSourceFiles();
            ArrayList sourceFileNames = new ArrayList();
            sourceFiles.forEach(f -> sourceFileNames.add(f.getTsFile().getName()));
            TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource(sourceFiles, (boolean)true);
            SimpleCompactionLogger compactionLogger = new SimpleCompactionLogger(new File(logFilePath));
            compactionLogger.logSourceFiles(sourceFiles);
            compactionLogger.logTargetFile(targetResource);
            compactionLogger.close();
            this.performer.setSourceFiles(sourceFiles);
            this.performer.setTargetFiles(Collections.singletonList(targetResource));
            this.performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
            this.performer.perform();
            CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)COMPACTION_TEST_SG);
            FileUtils.moveDirectory((File)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data"), (File)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1"));
            this.setDataDirs(new String[][]{{TestConstant.BASE_OUTPUT_PATH + File.separator + "data1"}});
            InnerSpaceCompactionTask recoverTask = new InnerSpaceCompactionTask(COMPACTION_TEST_SG, "0", tsFileManager, new File(logFilePath));
            recoverTask.recover();
            for (String sourceFileName : sourceFileNames) {
                Assert.assertTrue((boolean)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1" + File.separator + "sequence" + File.separator + COMPACTION_TEST_SG + File.separator + "0" + File.separator + "0", sourceFileName).exists());
            }
            File targetFileAfterMoved = new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1" + File.separator + "sequence" + File.separator + COMPACTION_TEST_SG + File.separator + "0" + File.separator + "0", targetResource.getTsFile().getName().replace(".inner", ".tsfile"));
            Assert.assertFalse((boolean)targetFileAfterMoved.exists());
        }
        finally {
            FileUtils.deleteDirectory((File)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRecoverWithIncompleteTargetFileUsingFileInfoAndChangingDataDirs() throws Exception {
        try {
            List<TsFileResource> sourceFiles = this.getSourceFiles();
            ArrayList sourceFileNames = new ArrayList();
            sourceFiles.forEach(f -> sourceFileNames.add(f.getTsFile().getName()));
            TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource(sourceFiles, (boolean)true);
            CompactionLogger compactionLogger = new CompactionLogger(new File(logFilePath));
            compactionLogger.logFiles(sourceFiles, "source");
            compactionLogger.logFiles(Collections.singletonList(targetResource), "target");
            compactionLogger.close();
            this.performer.setSourceFiles(sourceFiles);
            this.performer.setTargetFiles(Collections.singletonList(targetResource));
            this.performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
            this.performer.perform();
            CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)COMPACTION_TEST_SG);
            FileOutputStream targetStream = new FileOutputStream(targetResource.getTsFile(), true);
            FileChannel channel = targetStream.getChannel();
            channel.truncate(targetResource.getTsFile().length() - 100L);
            channel.close();
            FileUtils.moveDirectory((File)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data"), (File)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1"));
            this.setDataDirs(new String[][]{{TestConstant.BASE_OUTPUT_PATH + File.separator + "data1"}});
            CompactionRecoverTask recoverTask = new CompactionRecoverTask(COMPACTION_TEST_SG, "0", tsFileManager, new File(logFilePath), true);
            recoverTask.doCompaction();
            for (String sourceFileName : sourceFileNames) {
                Assert.assertTrue((boolean)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1" + File.separator + "sequence" + File.separator + COMPACTION_TEST_SG + File.separator + "0" + File.separator + "0", sourceFileName).exists());
            }
            Assert.assertFalse((boolean)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1" + File.separator + "sequence" + File.separator + COMPACTION_TEST_SG + File.separator + "0" + File.separator + "0", targetResource.getTsFile().getName()).exists());
        }
        finally {
            FileUtils.deleteDirectory((File)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInnerRecoverWithIncompleteTargetFileUsingFileInfoAndChangingDataDirs() throws Exception {
        try {
            List<TsFileResource> sourceFiles = this.getSourceFiles();
            ArrayList sourceFileNames = new ArrayList();
            sourceFiles.forEach(f -> sourceFileNames.add(f.getTsFile().getName()));
            TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource(sourceFiles, (boolean)true);
            SimpleCompactionLogger compactionLogger = new SimpleCompactionLogger(new File(logFilePath));
            compactionLogger.logSourceFiles(sourceFiles);
            compactionLogger.logTargetFile(targetResource);
            compactionLogger.close();
            this.performer.setSourceFiles(sourceFiles);
            this.performer.setTargetFiles(Collections.singletonList(targetResource));
            this.performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
            this.performer.perform();
            CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)COMPACTION_TEST_SG);
            FileOutputStream targetStream = new FileOutputStream(targetResource.getTsFile(), true);
            FileChannel channel = targetStream.getChannel();
            channel.truncate(targetResource.getTsFile().length() - 100L);
            channel.close();
            FileUtils.moveDirectory((File)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data"), (File)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1"));
            this.setDataDirs(new String[][]{{TestConstant.BASE_OUTPUT_PATH + File.separator + "data1"}});
            InnerSpaceCompactionTask recoverTask = new InnerSpaceCompactionTask(COMPACTION_TEST_SG, "0", tsFileManager, new File(logFilePath));
            recoverTask.recover();
            for (String sourceFileName : sourceFileNames) {
                Assert.assertTrue((boolean)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1" + File.separator + "sequence" + File.separator + COMPACTION_TEST_SG + File.separator + "0" + File.separator + "0", sourceFileName).exists());
            }
            Assert.assertFalse((boolean)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1" + File.separator + "sequence" + File.separator + COMPACTION_TEST_SG + File.separator + "0" + File.separator + "0", targetResource.getTsFile().getName()).exists());
        }
        finally {
            FileUtils.deleteDirectory((File)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRecoverWithCompleteTargetFileUsingFilePathAndChangingDataDirs() throws Exception {
        try {
            List<TsFileResource> sourceFiles = this.getSourceFiles();
            ArrayList sourceFileNames = new ArrayList();
            sourceFiles.forEach(f -> sourceFileNames.add(f.getTsFile().getName()));
            TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource(sourceFiles, (boolean)true);
            CompactionLogger compactionLogger = new CompactionLogger(new File(logFilePath));
            compactionLogger.logFiles(sourceFiles, "source");
            compactionLogger.logFiles(Collections.singletonList(targetResource), "target");
            compactionLogger.close();
            this.performer.setSourceFiles(sourceFiles);
            this.performer.setTargetFiles(Collections.singletonList(targetResource));
            this.performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
            this.performer.perform();
            CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)COMPACTION_TEST_SG);
            FileUtils.moveDirectory((File)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data"), (File)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1"));
            this.setDataDirs(new String[][]{{TestConstant.BASE_OUTPUT_PATH + File.separator + "data1"}});
            CompactionRecoverTask recoverTask = new CompactionRecoverTask(COMPACTION_TEST_SG, "0", tsFileManager, new File(logFilePath), true);
            recoverTask.doCompaction();
            for (String sourceFileName : sourceFileNames) {
                Assert.assertTrue((boolean)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1" + File.separator + "sequence" + File.separator + COMPACTION_TEST_SG + File.separator + "0" + File.separator + "0", sourceFileName).exists());
            }
            File targetFileAfterMoved = new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1" + File.separator + "sequence" + File.separator + COMPACTION_TEST_SG + File.separator + "0" + File.separator + "0", targetResource.getTsFile().getName().replace(".inner", ".tsfile"));
            Assert.assertFalse((boolean)targetFileAfterMoved.exists());
        }
        finally {
            FileUtils.deleteDirectory((File)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInnerRecoverWithCompleteTargetFileUsingFilePathAndChangingDataDirs() throws Exception {
        try {
            List<TsFileResource> sourceFiles = this.getSourceFiles();
            ArrayList sourceFileNames = new ArrayList();
            sourceFiles.forEach(f -> sourceFileNames.add(f.getTsFile().getName()));
            TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource(sourceFiles, (boolean)true);
            SimpleCompactionLogger compactionLogger = new SimpleCompactionLogger(new File(logFilePath));
            compactionLogger.logSourceFiles(sourceFiles);
            compactionLogger.logTargetFile(targetResource);
            compactionLogger.close();
            this.performer.setSourceFiles(sourceFiles);
            this.performer.setTargetFiles(Collections.singletonList(targetResource));
            this.performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
            this.performer.perform();
            CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)COMPACTION_TEST_SG);
            FileUtils.moveDirectory((File)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data"), (File)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1"));
            this.setDataDirs(new String[][]{{TestConstant.BASE_OUTPUT_PATH + File.separator + "data1"}});
            InnerSpaceCompactionTask recoverTask = new InnerSpaceCompactionTask(COMPACTION_TEST_SG, "0", tsFileManager, new File(logFilePath));
            recoverTask.recover();
            for (String sourceFileName : sourceFileNames) {
                Assert.assertTrue((boolean)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1" + File.separator + "sequence" + File.separator + COMPACTION_TEST_SG + File.separator + "0" + File.separator + "0", sourceFileName).exists());
            }
            File targetFileAfterMoved = new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1" + File.separator + "sequence" + File.separator + COMPACTION_TEST_SG + File.separator + "0" + File.separator + "0", targetResource.getTsFile().getName().replace(".inner", ".tsfile"));
            Assert.assertFalse((boolean)targetFileAfterMoved.exists());
        }
        finally {
            FileUtils.deleteDirectory((File)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRecoverWithIncompleteTargetFileUsingFilePathAndChangingDataDirs() throws Exception {
        try {
            List<TsFileResource> sourceFiles = this.getSourceFiles();
            ArrayList sourceFileNames = new ArrayList();
            sourceFiles.forEach(f -> sourceFileNames.add(f.getTsFile().getName()));
            TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource(sourceFiles, (boolean)true);
            CompactionLogger compactionLogger = new CompactionLogger(new File(logFilePath));
            compactionLogger.logFiles(sourceFiles, "source");
            compactionLogger.logFiles(Collections.singletonList(targetResource), "target");
            compactionLogger.close();
            this.performer.setSourceFiles(sourceFiles);
            this.performer.setTargetFiles(Collections.singletonList(targetResource));
            this.performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
            this.performer.perform();
            CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)COMPACTION_TEST_SG);
            FileOutputStream targetStream = new FileOutputStream(targetResource.getTsFile(), true);
            FileChannel channel = targetStream.getChannel();
            channel.truncate(targetResource.getTsFile().length() - 100L);
            channel.close();
            FileUtils.moveDirectory((File)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data"), (File)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1"));
            this.setDataDirs(new String[][]{{TestConstant.BASE_OUTPUT_PATH + File.separator + "data1"}});
            CompactionRecoverTask recoverTask = new CompactionRecoverTask(COMPACTION_TEST_SG, "0", tsFileManager, new File(logFilePath), true);
            recoverTask.doCompaction();
            for (String sourceFileName : sourceFileNames) {
                Assert.assertTrue((boolean)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1" + File.separator + "sequence" + File.separator + COMPACTION_TEST_SG + File.separator + "0" + File.separator + "0", sourceFileName).exists());
            }
            Assert.assertFalse((boolean)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1" + File.separator + "sequence" + File.separator + COMPACTION_TEST_SG + File.separator + "0" + File.separator + "0", targetResource.getTsFile().getName()).exists());
        }
        finally {
            FileUtils.deleteDirectory((File)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInnerRecoverWithIncompleteTargetFileUsingFilePathAndChangingDataDirs() throws Exception {
        try {
            List<TsFileResource> sourceFiles = this.getSourceFiles();
            ArrayList sourceFileNames = new ArrayList();
            sourceFiles.forEach(f -> sourceFileNames.add(f.getTsFile().getName()));
            TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource(sourceFiles, (boolean)true);
            SimpleCompactionLogger compactionLogger = new SimpleCompactionLogger(new File(logFilePath));
            compactionLogger.logSourceFiles(sourceFiles);
            compactionLogger.logTargetFile(targetResource);
            compactionLogger.close();
            this.performer.setSourceFiles(sourceFiles);
            this.performer.setTargetFiles(Collections.singletonList(targetResource));
            this.performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
            this.performer.perform();
            CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)COMPACTION_TEST_SG);
            FileOutputStream targetStream = new FileOutputStream(targetResource.getTsFile(), true);
            FileChannel channel = targetStream.getChannel();
            channel.truncate(targetResource.getTsFile().length() - 100L);
            channel.close();
            FileUtils.moveDirectory((File)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data"), (File)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1"));
            this.setDataDirs(new String[][]{{TestConstant.BASE_OUTPUT_PATH + File.separator + "data1"}});
            InnerSpaceCompactionTask recoverTask = new InnerSpaceCompactionTask(COMPACTION_TEST_SG, "0", tsFileManager, new File(logFilePath));
            recoverTask.recover();
            for (String sourceFileName : sourceFileNames) {
                Assert.assertTrue((boolean)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1" + File.separator + "sequence" + File.separator + COMPACTION_TEST_SG + File.separator + "0" + File.separator + "0", sourceFileName).exists());
            }
            Assert.assertFalse((boolean)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1" + File.separator + "sequence" + File.separator + COMPACTION_TEST_SG + File.separator + "0" + File.separator + "0", targetResource.getTsFile().getName()).exists());
        }
        finally {
            FileUtils.deleteDirectory((File)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1"));
        }
    }
}

