/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.inner.sizetiered;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.storageengine.buffer.ChunkCache;
import org.apache.iotdb.db.storageengine.buffer.TimeSeriesMetadataCache;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.ICompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.FastCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.recover.CompactionRecoverTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.subtask.FastCompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.log.CompactionLogger;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.reader.SeriesDataBlockReader;
import org.apache.iotdb.db.storageengine.dataregion.compaction.inner.AbstractInnerSpaceCompactionTest;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.CompactionConfigRestorer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.CompactionFileGeneratorUtils;
import org.apache.iotdb.db.storageengine.dataregion.read.control.FileReaderManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.generator.TsFileNameGenerator;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.SchemaTestUtils;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.writer.TsFileOutput;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SizeTieredCompactionRecoverTest
extends AbstractInnerSpaceCompactionTest {
    ICompactionPerformer performer = new FastCompactionPerformer(false);

    @Override
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException {
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        new CompactionConfigRestorer().restoreCompactionConfig();
        super.tearDown();
    }

    @Test
    public void testCompactionRecoverWithUncompletedTargetFileAndLog() throws Exception {
        String line;
        TsFileManager tsFileManager = new TsFileManager("root.compactionTest", "0", this.tempSGDir.getAbsolutePath());
        tsFileManager.addAll(this.seqResources, true);
        tsFileManager.addAll(this.unseqResources, false);
        MeasurementPath path = SchemaTestUtils.getMeasurementPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        SeriesDataBlockReader tsFilesReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), tsFileManager.getTsFileList(true), new ArrayList(), true);
        int count = 0;
        while (tsFilesReader.hasNextBatch()) {
            TsBlock batchData = tsFilesReader.nextBatch();
            int size = batchData.getPositionCount();
            for (int i = 0; i < size; ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getColumn(0).getDouble(i), (double)0.001);
                ++count;
            }
        }
        tsFilesReader.close();
        this.closeTsFileSequenceReader();
        Assert.assertEquals((long)500L, (long)count);
        TsFileResource targetTsFileResource = new TsFileResource(new File(SEQ_DIRS + File.separator.concat("0-0-1-0.inner")));
        File compactionLogFile = new File(((TsFileResource)this.seqResources.get(0)).getTsFile().getParent() + File.separator + targetTsFileResource.getTsFile().getName() + ".inner-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(compactionLogFile);
        ArrayList<TsFileResource> tmpSeqResources = new ArrayList<TsFileResource>();
        tmpSeqResources.add((TsFileResource)this.seqResources.get(0));
        tmpSeqResources.add((TsFileResource)this.seqResources.get(1));
        tmpSeqResources.add((TsFileResource)this.seqResources.get(2));
        compactionLogger.logFiles(tmpSeqResources, "source");
        compactionLogger.logFiles(Collections.singletonList(targetTsFileResource), "target");
        this.deleteFileIfExists(targetTsFileResource.getTsFile());
        this.performer.setSourceFiles(new ArrayList(this.seqResources.subList(0, 3)));
        this.performer.setTargetFiles(Collections.singletonList(targetTsFileResource));
        this.performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        this.performer.perform();
        compactionLogger.close();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetTsFileResource), (boolean)true, (String)"root.compactionTest");
        BufferedReader logReader = new BufferedReader(new FileReader(compactionLogFile));
        ArrayList<String> logs = new ArrayList<String>();
        while ((line = logReader.readLine()) != null) {
            logs.add(line);
        }
        logReader.close();
        BufferedWriter logStream = new BufferedWriter(new FileWriter(SystemFileFactory.INSTANCE.getFile(this.tempSGDir.getPath(), "root.compactionTest.inner-compaction.log"), false));
        for (int i = 0; i < logs.size() - 1; ++i) {
            logStream.write((String)logs.get(i));
            logStream.newLine();
        }
        logStream.close();
        TsFileOutput out = FSFactoryProducer.getFileOutputFactory().getTsFileOutput(targetTsFileResource.getTsFile().getPath(), true);
        out.truncate((long)((double)targetTsFileResource.getTsFileSize() * 0.9));
        out.close();
        new CompactionRecoverTask("root.compactionTest", "0", tsFileManager, compactionLogFile, true).doCompaction();
        path = SchemaTestUtils.getMeasurementPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        tsFilesReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), tsFileManager.getTsFileList(true), new ArrayList(), true);
        count = 0;
        while (tsFilesReader.hasNextBatch()) {
            TsBlock batchData = tsFilesReader.nextBatch();
            int size = batchData.getPositionCount();
            for (int i = 0; i < size; ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getColumn(0).getDouble(i), (double)0.001);
                ++count;
            }
        }
        tsFilesReader.close();
        this.closeTsFileSequenceReader();
        Assert.assertEquals((long)500L, (long)count);
    }

    @Test
    public void testRecoverWithAllSourceFilesExisted() throws Exception {
        TsFileManager tsFileManager = new TsFileManager("root.compactionTest", "0", this.tempSGDir.getAbsolutePath());
        tsFileManager.addAll(this.seqResources, true);
        tsFileManager.addAll(this.unseqResources, false);
        MeasurementPath path = SchemaTestUtils.getMeasurementPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        SeriesDataBlockReader tsFilesReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), tsFileManager.getTsFileList(true), new ArrayList(), true);
        int count = 0;
        while (tsFilesReader.hasNextBatch()) {
            TsBlock batchData = tsFilesReader.nextBatch();
            int size = batchData.getPositionCount();
            for (int i = 0; i < size; ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getColumn(0).getDouble(i), (double)0.001);
                ++count;
            }
        }
        tsFilesReader.close();
        this.closeTsFileSequenceReader();
        Assert.assertEquals((long)500L, (long)count);
        TsFileResource targetTsFileResource = new TsFileResource(new File(SEQ_DIRS + File.separator.concat("0-0-1-0.inner")));
        File compactionLogFile = new File(((TsFileResource)this.seqResources.get(0)).getTsFile().getParent() + File.separator + targetTsFileResource.getTsFile().getName() + ".inner-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(compactionLogFile);
        ArrayList<TsFileResource> tmpSeqResources = new ArrayList<TsFileResource>();
        tmpSeqResources.add((TsFileResource)this.seqResources.get(0));
        tmpSeqResources.add((TsFileResource)this.seqResources.get(1));
        tmpSeqResources.add((TsFileResource)this.seqResources.get(2));
        compactionLogger.logFiles(tmpSeqResources, "source");
        compactionLogger.logFiles(Collections.singletonList(targetTsFileResource), "target");
        this.deleteFileIfExists(targetTsFileResource.getTsFile());
        this.performer.setSourceFiles(new ArrayList(this.seqResources.subList(0, 3)));
        this.performer.setTargetFiles(Collections.singletonList(targetTsFileResource));
        this.performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        this.performer.perform();
        compactionLogger.close();
        new CompactionRecoverTask("root.compactionTest", "0", tsFileManager, compactionLogFile, true).doCompaction();
        Assert.assertTrue((boolean)((TsFileResource)this.seqResources.get(0)).getTsFile().exists());
        Assert.assertTrue((boolean)((TsFileResource)this.seqResources.get(1)).getTsFile().exists());
        Assert.assertTrue((boolean)((TsFileResource)this.seqResources.get(2)).getTsFile().exists());
        Assert.assertFalse((boolean)targetTsFileResource.getTsFile().exists());
        Assert.assertFalse((boolean)new File(targetTsFileResource.getTsFilePath().replace(".inner", ".tsfile")).exists());
        Assert.assertFalse((boolean)new File(targetTsFileResource.getTsFilePath() + ".resource").exists());
        path = SchemaTestUtils.getMeasurementPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        tsFilesReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), tsFileManager.getTsFileList(true), new ArrayList(), true);
        count = 0;
        while (tsFilesReader.hasNextBatch()) {
            TsBlock batchData = tsFilesReader.nextBatch();
            int size = batchData.getPositionCount();
            for (int i = 0; i < size; ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getColumn(0).getDouble(i), (double)0.001);
                ++count;
            }
        }
        tsFilesReader.close();
        this.closeTsFileSequenceReader();
        Assert.assertEquals((long)500L, (long)count);
    }

    @Test
    public void testRecoverWithAllSourceFilesExistedAndTargetFileNotExist() throws Exception {
        TsFileManager tsFileManager = new TsFileManager("root.compactionTest", "0", this.tempSGDir.getAbsolutePath());
        tsFileManager.addAll(this.seqResources, true);
        tsFileManager.addAll(this.unseqResources, false);
        MeasurementPath path = SchemaTestUtils.getMeasurementPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        SeriesDataBlockReader tsFilesReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), tsFileManager.getTsFileList(true), new ArrayList(), true);
        int count = 0;
        while (tsFilesReader.hasNextBatch()) {
            TsBlock batchData = tsFilesReader.nextBatch();
            int size = batchData.getPositionCount();
            for (int i = 0; i < size; ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getColumn(0).getDouble(i), (double)0.001);
                ++count;
            }
        }
        tsFilesReader.close();
        this.closeTsFileSequenceReader();
        Assert.assertEquals((long)500L, (long)count);
        TsFileResource targetTsFileResource = new TsFileResource(new File(SEQ_DIRS + File.separator.concat("0-0-1-0.inner")));
        File compactionLogFile = new File(((TsFileResource)this.seqResources.get(0)).getTsFile().getParent() + File.separator + targetTsFileResource.getTsFile().getName() + ".inner-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(compactionLogFile);
        ArrayList<TsFileResource> tmpSeqResources = new ArrayList<TsFileResource>();
        tmpSeqResources.add((TsFileResource)this.seqResources.get(0));
        tmpSeqResources.add((TsFileResource)this.seqResources.get(1));
        tmpSeqResources.add((TsFileResource)this.seqResources.get(2));
        compactionLogger.logFiles(tmpSeqResources, "source");
        compactionLogger.logFiles(Collections.singletonList(targetTsFileResource), "target");
        this.deleteFileIfExists(targetTsFileResource.getTsFile());
        this.performer.setSourceFiles(new ArrayList(this.seqResources.subList(0, 3)));
        this.performer.setTargetFiles(Collections.singletonList(targetTsFileResource));
        this.performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        this.performer.perform();
        targetTsFileResource.remove();
        compactionLogger.close();
        new CompactionRecoverTask("root.compactionTest", "0", tsFileManager, compactionLogFile, true).doCompaction();
        Assert.assertTrue((boolean)((TsFileResource)this.seqResources.get(0)).getTsFile().exists());
        Assert.assertTrue((boolean)((TsFileResource)this.seqResources.get(1)).getTsFile().exists());
        Assert.assertTrue((boolean)((TsFileResource)this.seqResources.get(2)).getTsFile().exists());
        Assert.assertFalse((boolean)targetTsFileResource.getTsFile().exists());
        Assert.assertFalse((boolean)new File(targetTsFileResource.getTsFilePath().replace(".inner", ".tsfile")).exists());
        Assert.assertFalse((boolean)new File(targetTsFileResource.getTsFilePath() + ".resource").exists());
        path = SchemaTestUtils.getMeasurementPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        tsFilesReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), tsFileManager.getTsFileList(true), new ArrayList(), true);
        count = 0;
        while (tsFilesReader.hasNextBatch()) {
            TsBlock batchData = tsFilesReader.nextBatch();
            int size = batchData.getPositionCount();
            for (int i = 0; i < size; ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getColumn(0).getDouble(i), (double)0.001);
                ++count;
            }
        }
        tsFilesReader.close();
        this.closeTsFileSequenceReader();
        Assert.assertEquals((long)500L, (long)count);
    }

    @Test
    public void testRecoverWithoutAllSourceFilesExisted() throws Exception {
        TsFileManager tsFileManager = new TsFileManager("root.compactionTest", "0", this.tempSGDir.getAbsolutePath());
        tsFileManager.addAll(this.seqResources, true);
        tsFileManager.addAll(this.unseqResources, false);
        MeasurementPath path = SchemaTestUtils.getMeasurementPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        SeriesDataBlockReader tsFilesReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), tsFileManager.getTsFileList(true), new ArrayList(), true);
        int count = 0;
        while (tsFilesReader.hasNextBatch()) {
            TsBlock batchData = tsFilesReader.nextBatch();
            int size = batchData.getPositionCount();
            for (int i = 0; i < size; ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getColumn(0).getDouble(i), (double)0.001);
                ++count;
            }
        }
        tsFilesReader.close();
        this.closeTsFileSequenceReader();
        Assert.assertEquals((long)500L, (long)count);
        ArrayList<TsFileResource> tmpSeqResources = new ArrayList<TsFileResource>();
        tmpSeqResources.add((TsFileResource)this.seqResources.get(0));
        tmpSeqResources.add((TsFileResource)this.seqResources.get(1));
        tmpSeqResources.add((TsFileResource)this.seqResources.get(2));
        TsFileResource targetTsFileResource = TsFileNameGenerator.getInnerCompactionTargetFileResource(tmpSeqResources, (boolean)true);
        File compactionLogFile = new File(((TsFileResource)this.seqResources.get(0)).getTsFile().getParent() + File.separator + targetTsFileResource.getTsFile().getName() + ".inner-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(compactionLogFile);
        compactionLogger.logFiles(tmpSeqResources, "source");
        compactionLogger.logFiles(Collections.singletonList(targetTsFileResource), "target");
        this.deleteFileIfExists(targetTsFileResource.getTsFile());
        this.performer.setSourceFiles(new ArrayList(this.seqResources.subList(0, 3)));
        this.performer.setTargetFiles(Collections.singletonList(targetTsFileResource));
        this.performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        this.performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetTsFileResource), (boolean)true, (String)"root.compactionTest");
        ((TsFileResource)this.seqResources.get(0)).remove();
        compactionLogger.close();
        new CompactionRecoverTask("root.compactionTest", "0", tsFileManager, compactionLogFile, true).doCompaction();
        Assert.assertFalse((boolean)((TsFileResource)this.seqResources.get(0)).getTsFile().exists());
        Assert.assertFalse((boolean)((TsFileResource)this.seqResources.get(1)).getTsFile().exists());
        Assert.assertFalse((boolean)((TsFileResource)this.seqResources.get(2)).getTsFile().exists());
        Assert.assertTrue((boolean)targetTsFileResource.getTsFile().exists());
        Assert.assertTrue((boolean)new File(targetTsFileResource.getTsFilePath() + ".resource").exists());
        Assert.assertFalse((boolean)new File(targetTsFileResource.getTsFilePath().replace(".tsfile", ".inner")).exists());
        tsFileManager.add(targetTsFileResource, true);
        path = SchemaTestUtils.getMeasurementPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        tsFilesReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), tsFileManager.getTsFileList(true).subList(3, 6), new ArrayList(), true);
        count = 0;
        while (tsFilesReader.hasNextBatch()) {
            TsBlock batchData = tsFilesReader.nextBatch();
            int size = batchData.getPositionCount();
            for (int i = 0; i < size; ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getColumn(0).getDouble(i), (double)0.001);
                ++count;
            }
        }
        tsFilesReader.close();
        this.closeTsFileSequenceReader();
        Assert.assertEquals((long)500L, (long)count);
    }

    @Test
    public void testRecoverWithAllSourcesFileAndCompactonModFileExist() throws Exception {
        int i;
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource((List)this.seqResources, (boolean)true);
        File logFile = new File(targetResource.getTsFile().getPath() + ".inner-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(logFile);
        compactionLogger.logFiles(this.seqResources, "source");
        compactionLogger.logFiles(Collections.singletonList(targetResource), "target");
        this.performer.setSourceFiles(this.seqResources);
        this.performer.setTargetFiles(Collections.singletonList(targetResource));
        this.performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        this.performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)"root.compactionTest");
        for (i = 0; i < this.seqResources.size(); ++i) {
            HashMap<String, Pair<Long, Long>> deleteMap = new HashMap<String, Pair<Long, Long>>();
            deleteMap.put(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId(), new Pair((Object)((long)i * this.ptNum), (Object)((long)i * this.ptNum + 10L)));
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.seqResources.get(i), true);
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.seqResources.get(i), false);
        }
        CompactionUtils.combineModsInInnerCompaction((Collection)this.seqResources, (TsFileResource)targetResource);
        compactionLogger.close();
        new CompactionRecoverTask("root.compactionTest", "0", this.tsFileManager, logFile, true).doCompaction();
        for (i = 0; i < this.seqResources.size(); ++i) {
            Assert.assertTrue((boolean)((TsFileResource)this.seqResources.get(i)).getTsFile().exists());
            Assert.assertTrue((boolean)((TsFileResource)this.seqResources.get(i)).resourceFileExists());
        }
        Assert.assertFalse((boolean)targetResource.getTsFile().exists());
        Assert.assertFalse((boolean)new File(targetResource.getTsFilePath().replace(".inner", ".tsfile")).exists());
        Assert.assertFalse((boolean)new File(targetResource.getTsFilePath() + ".resource").exists());
        for (i = 0; i < this.seqResources.size(); ++i) {
            Assert.assertFalse((boolean)((TsFileResource)this.seqResources.get(i)).getCompactionModFile().exists());
        }
        for (i = 0; i < this.seqResources.size(); ++i) {
            ((TsFileResource)this.seqResources.get(i)).resetModFile();
            Assert.assertTrue((boolean)((TsFileResource)this.seqResources.get(i)).getModFile().exists());
            Assert.assertEquals((long)1L, (long)((TsFileResource)this.seqResources.get(i)).getModFile().getModifications().size());
        }
        Assert.assertFalse((boolean)targetResource.getModFile().exists());
        Assert.assertFalse((boolean)logFile.exists());
        Assert.assertTrue((boolean)this.tsFileManager.isAllowCompaction());
    }

    @Test
    public void testRecoverWithAllSourcesFileAndCompactonModFileExistAndTargetFileNotExist() throws Exception {
        int i;
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource((List)this.seqResources, (boolean)true);
        File logFile = new File(targetResource.getTsFile().getPath() + ".inner-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(logFile);
        compactionLogger.logFiles(this.seqResources, "source");
        compactionLogger.logFiles(Collections.singletonList(targetResource), "target");
        this.performer.setSourceFiles(this.seqResources);
        this.performer.setTargetFiles(Collections.singletonList(targetResource));
        this.performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        this.performer.perform();
        targetResource.remove();
        for (i = 0; i < this.seqResources.size(); ++i) {
            HashMap<String, Pair<Long, Long>> deleteMap = new HashMap<String, Pair<Long, Long>>();
            deleteMap.put(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId(), new Pair((Object)((long)i * this.ptNum), (Object)((long)i * this.ptNum + 10L)));
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.seqResources.get(i), true);
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.seqResources.get(i), false);
        }
        compactionLogger.close();
        new CompactionRecoverTask("root.compactionTest", "0", this.tsFileManager, logFile, true).doCompaction();
        for (i = 0; i < this.seqResources.size(); ++i) {
            Assert.assertTrue((boolean)((TsFileResource)this.seqResources.get(i)).getTsFile().exists());
            Assert.assertTrue((boolean)((TsFileResource)this.seqResources.get(i)).resourceFileExists());
        }
        Assert.assertFalse((boolean)targetResource.getTsFile().exists());
        Assert.assertFalse((boolean)new File(targetResource.getTsFilePath().replace(".inner", ".tsfile")).exists());
        Assert.assertFalse((boolean)new File(targetResource.getTsFilePath() + ".resource").exists());
        for (i = 0; i < this.seqResources.size(); ++i) {
            Assert.assertFalse((boolean)((TsFileResource)this.seqResources.get(i)).getCompactionModFile().exists());
        }
        for (i = 0; i < this.seqResources.size(); ++i) {
            ((TsFileResource)this.seqResources.get(i)).resetModFile();
            Assert.assertTrue((boolean)((TsFileResource)this.seqResources.get(i)).getModFile().exists());
            Assert.assertEquals((long)1L, (long)((TsFileResource)this.seqResources.get(i)).getModFile().getModifications().size());
        }
        Assert.assertFalse((boolean)targetResource.getModFile().exists());
        Assert.assertFalse((boolean)logFile.exists());
        Assert.assertTrue((boolean)this.tsFileManager.isAllowCompaction());
    }

    @Test
    public void testRecoverWithoutAllSourceFilesExistAndModFiles() throws Exception {
        int i;
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource((List)this.seqResources, (boolean)true);
        File logFile = new File(targetResource.getTsFile().getPath() + ".inner-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(logFile);
        compactionLogger.logFiles(this.seqResources, "source");
        compactionLogger.logFiles(Collections.singletonList(targetResource), "target");
        this.performer.setSourceFiles(this.seqResources);
        this.performer.setTargetFiles(Collections.singletonList(targetResource));
        this.performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        this.performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)"root.compactionTest");
        for (i = 0; i < this.seqResources.size(); ++i) {
            HashMap<String, Pair<Long, Long>> deleteMap = new HashMap<String, Pair<Long, Long>>();
            deleteMap.put(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId(), new Pair((Object)((long)i * this.ptNum), (Object)((long)i * this.ptNum + 10L)));
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.seqResources.get(i), true);
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.seqResources.get(i), false);
        }
        CompactionUtils.combineModsInInnerCompaction((Collection)this.seqResources, (TsFileResource)targetResource);
        ((TsFileResource)this.seqResources.get(0)).remove();
        compactionLogger.close();
        new CompactionRecoverTask("root.compactionTest", "0", this.tsFileManager, logFile, true).doCompaction();
        for (i = 0; i < this.seqResources.size(); ++i) {
            Assert.assertFalse((boolean)((TsFileResource)this.seqResources.get(i)).getTsFile().exists());
            Assert.assertFalse((boolean)((TsFileResource)this.seqResources.get(i)).resourceFileExists());
        }
        Assert.assertTrue((boolean)targetResource.getTsFile().exists());
        Assert.assertTrue((boolean)targetResource.resourceFileExists());
        Assert.assertFalse((boolean)new File(targetResource.getTsFilePath().replace(".tsfile", ".inner")).exists());
        for (i = 0; i < this.seqResources.size(); ++i) {
            Assert.assertFalse((boolean)((TsFileResource)this.seqResources.get(i)).getCompactionModFile().exists());
            Assert.assertFalse((boolean)((TsFileResource)this.seqResources.get(i)).getModFile().exists());
        }
        Assert.assertTrue((boolean)targetResource.getModFile().exists());
        Assert.assertFalse((boolean)logFile.exists());
        Assert.assertTrue((boolean)this.tsFileManager.isAllowCompaction());
    }

    @Test
    public void testRecoverCompleteTargetFileAndCompactionLog() throws Exception {
        TsFileManager tsFileManager = new TsFileManager("root.compactionTest", "0", this.tempSGDir.getAbsolutePath());
        tsFileManager.addAll(this.seqResources, true);
        tsFileManager.addAll(this.unseqResources, false);
        MeasurementPath path = SchemaTestUtils.getMeasurementPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        SeriesDataBlockReader tsFilesReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), tsFileManager.getTsFileList(true), new ArrayList(), true);
        int count = 0;
        while (tsFilesReader.hasNextBatch()) {
            TsBlock batchData = tsFilesReader.nextBatch();
            int size = batchData.getPositionCount();
            for (int i = 0; i < size; ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getColumn(0).getDouble(i), (double)0.001);
                ++count;
            }
        }
        tsFilesReader.close();
        this.closeTsFileSequenceReader();
        Assert.assertEquals((long)500L, (long)count);
        TsFileResource targetTsFileResource = new TsFileResource(new File(SEQ_DIRS + File.separator.concat("0-0-1-0.inner")));
        File compactionLogFile = new File(((TsFileResource)this.seqResources.get(0)).getTsFile().getParent() + File.separator + targetTsFileResource.getTsFile().getName() + ".inner-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(compactionLogFile);
        ArrayList<TsFileResource> tmpSeqResources = new ArrayList<TsFileResource>();
        tmpSeqResources.add((TsFileResource)this.seqResources.get(0));
        tmpSeqResources.add((TsFileResource)this.seqResources.get(1));
        tmpSeqResources.add((TsFileResource)this.seqResources.get(2));
        compactionLogger.logFiles(tmpSeqResources, "source");
        compactionLogger.logFiles(Collections.singletonList(targetTsFileResource), "target");
        this.deleteFileIfExists(targetTsFileResource.getTsFile());
        this.performer.setSourceFiles(new ArrayList(this.seqResources.subList(0, 3)));
        this.performer.setTargetFiles(Collections.singletonList(targetTsFileResource));
        this.performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        this.performer.perform();
        compactionLogger.close();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetTsFileResource), (boolean)true, (String)"root.compactionTest");
        tsFileManager.add(targetTsFileResource, true);
        new CompactionRecoverTask("root.compactionTest", "0", tsFileManager, compactionLogFile, true).doCompaction();
        path = SchemaTestUtils.getMeasurementPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        TimeSeriesMetadataCache.getInstance().clear();
        ChunkCache.getInstance().clear();
        tsFilesReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), tsFileManager.getTsFileList(true).subList(0, 5), new ArrayList(), true);
        count = 0;
        while (tsFilesReader.hasNextBatch()) {
            TsBlock batchData = tsFilesReader.nextBatch();
            int size = batchData.getPositionCount();
            for (int i = 0; i < size; ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getColumn(0).getDouble(i), (double)0.001);
                ++count;
            }
        }
        tsFilesReader.close();
        this.closeTsFileSequenceReader();
        Assert.assertEquals((long)500L, (long)count);
    }

    @Test
    public void testCompactionRecoverWithCompletedTargetFileAndLog() throws Exception {
        TsFileManager tsFileManager = new TsFileManager("root.compactionTest", "0", this.tempSGDir.getAbsolutePath());
        tsFileManager.addAll(this.seqResources, true);
        tsFileManager.addAll(this.unseqResources, false);
        MeasurementPath path = SchemaTestUtils.getMeasurementPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        SeriesDataBlockReader tsFilesReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), tsFileManager.getTsFileList(true), new ArrayList(), true);
        int count = 0;
        while (tsFilesReader.hasNextBatch()) {
            TsBlock batchData = tsFilesReader.nextBatch();
            int size = batchData.getPositionCount();
            for (int i = 0; i < size; ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getColumn(0).getDouble(i), (double)0.001);
                ++count;
            }
        }
        tsFilesReader.close();
        this.closeTsFileSequenceReader();
        Assert.assertEquals((long)500L, (long)count);
        ArrayList<TsFileResource> tmpSeqResources = new ArrayList<TsFileResource>();
        tmpSeqResources.add((TsFileResource)this.seqResources.get(0));
        tmpSeqResources.add((TsFileResource)this.seqResources.get(1));
        tmpSeqResources.add((TsFileResource)this.seqResources.get(2));
        TsFileResource targetTsFileResource = TsFileNameGenerator.getInnerCompactionTargetFileResource(tmpSeqResources, (boolean)true);
        File compactionLogFile = new File(((TsFileResource)this.seqResources.get(0)).getTsFile().getParent() + File.separator + targetTsFileResource.getTsFile().getName() + ".inner-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(compactionLogFile);
        compactionLogger.logFiles(tmpSeqResources, "source");
        compactionLogger.logFiles(Collections.singletonList(targetTsFileResource), "target");
        this.deleteFileIfExists(targetTsFileResource.getTsFile());
        this.performer.setSourceFiles(new ArrayList(this.seqResources.subList(0, 3)));
        this.performer.setTargetFiles(Collections.singletonList(targetTsFileResource));
        this.performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        this.performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetTsFileResource), (boolean)true, (String)"root.compactionTest");
        compactionLogger.close();
        for (TsFileResource resource : new ArrayList(this.seqResources.subList(0, 3))) {
            this.deleteFileIfExists(resource.getTsFile());
            tsFileManager.remove(resource, true);
        }
        tsFileManager.add(targetTsFileResource, true);
        new CompactionRecoverTask("root.compactionTest", "0", tsFileManager, compactionLogFile, true).doCompaction();
        path = SchemaTestUtils.getMeasurementPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        tsFilesReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), tsFileManager.getTsFileList(true), new ArrayList(), true);
        count = 0;
        while (tsFilesReader.hasNextBatch()) {
            TsBlock batchData = tsFilesReader.nextBatch();
            int size = batchData.getPositionCount();
            for (int i = 0; i < size; ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getColumn(0).getDouble(i), (double)0.001);
                ++count;
            }
        }
        tsFilesReader.close();
        this.closeTsFileSequenceReader();
        Assert.assertEquals((long)500L, (long)count);
    }

    @Test
    public void testCompactionRecoverWithCompletedTargetFile() throws Exception {
        TsFileManager tsFileManager = new TsFileManager("root.compactionTest", "0", this.tempSGDir.getAbsolutePath());
        tsFileManager.addAll(this.seqResources, true);
        tsFileManager.addAll(this.unseqResources, false);
        MeasurementPath path = SchemaTestUtils.getMeasurementPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        SeriesDataBlockReader tsFilesReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), tsFileManager.getTsFileList(true), new ArrayList(), true);
        int count = 0;
        while (tsFilesReader.hasNextBatch()) {
            TsBlock batchData = tsFilesReader.nextBatch();
            int size = batchData.getPositionCount();
            for (int i = 0; i < size; ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getColumn(0).getDouble(i), (double)0.001);
                ++count;
            }
        }
        tsFilesReader.close();
        this.closeTsFileSequenceReader();
        Assert.assertEquals((long)500L, (long)count);
        ArrayList<TsFileResource> tmpSeqResources = new ArrayList<TsFileResource>();
        tmpSeqResources.add((TsFileResource)this.seqResources.get(0));
        tmpSeqResources.add((TsFileResource)this.seqResources.get(1));
        tmpSeqResources.add((TsFileResource)this.seqResources.get(2));
        TsFileResource targetTsFileResource = TsFileNameGenerator.getInnerCompactionTargetFileResource(tmpSeqResources, (boolean)true);
        File compactionLogFile = new File(((TsFileResource)this.seqResources.get(0)).getTsFile().getParent() + File.separator + targetTsFileResource.getTsFile().getName() + ".inner-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(compactionLogFile);
        compactionLogger.logFiles(tmpSeqResources, "source");
        compactionLogger.logFiles(Collections.singletonList(targetTsFileResource), "target");
        this.deleteFileIfExists(targetTsFileResource.getTsFile());
        this.performer.setSourceFiles(new ArrayList(this.seqResources.subList(0, 3)));
        this.performer.setTargetFiles(Collections.singletonList(targetTsFileResource));
        this.performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        this.performer.perform();
        compactionLogger.close();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetTsFileResource), (boolean)true, (String)"root.compactionTest");
        this.deleteFileIfExists(compactionLogFile);
        for (TsFileResource resource : new ArrayList(this.seqResources.subList(0, 3))) {
            tsFileManager.remove(resource, true);
            this.deleteFileIfExists(resource.getTsFile());
        }
        tsFileManager.add(targetTsFileResource, true);
        new CompactionRecoverTask("root.compactionTest", "0", tsFileManager, compactionLogFile, true).doCompaction();
        path = SchemaTestUtils.getMeasurementPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        logger.warn("TsFiles in list is {}", (Object)tsFileManager.getTsFileList(true));
        tsFilesReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), tsFileManager.getTsFileList(true), new ArrayList(), true);
        count = 0;
        while (tsFilesReader.hasNextBatch()) {
            TsBlock batchData = tsFilesReader.nextBatch();
            int size = batchData.getPositionCount();
            for (int i = 0; i < size; ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getColumn(0).getDouble(i), (double)0.001);
                ++count;
            }
        }
        tsFilesReader.close();
        this.closeTsFileSequenceReader();
        Assert.assertEquals((long)500L, (long)count);
    }

    @Test
    public void testCompactionMergeRecoverMergeStartSourceLog() throws IOException, MetadataException {
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CompactionLogger sizeTieredCompactionLogger = new CompactionLogger(new File(this.tempSGDir.getPath(), "root.compactionTestroot.compactionTest.inner-compaction.log"));
        ArrayList<TsFileResource> tmpSeqResources = new ArrayList<TsFileResource>();
        tmpSeqResources.add((TsFileResource)this.seqResources.get(0));
        tmpSeqResources.add((TsFileResource)this.seqResources.get(1));
        tmpSeqResources.add((TsFileResource)this.seqResources.get(2));
        sizeTieredCompactionLogger.logFiles(tmpSeqResources, "source");
        sizeTieredCompactionLogger.close();
        MeasurementPath path = SchemaTestUtils.getMeasurementPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        SeriesDataBlockReader tsFilesReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.tsFileManager.getTsFileList(true), new ArrayList(), true);
        int count = 0;
        while (tsFilesReader.hasNextBatch()) {
            TsBlock batchData = tsFilesReader.nextBatch();
            int size = batchData.getPositionCount();
            for (int i = 0; i < size; ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getColumn(0).getDouble(i), (double)0.001);
                ++count;
            }
        }
        tsFilesReader.close();
        this.closeTsFileSequenceReader();
        Assert.assertEquals((long)500L, (long)count);
    }

    @Test
    public void testCompactionMergeRecoverMergeStartSequenceLog() throws IOException, MetadataException {
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CompactionLogger sizeTieredCompactionLogger = new CompactionLogger(new File(this.tempSGDir.getPath(), "root.compactionTest.inner-compaction.log"));
        ArrayList<TsFileResource> tmpSeqResources = new ArrayList<TsFileResource>();
        tmpSeqResources.add((TsFileResource)this.seqResources.get(0));
        tmpSeqResources.add((TsFileResource)this.seqResources.get(1));
        tmpSeqResources.add((TsFileResource)this.seqResources.get(2));
        sizeTieredCompactionLogger.logFiles(tmpSeqResources, "source");
        sizeTieredCompactionLogger.close();
        MeasurementPath path = SchemaTestUtils.getMeasurementPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        SeriesDataBlockReader tsFilesReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.tsFileManager.getTsFileList(true), new ArrayList(), true);
        int count = 0;
        while (tsFilesReader.hasNextBatch()) {
            TsBlock batchData = tsFilesReader.nextBatch();
            int size = batchData.getPositionCount();
            for (int i = 0; i < size; ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getColumn(0).getDouble(i), (double)0.001);
                ++count;
            }
        }
        tsFilesReader.close();
        this.closeTsFileSequenceReader();
        Assert.assertEquals((long)500L, (long)count);
    }

    @Test
    public void testCompactionMergeRecoverMergeStart() throws IOException, MetadataException {
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CompactionLogger sizeTieredCompactionLogger = new CompactionLogger(new File(this.tempSGDir.getPath(), "root.compactionTest.inner-compaction.log"));
        ArrayList<TsFileResource> tmpSeqResources = new ArrayList<TsFileResource>();
        tmpSeqResources.add((TsFileResource)this.seqResources.get(0));
        tmpSeqResources.add((TsFileResource)this.seqResources.get(1));
        tmpSeqResources.add((TsFileResource)this.seqResources.get(2));
        sizeTieredCompactionLogger.logFiles(tmpSeqResources, "source");
        TsFileResource targetTsFileResource = new TsFileResource(new File(SEQ_DIRS + File.separator.concat("0-0-1-0.inner")));
        sizeTieredCompactionLogger.logFiles(Collections.singletonList(targetTsFileResource), "target");
        sizeTieredCompactionLogger.close();
        MeasurementPath path = SchemaTestUtils.getMeasurementPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        SeriesDataBlockReader tsFilesReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.tsFileManager.getTsFileList(true), new ArrayList(), true);
        int count = 0;
        while (tsFilesReader.hasNextBatch()) {
            TsBlock batchData = tsFilesReader.nextBatch();
            int size = batchData.getPositionCount();
            for (int i = 0; i < size; ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getColumn(0).getDouble(i), (double)0.001);
                ++count;
            }
        }
        Assert.assertEquals((long)500L, (long)count);
    }

    public void deleteFileIfExists(File file) {
        long waitingTime = 0L;
        while (file.exists()) {
            file.delete();
            System.gc();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if ((waitingTime += 100L) <= 20000L) continue;
            System.out.println("fail to delete " + file);
            break;
        }
    }

    @Test
    public void testWhenTargetFileShouldBeDeletedAfterCompactionAndSomeSourceFilesLost() throws Exception {
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        for (int device = 0; device < this.deviceNum; ++device) {
            for (int measurement = 0; measurement < this.measurementNum; ++measurement) {
                HashMap<String, Pair> deleteMap = new HashMap<String, Pair>();
                deleteMap.put("root.compactionTest.device" + device + "." + "sensor" + measurement, new Pair((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE));
                this.seqResources.forEach(x -> {
                    try {
                        CompactionFileGeneratorUtils.generateMods(deleteMap, x, false);
                    }
                    catch (IOException | IllegalPathException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getInnerCompactionTargetTsFileResources(this.seqResources, true);
        File compactionLogFile = new File(SEQ_DIRS, targetResources.get(0).getTsFile().getName() + ".cross-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(compactionLogFile);
        compactionLogger.logFiles(targetResources, "target");
        compactionLogger.logFiles(this.seqResources, "source");
        FastCompactionPerformer performer = new FastCompactionPerformer(this.seqResources, Collections.emptyList(), targetResources);
        performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        performer.perform();
        CompactionUtils.moveTargetFile(targetResources, (boolean)true, (String)"root.compactionTest");
        CompactionUtils.combineModsInInnerCompaction((Collection)this.seqResources, (TsFileResource)targetResources.get(0));
        compactionLogger.logFile(targetResources.get(0), "empty");
        compactionLogger.close();
        ((TsFileResource)this.seqResources.get(0)).remove();
        new CompactionRecoverTask("root.compactionTest", "0", this.tsFileManager, compactionLogFile, true).doCompaction();
        Assert.assertTrue((boolean)this.tsFileManager.isAllowCompaction());
        for (TsFileResource resource : this.seqResources) {
            Assert.assertFalse((boolean)resource.getTsFile().exists());
            Assert.assertFalse((boolean)new File(resource.getTsFilePath() + ".resource").exists());
            Assert.assertFalse((boolean)resource.getModFile().exists());
            Assert.assertFalse((boolean)resource.getCompactionModFile().exists());
        }
        Assert.assertFalse((boolean)targetResources.get(0).getTsFile().exists());
        Assert.assertFalse((boolean)targetResources.get(0).resourceFileExists());
    }

    @Test
    public void testWhenTargetFileIsDeletedAfterCompactionAndSomeSourceFilesLost() throws Exception {
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        for (int device = 0; device < this.deviceNum; ++device) {
            for (int measurement = 0; measurement < this.measurementNum; ++measurement) {
                HashMap<String, Pair> deleteMap = new HashMap<String, Pair>();
                deleteMap.put("root.compactionTest.device" + device + "." + "sensor" + measurement, new Pair((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE));
                this.seqResources.forEach(x -> {
                    try {
                        CompactionFileGeneratorUtils.generateMods(deleteMap, x, false);
                    }
                    catch (IOException | IllegalPathException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getInnerCompactionTargetTsFileResources(this.seqResources, true);
        File compactionLogFile = new File(SEQ_DIRS, targetResources.get(0).getTsFile().getName() + ".cross-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(compactionLogFile);
        compactionLogger.logFiles(targetResources, "target");
        compactionLogger.logFiles(this.seqResources, "source");
        FastCompactionPerformer performer = new FastCompactionPerformer(this.seqResources, Collections.emptyList(), targetResources);
        performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        performer.perform();
        CompactionUtils.moveTargetFile(targetResources, (boolean)true, (String)"root.compactionTest");
        CompactionUtils.combineModsInInnerCompaction((Collection)this.seqResources, (TsFileResource)targetResources.get(0));
        compactionLogger.logFile(targetResources.get(0), "empty");
        compactionLogger.close();
        CompactionUtils.deleteTsFilesInDisk((Collection)this.seqResources, (String)"root.compactionTest");
        CompactionUtils.deleteModificationForSourceFile((Collection)this.seqResources, (String)"root.compactionTest");
        if (targetResources.get(0).isDeleted()) {
            targetResources.get(0).remove();
        }
        new CompactionRecoverTask("root.compactionTest", "0", this.tsFileManager, compactionLogFile, true).doCompaction();
        Assert.assertTrue((boolean)this.tsFileManager.isAllowCompaction());
        for (TsFileResource resource : this.seqResources) {
            Assert.assertFalse((boolean)resource.getTsFile().exists());
            Assert.assertFalse((boolean)new File(resource.getTsFilePath() + ".resource").exists());
            Assert.assertFalse((boolean)resource.getModFile().exists());
            Assert.assertFalse((boolean)resource.getCompactionModFile().exists());
        }
        Assert.assertFalse((boolean)targetResources.get(0).getTsFile().exists());
        Assert.assertFalse((boolean)targetResources.get(0).resourceFileExists());
    }

    @Test
    public void testWhenTargetFileIsDeletedAfterCompactionAndAllSourceFilesExisted() throws Exception {
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        for (int device = 0; device < this.deviceNum; ++device) {
            for (int measurement = 0; measurement < this.measurementNum; ++measurement) {
                HashMap<String, Pair> deleteMap = new HashMap<String, Pair>();
                deleteMap.put("root.compactionTest.device" + device + "." + "sensor" + measurement, new Pair((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE));
                this.seqResources.forEach(x -> {
                    try {
                        CompactionFileGeneratorUtils.generateMods(deleteMap, x, false);
                    }
                    catch (IOException | IllegalPathException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getInnerCompactionTargetTsFileResources(this.seqResources, true);
        File compactionLogFile = new File(SEQ_DIRS, targetResources.get(0).getTsFile().getName() + ".cross-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(compactionLogFile);
        compactionLogger.logFiles(targetResources, "target");
        compactionLogger.logFiles(this.seqResources, "source");
        compactionLogger.close();
        FastCompactionPerformer performer = new FastCompactionPerformer(this.seqResources, Collections.emptyList(), targetResources);
        performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        performer.perform();
        CompactionUtils.moveTargetFile(targetResources, (boolean)true, (String)"root.compactionTest");
        CompactionUtils.combineModsInInnerCompaction((Collection)this.seqResources, (TsFileResource)targetResources.get(0));
        new CompactionRecoverTask("root.compactionTest", "0", this.tsFileManager, compactionLogFile, true).doCompaction();
        Assert.assertTrue((boolean)this.tsFileManager.isAllowCompaction());
        for (TsFileResource resource : this.seqResources) {
            Assert.assertTrue((boolean)resource.getTsFile().exists());
            Assert.assertTrue((boolean)new File(resource.getTsFilePath() + ".resource").exists());
            Assert.assertTrue((boolean)resource.getModFile().exists());
            Assert.assertFalse((boolean)resource.getCompactionModFile().exists());
        }
        for (TsFileResource resource : targetResources) {
            if (resource == null) continue;
            Assert.assertFalse((boolean)resource.getTsFile().exists());
            Assert.assertFalse((boolean)new File(resource.getTsFilePath().replace(".inner", ".tsfile")).exists());
            Assert.assertFalse((boolean)new File(resource.getTsFilePath().replace(".inner", ".tsfile") + ".resource").exists());
        }
    }

    private void closeTsFileSequenceReader() throws IOException {
        for (TsFileResource tsFileResource : this.seqResources) {
            FileReaderManager.getInstance().closeFileAndRemoveReader(tsFileResource.getTsFilePath());
        }
    }
}

