/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.inner;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.ReadChunkCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.log.CompactionLogger;
import org.apache.iotdb.db.storageengine.dataregion.compaction.inner.InnerCompactionTest;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.apache.iotdb.tsfile.read.TsFileReader;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.expression.QueryExpression;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ReadChunkCompactionPerformerOldTest
extends InnerCompactionTest {
    File tempSGDir;

    @Override
    @Before
    public void setUp() throws Exception {
        this.tempSGDir = new File(TestConstant.getTestTsFileDir((String)"root.compactionTest", (long)0L, (long)0L));
        if (!this.tempSGDir.exists()) {
            Assert.assertTrue((boolean)this.tempSGDir.mkdirs());
        }
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        super.tearDown();
        FileUtils.deleteDirectory((File)new File("target/testTsFile"));
    }

    @Test
    public void testCompact() throws Exception {
        TsFileResource targetTsFileResource = new TsFileResource(new File(TestConstant.getTestTsFileDir((String)"root.compactionTest", (long)0L, (long)0L).concat("0-0-1-0.inner")));
        File targetFile = new File(TestConstant.getTestTsFileDir((String)"root.compactionTest", (long)0L, (long)0L).concat("0-0-1-0.tsfile"));
        if (targetFile.exists()) {
            Assert.assertTrue((boolean)targetFile.delete());
        }
        CompactionLogger sizeTieredCompactionLogger = new CompactionLogger(new File(targetTsFileResource.getTsFilePath().concat(".compaction.log")));
        sizeTieredCompactionLogger.logFiles(this.seqResources, "source");
        ReadChunkCompactionPerformer performer = new ReadChunkCompactionPerformer(this.seqResources, targetTsFileResource);
        performer.setSummary(new CompactionTaskSummary());
        performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetTsFileResource), (boolean)true, (String)"root.compactionTest");
        sizeTieredCompactionLogger.close();
        Path path = new Path(this.deviceIds[0], this.measurementSchemas[0].getMeasurementId(), true);
        try (TsFileSequenceReader reader = new TsFileSequenceReader(targetTsFileResource.getTsFilePath());
             TsFileReader readTsFile = new TsFileReader(reader);){
            QueryExpression queryExpression = QueryExpression.create(Collections.singletonList(path), null);
            QueryDataSet queryDataSet = readTsFile.query(queryExpression);
            int cut = 0;
            while (queryDataSet.hasNext()) {
                RowRecord record = queryDataSet.next();
                Assert.assertEquals((double)record.getTimestamp(), (double)((Field)record.getFields().get(0)).getDoubleV(), (double)0.001);
                ++cut;
            }
            Assert.assertEquals((long)600L, (long)cut);
        }
    }
}

