/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.inner;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.buffer.BloomFilterCache;
import org.apache.iotdb.db.storageengine.buffer.ChunkCache;
import org.apache.iotdb.db.storageengine.buffer.TimeSeriesMetadataCache;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.ICompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.ReadChunkCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.CompactionCheckerUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.CompactionConfigRestorer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.CompactionFileGeneratorUtils;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.generator.TsFileNameGenerator;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ReadChunkCompactionPerformerNoAlignedTest {
    private final String storageGroup = "root.compactionTest";
    private final String[] devices = new String[]{"device0", "device1", "device2", "device3"};
    private PartialPath[] devicePath = new PartialPath[this.devices.length];
    private final String[] measurements = new String[]{"s0", "s1", "s2", "s3", "s4"};
    private Set<String> fullPathSet = new HashSet<String>();
    private MeasurementSchema[] schemas = new MeasurementSchema[this.measurements.length];
    private List<PartialPath> paths = new ArrayList<PartialPath>();
    private List<IMeasurementSchema> schemaList = new ArrayList<IMeasurementSchema>();
    private static File tempSGDir;
    private static String SEQ_DIRS;
    private static String UNSEQ_DIRS;
    private final ICompactionPerformer performer = new ReadChunkCompactionPerformer();

    @Before
    public void setUp() throws Exception {
        tempSGDir = new File(TestConstant.BASE_OUTPUT_PATH + "data" + File.separator + "sequence" + File.separator + "root.compactionTest");
        if (!tempSGDir.exists()) {
            Assert.assertTrue((boolean)tempSGDir.mkdirs());
        }
        if (!new File(SEQ_DIRS).exists()) {
            Assert.assertTrue((boolean)new File(SEQ_DIRS).mkdirs());
        }
        if (!new File(UNSEQ_DIRS).exists()) {
            Assert.assertTrue((boolean)new File(UNSEQ_DIRS).mkdirs());
        }
        this.createTimeseries();
        ChunkCache.getInstance().clear();
        TimeSeriesMetadataCache.getInstance().clear();
        BloomFilterCache.getInstance().clear();
    }

    @After
    public void tearDown() throws Exception {
        new CompactionConfigRestorer().restoreCompactionConfig();
        if (new File(SEQ_DIRS).exists()) {
            FileUtils.forceDelete((File)new File(SEQ_DIRS));
        }
        if (new File(UNSEQ_DIRS).exists()) {
            FileUtils.forceDelete((File)new File(UNSEQ_DIRS));
        }
        ChunkCache.getInstance().clear();
        TimeSeriesMetadataCache.getInstance().clear();
        BloomFilterCache.getInstance().clear();
        EnvironmentUtils.cleanAllDir();
    }

    private void createTimeseries() throws MetadataException {
        int i;
        for (i = 0; i < this.measurements.length; ++i) {
            this.schemas[i] = new MeasurementSchema(this.measurements[i], TSDataType.INT64, TSEncoding.PLAIN, CompressionType.SNAPPY);
        }
        for (i = 0; i < this.devices.length; ++i) {
            this.devicePath[i] = new PartialPath("root.compactionTest." + this.devices[i]);
        }
        for (PartialPath device : this.devicePath) {
            for (MeasurementSchema schema : this.schemas) {
                this.fullPathSet.add(device.getFullPath() + "." + schema.getMeasurementId());
                this.paths.add((PartialPath)new MeasurementPath(new PartialPath(device.getFullPath() + "." + schema.getMeasurementId()), (IMeasurementSchema)schema));
                this.schemaList.add((IMeasurementSchema)schema);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDirectlyFlushChunk() throws Exception {
        long originTargetChunkSize = IoTDBDescriptor.getInstance().getConfig().getTargetChunkSize();
        long originTargetChunkPointNum = IoTDBDescriptor.getInstance().getConfig().getTargetChunkPointNum();
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkSize(100L);
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkPointNum(100L);
        try {
            ArrayList<TsFileResource> sourceFiles = new ArrayList<TsFileResource>();
            int fileNum = 6;
            long pointStep = 200L;
            for (int i = 0; i < fileNum; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(((long)i + 1L) * pointStep);
                chunkPagePointsNum.add(pagePointsNum);
                TsFileResource resource = new TsFileResource(new File(SEQ_DIRS, String.format("%d-%d-0-0.tsfile", i + 1, i + 1)));
                sourceFiles.add(resource);
                CompactionFileGeneratorUtils.writeTsFile(this.fullPathSet, chunkPagePointsNum, (long)i * 1500L, resource);
            }
            Map<PartialPath, List<TimeValuePair>> originData = CompactionCheckerUtils.getDataByQuery(this.paths, this.schemaList, sourceFiles, new ArrayList<TsFileResource>());
            TsFileNameGenerator.TsFileName tsFileName = TsFileNameGenerator.getTsFileName((String)((TsFileResource)sourceFiles.get(0)).getTsFile().getName());
            TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource(sourceFiles, (boolean)true);
            this.performer.setSourceFiles(sourceFiles);
            this.performer.setTargetFiles(Collections.singletonList(targetResource));
            this.performer.setSummary(new CompactionTaskSummary());
            this.performer.perform();
            CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)"root.compactionTest");
            HashMap<String, List<List<Long>>> chunkPagePointsNumMerged = new HashMap<String, List<List<Long>>>();
            long[] points = new long[fileNum];
            for (int i = 1; i <= fileNum; ++i) {
                points[i - 1] = (long)i * pointStep;
            }
            for (String path : this.fullPathSet) {
                CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, path, points);
            }
            CompactionCheckerUtils.checkChunkAndPage(chunkPagePointsNumMerged, targetResource);
            Map<PartialPath, List<TimeValuePair>> compactedData = CompactionCheckerUtils.getDataByQuery(this.paths, this.schemaList, Collections.singletonList(targetResource), new ArrayList<TsFileResource>());
            CompactionCheckerUtils.validDataByValueList(originData, compactedData);
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setTargetChunkSize(originTargetChunkSize);
            IoTDBDescriptor.getInstance().getConfig().setTargetChunkPointNum(originTargetChunkPointNum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLargeChunkMergeWithCacheChunkAndFlush() throws Exception {
        long testTargetChunkPointNum = 2000L;
        long testChunkSizeLowerBound = 1024L;
        long testChunkPointNumLowerBound = 100L;
        long originTargetChunkSize = IoTDBDescriptor.getInstance().getConfig().getTargetChunkSize();
        long originTargetChunkPointNum = IoTDBDescriptor.getInstance().getConfig().getTargetChunkPointNum();
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkSize(0x100000L);
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkPointNum(testTargetChunkPointNum);
        long originChunkSizeLowerBound = IoTDBDescriptor.getInstance().getConfig().getChunkSizeLowerBoundInCompaction();
        IoTDBDescriptor.getInstance().getConfig().setChunkSizeLowerBoundInCompaction(testChunkSizeLowerBound);
        long originChunkPointNumLowerBound = IoTDBDescriptor.getInstance().getConfig().getChunkPointNumLowerBoundInCompaction();
        IoTDBDescriptor.getInstance().getConfig().setChunkPointNumLowerBoundInCompaction(testChunkPointNumLowerBound);
        try {
            ArrayList<TsFileResource> sourceFiles = new ArrayList<TsFileResource>();
            int fileNum = 6;
            long pointStep = 100L;
            long[] points = new long[fileNum];
            for (int i = 0; i < fileNum - 1; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add((long)(i + 1) * pointStep);
                points[i] = (long)(i + 1) * pointStep;
                chunkPagePointsNum.add(pagePointsNum);
                TsFileResource resource = new TsFileResource(new File(SEQ_DIRS, String.format("%d-%d-0-0.tsfile", i + 1, i + 1)));
                sourceFiles.add(resource);
                CompactionFileGeneratorUtils.writeTsFile(this.fullPathSet, chunkPagePointsNum, (long)i * 1500L, resource);
            }
            ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
            ArrayList<Long> pagePointsNum = new ArrayList<Long>();
            pagePointsNum.add(testTargetChunkPointNum + 100L);
            points[fileNum - 1] = testTargetChunkPointNum + 100L;
            chunkPagePointsNum.add(pagePointsNum);
            TsFileResource resource = new TsFileResource(new File(SEQ_DIRS, String.format("%d-%d-0-0.tsfile", fileNum, fileNum)));
            sourceFiles.add(resource);
            CompactionFileGeneratorUtils.writeTsFile(this.fullPathSet, chunkPagePointsNum, (long)fileNum * testTargetChunkPointNum, resource);
            Map<PartialPath, List<TimeValuePair>> originData = CompactionCheckerUtils.getDataByQuery(this.paths, this.schemaList, sourceFiles, new ArrayList<TsFileResource>());
            TsFileNameGenerator.TsFileName tsFileName = TsFileNameGenerator.getTsFileName((String)((TsFileResource)sourceFiles.get(0)).getTsFile().getName());
            TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource(sourceFiles, (boolean)true);
            this.performer.setSourceFiles(sourceFiles);
            this.performer.setTargetFiles(Collections.singletonList(targetResource));
            this.performer.setSummary(new CompactionTaskSummary());
            this.performer.perform();
            CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)"root.compactionTest");
            HashMap<String, List<List<Long>>> chunkPagePointsNumMerged = new HashMap<String, List<List<Long>>>();
            for (String path : this.fullPathSet) {
                CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, path, points);
            }
            Map<PartialPath, List<TimeValuePair>> compactedData = CompactionCheckerUtils.getDataByQuery(this.paths, this.schemaList, Collections.singletonList(targetResource), new ArrayList<TsFileResource>());
            CompactionCheckerUtils.validDataByValueList(originData, compactedData);
            CompactionCheckerUtils.checkChunkAndPage(chunkPagePointsNumMerged, targetResource);
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setTargetChunkSize(originTargetChunkSize);
            IoTDBDescriptor.getInstance().getConfig().setTargetChunkPointNum(originTargetChunkPointNum);
            IoTDBDescriptor.getInstance().getConfig().setChunkSizeLowerBoundInCompaction(originChunkSizeLowerBound);
            IoTDBDescriptor.getInstance().getConfig().setChunkPointNumLowerBoundInCompaction(originChunkPointNumLowerBound);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLargeChunkDeserializeIntoPoint() throws Exception {
        long testTargetChunkPointNum = 2000L;
        long testChunkSizeLowerBound = 1024L;
        long testChunkPointNumLowerBound = 100L;
        long originTargetChunkSize = IoTDBDescriptor.getInstance().getConfig().getTargetChunkSize();
        long originTargetChunkPointNum = IoTDBDescriptor.getInstance().getConfig().getTargetChunkPointNum();
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkSize(0x100000L);
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkPointNum(testTargetChunkPointNum);
        long originChunkSizeLowerBound = IoTDBDescriptor.getInstance().getConfig().getChunkSizeLowerBoundInCompaction();
        IoTDBDescriptor.getInstance().getConfig().setChunkSizeLowerBoundInCompaction(testChunkSizeLowerBound);
        long originChunkPointNumLowerBound = IoTDBDescriptor.getInstance().getConfig().getChunkPointNumLowerBoundInCompaction();
        IoTDBDescriptor.getInstance().getConfig().setChunkPointNumLowerBoundInCompaction(testChunkPointNumLowerBound);
        try {
            ArrayList<TsFileResource> sourceFiles = new ArrayList<TsFileResource>();
            int fileNum = 6;
            long pointStep = 10L;
            long[] points = new long[fileNum];
            for (int i = 0; i < fileNum - 1; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add((long)(i + 1) * pointStep);
                points[i] = (long)(i + 1) * pointStep;
                chunkPagePointsNum.add(pagePointsNum);
                TsFileResource resource = new TsFileResource(new File(SEQ_DIRS, String.format("%d-%d-0-0.tsfile", i + 1, i + 1)));
                sourceFiles.add(resource);
                CompactionFileGeneratorUtils.writeTsFile(this.fullPathSet, chunkPagePointsNum, (long)i * 1500L, resource);
            }
            ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
            ArrayList<Long> pagePointsNum = new ArrayList<Long>();
            pagePointsNum.add(testTargetChunkPointNum + 100L);
            points[fileNum - 1] = testTargetChunkPointNum + 100L;
            chunkPagePointsNum.add(pagePointsNum);
            TsFileResource resource = new TsFileResource(new File(SEQ_DIRS, String.format("%d-%d-0-0.tsfile", fileNum, fileNum)));
            sourceFiles.add(resource);
            CompactionFileGeneratorUtils.writeTsFile(this.fullPathSet, chunkPagePointsNum, (long)fileNum * testTargetChunkPointNum, resource);
            Map<PartialPath, List<TimeValuePair>> originData = CompactionCheckerUtils.getDataByQuery(this.paths, this.schemaList, sourceFiles, new ArrayList<TsFileResource>());
            TsFileNameGenerator.TsFileName tsFileName = TsFileNameGenerator.getTsFileName((String)((TsFileResource)sourceFiles.get(0)).getTsFile().getName());
            TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource(sourceFiles, (boolean)true);
            this.performer.setSourceFiles(sourceFiles);
            this.performer.setTargetFiles(Collections.singletonList(targetResource));
            this.performer.setSummary(new CompactionTaskSummary());
            this.performer.perform();
            CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)"root.compactionTest");
            HashMap<String, List<List<Long>>> chunkPagePointsNumMerged = new HashMap<String, List<List<Long>>>();
            for (String path : this.fullPathSet) {
                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, path, (long)((fileNum - 1) * fileNum) * pointStep / 2L + testTargetChunkPointNum + 100L);
            }
            Map<PartialPath, List<TimeValuePair>> compactedData = CompactionCheckerUtils.getDataByQuery(this.paths, this.schemaList, Collections.singletonList(targetResource), new ArrayList<TsFileResource>());
            CompactionCheckerUtils.validDataByValueList(originData, compactedData);
            CompactionCheckerUtils.checkChunkAndPage(chunkPagePointsNumMerged, targetResource);
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setTargetChunkSize(originTargetChunkSize);
            IoTDBDescriptor.getInstance().getConfig().setTargetChunkPointNum(originTargetChunkPointNum);
            IoTDBDescriptor.getInstance().getConfig().setChunkSizeLowerBoundInCompaction(originChunkSizeLowerBound);
            IoTDBDescriptor.getInstance().getConfig().setChunkPointNumLowerBoundInCompaction(originChunkPointNumLowerBound);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMergeChunk() throws Exception {
        long testTargetChunkPointNum = 1000L;
        long originTargetChunkSize = IoTDBDescriptor.getInstance().getConfig().getTargetChunkSize();
        long originTargetChunkPointNum = IoTDBDescriptor.getInstance().getConfig().getTargetChunkPointNum();
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkSize(10240L);
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkPointNum(testTargetChunkPointNum);
        long originChunkSizeLowerBound = IoTDBDescriptor.getInstance().getConfig().getChunkSizeLowerBoundInCompaction();
        IoTDBDescriptor.getInstance().getConfig().setChunkSizeLowerBoundInCompaction(1L);
        long originChunkPointNumLowerBound = IoTDBDescriptor.getInstance().getConfig().getChunkPointNumLowerBoundInCompaction();
        IoTDBDescriptor.getInstance().getConfig().setChunkPointNumLowerBoundInCompaction(1L);
        try {
            ArrayList<TsFileResource> sourceFiles = new ArrayList<TsFileResource>();
            HashSet<String> fullPathSetWithDeleted = new HashSet<String>(this.fullPathSet);
            String deletedPath = "root.compactionTest.device999.s999";
            fullPathSetWithDeleted.add(deletedPath);
            int fileNum = 6;
            long pointStep = 300L;
            for (int i = 0; i < fileNum; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(((long)i + 1L) * pointStep);
                chunkPagePointsNum.add(pagePointsNum);
                TsFileResource resource = new TsFileResource(new File(SEQ_DIRS, String.format("%d-%d-0-0.tsfile", i + 1, i + 1)));
                sourceFiles.add(resource);
                CompactionFileGeneratorUtils.writeTsFile(fullPathSetWithDeleted, chunkPagePointsNum, (long)i * 1500L, resource);
            }
            Map<PartialPath, List<TimeValuePair>> originData = CompactionCheckerUtils.getDataByQuery(this.paths, this.schemaList, sourceFiles, new ArrayList<TsFileResource>());
            TsFileNameGenerator.TsFileName tsFileName = TsFileNameGenerator.getTsFileName((String)((TsFileResource)sourceFiles.get(0)).getTsFile().getName());
            TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource(sourceFiles, (boolean)true);
            this.performer.setSourceFiles(sourceFiles);
            this.performer.setTargetFiles(Collections.singletonList(targetResource));
            this.performer.setSummary(new CompactionTaskSummary());
            this.performer.perform();
            CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)"root.compactionTest");
            HashMap<String, List<List<Long>>> chunkPagePointsNumMerged = new HashMap<String, List<List<Long>>>();
            ArrayList chunkPointsArray = new ArrayList();
            ArrayList<Long> pointsArray = new ArrayList<Long>();
            long curPointNum = 0L;
            for (int i = 0; i < fileNum; ++i) {
                pointsArray.add(((long)i + 1L) * pointStep);
                if ((curPointNum += ((long)i + 1L) * pointStep) <= testTargetChunkPointNum) continue;
                chunkPointsArray.add(pointsArray);
                pointsArray = new ArrayList();
                curPointNum = 0L;
            }
            if (curPointNum > 0L) {
                chunkPointsArray.add(pointsArray);
            }
            for (String path : fullPathSetWithDeleted) {
                chunkPagePointsNumMerged.put(path, chunkPointsArray);
            }
            CompactionCheckerUtils.checkChunkAndPage(chunkPagePointsNumMerged, targetResource);
            Map<PartialPath, List<TimeValuePair>> compactedData = CompactionCheckerUtils.getDataByQuery(this.paths, this.schemaList, Collections.singletonList(targetResource), new ArrayList<TsFileResource>());
            CompactionCheckerUtils.validDataByValueList(originData, compactedData);
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setTargetChunkSize(originTargetChunkSize);
            IoTDBDescriptor.getInstance().getConfig().setTargetChunkPointNum(originTargetChunkPointNum);
            IoTDBDescriptor.getInstance().getConfig().setChunkSizeLowerBoundInCompaction(originChunkSizeLowerBound);
            IoTDBDescriptor.getInstance().getConfig().setChunkPointNumLowerBoundInCompaction(originChunkPointNumLowerBound);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMiddleChunkDeserialize() throws Exception {
        long testTargetChunkPointNum = 2000L;
        long testChunkSizeLowerBound = 1024L;
        long testChunkPointNumLowerBound = 100L;
        long originTargetChunkSize = IoTDBDescriptor.getInstance().getConfig().getTargetChunkSize();
        long originTargetChunkPointNum = IoTDBDescriptor.getInstance().getConfig().getTargetChunkPointNum();
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkSize(0x100000L);
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkPointNum(testTargetChunkPointNum);
        long originChunkSizeLowerBound = IoTDBDescriptor.getInstance().getConfig().getChunkSizeLowerBoundInCompaction();
        IoTDBDescriptor.getInstance().getConfig().setChunkSizeLowerBoundInCompaction(testChunkSizeLowerBound);
        long originChunkPointNumLowerBound = IoTDBDescriptor.getInstance().getConfig().getChunkPointNumLowerBoundInCompaction();
        IoTDBDescriptor.getInstance().getConfig().setChunkPointNumLowerBoundInCompaction(testChunkPointNumLowerBound);
        try {
            ArrayList<TsFileResource> sourceFiles = new ArrayList<TsFileResource>();
            int fileNum = 6;
            long pointStep = 10L;
            long[] points = new long[fileNum];
            for (int i = 0; i < fileNum - 1; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add((long)(i + 1) * pointStep);
                points[i] = (long)(i + 1) * pointStep;
                chunkPagePointsNum.add(pagePointsNum);
                TsFileResource resource = new TsFileResource(new File(SEQ_DIRS, String.format("%d-%d-0-0.tsfile", i + 1, i + 1)));
                sourceFiles.add(resource);
                CompactionFileGeneratorUtils.writeTsFile(this.fullPathSet, chunkPagePointsNum, (long)i * 1500L, resource);
            }
            ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
            ArrayList<Long> pagePointsNum = new ArrayList<Long>();
            pagePointsNum.add(testTargetChunkPointNum - 100L);
            points[fileNum - 1] = testTargetChunkPointNum - 100L;
            chunkPagePointsNum.add(pagePointsNum);
            TsFileResource resource = new TsFileResource(new File(SEQ_DIRS, String.format("%d-%d-0-0.tsfile", fileNum, fileNum)));
            sourceFiles.add(resource);
            CompactionFileGeneratorUtils.writeTsFile(this.fullPathSet, chunkPagePointsNum, (long)fileNum * testTargetChunkPointNum, resource);
            Map<PartialPath, List<TimeValuePair>> originData = CompactionCheckerUtils.getDataByQuery(this.paths, this.schemaList, sourceFiles, new ArrayList<TsFileResource>());
            TsFileNameGenerator.TsFileName tsFileName = TsFileNameGenerator.getTsFileName((String)((TsFileResource)sourceFiles.get(0)).getTsFile().getName());
            TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource(sourceFiles, (boolean)true);
            this.performer.setSourceFiles(sourceFiles);
            this.performer.setTargetFiles(Collections.singletonList(targetResource));
            this.performer.setSummary(new CompactionTaskSummary());
            this.performer.perform();
            CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)"root.compactionTest");
            HashMap<String, List<List<Long>>> chunkPagePointsNumMerged = new HashMap<String, List<List<Long>>>();
            for (String path : this.fullPathSet) {
                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, path, (long)((fileNum - 1) * fileNum) * pointStep / 2L + testTargetChunkPointNum - 100L);
            }
            Map<PartialPath, List<TimeValuePair>> compactedData = CompactionCheckerUtils.getDataByQuery(this.paths, this.schemaList, Collections.singletonList(targetResource), new ArrayList<TsFileResource>());
            CompactionCheckerUtils.validDataByValueList(originData, compactedData);
            CompactionCheckerUtils.checkChunkAndPage(chunkPagePointsNumMerged, targetResource);
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setTargetChunkSize(originTargetChunkSize);
            IoTDBDescriptor.getInstance().getConfig().setTargetChunkPointNum(originTargetChunkPointNum);
            IoTDBDescriptor.getInstance().getConfig().setChunkSizeLowerBoundInCompaction(originChunkSizeLowerBound);
            IoTDBDescriptor.getInstance().getConfig().setChunkPointNumLowerBoundInCompaction(originChunkPointNumLowerBound);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeserializePage() throws Exception {
        long testTargetChunkPointNum = 1500L;
        long testChunkSizeLowerBound = 1024L;
        long testChunkPointNumLowerBound = 1000L;
        long originTargetChunkSize = IoTDBDescriptor.getInstance().getConfig().getTargetChunkSize();
        long originTargetChunkPointNum = IoTDBDescriptor.getInstance().getConfig().getTargetChunkPointNum();
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkSize(10240L);
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkPointNum(testTargetChunkPointNum);
        long originChunkSizeLowerBound = IoTDBDescriptor.getInstance().getConfig().getChunkSizeLowerBoundInCompaction();
        IoTDBDescriptor.getInstance().getConfig().setChunkSizeLowerBoundInCompaction(testChunkSizeLowerBound);
        long originChunkPointNumLowerBound = IoTDBDescriptor.getInstance().getConfig().getChunkPointNumLowerBoundInCompaction();
        IoTDBDescriptor.getInstance().getConfig().setChunkPointNumLowerBoundInCompaction(testChunkPointNumLowerBound);
        try {
            ArrayList<TsFileResource> sourceFiles = new ArrayList<TsFileResource>();
            int fileNum = 6;
            long pointStep = 50L;
            for (int i = 0; i < fileNum; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(((long)i + 1L) * pointStep);
                chunkPagePointsNum.add(pagePointsNum);
                TsFileResource resource = new TsFileResource(new File(SEQ_DIRS, String.format("%d-%d-0-0.tsfile", i + 1, i + 1)));
                sourceFiles.add(resource);
                CompactionFileGeneratorUtils.writeTsFile(this.fullPathSet, chunkPagePointsNum, (long)i * 1500L, resource);
            }
            Map<PartialPath, List<TimeValuePair>> originData = CompactionCheckerUtils.getDataByQuery(this.paths, this.schemaList, sourceFiles, new ArrayList<TsFileResource>());
            TsFileNameGenerator.TsFileName tsFileName = TsFileNameGenerator.getTsFileName((String)((TsFileResource)sourceFiles.get(0)).getTsFile().getName());
            TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource(sourceFiles, (boolean)true);
            this.performer.setSourceFiles(sourceFiles);
            this.performer.setTargetFiles(Collections.singletonList(targetResource));
            this.performer.setSummary(new CompactionTaskSummary());
            this.performer.perform();
            CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)"root.compactionTest");
            HashMap<String, List<List<Long>>> chunkPagePointsNumMerged = new HashMap<String, List<List<Long>>>();
            ArrayList chunkPointsArray = new ArrayList();
            for (String path : this.fullPathSet) {
                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, path, (long)(fileNum * (fileNum + 1)) * pointStep / 2L);
            }
            CompactionCheckerUtils.checkChunkAndPage(chunkPagePointsNumMerged, targetResource);
            Map<PartialPath, List<TimeValuePair>> compactedData = CompactionCheckerUtils.getDataByQuery(this.paths, this.schemaList, Collections.singletonList(targetResource), new ArrayList<TsFileResource>());
            CompactionCheckerUtils.validDataByValueList(originData, compactedData);
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setTargetChunkSize(originTargetChunkSize);
            IoTDBDescriptor.getInstance().getConfig().setTargetChunkPointNum(originTargetChunkPointNum);
            IoTDBDescriptor.getInstance().getConfig().setChunkSizeLowerBoundInCompaction(originChunkSizeLowerBound);
            IoTDBDescriptor.getInstance().getConfig().setChunkPointNumLowerBoundInCompaction(originChunkPointNumLowerBound);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeserializeCachedChunk() throws Exception {
        long testTargetChunkPointNum = 1500L;
        long testChunkSizeLowerBound = 1024L;
        long testChunkPointNumLowerBound = 100L;
        long originTargetChunkSize = IoTDBDescriptor.getInstance().getConfig().getTargetChunkSize();
        long originTargetChunkPointNum = IoTDBDescriptor.getInstance().getConfig().getTargetChunkPointNum();
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkSize(10240L);
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkPointNum(testTargetChunkPointNum);
        long originChunkSizeLowerBound = IoTDBDescriptor.getInstance().getConfig().getChunkSizeLowerBoundInCompaction();
        IoTDBDescriptor.getInstance().getConfig().setChunkSizeLowerBoundInCompaction(testChunkSizeLowerBound);
        long originChunkPointNumLowerBound = IoTDBDescriptor.getInstance().getConfig().getChunkPointNumLowerBoundInCompaction();
        IoTDBDescriptor.getInstance().getConfig().setChunkPointNumLowerBoundInCompaction(testChunkPointNumLowerBound);
        try {
            ArrayList<TsFileResource> sourceFiles = new ArrayList<TsFileResource>();
            int fileNum = 6;
            long pointStep = 50L;
            for (int i = 0; i < fileNum; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add((long)(fileNum - i) * pointStep);
                chunkPagePointsNum.add(pagePointsNum);
                TsFileResource resource = new TsFileResource(new File(SEQ_DIRS, String.format("%d-%d-0-0.tsfile", i + 1, i + 1)));
                sourceFiles.add(resource);
                CompactionFileGeneratorUtils.writeTsFile(this.fullPathSet, chunkPagePointsNum, (long)i * 1500L, resource);
            }
            Map<PartialPath, List<TimeValuePair>> originData = CompactionCheckerUtils.getDataByQuery(this.paths, this.schemaList, sourceFiles, new ArrayList<TsFileResource>());
            TsFileNameGenerator.TsFileName tsFileName = TsFileNameGenerator.getTsFileName((String)((TsFileResource)sourceFiles.get(0)).getTsFile().getName());
            TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource(sourceFiles, (boolean)true);
            this.performer.setSourceFiles(sourceFiles);
            this.performer.setTargetFiles(Collections.singletonList(targetResource));
            this.performer.setSummary(new CompactionTaskSummary());
            this.performer.perform();
            CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)"root.compactionTest");
            HashMap<String, List<List<Long>>> chunkPagePointsNumMerged = new HashMap<String, List<List<Long>>>();
            ArrayList chunkPointsArray = new ArrayList();
            for (String path : this.fullPathSet) {
                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, path, (long)(fileNum * (fileNum + 1)) * pointStep / 2L);
            }
            CompactionCheckerUtils.checkChunkAndPage(chunkPagePointsNumMerged, targetResource);
            Map<PartialPath, List<TimeValuePair>> compactedData = CompactionCheckerUtils.getDataByQuery(this.paths, this.schemaList, Collections.singletonList(targetResource), new ArrayList<TsFileResource>());
            CompactionCheckerUtils.validDataByValueList(originData, compactedData);
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setTargetChunkSize(originTargetChunkSize);
            IoTDBDescriptor.getInstance().getConfig().setTargetChunkPointNum(originTargetChunkPointNum);
            IoTDBDescriptor.getInstance().getConfig().setChunkSizeLowerBoundInCompaction(originChunkSizeLowerBound);
            IoTDBDescriptor.getInstance().getConfig().setChunkPointNumLowerBoundInCompaction(originChunkPointNumLowerBound);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMixCompact1() throws Exception {
        long testTargetChunkPointNum = 2000L;
        long testChunkSizeLowerBound = 1024L;
        long testChunkPointNumLowerBound = 100L;
        long originTargetChunkSize = IoTDBDescriptor.getInstance().getConfig().getTargetChunkSize();
        long originTargetChunkPointNum = IoTDBDescriptor.getInstance().getConfig().getTargetChunkPointNum();
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkSize(0x100000L);
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkPointNum(testTargetChunkPointNum);
        long originChunkSizeLowerBound = IoTDBDescriptor.getInstance().getConfig().getChunkSizeLowerBoundInCompaction();
        IoTDBDescriptor.getInstance().getConfig().setChunkSizeLowerBoundInCompaction(testChunkSizeLowerBound);
        long originChunkPointNumLowerBound = IoTDBDescriptor.getInstance().getConfig().getChunkPointNumLowerBoundInCompaction();
        IoTDBDescriptor.getInstance().getConfig().setChunkPointNumLowerBoundInCompaction(testChunkPointNumLowerBound);
        try {
            ArrayList<TsFileResource> sourceFiles = new ArrayList<TsFileResource>();
            int fileNum = 12;
            long[] points = new long[]{100L, 200L, 300L, 50L, 2100L, 50L, 600L, 2300L, 2500L, 1000L, 500L, 500L};
            for (int i = 0; i < fileNum; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(points[i]);
                chunkPagePointsNum.add(pagePointsNum);
                TsFileResource resource = new TsFileResource(new File(SEQ_DIRS, String.format("%d-%d-0-0.tsfile", i + 1, i + 1)));
                sourceFiles.add(resource);
                CompactionFileGeneratorUtils.writeTsFile(this.fullPathSet, chunkPagePointsNum, (long)i * 2500L, resource);
            }
            Map<PartialPath, List<TimeValuePair>> originData = CompactionCheckerUtils.getDataByQuery(this.paths, this.schemaList, sourceFiles, new ArrayList<TsFileResource>());
            TsFileNameGenerator.TsFileName tsFileName = TsFileNameGenerator.getTsFileName((String)((TsFileResource)sourceFiles.get(0)).getTsFile().getName());
            TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource(sourceFiles, (boolean)true);
            this.performer.setSourceFiles(sourceFiles);
            this.performer.setTargetFiles(Collections.singletonList(targetResource));
            this.performer.setSummary(new CompactionTaskSummary());
            this.performer.perform();
            CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)"root.compactionTest");
            HashMap<String, List<List<Long>>> chunkPagePointsNumMerged = new HashMap<String, List<List<Long>>>();
            for (String path : this.fullPathSet) {
                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, path, 2750L);
                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, path, 2950L);
                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, path, 2500L);
                CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, path, new long[]{1000L, 500L, 500L});
            }
            Map<PartialPath, List<TimeValuePair>> compactedData = CompactionCheckerUtils.getDataByQuery(this.paths, this.schemaList, Collections.singletonList(targetResource), new ArrayList<TsFileResource>());
            CompactionCheckerUtils.validDataByValueList(originData, compactedData);
            CompactionCheckerUtils.checkChunkAndPage(chunkPagePointsNumMerged, targetResource);
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setTargetChunkSize(originTargetChunkSize);
            IoTDBDescriptor.getInstance().getConfig().setTargetChunkPointNum(originTargetChunkPointNum);
            IoTDBDescriptor.getInstance().getConfig().setChunkSizeLowerBoundInCompaction(originChunkSizeLowerBound);
            IoTDBDescriptor.getInstance().getConfig().setChunkPointNumLowerBoundInCompaction(originChunkPointNumLowerBound);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMixCompact2() throws Exception {
        long testTargetChunkPointNum = 2000L;
        long testChunkSizeLowerBound = 1024L;
        long testChunkPointNumLowerBound = 100L;
        long originTargetChunkSize = IoTDBDescriptor.getInstance().getConfig().getTargetChunkSize();
        long originTargetChunkPointNum = IoTDBDescriptor.getInstance().getConfig().getTargetChunkPointNum();
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkSize(0x100000L);
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkPointNum(testTargetChunkPointNum);
        long originChunkSizeLowerBound = IoTDBDescriptor.getInstance().getConfig().getChunkSizeLowerBoundInCompaction();
        IoTDBDescriptor.getInstance().getConfig().setChunkSizeLowerBoundInCompaction(testChunkSizeLowerBound);
        long originChunkPointNumLowerBound = IoTDBDescriptor.getInstance().getConfig().getChunkPointNumLowerBoundInCompaction();
        IoTDBDescriptor.getInstance().getConfig().setChunkPointNumLowerBoundInCompaction(testChunkPointNumLowerBound);
        try {
            ArrayList<TsFileResource> sourceFiles = new ArrayList<TsFileResource>();
            int fileNum = 12;
            long pointStep = 10L;
            long[] points = new long[]{1960L, 50L, 1960L, 50L, 2100L, 50L, 1960L, 2300L, 2500L, 1000L, 500L, 500L};
            for (int i = 0; i < fileNum; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(points[i]);
                chunkPagePointsNum.add(pagePointsNum);
                TsFileResource resource = new TsFileResource(new File(SEQ_DIRS, String.format("%d-%d-0-0.tsfile", i + 1, i + 1)));
                sourceFiles.add(resource);
                CompactionFileGeneratorUtils.writeTsFile(this.fullPathSet, chunkPagePointsNum, (long)i * 2500L, resource);
            }
            Map<PartialPath, List<TimeValuePair>> originData = CompactionCheckerUtils.getDataByQuery(this.paths, this.schemaList, sourceFiles, new ArrayList<TsFileResource>());
            TsFileNameGenerator.TsFileName tsFileName = TsFileNameGenerator.getTsFileName((String)((TsFileResource)sourceFiles.get(0)).getTsFile().getName());
            TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource(sourceFiles, (boolean)true);
            this.performer.setSourceFiles(sourceFiles);
            this.performer.setTargetFiles(Collections.singletonList(targetResource));
            this.performer.setSummary(new CompactionTaskSummary());
            this.performer.perform();
            CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)"root.compactionTest");
            HashMap<String, List<List<Long>>> chunkPagePointsNumMerged = new HashMap<String, List<List<Long>>>();
            for (String path : this.fullPathSet) {
                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, path, 2010L);
                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, path, 2010L);
                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, path, 2100L);
                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, path, 2010L);
                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, path, 2300L);
                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, path, 2500L);
                CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, path, new long[]{1000L, 500L, 500L});
            }
            Map<PartialPath, List<TimeValuePair>> compactedData = CompactionCheckerUtils.getDataByQuery(this.paths, this.schemaList, Collections.singletonList(targetResource), new ArrayList<TsFileResource>());
            CompactionCheckerUtils.validDataByValueList(originData, compactedData);
            CompactionCheckerUtils.checkChunkAndPage(chunkPagePointsNumMerged, targetResource);
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setTargetChunkSize(originTargetChunkSize);
            IoTDBDescriptor.getInstance().getConfig().setTargetChunkPointNum(originTargetChunkPointNum);
            IoTDBDescriptor.getInstance().getConfig().setChunkSizeLowerBoundInCompaction(originChunkSizeLowerBound);
            IoTDBDescriptor.getInstance().getConfig().setChunkPointNumLowerBoundInCompaction(originChunkPointNumLowerBound);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMergeChunkWithDifferentEncoding() throws Exception {
        long testTargetChunkPointNum = 1000L;
        long originTargetChunkSize = IoTDBDescriptor.getInstance().getConfig().getTargetChunkSize();
        long originTargetChunkPointNum = IoTDBDescriptor.getInstance().getConfig().getTargetChunkPointNum();
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkSize(10240L);
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkPointNum(testTargetChunkPointNum);
        long originChunkSizeLowerBound = IoTDBDescriptor.getInstance().getConfig().getChunkSizeLowerBoundInCompaction();
        IoTDBDescriptor.getInstance().getConfig().setChunkSizeLowerBoundInCompaction(1L);
        long originChunkPointNumLowerBound = IoTDBDescriptor.getInstance().getConfig().getChunkPointNumLowerBoundInCompaction();
        IoTDBDescriptor.getInstance().getConfig().setChunkPointNumLowerBoundInCompaction(1L);
        try {
            ArrayList<TsFileResource> sourceFiles = new ArrayList<TsFileResource>();
            HashSet<String> fullPathSetWithDeleted = new HashSet<String>(this.fullPathSet);
            String deletedPath = "root.compactionTest.device999.s999";
            fullPathSetWithDeleted.add(deletedPath);
            int fileNum = 6;
            long pointStep = 300L;
            for (int i = 0; i < fileNum; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(((long)i + 1L) * pointStep);
                chunkPagePointsNum.add(pagePointsNum);
                TsFileResource resource = new TsFileResource(new File(SEQ_DIRS, String.format("%d-%d-0-0.tsfile", i + 1, i + 1)));
                sourceFiles.add(resource);
                CompactionFileGeneratorUtils.writeTsFile(fullPathSetWithDeleted, chunkPagePointsNum, (long)i * 2000L, resource, i % 2 == 0 ? TSEncoding.PLAIN : TSEncoding.RLE, CompressionType.SNAPPY);
                HashMap<String, Pair<Long, Long>> deletionMap = new HashMap<String, Pair<Long, Long>>();
                deletionMap.put(deletedPath, new Pair((Object)((long)i * 2000L), (Object)((long)(i + 1) * 2000L)));
                CompactionFileGeneratorUtils.generateMods(deletionMap, resource, false);
            }
            Map<PartialPath, List<TimeValuePair>> originData = CompactionCheckerUtils.getDataByQuery(this.paths, this.schemaList, sourceFiles, new ArrayList<TsFileResource>());
            TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource(sourceFiles, (boolean)true);
            this.performer.setSourceFiles(sourceFiles);
            this.performer.setTargetFiles(Collections.singletonList(targetResource));
            this.performer.setSummary(new CompactionTaskSummary());
            this.performer.perform();
            HashMap chunkPagePointsNumMerged = new HashMap();
            ArrayList chunkPointsArray = new ArrayList();
            ArrayList<Long> pointsArray = new ArrayList<Long>();
            long curPointNum = 0L;
            for (int i = 0; i < fileNum; ++i) {
                pointsArray.add(((long)i + 1L) * pointStep);
                if ((curPointNum += ((long)i + 1L) * pointStep) <= testTargetChunkPointNum) continue;
                chunkPointsArray.add(pointsArray);
                pointsArray = new ArrayList();
                curPointNum = 0L;
            }
            if (curPointNum > 0L) {
                chunkPointsArray.add(pointsArray);
            }
            for (String path : fullPathSetWithDeleted) {
                chunkPagePointsNumMerged.put(path, chunkPointsArray);
            }
            chunkPagePointsNumMerged.put(deletedPath, null);
            CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)"root.compactionTest");
            Map<PartialPath, List<TimeValuePair>> compactedData = CompactionCheckerUtils.getDataByQuery(this.paths, this.schemaList, Collections.singletonList(targetResource), new ArrayList<TsFileResource>());
            CompactionCheckerUtils.validDataByValueList(originData, compactedData);
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setTargetChunkSize(originTargetChunkSize);
            IoTDBDescriptor.getInstance().getConfig().setTargetChunkPointNum(originTargetChunkPointNum);
            IoTDBDescriptor.getInstance().getConfig().setChunkSizeLowerBoundInCompaction(originChunkSizeLowerBound);
            IoTDBDescriptor.getInstance().getConfig().setChunkPointNumLowerBoundInCompaction(originChunkPointNumLowerBound);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMergeChunkWithDifferentCompression() throws Exception {
        long testTargetChunkPointNum = 1000L;
        long originTargetChunkSize = IoTDBDescriptor.getInstance().getConfig().getTargetChunkSize();
        long originTargetChunkPointNum = IoTDBDescriptor.getInstance().getConfig().getTargetChunkPointNum();
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkSize(10240L);
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkPointNum(testTargetChunkPointNum);
        long originChunkSizeLowerBound = IoTDBDescriptor.getInstance().getConfig().getChunkSizeLowerBoundInCompaction();
        IoTDBDescriptor.getInstance().getConfig().setChunkSizeLowerBoundInCompaction(1L);
        long originChunkPointNumLowerBound = IoTDBDescriptor.getInstance().getConfig().getChunkPointNumLowerBoundInCompaction();
        IoTDBDescriptor.getInstance().getConfig().setChunkPointNumLowerBoundInCompaction(1L);
        try {
            ArrayList<TsFileResource> sourceFiles = new ArrayList<TsFileResource>();
            HashSet<String> fullPathSetWithDeleted = new HashSet<String>(this.fullPathSet);
            String deletedPath = "root.compactionTest.device999.s999";
            fullPathSetWithDeleted.add(deletedPath);
            int fileNum = 6;
            long pointStep = 300L;
            for (int i = 0; i < fileNum; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(((long)i + 1L) * pointStep);
                chunkPagePointsNum.add(pagePointsNum);
                TsFileResource resource = new TsFileResource(new File(SEQ_DIRS, String.format("%d-%d-0-0.tsfile", i + 1, i + 1)));
                sourceFiles.add(resource);
                CompactionFileGeneratorUtils.writeTsFile(fullPathSetWithDeleted, chunkPagePointsNum, (long)i * 2000L, resource, TSEncoding.PLAIN, i % 2 == 0 ? CompressionType.SNAPPY : CompressionType.GZIP);
                HashMap<String, Pair<Long, Long>> deletionMap = new HashMap<String, Pair<Long, Long>>();
                deletionMap.put(deletedPath, new Pair((Object)((long)i * 2000L), (Object)((long)(i + 1) * 2000L)));
                CompactionFileGeneratorUtils.generateMods(deletionMap, resource, false);
            }
            Map<PartialPath, List<TimeValuePair>> originData = CompactionCheckerUtils.getDataByQuery(this.paths, this.schemaList, sourceFiles, new ArrayList<TsFileResource>());
            TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource(sourceFiles, (boolean)true);
            this.performer.setSourceFiles(sourceFiles);
            this.performer.setTargetFiles(Collections.singletonList(targetResource));
            this.performer.setSummary(new CompactionTaskSummary());
            this.performer.perform();
            HashMap chunkPagePointsNumMerged = new HashMap();
            ArrayList chunkPointsArray = new ArrayList();
            ArrayList<Long> pointsArray = new ArrayList<Long>();
            long curPointNum = 0L;
            for (int i = 0; i < fileNum; ++i) {
                pointsArray.add(((long)i + 1L) * pointStep);
                if ((curPointNum += ((long)i + 1L) * pointStep) <= testTargetChunkPointNum) continue;
                chunkPointsArray.add(pointsArray);
                pointsArray = new ArrayList();
                curPointNum = 0L;
            }
            if (curPointNum > 0L) {
                chunkPointsArray.add(pointsArray);
            }
            for (String path : fullPathSetWithDeleted) {
                chunkPagePointsNumMerged.put(path, chunkPointsArray);
            }
            chunkPagePointsNumMerged.put(deletedPath, null);
            CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)"root.compactionTest");
            Map<PartialPath, List<TimeValuePair>> compactedData = CompactionCheckerUtils.getDataByQuery(this.paths, this.schemaList, Collections.singletonList(targetResource), new ArrayList<TsFileResource>());
            CompactionCheckerUtils.validDataByValueList(originData, compactedData);
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setTargetChunkSize(originTargetChunkSize);
            IoTDBDescriptor.getInstance().getConfig().setTargetChunkPointNum(originTargetChunkPointNum);
            IoTDBDescriptor.getInstance().getConfig().setChunkSizeLowerBoundInCompaction(originChunkSizeLowerBound);
            IoTDBDescriptor.getInstance().getConfig().setChunkPointNumLowerBoundInCompaction(originChunkPointNumLowerBound);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMergeChunkWithDifferentCompressionAndEncoding() throws Exception {
        long testTargetChunkPointNum = 1000L;
        long originTargetChunkSize = IoTDBDescriptor.getInstance().getConfig().getTargetChunkSize();
        long originTargetChunkPointNum = IoTDBDescriptor.getInstance().getConfig().getTargetChunkPointNum();
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkSize(10240L);
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkPointNum(testTargetChunkPointNum);
        long originChunkSizeLowerBound = IoTDBDescriptor.getInstance().getConfig().getChunkSizeLowerBoundInCompaction();
        IoTDBDescriptor.getInstance().getConfig().setChunkSizeLowerBoundInCompaction(1L);
        long originChunkPointNumLowerBound = IoTDBDescriptor.getInstance().getConfig().getChunkPointNumLowerBoundInCompaction();
        IoTDBDescriptor.getInstance().getConfig().setChunkPointNumLowerBoundInCompaction(1L);
        try {
            ArrayList<TsFileResource> sourceFiles = new ArrayList<TsFileResource>();
            HashSet<String> fullPathSetWithDeleted = new HashSet<String>(this.fullPathSet);
            String deletedPath = "root.compactionTest.device999.s999";
            fullPathSetWithDeleted.add(deletedPath);
            int fileNum = 6;
            long pointStep = 300L;
            Random random = new Random();
            for (int i = 0; i < fileNum; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(((long)i + 1L) * pointStep);
                chunkPagePointsNum.add(pagePointsNum);
                TsFileResource resource = new TsFileResource(new File(SEQ_DIRS, String.format("%d-%d-0-0.tsfile", i + 1, i + 1)));
                sourceFiles.add(resource);
                CompactionFileGeneratorUtils.writeTsFile(fullPathSetWithDeleted, chunkPagePointsNum, (long)i * 2000L, resource, random.nextInt() % 2 == 0 ? (random.nextInt() % 5 < 2 ? TSEncoding.RLE : TSEncoding.GORILLA) : TSEncoding.PLAIN, random.nextInt() % 3 == 0 ? (random.nextInt() % 5 < 2 ? CompressionType.SNAPPY : CompressionType.LZ4) : CompressionType.GZIP);
                HashMap<String, Pair<Long, Long>> deletionMap = new HashMap<String, Pair<Long, Long>>();
                deletionMap.put(deletedPath, new Pair((Object)((long)i * 2000L), (Object)((long)(i + 1) * 2000L)));
                CompactionFileGeneratorUtils.generateMods(deletionMap, resource, false);
            }
            Map<PartialPath, List<TimeValuePair>> originData = CompactionCheckerUtils.getDataByQuery(this.paths, this.schemaList, sourceFiles, new ArrayList<TsFileResource>());
            TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource(sourceFiles, (boolean)true);
            this.performer.setSourceFiles(sourceFiles);
            this.performer.setTargetFiles(Collections.singletonList(targetResource));
            this.performer.setSummary(new CompactionTaskSummary());
            this.performer.perform();
            HashMap chunkPagePointsNumMerged = new HashMap();
            ArrayList chunkPointsArray = new ArrayList();
            ArrayList<Long> pointsArray = new ArrayList<Long>();
            long curPointNum = 0L;
            for (int i = 0; i < fileNum; ++i) {
                pointsArray.add(((long)i + 1L) * pointStep);
                if ((curPointNum += ((long)i + 1L) * pointStep) <= testTargetChunkPointNum) continue;
                chunkPointsArray.add(pointsArray);
                pointsArray = new ArrayList();
                curPointNum = 0L;
            }
            if (curPointNum > 0L) {
                chunkPointsArray.add(pointsArray);
            }
            for (String path : fullPathSetWithDeleted) {
                chunkPagePointsNumMerged.put(path, chunkPointsArray);
            }
            chunkPagePointsNumMerged.put(deletedPath, null);
            CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)"root.compactionTest");
            Map<PartialPath, List<TimeValuePair>> compactedData = CompactionCheckerUtils.getDataByQuery(this.paths, this.schemaList, Collections.singletonList(targetResource), new ArrayList<TsFileResource>());
            CompactionCheckerUtils.validDataByValueList(originData, compactedData);
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setTargetChunkSize(originTargetChunkSize);
            IoTDBDescriptor.getInstance().getConfig().setTargetChunkPointNum(originTargetChunkPointNum);
            IoTDBDescriptor.getInstance().getConfig().setChunkSizeLowerBoundInCompaction(originChunkSizeLowerBound);
            IoTDBDescriptor.getInstance().getConfig().setChunkPointNumLowerBoundInCompaction(originChunkPointNumLowerBound);
        }
    }

    static {
        SEQ_DIRS = TestConstant.BASE_OUTPUT_PATH + "data" + File.separator + "sequence" + File.separator + "root.compactionTest" + File.separator + "0" + File.separator + "0";
        UNSEQ_DIRS = TestConstant.BASE_OUTPUT_PATH + "data" + File.separator + "unsequence" + File.separator + "root.compactionTest" + File.separator + "0" + File.separator + "0";
    }
}

