/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.inner;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.AbstractCompactionTest;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.ReadChunkCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.CompactionCheckerUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.CompactionTestFileWriter;
import org.apache.iotdb.db.storageengine.dataregion.modification.Deletion;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.generator.TsFileNameGenerator;
import org.apache.iotdb.db.storageengine.dataregion.utils.TsFileResourceUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.exception.write.PageException;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NewReadChunkCompactionPerformerWithAlignedSeriesTest
extends AbstractCompactionTest {
    long originTargetChunkSize;
    long originTargetChunkPointNum;
    int originTargetPageSize;
    int originTargetPagePointNum;

    @Override
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException, InterruptedException {
        super.setUp();
        this.originTargetChunkSize = IoTDBDescriptor.getInstance().getConfig().getTargetChunkSize();
        this.originTargetChunkPointNum = IoTDBDescriptor.getInstance().getConfig().getTargetChunkPointNum();
        this.originTargetPageSize = TSFileDescriptor.getInstance().getConfig().getPageSizeInByte();
        this.originTargetPagePointNum = TSFileDescriptor.getInstance().getConfig().getMaxNumberOfPointsInPage();
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkSize(0x100000L);
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkPointNum(100000L);
        TSFileDescriptor.getInstance().getConfig().setPageSizeInByte(65536);
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(10000);
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        super.tearDown();
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkSize(this.originTargetChunkSize);
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkPointNum(this.originTargetChunkPointNum);
        TSFileDescriptor.getInstance().getConfig().setPageSizeInByte(this.originTargetPageSize);
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(this.originTargetPagePointNum);
    }

    @Test
    public void testSimpleCompactionByFlushChunk() throws IOException, StorageEngineException, InterruptedException, MetadataException, PageException {
        TsFileResource seqResource1 = this.generateSingleAlignedSeriesFile("d0", Arrays.asList("s0", "s1", "s2"), new TimeRange[]{new TimeRange(100000L, 200000L), new TimeRange(300000L, 500000L)}, TSEncoding.PLAIN, CompressionType.LZ4, Arrays.asList(false, false, false), true);
        this.seqResources.add(seqResource1);
        TsFileResource seqResource2 = this.generateSingleAlignedSeriesFile("d0", Arrays.asList("s0", "s1", "s2"), new TimeRange[]{new TimeRange(600000L, 700000L), new TimeRange(800000L, 900000L)}, TSEncoding.PLAIN, CompressionType.LZ4, Arrays.asList(false, false, false), true);
        this.seqResources.add(seqResource2);
        this.tsFileManager.addAll(this.seqResources, true);
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource((List)this.seqResources, (boolean)true);
        ReadChunkCompactionPerformer performer = new ReadChunkCompactionPerformer();
        CompactionTaskSummary summary = new CompactionTaskSummary();
        performer.setSummary(summary);
        performer.setSourceFiles(this.seqResources);
        performer.setTargetFiles(Collections.singletonList(targetResource));
        performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)COMPACTION_TEST_SG);
        Assert.assertEquals((long)16L, (long)summary.getDirectlyFlushChunkNum());
        Assert.assertEquals((long)0L, (long)summary.getDeserializeChunkCount());
        TsFileResourceUtils.validateTsFileDataCorrectness((TsFileResource)targetResource);
        Assert.assertEquals(CompactionCheckerUtils.readFiles(this.seqResources), CompactionCheckerUtils.readFiles(Collections.singletonList(targetResource)));
    }

    @Test
    public void testSimpleCompactionWithNullColumnByFlushChunk() throws IOException, StorageEngineException, InterruptedException, MetadataException, PageException {
        TsFileResource seqResource1 = this.generateSingleAlignedSeriesFile("d0", Arrays.asList("s0", "s1", "s2"), new TimeRange[]{new TimeRange(100000L, 200000L), new TimeRange(300000L, 500000L)}, TSEncoding.PLAIN, CompressionType.LZ4, Arrays.asList(false, false, true), true);
        this.seqResources.add(seqResource1);
        TsFileResource seqResource2 = this.generateSingleAlignedSeriesFile("d0", Arrays.asList("s0", "s1", "s2"), new TimeRange[]{new TimeRange(600000L, 700000L), new TimeRange(800000L, 900000L)}, TSEncoding.PLAIN, CompressionType.LZ4, Arrays.asList(false, false, false), true);
        this.seqResources.add(seqResource2);
        this.tsFileManager.addAll(this.seqResources, true);
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource((List)this.seqResources, (boolean)true);
        ReadChunkCompactionPerformer performer = new ReadChunkCompactionPerformer();
        CompactionTaskSummary summary = new CompactionTaskSummary();
        performer.setSummary(summary);
        performer.setSourceFiles(this.seqResources);
        performer.setTargetFiles(Collections.singletonList(targetResource));
        performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)COMPACTION_TEST_SG);
        Assert.assertEquals((long)14L, (long)summary.getDirectlyFlushChunkNum());
        Assert.assertEquals((long)0L, (long)summary.getDeserializeChunkCount());
        TsFileResourceUtils.validateTsFileDataCorrectness((TsFileResource)targetResource);
        Assert.assertEquals(CompactionCheckerUtils.readFiles(this.seqResources), CompactionCheckerUtils.readFiles(Collections.singletonList(targetResource)));
    }

    @Test
    public void testSimpleCompactionWithAllDeletedColumnByFlushChunk() throws IOException, StorageEngineException, InterruptedException, MetadataException, PageException {
        TsFileResource seqResource1 = this.generateSingleAlignedSeriesFile("d0", Arrays.asList("s0", "s1", "s2"), new TimeRange[]{new TimeRange(100000L, 200000L), new TimeRange(300000L, 500000L)}, TSEncoding.PLAIN, CompressionType.LZ4, Arrays.asList(false, false, false), true);
        this.seqResources.add(seqResource1);
        seqResource1.getModFile().write((Modification)new Deletion(new PartialPath("root.testsg.d0", "s2"), Long.MAX_VALUE, Long.MAX_VALUE));
        seqResource1.getModFile().close();
        TsFileResource seqResource2 = this.generateSingleAlignedSeriesFile("d0", Arrays.asList("s0", "s1", "s2"), new TimeRange[]{new TimeRange(600000L, 700000L), new TimeRange(800000L, 900000L)}, TSEncoding.PLAIN, CompressionType.LZ4, Arrays.asList(false, false, false), true);
        this.seqResources.add(seqResource2);
        this.tsFileManager.addAll(this.seqResources, true);
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource((List)this.seqResources, (boolean)true);
        ReadChunkCompactionPerformer performer = new ReadChunkCompactionPerformer();
        CompactionTaskSummary summary = new CompactionTaskSummary();
        performer.setSummary(summary);
        performer.setSourceFiles(this.seqResources);
        performer.setTargetFiles(Collections.singletonList(targetResource));
        performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)COMPACTION_TEST_SG);
        Assert.assertEquals((long)14L, (long)summary.getDirectlyFlushChunkNum());
        Assert.assertEquals((long)0L, (long)summary.getDeserializeChunkCount());
        TsFileResourceUtils.validateTsFileDataCorrectness((TsFileResource)targetResource);
        Assert.assertEquals(CompactionCheckerUtils.readFiles(this.seqResources), CompactionCheckerUtils.readFiles(Collections.singletonList(targetResource)));
    }

    @Test
    public void testSimpleCompactionWithNotExistColumnByFlushChunk() throws IOException, StorageEngineException, InterruptedException, MetadataException, PageException {
        TsFileResource seqResource1 = this.generateSingleAlignedSeriesFile("d0", Arrays.asList("s0", "s1"), new TimeRange[]{new TimeRange(100000L, 200000L), new TimeRange(300000L, 500000L)}, TSEncoding.PLAIN, CompressionType.LZ4, Arrays.asList(false, false, false), true);
        this.seqResources.add(seqResource1);
        seqResource1.getModFile().write((Modification)new Deletion(new PartialPath("root.testsg.d0", "s2"), Long.MAX_VALUE, Long.MAX_VALUE));
        seqResource1.getModFile().close();
        TsFileResource seqResource2 = this.generateSingleAlignedSeriesFile("d0", Arrays.asList("s0", "s1", "s2"), new TimeRange[]{new TimeRange(600000L, 700000L), new TimeRange(800000L, 900000L)}, TSEncoding.PLAIN, CompressionType.LZ4, Arrays.asList(false, false, false), true);
        this.seqResources.add(seqResource2);
        this.tsFileManager.addAll(this.seqResources, true);
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource((List)this.seqResources, (boolean)true);
        ReadChunkCompactionPerformer performer = new ReadChunkCompactionPerformer();
        CompactionTaskSummary summary = new CompactionTaskSummary();
        performer.setSummary(summary);
        performer.setSourceFiles(this.seqResources);
        performer.setTargetFiles(Collections.singletonList(targetResource));
        performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)COMPACTION_TEST_SG);
        Assert.assertEquals((long)14L, (long)summary.getDirectlyFlushChunkNum());
        Assert.assertEquals((long)0L, (long)summary.getDeserializeChunkCount());
        TsFileResourceUtils.validateTsFileDataCorrectness((TsFileResource)targetResource);
        Assert.assertEquals(CompactionCheckerUtils.readFiles(this.seqResources), CompactionCheckerUtils.readFiles(Collections.singletonList(targetResource)));
    }

    @Test
    public void testSimpleCompactionWithNullColumn() throws IOException, StorageEngineException, InterruptedException, MetadataException, PageException {
        TsFileResource seqResource1 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqResource1);){
            writer.startChunkGroup("d0");
            writer.generateSimpleAlignedSeriesToCurrentDeviceWithNullValue(Arrays.asList("s0", "s1", "s2"), new TimeRange[]{new TimeRange(100000L, 200000L)}, TSEncoding.PLAIN, CompressionType.LZ4, Arrays.asList(false, false, true));
            writer.generateSimpleAlignedSeriesToCurrentDeviceWithNullValue(Arrays.asList("s0", "s1", "s2"), new TimeRange[]{new TimeRange(300000L, 500000L)}, TSEncoding.PLAIN, CompressionType.LZ4, Arrays.asList(false, false, false));
            writer.endChunkGroup();
            writer.endFile();
        }
        this.seqResources.add(seqResource1);
        TsFileResource seqResource2 = this.generateSingleAlignedSeriesFile("d0", Arrays.asList("s0", "s1"), new TimeRange[]{new TimeRange(600000L, 700000L), new TimeRange(800000L, 900000L)}, TSEncoding.PLAIN, CompressionType.LZ4, Arrays.asList(false, false), true);
        this.seqResources.add(seqResource2);
        this.tsFileManager.addAll(this.seqResources, true);
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource((List)this.seqResources, (boolean)true);
        ReadChunkCompactionPerformer performer = new ReadChunkCompactionPerformer();
        CompactionTaskSummary summary = new CompactionTaskSummary();
        performer.setSummary(summary);
        performer.setSourceFiles(this.seqResources);
        performer.setTargetFiles(Collections.singletonList(targetResource));
        performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)COMPACTION_TEST_SG);
        TsFileResourceUtils.validateTsFileDataCorrectness((TsFileResource)targetResource);
        Assert.assertEquals(CompactionCheckerUtils.readFiles(this.seqResources), CompactionCheckerUtils.readFiles(Collections.singletonList(targetResource)));
    }

    @Test
    public void testSimpleCompactionWithPartialDeletedColumnByFlushChunk() throws IOException, StorageEngineException, InterruptedException, MetadataException, PageException {
        TsFileResource seqResource1 = this.generateSingleAlignedSeriesFile("d0", Arrays.asList("s0", "s1", "s2"), new TimeRange[]{new TimeRange(100000L, 200000L), new TimeRange(300000L, 500000L)}, TSEncoding.PLAIN, CompressionType.LZ4, Arrays.asList(false, false, false), true);
        this.seqResources.add(seqResource1);
        seqResource1.getModFile().write((Modification)new Deletion(new PartialPath("root.testsg.d0", "s2"), Long.MAX_VALUE, 250000L));
        seqResource1.getModFile().close();
        TsFileResource seqResource2 = this.generateSingleAlignedSeriesFile("d0", Arrays.asList("s0", "s1", "s2"), new TimeRange[]{new TimeRange(600000L, 700000L), new TimeRange(800000L, 900000L)}, TSEncoding.PLAIN, CompressionType.LZ4, Arrays.asList(false, false, false), true);
        this.seqResources.add(seqResource2);
        this.tsFileManager.addAll(this.seqResources, true);
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource((List)this.seqResources, (boolean)true);
        ReadChunkCompactionPerformer performer = new ReadChunkCompactionPerformer();
        CompactionTaskSummary summary = new CompactionTaskSummary();
        performer.setSummary(summary);
        performer.setSourceFiles(this.seqResources);
        performer.setTargetFiles(Collections.singletonList(targetResource));
        performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)COMPACTION_TEST_SG);
        Assert.assertEquals((long)15L, (long)summary.getDirectlyFlushChunkNum());
        Assert.assertEquals((long)0L, (long)summary.getDeserializeChunkCount());
        TsFileResourceUtils.validateTsFileDataCorrectness((TsFileResource)targetResource);
        Assert.assertEquals(CompactionCheckerUtils.readFiles(this.seqResources), CompactionCheckerUtils.readFiles(Collections.singletonList(targetResource)));
    }

    @Test
    public void testSimpleCompactionWithAllDeletedPageByFlushPage() throws Exception {
        TsFileResource seqResource1 = this.generateSingleAlignedSeriesFile("d0", Arrays.asList("s0", "s1", "s2"), new TimeRange[][]{{new TimeRange(10000L, 20000L), new TimeRange(30000L, 50000L)}}, TSEncoding.RLE, CompressionType.LZ4, Arrays.asList(false, false, false), true);
        this.seqResources.add(seqResource1);
        seqResource1.getModFile().write((Modification)new Deletion(new PartialPath("root.testsg.d0", "s2"), Long.MAX_VALUE, 25000L));
        seqResource1.getModFile().close();
        TsFileResource seqResource2 = this.generateSingleAlignedSeriesFile("d0", Arrays.asList("s0", "s1", "s2"), new TimeRange[][]{{new TimeRange(60000L, 70000L), new TimeRange(80000L, 90000L)}}, TSEncoding.RLE, CompressionType.LZ4, Arrays.asList(false, false, false), true);
        this.seqResources.add(seqResource2);
        this.tsFileManager.addAll(this.seqResources, true);
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource((List)this.seqResources, (boolean)true);
        ReadChunkCompactionPerformer performer = new ReadChunkCompactionPerformer();
        CompactionTaskSummary summary = new CompactionTaskSummary();
        performer.setSummary(summary);
        performer.setSourceFiles(this.seqResources);
        performer.setTargetFiles(Collections.singletonList(targetResource));
        performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)COMPACTION_TEST_SG);
        Assert.assertEquals((long)0L, (long)summary.getDirectlyFlushChunkNum());
        Assert.assertEquals((long)8L, (long)summary.getDeserializeChunkCount());
        Assert.assertEquals((long)15L, (long)summary.getDirectlyFlushPageCount());
        TsFileResourceUtils.validateTsFileDataCorrectness((TsFileResource)targetResource);
    }

    @Test
    public void testSimpleCompactionWithPartialDeletedPageByWritePoint() throws IOException, MetadataException, StorageEngineException, InterruptedException, PageException {
        TsFileResource seqResource1 = this.generateSingleAlignedSeriesFile("d0", Arrays.asList("s0", "s1", "s2"), new TimeRange[][]{{new TimeRange(10000L, 20000L), new TimeRange(30000L, 50000L)}}, TSEncoding.RLE, CompressionType.LZ4, Arrays.asList(false, false, false), true);
        this.seqResources.add(seqResource1);
        seqResource1.getModFile().write((Modification)new Deletion(new PartialPath("root.testsg.d0", "s2"), Long.MAX_VALUE, 15000L));
        seqResource1.getModFile().close();
        TsFileResource seqResource2 = this.generateSingleAlignedSeriesFile("d0", Arrays.asList("s0", "s1", "s2"), new TimeRange[][]{{new TimeRange(60000L, 70000L), new TimeRange(80000L, 90000L)}}, TSEncoding.RLE, CompressionType.LZ4, Arrays.asList(false, false, false), true);
        this.seqResources.add(seqResource2);
        this.tsFileManager.addAll(this.seqResources, true);
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource((List)this.seqResources, (boolean)true);
        ReadChunkCompactionPerformer performer = new ReadChunkCompactionPerformer();
        CompactionTaskSummary summary = new CompactionTaskSummary();
        performer.setSummary(summary);
        performer.setSourceFiles(this.seqResources);
        performer.setTargetFiles(Collections.singletonList(targetResource));
        performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)COMPACTION_TEST_SG);
        Assert.assertTrue((summary.getDeserializePageCount() > 0 ? 1 : 0) != 0);
        TsFileResourceUtils.validateTsFileDataCorrectness((TsFileResource)targetResource);
        Assert.assertEquals(CompactionCheckerUtils.readFiles(this.seqResources), CompactionCheckerUtils.readFiles(Collections.singletonList(targetResource)));
    }

    @Test
    public void testSimpleCompactionByFlushPage() throws IOException, StorageEngineException, InterruptedException, MetadataException, PageException {
        TsFileResource seqResource1 = this.generateSingleAlignedSeriesFile("d0", Arrays.asList("s0", "s1", "s2"), new TimeRange[]{new TimeRange(10000L, 20000L), new TimeRange(30000L, 40000L)}, TSEncoding.PLAIN, CompressionType.LZ4, Arrays.asList(false, false, false), true);
        this.seqResources.add(seqResource1);
        TsFileResource seqResource2 = this.generateSingleAlignedSeriesFile("d0", Arrays.asList("s0", "s1", "s2"), new TimeRange[]{new TimeRange(60000L, 70000L), new TimeRange(80000L, 90000L)}, TSEncoding.PLAIN, CompressionType.LZ4, Arrays.asList(false, false, false), true);
        this.seqResources.add(seqResource2);
        this.tsFileManager.addAll(this.seqResources, true);
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource((List)this.seqResources, (boolean)true);
        ReadChunkCompactionPerformer performer = new ReadChunkCompactionPerformer();
        CompactionTaskSummary summary = new CompactionTaskSummary();
        performer.setSummary(summary);
        performer.setSourceFiles(this.seqResources);
        performer.setTargetFiles(Collections.singletonList(targetResource));
        performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)COMPACTION_TEST_SG);
        Assert.assertEquals((long)16L, (long)summary.getDeserializeChunkCount());
        Assert.assertEquals((long)16L, (long)summary.getDirectlyFlushPageCount());
        TsFileResourceUtils.validateTsFileDataCorrectness((TsFileResource)targetResource);
        Assert.assertEquals(CompactionCheckerUtils.readFiles(this.seqResources), CompactionCheckerUtils.readFiles(Collections.singletonList(targetResource)));
    }

    @Test
    public void testSimpleCompactionByWritePoint() throws IOException, StorageEngineException, InterruptedException, MetadataException, PageException {
        TsFileResource seqResource1 = this.generateSingleAlignedSeriesFile("d0", Arrays.asList("s0", "s1", "s2"), new TimeRange[]{new TimeRange(1000L, 2000L), new TimeRange(3000L, 4000L)}, TSEncoding.PLAIN, CompressionType.LZ4, Arrays.asList(false, false, false), true);
        this.seqResources.add(seqResource1);
        TsFileResource seqResource2 = this.generateSingleAlignedSeriesFile("d0", Arrays.asList("s0", "s1", "s2"), new TimeRange[]{new TimeRange(6000L, 7000L), new TimeRange(8000L, 9000L)}, TSEncoding.PLAIN, CompressionType.LZ4, Arrays.asList(false, false, false), true);
        this.seqResources.add(seqResource2);
        this.tsFileManager.addAll(this.seqResources, true);
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource((List)this.seqResources, (boolean)true);
        ReadChunkCompactionPerformer performer = new ReadChunkCompactionPerformer();
        CompactionTaskSummary summary = new CompactionTaskSummary();
        performer.setSummary(summary);
        performer.setSourceFiles(this.seqResources);
        performer.setTargetFiles(Collections.singletonList(targetResource));
        performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)COMPACTION_TEST_SG);
        Assert.assertEquals((long)16L, (long)summary.getDeserializeChunkCount());
        Assert.assertEquals((long)16L, (long)summary.getDeserializePageCount());
        TsFileResourceUtils.validateTsFileDataCorrectness((TsFileResource)targetResource);
        Assert.assertEquals(CompactionCheckerUtils.readFiles(this.seqResources), CompactionCheckerUtils.readFiles(Collections.singletonList(targetResource)));
    }

    @Test
    public void testCompactionWithDifferentCompressionTypeOrEncoding() throws IOException, StorageEngineException, InterruptedException, MetadataException, PageException {
        TsFileResource seqResource1 = this.generateSingleAlignedSeriesFile("d0", Arrays.asList("s0", "s1", "s2"), new TimeRange[]{new TimeRange(100000L, 200000L), new TimeRange(300000L, 500000L)}, TSEncoding.PLAIN, CompressionType.LZ4, Arrays.asList(false, false, false), true);
        this.seqResources.add(seqResource1);
        TsFileResource seqResource2 = this.generateSingleAlignedSeriesFile("d0", Arrays.asList("s0", "s1", "s2"), new TimeRange[]{new TimeRange(600000L, 700000L), new TimeRange(800000L, 900000L)}, TSEncoding.PLAIN, CompressionType.SNAPPY, Arrays.asList(false, false, false), true);
        this.seqResources.add(seqResource2);
        TsFileResource seqResource3 = this.generateSingleAlignedSeriesFile("d0", Arrays.asList("s0", "s1", "s2"), new TimeRange[]{new TimeRange(1600000L, 1700000L), new TimeRange(1800000L, 1900000L)}, TSEncoding.PLAIN, CompressionType.SNAPPY, Arrays.asList(false, false, false), true);
        this.seqResources.add(seqResource3);
        this.tsFileManager.addAll(this.seqResources, true);
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource((List)this.seqResources, (boolean)true);
        ReadChunkCompactionPerformer performer = new ReadChunkCompactionPerformer();
        CompactionTaskSummary summary = new CompactionTaskSummary();
        performer.setSummary(summary);
        performer.setSourceFiles(this.seqResources);
        performer.setTargetFiles(Collections.singletonList(targetResource));
        performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)COMPACTION_TEST_SG);
        Assert.assertEquals((long)16L, (long)summary.getDirectlyFlushChunkNum());
        Assert.assertEquals((long)0L, (long)summary.getDirectlyFlushPageCount());
        TsFileResourceUtils.validateTsFileDataCorrectness((TsFileResource)targetResource);
        Assert.assertEquals(CompactionCheckerUtils.readFiles(this.seqResources), CompactionCheckerUtils.readFiles(Collections.singletonList(targetResource)));
    }

    @Test
    public void testFlushChunkMetadataToTempFile() throws IOException, StorageEngineException, InterruptedException, MetadataException, PageException {
        ArrayList<String> devices = new ArrayList<String>();
        for (int i = 0; i < 1000; ++i) {
            devices.add("d" + i);
        }
        TsFileResource seqResource1 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqResource1);){
            for (String string : devices) {
                writer.startChunkGroup(string);
                writer.generateSimpleAlignedSeriesToCurrentDevice(Arrays.asList("s0", "s1", "s2"), new TimeRange[]{new TimeRange(1000L, 2000L), new TimeRange(3000L, 5000L)}, TSEncoding.PLAIN, CompressionType.LZ4);
                writer.endChunkGroup();
            }
            writer.endFile();
        }
        this.seqResources.add(seqResource1);
        TsFileResource seqResource2 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqResource2);){
            for (String string : devices) {
                writer.startChunkGroup(string);
                writer.generateSimpleAlignedSeriesToCurrentDevice(Arrays.asList("s0", "s1", "s2"), new TimeRange[]{new TimeRange(6000L, 7000L), new TimeRange(8000L, 9000L)}, TSEncoding.PLAIN, CompressionType.LZ4);
                writer.endChunkGroup();
            }
            writer.endFile();
        }
        this.seqResources.add(seqResource2);
        TsFileResource seqResource3 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter compactionTestFileWriter = new CompactionTestFileWriter(seqResource3);){
            for (String device : devices) {
                compactionTestFileWriter.startChunkGroup(device);
                compactionTestFileWriter.generateSimpleAlignedSeriesToCurrentDevice(Arrays.asList("s0", "s1", "s2"), new TimeRange[]{new TimeRange(16000L, 17000L), new TimeRange(18000L, 19000L)}, TSEncoding.PLAIN, CompressionType.LZ4);
                compactionTestFileWriter.endChunkGroup();
            }
            compactionTestFileWriter.endFile();
        }
        this.seqResources.add(seqResource3);
        this.tsFileManager.addAll(this.seqResources, true);
        TsFileResource tsFileResource = TsFileNameGenerator.getInnerCompactionTargetFileResource((List)this.seqResources, (boolean)true);
        ReadChunkCompactionPerformer readChunkCompactionPerformer = new ReadChunkCompactionPerformer();
        CompactionTaskSummary summary = new CompactionTaskSummary();
        readChunkCompactionPerformer.setSummary(summary);
        readChunkCompactionPerformer.setSourceFiles(this.seqResources);
        readChunkCompactionPerformer.setTargetFiles(Collections.singletonList(tsFileResource));
        readChunkCompactionPerformer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(tsFileResource), (boolean)true, (String)COMPACTION_TEST_SG);
        TsFileResourceUtils.validateTsFileDataCorrectness((TsFileResource)tsFileResource);
        Assert.assertEquals(CompactionCheckerUtils.readFiles(this.seqResources), CompactionCheckerUtils.readFiles(Collections.singletonList(tsFileResource)));
        Assert.assertEquals((long)devices.size(), (long)tsFileResource.buildDeviceTimeIndex().getDevices().size());
    }

    private TsFileResource generateSingleAlignedSeriesFile(String device, List<String> measurement, TimeRange[] chunkTimeRanges, TSEncoding encoding, CompressionType compressionType, List<Boolean> nullValues, boolean isSeq) throws IOException {
        TsFileResource seqResource1 = this.createEmptyFileAndResource(isSeq);
        CompactionTestFileWriter writer1 = new CompactionTestFileWriter(seqResource1);
        writer1.startChunkGroup(device);
        writer1.generateSimpleAlignedSeriesToCurrentDeviceWithNullValue(measurement, chunkTimeRanges, encoding, compressionType, nullValues);
        writer1.endChunkGroup();
        writer1.endFile();
        writer1.close();
        return seqResource1;
    }

    private TsFileResource generateSingleAlignedSeriesFile(String device, List<String> measurement, TimeRange[][] chunkTimeRanges, TSEncoding encoding, CompressionType compressionType, List<Boolean> nullValues, boolean isSeq) throws IOException {
        TsFileResource seqResource1 = this.createEmptyFileAndResource(isSeq);
        CompactionTestFileWriter writer1 = new CompactionTestFileWriter(seqResource1);
        writer1.startChunkGroup(device);
        writer1.generateSimpleAlignedSeriesToCurrentDeviceWithNullValue(measurement, chunkTimeRanges, encoding, compressionType, nullValues);
        writer1.endChunkGroup();
        writer1.endFile();
        writer1.close();
        return seqResource1;
    }

    private TsFileResource generateSingleAlignedSeriesFile(String device, List<String> measurement, TimeRange[][][] chunkTimeRanges, TSEncoding encoding, CompressionType compressionType, List<Boolean> nullValues, boolean isSeq) throws IOException {
        TsFileResource seqResource1 = this.createEmptyFileAndResource(isSeq);
        CompactionTestFileWriter writer1 = new CompactionTestFileWriter(seqResource1);
        writer1.startChunkGroup(device);
        writer1.generateSimpleAlignedSeriesToCurrentDeviceWithNullValue(measurement, chunkTimeRanges, encoding, compressionType, nullValues);
        writer1.endChunkGroup();
        writer1.endFile();
        writer1.close();
        return seqResource1;
    }
}

