/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.inner;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.storageengine.buffer.BloomFilterCache;
import org.apache.iotdb.db.storageengine.buffer.ChunkCache;
import org.apache.iotdb.db.storageengine.buffer.TimeSeriesMetadataCache;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.ReadPointCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.CompactionCheckerUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.CompactionClearUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.CompactionConfigRestorer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.CompactionFileGeneratorUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.CompactionOverlapType;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.CompactionTimeseriesType;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.Pair;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InnerUnseqCompactionWithReadPointPerformerTest {
    private static final Logger LOG = LoggerFactory.getLogger(InnerUnseqCompactionWithReadPointPerformerTest.class);
    static final String COMPACTION_TEST_SG = "root.compactionTest";
    static final String[] fullPaths = new String[]{"root.compactionTest.device0.sensor0", "root.compactionTest.device0.sensor1", "root.compactionTest.device0.sensor2", "root.compactionTest.device0.sensor3", "root.compactionTest.device0.sensor4", "root.compactionTest.device0.sensor5", "root.compactionTest.device0.sensor6", "root.compactionTest.device0.sensor7", "root.compactionTest.device0.sensor8", "root.compactionTest.device0.sensor9", "root.compactionTest.device1.sensor0", "root.compactionTest.device1.sensor1", "root.compactionTest.device1.sensor2", "root.compactionTest.device1.sensor3", "root.compactionTest.device1.sensor4"};
    static final int[] toMergeFileNums = new int[]{2, 3};
    static final CompactionTimeseriesType[] compactionTimeseriesTypes = new CompactionTimeseriesType[]{CompactionTimeseriesType.ALL_SAME, CompactionTimeseriesType.PART_SAME, CompactionTimeseriesType.NO_SAME};
    static final boolean[] compactionBeforeHasMods = new boolean[]{true, false};
    static final boolean[] compactionHasMods = new boolean[]{true, false};
    static final CompactionOverlapType[] compactionOverlapTypes = new CompactionOverlapType[]{CompactionOverlapType.FILE_NO_OVERLAP, CompactionOverlapType.FILE_OVERLAP_CHUNK_NO_OVERLAP, CompactionOverlapType.CHUNK_OVERLAP_PAGE_NO_OVERLAP, CompactionOverlapType.PAGE_OVERLAP};
    static final String oldThreadName = Thread.currentThread().getName();

    @Before
    public void setUp() throws MetadataException {
        Thread.currentThread().setName("pool-1-IoTDB-Compaction-Worker-1");
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws IOException, StorageEngineException {
        new CompactionConfigRestorer().restoreCompactionConfig();
        EnvironmentUtils.cleanEnv();
        CompactionClearUtils.clearAllCompactionFiles();
        ChunkCache.getInstance().clear();
        TimeSeriesMetadataCache.getInstance().clear();
        BloomFilterCache.getInstance().clear();
        EnvironmentUtils.cleanAllDir();
        Thread.currentThread().setName(oldThreadName);
        CompactionClearUtils.deleteEmptyDir(new File("target"));
    }

    @Test
    public void test() throws Exception {
        for (int toMergeFileNum : toMergeFileNums) {
            for (CompactionTimeseriesType compactionTimeseriesType : compactionTimeseriesTypes) {
                for (boolean compactionBeforeHasMod : compactionBeforeHasMods) {
                    for (boolean compactionHasMod : compactionHasMods) {
                        for (CompactionOverlapType compactionOverlapType : compactionOverlapTypes) {
                            ArrayList<TsFileResource> toMergeResources = new ArrayList<TsFileResource>();
                            for (int i = 0; i < toMergeFileNum; ++i) {
                                HashSet<String> fullPath = new HashSet<String>();
                                if (compactionTimeseriesType == CompactionTimeseriesType.ALL_SAME) {
                                    fullPath.add(fullPaths[0]);
                                    fullPath.add(fullPaths[1]);
                                    fullPath.add(fullPaths[2]);
                                } else if (compactionTimeseriesType == CompactionTimeseriesType.PART_SAME) {
                                    if (i == 0) {
                                        fullPath.add(fullPaths[0]);
                                        fullPath.add(fullPaths[1]);
                                        fullPath.add(fullPaths[2]);
                                    } else if (i == 1) {
                                        fullPath.add(fullPaths[1]);
                                        fullPath.add(fullPaths[2]);
                                        fullPath.add(fullPaths[3]);
                                    } else {
                                        fullPath.add(fullPaths[2]);
                                        fullPath.add(fullPaths[3]);
                                        fullPath.add(fullPaths[4]);
                                    }
                                } else if (i == 0) {
                                    fullPath.add(fullPaths[0]);
                                    fullPath.add(fullPaths[1]);
                                    fullPath.add(fullPaths[2]);
                                } else if (i == 1) {
                                    fullPath.add(fullPaths[3]);
                                    fullPath.add(fullPaths[4]);
                                    fullPath.add(fullPaths[5]);
                                } else {
                                    fullPath.add(fullPaths[6]);
                                    fullPath.add(fullPaths[7]);
                                    fullPath.add(fullPaths[8]);
                                }
                                TsFileResource tsFileResource = null;
                                switch (compactionOverlapType) {
                                    case FILE_NO_OVERLAP: {
                                        ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                                        ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                                        pagePointsNum.add(100L);
                                        chunkPagePointsNum.add(pagePointsNum);
                                        pagePointsNum = new ArrayList();
                                        pagePointsNum.add(200L);
                                        chunkPagePointsNum.add(pagePointsNum);
                                        pagePointsNum = new ArrayList();
                                        pagePointsNum.add(300L);
                                        chunkPagePointsNum.add(pagePointsNum);
                                        tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(false, i + 1, COMPACTION_TEST_SG);
                                        CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, (long)i * 600L, tsFileResource);
                                        break;
                                    }
                                    case FILE_OVERLAP_CHUNK_NO_OVERLAP: {
                                        ArrayList<long[][]> pagePointsRange;
                                        ArrayList<List<long[][]>> chunkPagePointsRange;
                                        if (i == 0) {
                                            chunkPagePointsRange = new ArrayList<List<long[][]>>();
                                            pagePointsRange = new ArrayList<long[][]>();
                                            pagePointsRange.add(new long[][]{{0L, 100L}});
                                            pagePointsRange.add(new long[][]{{100L, 300L}});
                                            pagePointsRange.add(new long[][]{{300L, 600L}});
                                            chunkPagePointsRange.add(pagePointsRange);
                                            pagePointsRange = new ArrayList();
                                            pagePointsRange.add(new long[][]{{0L, 100L}});
                                            pagePointsRange.add(new long[][]{{100L, 300L}});
                                            pagePointsRange.add(new long[][]{{300L, 600L}});
                                            chunkPagePointsRange.add(pagePointsRange);
                                            pagePointsRange = new ArrayList();
                                            pagePointsRange.add(new long[][]{{0L, 100L}});
                                            pagePointsRange.add(new long[][]{{100L, 300L}});
                                            pagePointsRange.add(new long[][]{{300L, 600L}});
                                            chunkPagePointsRange.add(pagePointsRange);
                                            fullPath.add(fullPaths[10]);
                                            pagePointsRange = new ArrayList();
                                            pagePointsRange.add(new long[][]{{0L, 1000L}});
                                            chunkPagePointsRange.add(pagePointsRange);
                                            tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(false, i + 1, COMPACTION_TEST_SG);
                                            CompactionFileGeneratorUtils.writeChunkToTsFileWithTimeRange(fullPath, chunkPagePointsRange, tsFileResource);
                                            break;
                                        }
                                        ArrayList<List<Long>> chunkPagePointsNum = new ArrayList();
                                        ArrayList<Long> pagePointsNum = new ArrayList();
                                        pagePointsNum.add(100L);
                                        chunkPagePointsNum.add(pagePointsNum);
                                        pagePointsNum = new ArrayList();
                                        pagePointsNum.add(200L);
                                        chunkPagePointsNum.add(pagePointsNum);
                                        pagePointsNum = new ArrayList();
                                        pagePointsNum.add(300L);
                                        chunkPagePointsNum.add(pagePointsNum);
                                        tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(false, i + 1, COMPACTION_TEST_SG);
                                        CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, (long)i * 600L, tsFileResource);
                                        break;
                                    }
                                    case CHUNK_OVERLAP_PAGE_NO_OVERLAP: {
                                        ArrayList<long[][]> pagePointsRange;
                                        ArrayList<List<long[][]>> chunkPagePointsRange;
                                        if (i == 0) {
                                            chunkPagePointsRange = new ArrayList();
                                            pagePointsRange = new ArrayList();
                                            pagePointsRange.add(new long[][]{{0L, 100L}});
                                            pagePointsRange.add(new long[][]{{100L, 300L}});
                                            pagePointsRange.add(new long[][]{{300L, 600L}});
                                            chunkPagePointsRange.add(pagePointsRange);
                                            pagePointsRange = new ArrayList();
                                            pagePointsRange.add(new long[][]{{0L, 100L}});
                                            pagePointsRange.add(new long[][]{{100L, 300L}});
                                            pagePointsRange.add(new long[][]{{300L, 600L}});
                                            chunkPagePointsRange.add(pagePointsRange);
                                            pagePointsRange = new ArrayList();
                                            pagePointsRange.add(new long[][]{{0L, 100L}});
                                            pagePointsRange.add(new long[][]{{100L, 300L}});
                                            pagePointsRange.add(new long[][]{{300L, 600L}, {1800L, 3600L}});
                                            chunkPagePointsRange.add(pagePointsRange);
                                            tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(false, i + 1, COMPACTION_TEST_SG);
                                            CompactionFileGeneratorUtils.writeChunkToTsFileWithTimeRange(fullPath, chunkPagePointsRange, tsFileResource);
                                            break;
                                        }
                                        ArrayList<List<Long>> chunkPagePointsNum = new ArrayList();
                                        ArrayList<Long> pagePointsNum = new ArrayList();
                                        pagePointsNum.add(100L);
                                        chunkPagePointsNum.add(pagePointsNum);
                                        pagePointsNum = new ArrayList();
                                        pagePointsNum.add(200L);
                                        chunkPagePointsNum.add(pagePointsNum);
                                        pagePointsNum = new ArrayList();
                                        pagePointsNum.add(300L);
                                        chunkPagePointsNum.add(pagePointsNum);
                                        tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(false, i + 1, COMPACTION_TEST_SG);
                                        CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, (long)i * 600L, tsFileResource);
                                        break;
                                    }
                                    case PAGE_OVERLAP: {
                                        ArrayList<Long> pagePointsNum;
                                        ArrayList<List<Long>> chunkPagePointsNum;
                                        if (i == 1) {
                                            chunkPagePointsNum = new ArrayList();
                                            pagePointsNum = new ArrayList();
                                            pagePointsNum.add(100L);
                                            chunkPagePointsNum.add(pagePointsNum);
                                            pagePointsNum = new ArrayList();
                                            pagePointsNum.add(200L);
                                            chunkPagePointsNum.add(pagePointsNum);
                                            pagePointsNum = new ArrayList();
                                            pagePointsNum.add(300L);
                                            chunkPagePointsNum.add(pagePointsNum);
                                            tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(false, i + 1, COMPACTION_TEST_SG);
                                            CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 50L, tsFileResource);
                                            break;
                                        }
                                        chunkPagePointsNum = new ArrayList();
                                        pagePointsNum = new ArrayList();
                                        pagePointsNum.add(100L);
                                        chunkPagePointsNum.add(pagePointsNum);
                                        pagePointsNum = new ArrayList();
                                        pagePointsNum.add(200L);
                                        chunkPagePointsNum.add(pagePointsNum);
                                        pagePointsNum = new ArrayList();
                                        pagePointsNum.add(300L);
                                        chunkPagePointsNum.add(pagePointsNum);
                                        tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(false, i + 1, COMPACTION_TEST_SG);
                                        CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, (long)i * 600L, tsFileResource);
                                    }
                                }
                                toMergeResources.add(tsFileResource);
                                if (!compactionBeforeHasMod) continue;
                                HashMap<String, Pair<Long, Long>> toDeleteTimeseriesAndTime = new HashMap<String, Pair<Long, Long>>();
                                if (compactionTimeseriesType == CompactionTimeseriesType.ALL_SAME) {
                                    toDeleteTimeseriesAndTime.put(fullPaths[i], new Pair((Object)((long)i * 600L + 250L), (Object)((long)i * 600L + 300L)));
                                } else if (compactionTimeseriesType == CompactionTimeseriesType.PART_SAME) {
                                    if (i == 0) {
                                        toDeleteTimeseriesAndTime.put(fullPaths[0], new Pair((Object)250L, (Object)300L));
                                    } else if (i == 1) {
                                        toDeleteTimeseriesAndTime.put(fullPaths[3], (Pair<Long, Long>)new Pair((Object)((long)i * 600L + 250L), (Object)((long)i * 600L + 300L)));
                                    } else {
                                        toDeleteTimeseriesAndTime.put(fullPaths[4], (Pair<Long, Long>)new Pair((Object)((long)i * 600L + 250L), (Object)((long)i * 600L + 300L)));
                                    }
                                } else if (i == 0) {
                                    toDeleteTimeseriesAndTime.put(fullPaths[2], new Pair((Object)250L, (Object)300L));
                                } else if (i == 1) {
                                    toDeleteTimeseriesAndTime.put(fullPaths[5], (Pair<Long, Long>)new Pair((Object)((long)i * 600L + 250L), (Object)((long)i * 600L + 300L)));
                                } else {
                                    toDeleteTimeseriesAndTime.put(fullPaths[8], (Pair<Long, Long>)new Pair((Object)((long)i * 600L + 250L), (Object)((long)i * 600L + 300L)));
                                }
                                CompactionFileGeneratorUtils.generateMods(toDeleteTimeseriesAndTime, tsFileResource, false);
                            }
                            LOG.error("{} {} {} {} {}", new Object[]{toMergeFileNum, compactionTimeseriesType, compactionBeforeHasMod, compactionHasMod, compactionOverlapType});
                            TsFileResource targetTsFileResource = CompactionFileGeneratorUtils.getInnerCompactionTargetTsFileResources(toMergeResources, false).get(0);
                            Map<String, List<TimeValuePair>> sourceData = CompactionCheckerUtils.readFiles(toMergeResources);
                            if (compactionHasMod) {
                                HashMap<String, Pair<Long, Long>> toDeleteTimeseriesAndTime = new HashMap<String, Pair<Long, Long>>();
                                toDeleteTimeseriesAndTime.put(fullPaths[1], new Pair((Object)250L, (Object)300L));
                                CompactionFileGeneratorUtils.generateMods(toDeleteTimeseriesAndTime, (TsFileResource)toMergeResources.get(0), true);
                                List<TimeValuePair> timeValuePairs = sourceData.get(fullPaths[1]);
                                timeValuePairs.removeIf(timeValuePair -> timeValuePair.getTimestamp() >= 250L && timeValuePair.getTimestamp() <= 300L);
                            }
                            ReadPointCompactionPerformer performer = new ReadPointCompactionPerformer(Collections.emptyList(), toMergeResources, Collections.singletonList(targetTsFileResource));
                            performer.setSummary(new CompactionTaskSummary());
                            performer.perform();
                            CompactionUtils.moveTargetFile(Collections.singletonList(targetTsFileResource), (boolean)true, (String)COMPACTION_TEST_SG);
                            CompactionUtils.combineModsInInnerCompaction(toMergeResources, (TsFileResource)targetTsFileResource);
                            ArrayList<TsFileResource> targetTsFileResources = new ArrayList<TsFileResource>();
                            targetTsFileResources.add(targetTsFileResource);
                            CompactionCheckerUtils.checkDataAndResource(sourceData, targetTsFileResources);
                            HashMap<String, List<List<Long>>> chunkPagePointsNumMerged = new HashMap<String, List<List<Long>>>();
                            if (compactionTimeseriesType == CompactionTimeseriesType.ALL_SAME) {
                                if (toMergeFileNum == 2) {
                                    if (compactionBeforeHasMod) {
                                        switch (compactionOverlapType) {
                                            case FILE_NO_OVERLAP: {
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 1149L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 1149L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 1200L);
                                                break;
                                            }
                                            case FILE_OVERLAP_CHUNK_NO_OVERLAP: {
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 1149L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 1149L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 1200L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[10], 1000L);
                                                break;
                                            }
                                            case CHUNK_OVERLAP_PAGE_NO_OVERLAP: {
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 1149L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 1149L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 3000L);
                                                break;
                                            }
                                            case PAGE_OVERLAP: {
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 650L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 650L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 650L);
                                            }
                                        }
                                    } else {
                                        switch (compactionOverlapType) {
                                            case FILE_NO_OVERLAP: {
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 1200L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 1200L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 1200L);
                                                break;
                                            }
                                            case FILE_OVERLAP_CHUNK_NO_OVERLAP: {
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 1200L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 1200L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 1200L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[10], 1000L);
                                                break;
                                            }
                                            case CHUNK_OVERLAP_PAGE_NO_OVERLAP: {
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 1200L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 1200L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 3000L);
                                                break;
                                            }
                                            case PAGE_OVERLAP: {
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 650L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 650L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 650L);
                                            }
                                        }
                                    }
                                } else if (toMergeFileNum == 3) {
                                    if (compactionBeforeHasMod) {
                                        switch (compactionOverlapType) {
                                            case FILE_NO_OVERLAP: {
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 1749L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 1749L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 1749L);
                                                break;
                                            }
                                            case FILE_OVERLAP_CHUNK_NO_OVERLAP: {
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 1749L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 1749L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 1749L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[10], 1000L);
                                                break;
                                            }
                                            case CHUNK_OVERLAP_PAGE_NO_OVERLAP: {
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 1749L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 1749L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 3549L);
                                                break;
                                            }
                                            case PAGE_OVERLAP: {
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 1250L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 1250L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 1199L);
                                            }
                                        }
                                    } else {
                                        switch (compactionOverlapType) {
                                            case FILE_NO_OVERLAP: {
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 1800L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 1800L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 1800L);
                                                break;
                                            }
                                            case FILE_OVERLAP_CHUNK_NO_OVERLAP: {
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 1800L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 1800L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 1800L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[10], 1000L);
                                                break;
                                            }
                                            case CHUNK_OVERLAP_PAGE_NO_OVERLAP: {
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 1800L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 1800L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 3600L);
                                                break;
                                            }
                                            case PAGE_OVERLAP: {
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 1250L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 1250L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 1250L);
                                            }
                                        }
                                    }
                                }
                            } else if (compactionTimeseriesType == CompactionTimeseriesType.PART_SAME) {
                                if (toMergeFileNum == 2) {
                                    if (compactionBeforeHasMod) {
                                        switch (compactionOverlapType) {
                                            case FILE_NO_OVERLAP: {
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 549L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 1200L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 1200L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[3], 549L);
                                                break;
                                            }
                                            case FILE_OVERLAP_CHUNK_NO_OVERLAP: {
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 549L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 1200L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 1200L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[3], 549L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[10], 1000L);
                                                break;
                                            }
                                            case CHUNK_OVERLAP_PAGE_NO_OVERLAP: {
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 549L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 1200L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 3000L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[3], 549L);
                                                break;
                                            }
                                            case PAGE_OVERLAP: {
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 549L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 650L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 650L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[3], 600L);
                                            }
                                        }
                                    } else {
                                        switch (compactionOverlapType) {
                                            case FILE_NO_OVERLAP: {
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 600L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 1200L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 1200L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[3], 600L);
                                                break;
                                            }
                                            case FILE_OVERLAP_CHUNK_NO_OVERLAP: {
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 600L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 1200L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 1200L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[3], 600L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[10], 1000L);
                                                break;
                                            }
                                            case CHUNK_OVERLAP_PAGE_NO_OVERLAP: {
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 600L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 1200L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 3000L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[3], 600L);
                                                break;
                                            }
                                            case PAGE_OVERLAP: {
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 600L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 650L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 650L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[3], 600L);
                                            }
                                        }
                                    }
                                } else if (toMergeFileNum == 3) {
                                    if (compactionBeforeHasMod) {
                                        switch (compactionOverlapType) {
                                            case FILE_NO_OVERLAP: {
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 549L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 1200L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 1800L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[3], 1149L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[4], 549L);
                                                break;
                                            }
                                            case FILE_OVERLAP_CHUNK_NO_OVERLAP: {
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 549L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 1200L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 1800L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[3], 1149L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[4], 549L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[10], 1000L);
                                                break;
                                            }
                                            case CHUNK_OVERLAP_PAGE_NO_OVERLAP: {
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 549L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 1200L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 3600L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[3], 1149L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[4], 549L);
                                                break;
                                            }
                                            case PAGE_OVERLAP: {
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 549L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 650L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 1250L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[3], 1200L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[4], 549L);
                                            }
                                        }
                                    } else {
                                        switch (compactionOverlapType) {
                                            case FILE_NO_OVERLAP: {
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 600L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 1200L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 1800L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[3], 1200L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[4], 600L);
                                                break;
                                            }
                                            case FILE_OVERLAP_CHUNK_NO_OVERLAP: {
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 600L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 1200L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 1800L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[3], 1200L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[4], 600L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[10], 1000L);
                                                break;
                                            }
                                            case CHUNK_OVERLAP_PAGE_NO_OVERLAP: {
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 600L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 1200L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 3600L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[3], 1200L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[4], 600L);
                                                break;
                                            }
                                            case PAGE_OVERLAP: {
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 600L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 650L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 1250L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[3], 1200L);
                                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[4], 600L);
                                            }
                                        }
                                    }
                                }
                            } else if (toMergeFileNum == 2) {
                                if (compactionBeforeHasMod) {
                                    switch (compactionOverlapType) {
                                        case FILE_NO_OVERLAP: {
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 549L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[3], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[4], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[5], 549L);
                                            break;
                                        }
                                        case FILE_OVERLAP_CHUNK_NO_OVERLAP: {
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 549L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[3], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[4], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[5], 549L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[10], 1000L);
                                            break;
                                        }
                                        case CHUNK_OVERLAP_PAGE_NO_OVERLAP: {
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 2349L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[3], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[4], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[5], 549L);
                                            break;
                                        }
                                        case PAGE_OVERLAP: {
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 549L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[3], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[4], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[5], 600L);
                                        }
                                    }
                                } else {
                                    switch (compactionOverlapType) {
                                        case FILE_NO_OVERLAP: {
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[3], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[4], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[5], 600L);
                                            break;
                                        }
                                        case FILE_OVERLAP_CHUNK_NO_OVERLAP: {
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[3], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[4], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[5], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[10], 1000L);
                                            break;
                                        }
                                        case CHUNK_OVERLAP_PAGE_NO_OVERLAP: {
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 2400L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[3], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[4], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[5], 600L);
                                            break;
                                        }
                                        case PAGE_OVERLAP: {
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[3], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[4], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[5], 600L);
                                        }
                                    }
                                }
                            } else if (toMergeFileNum == 3) {
                                if (compactionBeforeHasMod) {
                                    switch (compactionOverlapType) {
                                        case FILE_NO_OVERLAP: {
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 549L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[3], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[4], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[5], 549L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[6], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[7], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[8], 549L);
                                            break;
                                        }
                                        case FILE_OVERLAP_CHUNK_NO_OVERLAP: {
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 549L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[3], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[4], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[5], 549L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[6], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[7], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[8], 549L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[10], 1000L);
                                            break;
                                        }
                                        case CHUNK_OVERLAP_PAGE_NO_OVERLAP: {
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 2349L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[3], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[4], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[5], 549L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[6], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[7], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[8], 549L);
                                            break;
                                        }
                                        case PAGE_OVERLAP: {
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 549L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[3], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[4], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[5], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[6], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[7], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[8], 549L);
                                        }
                                    }
                                } else {
                                    switch (compactionOverlapType) {
                                        case FILE_NO_OVERLAP: {
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[3], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[4], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[5], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[6], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[7], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[8], 600L);
                                            break;
                                        }
                                        case FILE_OVERLAP_CHUNK_NO_OVERLAP: {
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[3], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[4], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[5], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[6], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[7], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[8], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[10], 1000L);
                                            break;
                                        }
                                        case CHUNK_OVERLAP_PAGE_NO_OVERLAP: {
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 2400L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[3], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[4], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[5], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[6], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[7], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[8], 600L);
                                            break;
                                        }
                                        case PAGE_OVERLAP: {
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[3], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[4], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[5], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[6], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[7], 600L);
                                            CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[8], 600L);
                                        }
                                    }
                                }
                            }
                            CompactionCheckerUtils.checkChunkAndPage(chunkPagePointsNumMerged, targetTsFileResource);
                            CompactionClearUtils.clearAllCompactionFiles();
                        }
                    }
                }
            }
        }
    }
}

