/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.inner;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.AbstractCompactionTest;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.exception.FileCannotTransitToCompactingException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.ICompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.FastCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.AbstractCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.InnerSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionWorker;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.impl.SizeTieredCompactionSelector;
import org.apache.iotdb.db.storageengine.dataregion.modification.Deletion;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModificationFile;
import org.apache.iotdb.db.storageengine.dataregion.read.control.FileReaderManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceList;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.utils.datastructure.FixedPriorityBlockingQueue;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class InnerSpaceCompactionSelectorTest
extends AbstractCompactionTest {
    @Override
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException, InterruptedException {
        super.setUp();
        IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(2);
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        super.tearDown();
        for (TsFileResource tsFileResource : this.seqResources) {
            FileReaderManager.getInstance().closeFileAndRemoveReader(tsFileResource.getTsFilePath());
        }
        for (TsFileResource tsFileResource : this.unseqResources) {
            FileReaderManager.getInstance().closeFileAndRemoveReader(tsFileResource.getTsFilePath());
        }
    }

    @Test
    public void testFileWithDeviceIndexBeenDeletedBeforeSelection() throws IOException, MetadataException, WriteProcessException, InterruptedException {
        this.createFiles(6, 2, 3, 50, 0, 10000, 50, 50, false, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        AtomicBoolean fail = new AtomicBoolean(false);
        CountDownLatch cd = new CountDownLatch(1);
        Thread thread1 = new Thread(() -> {
            try {
                cd.await();
                SizeTieredCompactionSelector selector = new SizeTieredCompactionSelector("", "", 0L, true, this.tsFileManager);
                TsFileResourceList resources = this.tsFileManager.getOrCreateSequenceListByTimePartition(0L);
                List innerSpaceCompactionTasks = selector.selectInnerSpaceTask((List)resources);
                if (innerSpaceCompactionTasks.size() != 2) {
                    throw new RuntimeException("task num is not 2");
                }
                if (((InnerSpaceCompactionTask)innerSpaceCompactionTasks.get(0)).getSelectedTsFileResourceList().size() != 2 || ((InnerSpaceCompactionTask)innerSpaceCompactionTasks.get(1)).getSelectedTsFileResourceList().size() != 2) {
                    throw new RuntimeException("selected file num is not 2");
                }
            }
            catch (Exception e) {
                fail.set(true);
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        });
        Thread thread2 = new Thread(() -> {
            try {
                TsFileResource resource = (TsFileResource)this.seqResources.get(1);
                resource.writeLock();
                resource.remove();
                resource.writeUnlock();
                cd.countDown();
            }
            catch (Exception e) {
                fail.set(true);
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        });
        thread1.start();
        thread2.start();
        thread1.join(10000L);
        thread2.join(10000L);
        if (fail.get()) {
            Assert.fail();
        }
    }

    @Test
    public void testFileWithDeviceIndexBeenDeletedDuringSelectionAndBeforeSettingCandidate() throws IOException, MetadataException, WriteProcessException, InterruptedException {
        this.createFiles(6, 2, 3, 50, 0, 10000, 50, 50, false, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        AtomicBoolean fail = new AtomicBoolean(false);
        CountDownLatch cd1 = new CountDownLatch(1);
        CountDownLatch cd2 = new CountDownLatch(1);
        Thread thread1 = new Thread(() -> {
            try {
                SizeTieredCompactionSelector selector = new SizeTieredCompactionSelector("", "", 0L, true, this.tsFileManager);
                TsFileResourceList resources = this.tsFileManager.getOrCreateSequenceListByTimePartition(0L);
                List innerSpaceCompactionTasks = selector.selectInnerSpaceTask((List)resources);
                cd1.countDown();
                cd2.await();
                if (innerSpaceCompactionTasks.size() != 3) {
                    throw new RuntimeException("task num is not 3");
                }
                for (int idx = 0; idx < innerSpaceCompactionTasks.size(); ++idx) {
                    TsFileResource resource;
                    int i;
                    List task = ((InnerSpaceCompactionTask)innerSpaceCompactionTasks.get(idx)).getSelectedTsFileResourceList();
                    if (task.size() != 2) {
                        throw new RuntimeException("selected file num is not 2");
                    }
                    InnerSpaceCompactionTask innerSpaceCompactionTask = new InnerSpaceCompactionTask(0L, this.tsFileManager, task, true, (ICompactionPerformer)new FastCompactionPerformer(false), this.tsFileManager.getNextCompactionTaskId());
                    if (idx == 0) {
                        if (innerSpaceCompactionTask.setSourceFilesToCompactionCandidate()) {
                            throw new RuntimeException("set status should be false");
                        }
                        for (i = 0; i < task.size(); ++i) {
                            resource = (TsFileResource)task.get(i);
                            if (i == 1) {
                                if (resource.getStatus() == TsFileResourceStatus.DELETED) continue;
                                throw new RuntimeException("status should be DELETED");
                            }
                            if (resource.getStatus() == TsFileResourceStatus.NORMAL) continue;
                            throw new RuntimeException("status should be NORMAL");
                        }
                        continue;
                    }
                    if (!innerSpaceCompactionTask.setSourceFilesToCompactionCandidate()) {
                        throw new RuntimeException("set status should be true");
                    }
                    for (i = 0; i < task.size(); ++i) {
                        resource = (TsFileResource)task.get(i);
                        if (resource.getStatus() == TsFileResourceStatus.COMPACTION_CANDIDATE) continue;
                        throw new RuntimeException("status should be COMPACTION_CANDIDATE");
                    }
                }
            }
            catch (Exception e) {
                fail.set(true);
                e.printStackTrace();
            }
        });
        Thread thread2 = new Thread(() -> {
            try {
                cd1.await();
                TsFileResource resource = (TsFileResource)this.seqResources.get(1);
                resource.writeLock();
                resource.remove();
                resource.writeUnlock();
                cd2.countDown();
            }
            catch (Exception e) {
                fail.set(true);
                e.printStackTrace();
            }
        });
        thread1.start();
        thread2.start();
        thread1.join(10000L);
        thread2.join(10000L);
        if (fail.get()) {
            Assert.fail();
        }
    }

    @Test
    public void testFileWithDeviceIndexBeenDeletedDuringSelectionAndBeforeSettingCompacting() throws IOException, MetadataException, WriteProcessException, InterruptedException {
        this.createFiles(6, 2, 3, 50, 0, 10000, 50, 50, false, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        AtomicBoolean fail = new AtomicBoolean(false);
        CountDownLatch cd1 = new CountDownLatch(1);
        CountDownLatch cd2 = new CountDownLatch(1);
        Thread thread1 = new Thread(() -> {
            try {
                SizeTieredCompactionSelector selector = new SizeTieredCompactionSelector("", "", 0L, true, this.tsFileManager);
                TsFileResourceList resources = this.tsFileManager.getOrCreateSequenceListByTimePartition(0L);
                List taskResource = selector.selectInnerSpaceTask((List)resources);
                if (taskResource.size() != 3) {
                    throw new RuntimeException("task num is not 3");
                }
                for (int idx = 0; idx < taskResource.size(); ++idx) {
                    List task = ((InnerSpaceCompactionTask)taskResource.get(idx)).getSelectedTsFileResourceList();
                    if (task.size() != 2) {
                        throw new RuntimeException("selected file num is not 2");
                    }
                    InnerSpaceCompactionTask innerSpaceCompactionTask = new InnerSpaceCompactionTask(0L, this.tsFileManager, task, true, (ICompactionPerformer)new FastCompactionPerformer(false), this.tsFileManager.getNextCompactionTaskId());
                    if (!innerSpaceCompactionTask.setSourceFilesToCompactionCandidate()) {
                        throw new RuntimeException("set status should be true");
                    }
                    if (idx == 0) {
                        cd1.countDown();
                        cd2.await();
                        Assert.assertThrows((String)"inner space compaction task should be invalid.", FileCannotTransitToCompactingException.class, () -> ((InnerSpaceCompactionTask)innerSpaceCompactionTask).transitSourceFilesToMerging());
                        FixedPriorityBlockingQueue mockQueue = (FixedPriorityBlockingQueue)Mockito.mock(FixedPriorityBlockingQueue.class);
                        Mockito.when((Object)((AbstractCompactionTask)mockQueue.take())).thenReturn((Object)innerSpaceCompactionTask).thenThrow(new Throwable[]{new InterruptedException()});
                        CompactionWorker worker = new CompactionWorker(0, mockQueue);
                        worker.run();
                        for (int i = 0; i < task.size(); ++i) {
                            TsFileResource resource = (TsFileResource)task.get(i);
                            if (i == 1) {
                                if (resource.getStatus() == TsFileResourceStatus.DELETED) continue;
                                throw new RuntimeException("status should be DELETED");
                            }
                            if (resource.getStatus() == TsFileResourceStatus.NORMAL) continue;
                            throw new RuntimeException("status should be NORMAL");
                        }
                        continue;
                    }
                    try {
                        innerSpaceCompactionTask.transitSourceFilesToMerging();
                    }
                    catch (FileCannotTransitToCompactingException e) {
                        Assert.fail((String)"inner space compaction task should be valid.");
                    }
                    for (int i = 0; i < task.size(); ++i) {
                        TsFileResource resource = (TsFileResource)task.get(i);
                        if (resource.getStatus() == TsFileResourceStatus.COMPACTING) continue;
                        throw new RuntimeException("status should be COMPACTING");
                    }
                }
            }
            catch (Exception e) {
                fail.set(true);
                e.printStackTrace();
            }
        });
        Thread thread2 = new Thread(() -> {
            try {
                cd1.await();
                TsFileResource resource = (TsFileResource)this.seqResources.get(1);
                resource.writeLock();
                resource.remove();
                resource.writeUnlock();
                cd2.countDown();
            }
            catch (Exception e) {
                fail.set(true);
                e.printStackTrace();
            }
        });
        thread1.start();
        thread2.start();
        thread1.join(10000L);
        thread2.join(10000L);
        if (fail.get()) {
            Assert.fail();
        }
    }

    @Test
    public void testFileWithFileIndexBeenDeletedBeforeSelection() throws IOException, MetadataException, WriteProcessException, InterruptedException {
        this.createFiles(6, 2, 3, 50, 0, 10000, 50, 50, false, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        AtomicBoolean fail = new AtomicBoolean(false);
        ((TsFileResource)this.seqResources.get(0)).degradeTimeIndex();
        ((TsFileResource)this.seqResources.get(1)).degradeTimeIndex();
        ((TsFileResource)this.seqResources.get(3)).degradeTimeIndex();
        CountDownLatch cd1 = new CountDownLatch(1);
        CountDownLatch cd2 = new CountDownLatch(1);
        Thread thread1 = new Thread(() -> {
            try {
                cd1.countDown();
                cd2.await();
                SizeTieredCompactionSelector selector = new SizeTieredCompactionSelector("", "", 0L, true, this.tsFileManager);
                TsFileResourceList resources = this.tsFileManager.getOrCreateSequenceListByTimePartition(0L);
                List innerSpaceCompactionTasks = selector.selectInnerSpaceTask((List)resources);
                if (innerSpaceCompactionTasks.size() != 2) {
                    throw new RuntimeException("task num is not 2");
                }
                if (((InnerSpaceCompactionTask)innerSpaceCompactionTasks.get(0)).getSelectedTsFileResourceList().size() != 2 || ((InnerSpaceCompactionTask)innerSpaceCompactionTasks.get(1)).getSelectedTsFileResourceList().size() != 2) {
                    throw new RuntimeException("selected file num is not 2");
                }
            }
            catch (Exception e) {
                fail.set(true);
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        });
        Thread thread2 = new Thread(() -> {
            try {
                cd1.await();
                TsFileResource resource = (TsFileResource)this.seqResources.get(1);
                resource.writeLock();
                resource.remove();
                resource.writeUnlock();
                cd2.countDown();
            }
            catch (Exception e) {
                fail.set(true);
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        });
        thread1.start();
        thread2.start();
        thread1.join(10000L);
        thread2.join(10000L);
        if (fail.get()) {
            Assert.fail();
        }
    }

    @Test
    public void testFileWithFileIndexBeenDeletedDuringSelectionAndBeforeSettingCandidate() throws IOException, MetadataException, WriteProcessException, InterruptedException {
        this.createFiles(6, 2, 3, 50, 0, 10000, 50, 50, false, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        AtomicBoolean fail = new AtomicBoolean(false);
        ((TsFileResource)this.seqResources.get(0)).degradeTimeIndex();
        ((TsFileResource)this.seqResources.get(1)).degradeTimeIndex();
        ((TsFileResource)this.seqResources.get(3)).degradeTimeIndex();
        CountDownLatch cd1 = new CountDownLatch(1);
        CountDownLatch cd2 = new CountDownLatch(1);
        Thread thread1 = new Thread(() -> {
            try {
                SizeTieredCompactionSelector selector = new SizeTieredCompactionSelector("", "", 0L, true, this.tsFileManager);
                TsFileResourceList resources = this.tsFileManager.getOrCreateSequenceListByTimePartition(0L);
                List innerSpaceCompactionTasks = selector.selectInnerSpaceTask((List)resources);
                cd1.countDown();
                cd2.await();
                if (innerSpaceCompactionTasks.size() != 3) {
                    throw new RuntimeException("task num is not 3");
                }
                for (int idx = 0; idx < innerSpaceCompactionTasks.size(); ++idx) {
                    TsFileResource resource;
                    int i;
                    List task = ((InnerSpaceCompactionTask)innerSpaceCompactionTasks.get(idx)).getSelectedTsFileResourceList();
                    if (task.size() != 2) {
                        throw new RuntimeException("selected file num is not 2");
                    }
                    InnerSpaceCompactionTask innerSpaceCompactionTask = new InnerSpaceCompactionTask(0L, this.tsFileManager, task, true, (ICompactionPerformer)new FastCompactionPerformer(false), this.tsFileManager.getNextCompactionTaskId());
                    if (idx == 0) {
                        if (innerSpaceCompactionTask.setSourceFilesToCompactionCandidate()) {
                            throw new RuntimeException("set status should be false");
                        }
                        for (i = 0; i < task.size(); ++i) {
                            resource = (TsFileResource)task.get(i);
                            if (i == 1) {
                                if (resource.getStatus() == TsFileResourceStatus.DELETED) continue;
                                throw new RuntimeException("status should be DELETED");
                            }
                            if (resource.getStatus() == TsFileResourceStatus.NORMAL) continue;
                            throw new RuntimeException("status should be NORMAL");
                        }
                        continue;
                    }
                    if (!innerSpaceCompactionTask.setSourceFilesToCompactionCandidate()) {
                        throw new RuntimeException("set status should be true");
                    }
                    for (i = 0; i < task.size(); ++i) {
                        resource = (TsFileResource)task.get(i);
                        if (resource.getStatus() == TsFileResourceStatus.COMPACTION_CANDIDATE) continue;
                        throw new RuntimeException("status should be COMPACTION_CANDIDATE");
                    }
                }
            }
            catch (Exception e) {
                fail.set(true);
                e.printStackTrace();
            }
        });
        Thread thread2 = new Thread(() -> {
            try {
                cd1.await();
                TsFileResource resource = (TsFileResource)this.seqResources.get(1);
                resource.writeLock();
                resource.remove();
                resource.writeUnlock();
                cd2.countDown();
            }
            catch (Exception e) {
                fail.set(true);
                e.printStackTrace();
            }
        });
        thread1.start();
        thread2.start();
        thread1.join(10000L);
        thread2.join(10000L);
        if (fail.get()) {
            Assert.fail();
        }
    }

    @Test
    public void testFileWithFileIndexBeenDeletedDuringSelectionAndBeforeSettingCompacting() throws IOException, MetadataException, WriteProcessException, InterruptedException {
        this.createFiles(6, 2, 3, 50, 0, 10000, 50, 50, false, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        AtomicBoolean fail = new AtomicBoolean(false);
        ((TsFileResource)this.seqResources.get(0)).degradeTimeIndex();
        ((TsFileResource)this.seqResources.get(1)).degradeTimeIndex();
        ((TsFileResource)this.seqResources.get(3)).degradeTimeIndex();
        CountDownLatch cd1 = new CountDownLatch(1);
        CountDownLatch cd2 = new CountDownLatch(1);
        Thread thread1 = new Thread(() -> {
            try {
                SizeTieredCompactionSelector selector = new SizeTieredCompactionSelector("", "", 0L, true, this.tsFileManager);
                TsFileResourceList resources = this.tsFileManager.getOrCreateSequenceListByTimePartition(0L);
                List innerSpaceCompactionTasks = selector.selectInnerSpaceTask((List)resources);
                if (innerSpaceCompactionTasks.size() != 3) {
                    throw new RuntimeException("task num is not 3");
                }
                for (int idx = 0; idx < innerSpaceCompactionTasks.size(); ++idx) {
                    List task = ((InnerSpaceCompactionTask)innerSpaceCompactionTasks.get(idx)).getSelectedTsFileResourceList();
                    if (task.size() != 2) {
                        throw new RuntimeException("selected file num is not 2");
                    }
                    InnerSpaceCompactionTask innerSpaceCompactionTask = new InnerSpaceCompactionTask(0L, this.tsFileManager, task, true, (ICompactionPerformer)new FastCompactionPerformer(false), this.tsFileManager.getNextCompactionTaskId());
                    if (!innerSpaceCompactionTask.setSourceFilesToCompactionCandidate()) {
                        throw new RuntimeException("set status should be true");
                    }
                    if (idx == 0) {
                        cd1.countDown();
                        cd2.await();
                        Assert.assertThrows((String)"inner space compaction task should be invalid.", FileCannotTransitToCompactingException.class, () -> ((InnerSpaceCompactionTask)innerSpaceCompactionTask).transitSourceFilesToMerging());
                        FixedPriorityBlockingQueue mockQueue = (FixedPriorityBlockingQueue)Mockito.mock(FixedPriorityBlockingQueue.class);
                        Mockito.when((Object)((AbstractCompactionTask)mockQueue.take())).thenReturn((Object)innerSpaceCompactionTask).thenThrow(new Throwable[]{new InterruptedException()});
                        CompactionWorker worker = new CompactionWorker(0, mockQueue);
                        worker.run();
                        for (int i = 0; i < task.size(); ++i) {
                            TsFileResource resource = (TsFileResource)task.get(i);
                            if (i == 1) {
                                if (resource.getStatus() == TsFileResourceStatus.DELETED) continue;
                                throw new RuntimeException("status should be DELETED");
                            }
                            if (resource.getStatus() == TsFileResourceStatus.NORMAL) continue;
                            throw new RuntimeException("status should be NORMAL");
                        }
                        continue;
                    }
                    try {
                        innerSpaceCompactionTask.transitSourceFilesToMerging();
                    }
                    catch (FileCannotTransitToCompactingException e) {
                        Assert.fail((String)"inner space compaction task should be valid.");
                    }
                    for (int i = 0; i < task.size(); ++i) {
                        TsFileResource resource = (TsFileResource)task.get(i);
                        if (resource.getStatus() == TsFileResourceStatus.COMPACTING) continue;
                        throw new RuntimeException("status should be COMPACTING");
                    }
                }
            }
            catch (Exception e) {
                fail.set(true);
                e.printStackTrace();
            }
        });
        Thread thread2 = new Thread(() -> {
            try {
                cd1.await();
                TsFileResource resource = (TsFileResource)this.seqResources.get(1);
                resource.writeLock();
                resource.remove();
                resource.writeUnlock();
                cd2.countDown();
            }
            catch (Exception e) {
                fail.set(true);
                e.printStackTrace();
            }
        });
        thread1.start();
        thread2.start();
        thread1.join(10000L);
        thread2.join(10000L);
        if (fail.get()) {
            Assert.fail();
        }
    }

    @Test
    public void testSelectWhenModsFileGreaterThan50M() throws IOException, MetadataException, WriteProcessException {
        this.createFiles(6, 2, 3, 50, 0, 10000, 50, 50, false, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        MockModiFicationFile mockModiFicationFile = new MockModiFicationFile(((TsFileResource)this.seqResources.get(0)).getTsFilePath() + ".mods");
        mockModiFicationFile.write((Modification)new Deletion(new PartialPath("root.a.b"), 1L, 1L));
        ((TsFileResource)this.seqResources.get(0)).setModFile((ModificationFile)mockModiFicationFile);
        SizeTieredCompactionSelector selector = new SizeTieredCompactionSelector("", "", 0L, true, this.tsFileManager);
        TsFileResourceList resources = this.tsFileManager.getOrCreateSequenceListByTimePartition(0L);
        List innerSpaceCompactionTasks = selector.selectInnerSpaceTask((List)resources);
        Assert.assertEquals((long)1L, (long)innerSpaceCompactionTasks.size());
        mockModiFicationFile.remove();
    }

    @Test
    public void testSelectWhenModsFileGreaterThan50MWithTsFileResourceStatusIsNotNormal() throws IOException, MetadataException, WriteProcessException {
        this.createFiles(2, 2, 3, 50, 0, 10000, 50, 50, false, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        MockModiFicationFile mockModiFicationFile = new MockModiFicationFile(((TsFileResource)this.seqResources.get(0)).getTsFilePath() + ".mods");
        mockModiFicationFile.write((Modification)new Deletion(new PartialPath("root.a.b"), 1L, 1L));
        ((TsFileResource)this.seqResources.get(0)).setModFile((ModificationFile)mockModiFicationFile);
        ((TsFileResource)this.seqResources.get(0)).setStatusForTest(TsFileResourceStatus.COMPACTING);
        SizeTieredCompactionSelector selector = new SizeTieredCompactionSelector("", "", 0L, true, this.tsFileManager);
        TsFileResourceList resources = this.tsFileManager.getOrCreateSequenceListByTimePartition(0L);
        List innerSpaceCompactionTasks = selector.selectInnerSpaceTask((List)resources);
        Assert.assertEquals((long)0L, (long)innerSpaceCompactionTasks.size());
        mockModiFicationFile.remove();
    }

    class MockModiFicationFile
    extends ModificationFile {
        public MockModiFicationFile(String filePath) {
            super(filePath);
            new File(filePath);
        }

        public long getSize() {
            return 52428801L;
        }
    }
}

