/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.inner;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.exception.CompactionExceptionHandler;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.ICompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.FastCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.subtask.FastCompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.log.CompactionLogger;
import org.apache.iotdb.db.storageengine.dataregion.compaction.inner.AbstractInnerSpaceCompactionTest;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.CompactionFileGeneratorUtils;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModificationFile;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.generator.TsFileNameGenerator;
import org.apache.iotdb.tsfile.utils.Pair;
import org.junit.Assert;
import org.junit.Test;

public class InnerSpaceCompactionExceptionTest
extends AbstractInnerSpaceCompactionTest {
    ICompactionPerformer performer = new FastCompactionPerformer(false);

    @Test
    public void testWhenAllSourceExistsAndTargetNotComplete() throws Exception {
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource((List)this.seqResources, (boolean)true);
        File logFile = new File(targetResource.getTsFile().getPath() + ".inner-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(logFile);
        compactionLogger.logFiles(this.seqResources, "source");
        compactionLogger.logFiles(Collections.singletonList(targetResource), "target");
        this.performer.setSourceFiles(this.seqResources);
        this.performer.setTargetFiles(Collections.singletonList(targetResource));
        this.performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        this.performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)"root.compactionTest");
        try (FileOutputStream os = new FileOutputStream(targetResource.getTsFile(), true);
             FileChannel channel = os.getChannel();){
            channel.truncate(targetResource.getTsFileSize() - 10L);
        }
        compactionLogger.close();
        CompactionExceptionHandler.handleException((String)"root.compactionTest", (File)logFile, Collections.singletonList(targetResource), (List)this.seqResources, Collections.emptyList(), (TsFileManager)this.tsFileManager, (long)0L, (boolean)true, (boolean)true);
        Assert.assertFalse((boolean)targetResource.getTsFile().exists());
        Assert.assertFalse((boolean)targetResource.resourceFileExists());
        for (TsFileResource resource : this.seqResources) {
            Assert.assertTrue((boolean)resource.resourceFileExists());
            Assert.assertTrue((boolean)resource.getTsFile().exists());
        }
        Assert.assertTrue((boolean)this.tsFileManager.isAllowCompaction());
    }

    @Test
    public void testWhenAllSourceExistsAndTargetComplete() throws Exception {
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource((List)this.seqResources, (boolean)true);
        File logFile = new File(targetResource.getTsFile().getPath() + ".inner-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(logFile);
        compactionLogger.logFiles(this.seqResources, "source");
        compactionLogger.logFiles(Collections.singletonList(targetResource), "target");
        this.performer.setSourceFiles(this.seqResources);
        this.performer.setTargetFiles(Collections.singletonList(targetResource));
        this.performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        this.performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)"root.compactionTest");
        compactionLogger.close();
        CompactionExceptionHandler.handleException((String)"root.compactionTest", (File)logFile, Collections.singletonList(targetResource), (List)this.seqResources, Collections.emptyList(), (TsFileManager)this.tsFileManager, (long)0L, (boolean)true, (boolean)true);
        Assert.assertFalse((boolean)targetResource.getTsFile().exists());
        Assert.assertFalse((boolean)targetResource.resourceFileExists());
        for (TsFileResource resource : this.seqResources) {
            Assert.assertTrue((boolean)resource.resourceFileExists());
            Assert.assertTrue((boolean)resource.getTsFile().exists());
        }
        Assert.assertTrue((boolean)this.tsFileManager.isAllowCompaction());
    }

    @Test
    public void testWhenSomeSourceLostAndTargetComplete() throws Exception {
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource((List)this.seqResources, (boolean)true);
        File logFile = new File(targetResource.getTsFile().getPath() + ".inner-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(logFile);
        compactionLogger.logFiles(this.seqResources, "source");
        compactionLogger.logFiles(Collections.singletonList(targetResource), "target");
        this.performer.setSourceFiles(this.seqResources);
        this.performer.setTargetFiles(Collections.singletonList(targetResource));
        this.performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        this.performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)"root.compactionTest");
        for (TsFileResource resource : this.seqResources) {
            this.tsFileManager.getOrCreateSequenceListByTimePartition(0L).remove((Object)resource);
        }
        this.tsFileManager.getOrCreateSequenceListByTimePartition(0L).keepOrderInsert(targetResource);
        Files.delete(((TsFileResource)this.seqResources.get(0)).getTsFile().toPath());
        ((TsFileResource)this.seqResources.get(0)).remove();
        compactionLogger.close();
        Assert.assertTrue((boolean)targetResource.getTsFile().exists());
        Assert.assertTrue((boolean)targetResource.resourceFileExists());
        CompactionExceptionHandler.handleException((String)"root.compactionTest", (File)logFile, Collections.singletonList(targetResource), (List)this.seqResources, Collections.emptyList(), (TsFileManager)this.tsFileManager, (long)0L, (boolean)true, (boolean)true);
        Assert.assertTrue((boolean)targetResource.getTsFile().exists());
        Assert.assertTrue((boolean)targetResource.resourceFileExists());
        this.seqResources.remove(0);
        for (TsFileResource resource : this.seqResources) {
            Assert.assertFalse((boolean)resource.resourceFileExists());
            Assert.assertFalse((boolean)resource.getTsFile().exists());
        }
        Assert.assertTrue((boolean)this.tsFileManager.isAllowCompaction());
        Assert.assertEquals((long)1L, (long)this.tsFileManager.getOrCreateSequenceListByTimePartition(0L).size());
        Assert.assertEquals((Object)targetResource, (Object)this.tsFileManager.getOrCreateSequenceListByTimePartition(0L).get(0));
    }

    @Test
    public void testWhenSomeSourceLostAndTargetNotComplete() throws Exception {
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource((List)this.seqResources, (boolean)true);
        File logFile = new File(targetResource.getTsFile().getPath() + ".inner-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(logFile);
        compactionLogger.logFiles(this.seqResources, "source");
        compactionLogger.logFiles(Collections.singletonList(targetResource), "target");
        this.performer.setSourceFiles(this.seqResources);
        this.performer.setTargetFiles(Collections.singletonList(targetResource));
        this.performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        this.performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)"root.compactionTest");
        ((TsFileResource)this.seqResources.get(0)).remove();
        try (FileOutputStream os = new FileOutputStream(targetResource.getTsFile(), true);
             FileChannel channel = os.getChannel();){
            channel.truncate(targetResource.getTsFileSize() - 10L);
        }
        compactionLogger.close();
        Assert.assertTrue((boolean)targetResource.getTsFile().exists());
        CompactionExceptionHandler.handleException((String)"root.compactionTest", (File)logFile, Collections.singletonList(targetResource), (List)this.seqResources, Collections.emptyList(), (TsFileManager)this.tsFileManager, (long)0L, (boolean)true, (boolean)true);
        Assert.assertTrue((boolean)targetResource.getTsFile().exists());
        Assert.assertTrue((boolean)targetResource.resourceFileExists());
        this.seqResources.remove(0);
        for (TsFileResource resource : this.seqResources) {
            Assert.assertTrue((boolean)resource.resourceFileExists());
            Assert.assertTrue((boolean)resource.getTsFile().exists());
        }
    }

    @Test
    public void testHandleWithCompactionMods() throws Exception {
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource((List)this.seqResources, (boolean)true);
        File logFile = new File(targetResource.getTsFile().getPath() + ".inner-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(logFile);
        compactionLogger.logFiles(this.seqResources, "source");
        compactionLogger.logFiles(Collections.singletonList(targetResource), "target");
        this.performer.setSourceFiles(this.seqResources);
        this.performer.setTargetFiles(Collections.singletonList(targetResource));
        this.performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        this.performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)"root.compactionTest");
        for (int i = 0; i < this.seqResources.size(); ++i) {
            HashMap<String, Pair<Long, Long>> deleteMap = new HashMap<String, Pair<Long, Long>>();
            deleteMap.put(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId(), new Pair((Object)((long)i * this.ptNum), (Object)((long)i * this.ptNum + 10L)));
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.seqResources.get(i), true);
        }
        CompactionUtils.combineModsInInnerCompaction((Collection)this.seqResources, (TsFileResource)targetResource);
        ((TsFileResource)this.seqResources.get(0)).remove();
        compactionLogger.close();
        Assert.assertTrue((boolean)targetResource.getTsFile().exists());
        CompactionExceptionHandler.handleException((String)"root.compactionTest", (File)logFile, Collections.singletonList(targetResource), (List)this.seqResources, Collections.emptyList(), (TsFileManager)this.tsFileManager, (long)0L, (boolean)true, (boolean)true);
        Assert.assertTrue((boolean)targetResource.getTsFile().exists());
        Assert.assertTrue((boolean)targetResource.resourceFileExists());
        Assert.assertTrue((boolean)targetResource.getModFile().exists());
        Collection modifications = targetResource.getModFile().getModifications();
        Assert.assertEquals((long)this.seqResources.size(), (long)modifications.size());
        for (Modification modification : modifications) {
            Assert.assertEquals((Object)this.deviceIds[0], (Object)modification.getDevice());
            Assert.assertEquals((Object)this.measurementSchemas[0].getMeasurementId(), (Object)modification.getMeasurement());
            Assert.assertEquals((long)Long.MAX_VALUE, (long)modification.getFileOffset());
        }
        this.seqResources.remove(0);
        for (TsFileResource resource : this.seqResources) {
            Assert.assertFalse((boolean)resource.resourceFileExists());
            Assert.assertFalse((boolean)resource.getTsFile().exists());
            Assert.assertFalse((boolean)resource.getModFile().exists());
        }
        Assert.assertTrue((boolean)this.tsFileManager.isAllowCompaction());
    }

    @Test
    public void testHandleWithNormalMods() throws Exception {
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource((List)this.seqResources, (boolean)true);
        File logFile = new File(targetResource.getTsFile().getPath() + ".inner-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(logFile);
        compactionLogger.logFiles(this.seqResources, "source");
        compactionLogger.logFiles(Collections.singletonList(targetResource), "target");
        for (int i = 0; i < this.seqResources.size(); ++i) {
            HashMap<String, Pair<Long, Long>> deleteMap = new HashMap<String, Pair<Long, Long>>();
            deleteMap.put(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId(), new Pair((Object)((long)i * this.ptNum), (Object)((long)i * this.ptNum + 10L)));
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.seqResources.get(i), false);
        }
        this.performer.setSourceFiles(this.seqResources);
        this.performer.setTargetFiles(Collections.singletonList(targetResource));
        this.performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        this.performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)"root.compactionTest");
        ((TsFileResource)this.seqResources.get(0)).remove();
        compactionLogger.close();
        Assert.assertTrue((boolean)targetResource.getTsFile().exists());
        CompactionExceptionHandler.handleException((String)"root.compactionTest", (File)logFile, Collections.singletonList(targetResource), (List)this.seqResources, Collections.emptyList(), (TsFileManager)this.tsFileManager, (long)0L, (boolean)true, (boolean)true);
        Assert.assertTrue((boolean)targetResource.getTsFile().exists());
        Assert.assertTrue((boolean)targetResource.resourceFileExists());
        Assert.assertFalse((boolean)targetResource.getModFile().exists());
        this.seqResources.remove(0);
        for (TsFileResource resource : this.seqResources) {
            Assert.assertFalse((boolean)resource.resourceFileExists());
            Assert.assertFalse((boolean)resource.getTsFile().exists());
            Assert.assertFalse((boolean)resource.getModFile().exists());
        }
        Assert.assertTrue((boolean)this.tsFileManager.isAllowCompaction());
    }

    @Test
    public void testHandleWithCompactionModsAndNormalMods() throws Exception {
        HashMap<String, Pair<Long, Long>> deleteMap;
        int i;
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource((List)this.seqResources, (boolean)true);
        File logFile = new File(targetResource.getTsFile().getPath() + ".inner-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(logFile);
        compactionLogger.logFiles(this.seqResources, "source");
        compactionLogger.logFiles(Collections.singletonList(targetResource), "target");
        for (i = 0; i < this.seqResources.size(); ++i) {
            deleteMap = new HashMap<String, Pair<Long, Long>>();
            deleteMap.put(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId(), new Pair((Object)((long)i * this.ptNum), (Object)((long)i * this.ptNum + 5L)));
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.seqResources.get(i), false);
        }
        this.performer.setSourceFiles(this.seqResources);
        this.performer.setTargetFiles(Collections.singletonList(targetResource));
        this.performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        this.performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)"root.compactionTest");
        for (i = 0; i < this.seqResources.size(); ++i) {
            deleteMap = new HashMap();
            deleteMap.put(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId(), (Pair<Long, Long>)new Pair((Object)((long)i * this.ptNum + 10L), (Object)((long)i * this.ptNum + 15L)));
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.seqResources.get(i), true);
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.seqResources.get(i), false);
        }
        compactionLogger.close();
        CompactionExceptionHandler.handleException((String)"root.compactionTest", (File)logFile, Collections.singletonList(targetResource), (List)this.seqResources, Collections.emptyList(), (TsFileManager)this.tsFileManager, (long)0L, (boolean)true, (boolean)true);
        Assert.assertFalse((boolean)targetResource.getTsFile().exists());
        Assert.assertFalse((boolean)targetResource.resourceFileExists());
        Assert.assertFalse((boolean)targetResource.getModFile().exists());
        for (TsFileResource resource : this.seqResources) {
            resource.resetModFile();
            Assert.assertTrue((boolean)resource.resourceFileExists());
            Assert.assertTrue((boolean)resource.getTsFile().exists());
            Assert.assertTrue((boolean)resource.getModFile().exists());
            Assert.assertFalse((boolean)ModificationFile.getCompactionMods((TsFileResource)resource).exists());
            Collection modifications = resource.getModFile().getModifications();
            Assert.assertEquals((long)2L, (long)modifications.size());
            for (Modification modification : modifications) {
                Assert.assertEquals((Object)this.deviceIds[0], (Object)modification.getDevice());
                Assert.assertEquals((Object)this.measurementSchemas[0].getMeasurementId(), (Object)modification.getMeasurement());
                Assert.assertEquals((long)Long.MAX_VALUE, (long)modification.getFileOffset());
            }
        }
        Assert.assertTrue((boolean)this.tsFileManager.isAllowCompaction());
    }

    @Test
    public void testWhenTargetFileIsDeletedAfterCompactionAndSomeSourceFilesLost() throws Exception {
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        for (int device = 0; device < this.deviceNum; ++device) {
            for (int measurement = 0; measurement < this.measurementNum; ++measurement) {
                HashMap<String, Pair> deleteMap = new HashMap<String, Pair>();
                deleteMap.put("root.compactionTest.device" + device + "." + "sensor" + measurement, new Pair((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE));
                this.seqResources.forEach(x -> {
                    try {
                        CompactionFileGeneratorUtils.generateMods(deleteMap, x, false);
                    }
                    catch (IOException | IllegalPathException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getInnerCompactionTargetTsFileResources(this.seqResources, true);
        File compactionLogFile = new File(SEQ_DIRS, targetResources.get(0).getTsFile().getName() + ".cross-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(compactionLogFile);
        compactionLogger.logFiles(targetResources, "target");
        compactionLogger.logFiles(this.seqResources, "source");
        compactionLogger.close();
        FastCompactionPerformer performer = new FastCompactionPerformer(this.seqResources, Collections.emptyList(), targetResources);
        performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        performer.perform();
        CompactionUtils.moveTargetFile(targetResources, (boolean)true, (String)"root.compactionTest");
        CompactionUtils.combineModsInInnerCompaction((Collection)this.seqResources, (TsFileResource)targetResources.get(0));
        ((TsFileResource)this.seqResources.get(0)).remove();
        CompactionExceptionHandler.handleException((String)"root.compactionTest", (File)compactionLogFile, targetResources, (List)this.seqResources, Collections.emptyList(), (TsFileManager)this.tsFileManager, (long)0L, (boolean)true, (boolean)true);
        Assert.assertTrue((boolean)this.tsFileManager.isAllowCompaction());
        for (TsFileResource resource : this.seqResources) {
            Assert.assertFalse((boolean)resource.getTsFile().exists());
            Assert.assertFalse((boolean)new File(resource.getTsFilePath() + ".resource").exists());
            Assert.assertFalse((boolean)resource.getModFile().exists());
            Assert.assertFalse((boolean)resource.getCompactionModFile().exists());
        }
        Assert.assertFalse((boolean)targetResources.get(0).getTsFile().exists());
        Assert.assertFalse((boolean)targetResources.get(0).resourceFileExists());
    }

    @Test
    public void testWhenTargetFileIsDeletedAfterCompactionAndAllSourceFilesExisted() throws Exception {
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        for (int device = 0; device < this.deviceNum; ++device) {
            for (int measurement = 0; measurement < this.measurementNum; ++measurement) {
                HashMap<String, Pair> deleteMap = new HashMap<String, Pair>();
                deleteMap.put("root.compactionTest.device" + device + "." + "sensor" + measurement, new Pair((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE));
                this.seqResources.forEach(x -> {
                    try {
                        CompactionFileGeneratorUtils.generateMods(deleteMap, x, false);
                    }
                    catch (IOException | IllegalPathException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getInnerCompactionTargetTsFileResources(this.seqResources, true);
        File compactionLogFile = new File(SEQ_DIRS, targetResources.get(0).getTsFile().getName() + ".cross-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(compactionLogFile);
        compactionLogger.logFiles(targetResources, "target");
        compactionLogger.logFiles(this.seqResources, "source");
        compactionLogger.close();
        FastCompactionPerformer performer = new FastCompactionPerformer(this.seqResources, Collections.emptyList(), targetResources);
        performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        performer.perform();
        CompactionUtils.moveTargetFile(targetResources, (boolean)true, (String)"root.compactionTest");
        CompactionUtils.combineModsInInnerCompaction((Collection)this.seqResources, (TsFileResource)targetResources.get(0));
        CompactionExceptionHandler.handleException((String)"root.compactionTest", (File)compactionLogFile, targetResources, (List)this.seqResources, Collections.emptyList(), (TsFileManager)this.tsFileManager, (long)0L, (boolean)true, (boolean)true);
        Assert.assertTrue((boolean)this.tsFileManager.isAllowCompaction());
        for (TsFileResource resource : this.seqResources) {
            Assert.assertTrue((boolean)resource.getTsFile().exists());
            Assert.assertTrue((boolean)new File(resource.getTsFilePath() + ".resource").exists());
            Assert.assertTrue((boolean)resource.getModFile().exists());
            Assert.assertFalse((boolean)resource.getCompactionModFile().exists());
        }
        for (TsFileResource resource : targetResources) {
            if (resource == null) continue;
            Assert.assertFalse((boolean)resource.getTsFile().exists());
            Assert.assertFalse((boolean)new File(resource.getTsFilePath().replace(".inner", ".tsfile")).exists());
            Assert.assertFalse((boolean)new File(resource.getTsFilePath().replace(".inner", ".tsfile") + ".resource").exists());
        }
    }
}

