/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.inner;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.reader.SeriesDataBlockReader;
import org.apache.iotdb.db.storageengine.dataregion.compaction.inner.InnerCompactionTest;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionScheduler;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionTaskManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.PlainDeviceID;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.write.TsFileWriter;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InnerCompactionMoreDataTest
extends InnerCompactionTest {
    protected int measurementNum = 3000;
    protected int seqFileNum = 2;
    File tempSGDir;

    @Override
    void prepareSeries() throws MetadataException {
        int i;
        this.measurementSchemas = new MeasurementSchema[this.measurementNum];
        for (i = 0; i < this.measurementNum; ++i) {
            this.measurementSchemas[i] = new MeasurementSchema("sensor" + i, TSDataType.DOUBLE, this.encoding, CompressionType.UNCOMPRESSED);
        }
        this.deviceIds = new String[this.deviceNum];
        for (i = 0; i < this.deviceNum; ++i) {
            this.deviceIds[i] = "root.compactionTest.device" + i;
        }
    }

    @Override
    void prepareFiles(int seqFileNum, int unseqFileNum) throws IOException, WriteProcessException {
        for (int i = 0; i < seqFileNum; ++i) {
            File file = new File(TestConstant.getTestTsFileDir((String)"root.compactionTest", (long)0L, (long)0L).concat(i + "-" + i + "-" + 0 + "-" + 0 + ".tsfile"));
            TsFileResource tsFileResource = new TsFileResource(file);
            tsFileResource.setStatusForTest(TsFileResourceStatus.NORMAL);
            tsFileResource.updatePlanIndexes((long)i);
            this.seqResources.add(tsFileResource);
            this.prepareFile(tsFileResource, (long)i * this.ptNum, this.ptNum, 0L);
        }
    }

    @Override
    void prepareFile(TsFileResource tsFileResource, long timeOffset, long ptNum, long valueOffset) throws IOException, WriteProcessException {
        TsFileWriter fileWriter = new TsFileWriter(tsFileResource.getTsFile());
        for (String deviceId : this.deviceIds) {
            for (MeasurementSchema measurementSchema : this.measurementSchemas) {
                fileWriter.registerTimeseries(new Path(deviceId), measurementSchema);
            }
        }
        for (long i = timeOffset; i < timeOffset + ptNum; ++i) {
            for (int j = 0; j < this.deviceNum; ++j) {
                TSRecord record = new TSRecord(i, this.deviceIds[j]);
                for (int k = 0; k < this.measurementNum; ++k) {
                    record.addTuple(DataPoint.getDataPoint((TSDataType)this.measurementSchemas[k].getType(), (String)this.measurementSchemas[k].getMeasurementId(), (String)String.valueOf(i + valueOffset + (long)k)));
                }
                fileWriter.write(record);
                tsFileResource.updateStartTime((IDeviceID)new PlainDeviceID(this.deviceIds[j]), i);
                tsFileResource.updateEndTime((IDeviceID)new PlainDeviceID(this.deviceIds[j]), i);
            }
            if ((i + 1L) % this.flushInterval != 0L) continue;
            fileWriter.flushAllChunkGroups();
        }
        fileWriter.close();
    }

    @Override
    @Before
    public void setUp() throws Exception {
        this.tempSGDir = new File(TestConstant.getTestTsFileDir((String)"root.compactionTest", (long)0L, (long)0L));
        if (!this.tempSGDir.exists()) {
            Assert.assertTrue((boolean)this.tempSGDir.mkdirs());
        }
        super.setUp();
        this.tempSGDir = new File(TestConstant.BASE_OUTPUT_PATH.concat("tempSG"));
        this.tempSGDir.mkdirs();
        this.tsFileManager = new TsFileManager("root.compactionTest", "0", this.tempSGDir.getAbsolutePath());
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        super.tearDown();
        FileUtils.deleteDirectory((File)this.tempSGDir);
    }

    @Test
    public void testSensorWithTwoOrThreeNode() throws MetadataException, IOException, InterruptedException {
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CompactionScheduler.scheduleCompaction((TsFileManager)this.tsFileManager, (long)0L);
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        CompactionTaskManager.getInstance().waitAllCompactionFinish();
        MeasurementPath path = new MeasurementPath(new PartialPath(this.deviceIds[0], this.measurementSchemas[2688].getMeasurementId()), this.measurementSchemas[2688].getType());
        SeriesDataBlockReader tsFilesReader = new SeriesDataBlockReader((PartialPath)path, EnvironmentUtils.TEST_QUERY_FI_CONTEXT, this.tsFileManager.getTsFileList(true), new ArrayList(), true);
        while (tsFilesReader.hasNextBatch()) {
            TsBlock batchData = tsFilesReader.nextBatch();
            int size = batchData.getPositionCount();
            for (int i = 0; i < size; ++i) {
                Assert.assertEquals((double)(batchData.getTimeByIndex(i) + 2688L), (double)batchData.getColumn(0).getDouble(i), (double)0.001);
            }
        }
    }
}

