/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.cross;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.MergeException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.cross.MergeTest;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.impl.RewriteCrossSpaceCompactionSelector;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.utils.CrossCompactionTaskResource;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.utils.CrossSpaceCompactionCandidate;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.ITimeIndex;
import org.apache.iotdb.db.storageengine.rescon.memory.SystemInfo;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.write.TsFileWriter;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RewriteCompactionFileSelectorTest
extends MergeTest {
    private static final Logger logger = LoggerFactory.getLogger(RewriteCompactionFileSelectorTest.class);
    private int oldMinCrossCompactionUnseqLevel = IoTDBDescriptor.getInstance().getConfig().getMinCrossCompactionUnseqFileLevel();

    @Override
    @Before
    public void setUp() throws IOException, MetadataException, WriteProcessException {
        super.setUp();
        IoTDBDescriptor.getInstance().getConfig().setMinCrossCompactionUnseqFileLevel(0);
        IoTDBDescriptor.getInstance().getConfig().setCompactionThreadCount(1);
    }

    @Override
    @After
    public void tearDown() throws StorageEngineException, IOException {
        super.tearDown();
    }

    @Test
    public void testFullSelection() throws MergeException, IOException {
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        List seqSelected = ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles();
        List unseqSelected = ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles();
        Assert.assertEquals((Object)this.seqResources, (Object)seqSelected);
        Assert.assertEquals((Object)this.unseqResources, (Object)unseqSelected);
        selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        selected = selector.selectCrossSpaceTask(this.seqResources.subList(0, 1), this.unseqResources);
        seqSelected = ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles();
        unseqSelected = ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles();
        Assert.assertEquals(this.seqResources.subList(0, 1), (Object)seqSelected);
        Assert.assertEquals((Object)this.unseqResources, (Object)unseqSelected);
        selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources.subList(0, 1));
        seqSelected = ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles();
        unseqSelected = ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles();
        Assert.assertEquals(this.seqResources.subList(0, 1), (Object)seqSelected);
        Assert.assertEquals(this.unseqResources.subList(0, 1), (Object)unseqSelected);
    }

    @Test
    public void testWithFewMemoryBudgeSelection() throws MergeException, IOException {
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)1L, (long)selected.size());
    }

    @Test
    public void testRestrictedSelection() throws MergeException, IOException {
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        List seqSelected = ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles();
        List unseqSelected = ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles();
        Assert.assertEquals(this.seqResources.subList(0, 5), (Object)seqSelected);
        Assert.assertEquals(this.unseqResources.subList(0, 6), (Object)unseqSelected);
    }

    @Test
    public void testFileOpenSelection() throws MergeException, IOException, WriteProcessException, NoSuchFieldException, IllegalAccessException {
        File file = new File(TestConstant.BASE_OUTPUT_PATH.concat(System.currentTimeMillis() + "-" + 10 + "-" + 10 + "-" + 0 + ".tsfile"));
        TsFileResource largeUnseqTsFileResource = new TsFileResource(file);
        this.unseqResources.add(largeUnseqTsFileResource);
        largeUnseqTsFileResource.setStatusForTest(TsFileResourceStatus.NORMAL);
        largeUnseqTsFileResource.setMinPlanIndex(10L);
        largeUnseqTsFileResource.setMaxPlanIndex(10L);
        largeUnseqTsFileResource.setVersion(10L);
        this.prepareFile(largeUnseqTsFileResource, 0L, (long)this.seqFileNum * this.ptNum, 0L);
        TsFileResource secondTsFileResource = (TsFileResource)this.seqResources.get(1);
        secondTsFileResource.setStatusForTest(TsFileResourceStatus.UNCLOSED);
        Set devices = secondTsFileResource.getDevices();
        Field timeIndexField = TsFileResource.class.getDeclaredField("timeIndex");
        timeIndexField.setAccessible(true);
        ITimeIndex timeIndex = (ITimeIndex)timeIndexField.get(secondTsFileResource);
        ITimeIndex newTimeIndex = IoTDBDescriptor.getInstance().getConfig().getTimeIndexLevel().getTimeIndex();
        for (IDeviceID device : devices) {
            newTimeIndex.updateStartTime(device, timeIndex.getStartTime(device));
        }
        secondTsFileResource.setTimeIndex(newTimeIndex);
        ArrayList<TsFileResource> newUnseqResources = new ArrayList<TsFileResource>();
        newUnseqResources.add(largeUnseqTsFileResource);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, newUnseqResources);
        Assert.assertEquals((long)0L, (long)selected.size());
    }

    @Test
    public void testFileOpenSelectionFromCompaction() throws IOException, WriteProcessException, NoSuchFieldException, IllegalAccessException {
        File file = new File(TestConstant.BASE_OUTPUT_PATH.concat(System.currentTimeMillis() + "-" + 10 + "-" + 10 + "-" + 0 + ".tsfile"));
        TsFileResource largeUnseqTsFileResource = new TsFileResource(file);
        this.unseqResources.add(largeUnseqTsFileResource);
        largeUnseqTsFileResource.setStatusForTest(TsFileResourceStatus.NORMAL);
        largeUnseqTsFileResource.setMinPlanIndex(10L);
        largeUnseqTsFileResource.setMaxPlanIndex(10L);
        largeUnseqTsFileResource.setVersion(10L);
        this.prepareFile(largeUnseqTsFileResource, 0L, (long)this.seqFileNum * this.ptNum, 0L);
        TsFileResource secondTsFileResource = (TsFileResource)this.seqResources.get(1);
        secondTsFileResource.setStatusForTest(TsFileResourceStatus.UNCLOSED);
        Set devices = secondTsFileResource.getDevices();
        Field timeIndexField = TsFileResource.class.getDeclaredField("timeIndex");
        timeIndexField.setAccessible(true);
        ITimeIndex timeIndex = (ITimeIndex)timeIndexField.get(secondTsFileResource);
        ITimeIndex newTimeIndex = IoTDBDescriptor.getInstance().getConfig().getTimeIndexLevel().getTimeIndex();
        for (IDeviceID device : devices) {
            newTimeIndex.updateStartTime(device, timeIndex.getStartTime(device));
        }
        secondTsFileResource.setTimeIndex(newTimeIndex);
        ArrayList<TsFileResource> newUnseqResources = new ArrayList<TsFileResource>();
        newUnseqResources.add(largeUnseqTsFileResource);
        long ttlLowerBound = System.currentTimeMillis() - Long.MAX_VALUE;
        CrossSpaceCompactionCandidate mergeResource = new CrossSpaceCompactionCandidate(this.seqResources, newUnseqResources, ttlLowerBound);
        Assert.assertEquals((long)5L, (long)mergeResource.getSeqFiles().size());
        Assert.assertEquals((long)1L, (long)mergeResource.getUnseqFiles().size());
    }

    @Test
    public void testFileSelectionAboutLastSeqFile() throws MergeException, IOException, WriteProcessException {
        File file = new File(TestConstant.BASE_OUTPUT_PATH.concat(System.currentTimeMillis() + "-" + 10 + "-" + 10 + "-" + 0 + ".tsfile"));
        TsFileResource largeUnseqTsFileResource = new TsFileResource(file);
        largeUnseqTsFileResource.setStatusForTest(TsFileResourceStatus.NORMAL);
        largeUnseqTsFileResource.setMinPlanIndex(10L);
        largeUnseqTsFileResource.setMaxPlanIndex(10L);
        largeUnseqTsFileResource.setVersion(10L);
        this.prepareFile(largeUnseqTsFileResource, 0L, this.ptNum + 1L, 0L);
        this.unseqResources.clear();
        this.unseqResources.add(largeUnseqTsFileResource);
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectContinuousUnseqFile() throws IOException, WriteProcessException, MergeException {
        ArrayList<TsFileResource> seqList = new ArrayList<TsFileResource>();
        ArrayList<TsFileResource> unseqList = new ArrayList<TsFileResource>();
        try {
            int seqFileNum = 99;
            for (int i = 0; i < seqFileNum; ++i) {
                File file = new File(TestConstant.BASE_OUTPUT_PATH.concat(System.currentTimeMillis() + "-" + i + "-" + 10 + "-" + 0 + ".tsfile"));
                TsFileResource fileResource = new TsFileResource(file);
                fileResource.setStatusForTest(TsFileResourceStatus.NORMAL);
                this.prepareFile(fileResource, i, 1L, 0L);
                seqList.add(fileResource);
            }
            int unseqFileNum = 3;
            for (int i = 0; i < unseqFileNum; ++i) {
                File file = new File(TestConstant.BASE_OUTPUT_PATH.concat(System.currentTimeMillis() + "-" + i + "-" + 10 + "-" + 0 + ".tsfile"));
                TsFileResource fileResource = new TsFileResource(file);
                fileResource.setStatusForTest(TsFileResourceStatus.NORMAL);
                unseqList.add(fileResource);
            }
            this.prepareFile((TsFileResource)unseqList.get(0), 0L, 1L, 10L);
            this.prepareFile((TsFileResource)unseqList.get(1), 0L, 100L, 20L);
            this.prepareFile((TsFileResource)unseqList.get(2), 99L, 1L, 30L);
            CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(seqList, unseqList);
            long originMemoryBudget = SystemInfo.getInstance().getMemorySizeForCompaction();
            SystemInfo.getInstance().setMemorySizeForCompaction(29000L * (long)IoTDBDescriptor.getInstance().getConfig().getCompactionThreadCount());
            try {
                RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
                List selected = selector.selectCrossSpaceTask(seqList, unseqList);
                Assert.assertEquals((long)1L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
                Assert.assertEquals((long)1L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
                Assert.assertEquals(seqList.get(0), ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(0));
                Assert.assertEquals(unseqList.get(0), ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(0));
                selected = selector.selectCrossSpaceTask(seqList.subList(1, seqList.size()), unseqList.subList(1, unseqList.size()));
                Assert.assertEquals((long)1L, (long)selected.size());
            }
            finally {
                SystemInfo.getInstance().setMemorySizeForCompaction(originMemoryBudget);
            }
        }
        finally {
            this.removeFiles(seqList, unseqList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnseqFilesOverlappedWithOneSeqFile() throws IOException, WriteProcessException, MergeException {
        ArrayList<TsFileResource> seqList = new ArrayList<TsFileResource>();
        ArrayList<TsFileResource> unseqList = new ArrayList<TsFileResource>();
        int seqFileNum = 5;
        for (int i = 11; i < seqFileNum + 11; ++i) {
            File file = new File(TestConstant.OUTPUT_DATA_DIR.concat(System.currentTimeMillis() + "-" + i + "-" + 10 + "-" + 0 + ".tsfile"));
            TsFileResource fileResource = new TsFileResource(file);
            fileResource.setStatusForTest(TsFileResourceStatus.NORMAL);
            this.prepareFile(fileResource, i, 1L, i);
            seqList.add(fileResource);
        }
        int unseqFileNum = 10;
        for (int i = 0; i < unseqFileNum; ++i) {
            File file = new File(TestConstant.OUTPUT_DATA_DIR.concat(System.currentTimeMillis() + "-" + i + "-" + 10 + "-" + 0 + ".tsfile"));
            TsFileResource fileResource = new TsFileResource(file);
            fileResource.setStatusForTest(TsFileResourceStatus.NORMAL);
            this.prepareFile(fileResource, i, 1L, i);
            unseqList.add(fileResource);
        }
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(seqList, unseqList);
        Assert.assertEquals((long)5L, (long)resource.getSeqFiles().size());
        Assert.assertEquals((long)10L, (long)resource.getUnseqFiles().size());
        long origin = SystemInfo.getInstance().getMemorySizeForCompaction();
        SystemInfo.getInstance().setMemorySizeForCompaction(524288000L * (long)IoTDBDescriptor.getInstance().getConfig().getCompactionThreadCount());
        try {
            RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
            List selected = selector.selectCrossSpaceTask(seqList, unseqList);
            Assert.assertEquals((long)1L, (long)selected.size());
            Assert.assertEquals((long)1L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
            Assert.assertEquals((long)10L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        }
        finally {
            SystemInfo.getInstance().setMemorySizeForCompaction(origin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOneUnseqFileOverlappedWithOneSeqFile() throws IOException, WriteProcessException, MergeException {
        ArrayList<TsFileResource> seqList = new ArrayList<TsFileResource>();
        ArrayList<TsFileResource> unseqList = new ArrayList<TsFileResource>();
        int seqFileNum = 5;
        for (int i = 11; i < seqFileNum + 11; ++i) {
            File file = new File(TestConstant.OUTPUT_DATA_DIR.concat(System.currentTimeMillis() + "-" + i + "-" + 10 + "-" + 0 + ".tsfile"));
            TsFileResource fileResource = new TsFileResource(file);
            fileResource.setStatusForTest(TsFileResourceStatus.NORMAL);
            this.prepareFile(fileResource, i, 1L, i);
            seqList.add(fileResource);
        }
        int unseqFileNum = 1;
        for (int i = 0; i < unseqFileNum; ++i) {
            File file = new File(TestConstant.OUTPUT_DATA_DIR.concat(System.currentTimeMillis() + "-" + i + "-" + 10 + "-" + 0 + ".tsfile"));
            TsFileResource fileResource = new TsFileResource(file);
            fileResource.setStatusForTest(TsFileResourceStatus.NORMAL);
            this.prepareFile(fileResource, i, 10L, i);
            unseqList.add(fileResource);
        }
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(seqList, unseqList);
        Assert.assertEquals((long)5L, (long)resource.getSeqFiles().size());
        Assert.assertEquals((long)1L, (long)resource.getUnseqFiles().size());
        long origin = SystemInfo.getInstance().getMemorySizeForCompaction();
        SystemInfo.getInstance().setMemorySizeForCompaction(524288000L * (long)IoTDBDescriptor.getInstance().getConfig().getCompactionThreadCount());
        try {
            RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
            List selected = selector.selectCrossSpaceTask(seqList, unseqList);
            Assert.assertEquals((long)1L, (long)selected.size());
            Assert.assertEquals((long)1L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
            Assert.assertEquals((long)1L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        }
        finally {
            SystemInfo.getInstance().setMemorySizeForCompaction(origin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnseqFilesOverlapped() throws IOException, WriteProcessException, MergeException {
        ArrayList<TsFileResource> seqList = new ArrayList<TsFileResource>();
        ArrayList<TsFileResource> unseqList = new ArrayList<TsFileResource>();
        int seqFileNum = 5;
        for (int i = 11; i < seqFileNum + 11; ++i) {
            File file = new File(TestConstant.OUTPUT_DATA_DIR.concat(System.currentTimeMillis() + "-" + i + "-" + 10 + "-" + 0 + ".tsfile"));
            TsFileResource fileResource = new TsFileResource(file);
            fileResource.setStatusForTest(TsFileResourceStatus.NORMAL);
            this.prepareFile(fileResource, i, 1L, i);
            seqList.add(fileResource);
        }
        int unseqFileNum = 2;
        for (int i = 0; i < unseqFileNum; ++i) {
            File file = new File(TestConstant.OUTPUT_DATA_DIR.concat(System.currentTimeMillis() + "-" + i + "-" + 10 + "-" + 0 + ".tsfile"));
            TsFileResource fileResource = new TsFileResource(file);
            fileResource.setStatusForTest(TsFileResourceStatus.NORMAL);
            unseqList.add(fileResource);
        }
        this.prepareFile((TsFileResource)unseqList.get(0), 7L, 3L, 7L);
        this.prepareFile((TsFileResource)unseqList.get(1), 10L, 4L, 10L);
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(seqList, unseqList);
        Assert.assertEquals((long)5L, (long)resource.getSeqFiles().size());
        Assert.assertEquals((long)2L, (long)resource.getUnseqFiles().size());
        long origin = SystemInfo.getInstance().getMemorySizeForCompaction();
        SystemInfo.getInstance().setMemorySizeForCompaction(524288000L * (long)IoTDBDescriptor.getInstance().getConfig().getCompactionThreadCount());
        try {
            RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
            List selected = selector.selectCrossSpaceTask(seqList, unseqList);
            Assert.assertEquals((long)1L, (long)selected.size());
            Assert.assertEquals((long)3L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
            Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        }
        finally {
            SystemInfo.getInstance().setMemorySizeForCompaction(origin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAllUnseqFilesOverlapped() throws IOException, WriteProcessException, MergeException {
        ArrayList<TsFileResource> seqList = new ArrayList<TsFileResource>();
        ArrayList<TsFileResource> unseqList = new ArrayList<TsFileResource>();
        int seqFileNum = 5;
        for (int i = 11; i < seqFileNum + 11; ++i) {
            File file = new File(TestConstant.OUTPUT_DATA_DIR.concat(System.currentTimeMillis() + "-" + i + "-" + 10 + "-" + 0 + ".tsfile"));
            TsFileResource fileResource = new TsFileResource(file);
            fileResource.setStatusForTest(TsFileResourceStatus.NORMAL);
            this.prepareFile(fileResource, i, 1L, i);
            seqList.add(fileResource);
        }
        int unseqFileNum = 4;
        for (int i = 0; i < unseqFileNum; ++i) {
            File file = new File(TestConstant.OUTPUT_DATA_DIR.concat(System.currentTimeMillis() + "-" + i + "-" + 10 + "-" + 0 + ".tsfile"));
            TsFileResource fileResource = new TsFileResource(file);
            fileResource.setStatusForTest(TsFileResourceStatus.NORMAL);
            unseqList.add(fileResource);
        }
        this.prepareFile((TsFileResource)unseqList.get(0), 7L, 3L, 7L);
        this.prepareFile((TsFileResource)unseqList.get(1), 10L, 4L, 10L);
        this.prepareFile((TsFileResource)unseqList.get(2), 14L, 3L, 14L);
        this.prepareFile((TsFileResource)unseqList.get(3), 17L, 2L, 17L);
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(seqList, unseqList);
        Assert.assertEquals((long)5L, (long)resource.getSeqFiles().size());
        Assert.assertEquals((long)4L, (long)resource.getUnseqFiles().size());
        long origin = SystemInfo.getInstance().getMemorySizeForCompaction();
        SystemInfo.getInstance().setMemorySizeForCompaction(524288000L * (long)IoTDBDescriptor.getInstance().getConfig().getCompactionThreadCount());
        try {
            RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
            List selected = selector.selectCrossSpaceTask(seqList, unseqList);
            Assert.assertEquals((long)1L, (long)selected.size());
            Assert.assertEquals((long)5L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
            Assert.assertEquals((long)4L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        }
        finally {
            SystemInfo.getInstance().setMemorySizeForCompaction(origin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAllUnseqFilesOverlappedWithSeqFileOpen() throws IOException, WriteProcessException, MergeException {
        ArrayList<TsFileResource> seqList = new ArrayList<TsFileResource>();
        ArrayList<TsFileResource> unseqList = new ArrayList<TsFileResource>();
        int seqFileNum = 5;
        for (int i = 11; i < seqFileNum + 11; ++i) {
            File file = new File(TestConstant.OUTPUT_DATA_DIR.concat(System.currentTimeMillis() + "-" + i + "-" + 10 + "-" + 0 + ".tsfile"));
            TsFileResource fileResource = new TsFileResource(file);
            if (i - 11 != 3) {
                fileResource.setStatusForTest(TsFileResourceStatus.NORMAL);
            }
            this.prepareFile(fileResource, i, 1L, i);
            seqList.add(fileResource);
        }
        int unseqFileNum = 4;
        for (int i = 0; i < unseqFileNum; ++i) {
            File file = new File(TestConstant.OUTPUT_DATA_DIR.concat(System.currentTimeMillis() + "-" + i + "-" + 10 + "-" + 0 + ".tsfile"));
            TsFileResource fileResource = new TsFileResource(file);
            fileResource.setStatusForTest(TsFileResourceStatus.NORMAL);
            unseqList.add(fileResource);
        }
        this.prepareFile((TsFileResource)unseqList.get(0), 7L, 3L, 7L);
        this.prepareFile((TsFileResource)unseqList.get(1), 10L, 4L, 10L);
        this.prepareFile((TsFileResource)unseqList.get(2), 14L, 3L, 14L);
        this.prepareFile((TsFileResource)unseqList.get(3), 17L, 2L, 17L);
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(seqList, unseqList);
        Assert.assertEquals((long)5L, (long)resource.getSeqFiles().size());
        Assert.assertEquals((long)4L, (long)resource.getUnseqFiles().size());
        long origin = SystemInfo.getInstance().getMemorySizeForCompaction();
        SystemInfo.getInstance().setMemorySizeForCompaction(524288000L * (long)IoTDBDescriptor.getInstance().getConfig().getCompactionThreadCount());
        try {
            RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
            List selected = selector.selectCrossSpaceTask(seqList, unseqList);
            Assert.assertEquals((long)1L, (long)selected.size());
            Assert.assertEquals((long)3L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
            Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        }
        finally {
            SystemInfo.getInstance().setMemorySizeForCompaction(origin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiFileOverlapWithOneFile() throws IOException, WriteProcessException, MergeException {
        ArrayList<TsFileResource> seqList = new ArrayList<TsFileResource>();
        ArrayList<TsFileResource> unseqList = new ArrayList<TsFileResource>();
        File firstFile = new File(TestConstant.OUTPUT_DATA_DIR.concat("1-1-0-0.tsfile"));
        TsFileResource firstTsFileResource = new TsFileResource(firstFile);
        firstTsFileResource.setStatusForTest(TsFileResourceStatus.NORMAL);
        firstTsFileResource.setMinPlanIndex(1L);
        firstTsFileResource.setMaxPlanIndex(1L);
        firstTsFileResource.setVersion(1L);
        seqList.add(firstTsFileResource);
        if (!firstFile.getParentFile().exists()) {
            Assert.assertTrue((boolean)firstFile.getParentFile().mkdirs());
        }
        TsFileWriter fileWriter = new TsFileWriter(firstFile);
        for (IDeviceID deviceId : this.deviceIds) {
            for (MeasurementSchema measurementSchema : this.measurementSchemas) {
                fileWriter.registerTimeseries(new Path(deviceId), measurementSchema);
            }
        }
        for (long i = 0L; i < 10L; ++i) {
            for (int j = 0; j < this.deviceNum; ++j) {
                if (j == 3 && i > 5L) continue;
                TSRecord record = new TSRecord(i, this.deviceIds[j]);
                for (int k = 0; k < this.measurementNum; ++k) {
                    record.addTuple(DataPoint.getDataPoint((TSDataType)this.measurementSchemas[k].getType(), (String)this.measurementSchemas[k].getMeasurementId(), (String)String.valueOf(i)));
                }
                fileWriter.write(record);
                firstTsFileResource.updateStartTime(this.deviceIds[j], i);
                firstTsFileResource.updateEndTime(this.deviceIds[j], i);
            }
        }
        fileWriter.flushAllChunkGroups();
        fileWriter.close();
        File secondFile = new File(TestConstant.OUTPUT_DATA_DIR.concat("2-2-0-0.tsfile"));
        TsFileResource secondTsFileResource = new TsFileResource(secondFile);
        secondTsFileResource.setStatusForTest(TsFileResourceStatus.NORMAL);
        secondTsFileResource.setMinPlanIndex(2L);
        secondTsFileResource.setMaxPlanIndex(2L);
        secondTsFileResource.setVersion(2L);
        seqList.add(secondTsFileResource);
        if (!secondFile.getParentFile().exists()) {
            Assert.assertTrue((boolean)secondFile.getParentFile().mkdirs());
        }
        fileWriter = new TsFileWriter(secondFile);
        for (IDeviceID deviceId : this.deviceIds) {
            for (MeasurementSchema measurementSchema : this.measurementSchemas) {
                fileWriter.registerTimeseries(new Path(deviceId), measurementSchema);
            }
        }
        for (long i = 11L; i < 21L; ++i) {
            for (int j = 0; j < this.deviceNum; ++j) {
                TSRecord record = new TSRecord(i, this.deviceIds[j]);
                for (int k = 0; k < this.measurementNum; ++k) {
                    record.addTuple(DataPoint.getDataPoint((TSDataType)this.measurementSchemas[k].getType(), (String)this.measurementSchemas[k].getMeasurementId(), (String)String.valueOf(i)));
                }
                fileWriter.write(record);
                secondTsFileResource.updateStartTime(this.deviceIds[j], i);
                secondTsFileResource.updateEndTime(this.deviceIds[j], i);
            }
        }
        fileWriter.flushAllChunkGroups();
        fileWriter.close();
        File thirdFile = new File(TestConstant.OUTPUT_DATA_DIR.concat("3-3-0-0.tsfile"));
        TsFileResource thirdTsFileResource = new TsFileResource(thirdFile);
        thirdTsFileResource.setStatusForTest(TsFileResourceStatus.NORMAL);
        thirdTsFileResource.setMinPlanIndex(3L);
        thirdTsFileResource.setMaxPlanIndex(3L);
        thirdTsFileResource.setVersion(3L);
        unseqList.add(thirdTsFileResource);
        if (!secondFile.getParentFile().exists()) {
            Assert.assertTrue((boolean)thirdFile.getParentFile().mkdirs());
        }
        fileWriter = new TsFileWriter(thirdFile);
        for (IDeviceID deviceId : this.deviceIds) {
            for (MeasurementSchema measurementSchema : this.measurementSchemas) {
                fileWriter.registerTimeseries(new Path(deviceId), measurementSchema);
            }
        }
        for (long i = 0L; i < 2L; ++i) {
            for (int j = 0; j < this.deviceNum; ++j) {
                TSRecord record = new TSRecord(i, this.deviceIds[j]);
                for (int k = 0; k < this.measurementNum; ++k) {
                    record.addTuple(DataPoint.getDataPoint((TSDataType)this.measurementSchemas[k].getType(), (String)this.measurementSchemas[k].getMeasurementId(), (String)String.valueOf(i)));
                }
                fileWriter.write(record);
                thirdTsFileResource.updateStartTime(this.deviceIds[j], i);
                thirdTsFileResource.updateEndTime(this.deviceIds[j], i);
            }
        }
        fileWriter.flushAllChunkGroups();
        fileWriter.close();
        File fourthFile = new File(TestConstant.OUTPUT_DATA_DIR.concat("4-4-0-0.tsfile"));
        TsFileResource fourthTsFileResource = new TsFileResource(fourthFile);
        fourthTsFileResource.setStatusForTest(TsFileResourceStatus.NORMAL);
        fourthTsFileResource.setMinPlanIndex(4L);
        fourthTsFileResource.setMaxPlanIndex(4L);
        fourthTsFileResource.setVersion(4L);
        unseqList.add(fourthTsFileResource);
        if (!fourthFile.getParentFile().exists()) {
            Assert.assertTrue((boolean)fourthFile.getParentFile().mkdirs());
        }
        fileWriter = new TsFileWriter(fourthFile);
        for (IDeviceID deviceId : this.deviceIds) {
            for (MeasurementSchema measurementSchema : this.measurementSchemas) {
                fileWriter.registerTimeseries(new Path(deviceId), measurementSchema);
            }
        }
        for (long i = 6L; i < 15L; ++i) {
            for (int j = 0; j < this.deviceNum; ++j) {
                if (j == 3) continue;
                TSRecord record = new TSRecord(i, this.deviceIds[j]);
                for (int k = 0; k < this.measurementNum; ++k) {
                    record.addTuple(DataPoint.getDataPoint((TSDataType)this.measurementSchemas[k].getType(), (String)this.measurementSchemas[k].getMeasurementId(), (String)String.valueOf(i)));
                }
                fileWriter.write(record);
                fourthTsFileResource.updateStartTime(this.deviceIds[j], i);
                fourthTsFileResource.updateEndTime(this.deviceIds[j], i);
            }
        }
        TSRecord record = new TSRecord(1L, this.deviceIds[3]);
        for (int k = 0; k < this.measurementNum; ++k) {
            record.addTuple(DataPoint.getDataPoint((TSDataType)this.measurementSchemas[k].getType(), (String)this.measurementSchemas[k].getMeasurementId(), (String)String.valueOf(1)));
        }
        fileWriter.write(record);
        fourthTsFileResource.updateStartTime(this.deviceIds[3], 1L);
        fourthTsFileResource.updateEndTime(this.deviceIds[3], 1L);
        fileWriter.flushAllChunkGroups();
        fileWriter.close();
        long origin = SystemInfo.getInstance().getMemorySizeForCompaction();
        SystemInfo.getInstance().setMemorySizeForCompaction(524288000L * (long)IoTDBDescriptor.getInstance().getConfig().getCompactionThreadCount());
        try {
            RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
            List selected = selector.selectCrossSpaceTask(seqList, unseqList);
            Assert.assertEquals((long)1L, (long)selected.size());
            Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
            Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        }
        finally {
            SystemInfo.getInstance().setMemorySizeForCompaction(origin);
        }
    }

    @Test
    public void testMaxFileSelection() throws MergeException, IOException {
        int oldMaxCrossCompactionCandidateFileNum = IoTDBDescriptor.getInstance().getConfig().getFileLimitPerCrossTask();
        IoTDBDescriptor.getInstance().getConfig().setFileLimitPerCrossTask(5);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)1L, (long)selected.size());
        List seqSelected = ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles();
        List unseqSelected = ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles();
        Assert.assertEquals((long)2L, (long)seqSelected.size());
        Assert.assertEquals((long)2L, (long)unseqSelected.size());
        IoTDBDescriptor.getInstance().getConfig().setFileLimitPerCrossTask(oldMaxCrossCompactionCandidateFileNum);
    }

    @Test
    public void testAtLeastOneUnseqFileBeenSelected() throws IOException, MergeException {
        int maxCrossFilesNum = IoTDBDescriptor.getInstance().getConfig().getFileLimitPerCrossTask();
        IoTDBDescriptor.getInstance().getConfig().setFileLimitPerCrossTask(1);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)1L, (long)selected.size());
        List seqSelected = ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles();
        List unseqSelected = ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles();
        Assert.assertEquals((long)1L, (long)seqSelected.size());
        Assert.assertEquals((long)1L, (long)unseqSelected.size());
        IoTDBDescriptor.getInstance().getConfig().setFileLimitPerCrossTask(maxCrossFilesNum);
    }

    @Test
    public void testDeleteInSelection() throws Exception {
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        AtomicBoolean fail = new AtomicBoolean(false);
        Thread thread1 = new Thread(() -> {
            try {
                Thread.sleep(1000L);
                List list = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
            }
            catch (Exception e) {
                logger.error("Exception occurs", (Throwable)e);
                fail.set(true);
            }
        });
        Thread thread2 = new Thread(() -> {
            if (!((TsFileResource)this.seqResources.get(0)).remove()) {
                fail.set(true);
            }
            if (!((TsFileResource)this.unseqResources.get(0)).remove()) {
                fail.set(true);
            }
        });
        thread1.start();
        thread2.start();
        thread1.join();
        thread2.join();
        if (fail.get()) {
            Assert.fail();
        }
    }

    @Test
    public void testDeleteAndDegradeInSelection() throws Exception {
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        AtomicBoolean fail = new AtomicBoolean(false);
        Thread thread1 = new Thread(() -> {
            try {
                Thread.sleep(1000L);
                List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
                Assert.assertEquals((long)1L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
                Assert.assertEquals((long)1L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
            }
            catch (Exception e) {
                logger.error("Exception occurs", (Throwable)e);
                fail.set(true);
            }
        });
        Thread thread2 = new Thread(() -> {
            ((TsFileResource)this.seqResources.get(1)).degradeTimeIndex();
            if (!((TsFileResource)this.seqResources.get(1)).remove()) {
                fail.set(true);
            }
        });
        thread1.start();
        thread2.start();
        thread1.join();
        thread2.join();
        if (fail.get()) {
            Assert.fail();
        }
    }

    @Test
    public void testFirstZeroLevelUnseqFileIsLarge() {
        IoTDBDescriptor.getInstance().getConfig().setMinCrossCompactionUnseqFileLevel(1);
        IoTDBDescriptor.getInstance().getConfig().setTargetCompactionFileSize(((TsFileResource)this.unseqResources.get(5)).getTsFileSize());
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources.subList(5, 6));
        Assert.assertEquals((long)1L, (long)selected.size());
    }
}

