/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.cross;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.storageengine.buffer.ChunkCache;
import org.apache.iotdb.db.storageengine.buffer.TimeSeriesMetadataCache;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.CompactionConfigRestorer;
import org.apache.iotdb.db.storageengine.dataregion.read.control.FileReaderManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.PlainDeviceID;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.write.TsFileWriter;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

abstract class MergeTest {
    static final String MERGE_TEST_SG = "root.mergeTest";
    int seqFileNum = 5;
    int unseqFileNum = 5;
    int measurementNum = 10;
    int deviceNum = 10;
    long ptNum = 100L;
    long flushInterval = 20L;
    TSEncoding encoding = TSEncoding.PLAIN;
    IDeviceID[] deviceIds;
    MeasurementSchema[] measurementSchemas;
    List<TsFileResource> seqResources = new ArrayList<TsFileResource>();
    List<TsFileResource> unseqResources = new ArrayList<TsFileResource>();

    MergeTest() {
    }

    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException {
        EnvironmentUtils.envSetUp();
        this.prepareSeries();
        this.prepareFiles(this.seqFileNum, this.unseqFileNum);
    }

    @After
    public void tearDown() throws IOException, StorageEngineException {
        new CompactionConfigRestorer().restoreCompactionConfig();
        this.removeFiles(this.seqResources, this.unseqResources);
        this.seqResources.clear();
        this.unseqResources.clear();
        ChunkCache.getInstance().clear();
        TimeSeriesMetadataCache.getInstance().clear();
        EnvironmentUtils.cleanEnv();
    }

    private void prepareSeries() throws MetadataException {
        int i;
        this.measurementSchemas = new MeasurementSchema[this.measurementNum];
        for (i = 0; i < this.measurementNum; ++i) {
            this.measurementSchemas[i] = new MeasurementSchema("sensor" + i, TSDataType.DOUBLE, this.encoding, CompressionType.UNCOMPRESSED);
        }
        this.deviceIds = new IDeviceID[this.deviceNum];
        for (i = 0; i < this.deviceNum; ++i) {
            this.deviceIds[i] = new PlainDeviceID("root.mergeTest.device" + i);
        }
    }

    void prepareFiles(int seqFileNum, int unseqFileNum) throws IOException, WriteProcessException {
        TsFileResource tsFileResource;
        File file;
        int i;
        for (i = 0; i < seqFileNum; ++i) {
            file = new File(TestConstant.getTestTsFilePath((String)"root.sg1", (long)0L, (long)0L, (long)i));
            this.mkdirs(file);
            tsFileResource = new TsFileResource(file);
            tsFileResource.setStatusForTest(TsFileResourceStatus.NORMAL);
            tsFileResource.setMinPlanIndex((long)i);
            tsFileResource.setMaxPlanIndex((long)i);
            tsFileResource.setVersion((long)i);
            this.seqResources.add(tsFileResource);
            this.prepareFile(tsFileResource, (long)i * this.ptNum, this.ptNum, 0L);
        }
        for (i = 0; i < unseqFileNum; ++i) {
            file = new File(TestConstant.getTestTsFilePath((String)"root.sg1", (long)0L, (long)0L, (long)(i + seqFileNum)));
            this.mkdirs(file);
            tsFileResource = new TsFileResource(file);
            tsFileResource.setStatusForTest(TsFileResourceStatus.NORMAL);
            tsFileResource.setMinPlanIndex((long)(i + seqFileNum));
            tsFileResource.setMaxPlanIndex((long)(i + seqFileNum));
            tsFileResource.setVersion((long)(i + seqFileNum));
            this.unseqResources.add(tsFileResource);
            this.prepareFile(tsFileResource, (long)i * this.ptNum, this.ptNum * (long)(i + 1) / (long)unseqFileNum, 10000L);
        }
        File file2 = new File(TestConstant.getTestTsFilePath((String)"root.sg1", (long)0L, (long)0L, (long)(seqFileNum + unseqFileNum)));
        this.mkdirs(file2);
        TsFileResource tsFileResource2 = new TsFileResource(file2);
        tsFileResource2.setStatusForTest(TsFileResourceStatus.NORMAL);
        tsFileResource2.setMinPlanIndex((long)(seqFileNum + unseqFileNum));
        tsFileResource2.setMaxPlanIndex((long)(seqFileNum + unseqFileNum));
        tsFileResource2.setVersion((long)(seqFileNum + unseqFileNum));
        this.unseqResources.add(tsFileResource2);
        this.prepareFile(tsFileResource2, 0L, this.ptNum * (long)unseqFileNum, 20000L);
    }

    void removeFiles(List<TsFileResource> seqResList, List<TsFileResource> unseqResList) throws IOException {
        for (TsFileResource tsFileResource : seqResList) {
            tsFileResource.remove();
            tsFileResource.getModFile().remove();
        }
        for (TsFileResource tsFileResource : unseqResList) {
            tsFileResource.remove();
            tsFileResource.getModFile().remove();
        }
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
    }

    void prepareFile(TsFileResource tsFileResource, long timeOffset, long ptNum, long valueOffset) throws IOException, WriteProcessException {
        TsFileWriter fileWriter = new TsFileWriter(tsFileResource.getTsFile());
        for (IDeviceID deviceId : this.deviceIds) {
            for (MeasurementSchema measurementSchema : this.measurementSchemas) {
                fileWriter.registerTimeseries(new Path(deviceId), measurementSchema);
            }
        }
        for (long i = timeOffset; i < timeOffset + ptNum; ++i) {
            for (int j = 0; j < this.deviceNum; ++j) {
                TSRecord record = new TSRecord(i, ((PlainDeviceID)this.deviceIds[j]).toStringID());
                for (int k = 0; k < this.measurementNum; ++k) {
                    record.addTuple(DataPoint.getDataPoint((TSDataType)this.measurementSchemas[k].getType(), (String)this.measurementSchemas[k].getMeasurementId(), (String)String.valueOf(i + valueOffset)));
                }
                fileWriter.write(record);
                tsFileResource.updateStartTime(this.deviceIds[j], i);
                tsFileResource.updateEndTime(this.deviceIds[j], i);
            }
            if ((i + 1L) % this.flushInterval != 0L) continue;
            fileWriter.flushAllChunkGroups();
        }
        fileWriter.close();
        tsFileResource.serialize();
    }

    void mkdirs(File file) {
        if (!file.getParentFile().exists()) {
            Assert.assertTrue((boolean)file.getParentFile().mkdirs());
        }
    }
}

