/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.cross;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Phaser;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.storageengine.dataregion.compaction.AbstractCompactionTest;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.AbstractCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.InsertionCrossSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionWorker;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.comparator.DefaultCompactionTaskComparatorImpl;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.impl.RewriteCrossSpaceCompactionSelector;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.utils.InsertionCrossCompactionTaskResource;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.CompactionTestFileWriter;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.generator.TsFileNameGenerator;
import org.apache.iotdb.db.storageengine.rescon.memory.TsFileResourceManager;
import org.apache.iotdb.db.utils.datastructure.FixedPriorityBlockingQueue;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InsertionCrossSpaceCompactionTest
extends AbstractCompactionTest {
    private final FixedPriorityBlockingQueue<AbstractCompactionTask> candidateCompactionTaskQueue = new FixedPriorityBlockingQueue(50, (Comparator)new DefaultCompactionTaskComparatorImpl());
    private final CompactionWorker worker = new CompactionWorker(0, this.candidateCompactionTaskQueue);
    private boolean enableInsertionCrossSpaceCompaction;

    @Override
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException, InterruptedException {
        super.setUp();
        this.enableInsertionCrossSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableCrossSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableCrossSpaceCompaction(true);
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        IoTDBDescriptor.getInstance().getConfig().setEnableCrossSpaceCompaction(this.enableInsertionCrossSpaceCompaction);
        super.tearDown();
    }

    @Test
    public void test1() throws IOException, InterruptedException {
        TsFileResource seqResource1 = this.generateSingleNonAlignedSeriesFileWithDevices("1-1-0-0.tsfile", new String[]{"d1"}, new TimeRange[]{new TimeRange(10L, 20L)}, true);
        seqResource1.setStatusForTest(TsFileResourceStatus.NORMAL);
        TsFileResource seqResource2 = this.generateSingleNonAlignedSeriesFileWithDevices("3-3-0-0.tsfile", new String[]{"d1"}, new TimeRange[]{new TimeRange(40L, 50L)}, true);
        seqResource2.setStatusForTest(TsFileResourceStatus.NORMAL);
        TsFileResource unseqResource1 = this.generateSingleNonAlignedSeriesFileWithDevices("2-2-0-0.tsfile", new String[]{"d1"}, new TimeRange[]{new TimeRange(30L, 34L)}, false);
        unseqResource1.setStatusForTest(TsFileResourceStatus.NORMAL);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector(COMPACTION_TEST_SG, "0", 0L, this.tsFileManager);
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        this.unseqResources.add(unseqResource1);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        List tasks = selector.selectInsertionCrossSpaceTask((List)this.tsFileManager.getOrCreateSequenceListByTimePartition(0L), (List)this.tsFileManager.getOrCreateUnsequenceListByTimePartition(0L));
        Assert.assertEquals((long)1L, (long)tasks.size());
        InsertionCrossSpaceCompactionTask task = new InsertionCrossSpaceCompactionTask(new Phaser(1), 0L, this.tsFileManager, (InsertionCrossCompactionTaskResource)tasks.get(0), 0L);
        task.setSourceFilesToCompactionCandidate();
        this.candidateCompactionTaskQueue.put((Object)task);
        Assert.assertTrue((boolean)this.worker.processOneCompactionTask((AbstractCompactionTask)this.candidateCompactionTaskQueue.take()));
        Assert.assertEquals((long)3L, (long)this.tsFileManager.getTsFileList(true).size());
        Assert.assertEquals((Object)seqResource1, this.tsFileManager.getTsFileList(true).get(0));
        Assert.assertEquals((Object)seqResource2, this.tsFileManager.getTsFileList(true).get(2));
        TsFileResource targetFile = (TsFileResource)this.tsFileManager.getTsFileList(true).get(1);
        long timestamp = TsFileNameGenerator.getTsFileName((String)targetFile.getTsFile().getName()).getTime();
        Assert.assertEquals((long)2L, (long)timestamp);
        Assert.assertTrue((boolean)this.tsFileManager.getTsFileList(false).isEmpty());
    }

    @Test
    public void test2() throws IOException, InterruptedException {
        TsFileResource seqResource1 = this.generateSingleNonAlignedSeriesFileWithDevices("1-1-0-0.tsfile", new String[]{"d1"}, new TimeRange[]{new TimeRange(10L, 20L)}, true);
        seqResource1.setStatusForTest(TsFileResourceStatus.NORMAL);
        TsFileResource unseqResource1 = this.generateSingleNonAlignedSeriesFileWithDevices("2-2-0-0.tsfile", new String[]{"d1"}, new TimeRange[]{new TimeRange(30L, 34L)}, false);
        unseqResource1.setStatusForTest(TsFileResourceStatus.NORMAL);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector(COMPACTION_TEST_SG, "0", 0L, this.tsFileManager);
        this.seqResources.add(seqResource1);
        this.unseqResources.add(unseqResource1);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        List tasks = selector.selectInsertionCrossSpaceTask((List)this.tsFileManager.getOrCreateSequenceListByTimePartition(0L), (List)this.tsFileManager.getOrCreateUnsequenceListByTimePartition(0L));
        Assert.assertEquals((long)1L, (long)tasks.size());
        InsertionCrossSpaceCompactionTask task = new InsertionCrossSpaceCompactionTask(new Phaser(1), 0L, this.tsFileManager, (InsertionCrossCompactionTaskResource)tasks.get(0), 0L);
        task.setSourceFilesToCompactionCandidate();
        this.candidateCompactionTaskQueue.put((Object)task);
        Assert.assertTrue((boolean)this.worker.processOneCompactionTask((AbstractCompactionTask)this.candidateCompactionTaskQueue.take()));
        Assert.assertEquals((long)2L, (long)this.tsFileManager.getTsFileList(true).size());
        Assert.assertEquals((Object)seqResource1, this.tsFileManager.getTsFileList(true).get(0));
        Assert.assertTrue((boolean)this.tsFileManager.getTsFileList(false).isEmpty());
        TsFileResource targetFile = (TsFileResource)this.tsFileManager.getTsFileList(true).get(1);
        long timestamp = TsFileNameGenerator.getTsFileName((String)targetFile.getTsFile().getName()).getTime();
        Assert.assertEquals((long)2L, (long)timestamp);
    }

    @Test
    public void test3() throws IOException, InterruptedException {
        TsFileResource seqResource1 = this.generateSingleNonAlignedSeriesFileWithDevices("1-1-0-0.tsfile", new String[]{"d1"}, new TimeRange[]{new TimeRange(10L, 20L)}, true);
        seqResource1.setStatusForTest(TsFileResourceStatus.NORMAL);
        TsFileResource unseqResource1 = this.generateSingleNonAlignedSeriesFileWithDevices("2-2-0-0.tsfile", new String[]{"d1"}, new TimeRange[]{new TimeRange(1L, 4L)}, false);
        unseqResource1.setStatusForTest(TsFileResourceStatus.NORMAL);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector(COMPACTION_TEST_SG, "0", 0L, this.tsFileManager);
        this.seqResources.add(seqResource1);
        this.unseqResources.add(unseqResource1);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        List tasks = selector.selectInsertionCrossSpaceTask((List)this.tsFileManager.getOrCreateSequenceListByTimePartition(0L), (List)this.tsFileManager.getOrCreateUnsequenceListByTimePartition(0L));
        Assert.assertEquals((long)1L, (long)tasks.size());
        InsertionCrossSpaceCompactionTask task = new InsertionCrossSpaceCompactionTask(new Phaser(1), 0L, this.tsFileManager, (InsertionCrossCompactionTaskResource)tasks.get(0), 0L);
        task.setSourceFilesToCompactionCandidate();
        this.candidateCompactionTaskQueue.put((Object)task);
        Assert.assertTrue((boolean)this.worker.processOneCompactionTask((AbstractCompactionTask)this.candidateCompactionTaskQueue.take()));
        Assert.assertEquals((long)2L, (long)this.tsFileManager.getTsFileList(true).size());
        Assert.assertEquals((Object)seqResource1, this.tsFileManager.getTsFileList(true).get(1));
        Assert.assertTrue((boolean)this.tsFileManager.getTsFileList(false).isEmpty());
        TsFileResource targetFile = (TsFileResource)this.tsFileManager.getTsFileList(true).get(0);
        long timestamp = TsFileNameGenerator.getTsFileName((String)targetFile.getTsFile().getName()).getTime();
        Assert.assertEquals((long)0L, (long)timestamp);
    }

    @Test
    public void test4() throws IOException, InterruptedException {
        TsFileResource seqResource1 = this.generateSingleNonAlignedSeriesFileWithDevices("2-1-0-0.tsfile", new String[]{"d1"}, new TimeRange[]{new TimeRange(10L, 20L)}, true);
        seqResource1.setStatusForTest(TsFileResourceStatus.NORMAL);
        TsFileResource seqResource2 = this.generateSingleNonAlignedSeriesFileWithDevices("6-3-0-0.tsfile", new String[]{"d1"}, new TimeRange[]{new TimeRange(40L, 50L)}, true);
        seqResource2.setStatusForTest(TsFileResourceStatus.NORMAL);
        TsFileResource unseqResource1 = this.generateSingleNonAlignedSeriesFileWithDevices("3-2-0-0.tsfile", new String[]{"d1"}, new TimeRange[]{new TimeRange(30L, 34L)}, false);
        unseqResource1.setStatusForTest(TsFileResourceStatus.NORMAL);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector(COMPACTION_TEST_SG, "0", 0L, this.tsFileManager);
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        this.unseqResources.add(unseqResource1);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        List tasks = selector.selectInsertionCrossSpaceTask((List)this.tsFileManager.getOrCreateSequenceListByTimePartition(0L), (List)this.tsFileManager.getOrCreateUnsequenceListByTimePartition(0L));
        Assert.assertEquals((long)1L, (long)tasks.size());
        InsertionCrossSpaceCompactionTask task = new InsertionCrossSpaceCompactionTask(new Phaser(1), 0L, this.tsFileManager, (InsertionCrossCompactionTaskResource)tasks.get(0), 0L);
        task.setSourceFilesToCompactionCandidate();
        this.candidateCompactionTaskQueue.put((Object)task);
        Assert.assertTrue((boolean)this.worker.processOneCompactionTask((AbstractCompactionTask)this.candidateCompactionTaskQueue.take()));
        Assert.assertEquals((long)3L, (long)this.tsFileManager.getTsFileList(true).size());
        Assert.assertEquals((Object)seqResource1, this.tsFileManager.getTsFileList(true).get(0));
        Assert.assertEquals((Object)seqResource2, this.tsFileManager.getTsFileList(true).get(2));
        TsFileResource targetFile = (TsFileResource)this.tsFileManager.getTsFileList(true).get(1);
        long timestamp = TsFileNameGenerator.getTsFileName((String)targetFile.getTsFile().getName()).getTime();
        Assert.assertEquals((long)4L, (long)timestamp);
        Assert.assertTrue((boolean)this.tsFileManager.getTsFileList(false).isEmpty());
    }

    @Test
    public void test5() throws IOException, InterruptedException {
        TsFileResource unseqResource1 = this.generateSingleNonAlignedSeriesFileWithDevices("2-2-0-0.tsfile", new String[]{"d1"}, new TimeRange[]{new TimeRange(1L, 4L)}, false);
        unseqResource1.setStatusForTest(TsFileResourceStatus.NORMAL);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector(COMPACTION_TEST_SG, "0", 0L, this.tsFileManager);
        this.unseqResources.add(unseqResource1);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        List tasks = selector.selectInsertionCrossSpaceTask((List)this.tsFileManager.getOrCreateSequenceListByTimePartition(0L), (List)this.tsFileManager.getOrCreateUnsequenceListByTimePartition(0L));
        Assert.assertEquals((long)1L, (long)tasks.size());
        InsertionCrossSpaceCompactionTask task = new InsertionCrossSpaceCompactionTask(new Phaser(1), 0L, this.tsFileManager, (InsertionCrossCompactionTaskResource)tasks.get(0), 0L);
        task.setSourceFilesToCompactionCandidate();
        this.candidateCompactionTaskQueue.put((Object)task);
        Assert.assertTrue((boolean)this.worker.processOneCompactionTask((AbstractCompactionTask)this.candidateCompactionTaskQueue.take()));
        Assert.assertEquals((long)1L, (long)this.tsFileManager.getTsFileList(true).size());
        Assert.assertTrue((boolean)this.tsFileManager.getTsFileList(false).isEmpty());
        TsFileResource targetFile = (TsFileResource)this.tsFileManager.getTsFileList(true).get(0);
        long timestamp = TsFileNameGenerator.getTsFileName((String)targetFile.getTsFile().getName()).getTime();
        Assert.assertEquals((long)2L, (long)timestamp);
    }

    @Test
    public void testInsertionCompactionSchedule() throws IOException, InterruptedException {
        TsFileResource seqResource1 = this.generateSingleNonAlignedSeriesFileWithDevices("1-1-0-0.tsfile", new String[]{"d1"}, new TimeRange[]{new TimeRange(1L, 4L)}, true);
        seqResource1.setStatusForTest(TsFileResourceStatus.NORMAL);
        TsFileResource seqResource2 = this.generateSingleNonAlignedSeriesFileWithDevices("8-8-0-0.tsfile", new String[]{"d1"}, new TimeRange[]{new TimeRange(100L, 400L)}, true);
        seqResource2.setStatusForTest(TsFileResourceStatus.NORMAL);
        TsFileResource unseqResource1 = this.generateSingleNonAlignedSeriesFileWithDevices("2-2-0-0.tsfile", new String[]{"d1"}, new TimeRange[]{new TimeRange(10L, 40L)}, false);
        unseqResource1.setStatusForTest(TsFileResourceStatus.NORMAL);
        TsFileResource unseqResource2 = this.generateSingleNonAlignedSeriesFileWithDevices("3-3-0-0.tsfile", new String[]{"d1"}, new TimeRange[]{new TimeRange(60L, 90L)}, false);
        unseqResource2.setStatusForTest(TsFileResourceStatus.NORMAL);
        TsFileResource unseqResource3 = this.generateSingleNonAlignedSeriesFileWithDevices("4-4-0-0.tsfile", new String[]{"d1"}, new TimeRange[]{new TimeRange(110L, 1400L)}, false);
        unseqResource3.setStatusForTest(TsFileResourceStatus.NORMAL);
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        this.unseqResources.add(unseqResource1);
        this.unseqResources.add(unseqResource2);
        this.unseqResources.add(unseqResource3);
        DataRegionForCompactionTest dataRegion = this.createDataRegion();
        TsFileManager tsFileManager = dataRegion.getTsFileManager();
        tsFileManager.addAll(this.seqResources, true);
        tsFileManager.addAll(this.unseqResources, false);
        Assert.assertEquals((long)2L, (long)dataRegion.executeInsertionCompaction());
        Assert.assertEquals((long)4L, (long)tsFileManager.getTsFileList(true).size());
        Assert.assertEquals((long)1L, (long)tsFileManager.getTsFileList(false).size());
        TsFileResource targetFile1 = (TsFileResource)tsFileManager.getTsFileList(true).get(1);
        long timestamp = TsFileNameGenerator.getTsFileName((String)targetFile1.getTsFile().getName()).getTime();
        Assert.assertEquals((long)4L, (long)timestamp);
        TsFileResource targetFile2 = (TsFileResource)tsFileManager.getTsFileList(true).get(2);
        timestamp = TsFileNameGenerator.getTsFileName((String)targetFile2.getTsFile().getName()).getTime();
        Assert.assertEquals((long)6L, (long)timestamp);
    }

    @Test
    public void testInsertionCompactionScheduleWithEmptySeqSpace() throws IOException, InterruptedException {
        TsFileResource unseqResource1 = this.generateSingleNonAlignedSeriesFileWithDevices("2-2-0-0.tsfile", new String[]{"d1"}, new TimeRange[]{new TimeRange(1L, 4L)}, false);
        unseqResource1.setStatusForTest(TsFileResourceStatus.NORMAL);
        TsFileResource unseqResource2 = this.generateSingleNonAlignedSeriesFileWithDevices("3-3-0-0.tsfile", new String[]{"d1"}, new TimeRange[]{new TimeRange(6L, 9L)}, false);
        unseqResource2.setStatusForTest(TsFileResourceStatus.NORMAL);
        TsFileResource unseqResource3 = this.generateSingleNonAlignedSeriesFileWithDevices("4-4-0-0.tsfile", new String[]{"d1"}, new TimeRange[]{new TimeRange(11L, 14L)}, false);
        unseqResource3.setStatusForTest(TsFileResourceStatus.NORMAL);
        this.unseqResources.add(unseqResource1);
        this.unseqResources.add(unseqResource2);
        this.unseqResources.add(unseqResource3);
        DataRegionForCompactionTest dataRegion = this.createDataRegion();
        TsFileManager tsFileManager = dataRegion.getTsFileManager();
        tsFileManager.addAll(this.seqResources, true);
        tsFileManager.addAll(this.unseqResources, false);
        Assert.assertEquals((long)3L, (long)dataRegion.executeInsertionCompaction());
        Assert.assertEquals((long)3L, (long)tsFileManager.getTsFileList(true).size());
        TsFileResource targetFile1 = (TsFileResource)tsFileManager.getTsFileList(true).get(0);
        long timestamp = TsFileNameGenerator.getTsFileName((String)targetFile1.getTsFile().getName()).getTime();
        Assert.assertEquals((long)2L, (long)timestamp);
        TsFileResource targetFile2 = (TsFileResource)tsFileManager.getTsFileList(true).get(1);
        timestamp = TsFileNameGenerator.getTsFileName((String)targetFile2.getTsFile().getName()).getTime();
        Assert.assertEquals((long)3L, (long)timestamp);
        TsFileResource targetFile3 = (TsFileResource)tsFileManager.getTsFileList(true).get(2);
        timestamp = TsFileNameGenerator.getTsFileName((String)targetFile3.getTsFile().getName()).getTime();
        Assert.assertEquals((long)4L, (long)timestamp);
    }

    @Test
    public void testInsertionCompactionScheduleWithEmptySeqSpace2() throws IOException, InterruptedException {
        TsFileResource unseqResource0 = this.generateSingleNonAlignedSeriesFileWithDevices("1-1-0-0.tsfile", new String[]{"d1"}, new TimeRange[]{new TimeRange(3L, 14L)}, false);
        unseqResource0.setStatusForTest(TsFileResourceStatus.NORMAL);
        TsFileResource unseqResource1 = this.generateSingleNonAlignedSeriesFileWithDevices("2-2-0-0.tsfile", new String[]{"d1"}, new TimeRange[]{new TimeRange(1L, 4L)}, false);
        unseqResource1.setStatusForTest(TsFileResourceStatus.NORMAL);
        TsFileResource unseqResource2 = this.generateSingleNonAlignedSeriesFileWithDevices("3-3-0-0.tsfile", new String[]{"d1"}, new TimeRange[]{new TimeRange(6L, 9L)}, false);
        unseqResource2.setStatusForTest(TsFileResourceStatus.NORMAL);
        TsFileResource unseqResource3 = this.generateSingleNonAlignedSeriesFileWithDevices("4-4-0-0.tsfile", new String[]{"d1"}, new TimeRange[]{new TimeRange(11L, 14L)}, false);
        unseqResource3.setStatusForTest(TsFileResourceStatus.NORMAL);
        TsFileResource unseqResource5 = this.generateSingleNonAlignedSeriesFileWithDevices("5-5-0-0.tsfile", new String[]{"d1"}, new TimeRange[]{new TimeRange(21L, 24L)}, false);
        unseqResource5.setStatusForTest(TsFileResourceStatus.NORMAL);
        this.unseqResources.add(unseqResource0);
        this.unseqResources.add(unseqResource1);
        this.unseqResources.add(unseqResource2);
        this.unseqResources.add(unseqResource3);
        this.unseqResources.add(unseqResource5);
        DataRegionForCompactionTest dataRegion = this.createDataRegion();
        TsFileManager tsFileManager = dataRegion.getTsFileManager();
        tsFileManager.addAll(this.seqResources, true);
        tsFileManager.addAll(this.unseqResources, false);
        Assert.assertEquals((long)2L, (long)dataRegion.executeInsertionCompaction());
        Assert.assertEquals((long)2L, (long)tsFileManager.getTsFileList(true).size());
        TsFileResource targetFile1 = (TsFileResource)tsFileManager.getTsFileList(true).get(0);
        long timestamp = TsFileNameGenerator.getTsFileName((String)targetFile1.getTsFile().getName()).getTime();
        Assert.assertEquals((long)1L, (long)timestamp);
        TsFileResource targetFile2 = (TsFileResource)tsFileManager.getTsFileList(true).get(1);
        timestamp = TsFileNameGenerator.getTsFileName((String)targetFile2.getTsFile().getName()).getTime();
        Assert.assertEquals((long)2L, (long)timestamp);
    }

    @Test
    public void testInsertionCompactionScheduleWithMultiTimePartitions() throws IOException, InterruptedException {
        TsFileResource unseqResource1 = this.generateSingleNonAlignedSeriesFileWithDevices("2-2-0-0.tsfile", new String[]{"d1"}, new TimeRange[]{new TimeRange(1L, 4L)}, false);
        unseqResource1.setStatusForTest(TsFileResourceStatus.NORMAL);
        TsFileResource unseqResource2 = this.generateSingleNonAlignedSeriesFileWithDevices("3-3-0-0.tsfile", new String[]{"d1"}, new TimeRange[]{new TimeRange(6L, 9L)}, false);
        unseqResource2.setStatusForTest(TsFileResourceStatus.NORMAL);
        this.createTimePartitionDirIfNotExist(2808L);
        TsFileResource unseqResource3 = this.generateSingleNonAlignedSeriesFileWithDevicesWithTimePartition("4-4-0-0.tsfile", new String[]{"d1"}, new TimeRange[]{new TimeRange(1698301490306L, 1698301490406L)}, 2808L, false);
        unseqResource3.setStatusForTest(TsFileResourceStatus.NORMAL);
        this.unseqResources.add(unseqResource1);
        this.unseqResources.add(unseqResource2);
        this.unseqResources.add(unseqResource3);
        DataRegionForCompactionTest dataRegion = this.createDataRegion();
        TsFileManager tsFileManager = dataRegion.getTsFileManager();
        TsFileResourceManager.getInstance().registerSealedTsFileResource(unseqResource1);
        TsFileResourceManager.getInstance().registerSealedTsFileResource(unseqResource2);
        TsFileResourceManager.getInstance().registerSealedTsFileResource(unseqResource3);
        tsFileManager.getOrCreateUnsequenceListByTimePartition(0L).keepOrderInsert(unseqResource1);
        tsFileManager.getOrCreateUnsequenceListByTimePartition(0L).keepOrderInsert(unseqResource2);
        tsFileManager.getOrCreateUnsequenceListByTimePartition(2808L).keepOrderInsert(unseqResource3);
        Assert.assertEquals((long)3L, (long)dataRegion.executeInsertionCompaction());
        Assert.assertEquals((long)3L, (long)tsFileManager.getTsFileList(true).size());
        Assert.assertEquals((long)2L, (long)tsFileManager.getOrCreateSequenceListByTimePartition(0L).size());
        Assert.assertEquals((long)1L, (long)tsFileManager.getOrCreateSequenceListByTimePartition(2808L).size());
        TsFileResource targetFile1 = tsFileManager.getOrCreateSequenceListByTimePartition(0L).get(0);
        long timestamp = TsFileNameGenerator.getTsFileName((String)targetFile1.getTsFile().getName()).getTime();
        Assert.assertEquals((long)2L, (long)timestamp);
        TsFileResource targetFile2 = tsFileManager.getOrCreateSequenceListByTimePartition(0L).get(1);
        timestamp = TsFileNameGenerator.getTsFileName((String)targetFile2.getTsFile().getName()).getTime();
        Assert.assertEquals((long)3L, (long)timestamp);
        TsFileResource targetFile3 = tsFileManager.getOrCreateSequenceListByTimePartition(2808L).get(0);
        timestamp = TsFileNameGenerator.getTsFileName((String)targetFile3.getTsFile().getName()).getTime();
        Assert.assertEquals((long)4L, (long)timestamp);
    }

    public TsFileResource generateSingleNonAlignedSeriesFileWithDevices(String fileName, String[] devices, TimeRange[] timeRanges, boolean seq) throws IOException {
        TsFileResource seqResource1 = this.createEmptyFileAndResourceWithName(fileName, seq, 0);
        CompactionTestFileWriter writer1 = new CompactionTestFileWriter(seqResource1);
        for (int i = 0; i < devices.length; ++i) {
            String device = devices[i];
            TimeRange timeRange = timeRanges[i];
            writer1.startChunkGroup(device);
            writer1.generateSimpleNonAlignedSeriesToCurrentDevice("s1", new TimeRange[]{timeRange}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer1.endChunkGroup();
        }
        writer1.endFile();
        writer1.close();
        return seqResource1;
    }

    public TsFileResource generateSingleNonAlignedSeriesFileWithDevicesWithTimePartition(String fileName, String[] devices, TimeRange[] timeRanges, long timePartition, boolean seq) throws IOException {
        TsFileResource seqResource1 = this.createEmptyFileAndResourceWithName(fileName, timePartition, seq);
        CompactionTestFileWriter writer1 = new CompactionTestFileWriter(seqResource1);
        for (int i = 0; i < devices.length; ++i) {
            String device = devices[i];
            TimeRange timeRange = timeRanges[i];
            writer1.startChunkGroup(device);
            writer1.generateSimpleNonAlignedSeriesToCurrentDevice("s1", new TimeRange[]{timeRange}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer1.endChunkGroup();
        }
        writer1.endFile();
        writer1.close();
        return seqResource1;
    }

    private DataRegionForCompactionTest createDataRegion() {
        return new DataRegionForCompactionTest(COMPACTION_TEST_SG, "0");
    }

    private static class DataRegionForCompactionTest
    extends DataRegion {
        public DataRegionForCompactionTest(String databaseName, String id) {
            super(databaseName, id);
        }

        public int executeInsertionCompaction() throws InterruptedException {
            return super.executeInsertionCompaction(new ArrayList(this.getTsFileManager().getTimePartitions()));
        }
    }
}

