/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.cross;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Phaser;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.MergeException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.AbstractCompactionTest;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.InsertionCrossSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.impl.RewriteCrossSpaceCompactionSelector;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.utils.CrossSpaceCompactionCandidate;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.utils.InsertionCrossCompactionTaskResource;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.TsFileGeneratorUtils;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.DeviceTimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.ITimeIndex;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.PlainDeviceID;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InsertionCrossSpaceCompactionSelectorTest
extends AbstractCompactionTest {
    @Override
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException, InterruptedException {
        IoTDBDescriptor.getInstance().getConfig().setEnableCrossSpaceCompaction(true);
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        IoTDBDescriptor.getInstance().getConfig().setEnableCrossSpaceCompaction(false);
        super.tearDown();
    }

    @Test
    public void testSimpleInsertionCompaction() throws IOException, MergeException {
        PlainDeviceID d1 = new PlainDeviceID("root.testsg.d1");
        TsFileResource seqResource1 = this.createTsFileResource("1-1-0-0.tsfile", true);
        seqResource1.updateStartTime((IDeviceID)d1, 10L);
        seqResource1.updateEndTime((IDeviceID)d1, 20L);
        TsFileResource seqResource2 = this.createTsFileResource("3-3-0-0.tsfile", true);
        seqResource2.updateStartTime((IDeviceID)d1, 40L);
        seqResource2.updateEndTime((IDeviceID)d1, 50L);
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        TsFileResource unseqResource1 = this.createTsFileResource("5-5-1-0.tsfile", false);
        unseqResource1.updateStartTime((IDeviceID)d1, 30L);
        unseqResource1.updateEndTime((IDeviceID)d1, 35L);
        this.unseqResources.add(unseqResource1);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("root.testsg", "0", 0L, this.tsFileManager);
        InsertionCrossCompactionTaskResource result = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertEquals((Object)unseqResource1, (Object)result.toInsertUnSeqFile);
        Assert.assertEquals((Object)seqResource1, (Object)result.prevSeqFile);
        Assert.assertEquals((Object)seqResource2, (Object)result.nextSeqFile);
    }

    @Test
    public void testSimpleInsertionCompactionWithMultiUnseqFiles() throws IOException, MergeException {
        PlainDeviceID d1 = new PlainDeviceID("root.testsg.d1");
        TsFileResource seqResource1 = this.createTsFileResource("1-1-0-0.tsfile", true);
        seqResource1.updateStartTime((IDeviceID)d1, 10L);
        seqResource1.updateEndTime((IDeviceID)d1, 20L);
        TsFileResource seqResource2 = this.createTsFileResource("3-3-0-0.tsfile", true);
        seqResource2.updateStartTime((IDeviceID)d1, 40L);
        seqResource2.updateEndTime((IDeviceID)d1, 50L);
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        TsFileResource unseqResource1 = this.createTsFileResource("5-5-1-0.tsfile", false);
        unseqResource1.updateStartTime((IDeviceID)d1, 30L);
        unseqResource1.updateEndTime((IDeviceID)d1, 35L);
        this.unseqResources.add(unseqResource1);
        TsFileResource unseqResource2 = this.createTsFileResource("6-6-1-0.tsfile", false);
        unseqResource2.updateStartTime((IDeviceID)d1, 32L);
        unseqResource2.updateEndTime((IDeviceID)d1, 37L);
        this.unseqResources.add(unseqResource2);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("root.testsg", "0", 0L, this.tsFileManager);
        InsertionCrossCompactionTaskResource result = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertEquals((Object)unseqResource1, (Object)result.toInsertUnSeqFile);
        Assert.assertEquals((Object)seqResource1, (Object)result.prevSeqFile);
        Assert.assertEquals((Object)seqResource2, (Object)result.nextSeqFile);
    }

    @Test
    public void testSimpleInsertionCompactionWithFirstUnseqFileCannotSelect() throws IOException, MergeException {
        PlainDeviceID d1 = new PlainDeviceID("root.testsg.d1");
        TsFileResource seqResource1 = this.createTsFileResource("1-1-0-0.tsfile", true);
        seqResource1.updateStartTime((IDeviceID)d1, 10L);
        seqResource1.updateEndTime((IDeviceID)d1, 20L);
        TsFileResource seqResource2 = this.createTsFileResource("3-3-0-0.tsfile", true);
        seqResource2.updateStartTime((IDeviceID)d1, 40L);
        seqResource2.updateEndTime((IDeviceID)d1, 50L);
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        TsFileResource unseqResource1 = this.createTsFileResource("5-5-1-0.tsfile", false);
        unseqResource1.updateStartTime((IDeviceID)d1, 10L);
        unseqResource1.updateEndTime((IDeviceID)d1, 35L);
        this.unseqResources.add(unseqResource1);
        TsFileResource unseqResource2 = this.createTsFileResource("6-6-1-0.tsfile", false);
        unseqResource2.updateStartTime((IDeviceID)d1, 32L);
        unseqResource2.updateEndTime((IDeviceID)d1, 37L);
        this.unseqResources.add(unseqResource2);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("root.testsg", "0", 0L, this.tsFileManager);
        InsertionCrossCompactionTaskResource result = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertEquals((Object)unseqResource2, (Object)result.toInsertUnSeqFile);
        Assert.assertEquals((Object)seqResource1, (Object)result.prevSeqFile);
        Assert.assertEquals((Object)seqResource2, (Object)result.nextSeqFile);
        Assert.assertEquals((Object)unseqResource1, (Object)result.firstUnSeqFileInParitition);
    }

    @Test
    public void testSimpleInsertionCompactionWithFirstUnseqFileInvalid() throws IOException, MergeException {
        PlainDeviceID d1 = new PlainDeviceID("root.testsg.d1");
        TsFileResource seqResource1 = this.createTsFileResource("1-1-0-0.tsfile", true);
        seqResource1.updateStartTime((IDeviceID)d1, 10L);
        seqResource1.updateEndTime((IDeviceID)d1, 20L);
        TsFileResource seqResource2 = this.createTsFileResource("3-3-0-0.tsfile", true);
        seqResource2.updateStartTime((IDeviceID)d1, 40L);
        seqResource2.updateEndTime((IDeviceID)d1, 50L);
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        TsFileResource unseqResource1 = this.createTsFileResource("5-5-1-0.tsfile", false);
        unseqResource1.updateStartTime((IDeviceID)d1, 10L);
        unseqResource1.updateEndTime((IDeviceID)d1, 35L);
        unseqResource1.setStatusForTest(TsFileResourceStatus.COMPACTION_CANDIDATE);
        this.unseqResources.add(unseqResource1);
        TsFileResource unseqResource2 = this.createTsFileResource("6-6-1-0.tsfile", false);
        unseqResource2.updateStartTime((IDeviceID)d1, 32L);
        unseqResource2.updateEndTime((IDeviceID)d1, 37L);
        this.unseqResources.add(unseqResource2);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("root.testsg", "0", 0L, this.tsFileManager);
        InsertionCrossCompactionTaskResource result = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertFalse((boolean)result.isValid());
    }

    @Test
    public void testSimpleInsertionCompactionWithFirstTwoUnseqFileCannotSelect() throws IOException, MergeException {
        PlainDeviceID d1 = new PlainDeviceID("root.testsg.d1");
        TsFileResource seqResource1 = this.createTsFileResource("1-1-0-0.tsfile", true);
        seqResource1.updateStartTime((IDeviceID)d1, 10L);
        seqResource1.updateEndTime((IDeviceID)d1, 20L);
        TsFileResource seqResource2 = this.createTsFileResource("3-3-0-0.tsfile", true);
        seqResource2.updateStartTime((IDeviceID)d1, 40L);
        seqResource2.updateEndTime((IDeviceID)d1, 50L);
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        TsFileResource unseqResource1 = this.createTsFileResource("5-5-1-0.tsfile", false);
        unseqResource1.updateStartTime((IDeviceID)d1, 10L);
        unseqResource1.updateEndTime((IDeviceID)d1, 35L);
        this.unseqResources.add(unseqResource1);
        TsFileResource unseqResource2 = this.createTsFileResource("6-6-1-0.tsfile", false);
        unseqResource2.updateStartTime((IDeviceID)d1, 12L);
        unseqResource2.updateEndTime((IDeviceID)d1, 37L);
        this.unseqResources.add(unseqResource2);
        TsFileResource unseqResource3 = this.createTsFileResource("7-7-1-0.tsfile", false);
        unseqResource3.updateStartTime((IDeviceID)d1, 32L);
        unseqResource3.updateEndTime((IDeviceID)d1, 37L);
        this.unseqResources.add(unseqResource3);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("root.testsg", "0", 0L, this.tsFileManager);
        InsertionCrossCompactionTaskResource result = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertEquals((Object)unseqResource3, (Object)result.toInsertUnSeqFile);
        Assert.assertEquals((Object)seqResource1, (Object)result.prevSeqFile);
        Assert.assertEquals((Object)seqResource2, (Object)result.nextSeqFile);
        Assert.assertEquals((Object)unseqResource1, (Object)result.firstUnSeqFileInParitition);
    }

    @Test
    public void testSimpleInsertionCompactionWithUnseqDeviceNotExistInSeqSpace() throws IOException, MergeException {
        PlainDeviceID d1 = new PlainDeviceID("root.testsg.d1");
        PlainDeviceID d2 = new PlainDeviceID("root.testsg.d2");
        TsFileResource seqResource1 = this.createTsFileResource("1-1-0-0.tsfile", true);
        seqResource1.updateStartTime((IDeviceID)d1, 10L);
        seqResource1.updateEndTime((IDeviceID)d1, 20L);
        TsFileResource seqResource2 = this.createTsFileResource("3-3-0-0.tsfile", true);
        seqResource2.updateStartTime((IDeviceID)d1, 40L);
        seqResource2.updateEndTime((IDeviceID)d1, 50L);
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        TsFileResource unseqResource1 = this.createTsFileResource("5-5-1-0.tsfile", false);
        unseqResource1.updateStartTime((IDeviceID)d2, 30L);
        unseqResource1.updateEndTime((IDeviceID)d2, 35L);
        this.unseqResources.add(unseqResource1);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("root.testsg", "0", 0L, this.tsFileManager);
        InsertionCrossCompactionTaskResource result = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertEquals((Object)unseqResource1, (Object)result.toInsertUnSeqFile);
        Assert.assertNull((Object)result.prevSeqFile);
        Assert.assertEquals((Object)seqResource1, (Object)result.nextSeqFile);
    }

    @Test
    public void testSimpleInsertionCompactionWithUnseqFileInsertFirstInSeqSpace() throws IOException, MergeException {
        PlainDeviceID d1 = new PlainDeviceID("root.testsg.d1");
        TsFileResource seqResource1 = this.createTsFileResource("1-1-0-0.tsfile", true);
        seqResource1.updateStartTime((IDeviceID)d1, 10L);
        seqResource1.updateEndTime((IDeviceID)d1, 20L);
        TsFileResource seqResource2 = this.createTsFileResource("3-3-0-0.tsfile", true);
        seqResource2.updateStartTime((IDeviceID)d1, 40L);
        seqResource2.updateEndTime((IDeviceID)d1, 50L);
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        TsFileResource unseqResource1 = this.createTsFileResource("5-5-1-0.tsfile", false);
        unseqResource1.updateStartTime((IDeviceID)d1, 3L);
        unseqResource1.updateEndTime((IDeviceID)d1, 5L);
        this.unseqResources.add(unseqResource1);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("root.testsg", "0", 0L, this.tsFileManager);
        InsertionCrossCompactionTaskResource result = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertEquals((Object)unseqResource1, (Object)result.toInsertUnSeqFile);
        Assert.assertNull((Object)result.prevSeqFile);
        Assert.assertEquals((Object)seqResource1, (Object)result.nextSeqFile);
    }

    @Test
    public void testSimpleInsertionCompactionWithUnseqFileInsertLastInSeqSpace() throws IOException, MergeException {
        PlainDeviceID d1 = new PlainDeviceID("root.testsg.d1");
        TsFileResource seqResource1 = this.createTsFileResource("1-1-0-0.tsfile", true);
        seqResource1.updateStartTime((IDeviceID)d1, 10L);
        seqResource1.updateEndTime((IDeviceID)d1, 20L);
        TsFileResource seqResource2 = this.createTsFileResource("3-3-0-0.tsfile", true);
        seqResource2.updateStartTime((IDeviceID)d1, 40L);
        seqResource2.updateEndTime((IDeviceID)d1, 50L);
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        TsFileResource unseqResource1 = this.createTsFileResource("5-5-1-0.tsfile", false);
        unseqResource1.updateStartTime((IDeviceID)d1, 60L);
        unseqResource1.updateEndTime((IDeviceID)d1, 65L);
        this.unseqResources.add(unseqResource1);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("root.testsg", "0", 0L, this.tsFileManager);
        InsertionCrossCompactionTaskResource result = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertEquals((Object)unseqResource1, (Object)result.toInsertUnSeqFile);
        Assert.assertEquals((Object)seqResource2, (Object)result.prevSeqFile);
        Assert.assertNull((Object)result.nextSeqFile);
    }

    @Test
    public void testSimpleInsertionCompactionWithCloseTimestamp() throws IOException, MergeException {
        PlainDeviceID d1 = new PlainDeviceID("root.testsg.d1");
        TsFileResource seqResource1 = this.createTsFileResource("1-1-0-0.tsfile", true);
        seqResource1.updateStartTime((IDeviceID)d1, 10L);
        seqResource1.updateEndTime((IDeviceID)d1, 20L);
        TsFileResource seqResource2 = this.createTsFileResource("2-3-0-0.tsfile", true);
        seqResource2.updateStartTime((IDeviceID)d1, 40L);
        seqResource2.updateEndTime((IDeviceID)d1, 50L);
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        TsFileResource unseqResource1 = this.createTsFileResource("5-5-1-0.tsfile", false);
        unseqResource1.updateStartTime((IDeviceID)d1, 30L);
        unseqResource1.updateEndTime((IDeviceID)d1, 35L);
        this.unseqResources.add(unseqResource1);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("root.testsg", "0", 0L, this.tsFileManager);
        InsertionCrossCompactionTaskResource result = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertFalse((boolean)result.isValid());
    }

    @Test
    public void testSimpleInsertionCompactionWithOverlap() throws IOException, MergeException {
        PlainDeviceID d1 = new PlainDeviceID("root.testsg.d1");
        TsFileResource seqResource1 = this.createTsFileResource("1-1-0-0.tsfile", true);
        seqResource1.updateStartTime((IDeviceID)d1, 10L);
        seqResource1.updateEndTime((IDeviceID)d1, 20L);
        TsFileResource seqResource2 = this.createTsFileResource("2-3-0-0.tsfile", true);
        seqResource2.updateStartTime((IDeviceID)d1, 40L);
        seqResource2.updateEndTime((IDeviceID)d1, 50L);
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        TsFileResource unseqResource1 = this.createTsFileResource("5-5-1-0.tsfile", false);
        unseqResource1.updateStartTime((IDeviceID)d1, 20L);
        unseqResource1.updateEndTime((IDeviceID)d1, 45L);
        this.unseqResources.add(unseqResource1);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("root.testsg", "0", 0L, this.tsFileManager);
        InsertionCrossCompactionTaskResource result = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertFalse((boolean)result.isValid());
    }

    @Test
    public void testSimpleInsertionCompactionWithPrevSeqFileInvalidCompactionCandidate() throws IOException, MergeException {
        PlainDeviceID d1 = new PlainDeviceID("root.testsg.d1");
        TsFileResource seqResource1 = this.createTsFileResource("1-1-0-0.tsfile", true);
        seqResource1.updateStartTime((IDeviceID)d1, 10L);
        seqResource1.updateEndTime((IDeviceID)d1, 20L);
        seqResource1.setStatusForTest(TsFileResourceStatus.COMPACTION_CANDIDATE);
        TsFileResource seqResource2 = this.createTsFileResource("3-3-0-0.tsfile", true);
        seqResource2.updateStartTime((IDeviceID)d1, 40L);
        seqResource2.updateEndTime((IDeviceID)d1, 50L);
        TsFileResource seqResource3 = this.createTsFileResource("5-5-0-0.tsfile", true);
        seqResource3.updateStartTime((IDeviceID)d1, 60L);
        seqResource3.updateEndTime((IDeviceID)d1, 70L);
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        TsFileResource unseqResource1 = this.createTsFileResource("4-4-1-0.tsfile", false);
        unseqResource1.updateStartTime((IDeviceID)d1, 30L);
        unseqResource1.updateEndTime((IDeviceID)d1, 35L);
        this.unseqResources.add(unseqResource1);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("root.testsg", "0", 0L, this.tsFileManager);
        InsertionCrossCompactionTaskResource result = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertFalse((boolean)result.isValid());
    }

    @Test
    public void testSimpleInsertionCompactionWithNextSeqFileInvalidCompactionCandidate() throws IOException, MergeException {
        PlainDeviceID d1 = new PlainDeviceID("root.testsg.d1");
        TsFileResource seqResource1 = this.createTsFileResource("1-1-0-0.tsfile", true);
        seqResource1.updateStartTime((IDeviceID)d1, 10L);
        seqResource1.updateEndTime((IDeviceID)d1, 20L);
        TsFileResource seqResource2 = this.createTsFileResource("3-3-0-0.tsfile", true);
        seqResource2.setStatusForTest(TsFileResourceStatus.COMPACTION_CANDIDATE);
        seqResource2.updateStartTime((IDeviceID)d1, 40L);
        seqResource2.updateEndTime((IDeviceID)d1, 50L);
        TsFileResource seqResource3 = this.createTsFileResource("5-5-0-0.tsfile", true);
        seqResource3.updateStartTime((IDeviceID)d1, 60L);
        seqResource3.updateEndTime((IDeviceID)d1, 70L);
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        TsFileResource unseqResource1 = this.createTsFileResource("4-4-1-0.tsfile", false);
        unseqResource1.updateStartTime((IDeviceID)d1, 30L);
        unseqResource1.updateEndTime((IDeviceID)d1, 35L);
        this.unseqResources.add(unseqResource1);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("root.testsg", "0", 0L, this.tsFileManager);
        InsertionCrossCompactionTaskResource result = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertFalse((boolean)result.isValid());
    }

    @Test
    public void testSimpleInsertionCompactionWithManySeqFiles() throws IOException, MergeException {
        PlainDeviceID d1 = new PlainDeviceID("root.testsg.d1");
        TsFileResource seqResource1 = this.createTsFileResource("1-1-0-0.tsfile", true);
        seqResource1.updateStartTime((IDeviceID)d1, 10L);
        seqResource1.updateEndTime((IDeviceID)d1, 20L);
        TsFileResource seqResource2 = this.createTsFileResource("3-3-0-0.tsfile", true);
        seqResource2.updateStartTime((IDeviceID)d1, 30L);
        seqResource2.updateEndTime((IDeviceID)d1, 40L);
        TsFileResource seqResource3 = this.createTsFileResource("5-5-0-0.tsfile", true);
        seqResource3.updateStartTime((IDeviceID)d1, 50L);
        seqResource3.updateEndTime((IDeviceID)d1, 60L);
        TsFileResource seqResource4 = this.createTsFileResource("7-7-0-0.tsfile", true);
        seqResource4.updateStartTime((IDeviceID)d1, 70L);
        seqResource4.updateEndTime((IDeviceID)d1, 80L);
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        this.seqResources.add(seqResource3);
        this.seqResources.add(seqResource4);
        TsFileResource unseqResource1 = this.createTsFileResource("9-9-0-0.tsfile", false);
        unseqResource1.updateStartTime((IDeviceID)d1, 42L);
        unseqResource1.updateEndTime((IDeviceID)d1, 45L);
        this.unseqResources.add(unseqResource1);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("root.testsg", "0", 0L, this.tsFileManager);
        InsertionCrossCompactionTaskResource task = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertEquals((Object)unseqResource1, (Object)task.toInsertUnSeqFile);
        Assert.assertEquals((Object)seqResource2, (Object)task.prevSeqFile);
        Assert.assertEquals((Object)seqResource3, (Object)task.nextSeqFile);
    }

    @Test
    public void testInsertionCompactionWithManySeqFilesManyDevices() throws IOException, MergeException {
        PlainDeviceID d1 = new PlainDeviceID("root.testsg.d1");
        PlainDeviceID d2 = new PlainDeviceID("root.testsg.d2");
        PlainDeviceID d3 = new PlainDeviceID("root.testsg.d3");
        TsFileResource seqResource1 = this.createTsFileResource("1-1-0-0.tsfile", true);
        seqResource1.updateStartTime((IDeviceID)d1, 10L);
        seqResource1.updateEndTime((IDeviceID)d1, 20L);
        seqResource1.updateStartTime((IDeviceID)d2, 15L);
        seqResource1.updateEndTime((IDeviceID)d2, 30L);
        seqResource1.updateStartTime((IDeviceID)d3, 1L);
        seqResource1.updateEndTime((IDeviceID)d3, 3L);
        TsFileResource seqResource2 = this.createTsFileResource("3-3-0-0.tsfile", true);
        seqResource2.updateStartTime((IDeviceID)d1, 30L);
        seqResource2.updateEndTime((IDeviceID)d1, 40L);
        TsFileResource seqResource3 = this.createTsFileResource("5-5-0-0.tsfile", true);
        seqResource3.updateStartTime((IDeviceID)d3, 21L);
        seqResource3.updateEndTime((IDeviceID)d3, 23L);
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        this.seqResources.add(seqResource3);
        TsFileResource unseqResource1 = this.createTsFileResource("9-9-0-0.tsfile", false);
        unseqResource1.updateStartTime((IDeviceID)d1, 42L);
        unseqResource1.updateEndTime((IDeviceID)d1, 45L);
        unseqResource1.updateStartTime((IDeviceID)d2, 31L);
        unseqResource1.updateEndTime((IDeviceID)d2, 37L);
        unseqResource1.updateStartTime((IDeviceID)d3, 10L);
        unseqResource1.updateEndTime((IDeviceID)d3, 20L);
        this.unseqResources.add(unseqResource1);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("root.testsg", "0", 0L, this.tsFileManager);
        InsertionCrossCompactionTaskResource task = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertEquals((Object)unseqResource1, (Object)task.toInsertUnSeqFile);
        Assert.assertEquals((Object)seqResource2, (Object)task.prevSeqFile);
        Assert.assertEquals((Object)seqResource3, (Object)task.nextSeqFile);
    }

    @Test
    public void testInsertionCompactionWithManySeqFilesManyDevices2() throws IOException, MergeException {
        PlainDeviceID d1 = new PlainDeviceID("root.testsg.d1");
        PlainDeviceID d2 = new PlainDeviceID("root.testsg.d2");
        PlainDeviceID d3 = new PlainDeviceID("root.testsg.d3");
        TsFileResource seqResource1 = this.createTsFileResource("1-1-0-0.tsfile", true);
        seqResource1.updateStartTime((IDeviceID)d1, 10L);
        seqResource1.updateEndTime((IDeviceID)d1, 20L);
        seqResource1.updateStartTime((IDeviceID)d2, 15L);
        seqResource1.updateEndTime((IDeviceID)d2, 30L);
        seqResource1.updateStartTime((IDeviceID)d3, 1L);
        seqResource1.updateEndTime((IDeviceID)d3, 3L);
        TsFileResource seqResource2 = this.createTsFileResource("3-3-0-0.tsfile", true);
        seqResource2.updateStartTime((IDeviceID)d1, 30L);
        seqResource2.updateEndTime((IDeviceID)d1, 40L);
        TsFileResource seqResource3 = this.createTsFileResource("5-5-0-0.tsfile", true);
        seqResource3.updateStartTime((IDeviceID)d3, 21L);
        seqResource3.updateEndTime((IDeviceID)d3, 23L);
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        this.seqResources.add(seqResource3);
        TsFileResource unseqResource1 = this.createTsFileResource("9-9-0-0.tsfile", false);
        unseqResource1.updateStartTime((IDeviceID)d1, 56L);
        unseqResource1.updateEndTime((IDeviceID)d1, 75L);
        unseqResource1.updateStartTime((IDeviceID)d2, 31L);
        unseqResource1.updateEndTime((IDeviceID)d2, 37L);
        unseqResource1.updateStartTime((IDeviceID)d3, 40L);
        unseqResource1.updateEndTime((IDeviceID)d3, 50L);
        this.unseqResources.add(unseqResource1);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("root.testsg", "0", 0L, this.tsFileManager);
        InsertionCrossCompactionTaskResource task = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertEquals((Object)unseqResource1, (Object)task.toInsertUnSeqFile);
        Assert.assertEquals((Object)seqResource3, (Object)task.prevSeqFile);
        Assert.assertNull((Object)task.nextSeqFile);
    }

    @Test
    public void testInsertLast1() throws IOException, MergeException {
        PlainDeviceID d1 = new PlainDeviceID("root.testsg.d1");
        PlainDeviceID d2 = new PlainDeviceID("root.testsg.d2");
        TsFileResource seqResource1 = this.createTsFileResource("1-1-0-0.tsfile", true);
        seqResource1.updateStartTime((IDeviceID)d1, 10L);
        seqResource1.updateEndTime((IDeviceID)d1, 20L);
        seqResource1.updateStartTime((IDeviceID)d2, 20L);
        seqResource1.updateEndTime((IDeviceID)d2, 30L);
        TsFileResource seqResource2 = this.createTsFileResource("3-3-0-0.tsfile", true);
        seqResource2.updateStartTime((IDeviceID)d1, 30L);
        seqResource2.updateEndTime((IDeviceID)d1, 40L);
        seqResource2.updateStartTime((IDeviceID)d2, 40L);
        seqResource2.updateEndTime((IDeviceID)d2, 50L);
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        TsFileResource unseqResource1 = this.createTsFileResource("4-4-1-0.tsfile", false);
        unseqResource1.updateStartTime((IDeviceID)d1, 42L);
        unseqResource1.updateEndTime((IDeviceID)d1, 45L);
        unseqResource1.updateStartTime((IDeviceID)d2, 31L);
        unseqResource1.updateEndTime((IDeviceID)d2, 37L);
        this.unseqResources.add(unseqResource1);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("root.testsg", "0", 0L, this.tsFileManager);
        InsertionCrossCompactionTaskResource result = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertFalse((boolean)result.isValid());
    }

    @Test
    public void testInsertLast2() throws IOException, MergeException {
        PlainDeviceID d1 = new PlainDeviceID("root.testsg.d1");
        PlainDeviceID d2 = new PlainDeviceID("root.testsg.d2");
        TsFileResource seqResource1 = this.createTsFileResource("1-1-0-0.tsfile", true);
        seqResource1.updateStartTime((IDeviceID)d1, 10L);
        seqResource1.updateEndTime((IDeviceID)d1, 20L);
        seqResource1.updateStartTime((IDeviceID)d2, 20L);
        seqResource1.updateEndTime((IDeviceID)d2, 30L);
        TsFileResource seqResource2 = this.createTsFileResource("3-3-0-0.tsfile", true);
        seqResource2.updateStartTime((IDeviceID)d1, 30L);
        seqResource2.updateEndTime((IDeviceID)d1, 40L);
        seqResource2.updateStartTime((IDeviceID)d2, 40L);
        seqResource2.updateEndTime((IDeviceID)d2, 50L);
        TsFileResource seqResource3 = this.createTsFileResource("5-5-0-0.tsfile", true);
        seqResource3.updateStartTime((IDeviceID)d1, 50L);
        seqResource3.updateEndTime((IDeviceID)d1, 60L);
        seqResource3.updateStartTime((IDeviceID)d2, 60L);
        seqResource3.updateEndTime((IDeviceID)d2, 70L);
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        this.seqResources.add(seqResource3);
        TsFileResource unseqResource1 = this.createTsFileResource("4-4-1-0.tsfile", false);
        unseqResource1.updateStartTime((IDeviceID)d1, 42L);
        unseqResource1.updateEndTime((IDeviceID)d1, 45L);
        unseqResource1.updateStartTime((IDeviceID)d2, 31L);
        unseqResource1.updateEndTime((IDeviceID)d2, 37L);
        this.unseqResources.add(unseqResource1);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("root.testsg", "0", 0L, this.tsFileManager);
        InsertionCrossCompactionTaskResource result = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertFalse((boolean)result.isValid());
    }

    @Test
    public void testInsertFirst() throws IOException, MergeException {
        PlainDeviceID d1 = new PlainDeviceID("root.testsg.d1");
        PlainDeviceID d2 = new PlainDeviceID("root.testsg.d2");
        TsFileResource seqResource1 = this.createTsFileResource("1-1-0-0.tsfile", true);
        seqResource1.updateStartTime((IDeviceID)d1, 10L);
        seqResource1.updateEndTime((IDeviceID)d1, 20L);
        seqResource1.updateStartTime((IDeviceID)d2, 20L);
        seqResource1.updateEndTime((IDeviceID)d2, 30L);
        this.seqResources.add(seqResource1);
        TsFileResource unseqResource1 = this.createTsFileResource("4-4-1-0.tsfile", false);
        unseqResource1.updateStartTime((IDeviceID)d1, 30L);
        unseqResource1.updateEndTime((IDeviceID)d1, 40L);
        unseqResource1.updateStartTime((IDeviceID)d2, 10L);
        unseqResource1.updateEndTime((IDeviceID)d2, 15L);
        this.unseqResources.add(unseqResource1);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("root.testsg", "0", 0L, this.tsFileManager);
        InsertionCrossCompactionTaskResource result = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertFalse((boolean)result.isValid());
    }

    @Test
    public void testInsertionCompactionWithManySeqFilesManyDevices3() throws IOException, MergeException {
        PlainDeviceID d1 = new PlainDeviceID("root.testsg.d1");
        PlainDeviceID d2 = new PlainDeviceID("root.testsg.d2");
        PlainDeviceID d3 = new PlainDeviceID("root.testsg.d3");
        TsFileResource seqResource1 = this.createTsFileResource("1-1-0-0.tsfile", true);
        seqResource1.updateStartTime((IDeviceID)d1, 10L);
        seqResource1.updateEndTime((IDeviceID)d1, 20L);
        seqResource1.updateStartTime((IDeviceID)d2, 15L);
        seqResource1.updateEndTime((IDeviceID)d2, 30L);
        seqResource1.updateStartTime((IDeviceID)d3, 3L);
        seqResource1.updateEndTime((IDeviceID)d3, 5L);
        TsFileResource seqResource2 = this.createTsFileResource("3-3-0-0.tsfile", true);
        seqResource2.updateStartTime((IDeviceID)d1, 30L);
        seqResource2.updateEndTime((IDeviceID)d1, 40L);
        TsFileResource seqResource3 = this.createTsFileResource("5-5-0-0.tsfile", true);
        seqResource3.updateStartTime((IDeviceID)d3, 21L);
        seqResource3.updateEndTime((IDeviceID)d3, 23L);
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        this.seqResources.add(seqResource3);
        TsFileResource unseqResource1 = this.createTsFileResource("9-9-0-0.tsfile", false);
        unseqResource1.updateStartTime((IDeviceID)d1, 1L);
        unseqResource1.updateEndTime((IDeviceID)d1, 2L);
        unseqResource1.updateStartTime((IDeviceID)d2, 1L);
        unseqResource1.updateEndTime((IDeviceID)d2, 2L);
        unseqResource1.updateStartTime((IDeviceID)d3, 1L);
        unseqResource1.updateEndTime((IDeviceID)d3, 2L);
        this.unseqResources.add(unseqResource1);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("root.testsg", "0", 0L, this.tsFileManager);
        InsertionCrossCompactionTaskResource task = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertEquals((Object)unseqResource1, (Object)task.toInsertUnSeqFile);
        Assert.assertNull((Object)task.prevSeqFile);
        Assert.assertEquals((Object)seqResource1, (Object)task.nextSeqFile);
    }

    @Test
    public void testInsertionCompactionWithManySeqFilesManyDevices4() throws IOException, MergeException {
        PlainDeviceID d1 = new PlainDeviceID("root.testsg.d1");
        PlainDeviceID d2 = new PlainDeviceID("root.testsg.d2");
        PlainDeviceID d3 = new PlainDeviceID("root.testsg.d3");
        TsFileResource seqResource1 = this.createTsFileResource("1-1-0-0.tsfile", true);
        seqResource1.updateStartTime((IDeviceID)d1, 10L);
        seqResource1.updateEndTime((IDeviceID)d1, 20L);
        seqResource1.updateStartTime((IDeviceID)d2, 10L);
        seqResource1.updateEndTime((IDeviceID)d2, 20L);
        seqResource1.updateStartTime((IDeviceID)d3, 10L);
        seqResource1.updateEndTime((IDeviceID)d3, 20L);
        TsFileResource seqResource2 = this.createTsFileResource("3-3-0-0.tsfile", true);
        seqResource2.updateStartTime((IDeviceID)d2, 30L);
        seqResource2.updateEndTime((IDeviceID)d2, 40L);
        TsFileResource seqResource3 = this.createTsFileResource("5-5-0-0.tsfile", true);
        seqResource3.updateStartTime((IDeviceID)d2, 51L);
        seqResource3.updateEndTime((IDeviceID)d2, 63L);
        TsFileResource seqResource4 = this.createTsFileResource("7-7-0-0.tsfile", true);
        seqResource4.updateStartTime((IDeviceID)d3, 60L);
        seqResource4.updateEndTime((IDeviceID)d3, 70L);
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        this.seqResources.add(seqResource3);
        this.seqResources.add(seqResource4);
        TsFileResource unseqResource1 = this.createTsFileResource("9-9-0-0.tsfile", false);
        unseqResource1.updateStartTime((IDeviceID)d1, 30L);
        unseqResource1.updateEndTime((IDeviceID)d1, 40L);
        unseqResource1.updateStartTime((IDeviceID)d3, 30L);
        unseqResource1.updateEndTime((IDeviceID)d3, 40L);
        this.unseqResources.add(unseqResource1);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("root.testsg", "0", 0L, this.tsFileManager);
        InsertionCrossCompactionTaskResource task = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertEquals((Object)unseqResource1, (Object)task.toInsertUnSeqFile);
        Assert.assertEquals((Object)seqResource1, (Object)task.prevSeqFile);
        Assert.assertEquals((Object)seqResource2, (Object)task.nextSeqFile);
    }

    @Test
    public void testInsertionCompactionWithManySeqFilesManyDevices5() throws IOException, MergeException {
        PlainDeviceID d1 = new PlainDeviceID("root.testsg.d1");
        PlainDeviceID d2 = new PlainDeviceID("root.testsg.d2");
        PlainDeviceID d3 = new PlainDeviceID("root.testsg.d3");
        TsFileResource seqResource1 = this.createTsFileResource("1-1-0-0.tsfile", true);
        seqResource1.updateStartTime((IDeviceID)d1, 10L);
        seqResource1.updateEndTime((IDeviceID)d1, 20L);
        seqResource1.updateStartTime((IDeviceID)d2, 10L);
        seqResource1.updateEndTime((IDeviceID)d2, 20L);
        seqResource1.updateStartTime((IDeviceID)d3, 10L);
        seqResource1.updateEndTime((IDeviceID)d3, 20L);
        TsFileResource seqResource2 = this.createTsFileResource("2-2-0-0.tsfile", true);
        seqResource2.updateStartTime((IDeviceID)d2, 30L);
        seqResource2.updateEndTime((IDeviceID)d2, 40L);
        TsFileResource seqResource3 = this.createTsFileResource("5-5-0-0.tsfile", true);
        seqResource3.updateStartTime((IDeviceID)d2, 51L);
        seqResource3.updateEndTime((IDeviceID)d2, 63L);
        TsFileResource seqResource4 = this.createTsFileResource("7-7-0-0.tsfile", true);
        seqResource4.updateStartTime((IDeviceID)d3, 60L);
        seqResource4.updateEndTime((IDeviceID)d3, 70L);
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        this.seqResources.add(seqResource3);
        this.seqResources.add(seqResource4);
        TsFileResource unseqResource1 = this.createTsFileResource("9-9-0-0.tsfile", false);
        unseqResource1.updateStartTime((IDeviceID)d1, 30L);
        unseqResource1.updateEndTime((IDeviceID)d1, 40L);
        unseqResource1.updateStartTime((IDeviceID)d3, 30L);
        unseqResource1.updateEndTime((IDeviceID)d3, 40L);
        this.unseqResources.add(unseqResource1);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("root.testsg", "0", 0L, this.tsFileManager);
        InsertionCrossCompactionTaskResource task = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertEquals((Object)unseqResource1, (Object)task.toInsertUnSeqFile);
        Assert.assertEquals((Object)seqResource2, (Object)task.prevSeqFile);
        Assert.assertEquals((Object)seqResource3, (Object)task.nextSeqFile);
    }

    @Test
    public void testInsertionCompactionWithManySeqFilesManyDevices6() throws IOException, MergeException {
        PlainDeviceID d1 = new PlainDeviceID("root.testsg.d1");
        PlainDeviceID d2 = new PlainDeviceID("root.testsg.d2");
        PlainDeviceID d3 = new PlainDeviceID("root.testsg.d3");
        TsFileResource seqResource1 = this.createTsFileResource("1-1-0-0.tsfile", true);
        seqResource1.updateStartTime((IDeviceID)d1, 10L);
        seqResource1.updateEndTime((IDeviceID)d1, 20L);
        seqResource1.updateStartTime((IDeviceID)d2, 10L);
        seqResource1.updateEndTime((IDeviceID)d2, 20L);
        TsFileResource seqResource2 = this.createTsFileResource("2-2-0-0.tsfile", true);
        seqResource2.updateStartTime((IDeviceID)d2, 30L);
        seqResource2.updateEndTime((IDeviceID)d2, 40L);
        TsFileResource seqResource3 = this.createTsFileResource("5-5-0-0.tsfile", true);
        seqResource3.updateStartTime((IDeviceID)d2, 51L);
        seqResource3.updateEndTime((IDeviceID)d2, 63L);
        TsFileResource seqResource4 = this.createTsFileResource("7-7-0-0.tsfile", true);
        seqResource4.updateStartTime((IDeviceID)d3, 60L);
        seqResource4.updateEndTime((IDeviceID)d3, 70L);
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        this.seqResources.add(seqResource3);
        this.seqResources.add(seqResource4);
        TsFileResource unseqResource1 = this.createTsFileResource("9-9-0-0.tsfile", false);
        unseqResource1.updateStartTime((IDeviceID)d3, 30L);
        unseqResource1.updateEndTime((IDeviceID)d3, 40L);
        this.unseqResources.add(unseqResource1);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("root.testsg", "0", 0L, this.tsFileManager);
        InsertionCrossCompactionTaskResource task = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertEquals((Object)unseqResource1, (Object)task.toInsertUnSeqFile);
        Assert.assertNull((Object)task.prevSeqFile);
        Assert.assertEquals((Object)seqResource1, (Object)task.nextSeqFile);
    }

    @Test
    public void testInsertionCompactionWithManySeqFilesManyDevicesWithOverlap() throws IOException, MergeException {
        PlainDeviceID d1 = new PlainDeviceID("root.testsg.d1");
        PlainDeviceID d2 = new PlainDeviceID("root.testsg.d2");
        PlainDeviceID d3 = new PlainDeviceID("root.testsg.d3");
        TsFileResource seqResource1 = this.createTsFileResource("1-1-0-0.tsfile", true);
        seqResource1.updateStartTime((IDeviceID)d1, 10L);
        seqResource1.updateEndTime((IDeviceID)d1, 20L);
        seqResource1.updateStartTime((IDeviceID)d2, 15L);
        seqResource1.updateEndTime((IDeviceID)d2, 30L);
        seqResource1.updateStartTime((IDeviceID)d3, 1L);
        seqResource1.updateEndTime((IDeviceID)d3, 3L);
        TsFileResource seqResource2 = this.createTsFileResource("3-3-0-0.tsfile", true);
        seqResource2.updateStartTime((IDeviceID)d1, 30L);
        seqResource2.updateEndTime((IDeviceID)d1, 40L);
        TsFileResource seqResource3 = this.createTsFileResource("5-5-0-0.tsfile", true);
        seqResource3.updateStartTime((IDeviceID)d3, 21L);
        seqResource3.updateEndTime((IDeviceID)d3, 23L);
        TsFileResource seqResource4 = this.createTsFileResource("7-7-0-0.tsfile", true);
        seqResource4.updateStartTime((IDeviceID)d1, 41L);
        seqResource4.updateEndTime((IDeviceID)d1, 41L);
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        this.seqResources.add(seqResource3);
        this.seqResources.add(seqResource4);
        TsFileResource unseqResource1 = this.createTsFileResource("9-9-0-0.tsfile", false);
        unseqResource1.updateStartTime((IDeviceID)d1, 42L);
        unseqResource1.updateEndTime((IDeviceID)d1, 45L);
        unseqResource1.updateStartTime((IDeviceID)d2, 31L);
        unseqResource1.updateEndTime((IDeviceID)d2, 37L);
        unseqResource1.updateStartTime((IDeviceID)d3, 10L);
        unseqResource1.updateEndTime((IDeviceID)d3, 20L);
        this.unseqResources.add(unseqResource1);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("root.testsg", "0", 0L, this.tsFileManager);
        InsertionCrossCompactionTaskResource task = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertFalse((boolean)task.isValid());
    }

    @Test
    public void testInsertionSelectorWithNoSeqFiles() throws MergeException, IOException {
        PlainDeviceID d1 = new PlainDeviceID("root.testsg.d1");
        PlainDeviceID d2 = new PlainDeviceID("root.testsg.d2");
        TsFileResource unseqResource1 = this.createTsFileResource("1-1-0-0.tsfile", false);
        unseqResource1.updateStartTime((IDeviceID)d1, 10L);
        unseqResource1.updateEndTime((IDeviceID)d1, 20L);
        unseqResource1.updateStartTime((IDeviceID)d2, 20L);
        unseqResource1.updateEndTime((IDeviceID)d2, 30L);
        unseqResource1.serialize();
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(unseqResource1.getTsFile());){
            tsFileIOWriter.startChunkGroup((IDeviceID)d1);
            MeasurementSchema schema = new MeasurementSchema("s1", TSDataType.INT64, TSEncoding.PLAIN, CompressionType.SNAPPY);
            ChunkWriterImpl iChunkWriter = new ChunkWriterImpl((IMeasurementSchema)schema);
            ArrayList<TimeRange> pages = new ArrayList<TimeRange>();
            pages.add(new TimeRange(10L, 20L));
            TsFileGeneratorUtils.writeNonAlignedChunk(iChunkWriter, tsFileIOWriter, pages, false);
            tsFileIOWriter.endChunkGroup();
            tsFileIOWriter.startChunkGroup((IDeviceID)d2);
            pages.clear();
            pages.add(new TimeRange(20L, 30L));
            TsFileGeneratorUtils.writeNonAlignedChunk(iChunkWriter, tsFileIOWriter, pages, false);
            tsFileIOWriter.endChunkGroup();
            tsFileIOWriter.endFile();
        }
        TsFileResource unseqResource2 = this.createTsFileResource("2-2-0-0.tsfile", false);
        unseqResource2.updateStartTime((IDeviceID)d1, 30L);
        unseqResource2.updateEndTime((IDeviceID)d1, 40L);
        unseqResource2.updateStartTime((IDeviceID)d2, 40L);
        unseqResource2.updateEndTime((IDeviceID)d2, 50L);
        unseqResource2.serialize();
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(unseqResource2.getTsFile());){
            tsFileIOWriter.startChunkGroup((IDeviceID)d1);
            MeasurementSchema schema = new MeasurementSchema("s1", TSDataType.INT64, TSEncoding.PLAIN, CompressionType.SNAPPY);
            ChunkWriterImpl iChunkWriter = new ChunkWriterImpl((IMeasurementSchema)schema);
            ArrayList<TimeRange> pages = new ArrayList<TimeRange>();
            pages.add(new TimeRange(30L, 40L));
            TsFileGeneratorUtils.writeNonAlignedChunk(iChunkWriter, tsFileIOWriter, pages, false);
            tsFileIOWriter.endChunkGroup();
            tsFileIOWriter.startChunkGroup((IDeviceID)d2);
            pages.clear();
            pages.add(new TimeRange(40L, 50L));
            TsFileGeneratorUtils.writeNonAlignedChunk(iChunkWriter, tsFileIOWriter, pages, false);
            tsFileIOWriter.endChunkGroup();
            tsFileIOWriter.endFile();
        }
        TsFileResource unseqResource3 = this.createTsFileResource("3-3-0-0.tsfile", false);
        unseqResource3.updateStartTime((IDeviceID)d1, 50L);
        unseqResource3.updateEndTime((IDeviceID)d1, 60L);
        unseqResource3.updateStartTime((IDeviceID)d2, 60L);
        unseqResource3.updateEndTime((IDeviceID)d2, 70L);
        unseqResource3.serialize();
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(unseqResource3.getTsFile());){
            tsFileIOWriter.startChunkGroup((IDeviceID)d1);
            MeasurementSchema schema = new MeasurementSchema("s1", TSDataType.INT64, TSEncoding.PLAIN, CompressionType.SNAPPY);
            ChunkWriterImpl iChunkWriter = new ChunkWriterImpl((IMeasurementSchema)schema);
            ArrayList<TimeRange> pages = new ArrayList<TimeRange>();
            pages.add(new TimeRange(50L, 60L));
            TsFileGeneratorUtils.writeNonAlignedChunk(iChunkWriter, tsFileIOWriter, pages, false);
            tsFileIOWriter.endChunkGroup();
            tsFileIOWriter.startChunkGroup((IDeviceID)d2);
            pages.clear();
            pages.add(new TimeRange(60L, 70L));
            TsFileGeneratorUtils.writeNonAlignedChunk(iChunkWriter, tsFileIOWriter, pages, false);
            tsFileIOWriter.endChunkGroup();
            tsFileIOWriter.endFile();
        }
        this.unseqResources.add(unseqResource1);
        this.unseqResources.add(unseqResource2);
        this.unseqResources.add(unseqResource3);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("root.testsg", "0", 0L, this.tsFileManager);
        int i = 1;
        while (this.tsFileManager.getTsFileList(false).size() > 0) {
            InsertionCrossCompactionTaskResource taskResource = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.tsFileManager.getTsFileList(true), this.tsFileManager.getTsFileList(false)));
            Assert.assertTrue((boolean)taskResource.isValid());
            Assert.assertEquals(this.tsFileManager.getTsFileList(false).get(0), (Object)taskResource.firstUnSeqFileInParitition);
            Assert.assertEquals(this.tsFileManager.getTsFileList(false).get(0), (Object)taskResource.toInsertUnSeqFile);
            Assert.assertEquals(null, (Object)taskResource.nextSeqFile);
            if (i == 1) {
                Assert.assertEquals(null, (Object)taskResource.prevSeqFile);
            } else if (i == 2) {
                Assert.assertEquals(this.tsFileManager.getTsFileList(true).get(0), (Object)taskResource.prevSeqFile);
            } else {
                Assert.assertEquals(this.tsFileManager.getTsFileList(true).get(1), (Object)taskResource.prevSeqFile);
            }
            InsertionCrossSpaceCompactionTask task = new InsertionCrossSpaceCompactionTask(new Phaser(1), 0L, this.tsFileManager, taskResource, this.tsFileManager.getNextCompactionTaskId());
            task.start();
            ++i;
        }
        Assert.assertEquals((long)3L, (long)this.tsFileManager.getTsFileList(true).size());
        Assert.assertEquals((long)0L, (long)this.tsFileManager.getTsFileList(false).size());
    }

    @Test
    public void testInsertionSelectorWithNoUnseqFiles() throws MergeException {
        PlainDeviceID d1 = new PlainDeviceID("root.testsg.d1");
        PlainDeviceID d2 = new PlainDeviceID("root.testsg.d2");
        TsFileResource seqResource1 = this.createTsFileResource("1-1-0-0.tsfile", true);
        seqResource1.updateStartTime((IDeviceID)d1, 10L);
        seqResource1.updateEndTime((IDeviceID)d1, 20L);
        seqResource1.updateStartTime((IDeviceID)d2, 20L);
        seqResource1.updateEndTime((IDeviceID)d2, 30L);
        TsFileResource seqResource2 = this.createTsFileResource("2-2-0-0.tsfile", true);
        seqResource2.updateStartTime((IDeviceID)d1, 30L);
        seqResource2.updateEndTime((IDeviceID)d1, 40L);
        seqResource2.updateStartTime((IDeviceID)d2, 40L);
        seqResource2.updateEndTime((IDeviceID)d2, 50L);
        TsFileResource seqResource3 = this.createTsFileResource("3-3-0-0.tsfile", true);
        seqResource3.updateStartTime((IDeviceID)d1, 50L);
        seqResource3.updateEndTime((IDeviceID)d1, 60L);
        seqResource3.updateStartTime((IDeviceID)d2, 60L);
        seqResource3.updateEndTime((IDeviceID)d2, 70L);
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        this.seqResources.add(seqResource3);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("root.testsg", "0", 0L, this.tsFileManager);
        InsertionCrossCompactionTaskResource task = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertNull((Object)task.toInsertUnSeqFile);
        Assert.assertNull((Object)task.prevSeqFile);
        Assert.assertNull((Object)task.nextSeqFile);
        Assert.assertNull((Object)task.firstUnSeqFileInParitition);
    }

    @Test
    public void testInsertionSelectorWithOverlapUnseqFile() throws MergeException {
        PlainDeviceID d1 = new PlainDeviceID("root.testsg.d1");
        PlainDeviceID d2 = new PlainDeviceID("root.testsg.d2");
        TsFileResource seqResource1 = this.createTsFileResource("1-1-0-0.tsfile", true);
        seqResource1.updateStartTime((IDeviceID)d1, 10L);
        seqResource1.updateEndTime((IDeviceID)d1, 20L);
        seqResource1.updateStartTime((IDeviceID)d2, 20L);
        seqResource1.updateEndTime((IDeviceID)d2, 30L);
        TsFileResource seqResource2 = this.createTsFileResource("2-2-0-0.tsfile", true);
        seqResource2.updateStartTime((IDeviceID)d1, 30L);
        seqResource2.updateEndTime((IDeviceID)d1, 40L);
        seqResource2.updateStartTime((IDeviceID)d2, 40L);
        seqResource2.updateEndTime((IDeviceID)d2, 50L);
        TsFileResource seqResource3 = this.createTsFileResource("3-3-0-0.tsfile", true);
        seqResource3.updateStartTime((IDeviceID)d1, 50L);
        seqResource3.updateEndTime((IDeviceID)d1, 60L);
        seqResource3.updateStartTime((IDeviceID)d2, 60L);
        seqResource3.updateEndTime((IDeviceID)d2, 70L);
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        this.seqResources.add(seqResource3);
        TsFileResource unseqResource1 = this.createTsFileResource("9-9-0-0.tsfile", false);
        unseqResource1.updateStartTime((IDeviceID)d1, 42L);
        unseqResource1.updateEndTime((IDeviceID)d1, 45L);
        unseqResource1.updateStartTime((IDeviceID)d2, 31L);
        unseqResource1.updateEndTime((IDeviceID)d2, 37L);
        this.unseqResources.add(unseqResource1);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("root.testsg", "0", 0L, this.tsFileManager);
        InsertionCrossCompactionTaskResource task = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertEquals(null, (Object)task.toInsertUnSeqFile);
        Assert.assertEquals(null, (Object)task.prevSeqFile);
        Assert.assertEquals(null, (Object)task.nextSeqFile);
        Assert.assertEquals(null, (Object)task.firstUnSeqFileInParitition);
        this.unseqResources.remove(unseqResource1);
        unseqResource1 = this.createTsFileResource("9-9-0-0.tsfile", false);
        unseqResource1.updateStartTime((IDeviceID)d1, 62L);
        unseqResource1.updateEndTime((IDeviceID)d1, 65L);
        unseqResource1.updateStartTime((IDeviceID)d2, 31L);
        unseqResource1.updateEndTime((IDeviceID)d2, 37L);
        this.unseqResources.add(unseqResource1);
        task = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertEquals(null, (Object)task.toInsertUnSeqFile);
        Assert.assertEquals(null, (Object)task.prevSeqFile);
        Assert.assertEquals(null, (Object)task.nextSeqFile);
        Assert.assertEquals(null, (Object)task.firstUnSeqFileInParitition);
    }

    @Test
    public void testInsertionSelectorWithNonOverlapUnseqFile() throws IOException, MergeException {
        PlainDeviceID d1 = new PlainDeviceID("root.testsg.d1");
        PlainDeviceID d2 = new PlainDeviceID("root.testsg.d2");
        PlainDeviceID d3 = new PlainDeviceID("root.testsg.d3");
        PlainDeviceID d4 = new PlainDeviceID("root.testsg.d4");
        PlainDeviceID d5 = new PlainDeviceID("root.testsg.d5");
        TsFileResource seqResource1 = this.createTsFileResource("100-100-0-0.tsfile", true);
        seqResource1.updateStartTime((IDeviceID)d1, 10L);
        seqResource1.updateEndTime((IDeviceID)d1, 20L);
        seqResource1.updateStartTime((IDeviceID)d2, 20L);
        seqResource1.updateEndTime((IDeviceID)d2, 30L);
        seqResource1.serialize();
        this.createTsFileByResource(seqResource1);
        TsFileResource seqResource2 = this.createTsFileResource("200-200-0-0.tsfile", true);
        seqResource2.updateStartTime((IDeviceID)d1, 30L);
        seqResource2.updateEndTime((IDeviceID)d1, 40L);
        seqResource2.updateStartTime((IDeviceID)d2, 40L);
        seqResource2.updateEndTime((IDeviceID)d2, 50L);
        seqResource2.serialize();
        this.createTsFileByResource(seqResource2);
        TsFileResource seqResource3 = this.createTsFileResource("300-300-0-0.tsfile", true);
        seqResource3.updateStartTime((IDeviceID)d1, 50L);
        seqResource3.updateEndTime((IDeviceID)d1, 60L);
        seqResource3.updateStartTime((IDeviceID)d2, 60L);
        seqResource3.updateEndTime((IDeviceID)d2, 70L);
        seqResource3.serialize();
        this.createTsFileByResource(seqResource3);
        TsFileResource seqResource4 = this.createTsFileResource("400-400-0-0.tsfile", true);
        seqResource4.updateStartTime((IDeviceID)d1, 70L);
        seqResource4.updateEndTime((IDeviceID)d1, 80L);
        seqResource4.updateStartTime((IDeviceID)d2, 80L);
        seqResource4.updateEndTime((IDeviceID)d2, 90L);
        seqResource4.serialize();
        this.createTsFileByResource(seqResource4);
        TsFileResource seqResource5 = this.createTsFileResource("500-500-0-0.tsfile", true);
        seqResource5.updateStartTime((IDeviceID)d1, 90L);
        seqResource5.updateEndTime((IDeviceID)d1, 100L);
        seqResource5.updateStartTime((IDeviceID)d2, 100L);
        seqResource5.updateEndTime((IDeviceID)d2, 110L);
        seqResource5.serialize();
        this.createTsFileByResource(seqResource5);
        TsFileResource seqResource6 = this.createTsFileResource("600-600-0-0.tsfile", true);
        seqResource6.updateStartTime((IDeviceID)d1, 110L);
        seqResource6.updateEndTime((IDeviceID)d1, 120L);
        seqResource6.updateStartTime((IDeviceID)d2, 120L);
        seqResource6.updateEndTime((IDeviceID)d2, 130L);
        seqResource6.serialize();
        this.createTsFileByResource(seqResource6);
        TsFileResource seqResource7 = this.createTsFileResource("700-700-0-0.tsfile", true);
        seqResource7.updateStartTime((IDeviceID)d1, 130L);
        seqResource7.updateEndTime((IDeviceID)d1, 140L);
        seqResource7.updateStartTime((IDeviceID)d2, 140L);
        seqResource7.updateEndTime((IDeviceID)d2, 150L);
        seqResource7.serialize();
        this.createTsFileByResource(seqResource7);
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        this.seqResources.add(seqResource3);
        this.seqResources.add(seqResource4);
        this.seqResources.add(seqResource5);
        this.seqResources.add(seqResource6);
        this.seqResources.add(seqResource7);
        TsFileResource unseqResource1 = this.createTsFileResource("9-9-0-0.tsfile", false);
        unseqResource1.updateStartTime((IDeviceID)d1, 42L);
        unseqResource1.updateEndTime((IDeviceID)d1, 45L);
        unseqResource1.updateStartTime((IDeviceID)d2, 31L);
        unseqResource1.updateEndTime((IDeviceID)d2, 97L);
        unseqResource1.serialize();
        this.createTsFileByResource(unseqResource1);
        TsFileResource unseqResource2 = this.createTsFileResource("10-10-0-0.tsfile", false);
        unseqResource2.updateStartTime((IDeviceID)d1, 42L);
        unseqResource2.updateEndTime((IDeviceID)d1, 45L);
        unseqResource2.updateStartTime((IDeviceID)d2, 51L);
        unseqResource2.updateEndTime((IDeviceID)d2, 57L);
        unseqResource2.serialize();
        this.createTsFileByResource(unseqResource2);
        TsFileResource unseqResource3 = this.createTsFileResource("11-11-0-0.tsfile", false);
        unseqResource3.updateStartTime((IDeviceID)d1, 42L);
        unseqResource3.updateEndTime((IDeviceID)d1, 45L);
        unseqResource3.updateStartTime((IDeviceID)d2, 91L);
        unseqResource3.updateEndTime((IDeviceID)d2, 97L);
        unseqResource3.serialize();
        this.createTsFileByResource(unseqResource3);
        TsFileResource unseqResource4 = this.createTsFileResource("12-12-0-0.tsfile", false);
        unseqResource4.updateStartTime((IDeviceID)d3, 4L);
        unseqResource4.updateEndTime((IDeviceID)d3, 155L);
        unseqResource4.serialize();
        this.createTsFileByResource(unseqResource4);
        TsFileResource unseqResource5 = this.createTsFileResource("13-13-0-0.tsfile", false);
        unseqResource5.updateStartTime((IDeviceID)d1, 2L);
        unseqResource5.updateEndTime((IDeviceID)d1, 9L);
        unseqResource5.updateStartTime((IDeviceID)d4, 31L);
        unseqResource5.updateEndTime((IDeviceID)d4, 97L);
        unseqResource5.serialize();
        this.createTsFileByResource(unseqResource5);
        TsFileResource unseqResource6 = this.createTsFileResource("14-14-0-0.tsfile", false);
        unseqResource6.updateStartTime((IDeviceID)d1, 42L);
        unseqResource6.updateEndTime((IDeviceID)d1, 45L);
        unseqResource6.updateStartTime((IDeviceID)d2, 91L);
        unseqResource6.updateEndTime((IDeviceID)d2, 97L);
        unseqResource6.updateStartTime((IDeviceID)d5, 31L);
        unseqResource6.updateEndTime((IDeviceID)d5, 97L);
        unseqResource6.serialize();
        this.createTsFileByResource(unseqResource6);
        TsFileResource unseqResource7 = this.createTsFileResource("15-15-0-0.tsfile", false);
        unseqResource7.updateStartTime((IDeviceID)d1, 222L);
        unseqResource7.updateEndTime((IDeviceID)d1, 250L);
        unseqResource7.updateStartTime((IDeviceID)d2, 981L);
        unseqResource7.updateEndTime((IDeviceID)d2, 987L);
        unseqResource7.updateStartTime((IDeviceID)d5, 31L);
        unseqResource7.updateEndTime((IDeviceID)d5, 97L);
        unseqResource7.serialize();
        this.createTsFileByResource(unseqResource7);
        this.unseqResources.add(unseqResource1);
        this.unseqResources.add(unseqResource2);
        this.unseqResources.add(unseqResource3);
        this.unseqResources.add(unseqResource4);
        this.unseqResources.add(unseqResource5);
        this.unseqResources.add(unseqResource6);
        this.unseqResources.add(unseqResource7);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("root.testsg", "0", 0L, this.tsFileManager);
        for (int i = 1; i < 6; ++i) {
            InsertionCrossCompactionTaskResource taskResource = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.tsFileManager.getTsFileList(true), this.tsFileManager.getTsFileList(false)));
            if (i < 5) {
                Assert.assertTrue((boolean)taskResource.isValid());
                Assert.assertEquals(this.tsFileManager.getTsFileList(false).get(0), (Object)taskResource.firstUnSeqFileInParitition);
            } else {
                Assert.assertFalse((boolean)taskResource.isValid());
            }
            if (i == 1) {
                Assert.assertEquals(this.tsFileManager.getTsFileList(false).get(1), (Object)taskResource.toInsertUnSeqFile);
                Assert.assertEquals(this.tsFileManager.getTsFileList(true).get(1), (Object)taskResource.prevSeqFile);
                Assert.assertEquals(this.tsFileManager.getTsFileList(true).get(2), (Object)taskResource.nextSeqFile);
            } else if (i == 2) {
                Assert.assertEquals(this.tsFileManager.getTsFileList(false).get(2), (Object)taskResource.toInsertUnSeqFile);
                Assert.assertEquals(null, (Object)taskResource.prevSeqFile);
                Assert.assertEquals(this.tsFileManager.getTsFileList(true).get(0), (Object)taskResource.nextSeqFile);
            } else if (i == 3) {
                Assert.assertEquals(this.tsFileManager.getTsFileList(false).get(2), (Object)taskResource.toInsertUnSeqFile);
                Assert.assertNull((Object)taskResource.prevSeqFile);
                Assert.assertEquals(this.tsFileManager.getTsFileList(true).get(0), (Object)taskResource.nextSeqFile);
            } else if (i == 4) {
                Assert.assertEquals(this.tsFileManager.getTsFileList(false).get(3), (Object)taskResource.toInsertUnSeqFile);
                Assert.assertEquals(this.tsFileManager.getTsFileList(true).get(9), (Object)taskResource.prevSeqFile);
                Assert.assertNull((Object)taskResource.nextSeqFile);
            } else {
                Assert.assertNull((Object)taskResource.prevSeqFile);
                Assert.assertNull((Object)taskResource.nextSeqFile);
                Assert.assertNull((Object)taskResource.firstUnSeqFileInParitition);
                Assert.assertNull((Object)taskResource.toInsertUnSeqFile);
            }
            if (taskResource.isValid()) {
                InsertionCrossSpaceCompactionTask task = new InsertionCrossSpaceCompactionTask(new Phaser(1), 0L, this.tsFileManager, taskResource, this.tsFileManager.getNextCompactionTaskId());
                task.start();
            }
            if (i == 1) {
                Assert.assertEquals((long)8L, (long)this.tsFileManager.getTsFileList(true).size());
                Assert.assertEquals((long)6L, (long)this.tsFileManager.getTsFileList(false).size());
                continue;
            }
            if (i == 2) {
                Assert.assertEquals((long)9L, (long)this.tsFileManager.getTsFileList(true).size());
                Assert.assertEquals((long)5L, (long)this.tsFileManager.getTsFileList(false).size());
                continue;
            }
            if (i == 3) {
                Assert.assertEquals((long)10L, (long)this.tsFileManager.getTsFileList(true).size());
                Assert.assertEquals((long)4L, (long)this.tsFileManager.getTsFileList(false).size());
                continue;
            }
            Assert.assertEquals((long)11L, (long)this.tsFileManager.getTsFileList(true).size());
            Assert.assertEquals((long)3L, (long)this.tsFileManager.getTsFileList(false).size());
        }
    }

    @Test
    public void testInsertionIntoCompactingSeqFiles() throws IOException, MergeException {
        PlainDeviceID d1 = new PlainDeviceID("root.testsg.d1");
        PlainDeviceID d2 = new PlainDeviceID("root.testsg.d2");
        PlainDeviceID d3 = new PlainDeviceID("root.testsg.d3");
        TsFileResource seqResource1 = this.createTsFileResource("100-100-0-0.tsfile", true);
        seqResource1.updateStartTime((IDeviceID)d1, 10L);
        seqResource1.updateEndTime((IDeviceID)d1, 20L);
        seqResource1.updateStartTime((IDeviceID)d2, 20L);
        seqResource1.updateEndTime((IDeviceID)d2, 30L);
        seqResource1.serialize();
        this.createTsFileByResource(seqResource1);
        TsFileResource seqResource2 = this.createTsFileResource("200-200-0-0.tsfile", true);
        seqResource2.updateStartTime((IDeviceID)d1, 30L);
        seqResource2.updateEndTime((IDeviceID)d1, 40L);
        seqResource2.updateStartTime((IDeviceID)d2, 40L);
        seqResource2.updateEndTime((IDeviceID)d2, 50L);
        seqResource2.serialize();
        this.createTsFileByResource(seqResource2);
        TsFileResource seqResource3 = this.createTsFileResource("300-300-0-0.tsfile", true);
        seqResource3.updateStartTime((IDeviceID)d3, 50L);
        seqResource3.updateEndTime((IDeviceID)d3, 60L);
        seqResource3.serialize();
        this.createTsFileByResource(seqResource3);
        TsFileResource seqResource4 = this.createTsFileResource("400-400-0-0.tsfile", true);
        seqResource4.updateStartTime((IDeviceID)d3, 70L);
        seqResource4.updateEndTime((IDeviceID)d3, 80L);
        seqResource4.serialize();
        this.createTsFileByResource(seqResource4);
        TsFileResource seqResource5 = this.createTsFileResource("500-500-0-0.tsfile", true);
        seqResource5.updateStartTime((IDeviceID)d2, 100L);
        seqResource5.updateEndTime((IDeviceID)d2, 110L);
        seqResource5.serialize();
        this.createTsFileByResource(seqResource5);
        TsFileResource seqResource6 = this.createTsFileResource("600-600-0-0.tsfile", true);
        seqResource6.updateStartTime((IDeviceID)d1, 110L);
        seqResource6.updateEndTime((IDeviceID)d1, 120L);
        seqResource6.updateStartTime((IDeviceID)d2, 120L);
        seqResource6.updateEndTime((IDeviceID)d2, 130L);
        seqResource6.serialize();
        this.createTsFileByResource(seqResource6);
        TsFileResource seqResource7 = this.createTsFileResource("700-700-0-0.tsfile", true);
        seqResource7.updateStartTime((IDeviceID)d1, 130L);
        seqResource7.updateEndTime((IDeviceID)d1, 140L);
        seqResource7.updateStartTime((IDeviceID)d2, 140L);
        seqResource7.updateEndTime((IDeviceID)d2, 150L);
        seqResource7.serialize();
        this.createTsFileByResource(seqResource7);
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        this.seqResources.add(seqResource3);
        this.seqResources.add(seqResource4);
        this.seqResources.add(seqResource5);
        this.seqResources.add(seqResource6);
        this.seqResources.add(seqResource7);
        TsFileResource unseqResource1 = this.createTsFileResource("9-9-0-0.tsfile", false);
        unseqResource1.updateStartTime((IDeviceID)d1, 42L);
        unseqResource1.updateEndTime((IDeviceID)d1, 45L);
        unseqResource1.updateStartTime((IDeviceID)d2, 61L);
        unseqResource1.updateEndTime((IDeviceID)d2, 97L);
        unseqResource1.serialize();
        this.createTsFileByResource(unseqResource1);
        this.unseqResources.add(unseqResource1);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("root.testsg", "0", 0L, this.tsFileManager);
        InsertionCrossCompactionTaskResource task = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertEquals(this.tsFileManager.getTsFileList(false).get(0), (Object)task.toInsertUnSeqFile);
        Assert.assertEquals(this.tsFileManager.getTsFileList(true).get(1), (Object)task.prevSeqFile);
        Assert.assertEquals(this.tsFileManager.getTsFileList(true).get(2), (Object)task.nextSeqFile);
        Assert.assertEquals(this.tsFileManager.getTsFileList(false).get(0), (Object)task.firstUnSeqFileInParitition);
        for (int i = 0; i < 3; ++i) {
            ((TsFileResource)this.seqResources.get(i)).setStatusForTest(TsFileResourceStatus.COMPACTION_CANDIDATE);
        }
        task = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertEquals(this.tsFileManager.getTsFileList(false).get(0), (Object)task.toInsertUnSeqFile);
        Assert.assertEquals(this.tsFileManager.getTsFileList(true).get(3), (Object)task.prevSeqFile);
        Assert.assertEquals(this.tsFileManager.getTsFileList(true).get(4), (Object)task.nextSeqFile);
        Assert.assertEquals(this.tsFileManager.getTsFileList(false).get(0), (Object)task.firstUnSeqFileInParitition);
        for (TsFileResource resource : this.seqResources) {
            resource.setStatusForTest(TsFileResourceStatus.COMPACTING);
        }
        task = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertEquals(null, (Object)task.toInsertUnSeqFile);
        Assert.assertEquals(null, (Object)task.prevSeqFile);
        Assert.assertEquals(null, (Object)task.nextSeqFile);
        Assert.assertEquals(null, (Object)task.firstUnSeqFileInParitition);
    }

    @Test
    public void testInsertionSelectorWithUnclosedSeqFile() throws MergeException {
        PlainDeviceID d1 = new PlainDeviceID("root.testsg.d1");
        PlainDeviceID d2 = new PlainDeviceID("root.testsg.d2");
        TsFileResource seqResource1 = this.createTsFileResource("100-100-0-0.tsfile", true);
        seqResource1.updateStartTime((IDeviceID)d1, 10L);
        seqResource1.updateEndTime((IDeviceID)d1, 20L);
        seqResource1.updateStartTime((IDeviceID)d2, 20L);
        seqResource1.updateEndTime((IDeviceID)d2, 30L);
        TsFileResource seqResource2 = this.createTsFileResource("200-200-0-0.tsfile", true);
        seqResource2.updateStartTime((IDeviceID)d1, 30L);
        seqResource2.updateEndTime((IDeviceID)d1, 40L);
        seqResource2.updateStartTime((IDeviceID)d2, 40L);
        seqResource2.updateEndTime((IDeviceID)d2, 50L);
        TsFileResource seqResource3 = this.createTsFileResource("300-300-0-0.tsfile", true);
        seqResource3.updateStartTime((IDeviceID)d1, 50L);
        seqResource3.updateEndTime((IDeviceID)d1, 60L);
        seqResource3.updateStartTime((IDeviceID)d2, 60L);
        seqResource3.updateEndTime((IDeviceID)d2, 70L);
        seqResource3.setStatusForTest(TsFileResourceStatus.UNCLOSED);
        TsFileResource seqResource4 = this.createTsFileResource("600-600-0-0.tsfile", true);
        seqResource4.updateStartTime((IDeviceID)d1, 110L);
        seqResource4.updateEndTime((IDeviceID)d1, 120L);
        seqResource4.updateStartTime((IDeviceID)d2, 120L);
        seqResource4.updateEndTime((IDeviceID)d2, 130L);
        seqResource4.setStatusForTest(TsFileResourceStatus.UNCLOSED);
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        this.seqResources.add(seqResource3);
        this.seqResources.add(seqResource4);
        TsFileResource unseqResource1 = this.createTsFileResource("9-9-0-0.tsfile", false);
        unseqResource1.updateStartTime((IDeviceID)d1, 42L);
        unseqResource1.updateEndTime((IDeviceID)d1, 55L);
        unseqResource1.updateStartTime((IDeviceID)d2, 61L);
        unseqResource1.updateEndTime((IDeviceID)d2, 97L);
        TsFileResource unseqResource2 = this.createTsFileResource("10-10-0-0.tsfile", false);
        unseqResource2.updateStartTime((IDeviceID)d1, 42L);
        unseqResource2.updateEndTime((IDeviceID)d1, 45L);
        unseqResource2.updateStartTime((IDeviceID)d2, 51L);
        unseqResource2.updateEndTime((IDeviceID)d2, 57L);
        this.unseqResources.add(unseqResource1);
        this.unseqResources.add(unseqResource2);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("root.testsg", "0", 0L, this.tsFileManager);
        InsertionCrossCompactionTaskResource task = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertNull((Object)task.toInsertUnSeqFile);
        Assert.assertNull((Object)task.prevSeqFile);
        Assert.assertNull((Object)task.nextSeqFile);
        Assert.assertNull((Object)task.firstUnSeqFileInParitition);
        this.unseqResources.remove(unseqResource2);
        TsFileResource unseqResource3 = this.createTsFileResource("11-11-0-0.tsfile", false);
        unseqResource3.updateStartTime((IDeviceID)d1, 80L);
        unseqResource3.updateEndTime((IDeviceID)d1, 90L);
        unseqResource3.updateStartTime((IDeviceID)d2, 80L);
        unseqResource3.updateEndTime((IDeviceID)d2, 90L);
        this.unseqResources.add(unseqResource1);
        this.unseqResources.add(unseqResource3);
        task = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertNull((Object)task.toInsertUnSeqFile);
        Assert.assertNull((Object)task.prevSeqFile);
        Assert.assertNull((Object)task.nextSeqFile);
        Assert.assertNull((Object)task.firstUnSeqFileInParitition);
    }

    @Test
    public void testInsertionSelectorWithUnclosedUnSeqFile() throws MergeException {
        PlainDeviceID d1 = new PlainDeviceID("root.testsg.d1");
        PlainDeviceID d2 = new PlainDeviceID("root.testsg.d2");
        TsFileResource seqResource1 = this.createTsFileResource("100-100-0-0.tsfile", true);
        seqResource1.updateStartTime((IDeviceID)d1, 10L);
        seqResource1.updateEndTime((IDeviceID)d1, 20L);
        seqResource1.updateStartTime((IDeviceID)d2, 20L);
        seqResource1.updateEndTime((IDeviceID)d2, 30L);
        TsFileResource seqResource2 = this.createTsFileResource("200-200-0-0.tsfile", true);
        seqResource2.updateStartTime((IDeviceID)d1, 30L);
        seqResource2.updateEndTime((IDeviceID)d1, 40L);
        seqResource2.updateStartTime((IDeviceID)d2, 40L);
        seqResource2.updateEndTime((IDeviceID)d2, 50L);
        TsFileResource seqResource3 = this.createTsFileResource("300-300-0-0.tsfile", true);
        seqResource3.updateStartTime((IDeviceID)d1, 50L);
        seqResource3.updateEndTime((IDeviceID)d1, 60L);
        seqResource3.updateStartTime((IDeviceID)d2, 60L);
        seqResource3.updateEndTime((IDeviceID)d2, 70L);
        TsFileResource seqResource4 = this.createTsFileResource("600-600-0-0.tsfile", true);
        seqResource4.updateStartTime((IDeviceID)d1, 110L);
        seqResource4.updateEndTime((IDeviceID)d1, 120L);
        seqResource4.updateStartTime((IDeviceID)d2, 120L);
        seqResource4.updateEndTime((IDeviceID)d2, 130L);
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        this.seqResources.add(seqResource3);
        this.seqResources.add(seqResource4);
        TsFileResource unseqResource1 = this.createTsFileResource("9-9-0-0.tsfile", false);
        unseqResource1.updateStartTime((IDeviceID)d1, 42L);
        unseqResource1.updateEndTime((IDeviceID)d1, 55L);
        unseqResource1.updateStartTime((IDeviceID)d2, 61L);
        unseqResource1.updateEndTime((IDeviceID)d2, 97L);
        unseqResource1.setStatusForTest(TsFileResourceStatus.UNCLOSED);
        TsFileResource unseqResource2 = this.createTsFileResource("10-10-0-0.tsfile", false);
        unseqResource2.updateStartTime((IDeviceID)d1, 42L);
        unseqResource2.updateEndTime((IDeviceID)d1, 45L);
        unseqResource2.updateStartTime((IDeviceID)d2, 51L);
        unseqResource2.updateEndTime((IDeviceID)d2, 57L);
        unseqResource1.setStatusForTest(TsFileResourceStatus.UNCLOSED);
        this.unseqResources.add(unseqResource1);
        this.unseqResources.add(unseqResource2);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("root.testsg", "0", 0L, this.tsFileManager);
        InsertionCrossCompactionTaskResource task = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertNull((Object)task.toInsertUnSeqFile);
        Assert.assertNull((Object)task.prevSeqFile);
        Assert.assertNull((Object)task.nextSeqFile);
        Assert.assertNull((Object)task.firstUnSeqFileInParitition);
    }

    @Test
    public void testInsertionSelectorWithNoSeqFilesAndFileTimeIndex() throws MergeException, IOException {
        PlainDeviceID d1 = new PlainDeviceID("root.testsg.d1");
        PlainDeviceID d2 = new PlainDeviceID("root.testsg.d2");
        TsFileResource unseqResource1 = this.createTsFileResource("1-1-0-0.tsfile", false);
        unseqResource1.updateStartTime((IDeviceID)d1, 10L);
        unseqResource1.updateEndTime((IDeviceID)d1, 20L);
        unseqResource1.updateStartTime((IDeviceID)d2, 20L);
        unseqResource1.updateEndTime((IDeviceID)d2, 30L);
        unseqResource1.serialize();
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(unseqResource1.getTsFile());){
            tsFileIOWriter.startChunkGroup((IDeviceID)d1);
            MeasurementSchema schema = new MeasurementSchema("s1", TSDataType.INT64, TSEncoding.PLAIN, CompressionType.SNAPPY);
            ChunkWriterImpl iChunkWriter = new ChunkWriterImpl((IMeasurementSchema)schema);
            ArrayList<TimeRange> pages = new ArrayList<TimeRange>();
            pages.add(new TimeRange(10L, 20L));
            TsFileGeneratorUtils.writeNonAlignedChunk(iChunkWriter, tsFileIOWriter, pages, false);
            tsFileIOWriter.endChunkGroup();
            tsFileIOWriter.startChunkGroup((IDeviceID)d2);
            pages.clear();
            pages.add(new TimeRange(20L, 30L));
            TsFileGeneratorUtils.writeNonAlignedChunk(iChunkWriter, tsFileIOWriter, pages, false);
            tsFileIOWriter.endChunkGroup();
            tsFileIOWriter.endFile();
        }
        TsFileResource unseqResource2 = this.createTsFileResource("2-2-0-0.tsfile", false);
        unseqResource2.updateStartTime((IDeviceID)d1, 30L);
        unseqResource2.updateEndTime((IDeviceID)d1, 40L);
        unseqResource2.updateStartTime((IDeviceID)d2, 40L);
        unseqResource2.updateEndTime((IDeviceID)d2, 50L);
        unseqResource2.serialize();
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(unseqResource2.getTsFile());){
            tsFileIOWriter.startChunkGroup((IDeviceID)d1);
            MeasurementSchema schema = new MeasurementSchema("s1", TSDataType.INT64, TSEncoding.PLAIN, CompressionType.SNAPPY);
            ChunkWriterImpl iChunkWriter = new ChunkWriterImpl((IMeasurementSchema)schema);
            ArrayList<TimeRange> pages = new ArrayList<TimeRange>();
            pages.add(new TimeRange(30L, 40L));
            TsFileGeneratorUtils.writeNonAlignedChunk(iChunkWriter, tsFileIOWriter, pages, false);
            tsFileIOWriter.endChunkGroup();
            tsFileIOWriter.startChunkGroup((IDeviceID)d2);
            pages.clear();
            pages.add(new TimeRange(40L, 50L));
            TsFileGeneratorUtils.writeNonAlignedChunk(iChunkWriter, tsFileIOWriter, pages, false);
            tsFileIOWriter.endChunkGroup();
            tsFileIOWriter.endFile();
        }
        TsFileResource unseqResource3 = this.createTsFileResource("3-3-0-0.tsfile", false);
        unseqResource3.updateStartTime((IDeviceID)d1, 50L);
        unseqResource3.updateEndTime((IDeviceID)d1, 60L);
        unseqResource3.updateStartTime((IDeviceID)d2, 60L);
        unseqResource3.updateEndTime((IDeviceID)d2, 70L);
        unseqResource3.serialize();
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(unseqResource3.getTsFile());){
            tsFileIOWriter.startChunkGroup((IDeviceID)d1);
            MeasurementSchema schema = new MeasurementSchema("s1", TSDataType.INT64, TSEncoding.PLAIN, CompressionType.SNAPPY);
            ChunkWriterImpl iChunkWriter = new ChunkWriterImpl((IMeasurementSchema)schema);
            ArrayList<TimeRange> pages = new ArrayList<TimeRange>();
            pages.add(new TimeRange(50L, 60L));
            TsFileGeneratorUtils.writeNonAlignedChunk(iChunkWriter, tsFileIOWriter, pages, false);
            tsFileIOWriter.endChunkGroup();
            tsFileIOWriter.startChunkGroup((IDeviceID)d2);
            pages.clear();
            pages.add(new TimeRange(60L, 70L));
            TsFileGeneratorUtils.writeNonAlignedChunk(iChunkWriter, tsFileIOWriter, pages, false);
            tsFileIOWriter.endChunkGroup();
            tsFileIOWriter.endFile();
        }
        this.unseqResources.add(unseqResource1);
        this.unseqResources.add(unseqResource2);
        this.unseqResources.add(unseqResource3);
        this.degradeTimeIndex();
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("root.testsg", "0", 0L, this.tsFileManager);
        int i = 1;
        while (this.tsFileManager.getTsFileList(false).size() > 0) {
            InsertionCrossCompactionTaskResource taskResource = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.tsFileManager.getTsFileList(true), this.tsFileManager.getTsFileList(false)));
            Assert.assertTrue((boolean)taskResource.isValid());
            Assert.assertEquals(this.tsFileManager.getTsFileList(false).get(0), (Object)taskResource.firstUnSeqFileInParitition);
            Assert.assertEquals(this.tsFileManager.getTsFileList(false).get(0), (Object)taskResource.toInsertUnSeqFile);
            Assert.assertEquals(null, (Object)taskResource.nextSeqFile);
            if (i == 1) {
                Assert.assertEquals(null, (Object)taskResource.prevSeqFile);
            } else if (i == 2) {
                Assert.assertEquals(this.tsFileManager.getTsFileList(true).get(0), (Object)taskResource.prevSeqFile);
            } else {
                Assert.assertEquals(this.tsFileManager.getTsFileList(true).get(1), (Object)taskResource.prevSeqFile);
            }
            InsertionCrossSpaceCompactionTask task = new InsertionCrossSpaceCompactionTask(new Phaser(1), 0L, this.tsFileManager, taskResource, this.tsFileManager.getNextCompactionTaskId());
            task.start();
            ++i;
        }
        Assert.assertEquals((long)3L, (long)this.tsFileManager.getTsFileList(true).size());
        Assert.assertEquals((long)0L, (long)this.tsFileManager.getTsFileList(false).size());
    }

    @Test
    public void testInsertionSelectorWithNoUnseqFilesAndFileTimeIndex() throws MergeException, IOException {
        PlainDeviceID d1 = new PlainDeviceID("root.testsg.d1");
        PlainDeviceID d2 = new PlainDeviceID("root.testsg.d2");
        TsFileResource seqResource1 = this.createTsFileResource("1-1-0-0.tsfile", true);
        seqResource1.updateStartTime((IDeviceID)d1, 10L);
        seqResource1.updateEndTime((IDeviceID)d1, 20L);
        seqResource1.updateStartTime((IDeviceID)d2, 20L);
        seqResource1.updateEndTime((IDeviceID)d2, 30L);
        seqResource1.serialize();
        TsFileResource seqResource2 = this.createTsFileResource("2-2-0-0.tsfile", true);
        seqResource2.updateStartTime((IDeviceID)d1, 30L);
        seqResource2.updateEndTime((IDeviceID)d1, 40L);
        seqResource2.updateStartTime((IDeviceID)d2, 40L);
        seqResource2.updateEndTime((IDeviceID)d2, 50L);
        seqResource2.serialize();
        TsFileResource seqResource3 = this.createTsFileResource("3-3-0-0.tsfile", true);
        seqResource3.updateStartTime((IDeviceID)d1, 50L);
        seqResource3.updateEndTime((IDeviceID)d1, 60L);
        seqResource3.updateStartTime((IDeviceID)d2, 60L);
        seqResource3.updateEndTime((IDeviceID)d2, 70L);
        seqResource3.serialize();
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        this.seqResources.add(seqResource3);
        this.degradeTimeIndex();
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("root.testsg", "0", 0L, this.tsFileManager);
        InsertionCrossCompactionTaskResource task = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertNull((Object)task.toInsertUnSeqFile);
        Assert.assertNull((Object)task.prevSeqFile);
        Assert.assertNull((Object)task.nextSeqFile);
        Assert.assertNull((Object)task.firstUnSeqFileInParitition);
    }

    @Test
    public void testInsertionSelectorWithOverlapUnseqFileAndFileTimeIndex() throws MergeException, IOException {
        PlainDeviceID d1 = new PlainDeviceID("root.testsg.d1");
        PlainDeviceID d2 = new PlainDeviceID("root.testsg.d2");
        TsFileResource seqResource1 = this.createTsFileResource("1-1-0-0.tsfile", true);
        seqResource1.updateStartTime((IDeviceID)d1, 10L);
        seqResource1.updateEndTime((IDeviceID)d1, 20L);
        seqResource1.updateStartTime((IDeviceID)d2, 20L);
        seqResource1.updateEndTime((IDeviceID)d2, 30L);
        seqResource1.serialize();
        TsFileResource seqResource2 = this.createTsFileResource("2-2-0-0.tsfile", true);
        seqResource2.updateStartTime((IDeviceID)d1, 30L);
        seqResource2.updateEndTime((IDeviceID)d1, 40L);
        seqResource2.updateStartTime((IDeviceID)d2, 40L);
        seqResource2.updateEndTime((IDeviceID)d2, 50L);
        seqResource2.serialize();
        TsFileResource seqResource3 = this.createTsFileResource("3-3-0-0.tsfile", true);
        seqResource3.updateStartTime((IDeviceID)d1, 50L);
        seqResource3.updateEndTime((IDeviceID)d1, 60L);
        seqResource3.updateStartTime((IDeviceID)d2, 60L);
        seqResource3.updateEndTime((IDeviceID)d2, 70L);
        seqResource3.serialize();
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        this.seqResources.add(seqResource3);
        TsFileResource unseqResource1 = this.createTsFileResource("9-9-0-0.tsfile", false);
        unseqResource1.updateStartTime((IDeviceID)d1, 42L);
        unseqResource1.updateEndTime((IDeviceID)d1, 45L);
        unseqResource1.updateStartTime((IDeviceID)d2, 31L);
        unseqResource1.updateEndTime((IDeviceID)d2, 37L);
        unseqResource1.serialize();
        this.unseqResources.add(unseqResource1);
        this.degradeTimeIndex();
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("root.testsg", "0", 0L, this.tsFileManager);
        InsertionCrossCompactionTaskResource task = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertEquals(null, (Object)task.toInsertUnSeqFile);
        Assert.assertEquals(null, (Object)task.prevSeqFile);
        Assert.assertEquals(null, (Object)task.nextSeqFile);
        Assert.assertEquals(null, (Object)task.firstUnSeqFileInParitition);
        this.unseqResources.remove(unseqResource1);
        unseqResource1.remove();
        unseqResource1 = this.createTsFileResource("9-9-0-0.tsfile", false);
        unseqResource1.updateStartTime((IDeviceID)d1, 62L);
        unseqResource1.updateEndTime((IDeviceID)d1, 65L);
        unseqResource1.updateStartTime((IDeviceID)d2, 31L);
        unseqResource1.updateEndTime((IDeviceID)d2, 37L);
        unseqResource1.serialize();
        this.unseqResources.add(unseqResource1);
        this.degradeTimeIndex();
        task = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertEquals(null, (Object)task.toInsertUnSeqFile);
        Assert.assertEquals(null, (Object)task.prevSeqFile);
        Assert.assertEquals(null, (Object)task.nextSeqFile);
        Assert.assertEquals(null, (Object)task.firstUnSeqFileInParitition);
    }

    @Test
    public void testInsertionSelectorWithNonOverlapUnseqFileAndFileTimeIndex() throws IOException, MergeException {
        PlainDeviceID d1 = new PlainDeviceID("root.testsg.d1");
        PlainDeviceID d2 = new PlainDeviceID("root.testsg.d2");
        PlainDeviceID d3 = new PlainDeviceID("root.testsg.d3");
        PlainDeviceID d4 = new PlainDeviceID("root.testsg.d4");
        PlainDeviceID d5 = new PlainDeviceID("root.testsg.d5");
        TsFileResource seqResource1 = this.createTsFileResource("100-100-0-0.tsfile", true);
        seqResource1.updateStartTime((IDeviceID)d1, 10L);
        seqResource1.updateEndTime((IDeviceID)d1, 20L);
        seqResource1.updateStartTime((IDeviceID)d2, 20L);
        seqResource1.updateEndTime((IDeviceID)d2, 30L);
        seqResource1.serialize();
        this.createTsFileByResource(seqResource1);
        TsFileResource seqResource2 = this.createTsFileResource("200-200-0-0.tsfile", true);
        seqResource2.updateStartTime((IDeviceID)d1, 30L);
        seqResource2.updateEndTime((IDeviceID)d1, 40L);
        seqResource2.updateStartTime((IDeviceID)d2, 40L);
        seqResource2.updateEndTime((IDeviceID)d2, 50L);
        seqResource2.serialize();
        this.createTsFileByResource(seqResource2);
        TsFileResource seqResource3 = this.createTsFileResource("300-300-0-0.tsfile", true);
        seqResource3.updateStartTime((IDeviceID)d1, 50L);
        seqResource3.updateEndTime((IDeviceID)d1, 60L);
        seqResource3.updateStartTime((IDeviceID)d2, 60L);
        seqResource3.updateEndTime((IDeviceID)d2, 70L);
        seqResource3.serialize();
        this.createTsFileByResource(seqResource3);
        TsFileResource seqResource4 = this.createTsFileResource("400-400-0-0.tsfile", true);
        seqResource4.updateStartTime((IDeviceID)d1, 70L);
        seqResource4.updateEndTime((IDeviceID)d1, 80L);
        seqResource4.updateStartTime((IDeviceID)d2, 80L);
        seqResource4.updateEndTime((IDeviceID)d2, 90L);
        seqResource4.serialize();
        this.createTsFileByResource(seqResource4);
        TsFileResource seqResource5 = this.createTsFileResource("500-500-0-0.tsfile", true);
        seqResource5.updateStartTime((IDeviceID)d1, 90L);
        seqResource5.updateEndTime((IDeviceID)d1, 100L);
        seqResource5.updateStartTime((IDeviceID)d2, 100L);
        seqResource5.updateEndTime((IDeviceID)d2, 110L);
        seqResource5.serialize();
        this.createTsFileByResource(seqResource5);
        TsFileResource seqResource6 = this.createTsFileResource("600-600-0-0.tsfile", true);
        seqResource6.updateStartTime((IDeviceID)d1, 110L);
        seqResource6.updateEndTime((IDeviceID)d1, 120L);
        seqResource6.updateStartTime((IDeviceID)d2, 120L);
        seqResource6.updateEndTime((IDeviceID)d2, 130L);
        seqResource6.serialize();
        this.createTsFileByResource(seqResource6);
        TsFileResource seqResource7 = this.createTsFileResource("700-700-0-0.tsfile", true);
        seqResource7.updateStartTime((IDeviceID)d1, 130L);
        seqResource7.updateEndTime((IDeviceID)d1, 140L);
        seqResource7.updateStartTime((IDeviceID)d2, 140L);
        seqResource7.updateEndTime((IDeviceID)d2, 150L);
        seqResource7.serialize();
        this.createTsFileByResource(seqResource7);
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        this.seqResources.add(seqResource3);
        this.seqResources.add(seqResource4);
        this.seqResources.add(seqResource5);
        this.seqResources.add(seqResource6);
        this.seqResources.add(seqResource7);
        TsFileResource unseqResource1 = this.createTsFileResource("9-9-0-0.tsfile", false);
        unseqResource1.updateStartTime((IDeviceID)d1, 42L);
        unseqResource1.updateEndTime((IDeviceID)d1, 45L);
        unseqResource1.updateStartTime((IDeviceID)d2, 31L);
        unseqResource1.updateEndTime((IDeviceID)d2, 97L);
        unseqResource1.serialize();
        this.createTsFileByResource(unseqResource1);
        TsFileResource unseqResource2 = this.createTsFileResource("10-10-0-0.tsfile", false);
        unseqResource2.updateStartTime((IDeviceID)d1, 42L);
        unseqResource2.updateEndTime((IDeviceID)d1, 45L);
        unseqResource2.updateStartTime((IDeviceID)d2, 51L);
        unseqResource2.updateEndTime((IDeviceID)d2, 57L);
        unseqResource2.serialize();
        this.createTsFileByResource(unseqResource2);
        TsFileResource unseqResource3 = this.createTsFileResource("11-11-0-0.tsfile", false);
        unseqResource3.updateStartTime((IDeviceID)d1, 42L);
        unseqResource3.updateEndTime((IDeviceID)d1, 45L);
        unseqResource3.updateStartTime((IDeviceID)d2, 91L);
        unseqResource3.updateEndTime((IDeviceID)d2, 97L);
        unseqResource3.serialize();
        this.createTsFileByResource(unseqResource3);
        TsFileResource unseqResource4 = this.createTsFileResource("12-12-0-0.tsfile", false);
        unseqResource4.updateStartTime((IDeviceID)d3, 4L);
        unseqResource4.updateEndTime((IDeviceID)d3, 155L);
        unseqResource4.serialize();
        this.createTsFileByResource(unseqResource4);
        TsFileResource unseqResource5 = this.createTsFileResource("13-13-0-0.tsfile", false);
        unseqResource5.updateStartTime((IDeviceID)d1, 2L);
        unseqResource5.updateEndTime((IDeviceID)d1, 9L);
        unseqResource5.updateStartTime((IDeviceID)d4, 31L);
        unseqResource5.updateEndTime((IDeviceID)d4, 97L);
        unseqResource5.serialize();
        this.createTsFileByResource(unseqResource5);
        TsFileResource unseqResource6 = this.createTsFileResource("14-14-0-0.tsfile", false);
        unseqResource6.updateStartTime((IDeviceID)d1, 42L);
        unseqResource6.updateEndTime((IDeviceID)d1, 45L);
        unseqResource6.updateStartTime((IDeviceID)d2, 91L);
        unseqResource6.updateEndTime((IDeviceID)d2, 97L);
        unseqResource6.updateStartTime((IDeviceID)d5, 31L);
        unseqResource6.updateEndTime((IDeviceID)d5, 97L);
        unseqResource6.serialize();
        this.createTsFileByResource(unseqResource6);
        TsFileResource unseqResource7 = this.createTsFileResource("15-15-0-0.tsfile", false);
        unseqResource7.updateStartTime((IDeviceID)d1, 222L);
        unseqResource7.updateEndTime((IDeviceID)d1, 250L);
        unseqResource7.updateStartTime((IDeviceID)d2, 981L);
        unseqResource7.updateEndTime((IDeviceID)d2, 987L);
        unseqResource7.updateStartTime((IDeviceID)d5, 31L);
        unseqResource7.updateEndTime((IDeviceID)d5, 97L);
        unseqResource7.serialize();
        this.createTsFileByResource(unseqResource7);
        this.unseqResources.add(unseqResource1);
        this.unseqResources.add(unseqResource2);
        this.unseqResources.add(unseqResource3);
        this.unseqResources.add(unseqResource4);
        this.unseqResources.add(unseqResource5);
        this.unseqResources.add(unseqResource6);
        this.unseqResources.add(unseqResource7);
        this.degradeTimeIndex();
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("root.testsg", "0", 0L, this.tsFileManager);
        for (int i = 1; i < 6; ++i) {
            InsertionCrossCompactionTaskResource taskResource = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.tsFileManager.getTsFileList(true), this.tsFileManager.getTsFileList(false)));
            if (i < 5) {
                Assert.assertTrue((boolean)taskResource.isValid());
                Assert.assertEquals(this.tsFileManager.getTsFileList(false).get(0), (Object)taskResource.firstUnSeqFileInParitition);
            } else {
                Assert.assertFalse((boolean)taskResource.isValid());
            }
            if (i == 1) {
                Assert.assertEquals(this.tsFileManager.getTsFileList(false).get(1), (Object)taskResource.toInsertUnSeqFile);
                Assert.assertEquals(this.tsFileManager.getTsFileList(true).get(1), (Object)taskResource.prevSeqFile);
                Assert.assertEquals(this.tsFileManager.getTsFileList(true).get(2), (Object)taskResource.nextSeqFile);
            } else if (i == 2) {
                Assert.assertEquals(this.tsFileManager.getTsFileList(false).get(2), (Object)taskResource.toInsertUnSeqFile);
                Assert.assertEquals(null, (Object)taskResource.prevSeqFile);
                Assert.assertEquals(this.tsFileManager.getTsFileList(true).get(0), (Object)taskResource.nextSeqFile);
            } else if (i == 3) {
                Assert.assertEquals(this.tsFileManager.getTsFileList(false).get(2), (Object)taskResource.toInsertUnSeqFile);
                Assert.assertNull((Object)taskResource.prevSeqFile);
                Assert.assertEquals(this.tsFileManager.getTsFileList(true).get(0), (Object)taskResource.nextSeqFile);
            } else if (i == 4) {
                Assert.assertEquals(this.tsFileManager.getTsFileList(false).get(3), (Object)taskResource.toInsertUnSeqFile);
                Assert.assertEquals(this.tsFileManager.getTsFileList(true).get(9), (Object)taskResource.prevSeqFile);
                Assert.assertNull((Object)taskResource.nextSeqFile);
            } else {
                Assert.assertNull((Object)taskResource.prevSeqFile);
                Assert.assertNull((Object)taskResource.nextSeqFile);
                Assert.assertNull((Object)taskResource.firstUnSeqFileInParitition);
                Assert.assertNull((Object)taskResource.toInsertUnSeqFile);
            }
            if (taskResource.isValid()) {
                InsertionCrossSpaceCompactionTask task = new InsertionCrossSpaceCompactionTask(new Phaser(1), 0L, this.tsFileManager, taskResource, this.tsFileManager.getNextCompactionTaskId());
                task.start();
            }
            if (i == 1) {
                Assert.assertEquals((long)8L, (long)this.tsFileManager.getTsFileList(true).size());
                Assert.assertEquals((long)6L, (long)this.tsFileManager.getTsFileList(false).size());
                continue;
            }
            if (i == 2) {
                Assert.assertEquals((long)9L, (long)this.tsFileManager.getTsFileList(true).size());
                Assert.assertEquals((long)5L, (long)this.tsFileManager.getTsFileList(false).size());
                continue;
            }
            if (i == 3) {
                Assert.assertEquals((long)10L, (long)this.tsFileManager.getTsFileList(true).size());
                Assert.assertEquals((long)4L, (long)this.tsFileManager.getTsFileList(false).size());
                continue;
            }
            Assert.assertEquals((long)11L, (long)this.tsFileManager.getTsFileList(true).size());
            Assert.assertEquals((long)3L, (long)this.tsFileManager.getTsFileList(false).size());
        }
    }

    @Test
    public void testInsertionIntoCompactingSeqFilesAndFileTimeIndex() throws IOException, MergeException {
        PlainDeviceID d1 = new PlainDeviceID("root.testsg.d1");
        PlainDeviceID d2 = new PlainDeviceID("root.testsg.d2");
        PlainDeviceID d3 = new PlainDeviceID("root.testsg.d3");
        TsFileResource seqResource1 = this.createTsFileResource("100-100-0-0.tsfile", true);
        seqResource1.updateStartTime((IDeviceID)d1, 10L);
        seqResource1.updateEndTime((IDeviceID)d1, 20L);
        seqResource1.updateStartTime((IDeviceID)d2, 20L);
        seqResource1.updateEndTime((IDeviceID)d2, 30L);
        seqResource1.serialize();
        this.createTsFileByResource(seqResource1);
        TsFileResource seqResource2 = this.createTsFileResource("200-200-0-0.tsfile", true);
        seqResource2.updateStartTime((IDeviceID)d1, 30L);
        seqResource2.updateEndTime((IDeviceID)d1, 40L);
        seqResource2.updateStartTime((IDeviceID)d2, 40L);
        seqResource2.updateEndTime((IDeviceID)d2, 50L);
        seqResource2.serialize();
        this.createTsFileByResource(seqResource2);
        TsFileResource seqResource3 = this.createTsFileResource("300-300-0-0.tsfile", true);
        seqResource3.updateStartTime((IDeviceID)d3, 50L);
        seqResource3.updateEndTime((IDeviceID)d3, 60L);
        seqResource3.serialize();
        this.createTsFileByResource(seqResource3);
        TsFileResource seqResource4 = this.createTsFileResource("400-400-0-0.tsfile", true);
        seqResource4.updateStartTime((IDeviceID)d3, 70L);
        seqResource4.updateEndTime((IDeviceID)d3, 80L);
        seqResource4.serialize();
        this.createTsFileByResource(seqResource4);
        TsFileResource seqResource5 = this.createTsFileResource("500-500-0-0.tsfile", true);
        seqResource5.updateStartTime((IDeviceID)d2, 100L);
        seqResource5.updateEndTime((IDeviceID)d2, 110L);
        seqResource5.serialize();
        this.createTsFileByResource(seqResource5);
        TsFileResource seqResource6 = this.createTsFileResource("600-600-0-0.tsfile", true);
        seqResource6.updateStartTime((IDeviceID)d1, 110L);
        seqResource6.updateEndTime((IDeviceID)d1, 120L);
        seqResource6.updateStartTime((IDeviceID)d2, 120L);
        seqResource6.updateEndTime((IDeviceID)d2, 130L);
        seqResource6.serialize();
        this.createTsFileByResource(seqResource6);
        TsFileResource seqResource7 = this.createTsFileResource("700-700-0-0.tsfile", true);
        seqResource7.updateStartTime((IDeviceID)d1, 130L);
        seqResource7.updateEndTime((IDeviceID)d1, 140L);
        seqResource7.updateStartTime((IDeviceID)d2, 140L);
        seqResource7.updateEndTime((IDeviceID)d2, 150L);
        seqResource7.serialize();
        this.createTsFileByResource(seqResource7);
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        this.seqResources.add(seqResource3);
        this.seqResources.add(seqResource4);
        this.seqResources.add(seqResource5);
        this.seqResources.add(seqResource6);
        this.seqResources.add(seqResource7);
        TsFileResource unseqResource1 = this.createTsFileResource("9-9-0-0.tsfile", false);
        unseqResource1.updateStartTime((IDeviceID)d1, 42L);
        unseqResource1.updateEndTime((IDeviceID)d1, 45L);
        unseqResource1.updateStartTime((IDeviceID)d2, 61L);
        unseqResource1.updateEndTime((IDeviceID)d2, 97L);
        unseqResource1.serialize();
        this.createTsFileByResource(unseqResource1);
        this.unseqResources.add(unseqResource1);
        this.degradeTimeIndex();
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("root.testsg", "0", 0L, this.tsFileManager);
        InsertionCrossCompactionTaskResource task = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertEquals(this.tsFileManager.getTsFileList(false).get(0), (Object)task.toInsertUnSeqFile);
        Assert.assertEquals(this.tsFileManager.getTsFileList(true).get(1), (Object)task.prevSeqFile);
        Assert.assertEquals(this.tsFileManager.getTsFileList(true).get(2), (Object)task.nextSeqFile);
        Assert.assertEquals(this.tsFileManager.getTsFileList(false).get(0), (Object)task.firstUnSeqFileInParitition);
        for (int i = 0; i < 3; ++i) {
            ((TsFileResource)this.seqResources.get(i)).setStatusForTest(TsFileResourceStatus.COMPACTION_CANDIDATE);
        }
        task = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertEquals(this.tsFileManager.getTsFileList(false).get(0), (Object)task.toInsertUnSeqFile);
        Assert.assertEquals(this.tsFileManager.getTsFileList(true).get(3), (Object)task.prevSeqFile);
        Assert.assertEquals(this.tsFileManager.getTsFileList(true).get(4), (Object)task.nextSeqFile);
        Assert.assertEquals(this.tsFileManager.getTsFileList(false).get(0), (Object)task.firstUnSeqFileInParitition);
        for (TsFileResource resource : this.seqResources) {
            resource.setStatusForTest(TsFileResourceStatus.COMPACTING);
        }
        task = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertEquals(null, (Object)task.toInsertUnSeqFile);
        Assert.assertEquals(null, (Object)task.prevSeqFile);
        Assert.assertEquals(null, (Object)task.nextSeqFile);
        Assert.assertEquals(null, (Object)task.firstUnSeqFileInParitition);
    }

    @Test
    public void testInsertionSelectorWithUnclosedSeqFileAndFileTimeIndex() throws MergeException, IOException {
        PlainDeviceID d1 = new PlainDeviceID("root.testsg.d1");
        PlainDeviceID d2 = new PlainDeviceID("root.testsg.d2");
        TsFileResource seqResource1 = this.createTsFileResource("100-100-0-0.tsfile", true);
        seqResource1.updateStartTime((IDeviceID)d1, 10L);
        seqResource1.updateEndTime((IDeviceID)d1, 20L);
        seqResource1.updateStartTime((IDeviceID)d2, 20L);
        seqResource1.updateEndTime((IDeviceID)d2, 30L);
        seqResource1.serialize();
        TsFileResource seqResource2 = this.createTsFileResource("200-200-0-0.tsfile", true);
        seqResource2.updateStartTime((IDeviceID)d1, 30L);
        seqResource2.updateEndTime((IDeviceID)d1, 40L);
        seqResource2.updateStartTime((IDeviceID)d2, 40L);
        seqResource2.updateEndTime((IDeviceID)d2, 50L);
        seqResource2.serialize();
        TsFileResource seqResource3 = this.createTsFileResource("300-300-0-0.tsfile", true);
        seqResource3.updateStartTime((IDeviceID)d1, 50L);
        seqResource3.updateEndTime((IDeviceID)d1, 60L);
        seqResource3.updateStartTime((IDeviceID)d2, 60L);
        seqResource3.updateEndTime((IDeviceID)d2, 70L);
        seqResource3.serialize();
        seqResource3.setStatusForTest(TsFileResourceStatus.UNCLOSED);
        TsFileResource seqResource4 = this.createTsFileResource("600-600-0-0.tsfile", true);
        seqResource4.updateStartTime((IDeviceID)d1, 110L);
        seqResource4.updateEndTime((IDeviceID)d1, 120L);
        seqResource4.updateStartTime((IDeviceID)d2, 120L);
        seqResource4.updateEndTime((IDeviceID)d2, 130L);
        seqResource4.serialize();
        seqResource4.setStatusForTest(TsFileResourceStatus.UNCLOSED);
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        this.seqResources.add(seqResource3);
        this.seqResources.add(seqResource4);
        TsFileResource unseqResource1 = this.createTsFileResource("9-9-0-0.tsfile", false);
        unseqResource1.updateStartTime((IDeviceID)d1, 42L);
        unseqResource1.updateEndTime((IDeviceID)d1, 55L);
        unseqResource1.updateStartTime((IDeviceID)d2, 61L);
        unseqResource1.updateEndTime((IDeviceID)d2, 97L);
        unseqResource1.serialize();
        TsFileResource unseqResource2 = this.createTsFileResource("10-10-0-0.tsfile", false);
        unseqResource2.updateStartTime((IDeviceID)d1, 42L);
        unseqResource2.updateEndTime((IDeviceID)d1, 45L);
        unseqResource2.updateStartTime((IDeviceID)d2, 51L);
        unseqResource2.updateEndTime((IDeviceID)d2, 57L);
        unseqResource2.serialize();
        this.unseqResources.add(unseqResource1);
        this.unseqResources.add(unseqResource2);
        this.degradeTimeIndex();
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("root.testsg", "0", 0L, this.tsFileManager);
        InsertionCrossCompactionTaskResource task = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertNull((Object)task.toInsertUnSeqFile);
        Assert.assertNull((Object)task.prevSeqFile);
        Assert.assertNull((Object)task.nextSeqFile);
        Assert.assertNull((Object)task.firstUnSeqFileInParitition);
        this.unseqResources.remove(unseqResource2);
        TsFileResource unseqResource3 = this.createTsFileResource("11-11-0-0.tsfile", false);
        unseqResource3.updateStartTime((IDeviceID)d1, 80L);
        unseqResource3.updateEndTime((IDeviceID)d1, 90L);
        unseqResource3.updateStartTime((IDeviceID)d2, 80L);
        unseqResource3.updateEndTime((IDeviceID)d2, 90L);
        unseqResource3.serialize();
        unseqResource3.degradeTimeIndex();
        this.unseqResources.add(unseqResource1);
        this.unseqResources.add(unseqResource3);
        task = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertNull((Object)task.toInsertUnSeqFile);
        Assert.assertNull((Object)task.prevSeqFile);
        Assert.assertNull((Object)task.nextSeqFile);
        Assert.assertNull((Object)task.firstUnSeqFileInParitition);
    }

    @Test
    public void testInsertionSelectorWithUnclosedUnSeqFileAndFileTimeIndex() throws MergeException, IOException {
        PlainDeviceID d1 = new PlainDeviceID("root.testsg.d1");
        PlainDeviceID d2 = new PlainDeviceID("root.testsg.d2");
        TsFileResource seqResource1 = this.createTsFileResource("100-100-0-0.tsfile", true);
        seqResource1.updateStartTime((IDeviceID)d1, 10L);
        seqResource1.updateEndTime((IDeviceID)d1, 20L);
        seqResource1.updateStartTime((IDeviceID)d2, 20L);
        seqResource1.updateEndTime((IDeviceID)d2, 30L);
        seqResource1.serialize();
        TsFileResource seqResource2 = this.createTsFileResource("200-200-0-0.tsfile", true);
        seqResource2.updateStartTime((IDeviceID)d1, 30L);
        seqResource2.updateEndTime((IDeviceID)d1, 40L);
        seqResource2.updateStartTime((IDeviceID)d2, 40L);
        seqResource2.updateEndTime((IDeviceID)d2, 50L);
        seqResource2.serialize();
        TsFileResource seqResource3 = this.createTsFileResource("300-300-0-0.tsfile", true);
        seqResource3.updateStartTime((IDeviceID)d1, 50L);
        seqResource3.updateEndTime((IDeviceID)d1, 60L);
        seqResource3.updateStartTime((IDeviceID)d2, 60L);
        seqResource3.updateEndTime((IDeviceID)d2, 70L);
        seqResource3.serialize();
        TsFileResource seqResource4 = this.createTsFileResource("600-600-0-0.tsfile", true);
        seqResource4.updateStartTime((IDeviceID)d1, 110L);
        seqResource4.updateEndTime((IDeviceID)d1, 120L);
        seqResource4.updateStartTime((IDeviceID)d2, 120L);
        seqResource4.updateEndTime((IDeviceID)d2, 130L);
        seqResource4.serialize();
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        this.seqResources.add(seqResource3);
        this.seqResources.add(seqResource4);
        TsFileResource unseqResource1 = this.createTsFileResource("9-9-0-0.tsfile", false);
        unseqResource1.updateStartTime((IDeviceID)d1, 42L);
        unseqResource1.updateEndTime((IDeviceID)d1, 55L);
        unseqResource1.updateStartTime((IDeviceID)d2, 61L);
        unseqResource1.updateEndTime((IDeviceID)d2, 97L);
        unseqResource1.serialize();
        unseqResource1.setStatusForTest(TsFileResourceStatus.UNCLOSED);
        TsFileResource unseqResource2 = this.createTsFileResource("10-10-0-0.tsfile", false);
        unseqResource2.updateStartTime((IDeviceID)d1, 42L);
        unseqResource2.updateEndTime((IDeviceID)d1, 45L);
        unseqResource2.updateStartTime((IDeviceID)d2, 51L);
        unseqResource2.updateEndTime((IDeviceID)d2, 57L);
        unseqResource2.serialize();
        unseqResource1.setStatusForTest(TsFileResourceStatus.UNCLOSED);
        this.unseqResources.add(unseqResource1);
        this.unseqResources.add(unseqResource2);
        this.degradeTimeIndex();
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("root.testsg", "0", 0L, this.tsFileManager);
        InsertionCrossCompactionTaskResource task = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertNull((Object)task.toInsertUnSeqFile);
        Assert.assertNull((Object)task.prevSeqFile);
        Assert.assertNull((Object)task.nextSeqFile);
        Assert.assertNull((Object)task.firstUnSeqFileInParitition);
    }

    private TsFileResource createTsFileResource(String name, boolean seq) {
        String filePath = (seq ? SEQ_DIRS : UNSEQ_DIRS) + File.separator + name;
        TsFileResource resource = new TsFileResource();
        resource.setTimeIndex((ITimeIndex)new DeviceTimeIndex());
        resource.setFile(new File(filePath));
        resource.setStatusForTest(TsFileResourceStatus.NORMAL);
        resource.setSeq(seq);
        return resource;
    }

    private void createTsFileByResource(TsFileResource resource) throws IOException {
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());){
            for (IDeviceID device : resource.getDevices()) {
                tsFileIOWriter.startChunkGroup(device);
                MeasurementSchema schema = new MeasurementSchema("s1", TSDataType.INT64, TSEncoding.PLAIN, CompressionType.SNAPPY);
                ChunkWriterImpl iChunkWriter = new ChunkWriterImpl((IMeasurementSchema)schema);
                ArrayList<TimeRange> pages = new ArrayList<TimeRange>();
                pages.add(new TimeRange(resource.getStartTime(device), resource.getEndTime(device)));
                TsFileGeneratorUtils.writeNonAlignedChunk(iChunkWriter, tsFileIOWriter, pages, resource.isSeq());
                tsFileIOWriter.endChunkGroup();
            }
            tsFileIOWriter.endFile();
        }
    }

    private void degradeTimeIndex() {
        for (TsFileResource resource : this.seqResources) {
            resource.degradeTimeIndex();
        }
        for (TsFileResource resource : this.unseqResources) {
            resource.degradeTimeIndex();
        }
    }
}

