/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.cross;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Phaser;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.exception.MergeException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.AbstractCompactionTest;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.InsertionCrossSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.log.SimpleCompactionLogger;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.impl.RewriteCrossSpaceCompactionSelector;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.utils.CrossSpaceCompactionCandidate;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.utils.InsertionCrossCompactionTaskResource;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.CompactionFileGeneratorUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.TsFileGeneratorUtils;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.DeviceTimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.ITimeIndex;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.PlainDeviceID;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InsertionCrossSpaceCompactionRecoverTest
extends AbstractCompactionTest {
    @Override
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException, InterruptedException {
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        super.tearDown();
    }

    @Test
    public void testRecoverWithTargetModFileNotExistedAndSourceModFileExisted() throws IOException, MergeException, IllegalPathException {
        PlainDeviceID d1 = new PlainDeviceID("root.testsg.d1");
        PlainDeviceID d2 = new PlainDeviceID("root.testsg.d2");
        TsFileResource seqResource1 = this.createTsFileResource("1-1-0-0.tsfile", true);
        seqResource1.updateStartTime((IDeviceID)d1, 10L);
        seqResource1.updateEndTime((IDeviceID)d1, 20L);
        seqResource1.updateStartTime((IDeviceID)d2, 20L);
        seqResource1.updateEndTime((IDeviceID)d2, 30L);
        this.createTsFileByResource(seqResource1);
        seqResource1.serialize();
        TsFileResource seqResource2 = this.createTsFileResource("3-3-0-0.tsfile", true);
        seqResource2.updateStartTime((IDeviceID)d1, 30L);
        seqResource2.updateEndTime((IDeviceID)d1, 40L);
        seqResource2.updateStartTime((IDeviceID)d2, 40L);
        seqResource2.updateEndTime((IDeviceID)d2, 50L);
        this.createTsFileByResource(seqResource2);
        seqResource2.serialize();
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        TsFileResource unseqResource1 = this.createTsFileResource("9-9-0-0.tsfile", false);
        unseqResource1.updateStartTime((IDeviceID)d1, 22L);
        unseqResource1.updateEndTime((IDeviceID)d1, 25L);
        unseqResource1.updateStartTime((IDeviceID)d2, 31L);
        unseqResource1.updateEndTime((IDeviceID)d2, 37L);
        this.createTsFileByResource(unseqResource1);
        unseqResource1.serialize();
        HashMap<String, Pair<Long, Long>> deleteMap = new HashMap<String, Pair<Long, Long>>();
        deleteMap.put(d1.toStringID() + ".s1", new Pair((Object)0L, (Object)300L));
        CompactionFileGeneratorUtils.generateMods(deleteMap, unseqResource1, false);
        this.unseqResources.add(unseqResource1);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("root.testsg", "0", 0L, this.tsFileManager);
        InsertionCrossCompactionTaskResource taskResource = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertEquals((Object)unseqResource1, (Object)taskResource.toInsertUnSeqFile);
        Assert.assertEquals((Object)seqResource1, (Object)taskResource.prevSeqFile);
        Assert.assertEquals((Object)seqResource2, (Object)taskResource.nextSeqFile);
        Assert.assertEquals((Object)unseqResource1, (Object)taskResource.firstUnSeqFileInParitition);
        InsertionCrossSpaceCompactionTask task = new InsertionCrossSpaceCompactionTask(new Phaser(), 0L, this.tsFileManager, taskResource, 0L);
        TsFileResource targetFile = new TsFileResource(task.generateTargetFile());
        File logFile = new File(targetFile.getTsFilePath() + ".insertion-compaction.log");
        CompactionFileGeneratorUtils.generateMods(deleteMap, unseqResource1, true);
        try (SimpleCompactionLogger logger = new SimpleCompactionLogger(logFile);){
            logger.logSourceFile(taskResource.toInsertUnSeqFile);
            logger.logTargetFile(targetFile);
            logger.force();
            File sourceTsFile = unseqResource1.getTsFile();
            File targetTsFile = targetFile.getTsFile();
            Files.createLink(targetTsFile.toPath(), sourceTsFile.toPath());
            Files.createLink(new File(targetTsFile.getPath() + ".resource").toPath(), new File(sourceTsFile.getPath() + ".resource").toPath());
        }
        new InsertionCrossSpaceCompactionTask("root.testsg", "0", this.tsFileManager, logFile).recover();
        Assert.assertTrue((boolean)unseqResource1.getTsFile().exists());
        Assert.assertTrue((boolean)new File(unseqResource1.getTsFilePath() + ".resource").exists());
        Assert.assertTrue((boolean)unseqResource1.getModFile().exists());
        Assert.assertFalse((boolean)unseqResource1.getCompactionModFile().exists());
        Assert.assertFalse((boolean)targetFile.tsFileExists());
        Assert.assertFalse((boolean)targetFile.resourceFileExists());
        Assert.assertFalse((boolean)targetFile.modFileExists());
    }

    @Test
    public void testRecoverWithTargetModFileNotExistedAndSourceModNotExisted() throws IOException, MergeException, IllegalPathException {
        PlainDeviceID d1 = new PlainDeviceID("root.testsg.d1");
        PlainDeviceID d2 = new PlainDeviceID("root.testsg.d2");
        TsFileResource seqResource1 = this.createTsFileResource("1-1-0-0.tsfile", true);
        seqResource1.updateStartTime((IDeviceID)d1, 10L);
        seqResource1.updateEndTime((IDeviceID)d1, 20L);
        seqResource1.updateStartTime((IDeviceID)d2, 20L);
        seqResource1.updateEndTime((IDeviceID)d2, 30L);
        this.createTsFileByResource(seqResource1);
        seqResource1.serialize();
        TsFileResource seqResource2 = this.createTsFileResource("3-3-0-0.tsfile", true);
        seqResource2.updateStartTime((IDeviceID)d1, 30L);
        seqResource2.updateEndTime((IDeviceID)d1, 40L);
        seqResource2.updateStartTime((IDeviceID)d2, 40L);
        seqResource2.updateEndTime((IDeviceID)d2, 50L);
        this.createTsFileByResource(seqResource2);
        seqResource2.serialize();
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        TsFileResource unseqResource1 = this.createTsFileResource("9-9-0-0.tsfile", false);
        unseqResource1.updateStartTime((IDeviceID)d1, 22L);
        unseqResource1.updateEndTime((IDeviceID)d1, 25L);
        unseqResource1.updateStartTime((IDeviceID)d2, 31L);
        unseqResource1.updateEndTime((IDeviceID)d2, 37L);
        this.createTsFileByResource(unseqResource1);
        unseqResource1.serialize();
        HashMap<String, Pair> deleteMap = new HashMap<String, Pair>();
        deleteMap.put(d1.toStringID() + ".s1", new Pair((Object)0L, (Object)300L));
        this.unseqResources.add(unseqResource1);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("root.testsg", "0", 0L, this.tsFileManager);
        InsertionCrossCompactionTaskResource taskResource = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertEquals((Object)unseqResource1, (Object)taskResource.toInsertUnSeqFile);
        Assert.assertEquals((Object)seqResource1, (Object)taskResource.prevSeqFile);
        Assert.assertEquals((Object)seqResource2, (Object)taskResource.nextSeqFile);
        Assert.assertEquals((Object)unseqResource1, (Object)taskResource.firstUnSeqFileInParitition);
        InsertionCrossSpaceCompactionTask task = new InsertionCrossSpaceCompactionTask(new Phaser(), 0L, this.tsFileManager, taskResource, 0L);
        TsFileResource targetFile = new TsFileResource(task.generateTargetFile());
        File logFile = new File(targetFile.getTsFilePath() + ".insertion-compaction.log");
        try (SimpleCompactionLogger logger = new SimpleCompactionLogger(logFile);){
            logger.logSourceFile(taskResource.toInsertUnSeqFile);
            logger.logTargetFile(targetFile);
            logger.force();
            File sourceTsFile = unseqResource1.getTsFile();
            File targetTsFile = targetFile.getTsFile();
            Files.createLink(targetTsFile.toPath(), sourceTsFile.toPath());
            Files.createLink(new File(targetTsFile.getPath() + ".resource").toPath(), new File(sourceTsFile.getPath() + ".resource").toPath());
            if (unseqResource1.getModFile().exists()) {
                Files.createLink(new File(targetTsFile.getPath() + ".mods").toPath(), new File(sourceTsFile.getPath() + ".mods").toPath());
            }
        }
        new InsertionCrossSpaceCompactionTask("root.testsg", "0", this.tsFileManager, logFile).recover();
        Assert.assertFalse((boolean)unseqResource1.getTsFile().exists());
        Assert.assertFalse((boolean)new File(unseqResource1.getTsFilePath() + ".resource").exists());
        Assert.assertFalse((boolean)unseqResource1.getModFile().exists());
        Assert.assertFalse((boolean)unseqResource1.getCompactionModFile().exists());
        Assert.assertTrue((boolean)targetFile.tsFileExists());
        Assert.assertTrue((boolean)targetFile.resourceFileExists());
        Assert.assertFalse((boolean)targetFile.modFileExists());
    }

    @Test
    public void testRecoverWithAllTargetFileExisted() throws IllegalPathException, IOException, MergeException {
        PlainDeviceID d1 = new PlainDeviceID("root.testsg.d1");
        PlainDeviceID d2 = new PlainDeviceID("root.testsg.d2");
        TsFileResource seqResource1 = this.createTsFileResource("1-1-0-0.tsfile", true);
        seqResource1.updateStartTime((IDeviceID)d1, 10L);
        seqResource1.updateEndTime((IDeviceID)d1, 20L);
        seqResource1.updateStartTime((IDeviceID)d2, 20L);
        seqResource1.updateEndTime((IDeviceID)d2, 30L);
        this.createTsFileByResource(seqResource1);
        seqResource1.serialize();
        TsFileResource seqResource2 = this.createTsFileResource("3-3-0-0.tsfile", true);
        seqResource2.updateStartTime((IDeviceID)d1, 30L);
        seqResource2.updateEndTime((IDeviceID)d1, 40L);
        seqResource2.updateStartTime((IDeviceID)d2, 40L);
        seqResource2.updateEndTime((IDeviceID)d2, 50L);
        this.createTsFileByResource(seqResource2);
        seqResource2.serialize();
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        TsFileResource unseqResource1 = this.createTsFileResource("9-9-0-0.tsfile", false);
        unseqResource1.updateStartTime((IDeviceID)d1, 22L);
        unseqResource1.updateEndTime((IDeviceID)d1, 25L);
        unseqResource1.updateStartTime((IDeviceID)d2, 31L);
        unseqResource1.updateEndTime((IDeviceID)d2, 37L);
        this.createTsFileByResource(unseqResource1);
        unseqResource1.serialize();
        HashMap<String, Pair<Long, Long>> deleteMap = new HashMap<String, Pair<Long, Long>>();
        deleteMap.put(d1.toStringID() + ".s1", new Pair((Object)0L, (Object)300L));
        CompactionFileGeneratorUtils.generateMods(deleteMap, unseqResource1, false);
        this.unseqResources.add(unseqResource1);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("root.testsg", "0", 0L, this.tsFileManager);
        InsertionCrossCompactionTaskResource taskResource = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertEquals((Object)unseqResource1, (Object)taskResource.toInsertUnSeqFile);
        Assert.assertEquals((Object)seqResource1, (Object)taskResource.prevSeqFile);
        Assert.assertEquals((Object)seqResource2, (Object)taskResource.nextSeqFile);
        Assert.assertEquals((Object)unseqResource1, (Object)taskResource.firstUnSeqFileInParitition);
        InsertionCrossSpaceCompactionTask task = new InsertionCrossSpaceCompactionTask(new Phaser(), 0L, this.tsFileManager, taskResource, 0L);
        TsFileResource targetFile = new TsFileResource(task.generateTargetFile());
        File logFile = new File(targetFile.getTsFilePath() + ".insertion-compaction.log");
        CompactionFileGeneratorUtils.generateMods(deleteMap, unseqResource1, true);
        try (SimpleCompactionLogger logger = new SimpleCompactionLogger(logFile);){
            logger.logSourceFile(taskResource.toInsertUnSeqFile);
            logger.logTargetFile(targetFile);
            logger.force();
            File sourceTsFile = unseqResource1.getTsFile();
            File targetTsFile = targetFile.getTsFile();
            Files.createLink(targetTsFile.toPath(), sourceTsFile.toPath());
            Files.createLink(new File(targetTsFile.getPath() + ".resource").toPath(), new File(sourceTsFile.getPath() + ".resource").toPath());
            if (unseqResource1.getModFile().exists()) {
                Files.createLink(new File(targetTsFile.getPath() + ".mods").toPath(), new File(sourceTsFile.getPath() + ".mods").toPath());
            }
        }
        new InsertionCrossSpaceCompactionTask("root.testsg", "0", this.tsFileManager, logFile).recover();
        Assert.assertFalse((boolean)unseqResource1.getTsFile().exists());
        Assert.assertFalse((boolean)new File(unseqResource1.getTsFilePath() + ".resource").exists());
        Assert.assertFalse((boolean)unseqResource1.getModFile().exists());
        Assert.assertFalse((boolean)unseqResource1.getCompactionModFile().exists());
        Assert.assertTrue((boolean)targetFile.tsFileExists());
        Assert.assertTrue((boolean)targetFile.resourceFileExists());
        Assert.assertTrue((boolean)targetFile.modFileExists());
    }

    @Test
    public void testRecoverWithTargetFileNotExist() throws IllegalPathException, IOException, MergeException {
        PlainDeviceID d1 = new PlainDeviceID("root.testsg.d1");
        PlainDeviceID d2 = new PlainDeviceID("root.testsg.d2");
        TsFileResource seqResource1 = this.createTsFileResource("1-1-0-0.tsfile", true);
        seqResource1.updateStartTime((IDeviceID)d1, 10L);
        seqResource1.updateEndTime((IDeviceID)d1, 20L);
        seqResource1.updateStartTime((IDeviceID)d2, 20L);
        seqResource1.updateEndTime((IDeviceID)d2, 30L);
        this.createTsFileByResource(seqResource1);
        seqResource1.serialize();
        TsFileResource seqResource2 = this.createTsFileResource("3-3-0-0.tsfile", true);
        seqResource2.updateStartTime((IDeviceID)d1, 30L);
        seqResource2.updateEndTime((IDeviceID)d1, 40L);
        seqResource2.updateStartTime((IDeviceID)d2, 40L);
        seqResource2.updateEndTime((IDeviceID)d2, 50L);
        this.createTsFileByResource(seqResource2);
        seqResource2.serialize();
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        TsFileResource unseqResource1 = this.createTsFileResource("9-9-0-0.tsfile", false);
        unseqResource1.updateStartTime((IDeviceID)d1, 22L);
        unseqResource1.updateEndTime((IDeviceID)d1, 25L);
        unseqResource1.updateStartTime((IDeviceID)d2, 31L);
        unseqResource1.updateEndTime((IDeviceID)d2, 37L);
        this.createTsFileByResource(unseqResource1);
        unseqResource1.serialize();
        HashMap<String, Pair<Long, Long>> deleteMap = new HashMap<String, Pair<Long, Long>>();
        deleteMap.put(d1.toStringID() + ".s1", new Pair((Object)0L, (Object)300L));
        CompactionFileGeneratorUtils.generateMods(deleteMap, unseqResource1, false);
        this.unseqResources.add(unseqResource1);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("root.testsg", "0", 0L, this.tsFileManager);
        InsertionCrossCompactionTaskResource taskResource = selector.selectOneInsertionTask(new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources));
        Assert.assertEquals((Object)unseqResource1, (Object)taskResource.toInsertUnSeqFile);
        Assert.assertEquals((Object)seqResource1, (Object)taskResource.prevSeqFile);
        Assert.assertEquals((Object)seqResource2, (Object)taskResource.nextSeqFile);
        Assert.assertEquals((Object)unseqResource1, (Object)taskResource.firstUnSeqFileInParitition);
        InsertionCrossSpaceCompactionTask task = new InsertionCrossSpaceCompactionTask(new Phaser(), 0L, this.tsFileManager, taskResource, 0L);
        TsFileResource targetFile = new TsFileResource(task.generateTargetFile());
        File logFile = new File(targetFile.getTsFilePath() + ".insertion-compaction.log");
        CompactionFileGeneratorUtils.generateMods(deleteMap, unseqResource1, true);
        try (SimpleCompactionLogger logger = new SimpleCompactionLogger(logFile);){
            logger.logSourceFile(taskResource.toInsertUnSeqFile);
            logger.logTargetFile(targetFile);
            logger.force();
        }
        new InsertionCrossSpaceCompactionTask("root.testsg", "0", this.tsFileManager, logFile).recover();
        Assert.assertTrue((boolean)unseqResource1.getTsFile().exists());
        Assert.assertTrue((boolean)new File(unseqResource1.getTsFilePath() + ".resource").exists());
        Assert.assertTrue((boolean)unseqResource1.getModFile().exists());
        Assert.assertFalse((boolean)unseqResource1.getCompactionModFile().exists());
        Assert.assertFalse((boolean)targetFile.tsFileExists());
        Assert.assertFalse((boolean)targetFile.resourceFileExists());
        Assert.assertFalse((boolean)targetFile.modFileExists());
    }

    private TsFileResource createTsFileResource(String name, boolean seq) {
        String filePath = (seq ? SEQ_DIRS : UNSEQ_DIRS) + File.separator + name;
        TsFileResource resource = new TsFileResource();
        resource.setTimeIndex((ITimeIndex)new DeviceTimeIndex());
        resource.setFile(new File(filePath));
        resource.setStatusForTest(TsFileResourceStatus.NORMAL);
        resource.setSeq(seq);
        return resource;
    }

    private void createTsFileByResource(TsFileResource resource) throws IOException {
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());){
            for (IDeviceID device : resource.getDevices()) {
                tsFileIOWriter.startChunkGroup(device);
                MeasurementSchema schema = new MeasurementSchema("s1", TSDataType.INT64, TSEncoding.PLAIN, CompressionType.SNAPPY);
                ChunkWriterImpl iChunkWriter = new ChunkWriterImpl((IMeasurementSchema)schema);
                ArrayList<TimeRange> pages = new ArrayList<TimeRange>();
                pages.add(new TimeRange(resource.getStartTime(device), resource.getEndTime(device)));
                TsFileGeneratorUtils.writeNonAlignedChunk(iChunkWriter, tsFileIOWriter, pages, resource.isSeq());
                tsFileIOWriter.endChunkGroup();
            }
            tsFileIOWriter.endFile();
        }
    }
}

