/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.cross;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.MergeException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.AbstractCompactionTest;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.ICompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.ICrossCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.FastCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CrossSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.InnerSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.subtask.FastCompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.ICrossSpaceSelector;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.IInnerSeqSpaceSelector;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.impl.RewriteCrossSpaceCompactionSelector;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.impl.SizeTieredCompactionSelector;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.utils.CrossCompactionTaskResource;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.utils.CrossSpaceCompactionCandidate;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.CompactionFileGeneratorUtils;
import org.apache.iotdb.db.storageengine.dataregion.read.control.FileReaderManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.dataregion.utils.TsFileResourceUtils;
import org.apache.iotdb.db.tools.validate.TsFileValidationTool;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.PlainDeviceID;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.TsFileGeneratorUtils;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CrossSpaceCompactionWithFastPerformerValidationTest
extends AbstractCompactionTest {
    TsFileManager tsFileManager = new TsFileManager(COMPACTION_TEST_SG, "0", STORAGE_GROUP_DIR.getPath());
    private final String oldThreadName = Thread.currentThread().getName();
    private ICrossCompactionPerformer performer = new FastCompactionPerformer(true);

    @Override
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException, InterruptedException {
        super.setUp();
        IoTDBDescriptor.getInstance().getConfig().setMinCrossCompactionUnseqFileLevel(0);
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkSize(1024L);
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        Thread.currentThread().setName("pool-1-IoTDB-Compaction-Worker-1");
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        super.tearDown();
        Thread.currentThread().setName(this.oldThreadName);
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        TsFileValidationTool.badFileNum = 0;
    }

    @Test
    public void test1() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 10, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(2, 10, 10, 1001, 2100, 2100, 100, 100, true, false);
        this.createFiles(1, 10, 10, 1000, 4200, 4200, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 5300, 5300, 100, 100, true, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)1L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(0), this.seqResources.get(2));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(0), this.unseqResources.get(0));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles(), ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles(), this.performer, 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void test2() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 5, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 5, 10, 1000, 2100, 2100, 100, 100, true, false);
        this.createFiles(1, 5, 10, 1500, 3200, 3200, 100, 100, true, false);
        this.createFiles(2, 5, 10, 1000, 4200, 4200, 100, 100, true, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)1L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(0), this.seqResources.get(2));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(0), this.unseqResources.get(0));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles(), ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles(), this.performer, 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void test3() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 5, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 5, 10, 1500, 1500, 1500, 100, 100, true, false);
        this.createFiles(1, 5, 10, 1000, 3100, 3100, 100, 100, true, false);
        this.createFiles(2, 5, 10, 1000, 4200, 4200, 100, 100, true, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(0), this.seqResources.get(1));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(1), this.seqResources.get(2));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(0), this.unseqResources.get(0));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles(), ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles(), this.performer, 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void test4() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 5, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 5, 10, 1000, 1500, 1500, 100, 100, true, false);
        this.createFiles(1, 5, 10, 300, 1700, 1700, 100, 100, true, false);
        this.createFiles(1, 5, 10, 1000, 2400, 2400, 100, 100, true, false);
        this.createFiles(1, 5, 10, 1200, 3300, 3300, 100, 100, true, false);
        this.createFiles(2, 5, 10, 1000, 4200, 4200, 100, 100, true, true);
        this.createFiles(1, 5, 10, 1000, 6500, 6500, 100, 100, true, true);
        this.createFiles(1, 5, 10, 1000, 6301, 6301, 100, 100, true, false);
        ((TsFileResource)this.seqResources.get(4)).setStatusForTest(TsFileResourceStatus.UNCLOSED);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)4L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(0), this.seqResources.get(1));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(1), this.seqResources.get(2));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(0), this.unseqResources.get(0));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(1), this.unseqResources.get(1));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(2), this.unseqResources.get(2));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(3), this.unseqResources.get(3));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles(), ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles(), this.performer, 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void test5() throws MetadataException, IOException, WriteProcessException, MergeException {
        IoTDBDescriptor.getInstance().getConfig().setFileLimitPerCrossTask(7);
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(7, 5, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 5, 10, 3300, 2150, 2150, 100, 100, true, false);
        this.createFiles(1, 5, 10, 4400, 1150, 1150, 100, 100, true, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)5L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(0), this.seqResources.get(1));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(1), this.seqResources.get(2));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(2), this.seqResources.get(3));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(3), this.seqResources.get(4));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(4), this.seqResources.get(5));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(0), this.unseqResources.get(0));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles(), ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles(), this.performer, 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void test6() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 5, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 5, 10, 3000, 1100, 1100, 100, 100, true, true);
        this.createFiles(2, 5, 10, 1000, 4200, 4200, 100, 100, true, true);
        this.createFiles(2, 5, 10, 1000, 1500, 1500, 100, 100, true, false);
        this.createFiles(1, 5, 10, 1000, 2000, 2000, 100, 100, true, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)1L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)3L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        for (TsFileResource selectedResource : ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles()) {
            Assert.assertEquals((Object)selectedResource, this.seqResources.get(1));
        }
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(0), this.unseqResources.get(0));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(1), this.unseqResources.get(1));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(2), this.unseqResources.get(2));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles(), ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles(), this.performer, 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void test7() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 5, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 5, 10, 3000, 1100, 1100, 100, 100, true, true);
        this.createFiles(3, 5, 10, 1000, 4200, 4200, 100, 100, true, true);
        this.createFiles(2, 5, 10, 1000, 1500, 1500, 100, 100, true, false);
        this.createFiles(1, 5, 10, 1000, 2000, 2000, 100, 100, true, false);
        this.createFiles(1, 5, 10, 4050, 1200, 1200, 100, 100, true, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)3L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)4L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(0), this.seqResources.get(1));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(1), this.seqResources.get(2));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(2), this.seqResources.get(3));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(0), this.unseqResources.get(0));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(1), this.unseqResources.get(1));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(2), this.unseqResources.get(2));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(3), this.unseqResources.get(3));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles(), ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles(), this.performer, 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void test8() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 5, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 5, 10, 1000, 1500, 1500, 100, 100, true, false);
        this.createFiles(1, 5, 10, 300, 1700, 1700, 100, 100, true, false);
        this.createFiles(1, 5, 10, 1000, 2400, 2400, 100, 100, true, false);
        this.createFiles(1, 5, 10, 1200, 3300, 3300, 100, 100, true, false);
        this.createFiles(2, 5, 10, 1000, 4200, 4200, 100, 100, true, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)4L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(0), this.seqResources.get(1));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(1), this.seqResources.get(2));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(0), this.unseqResources.get(0));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(1), this.unseqResources.get(1));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(2), this.unseqResources.get(2));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(3), this.unseqResources.get(3));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles(), ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles(), this.performer, 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewAlignedDeviceAndSensorInUnseqFile10() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 10, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(2, 10, 10, 1000, 2100, 2100, 100, 100, true, false);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, true, true);
        this.createFiles(2, 10, 10, 1000, 5300, 5300, 100, 100, true, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(0), this.seqResources.get(2));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(1), this.seqResources.get(3));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(0), this.unseqResources.get(0));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles(), ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles(), this.performer, 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewAlignedDeviceAndSensorInUnseqFile11() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 10, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(2, 10, 10, 1000, 2100, 2100, 100, 100, true, false);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, true, true);
        this.createFiles(1, 10, 5, 1000, 5300, 5300, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 6400, 6400, 100, 100, true, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(0), this.seqResources.get(2));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(1), this.seqResources.get(3));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(0), this.unseqResources.get(0));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles(), ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles(), this.performer, 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewAlignedDeviceAndSensorInUnseqFile12() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 10, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(2, 10, 10, 1000, 2100, 2100, 100, 100, true, false);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, true, true);
        this.createFiles(1, 5, 10, 1000, 5300, 5300, 100, 100, true, true);
        this.createFiles(1, 10, 7, 1000, 6400, 6400, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 7500, 7500, 100, 100, true, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(0), this.seqResources.get(2));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(1), this.seqResources.get(4));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(0), this.unseqResources.get(0));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles(), ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles(), this.performer, 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewAlignedDeviceAndSensorInUnseqFile20() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 10, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 2100, 2100, 100, 100, true, false);
        this.createFiles(1, 10, 10, 1500, 3200, 3200, 100, 100, true, false);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, true, true);
        this.createFiles(2, 10, 10, 1000, 5300, 5300, 100, 100, true, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(0), this.seqResources.get(2));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(1), this.seqResources.get(3));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(0), this.unseqResources.get(0));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles(), ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles(), this.performer, 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewAlignedDeviceAndSensorInUnseqFile21() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 10, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 2100, 2100, 100, 100, true, false);
        this.createFiles(1, 10, 10, 1500, 3200, 3200, 100, 100, true, false);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, true, true);
        this.createFiles(1, 10, 5, 1000, 5300, 5300, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 6400, 6400, 100, 100, true, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(0), this.seqResources.get(2));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(1), this.seqResources.get(3));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(0), this.unseqResources.get(0));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles(), ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles(), this.performer, 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewAlignedDeviceAndSensorInUnseqFile22() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 10, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 2100, 2100, 100, 100, true, false);
        this.createFiles(1, 10, 10, 1500, 3200, 3200, 100, 100, true, false);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, true, true);
        this.createFiles(1, 5, 10, 1000, 5300, 5300, 100, 100, true, true);
        this.createFiles(1, 10, 7, 1000, 6400, 6400, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 7500, 7500, 100, 100, true, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(0), this.seqResources.get(2));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(1), this.seqResources.get(4));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(0), this.unseqResources.get(0));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles(), ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles(), this.performer, 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewAlignedDeviceAndSensorInUnseqFile30() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 10, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 5, 5, 1000, 1100, 1100, 100, 100, true, true);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, true, true);
        this.createFiles(2, 10, 10, 1000, 5300, 5300, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1500, 1500, 1500, 100, 100, true, false);
        this.createFiles(1, 10, 10, 1000, 3100, 3100, 100, 100, true, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)3L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(0), this.seqResources.get(1));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(1), this.seqResources.get(2));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(2), this.seqResources.get(3));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(0), this.unseqResources.get(0));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles(), ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles(), this.performer, 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewAlignedDeviceAndSensorInUnseqFile31() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 10, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 5, 5, 1000, 1100, 1100, 100, 100, true, true);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, true, true);
        this.createFiles(1, 10, 5, 1000, 5300, 5300, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 6400, 6400, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1500, 1500, 1500, 100, 100, true, false);
        this.createFiles(1, 10, 10, 1000, 3100, 3100, 100, 100, true, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)3L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(0), this.seqResources.get(1));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(1), this.seqResources.get(2));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(2), this.seqResources.get(3));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(0), this.unseqResources.get(0));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles(), ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles(), this.performer, 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewAlignedDeviceAndSensorInUnseqFile32() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 10, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 5, 5, 1000, 1100, 1100, 100, 100, true, true);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, true, true);
        this.createFiles(1, 5, 10, 1000, 5300, 5300, 100, 100, true, true);
        this.createFiles(1, 10, 7, 1000, 6400, 6400, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 7500, 7500, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1500, 1500, 1500, 100, 100, true, false);
        this.createFiles(1, 10, 10, 1000, 3100, 3100, 100, 100, true, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)3L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(0), this.seqResources.get(1));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(1), this.seqResources.get(2));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(2), this.seqResources.get(4));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(0), this.unseqResources.get(0));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles(), ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles(), this.performer, 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewAlignedDeviceAndSensorInUnseqFile50() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 10, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 6, 6, 1000, 1100, 1100, 100, 100, true, true);
        this.createFiles(1, 5, 5, 1000, 2200, 2200, 100, 100, true, true);
        this.createFiles(1, 4, 4, 1000, 3300, 3300, 100, 100, true, true);
        this.createFiles(1, 3, 3, 1000, 4400, 4400, 100, 100, true, true);
        this.createFiles(1, 2, 2, 1000, 5500, 5500, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 6600, 6600, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 7700, 7700, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 8800, 8800, 100, 100, true, true);
        this.createFiles(1, 10, 10, 3300, 2150, 2150, 100, 100, true, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)5L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)1L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(0), this.seqResources.get(2));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(1), this.seqResources.get(3));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(2), this.seqResources.get(4));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(3), this.seqResources.get(5));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(4), this.seqResources.get(6));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(0), this.unseqResources.get(0));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles(), ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles(), this.performer, 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewAlignedDeviceAndSensorInUnseqFile51() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 10, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 6, 6, 1000, 1100, 1100, 100, 100, true, true);
        this.createFiles(1, 5, 5, 1000, 2200, 2200, 100, 100, true, true);
        this.createFiles(1, 4, 4, 1000, 3300, 3300, 100, 100, true, true);
        this.createFiles(1, 3, 3, 1000, 4400, 4400, 100, 100, true, true);
        this.createFiles(1, 2, 2, 1000, 5500, 5500, 100, 100, true, true);
        this.createFiles(1, 10, 5, 1000, 6600, 6600, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 7700, 7700, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 8800, 8800, 100, 100, true, true);
        this.createFiles(1, 10, 10, 3300, 2150, 2150, 100, 100, true, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)5L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)1L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(0), this.seqResources.get(2));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(1), this.seqResources.get(3));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(2), this.seqResources.get(4));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(3), this.seqResources.get(5));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(4), this.seqResources.get(6));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(0), this.unseqResources.get(0));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles(), ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles(), this.performer, 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewAlignedDeviceAndSensorInUnseqFile52() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 10, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 6, 6, 1000, 1100, 1100, 100, 100, true, true);
        this.createFiles(1, 5, 5, 1000, 2200, 2200, 100, 100, true, true);
        this.createFiles(1, 4, 4, 1000, 3300, 3300, 100, 100, true, true);
        this.createFiles(1, 3, 3, 1000, 4400, 4400, 100, 100, true, true);
        this.createFiles(1, 2, 2, 1000, 5500, 5500, 100, 100, true, true);
        this.createFiles(1, 5, 10, 1000, 6600, 6600, 100, 100, true, true);
        this.createFiles(1, 10, 7, 1000, 7700, 7700, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 8800, 8800, 100, 100, true, true);
        this.createFiles(1, 10, 10, 3300, 2150, 2150, 100, 100, true, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)6L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)1L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(0), this.seqResources.get(2));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(1), this.seqResources.get(3));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(2), this.seqResources.get(4));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(3), this.seqResources.get(5));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(4), this.seqResources.get(6));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(5), this.seqResources.get(7));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(0), this.unseqResources.get(0));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles(), ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles(), this.performer, 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewAlignedDeviceAndSensorInUnseqFile53() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 10, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 6, 6, 1000, 1100, 1100, 100, 100, true, true);
        this.createFiles(1, 5, 5, 1000, 2200, 2200, 100, 100, true, true);
        this.createFiles(1, 4, 4, 1000, 3300, 3300, 100, 100, true, true);
        this.createFiles(1, 3, 3, 1000, 4400, 4400, 100, 100, true, true);
        this.createFiles(1, 5, 2, 1000, 5500, 5500, 100, 100, true, true);
        this.createFiles(1, 5, 10, 1000, 6600, 6600, 100, 100, true, true);
        this.createFiles(1, 10, 7, 1000, 7700, 7700, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 8800, 8800, 100, 100, true, true);
        this.createFiles(1, 10, 10, 3300, 2150, 2150, 100, 100, true, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)5L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)1L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(0), this.seqResources.get(2));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(1), this.seqResources.get(3));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(2), this.seqResources.get(4));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(3), this.seqResources.get(5));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(4), this.seqResources.get(7));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(0), this.unseqResources.get(0));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles(), ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles(), this.performer, 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewDeviceAndSensorInUnseqFile10() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(2, 10, 10, 1000, 2100, 2100, 100, 100, false, false);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, false, true);
        this.createFiles(2, 10, 10, 1000, 5300, 5300, 100, 100, false, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(0), this.seqResources.get(2));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(1), this.seqResources.get(3));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(0), this.unseqResources.get(0));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles(), ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles(), this.performer, 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewDeviceAndSensorInUnseqFile11() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(2, 10, 10, 1000, 2100, 2100, 100, 100, false, false);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, false, true);
        this.createFiles(1, 10, 5, 1000, 5300, 5300, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 6400, 6400, 100, 100, false, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(0), this.seqResources.get(2));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(1), this.seqResources.get(3));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(0), this.unseqResources.get(0));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles(), ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles(), this.performer, 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewDeviceAndSensorInUnseqFile12() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(2, 10, 10, 1000, 2100, 2100, 100, 100, false, false);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, false, true);
        this.createFiles(1, 5, 10, 1000, 5300, 5300, 100, 100, false, true);
        this.createFiles(1, 10, 7, 1000, 6400, 6400, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 7500, 7500, 100, 100, false, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(0), this.seqResources.get(2));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(1), this.seqResources.get(4));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(0), this.unseqResources.get(0));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles(), ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles(), this.performer, 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewDeviceAndSensorInUnseqFile20() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 2100, 2100, 100, 100, false, false);
        this.createFiles(1, 10, 10, 1500, 3200, 3200, 100, 100, false, false);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, false, true);
        this.createFiles(2, 10, 10, 1000, 5300, 5300, 100, 100, false, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(0), this.seqResources.get(2));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(1), this.seqResources.get(3));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(0), this.unseqResources.get(0));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles(), ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles(), this.performer, 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewDeviceAndSensorInUnseqFile21() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 2100, 2100, 100, 100, false, false);
        this.createFiles(1, 10, 10, 1500, 3200, 3200, 100, 100, false, false);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, false, true);
        this.createFiles(1, 10, 5, 1000, 5300, 5300, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 6400, 6400, 100, 100, false, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(0), this.seqResources.get(2));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(1), this.seqResources.get(3));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(0), this.unseqResources.get(0));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles(), ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles(), this.performer, 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewDeviceAndSensorInUnseqFile22() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, false, true);
        this.createFiles(1, 5, 10, 1000, 5300, 5300, 100, 100, false, true);
        this.createFiles(1, 10, 7, 1000, 6400, 6400, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 7500, 7500, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 2100, 2100, 100, 100, false, false);
        this.createFiles(1, 10, 10, 1500, 3200, 3200, 100, 100, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(0), this.seqResources.get(2));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(1), this.seqResources.get(4));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(0), this.unseqResources.get(0));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles(), ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles(), this.performer, 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewDeviceAndSensorInUnseqFile30() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 5, 5, 1000, 1100, 1100, 100, 100, false, true);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, false, true);
        this.createFiles(2, 10, 10, 1000, 5300, 5300, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1500, 1500, 1500, 100, 100, false, false);
        this.createFiles(1, 10, 10, 1000, 3100, 3100, 100, 100, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)3L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(0), this.seqResources.get(1));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(1), this.seqResources.get(2));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(2), this.seqResources.get(3));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(0), this.unseqResources.get(0));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles(), ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles(), this.performer, 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewDeviceAndSensorInUnseqFile31() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 5, 5, 1000, 1100, 1100, 100, 100, false, true);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, false, true);
        this.createFiles(1, 10, 5, 1000, 5300, 5300, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 6400, 6400, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1500, 1500, 1500, 100, 100, false, false);
        this.createFiles(1, 10, 10, 1000, 3100, 3100, 100, 100, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)3L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(0), this.seqResources.get(1));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(1), this.seqResources.get(2));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(2), this.seqResources.get(3));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(0), this.unseqResources.get(0));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles(), ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles(), this.performer, 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewDeviceAndSensorInUnseqFile32() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 5, 5, 1000, 1100, 1100, 100, 100, false, true);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, false, true);
        this.createFiles(1, 5, 10, 1000, 5300, 5300, 100, 100, false, true);
        this.createFiles(1, 10, 7, 1000, 6400, 6400, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 7500, 7500, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1500, 1500, 1500, 100, 100, false, false);
        this.createFiles(1, 10, 10, 1000, 3100, 3100, 100, 100, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)3L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(0), this.seqResources.get(1));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(1), this.seqResources.get(2));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(2), this.seqResources.get(4));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(0), this.unseqResources.get(0));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles(), ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles(), this.performer, 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewDeviceAndSensorInUnseqFile50() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 6, 6, 1000, 1100, 1100, 100, 100, false, true);
        this.createFiles(1, 5, 5, 1000, 2200, 2200, 100, 100, false, true);
        this.createFiles(1, 4, 4, 1000, 3300, 3300, 100, 100, false, true);
        this.createFiles(1, 3, 3, 1000, 4400, 4400, 100, 100, false, true);
        this.createFiles(1, 2, 2, 1000, 5500, 5500, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 6600, 6600, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 7700, 7700, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 8800, 8800, 100, 100, false, true);
        this.createFiles(1, 10, 10, 3300, 2150, 2150, 100, 100, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)5L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)1L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(0), this.seqResources.get(2));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(1), this.seqResources.get(3));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(2), this.seqResources.get(4));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(3), this.seqResources.get(5));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(4), this.seqResources.get(6));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(0), this.unseqResources.get(0));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles(), ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles(), this.performer, 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewDeviceAndSensorInUnseqFile51() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 6, 6, 1000, 1100, 1100, 100, 100, false, true);
        this.createFiles(1, 5, 5, 1000, 2200, 2200, 100, 100, false, true);
        this.createFiles(1, 4, 4, 1000, 3300, 3300, 100, 100, false, true);
        this.createFiles(1, 3, 3, 1000, 4400, 4400, 100, 100, false, true);
        this.createFiles(1, 2, 2, 1000, 5500, 5500, 100, 100, false, true);
        this.createFiles(1, 10, 5, 1000, 6600, 6600, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 7700, 7700, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 8800, 8800, 100, 100, false, true);
        this.createFiles(1, 10, 10, 3300, 2150, 2150, 100, 100, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)5L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)1L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(0), this.seqResources.get(2));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(1), this.seqResources.get(3));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(2), this.seqResources.get(4));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(3), this.seqResources.get(5));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(4), this.seqResources.get(6));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(0), this.unseqResources.get(0));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles(), ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles(), this.performer, 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewDeviceAndSensorInUnseqFile52() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 6, 6, 1000, 1100, 1100, 100, 100, false, true);
        this.createFiles(1, 5, 5, 1000, 2200, 2200, 100, 100, false, true);
        this.createFiles(1, 4, 4, 1000, 3300, 3300, 100, 100, false, true);
        this.createFiles(1, 3, 3, 1000, 4400, 4400, 100, 100, false, true);
        this.createFiles(1, 2, 2, 1000, 5500, 5500, 100, 100, false, true);
        this.createFiles(1, 5, 10, 1000, 6600, 6600, 100, 100, false, true);
        this.createFiles(1, 10, 7, 1000, 7700, 7700, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 8800, 8800, 100, 100, false, true);
        this.createFiles(1, 10, 10, 3300, 2150, 2150, 100, 100, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)6L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)1L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(0), this.seqResources.get(2));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(1), this.seqResources.get(3));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(2), this.seqResources.get(4));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(3), this.seqResources.get(5));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(4), this.seqResources.get(6));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(5), this.seqResources.get(7));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(0), this.unseqResources.get(0));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles(), ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles(), this.performer, 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewDeviceAndSensorInUnseqFile53() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 6, 6, 1000, 1100, 1100, 100, 100, false, true);
        this.createFiles(1, 5, 5, 1000, 2200, 2200, 100, 100, false, true);
        this.createFiles(1, 4, 4, 1000, 3300, 3300, 100, 100, false, true);
        this.createFiles(1, 3, 3, 1000, 4400, 4400, 100, 100, false, true);
        this.createFiles(1, 5, 2, 1000, 5500, 5500, 100, 100, false, true);
        this.createFiles(1, 5, 10, 1000, 6600, 6600, 100, 100, false, true);
        this.createFiles(1, 10, 7, 1000, 7700, 7700, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 8800, 8800, 100, 100, false, true);
        this.createFiles(1, 10, 10, 3300, 2150, 2150, 100, 100, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)5L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)1L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(0), this.seqResources.get(2));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(1), this.seqResources.get(3));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(2), this.seqResources.get(4));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(3), this.seqResources.get(5));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(4), this.seqResources.get(7));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(0), this.unseqResources.get(0));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles(), ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles(), this.performer, 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithUnclosedSeqFile() throws MergeException, IOException, MetadataException, WriteProcessException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(5, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 2500, 2500, 100, 100, false, false);
        TsFileResource unclosedSeqResource = new TsFileResource(((TsFileResource)this.seqResources.get(4)).getTsFile());
        unclosedSeqResource.setStatusForTest(TsFileResourceStatus.UNCLOSED);
        TsFileResource lastSeqResource = (TsFileResource)this.seqResources.get(4);
        for (IDeviceID deviceID : lastSeqResource.getDevices()) {
            unclosedSeqResource.updateStartTime(deviceID, lastSeqResource.getStartTime(deviceID));
        }
        this.seqResources.remove(4);
        this.seqResources.add(4, unclosedSeqResource);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)1L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(0), this.seqResources.get(2));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(1), this.seqResources.get(3));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(0), this.unseqResources.get(0));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles(), ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles(), this.performer, 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithUnclosedSeqFileAndNewSensorInUnseqFile() throws MergeException, IOException, MetadataException, WriteProcessException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(3, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 5, 5, 1000, 3300, 3300, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 4400, 4400, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 2500, 2500, 100, 100, false, false);
        TsFileResource unclosedSeqResource = new TsFileResource(((TsFileResource)this.seqResources.get(4)).getTsFile());
        unclosedSeqResource.setStatusForTest(TsFileResourceStatus.UNCLOSED);
        TsFileResource lastSeqResource = (TsFileResource)this.seqResources.get(4);
        for (IDeviceID deviceID : lastSeqResource.getDevices()) {
            unclosedSeqResource.updateStartTime(deviceID, lastSeqResource.getStartTime(deviceID));
        }
        this.seqResources.remove(4);
        this.seqResources.add(4, unclosedSeqResource);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        new CrossSpaceCompactionTask(0L, this.tsFileManager, ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles(), ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles(), this.performer, 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testUnseqFileOverlapWithUnclosedSeqFile() throws MergeException, IOException, MetadataException, WriteProcessException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(5, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 2500, 2500, 100, 100, false, false);
        this.createFiles(1, 5, 5, 3000, 1500, 1500, 100, 100, false, false);
        TsFileResource unclosedSeqResource = new TsFileResource(((TsFileResource)this.seqResources.get(4)).getTsFile());
        unclosedSeqResource.setStatusForTest(TsFileResourceStatus.UNCLOSED);
        TsFileResource lastSeqResource = (TsFileResource)this.seqResources.get(4);
        for (IDeviceID deviceID : lastSeqResource.getDevices()) {
            unclosedSeqResource.updateStartTime(deviceID, lastSeqResource.getStartTime(deviceID));
        }
        this.seqResources.remove(4);
        this.seqResources.add(4, unclosedSeqResource);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)1L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(0), this.seqResources.get(2));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(1), this.seqResources.get(3));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(0), this.unseqResources.get(0));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles(), ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles(), this.performer, 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testUnseqFileOverlapWithUnclosedSeqFile2() throws MergeException, IOException, MetadataException, WriteProcessException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(5, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 2500, 2500, 100, 100, false, false);
        this.createFiles(1, 5, 5, 50, 4310, 4310, 100, 100, false, false);
        TsFileResource unclosedSeqResource = new TsFileResource(((TsFileResource)this.seqResources.get(4)).getTsFile());
        unclosedSeqResource.setStatusForTest(TsFileResourceStatus.UNCLOSED);
        TsFileResource lastSeqResource = (TsFileResource)this.seqResources.get(4);
        for (IDeviceID deviceID : lastSeqResource.getDevices()) {
            unclosedSeqResource.updateStartTime(deviceID, lastSeqResource.getStartTime(deviceID));
        }
        this.seqResources.remove(4);
        this.seqResources.add(4, unclosedSeqResource);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(0), this.seqResources.get(2));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(1), this.seqResources.get(3));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(0), this.unseqResources.get(0));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles(), ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles(), this.performer, 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithUnclosedUnSeqFile() throws MergeException, IOException, MetadataException, WriteProcessException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(5, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 2500, 2500, 100, 100, false, false);
        this.createFiles(1, 5, 5, 3000, 1500, 1500, 100, 100, false, false);
        TsFileResource unclosedUnSeqResource = new TsFileResource(((TsFileResource)this.unseqResources.get(1)).getTsFile());
        unclosedUnSeqResource.setStatusForTest(TsFileResourceStatus.UNCLOSED);
        TsFileResource lastUnSeqResource = (TsFileResource)this.unseqResources.get(1);
        for (IDeviceID deviceID : lastUnSeqResource.getDevices()) {
            unclosedUnSeqResource.updateStartTime(deviceID, lastUnSeqResource.getStartTime(deviceID));
            unclosedUnSeqResource.updateEndTime(deviceID, lastUnSeqResource.getEndTime(deviceID));
        }
        this.unseqResources.remove(1);
        this.unseqResources.add(1, unclosedUnSeqResource);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionCandidate resource = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)1L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(0), this.seqResources.get(2));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().get(1), this.seqResources.get(3));
        Assert.assertEquals(((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().get(0), this.unseqResources.get(0));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles(), ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles(), this.performer, 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testSelectingFilesWhenSomeFilesBeingDeleted() throws Exception {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(5, 10, 5, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 5, 10, 4500, 500, 500, 0, 100, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        ArrayList<TsFileResource> sourceFiles = new ArrayList<TsFileResource>();
        sourceFiles.add((TsFileResource)this.seqResources.get(2));
        sourceFiles.add((TsFileResource)this.seqResources.get(3));
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getInnerCompactionTargetTsFileResources(sourceFiles, true);
        FastCompactionPerformer performer = new FastCompactionPerformer(false);
        performer.setSourceFiles(sourceFiles);
        performer.setTargetFiles(targetResources);
        performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        performer.perform();
        CompactionUtils.moveTargetFile(targetResources, (boolean)true, (String)(COMPACTION_TEST_SG + "-0"));
        CompactionUtils.combineModsInInnerCompaction(sourceFiles, (TsFileResource)targetResources.get(0));
        this.tsFileManager.replace(sourceFiles, Collections.emptyList(), targetResources, 0L);
        CompactionUtils.deleteTsFilesInDisk(sourceFiles, (String)(COMPACTION_TEST_SG + "-0"));
        targetResources.forEach(x -> x.setStatusForTest(TsFileResourceStatus.NORMAL));
        ICrossSpaceSelector selector = IoTDBDescriptor.getInstance().getConfig().getCrossCompactionSelector().createInstance(COMPACTION_TEST_SG, "0", 0L, this.tsFileManager);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)0L, (long)selected.size());
    }

    @Test
    public void testTsFileValidationWithFileTimeIndex() throws MetadataException, IOException, WriteProcessException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(10, 10, 5, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 5, 10, 4500, 500, 500, 0, 100, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        ((TsFileResource)this.tsFileManager.getTsFileList(true).get(0)).updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d1"), 1100L);
        ((TsFileResource)this.tsFileManager.getTsFileList(true).get(1)).updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d1"), 1200L);
        for (int i = 1; i < this.seqResources.size(); ++i) {
            ((TsFileResource)this.tsFileManager.getTsFileList(true).get(i)).degradeTimeIndex();
        }
        Assert.assertFalse((boolean)TsFileResourceUtils.validateTsFileResourcesHasNoOverlap((List)this.tsFileManager.getOrCreateSequenceListByTimePartition(0L).getArrayList()));
        ((TsFileResource)this.tsFileManager.getTsFileList(true).get(0)).deserialize();
        ((TsFileResource)this.tsFileManager.getTsFileList(true).get(1)).deserialize();
        ((TsFileResource)this.tsFileManager.getTsFileList(true).get(0)).degradeTimeIndex();
        ((TsFileResource)this.tsFileManager.getTsFileList(true).get(1)).degradeTimeIndex();
        Assert.assertTrue((boolean)TsFileResourceUtils.validateTsFileResourcesHasNoOverlap((List)this.tsFileManager.getOrCreateSequenceListByTimePartition(0L).getArrayList()));
        ArrayList<TsFileResource> sourceFiles = new ArrayList<TsFileResource>();
        sourceFiles.add((TsFileResource)this.seqResources.get(4));
        sourceFiles.add((TsFileResource)this.seqResources.get(5));
        sourceFiles.add((TsFileResource)this.seqResources.get(6));
        FastCompactionPerformer performer = new FastCompactionPerformer(false);
        performer.setSourceFiles(sourceFiles);
        InnerSpaceCompactionTask innerSpaceCompactionTask = new InnerSpaceCompactionTask(0L, this.tsFileManager, sourceFiles, true, (ICompactionPerformer)performer, 0L);
        Assert.assertTrue((boolean)TsFileResourceUtils.validateTsFileResourcesHasNoOverlap((List)this.tsFileManager.getOrCreateSequenceListByTimePartition(0L).getArrayList()));
        innerSpaceCompactionTask.start();
        this.validateSeqFiles(true);
    }

    @Test
    public void testCompactionSchedule() throws Exception {
        IoTDBDescriptor.getInstance().getConfig().setFileLimitPerCrossTask(1);
        IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(2);
        this.createFiles(10, 10, 5, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 5, 10, 1000, 4000, 4000, 0, 100, false, false);
        this.createFiles(1, 5, 10, 1000, 5000, 5000, 0, 100, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        ICrossSpaceSelector crossSpaceCompactionSelector = IoTDBDescriptor.getInstance().getConfig().getCrossCompactionSelector().createInstance(COMPACTION_TEST_SG, "0", 0L, this.tsFileManager);
        CrossCompactionTaskResource sourceFiles = (CrossCompactionTaskResource)crossSpaceCompactionSelector.selectCrossSpaceTask((List)this.tsFileManager.getOrCreateSequenceListByTimePartition(0L), (List)this.tsFileManager.getOrCreateUnsequenceListByTimePartition(0L)).get(0);
        Assert.assertEquals((long)2L, (long)sourceFiles.getSeqFiles().size());
        Assert.assertEquals((long)1L, (long)sourceFiles.getUnseqFiles().size());
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(sourceFiles.getSeqFiles());
        this.performer.setSourceFiles(sourceFiles.getSeqFiles(), sourceFiles.getUnseqFiles());
        this.performer.setTargetFiles(targetResources);
        this.performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        this.performer.perform();
        CompactionUtils.moveTargetFile(targetResources, (boolean)false, (String)(COMPACTION_TEST_SG + "-0"));
        CompactionUtils.combineModsInCrossCompaction((List)sourceFiles.getSeqFiles(), (List)sourceFiles.getUnseqFiles(), targetResources);
        this.tsFileManager.replace(sourceFiles.getSeqFiles(), sourceFiles.getUnseqFiles(), targetResources, 0L);
        Assert.assertEquals((long)0L, (long)crossSpaceCompactionSelector.selectCrossSpaceTask((List)this.tsFileManager.getOrCreateSequenceListByTimePartition(0L), (List)this.tsFileManager.getOrCreateUnsequenceListByTimePartition(0L)).size());
        IInnerSeqSpaceSelector innerSelector = IoTDBDescriptor.getInstance().getConfig().getInnerSequenceCompactionSelector().createInstance(COMPACTION_TEST_SG, "0", 0L, this.tsFileManager);
        Assert.assertEquals((long)0L, (long)innerSelector.selectInnerSpaceTask(targetResources).size());
        targetResources.forEach(x -> x.setStatusForTest(TsFileResourceStatus.NORMAL));
        List pairs = crossSpaceCompactionSelector.selectCrossSpaceTask((List)this.tsFileManager.getOrCreateSequenceListByTimePartition(0L), (List)this.tsFileManager.getOrCreateUnsequenceListByTimePartition(0L));
        Assert.assertEquals((long)1L, (long)pairs.size());
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)pairs.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)1L, (long)((CrossCompactionTaskResource)pairs.get(0)).getUnseqFiles().size());
        Assert.assertEquals(this.tsFileManager.getTsFileList(true).get(4), ((CrossCompactionTaskResource)pairs.get(0)).getSeqFiles().get(0));
        Assert.assertEquals(this.tsFileManager.getTsFileList(true).get(5), ((CrossCompactionTaskResource)pairs.get(0)).getSeqFiles().get(1));
        Assert.assertEquals(this.tsFileManager.getTsFileList(false).get(0), ((CrossCompactionTaskResource)pairs.get(0)).getUnseqFiles().get(0));
        List innerPairs = innerSelector.selectInnerSpaceTask(targetResources);
        Assert.assertEquals((long)1L, (long)innerPairs.size());
    }

    @Test
    public void testNonAlignedUnseqFilesNotOverlapWithSeqFiles1() throws Exception {
        IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(2);
        this.createFiles(5, 10, 5, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(2, 5, 10, 500, 6000, 6000, 0, 100, false, false);
        this.createFiles(3, 10, 5, 1000, 7500, 7500, 100, 100, false, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        HashMap<String, Pair<Long, Long>> deleteMap = new HashMap<String, Pair<Long, Long>>();
        for (int d = 0; d < 5; ++d) {
            for (int m = 0; m < 5; ++m) {
                deleteMap.put(COMPACTION_TEST_SG + '.' + "d" + d + '.' + "s" + m, (Pair<Long, Long>)new Pair((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE));
            }
        }
        for (TsFileResource resource : this.seqResources) {
            CompactionFileGeneratorUtils.generateMods(deleteMap, resource, false);
        }
        ArrayList<PartialPath> timeseriesPaths = new ArrayList<PartialPath>();
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                timeseriesPaths.add((PartialPath)new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i + '.' + "s" + j, TSDataType.INT64));
            }
        }
        Map<PartialPath, List<TimeValuePair>> sourceData = this.readSourceFiles(timeseriesPaths, Collections.emptyList());
        List taskResources = new SizeTieredCompactionSelector(COMPACTION_TEST_SG, "0", 0L, true, this.tsFileManager).selectInnerSpaceTask((List)this.tsFileManager.getOrCreateSequenceListByTimePartition(0L));
        for (InnerSpaceCompactionTask task : taskResources) {
            Assert.assertTrue((boolean)task.start());
        }
        ICrossSpaceSelector crossSpaceCompactionSelector = IoTDBDescriptor.getInstance().getConfig().getCrossCompactionSelector().createInstance(COMPACTION_TEST_SG, "0", 0L, this.tsFileManager);
        CrossCompactionTaskResource sourceFiles = (CrossCompactionTaskResource)crossSpaceCompactionSelector.selectCrossSpaceTask((List)this.tsFileManager.getOrCreateSequenceListByTimePartition(0L), (List)this.tsFileManager.getOrCreateUnsequenceListByTimePartition(0L)).get(0);
        Assert.assertEquals((long)1L, (long)sourceFiles.getSeqFiles().size());
        Assert.assertEquals((long)2L, (long)sourceFiles.getUnseqFiles().size());
        Assert.assertTrue((boolean)new CrossSpaceCompactionTask(0L, this.tsFileManager, sourceFiles.getSeqFiles(), sourceFiles.getUnseqFiles(), (ICrossCompactionPerformer)new FastCompactionPerformer(true), sourceFiles.getTotalMemoryCost(), 0L).start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceData, Collections.emptyList());
    }

    @Test
    public void testNonAlignedUnseqFilesNotOverlapWithSeqFiles2() throws Exception {
        IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(2);
        this.createFiles(5, 10, 5, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(2, 5, 10, 500, 6000, 6000, 0, 100, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        HashMap<String, Pair<Long, Long>> deleteMap = new HashMap<String, Pair<Long, Long>>();
        for (int d = 0; d < 5; ++d) {
            for (int m = 0; m < 5; ++m) {
                deleteMap.put(COMPACTION_TEST_SG + '.' + "d" + d + '.' + "s" + m, (Pair<Long, Long>)new Pair((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE));
            }
        }
        for (TsFileResource resource : this.seqResources) {
            CompactionFileGeneratorUtils.generateMods(deleteMap, resource, false);
        }
        ArrayList<PartialPath> timeseriesPaths = new ArrayList<PartialPath>();
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                timeseriesPaths.add((PartialPath)new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i + '.' + "s" + j, TSDataType.INT64));
            }
        }
        Map<PartialPath, List<TimeValuePair>> sourceData = this.readSourceFiles(timeseriesPaths, Collections.emptyList());
        List taskResources = new SizeTieredCompactionSelector(COMPACTION_TEST_SG, "0", 0L, true, this.tsFileManager).selectInnerSpaceTask((List)this.tsFileManager.getOrCreateSequenceListByTimePartition(0L));
        for (InnerSpaceCompactionTask task : taskResources) {
            Assert.assertTrue((boolean)task.start());
        }
        ICrossSpaceSelector crossSpaceCompactionSelector = IoTDBDescriptor.getInstance().getConfig().getCrossCompactionSelector().createInstance(COMPACTION_TEST_SG, "0", 0L, this.tsFileManager);
        CrossCompactionTaskResource sourceFiles = (CrossCompactionTaskResource)crossSpaceCompactionSelector.selectCrossSpaceTask((List)this.tsFileManager.getOrCreateSequenceListByTimePartition(0L), (List)this.tsFileManager.getOrCreateUnsequenceListByTimePartition(0L)).get(0);
        Assert.assertEquals((long)1L, (long)sourceFiles.getSeqFiles().size());
        Assert.assertEquals((long)2L, (long)sourceFiles.getUnseqFiles().size());
        new CrossSpaceCompactionTask(0L, this.tsFileManager, sourceFiles.getSeqFiles(), sourceFiles.getUnseqFiles(), (ICrossCompactionPerformer)new FastCompactionPerformer(true), sourceFiles.getTotalMemoryCost(), 0L).start();
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceData, Collections.emptyList());
    }

    @Test
    public void testNonAlignedUnseqFilesNotOverlapWithSeqFiles3() throws Exception {
        IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(2);
        this.createFiles(4, 10, 5, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(2, 5, 10, 500, 6000, 6000, 0, 100, false, false);
        this.createFiles(1, 10, 5, 1000, 7500, 7500, 100, 100, false, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        HashMap<String, Pair<Long, Long>> deleteMap = new HashMap<String, Pair<Long, Long>>();
        for (int d = 0; d < 5; ++d) {
            for (int m = 0; m < 5; ++m) {
                deleteMap.put(COMPACTION_TEST_SG + '.' + "d" + d + '.' + "s" + m, (Pair<Long, Long>)new Pair((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE));
            }
        }
        for (TsFileResource resource : this.seqResources) {
            CompactionFileGeneratorUtils.generateMods(deleteMap, resource, false);
        }
        ArrayList<PartialPath> timeseriesPaths = new ArrayList<PartialPath>();
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                timeseriesPaths.add((PartialPath)new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i + '.' + "s" + j, TSDataType.INT64));
            }
        }
        Map<PartialPath, List<TimeValuePair>> sourceData = this.readSourceFiles(timeseriesPaths, Collections.emptyList());
        List innerSpaceCompactionTasks = new SizeTieredCompactionSelector(COMPACTION_TEST_SG, "0", 0L, true, this.tsFileManager).selectInnerSpaceTask((List)this.tsFileManager.getOrCreateSequenceListByTimePartition(0L));
        for (InnerSpaceCompactionTask task : innerSpaceCompactionTasks) {
            Assert.assertTrue((boolean)task.start());
        }
        ICrossSpaceSelector crossSpaceCompactionSelector = IoTDBDescriptor.getInstance().getConfig().getCrossCompactionSelector().createInstance(COMPACTION_TEST_SG, "0", 0L, this.tsFileManager);
        CrossCompactionTaskResource sourceFiles = (CrossCompactionTaskResource)crossSpaceCompactionSelector.selectCrossSpaceTask((List)this.tsFileManager.getOrCreateSequenceListByTimePartition(0L), (List)this.tsFileManager.getOrCreateUnsequenceListByTimePartition(0L)).get(0);
        Assert.assertEquals((long)1L, (long)sourceFiles.getSeqFiles().size());
        Assert.assertEquals((long)2L, (long)sourceFiles.getUnseqFiles().size());
        new CrossSpaceCompactionTask(0L, this.tsFileManager, sourceFiles.getSeqFiles(), sourceFiles.getUnseqFiles(), (ICrossCompactionPerformer)new FastCompactionPerformer(true), sourceFiles.getTotalMemoryCost(), 0L).start();
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceData, Collections.emptyList());
    }

    @Test
    public void testNonAlignedUnseqFilesNotOverlapWithSeqFiles4() throws Exception {
        IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(2);
        this.createFiles(5, 10, 5, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 9, 10, 500, 100, 100, 0, 100, false, false);
        this.createFiles(2, 5, 10, 500, 6000, 6000, 0, 100, false, false);
        this.createFiles(3, 10, 5, 1000, 7500, 7500, 100, 100, false, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        HashMap<String, Pair<Long, Long>> deleteMap = new HashMap<String, Pair<Long, Long>>();
        for (int d = 0; d < 5; ++d) {
            for (int m = 0; m < 5; ++m) {
                deleteMap.put(COMPACTION_TEST_SG + '.' + "d" + d + '.' + "s" + m, (Pair<Long, Long>)new Pair((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE));
            }
        }
        for (TsFileResource resource : this.seqResources) {
            CompactionFileGeneratorUtils.generateMods(deleteMap, resource, false);
        }
        ArrayList<PartialPath> timeseriesPaths = new ArrayList<PartialPath>();
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                timeseriesPaths.add((PartialPath)new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i + '.' + "s" + j, TSDataType.INT64));
            }
        }
        Map<PartialPath, List<TimeValuePair>> sourceData = this.readSourceFiles(timeseriesPaths, Collections.emptyList());
        List innerSpaceCompactionTasks = new SizeTieredCompactionSelector(COMPACTION_TEST_SG, "0", 0L, true, this.tsFileManager).selectInnerSpaceTask((List)this.tsFileManager.getOrCreateSequenceListByTimePartition(0L));
        for (InnerSpaceCompactionTask task : innerSpaceCompactionTasks) {
            Assert.assertTrue((boolean)task.start());
        }
        ICrossSpaceSelector crossSpaceCompactionSelector = IoTDBDescriptor.getInstance().getConfig().getCrossCompactionSelector().createInstance(COMPACTION_TEST_SG, "0", 0L, this.tsFileManager);
        CrossCompactionTaskResource sourceFiles = (CrossCompactionTaskResource)crossSpaceCompactionSelector.selectCrossSpaceTask((List)this.tsFileManager.getOrCreateSequenceListByTimePartition(0L), (List)this.tsFileManager.getOrCreateUnsequenceListByTimePartition(0L)).get(0);
        Assert.assertEquals((long)2L, (long)sourceFiles.getSeqFiles().size());
        Assert.assertEquals((long)3L, (long)sourceFiles.getUnseqFiles().size());
        Assert.assertTrue((boolean)new CrossSpaceCompactionTask(0L, this.tsFileManager, sourceFiles.getSeqFiles(), sourceFiles.getUnseqFiles(), (ICrossCompactionPerformer)new FastCompactionPerformer(true), sourceFiles.getTotalMemoryCost(), 0L).start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceData, Collections.emptyList());
    }

    @Test
    public void testAlignedUnseqFilesNotOverlapWithSeqFiles1() throws Exception {
        IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(2);
        this.createFiles(5, 10, 5, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(2, 5, 10, 500, 6000, 6000, 0, 100, true, false);
        this.createFiles(3, 10, 5, 1000, 7500, 7500, 100, 100, true, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        HashMap<String, Pair<Long, Long>> deleteMap = new HashMap<String, Pair<Long, Long>>();
        for (int d = 0; d < 5; ++d) {
            for (int m = 0; m < 5; ++m) {
                deleteMap.put(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.alignDeviceOffset + d) + '.' + "s" + m, (Pair<Long, Long>)new Pair((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE));
            }
        }
        for (TsFileResource resource : this.seqResources) {
            CompactionFileGeneratorUtils.generateMods(deleteMap, resource, false);
        }
        ArrayList<PartialPath> timeseriesPaths = new ArrayList<PartialPath>();
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                timeseriesPaths.add((PartialPath)new AlignedPath(COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), Collections.singletonList(new MeasurementSchema("s" + j, TSDataType.INT64))));
            }
        }
        Map<PartialPath, List<TimeValuePair>> sourceData = this.readSourceFiles(timeseriesPaths, Collections.emptyList());
        List innerSpaceCompactionTasks = new SizeTieredCompactionSelector(COMPACTION_TEST_SG, "0", 0L, true, this.tsFileManager).selectInnerSpaceTask((List)this.tsFileManager.getOrCreateSequenceListByTimePartition(0L));
        for (InnerSpaceCompactionTask task : innerSpaceCompactionTasks) {
            Assert.assertTrue((boolean)task.start());
        }
        ICrossSpaceSelector crossSpaceCompactionSelector = IoTDBDescriptor.getInstance().getConfig().getCrossCompactionSelector().createInstance(COMPACTION_TEST_SG, "0", 0L, this.tsFileManager);
        CrossCompactionTaskResource sourceFiles = (CrossCompactionTaskResource)crossSpaceCompactionSelector.selectCrossSpaceTask((List)this.tsFileManager.getOrCreateSequenceListByTimePartition(0L), (List)this.tsFileManager.getOrCreateUnsequenceListByTimePartition(0L)).get(0);
        Assert.assertEquals((long)1L, (long)sourceFiles.getSeqFiles().size());
        Assert.assertEquals((long)2L, (long)sourceFiles.getUnseqFiles().size());
        new CrossSpaceCompactionTask(0L, this.tsFileManager, sourceFiles.getSeqFiles(), sourceFiles.getUnseqFiles(), (ICrossCompactionPerformer)new FastCompactionPerformer(true), sourceFiles.getTotalMemoryCost(), 0L).start();
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceData, Collections.emptyList());
    }

    @Test
    public void testAlignedUnseqFilesNotOverlapWithSeqFiles2() throws Exception {
        IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(2);
        this.createFiles(5, 10, 5, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(2, 5, 10, 500, 6000, 6000, 0, 100, true, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        HashMap<String, Pair<Long, Long>> deleteMap = new HashMap<String, Pair<Long, Long>>();
        for (int d = 0; d < 5; ++d) {
            for (int m = 0; m < 5; ++m) {
                deleteMap.put(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.alignDeviceOffset + d) + '.' + "s" + m, (Pair<Long, Long>)new Pair((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE));
            }
        }
        for (TsFileResource resource : this.seqResources) {
            CompactionFileGeneratorUtils.generateMods(deleteMap, resource, false);
        }
        ArrayList<PartialPath> timeseriesPaths = new ArrayList<PartialPath>();
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                timeseriesPaths.add((PartialPath)new AlignedPath(COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), Collections.singletonList(new MeasurementSchema("s" + j, TSDataType.INT64))));
            }
        }
        Map<PartialPath, List<TimeValuePair>> sourceData = this.readSourceFiles(timeseriesPaths, Collections.emptyList());
        List innerSpaceCompactionTasks = new SizeTieredCompactionSelector(COMPACTION_TEST_SG, "0", 0L, true, this.tsFileManager).selectInnerSpaceTask((List)this.tsFileManager.getOrCreateSequenceListByTimePartition(0L));
        for (InnerSpaceCompactionTask task : innerSpaceCompactionTasks) {
            Assert.assertTrue((boolean)task.start());
        }
        ICrossSpaceSelector crossSpaceCompactionSelector = IoTDBDescriptor.getInstance().getConfig().getCrossCompactionSelector().createInstance(COMPACTION_TEST_SG, "0", 0L, this.tsFileManager);
        CrossCompactionTaskResource sourceFiles = (CrossCompactionTaskResource)crossSpaceCompactionSelector.selectCrossSpaceTask((List)this.tsFileManager.getOrCreateSequenceListByTimePartition(0L), (List)this.tsFileManager.getOrCreateUnsequenceListByTimePartition(0L)).get(0);
        Assert.assertEquals((long)1L, (long)sourceFiles.getSeqFiles().size());
        Assert.assertEquals((long)2L, (long)sourceFiles.getUnseqFiles().size());
        new CrossSpaceCompactionTask(0L, this.tsFileManager, sourceFiles.getSeqFiles(), sourceFiles.getUnseqFiles(), (ICrossCompactionPerformer)new FastCompactionPerformer(true), sourceFiles.getTotalMemoryCost(), 0L).start();
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceData, Collections.emptyList());
    }

    @Test
    public void testAlignedUnseqFilesNotOverlapWithSeqFiles3() throws Exception {
        IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(2);
        this.createFiles(4, 10, 5, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(2, 5, 10, 500, 6000, 6000, 0, 100, true, false);
        this.createFiles(1, 10, 5, 1000, 7500, 7500, 100, 100, true, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        HashMap<String, Pair<Long, Long>> deleteMap = new HashMap<String, Pair<Long, Long>>();
        for (int d = 0; d < 5; ++d) {
            for (int m = 0; m < 5; ++m) {
                deleteMap.put(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.alignDeviceOffset + d) + '.' + "s" + m, (Pair<Long, Long>)new Pair((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE));
            }
        }
        for (TsFileResource resource : this.seqResources) {
            CompactionFileGeneratorUtils.generateMods(deleteMap, resource, false);
        }
        ArrayList<PartialPath> timeseriesPaths = new ArrayList<PartialPath>();
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                timeseriesPaths.add((PartialPath)new AlignedPath(COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), Collections.singletonList(new MeasurementSchema("s" + j, TSDataType.INT64))));
            }
        }
        Map<PartialPath, List<TimeValuePair>> sourceData = this.readSourceFiles(timeseriesPaths, Collections.emptyList());
        List innerSpaceCompactionTasks = new SizeTieredCompactionSelector(COMPACTION_TEST_SG, "0", 0L, true, this.tsFileManager).selectInnerSpaceTask((List)this.tsFileManager.getOrCreateSequenceListByTimePartition(0L));
        for (InnerSpaceCompactionTask task : innerSpaceCompactionTasks) {
            Assert.assertTrue((boolean)task.start());
        }
        ICrossSpaceSelector crossSpaceCompactionSelector = IoTDBDescriptor.getInstance().getConfig().getCrossCompactionSelector().createInstance(COMPACTION_TEST_SG, "0", 0L, this.tsFileManager);
        CrossCompactionTaskResource sourceFiles = (CrossCompactionTaskResource)crossSpaceCompactionSelector.selectCrossSpaceTask((List)this.tsFileManager.getOrCreateSequenceListByTimePartition(0L), (List)this.tsFileManager.getOrCreateUnsequenceListByTimePartition(0L)).get(0);
        Assert.assertEquals((long)1L, (long)sourceFiles.getSeqFiles().size());
        Assert.assertEquals((long)2L, (long)sourceFiles.getUnseqFiles().size());
        new CrossSpaceCompactionTask(0L, this.tsFileManager, sourceFiles.getSeqFiles(), sourceFiles.getUnseqFiles(), (ICrossCompactionPerformer)new FastCompactionPerformer(true), sourceFiles.getTotalMemoryCost(), 0L).start();
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceData, Collections.emptyList());
    }

    @Test
    public void testAlignedUnseqFilesNotOverlapWithSeqFiles4() throws Exception {
        IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(2);
        this.createFiles(5, 10, 5, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 9, 10, 500, 100, 100, 0, 100, true, false);
        this.createFiles(2, 5, 10, 500, 6000, 6000, 0, 100, true, false);
        this.createFiles(3, 10, 5, 1000, 7500, 7500, 100, 100, true, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        HashMap<String, Pair<Long, Long>> deleteMap = new HashMap<String, Pair<Long, Long>>();
        for (int d = 0; d < 5; ++d) {
            for (int m = 0; m < 5; ++m) {
                deleteMap.put(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.alignDeviceOffset + d) + '.' + "s" + m, (Pair<Long, Long>)new Pair((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE));
            }
        }
        for (TsFileResource resource : this.seqResources) {
            CompactionFileGeneratorUtils.generateMods(deleteMap, resource, false);
        }
        ArrayList<PartialPath> timeseriesPaths = new ArrayList<PartialPath>();
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                timeseriesPaths.add((PartialPath)new AlignedPath(COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), Collections.singletonList(new MeasurementSchema("s" + j, TSDataType.INT64))));
            }
        }
        Map<PartialPath, List<TimeValuePair>> sourceData = this.readSourceFiles(timeseriesPaths, Collections.emptyList());
        List innerSpaceCompactionTasks = new SizeTieredCompactionSelector(COMPACTION_TEST_SG, "0", 0L, true, this.tsFileManager).selectInnerSpaceTask((List)this.tsFileManager.getOrCreateSequenceListByTimePartition(0L));
        for (InnerSpaceCompactionTask task : innerSpaceCompactionTasks) {
            Assert.assertTrue((boolean)task.start());
        }
        ICrossSpaceSelector crossSpaceCompactionSelector = IoTDBDescriptor.getInstance().getConfig().getCrossCompactionSelector().createInstance(COMPACTION_TEST_SG, "0", 0L, this.tsFileManager);
        CrossCompactionTaskResource sourceFiles = (CrossCompactionTaskResource)crossSpaceCompactionSelector.selectCrossSpaceTask((List)this.tsFileManager.getOrCreateSequenceListByTimePartition(0L), (List)this.tsFileManager.getOrCreateUnsequenceListByTimePartition(0L)).get(0);
        Assert.assertEquals((long)2L, (long)sourceFiles.getSeqFiles().size());
        Assert.assertEquals((long)3L, (long)sourceFiles.getUnseqFiles().size());
        new CrossSpaceCompactionTask(0L, this.tsFileManager, sourceFiles.getSeqFiles(), sourceFiles.getUnseqFiles(), (ICrossCompactionPerformer)new FastCompactionPerformer(true), sourceFiles.getTotalMemoryCost(), 0L).start();
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceData, Collections.emptyList());
    }

    @Override
    public void generateModsFile(List<PartialPath> seriesPaths, TsFileResource resource, long startValue, long endValue) throws IllegalPathException, IOException {
        HashMap<String, Pair<Long, Long>> deleteMap = new HashMap<String, Pair<Long, Long>>();
        for (PartialPath path : seriesPaths) {
            String fullPath = path instanceof AlignedPath ? path.getFullPath() + "." + (String)((AlignedPath)path).getMeasurementList().get(0) : path.getFullPath();
            deleteMap.put(fullPath, (Pair<Long, Long>)new Pair((Object)startValue, (Object)endValue));
        }
        CompactionFileGeneratorUtils.generateMods(deleteMap, resource, false);
    }
}

