/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.cross;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.AbstractCompactionTest;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.exception.FileCannotTransitToCompactingException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.AbstractCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CrossSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionTaskQueue;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionWorker;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.comparator.DefaultCompactionTaskComparatorImpl;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.impl.RewriteCrossSpaceCompactionSelector;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.utils.CrossCompactionTaskResource;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.utils.CrossSpaceCompactionCandidate;
import org.apache.iotdb.db.storageengine.dataregion.read.control.FileReaderManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.rescon.memory.SystemInfo;
import org.apache.iotdb.db.utils.datastructure.FixedPriorityBlockingQueue;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class CrossSpaceCompactionSelectorTest
extends AbstractCompactionTest {
    @Override
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException, InterruptedException {
        super.setUp();
        IoTDBDescriptor.getInstance().getConfig().setMinCrossCompactionUnseqFileLevel(0);
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        super.tearDown();
        for (TsFileResource tsFileResource : this.seqResources) {
            FileReaderManager.getInstance().closeFileAndRemoveReader(tsFileResource.getTsFilePath());
        }
        for (TsFileResource tsFileResource : this.unseqResources) {
            FileReaderManager.getInstance().closeFileAndRemoveReader(tsFileResource.getTsFilePath());
        }
    }

    @Test
    public void testSelectWithEmptySeqFileList() throws IOException, MetadataException, WriteProcessException {
        this.createFiles(5, 2, 3, 50, 0, 10000, 50, 50, false, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)0L, (long)selected.size());
    }

    @Test
    public void testSelectWithOneUnclosedSeqFile() throws IOException, MetadataException, WriteProcessException {
        this.createFiles(1, 2, 3, 50, 0, 10000, 50, 50, false, true);
        this.createFiles(5, 2, 3, 50, 0, 10000, 50, 50, false, false);
        ((TsFileResource)this.seqResources.get(0)).setStatusForTest(TsFileResourceStatus.UNCLOSED);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)0L, (long)selected.size());
    }

    @Test
    public void testSelectWithClosedSeqFileAndUnOverlapUnseqFile() throws IOException, MetadataException, WriteProcessException {
        this.createFiles(1, 2, 3, 50, 0, 10000, 50, 50, false, true);
        this.createFiles(5, 2, 3, 50, 0, 10000, 50, 50, false, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)1L, (long)selected.size());
        Assert.assertEquals((long)1L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)5L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        this.createFiles(1, 2, 3, 50, 100, 10000, 50, 50, false, true);
        selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)1L, (long)selected.size());
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)5L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
    }

    @Test
    public void testSelectWithClosedSeqFileAndUncloseSeqFile() throws IOException, MetadataException, WriteProcessException {
        this.createFiles(2, 2, 3, 50, 0, 10000, 50, 50, false, true);
        this.createFiles(5, 2, 3, 50, 0, 10000, 50, 50, false, false);
        ((TsFileResource)this.seqResources.get(1)).setStatusForTest(TsFileResourceStatus.UNCLOSED);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)1L, (long)selected.size());
        Assert.assertEquals((long)1L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)1L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        this.createFiles(1, 2, 3, 200, 200, 10000, 50, 50, false, true);
        ((TsFileResource)this.seqResources.get(1)).setStatusForTest(TsFileResourceStatus.NORMAL);
        ((TsFileResource)this.seqResources.get(2)).setStatusForTest(TsFileResourceStatus.UNCLOSED);
        selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)1L, (long)selected.size());
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        this.createFiles(1, 2, 3, 200, 1000, 10000, 50, 50, false, true);
        this.createFiles(1, 2, 3, 200, 2000, 10000, 50, 50, false, true);
        ((TsFileResource)this.seqResources.get(2)).setStatusForTest(TsFileResourceStatus.NORMAL);
        ((TsFileResource)this.seqResources.get(4)).setStatusForTest(TsFileResourceStatus.UNCLOSED);
        selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)1L, (long)selected.size());
        Assert.assertEquals((long)4L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)5L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
    }

    @Test
    public void testSelectWithMultiUnseqFilesOverlapWithOneSeqFile() throws IOException, MetadataException, WriteProcessException {
        this.createFiles(3, 2, 3, 50, 0, 10000, 50, 50, false, true);
        this.createFiles(1, 2, 3, 50, 0, 10000, 50, 50, false, false);
        this.createFiles(1, 2, 3, 50, 0, 10000, 50, 50, false, false);
        this.createFiles(1, 2, 3, 50, 0, 10000, 50, 50, false, false);
        this.createFiles(1, 2, 3, 50, 0, 10000, 50, 50, false, false);
        this.createFiles(1, 2, 3, 50, 0, 10000, 50, 50, false, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)1L, (long)selected.size());
        Assert.assertEquals((long)1L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)5L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
    }

    @Test
    public void testSelectWithTooLargeSeqFile() throws IOException, MetadataException, WriteProcessException {
        this.createFiles(2, 2, 3, 50, 0, 10000, 50, 50, false, true);
        this.createFiles(5, 2, 3, 50, 0, 10000, 50, 50, false, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)1L, (long)selected.size());
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
        Assert.assertEquals((long)5L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
        IoTDBDescriptor.getInstance().getConfig().setTargetCompactionFileSize(1L);
        selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)0L, (long)selected.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectWithTooManySourceFiles() throws IOException, MetadataException, WriteProcessException, InterruptedException, ExecutionException {
        int oldMaxFileNumForCompaction = SystemInfo.getInstance().getTotalFileLimitForCompaction();
        SystemInfo.getInstance().setTotalFileLimitForCompactionTask(1);
        SystemInfo.getInstance().getCompactionFileNumCost().set(0);
        SystemInfo.getInstance().getCompactionMemoryCost().set(0L);
        try {
            this.createFiles(19, 2, 3, 50, 0, 10000, 50, 50, false, true);
            this.createFiles(1, 2, 3, 3000, 0, 10000, 50, 50, false, false);
            RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
            List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
            Assert.assertEquals((long)1L, (long)selected.size());
            Assert.assertEquals((long)19L, (long)((CrossCompactionTaskResource)selected.get(0)).getSeqFiles().size());
            Assert.assertEquals((long)1L, (long)((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles().size());
            CrossSpaceCompactionTask crossSpaceCompactionTask = new CrossSpaceCompactionTask(0L, this.tsFileManager, ((CrossCompactionTaskResource)selected.get(0)).getSeqFiles(), ((CrossCompactionTaskResource)selected.get(0)).getUnseqFiles(), IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), 1000L, this.tsFileManager.getNextCompactionTaskId());
            Assert.assertTrue((boolean)crossSpaceCompactionTask.setSourceFilesToCompactionCandidate());
            CompactionTaskQueue queue = new CompactionTaskQueue(50, (Comparator)new DefaultCompactionTaskComparatorImpl());
            queue.put((Object)crossSpaceCompactionTask);
            Thread thread = new Thread(() -> CrossSpaceCompactionSelectorTest.lambda$testSelectWithTooManySourceFiles$0((FixedPriorityBlockingQueue)queue));
            thread.start();
            thread.join(TimeUnit.SECONDS.toMillis(2L));
            Assert.assertEquals((long)0L, (long)SystemInfo.getInstance().getCompactionMemoryCost().get());
            Assert.assertEquals((long)0L, (long)SystemInfo.getInstance().getCompactionFileNumCost().get());
            for (TsFileResource resource : this.seqResources) {
                Assert.assertEquals((Object)TsFileResourceStatus.NORMAL, (Object)resource.getStatus());
            }
            for (TsFileResource resource : this.unseqResources) {
                Assert.assertEquals((Object)TsFileResourceStatus.NORMAL, (Object)resource.getStatus());
            }
            thread.interrupt();
            thread.join();
        }
        finally {
            SystemInfo.getInstance().setTotalFileLimitForCompactionTask(oldMaxFileNumForCompaction);
        }
    }

    @Test
    public void testSeqFileWithDeviceIndexBeenDeletedBeforeSelection() throws IOException, MetadataException, WriteProcessException, InterruptedException {
        this.createFiles(5, 2, 3, 50, 0, 10000, 50, 50, false, true);
        this.createFiles(5, 2, 3, 50, 0, 10000, 50, 50, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        AtomicBoolean fail = new AtomicBoolean(false);
        CountDownLatch cd1 = new CountDownLatch(1);
        CountDownLatch cd2 = new CountDownLatch(1);
        Thread thread1 = new Thread(() -> {
            try {
                cd1.countDown();
                cd2.await();
                RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
                CrossSpaceCompactionCandidate candidate = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources, System.currentTimeMillis() - Long.MAX_VALUE);
                CrossCompactionTaskResource crossCompactionTaskResource = selector.selectOneTaskResources(candidate);
                if (!crossCompactionTaskResource.isValid()) {
                    throw new RuntimeException("compaction task resource is not valid");
                }
                if (crossCompactionTaskResource.getSeqFiles().size() != 1) {
                    throw new RuntimeException("selected seq file num is not 1");
                }
                if (crossCompactionTaskResource.getUnseqFiles().size() != 1) {
                    throw new RuntimeException("selected unseq file num is not 1");
                }
            }
            catch (Exception e) {
                fail.set(true);
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        });
        Thread thread2 = new Thread(() -> {
            try {
                cd1.await();
                TsFileResource resource = (TsFileResource)this.seqResources.get(1);
                resource.writeLock();
                resource.remove();
                resource.writeUnlock();
                cd2.countDown();
            }
            catch (Exception e) {
                fail.set(true);
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        });
        thread1.start();
        thread2.start();
        thread1.join(10000L);
        thread2.join(10000L);
        if (fail.get()) {
            Assert.fail();
        }
    }

    @Test
    public void testSeqFileWithDeviceIndexBeenDeletedDuringSelectionAndAfterCopyingList() throws IOException, MetadataException, WriteProcessException, InterruptedException {
        this.createFiles(5, 2, 3, 50, 0, 10000, 50, 50, false, true);
        this.createFiles(5, 2, 3, 50, 0, 10000, 50, 50, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        AtomicBoolean fail = new AtomicBoolean(false);
        CountDownLatch cd1 = new CountDownLatch(1);
        CountDownLatch cd2 = new CountDownLatch(1);
        Thread thread1 = new Thread(() -> {
            try {
                TsFileResource resource;
                int i;
                RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
                CrossSpaceCompactionCandidate candidate = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources, System.currentTimeMillis() - Long.MAX_VALUE);
                cd1.countDown();
                cd2.await();
                CrossCompactionTaskResource crossCompactionTaskResource = selector.selectOneTaskResources(candidate);
                if (!crossCompactionTaskResource.isValid()) {
                    throw new RuntimeException("compaction task resource is not valid");
                }
                if (crossCompactionTaskResource.getSeqFiles().size() != 1) {
                    throw new RuntimeException("selected seq file should be 1");
                }
                if (crossCompactionTaskResource.getUnseqFiles().size() != 1) {
                    throw new RuntimeException("selected unseq file num should be 1");
                }
                CrossSpaceCompactionTask crossSpaceCompactionTask = new CrossSpaceCompactionTask(0L, this.tsFileManager, crossCompactionTaskResource.getSeqFiles(), crossCompactionTaskResource.getUnseqFiles(), IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), crossCompactionTaskResource.getTotalMemoryCost(), this.tsFileManager.getNextCompactionTaskId());
                if (!crossSpaceCompactionTask.setSourceFilesToCompactionCandidate()) {
                    throw new RuntimeException("set status should be true");
                }
                for (i = 0; i < this.seqResources.size(); ++i) {
                    resource = (TsFileResource)this.seqResources.get(i);
                    if (i < 1) {
                        if (resource.getStatus() == TsFileResourceStatus.COMPACTION_CANDIDATE) continue;
                        throw new RuntimeException("status should be COMPACTION_CANDIDATE");
                    }
                    if (i == 1) {
                        if (resource.getStatus() == TsFileResourceStatus.DELETED) continue;
                        throw new RuntimeException("status should be DELETED");
                    }
                    if (resource.getStatus() == TsFileResourceStatus.NORMAL) continue;
                    throw new RuntimeException("status should be NORMAL");
                }
                for (i = 0; i < this.unseqResources.size(); ++i) {
                    resource = (TsFileResource)this.unseqResources.get(i);
                    if (i < 1) {
                        if (resource.getStatus() == TsFileResourceStatus.COMPACTION_CANDIDATE) continue;
                        throw new RuntimeException("status should be COMPACTION_CANDIDATE");
                    }
                    if (resource.getStatus() == TsFileResourceStatus.NORMAL) continue;
                    throw new RuntimeException("status should be NORMAL");
                }
            }
            catch (Exception e) {
                fail.set(true);
                e.printStackTrace();
            }
        });
        Thread thread2 = new Thread(() -> {
            try {
                cd1.await();
                TsFileResource resource = (TsFileResource)this.seqResources.get(1);
                resource.writeLock();
                resource.remove();
                resource.writeUnlock();
                cd2.countDown();
            }
            catch (Exception e) {
                fail.set(true);
                e.printStackTrace();
            }
        });
        thread1.start();
        thread2.start();
        thread1.join(10000L);
        thread2.join(10000L);
        if (fail.get()) {
            Assert.fail();
        }
    }

    @Test
    public void testSeqFileWithDeviceIndexBeenDeletedDuringSelectionAndBeforeSettingCandidate() throws IOException, MetadataException, WriteProcessException, InterruptedException {
        this.createFiles(5, 2, 3, 50, 0, 10000, 50, 50, false, true);
        this.createFiles(5, 2, 3, 50, 0, 10000, 50, 50, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        AtomicBoolean fail = new AtomicBoolean(false);
        CountDownLatch cd1 = new CountDownLatch(1);
        CountDownLatch cd2 = new CountDownLatch(1);
        Thread thread1 = new Thread(() -> {
            try {
                TsFileResource resource;
                int i;
                RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
                CrossSpaceCompactionCandidate candidate = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources, System.currentTimeMillis() - Long.MAX_VALUE);
                CrossCompactionTaskResource crossCompactionTaskResource = selector.selectOneTaskResources(candidate);
                if (!crossCompactionTaskResource.isValid()) {
                    throw new RuntimeException("compaction task resource is not valid");
                }
                if (crossCompactionTaskResource.getSeqFiles().size() != 5) {
                    throw new RuntimeException("selected seq file num is not 5");
                }
                if (crossCompactionTaskResource.getUnseqFiles().size() != 5) {
                    throw new RuntimeException("selected unseq file num is not 5");
                }
                cd1.countDown();
                cd2.await();
                CrossSpaceCompactionTask crossSpaceCompactionTask = new CrossSpaceCompactionTask(0L, this.tsFileManager, crossCompactionTaskResource.getSeqFiles(), crossCompactionTaskResource.getUnseqFiles(), IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), crossCompactionTaskResource.getTotalMemoryCost(), this.tsFileManager.getNextCompactionTaskId());
                if (crossSpaceCompactionTask.setSourceFilesToCompactionCandidate()) {
                    throw new RuntimeException("set status should be false");
                }
                for (i = 0; i < this.seqResources.size(); ++i) {
                    resource = (TsFileResource)this.seqResources.get(i);
                    if (i == 1) {
                        if (resource.getStatus() == TsFileResourceStatus.DELETED) continue;
                        throw new RuntimeException("status should be DELETED");
                    }
                    if (resource.getStatus() == TsFileResourceStatus.NORMAL) continue;
                    throw new RuntimeException("status should be NORMAL");
                }
                for (i = 0; i < this.unseqResources.size(); ++i) {
                    resource = (TsFileResource)this.unseqResources.get(i);
                    if (resource.getStatus() == TsFileResourceStatus.NORMAL) continue;
                    throw new RuntimeException("status should be NORMAL");
                }
            }
            catch (Exception e) {
                fail.set(true);
                e.printStackTrace();
            }
        });
        Thread thread2 = new Thread(() -> {
            try {
                cd1.await();
                TsFileResource resource = (TsFileResource)this.seqResources.get(1);
                resource.writeLock();
                resource.remove();
                resource.writeUnlock();
                cd2.countDown();
            }
            catch (Exception e) {
                fail.set(true);
                e.printStackTrace();
            }
        });
        thread1.start();
        thread2.start();
        thread1.join(10000L);
        thread2.join(10000L);
        if (fail.get()) {
            Assert.fail();
        }
    }

    @Test
    public void testSeqFileWithDeviceIndexBeenDeletedDuringSelectionAndBeforeSettingCompacting() throws IOException, MetadataException, WriteProcessException, InterruptedException {
        this.createFiles(5, 2, 3, 50, 0, 10000, 50, 50, false, true);
        this.createFiles(5, 2, 3, 50, 0, 10000, 50, 50, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        AtomicBoolean fail = new AtomicBoolean(false);
        CountDownLatch cd1 = new CountDownLatch(1);
        CountDownLatch cd2 = new CountDownLatch(1);
        Thread thread1 = new Thread(() -> {
            try {
                TsFileResource resource;
                int i;
                RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
                CrossSpaceCompactionCandidate candidate = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources, System.currentTimeMillis() - Long.MAX_VALUE);
                CrossCompactionTaskResource crossCompactionTaskResource = selector.selectOneTaskResources(candidate);
                if (!crossCompactionTaskResource.isValid()) {
                    throw new RuntimeException("compaction task resource is not valid");
                }
                if (crossCompactionTaskResource.getSeqFiles().size() != 5) {
                    throw new RuntimeException("selected seq file num is not 5");
                }
                if (crossCompactionTaskResource.getUnseqFiles().size() != 5) {
                    throw new RuntimeException("selected unseq file num is not 5");
                }
                CrossSpaceCompactionTask crossSpaceCompactionTask = new CrossSpaceCompactionTask(0L, this.tsFileManager, crossCompactionTaskResource.getSeqFiles(), crossCompactionTaskResource.getUnseqFiles(), IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), crossCompactionTaskResource.getTotalMemoryCost(), this.tsFileManager.getNextCompactionTaskId());
                if (!crossSpaceCompactionTask.setSourceFilesToCompactionCandidate()) {
                    throw new RuntimeException("fail to set status to compaction candidate.");
                }
                cd1.countDown();
                cd2.await();
                boolean exceptionCaught = false;
                Assert.assertThrows((String)"cross space compaction task should be invalid.", FileCannotTransitToCompactingException.class, () -> ((CrossSpaceCompactionTask)crossSpaceCompactionTask).transitSourceFilesToMerging());
                FixedPriorityBlockingQueue mockQueue = (FixedPriorityBlockingQueue)Mockito.mock(FixedPriorityBlockingQueue.class);
                Mockito.when((Object)((AbstractCompactionTask)mockQueue.take())).thenReturn((Object)crossSpaceCompactionTask).thenThrow(new Throwable[]{new InterruptedException()});
                CompactionWorker worker = new CompactionWorker(0, mockQueue);
                worker.run();
                for (i = 0; i < this.seqResources.size(); ++i) {
                    resource = (TsFileResource)this.seqResources.get(i);
                    if (i == 1) {
                        if (resource.getStatus() == TsFileResourceStatus.DELETED) continue;
                        throw new RuntimeException("status should be DELETED");
                    }
                    if (resource.getStatus() == TsFileResourceStatus.NORMAL) continue;
                    throw new RuntimeException("status should be NORMAL");
                }
                for (i = 0; i < this.unseqResources.size(); ++i) {
                    resource = (TsFileResource)this.unseqResources.get(i);
                    if (resource.getStatus() == TsFileResourceStatus.NORMAL) continue;
                    throw new RuntimeException("status should be NORMAL");
                }
            }
            catch (Exception e) {
                fail.set(true);
                e.printStackTrace();
            }
        });
        Thread thread2 = new Thread(() -> {
            try {
                cd1.await();
                TsFileResource resource = (TsFileResource)this.seqResources.get(1);
                resource.writeLock();
                resource.remove();
                resource.writeUnlock();
                cd2.countDown();
            }
            catch (Exception e) {
                fail.set(true);
                e.printStackTrace();
            }
        });
        thread1.start();
        thread2.start();
        thread1.join(10000L);
        thread2.join(10000L);
        if (fail.get()) {
            Assert.fail();
        }
    }

    @Test
    public void testSeqFileWithFileIndexBeenDeletedDuringSelectionAndAfterCopyingList() throws IOException, MetadataException, WriteProcessException, InterruptedException {
        this.createFiles(5, 2, 3, 50, 0, 10000, 50, 50, false, true);
        this.createFiles(5, 2, 3, 50, 0, 10000, 50, 50, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        AtomicBoolean fail = new AtomicBoolean(false);
        CountDownLatch cd1 = new CountDownLatch(1);
        CountDownLatch cd2 = new CountDownLatch(1);
        ((TsFileResource)this.seqResources.get(0)).degradeTimeIndex();
        ((TsFileResource)this.seqResources.get(1)).degradeTimeIndex();
        ((TsFileResource)this.seqResources.get(2)).degradeTimeIndex();
        ((TsFileResource)this.unseqResources.get(1)).degradeTimeIndex();
        Thread thread1 = new Thread(() -> {
            try {
                TsFileResource resource;
                int i;
                RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
                CrossSpaceCompactionCandidate candidate = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources, System.currentTimeMillis() - Long.MAX_VALUE);
                cd1.countDown();
                cd2.await();
                CrossCompactionTaskResource crossCompactionTaskResource = selector.selectOneTaskResources(candidate);
                if (!crossCompactionTaskResource.isValid()) {
                    throw new RuntimeException("compaction task resource is not valid");
                }
                if (crossCompactionTaskResource.getSeqFiles().size() != 1) {
                    throw new RuntimeException("selected seq file num should be 1");
                }
                if (crossCompactionTaskResource.getUnseqFiles().size() != 1) {
                    throw new RuntimeException("selected unseq file num should be 1");
                }
                CrossSpaceCompactionTask crossSpaceCompactionTask = new CrossSpaceCompactionTask(0L, this.tsFileManager, crossCompactionTaskResource.getSeqFiles(), crossCompactionTaskResource.getUnseqFiles(), IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), crossCompactionTaskResource.getTotalMemoryCost(), this.tsFileManager.getNextCompactionTaskId());
                if (!crossSpaceCompactionTask.setSourceFilesToCompactionCandidate()) {
                    throw new RuntimeException("set status should be true");
                }
                for (i = 0; i < this.seqResources.size(); ++i) {
                    resource = (TsFileResource)this.seqResources.get(i);
                    if (i < 1) {
                        if (resource.getStatus() == TsFileResourceStatus.COMPACTION_CANDIDATE) continue;
                        throw new RuntimeException("status should be COMPACTION_CANDIDATE");
                    }
                    if (i == 1) {
                        if (resource.getStatus() == TsFileResourceStatus.DELETED) continue;
                        throw new RuntimeException("status should be DELETED");
                    }
                    if (resource.getStatus() == TsFileResourceStatus.NORMAL) continue;
                    throw new RuntimeException("status should be NORMAL");
                }
                for (i = 0; i < this.unseqResources.size(); ++i) {
                    resource = (TsFileResource)this.unseqResources.get(i);
                    if (i < 1) {
                        if (resource.getStatus() == TsFileResourceStatus.COMPACTION_CANDIDATE) continue;
                        throw new RuntimeException("status should be COMPACTION_CANDIDATE");
                    }
                    if (resource.getStatus() == TsFileResourceStatus.NORMAL) continue;
                    throw new RuntimeException("status should be NORMAL");
                }
            }
            catch (Exception e) {
                fail.set(true);
                e.printStackTrace();
            }
        });
        Thread thread2 = new Thread(() -> {
            try {
                cd1.await();
                TsFileResource resource = (TsFileResource)this.seqResources.get(1);
                resource.writeLock();
                resource.remove();
                resource.writeUnlock();
                cd2.countDown();
            }
            catch (Exception e) {
                fail.set(true);
                e.printStackTrace();
            }
        });
        thread1.start();
        thread2.start();
        thread1.join();
        thread2.join();
        if (fail.get()) {
            Assert.fail();
        }
    }

    @Test
    public void testSeqFileWithFileIndexBeenDeletedDuringSelectionAndBeforeSettingCandidate() throws IOException, MetadataException, WriteProcessException, InterruptedException {
        this.createFiles(5, 2, 3, 50, 0, 10000, 50, 50, false, true);
        this.createFiles(5, 2, 3, 50, 0, 10000, 50, 50, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        AtomicBoolean fail = new AtomicBoolean(false);
        CountDownLatch cd1 = new CountDownLatch(1);
        CountDownLatch cd2 = new CountDownLatch(1);
        ((TsFileResource)this.seqResources.get(0)).degradeTimeIndex();
        ((TsFileResource)this.seqResources.get(1)).degradeTimeIndex();
        ((TsFileResource)this.seqResources.get(2)).degradeTimeIndex();
        ((TsFileResource)this.unseqResources.get(1)).degradeTimeIndex();
        Thread thread1 = new Thread(() -> {
            try {
                TsFileResource resource;
                int i;
                RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
                CrossSpaceCompactionCandidate candidate = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources, System.currentTimeMillis() - Long.MAX_VALUE);
                CrossCompactionTaskResource crossCompactionTaskResource = selector.selectOneTaskResources(candidate);
                if (!crossCompactionTaskResource.isValid()) {
                    throw new RuntimeException("compaction task resource is not valid");
                }
                if (crossCompactionTaskResource.getSeqFiles().size() != 5) {
                    throw new RuntimeException("selected seq file num is not 5");
                }
                if (crossCompactionTaskResource.getUnseqFiles().size() != 5) {
                    throw new RuntimeException("selected unseq file num is not 5");
                }
                cd1.countDown();
                cd2.await();
                CrossSpaceCompactionTask crossSpaceCompactionTask = new CrossSpaceCompactionTask(0L, this.tsFileManager, crossCompactionTaskResource.getSeqFiles(), crossCompactionTaskResource.getUnseqFiles(), IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), crossCompactionTaskResource.getTotalMemoryCost(), this.tsFileManager.getNextCompactionTaskId());
                if (crossSpaceCompactionTask.setSourceFilesToCompactionCandidate()) {
                    throw new RuntimeException("set status should be false");
                }
                for (i = 0; i < this.seqResources.size(); ++i) {
                    resource = (TsFileResource)this.seqResources.get(i);
                    if (i == 1) {
                        if (resource.getStatus() == TsFileResourceStatus.DELETED) continue;
                        throw new RuntimeException("status should be DELETED");
                    }
                    if (resource.getStatus() == TsFileResourceStatus.NORMAL) continue;
                    throw new RuntimeException("status should be NORMAL");
                }
                for (i = 0; i < this.unseqResources.size(); ++i) {
                    resource = (TsFileResource)this.unseqResources.get(i);
                    if (resource.getStatus() == TsFileResourceStatus.NORMAL) continue;
                    throw new RuntimeException("status should be NORMAL");
                }
            }
            catch (Exception e) {
                fail.set(true);
                e.printStackTrace();
            }
        });
        Thread thread2 = new Thread(() -> {
            try {
                cd1.await();
                TsFileResource resource = (TsFileResource)this.seqResources.get(1);
                resource.writeLock();
                resource.remove();
                resource.writeUnlock();
                cd2.countDown();
            }
            catch (Exception e) {
                fail.set(true);
                e.printStackTrace();
            }
        });
        thread1.start();
        thread2.start();
        thread1.join();
        thread2.join();
        if (fail.get()) {
            Assert.fail();
        }
    }

    @Test
    public void testSeqFileWithFileIndexBeenDeletedDuringSelectionAndBeforeSettingCompacting() throws IOException, MetadataException, WriteProcessException, InterruptedException {
        this.createFiles(5, 2, 3, 50, 0, 10000, 50, 50, false, true);
        this.createFiles(5, 2, 3, 50, 0, 10000, 50, 50, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        AtomicBoolean fail = new AtomicBoolean(false);
        CountDownLatch cd1 = new CountDownLatch(1);
        CountDownLatch cd2 = new CountDownLatch(1);
        ((TsFileResource)this.seqResources.get(0)).degradeTimeIndex();
        ((TsFileResource)this.seqResources.get(1)).degradeTimeIndex();
        ((TsFileResource)this.seqResources.get(2)).degradeTimeIndex();
        ((TsFileResource)this.unseqResources.get(1)).degradeTimeIndex();
        Thread thread1 = new Thread(() -> {
            try {
                TsFileResource resource;
                int i;
                RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
                CrossSpaceCompactionCandidate candidate = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources, System.currentTimeMillis() - Long.MAX_VALUE);
                CrossCompactionTaskResource crossCompactionTaskResource = selector.selectOneTaskResources(candidate);
                if (!crossCompactionTaskResource.isValid()) {
                    throw new RuntimeException("compaction task resource is not valid");
                }
                if (crossCompactionTaskResource.getSeqFiles().size() != 5) {
                    throw new RuntimeException("selected seq file num is not 5");
                }
                if (crossCompactionTaskResource.getUnseqFiles().size() != 5) {
                    throw new RuntimeException("selected unseq file num is not 5");
                }
                CrossSpaceCompactionTask crossSpaceCompactionTask = new CrossSpaceCompactionTask(0L, this.tsFileManager, crossCompactionTaskResource.getSeqFiles(), crossCompactionTaskResource.getUnseqFiles(), IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), crossCompactionTaskResource.getTotalMemoryCost(), this.tsFileManager.getNextCompactionTaskId());
                if (!crossSpaceCompactionTask.setSourceFilesToCompactionCandidate()) {
                    throw new RuntimeException("fail to set status to compaction candidate.");
                }
                cd1.countDown();
                cd2.await();
                Assert.assertThrows((String)"cross space compaction task should be invalid.", FileCannotTransitToCompactingException.class, () -> ((CrossSpaceCompactionTask)crossSpaceCompactionTask).transitSourceFilesToMerging());
                FixedPriorityBlockingQueue mockQueue = (FixedPriorityBlockingQueue)Mockito.mock(FixedPriorityBlockingQueue.class);
                Mockito.when((Object)((AbstractCompactionTask)mockQueue.take())).thenReturn((Object)crossSpaceCompactionTask).thenThrow(new Throwable[]{new InterruptedException()});
                CompactionWorker worker = new CompactionWorker(0, mockQueue);
                worker.run();
                for (i = 0; i < this.seqResources.size(); ++i) {
                    resource = (TsFileResource)this.seqResources.get(i);
                    if (i == 1) {
                        if (resource.getStatus() == TsFileResourceStatus.DELETED) continue;
                        throw new RuntimeException("status should be DELETED");
                    }
                    if (resource.getStatus() == TsFileResourceStatus.NORMAL) continue;
                    throw new RuntimeException("status should be NORMAL");
                }
                for (i = 0; i < this.unseqResources.size(); ++i) {
                    resource = (TsFileResource)this.unseqResources.get(i);
                    if (resource.getStatus() == TsFileResourceStatus.NORMAL) continue;
                    throw new RuntimeException("status should be NORMAL");
                }
            }
            catch (Exception e) {
                fail.set(true);
                e.printStackTrace();
            }
        });
        Thread thread2 = new Thread(() -> {
            try {
                cd1.await();
                TsFileResource resource = (TsFileResource)this.seqResources.get(1);
                resource.writeLock();
                resource.remove();
                resource.writeUnlock();
                cd2.countDown();
            }
            catch (Exception e) {
                fail.set(true);
                e.printStackTrace();
            }
        });
        thread1.start();
        thread2.start();
        thread1.join(10000L);
        thread2.join(10000L);
        if (fail.get()) {
            Assert.fail();
        }
    }

    @Test
    public void testSeqFileWithFileIndexBeenDeletedBeforeSelection() throws IOException, MetadataException, WriteProcessException, InterruptedException {
        this.createFiles(5, 2, 3, 50, 0, 10000, 50, 50, false, true);
        this.createFiles(5, 2, 3, 50, 0, 10000, 50, 50, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        AtomicBoolean fail = new AtomicBoolean(false);
        CountDownLatch cd1 = new CountDownLatch(1);
        CountDownLatch cd2 = new CountDownLatch(1);
        ((TsFileResource)this.seqResources.get(1)).degradeTimeIndex();
        ((TsFileResource)this.seqResources.get(2)).degradeTimeIndex();
        ((TsFileResource)this.unseqResources.get(1)).degradeTimeIndex();
        Thread thread1 = new Thread(() -> {
            try {
                cd1.countDown();
                cd2.await();
                RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
                CrossSpaceCompactionCandidate candidate = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources, System.currentTimeMillis() - Long.MAX_VALUE);
                CrossCompactionTaskResource crossCompactionTaskResource = selector.selectOneTaskResources(candidate);
                if (!crossCompactionTaskResource.isValid()) {
                    throw new RuntimeException("compaction task resource is not valid");
                }
                if (crossCompactionTaskResource.getSeqFiles().size() != 1) {
                    throw new RuntimeException("selected seq file num is not 1");
                }
                if (crossCompactionTaskResource.getUnseqFiles().size() != 1) {
                    throw new RuntimeException("selected unseq file num is not 1");
                }
            }
            catch (Exception e) {
                fail.set(true);
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        });
        Thread thread2 = new Thread(() -> {
            try {
                cd1.await();
                TsFileResource resource = (TsFileResource)this.seqResources.get(1);
                resource.writeLock();
                resource.remove();
                resource.writeUnlock();
                cd2.countDown();
            }
            catch (Exception e) {
                fail.set(true);
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        });
        thread1.start();
        thread2.start();
        thread1.join(10000L);
        thread2.join(10000L);
        if (fail.get()) {
            Assert.fail();
        }
    }

    @Test
    public void testUnSeqFileWithDeviceIndexBeenDeletedBeforeSelection() throws IOException, MetadataException, WriteProcessException, InterruptedException {
        this.createFiles(5, 2, 3, 50, 0, 10000, 50, 50, false, true);
        this.createFiles(5, 2, 3, 50, 0, 10000, 50, 50, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        AtomicBoolean fail = new AtomicBoolean(false);
        CountDownLatch cd1 = new CountDownLatch(1);
        CountDownLatch cd2 = new CountDownLatch(1);
        Thread thread1 = new Thread(() -> {
            try {
                cd1.countDown();
                cd2.await();
                RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
                CrossSpaceCompactionCandidate candidate = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources, System.currentTimeMillis() - Long.MAX_VALUE);
                CrossCompactionTaskResource crossCompactionTaskResource = selector.selectOneTaskResources(candidate);
                if (!crossCompactionTaskResource.isValid()) {
                    throw new RuntimeException("compaction task resource is not valid");
                }
                if (crossCompactionTaskResource.getSeqFiles().size() != 1) {
                    throw new RuntimeException("selected seq file num is not 1");
                }
                if (crossCompactionTaskResource.getUnseqFiles().size() != 1) {
                    throw new RuntimeException("selected unseq file num is not 1");
                }
            }
            catch (Exception e) {
                fail.set(true);
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        });
        Thread thread2 = new Thread(() -> {
            try {
                cd1.await();
                TsFileResource resource = (TsFileResource)this.unseqResources.get(1);
                resource.writeLock();
                resource.remove();
                resource.writeUnlock();
                cd2.countDown();
            }
            catch (Exception e) {
                fail.set(true);
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        });
        thread1.start();
        thread2.start();
        thread1.join(10000L);
        thread2.join(10000L);
        if (fail.get()) {
            Assert.fail();
        }
    }

    @Test
    public void testUnSeqFileWithDeviceIndexBeenDeletedDuringSelectionAndAfterCopyingList() throws IOException, MetadataException, WriteProcessException, InterruptedException {
        this.createFiles(5, 2, 3, 50, 0, 10000, 50, 50, false, true);
        this.createFiles(5, 2, 3, 50, 0, 10000, 50, 50, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        AtomicBoolean fail = new AtomicBoolean(false);
        CountDownLatch cd1 = new CountDownLatch(1);
        CountDownLatch cd2 = new CountDownLatch(1);
        Thread thread1 = new Thread(() -> {
            try {
                TsFileResource resource;
                int i;
                RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
                CrossSpaceCompactionCandidate candidate = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources, System.currentTimeMillis() - Long.MAX_VALUE);
                cd1.countDown();
                cd2.await();
                CrossCompactionTaskResource crossCompactionTaskResource = selector.selectOneTaskResources(candidate);
                if (!crossCompactionTaskResource.isValid()) {
                    throw new RuntimeException("compaction task resource is not valid");
                }
                if (crossCompactionTaskResource.getSeqFiles().size() != 1) {
                    throw new RuntimeException("selected seq file num is not 1");
                }
                if (crossCompactionTaskResource.getUnseqFiles().size() != 1) {
                    throw new RuntimeException("selected unseq file num is not 1");
                }
                CrossSpaceCompactionTask crossSpaceCompactionTask = new CrossSpaceCompactionTask(0L, this.tsFileManager, crossCompactionTaskResource.getSeqFiles(), crossCompactionTaskResource.getUnseqFiles(), IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), crossCompactionTaskResource.getTotalMemoryCost(), this.tsFileManager.getNextCompactionTaskId());
                if (!crossSpaceCompactionTask.setSourceFilesToCompactionCandidate()) {
                    throw new RuntimeException("set status should be true");
                }
                for (i = 0; i < this.unseqResources.size(); ++i) {
                    resource = (TsFileResource)this.unseqResources.get(i);
                    if (i < 1) {
                        if (resource.getStatus() == TsFileResourceStatus.COMPACTION_CANDIDATE) continue;
                        throw new RuntimeException("status should be COMPACTION_CANDIDATE");
                    }
                    if (i == 1) {
                        if (resource.getStatus() == TsFileResourceStatus.DELETED) continue;
                        throw new RuntimeException("status should be DELETED");
                    }
                    if (resource.getStatus() == TsFileResourceStatus.NORMAL) continue;
                    throw new RuntimeException("status should be NORMAL");
                }
                for (i = 0; i < this.seqResources.size(); ++i) {
                    resource = (TsFileResource)this.seqResources.get(i);
                    if (i < 1) {
                        if (resource.getStatus() == TsFileResourceStatus.COMPACTION_CANDIDATE) continue;
                        throw new RuntimeException("status should be COMPACTION_CANDIDATE");
                    }
                    if (resource.getStatus() == TsFileResourceStatus.NORMAL) continue;
                    throw new RuntimeException("status should be NORMAL");
                }
            }
            catch (Exception e) {
                fail.set(true);
                e.printStackTrace();
            }
        });
        Thread thread2 = new Thread(() -> {
            try {
                cd1.await();
                TsFileResource resource = (TsFileResource)this.unseqResources.get(1);
                resource.writeLock();
                resource.remove();
                resource.writeUnlock();
                cd2.countDown();
            }
            catch (Exception e) {
                fail.set(true);
                e.printStackTrace();
            }
        });
        thread1.start();
        thread2.start();
        thread1.join(10000L);
        thread2.join(10000L);
        if (fail.get()) {
            Assert.fail();
        }
    }

    @Test
    public void testUnSeqFileWithDeviceIndexBeenDeletedDuringSelectionAndBeforeSettingCandidate() throws IOException, MetadataException, WriteProcessException, InterruptedException {
        this.createFiles(5, 2, 3, 50, 0, 10000, 50, 50, false, true);
        this.createFiles(5, 2, 3, 50, 0, 10000, 50, 50, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        AtomicBoolean fail = new AtomicBoolean(false);
        CountDownLatch cd1 = new CountDownLatch(1);
        CountDownLatch cd2 = new CountDownLatch(1);
        Thread thread1 = new Thread(() -> {
            try {
                TsFileResource resource;
                int i;
                RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
                CrossSpaceCompactionCandidate candidate = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources, System.currentTimeMillis() - Long.MAX_VALUE);
                CrossCompactionTaskResource crossCompactionTaskResource = selector.selectOneTaskResources(candidate);
                if (!crossCompactionTaskResource.isValid()) {
                    throw new RuntimeException("compaction task resource is not valid");
                }
                if (crossCompactionTaskResource.getSeqFiles().size() != 5) {
                    throw new RuntimeException("selected seq file num is not 5");
                }
                if (crossCompactionTaskResource.getUnseqFiles().size() != 5) {
                    throw new RuntimeException("selected unseq file num is not 5");
                }
                cd1.countDown();
                cd2.await();
                CrossSpaceCompactionTask crossSpaceCompactionTask = new CrossSpaceCompactionTask(0L, this.tsFileManager, crossCompactionTaskResource.getSeqFiles(), crossCompactionTaskResource.getUnseqFiles(), IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), crossCompactionTaskResource.getTotalMemoryCost(), this.tsFileManager.getNextCompactionTaskId());
                if (crossSpaceCompactionTask.setSourceFilesToCompactionCandidate()) {
                    throw new RuntimeException("set status should be false");
                }
                for (i = 0; i < this.unseqResources.size(); ++i) {
                    resource = (TsFileResource)this.unseqResources.get(i);
                    if (i == 1) {
                        if (resource.getStatus() == TsFileResourceStatus.DELETED) continue;
                        throw new RuntimeException("status should be DELETED");
                    }
                    if (resource.getStatus() == TsFileResourceStatus.NORMAL) continue;
                    throw new RuntimeException("status should be NORMAL");
                }
                for (i = 0; i < this.seqResources.size(); ++i) {
                    resource = (TsFileResource)this.seqResources.get(i);
                    if (resource.getStatus() == TsFileResourceStatus.NORMAL) continue;
                    throw new RuntimeException("status should be NORMAL");
                }
            }
            catch (Exception e) {
                fail.set(true);
                e.printStackTrace();
            }
        });
        Thread thread2 = new Thread(() -> {
            try {
                cd1.await();
                TsFileResource resource = (TsFileResource)this.unseqResources.get(1);
                resource.writeLock();
                resource.remove();
                resource.writeUnlock();
                cd2.countDown();
            }
            catch (Exception e) {
                fail.set(true);
                e.printStackTrace();
            }
        });
        thread1.start();
        thread2.start();
        thread1.join(10000L);
        thread2.join(10000L);
        if (fail.get()) {
            Assert.fail();
        }
    }

    @Test
    public void testUnSeqFileWithDeviceIndexBeenDeletedDuringSelectionAndBeforeSettingCompacting() throws IOException, MetadataException, WriteProcessException, InterruptedException {
        this.createFiles(5, 2, 3, 50, 0, 10000, 50, 50, false, true);
        this.createFiles(5, 2, 3, 50, 0, 10000, 50, 50, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        AtomicBoolean fail = new AtomicBoolean(false);
        CountDownLatch cd1 = new CountDownLatch(1);
        CountDownLatch cd2 = new CountDownLatch(1);
        Thread thread1 = new Thread(() -> {
            try {
                TsFileResource resource;
                int i;
                RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
                CrossSpaceCompactionCandidate candidate = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources, System.currentTimeMillis() - Long.MAX_VALUE);
                CrossCompactionTaskResource crossCompactionTaskResource = selector.selectOneTaskResources(candidate);
                if (!crossCompactionTaskResource.isValid()) {
                    throw new RuntimeException("compaction task resource is not valid");
                }
                if (crossCompactionTaskResource.getSeqFiles().size() != 5) {
                    throw new RuntimeException("selected seq file num is not 5");
                }
                if (crossCompactionTaskResource.getUnseqFiles().size() != 5) {
                    throw new RuntimeException("selected unseq file num is not 5");
                }
                CrossSpaceCompactionTask crossSpaceCompactionTask = new CrossSpaceCompactionTask(0L, this.tsFileManager, crossCompactionTaskResource.getSeqFiles(), crossCompactionTaskResource.getUnseqFiles(), IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), crossCompactionTaskResource.getTotalMemoryCost(), this.tsFileManager.getNextCompactionTaskId());
                if (!crossSpaceCompactionTask.setSourceFilesToCompactionCandidate()) {
                    throw new RuntimeException("fail to set status to compaction candidate.");
                }
                cd1.countDown();
                cd2.await();
                Assert.assertThrows((String)"cross space compaction task should be invalid.", FileCannotTransitToCompactingException.class, () -> ((CrossSpaceCompactionTask)crossSpaceCompactionTask).transitSourceFilesToMerging());
                FixedPriorityBlockingQueue mockQueue = (FixedPriorityBlockingQueue)Mockito.mock(FixedPriorityBlockingQueue.class);
                Mockito.when((Object)((AbstractCompactionTask)mockQueue.take())).thenReturn((Object)crossSpaceCompactionTask).thenThrow(new Throwable[]{new InterruptedException()});
                CompactionWorker worker = new CompactionWorker(0, mockQueue);
                worker.run();
                for (i = 0; i < this.unseqResources.size(); ++i) {
                    resource = (TsFileResource)this.unseqResources.get(i);
                    if (i == 1) {
                        if (resource.getStatus() == TsFileResourceStatus.DELETED) continue;
                        throw new RuntimeException("status should be DELETED");
                    }
                    if (resource.getStatus() == TsFileResourceStatus.NORMAL) continue;
                    throw new RuntimeException("status should be NORMAL");
                }
                for (i = 0; i < this.seqResources.size(); ++i) {
                    resource = (TsFileResource)this.seqResources.get(i);
                    if (resource.getStatus() == TsFileResourceStatus.NORMAL) continue;
                    throw new RuntimeException("status should be NORMAL");
                }
            }
            catch (Exception e) {
                fail.set(true);
                e.printStackTrace();
            }
        });
        Thread thread2 = new Thread(() -> {
            try {
                cd1.await();
                TsFileResource resource = (TsFileResource)this.unseqResources.get(1);
                resource.writeLock();
                resource.remove();
                resource.writeUnlock();
                cd2.countDown();
            }
            catch (Exception e) {
                fail.set(true);
                e.printStackTrace();
            }
        });
        thread1.start();
        thread2.start();
        thread1.join(10000L);
        thread2.join(10000L);
        if (fail.get()) {
            Assert.fail();
        }
    }

    @Test
    public void testUnSeqFileWithFileIndexBeenDeletedDuringSelectionAndAfterCopyingList() throws IOException, MetadataException, WriteProcessException, InterruptedException {
        this.createFiles(5, 2, 3, 50, 0, 10000, 50, 50, false, true);
        this.createFiles(5, 2, 3, 50, 0, 10000, 50, 50, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        AtomicBoolean fail = new AtomicBoolean(false);
        CountDownLatch cd1 = new CountDownLatch(1);
        CountDownLatch cd2 = new CountDownLatch(1);
        ((TsFileResource)this.unseqResources.get(0)).degradeTimeIndex();
        ((TsFileResource)this.unseqResources.get(1)).degradeTimeIndex();
        ((TsFileResource)this.unseqResources.get(2)).degradeTimeIndex();
        ((TsFileResource)this.seqResources.get(1)).degradeTimeIndex();
        Thread thread1 = new Thread(() -> {
            try {
                TsFileResource resource;
                int i;
                RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
                CrossSpaceCompactionCandidate candidate = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources, System.currentTimeMillis() - Long.MAX_VALUE);
                cd1.countDown();
                cd2.await();
                CrossCompactionTaskResource crossCompactionTaskResource = selector.selectOneTaskResources(candidate);
                if (!crossCompactionTaskResource.isValid()) {
                    throw new RuntimeException("compaction task resource is not valid");
                }
                if (crossCompactionTaskResource.getSeqFiles().size() != 1) {
                    throw new RuntimeException("selected seq file num is not 1");
                }
                if (crossCompactionTaskResource.getUnseqFiles().size() != 1) {
                    throw new RuntimeException("selected unseq file num is not 1");
                }
                CrossSpaceCompactionTask crossSpaceCompactionTask = new CrossSpaceCompactionTask(0L, this.tsFileManager, crossCompactionTaskResource.getSeqFiles(), crossCompactionTaskResource.getUnseqFiles(), IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), crossCompactionTaskResource.getTotalMemoryCost(), this.tsFileManager.getNextCompactionTaskId());
                if (!crossSpaceCompactionTask.setSourceFilesToCompactionCandidate()) {
                    throw new RuntimeException("set status should be true");
                }
                for (i = 0; i < this.unseqResources.size(); ++i) {
                    resource = (TsFileResource)this.unseqResources.get(i);
                    if (i < 1) {
                        if (resource.getStatus() == TsFileResourceStatus.COMPACTION_CANDIDATE) continue;
                        throw new RuntimeException("status should be COMPACTION_CANDIDATE");
                    }
                    if (i == 1) {
                        if (resource.getStatus() == TsFileResourceStatus.DELETED) continue;
                        throw new RuntimeException("status should be DELETED");
                    }
                    if (resource.getStatus() == TsFileResourceStatus.NORMAL) continue;
                    throw new RuntimeException("status should be NORMAL");
                }
                for (i = 0; i < this.seqResources.size(); ++i) {
                    resource = (TsFileResource)this.seqResources.get(i);
                    if (i < 1) {
                        if (resource.getStatus() == TsFileResourceStatus.COMPACTION_CANDIDATE) continue;
                        throw new RuntimeException("status should be COMPACTION_CANDIDATE");
                    }
                    if (resource.getStatus() == TsFileResourceStatus.NORMAL) continue;
                    throw new RuntimeException("status should be NORMAL");
                }
            }
            catch (Exception e) {
                fail.set(true);
                e.printStackTrace();
            }
        });
        Thread thread2 = new Thread(() -> {
            try {
                cd1.await();
                TsFileResource resource = (TsFileResource)this.unseqResources.get(1);
                resource.writeLock();
                resource.remove();
                resource.writeUnlock();
                cd2.countDown();
            }
            catch (Exception e) {
                fail.set(true);
                e.printStackTrace();
            }
        });
        thread1.start();
        thread2.start();
        thread1.join(10000L);
        thread2.join(10000L);
        if (fail.get()) {
            Assert.fail();
        }
    }

    @Test
    public void testUnSeqFileWithFileIndexBeenDeletedDuringSelectionAndBeforeSettingCandidate() throws IOException, MetadataException, WriteProcessException, InterruptedException {
        this.createFiles(5, 2, 3, 50, 0, 10000, 50, 50, false, true);
        this.createFiles(5, 2, 3, 50, 0, 10000, 50, 50, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        AtomicBoolean fail = new AtomicBoolean(false);
        CountDownLatch cd1 = new CountDownLatch(1);
        CountDownLatch cd2 = new CountDownLatch(1);
        ((TsFileResource)this.unseqResources.get(0)).degradeTimeIndex();
        ((TsFileResource)this.unseqResources.get(1)).degradeTimeIndex();
        ((TsFileResource)this.unseqResources.get(2)).degradeTimeIndex();
        ((TsFileResource)this.seqResources.get(1)).degradeTimeIndex();
        Thread thread1 = new Thread(() -> {
            try {
                TsFileResource resource;
                int i;
                RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
                CrossSpaceCompactionCandidate candidate = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources, System.currentTimeMillis() - Long.MAX_VALUE);
                CrossCompactionTaskResource crossCompactionTaskResource = selector.selectOneTaskResources(candidate);
                if (!crossCompactionTaskResource.isValid()) {
                    throw new RuntimeException("compaction task resource is not valid");
                }
                if (crossCompactionTaskResource.getSeqFiles().size() != 5) {
                    throw new RuntimeException("selected seq file num is not 5");
                }
                if (crossCompactionTaskResource.getUnseqFiles().size() != 5) {
                    throw new RuntimeException("selected unseq file num is not 5");
                }
                cd1.countDown();
                cd2.await();
                CrossSpaceCompactionTask crossSpaceCompactionTask = new CrossSpaceCompactionTask(0L, this.tsFileManager, crossCompactionTaskResource.getSeqFiles(), crossCompactionTaskResource.getUnseqFiles(), IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), crossCompactionTaskResource.getTotalMemoryCost(), this.tsFileManager.getNextCompactionTaskId());
                if (crossSpaceCompactionTask.setSourceFilesToCompactionCandidate()) {
                    throw new RuntimeException("set status should be false");
                }
                for (i = 0; i < this.unseqResources.size(); ++i) {
                    resource = (TsFileResource)this.unseqResources.get(i);
                    if (i == 1) {
                        if (resource.getStatus() == TsFileResourceStatus.DELETED) continue;
                        throw new RuntimeException("status should be DELETED");
                    }
                    if (resource.getStatus() == TsFileResourceStatus.NORMAL) continue;
                    throw new RuntimeException("status should be NORMAL");
                }
                for (i = 0; i < this.seqResources.size(); ++i) {
                    resource = (TsFileResource)this.seqResources.get(i);
                    if (resource.getStatus() == TsFileResourceStatus.NORMAL) continue;
                    throw new RuntimeException("status should be NORMAL");
                }
            }
            catch (Exception e) {
                fail.set(true);
                e.printStackTrace();
            }
        });
        Thread thread2 = new Thread(() -> {
            try {
                cd1.await();
                TsFileResource resource = (TsFileResource)this.unseqResources.get(1);
                resource.writeLock();
                resource.remove();
                resource.writeUnlock();
                cd2.countDown();
            }
            catch (Exception e) {
                fail.set(true);
                e.printStackTrace();
            }
        });
        thread1.start();
        thread2.start();
        thread1.join(10000L);
        thread2.join(10000L);
        if (fail.get()) {
            Assert.fail();
        }
    }

    @Test
    public void testUnSeqFileWithFileIndexBeenDeletedDuringSelectionAndBeforeSettingCompacting() throws IOException, MetadataException, WriteProcessException, InterruptedException {
        this.createFiles(5, 2, 3, 50, 0, 10000, 50, 50, false, true);
        this.createFiles(5, 2, 3, 50, 0, 10000, 50, 50, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        AtomicBoolean fail = new AtomicBoolean(false);
        CountDownLatch cd1 = new CountDownLatch(1);
        CountDownLatch cd2 = new CountDownLatch(1);
        ((TsFileResource)this.unseqResources.get(0)).degradeTimeIndex();
        ((TsFileResource)this.unseqResources.get(1)).degradeTimeIndex();
        ((TsFileResource)this.unseqResources.get(2)).degradeTimeIndex();
        ((TsFileResource)this.seqResources.get(1)).degradeTimeIndex();
        Thread thread1 = new Thread(() -> {
            try {
                TsFileResource resource;
                int i;
                RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
                CrossSpaceCompactionCandidate candidate = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources, System.currentTimeMillis() - Long.MAX_VALUE);
                CrossCompactionTaskResource crossCompactionTaskResource = selector.selectOneTaskResources(candidate);
                if (!crossCompactionTaskResource.isValid()) {
                    throw new RuntimeException("compaction task resource is not valid");
                }
                if (crossCompactionTaskResource.getSeqFiles().size() != 5) {
                    throw new RuntimeException("selected seq file num is not 5");
                }
                if (crossCompactionTaskResource.getUnseqFiles().size() != 5) {
                    throw new RuntimeException("selected unseq file num is not 5");
                }
                CrossSpaceCompactionTask crossSpaceCompactionTask = new CrossSpaceCompactionTask(0L, this.tsFileManager, crossCompactionTaskResource.getSeqFiles(), crossCompactionTaskResource.getUnseqFiles(), IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), crossCompactionTaskResource.getTotalMemoryCost(), this.tsFileManager.getNextCompactionTaskId());
                if (!crossSpaceCompactionTask.setSourceFilesToCompactionCandidate()) {
                    throw new RuntimeException("fail to set status to compaction candidate.");
                }
                cd1.countDown();
                cd2.await();
                Assert.assertThrows((String)"cross space compaction task should be invalid.", FileCannotTransitToCompactingException.class, () -> ((CrossSpaceCompactionTask)crossSpaceCompactionTask).transitSourceFilesToMerging());
                FixedPriorityBlockingQueue mockQueue = (FixedPriorityBlockingQueue)Mockito.mock(FixedPriorityBlockingQueue.class);
                Mockito.when((Object)((AbstractCompactionTask)mockQueue.take())).thenReturn((Object)crossSpaceCompactionTask).thenThrow(new Throwable[]{new InterruptedException()});
                CompactionWorker worker = new CompactionWorker(0, mockQueue);
                worker.run();
                for (i = 0; i < this.unseqResources.size(); ++i) {
                    resource = (TsFileResource)this.unseqResources.get(i);
                    if (i == 1) {
                        if (resource.getStatus() == TsFileResourceStatus.DELETED) continue;
                        throw new RuntimeException("status should be DELETED");
                    }
                    if (resource.getStatus() == TsFileResourceStatus.NORMAL) continue;
                    throw new RuntimeException("status should be NORMAL");
                }
                for (i = 0; i < this.seqResources.size(); ++i) {
                    resource = (TsFileResource)this.seqResources.get(i);
                    if (resource.getStatus() == TsFileResourceStatus.NORMAL) continue;
                    throw new RuntimeException("status should be NORMAL");
                }
            }
            catch (Exception e) {
                fail.set(true);
                e.printStackTrace();
            }
        });
        Thread thread2 = new Thread(() -> {
            try {
                cd1.await();
                TsFileResource resource = (TsFileResource)this.unseqResources.get(1);
                resource.writeLock();
                resource.remove();
                resource.writeUnlock();
                cd2.countDown();
            }
            catch (Exception e) {
                fail.set(true);
                e.printStackTrace();
            }
        });
        thread1.start();
        thread2.start();
        thread1.join(10000L);
        thread2.join(10000L);
        if (fail.get()) {
            Assert.fail();
        }
    }

    @Test
    public void testUnSeqFileWithFileIndexBeenDeletedBeforeSelection() throws IOException, MetadataException, WriteProcessException, InterruptedException {
        this.createFiles(5, 2, 3, 50, 0, 10000, 50, 50, false, true);
        this.createFiles(5, 2, 3, 50, 0, 10000, 50, 50, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        AtomicBoolean fail = new AtomicBoolean(false);
        CountDownLatch cd1 = new CountDownLatch(1);
        CountDownLatch cd2 = new CountDownLatch(1);
        ((TsFileResource)this.unseqResources.get(0)).degradeTimeIndex();
        ((TsFileResource)this.unseqResources.get(1)).degradeTimeIndex();
        ((TsFileResource)this.unseqResources.get(2)).degradeTimeIndex();
        ((TsFileResource)this.seqResources.get(1)).degradeTimeIndex();
        Thread thread1 = new Thread(() -> {
            try {
                cd1.countDown();
                cd2.await();
                RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
                CrossSpaceCompactionCandidate candidate = new CrossSpaceCompactionCandidate(this.seqResources, this.unseqResources, System.currentTimeMillis() - Long.MAX_VALUE);
                CrossCompactionTaskResource crossCompactionTaskResource = selector.selectOneTaskResources(candidate);
                if (!crossCompactionTaskResource.isValid()) {
                    throw new RuntimeException("compaction task resource is not valid");
                }
                if (crossCompactionTaskResource.getSeqFiles().size() != 1) {
                    throw new RuntimeException("selected seq file num is not 1");
                }
                if (crossCompactionTaskResource.getUnseqFiles().size() != 1) {
                    throw new RuntimeException("selected unseq file num is not 1");
                }
            }
            catch (Exception e) {
                fail.set(true);
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        });
        Thread thread2 = new Thread(() -> {
            try {
                cd1.await();
                TsFileResource resource = (TsFileResource)this.unseqResources.get(1);
                resource.writeLock();
                resource.remove();
                resource.writeUnlock();
                cd2.countDown();
            }
            catch (Exception e) {
                fail.set(true);
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        });
        thread1.start();
        thread2.start();
        thread1.join(10000L);
        thread2.join(10000L);
        if (fail.get()) {
            Assert.fail();
        }
    }

    private static /* synthetic */ void lambda$testSelectWithTooManySourceFiles$0(FixedPriorityBlockingQueue queue) {
        try {
            AbstractCompactionTask task = (AbstractCompactionTask)queue.take();
            Assert.fail();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

