/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.cross;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.AbstractCompactionTest;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.exception.CompactionExceptionHandler;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.ICrossCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.FastCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.ReadPointCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CrossSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.subtask.FastCompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.log.CompactionLogger;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.CompactionConfigRestorer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.CompactionFileGeneratorUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.CompactionTestFileWriter;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModificationFile;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.utils.Pair;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CrossSpaceCompactionExceptionTest
extends AbstractCompactionTest {
    private final String oldThreadName = Thread.currentThread().getName();
    private long targetChunkSize;

    @Override
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException, InterruptedException {
        super.setUp();
        this.targetChunkSize = IoTDBDescriptor.getInstance().getConfig().getTargetChunkSize();
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkSize(1024L);
        Thread.currentThread().setName("pool-1-IoTDB-Compaction-Worker-1");
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        super.tearDown();
        Thread.currentThread().setName(this.oldThreadName);
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkSize(this.targetChunkSize);
        new CompactionConfigRestorer().restoreCompactionConfig();
    }

    @Test
    public void testHandleWithAllSourceFilesExisted() throws Exception {
        this.registerTimeseriesInMManger(4, 5, false);
        this.createFiles(2, 2, 3, 300, 0, 0, 50, 50, false, true);
        this.createFiles(2, 4, 5, 300, 700, 700, 50, 50, false, true);
        this.createFiles(3, 3, 4, 200, 20, 10020, 30, 30, false, false);
        this.createFiles(2, 1, 5, 100, 450, 20450, 0, 0, false, false);
        TsFileManager tsFileManager = new TsFileManager(COMPACTION_TEST_SG, "0", SEQ_DIRS.getPath());
        tsFileManager.addAll(this.seqResources, true);
        tsFileManager.addAll(this.unseqResources, false);
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources);
        File compactionLogFile = new File(SEQ_DIRS, targetResources.get(0).getTsFile().getName() + ".cross-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(compactionLogFile);
        compactionLogger.logFiles(targetResources, "target");
        compactionLogger.logFiles(this.seqResources, "source");
        compactionLogger.logFiles(this.unseqResources, "source");
        ReadPointCompactionPerformer performer = new ReadPointCompactionPerformer(this.seqResources, this.unseqResources, targetResources);
        performer.setSummary(new CompactionTaskSummary());
        performer.perform();
        compactionLogger.close();
        CompactionExceptionHandler.handleException((String)COMPACTION_TEST_SG, (File)compactionLogFile, targetResources, (List)this.seqResources, (List)this.unseqResources, (TsFileManager)tsFileManager, (long)0L, (boolean)false, (boolean)true);
        for (TsFileResource resource : this.seqResources) {
            Assert.assertTrue((boolean)resource.getTsFile().exists());
            Assert.assertTrue((boolean)new File(resource.getTsFilePath() + ".resource").exists());
        }
        for (TsFileResource resource : this.unseqResources) {
            Assert.assertTrue((boolean)resource.getTsFile().exists());
            Assert.assertTrue((boolean)new File(resource.getTsFilePath() + ".resource").exists());
        }
        for (TsFileResource resource : targetResources) {
            Assert.assertFalse((boolean)resource.getTsFile().exists());
            Assert.assertFalse((boolean)new File(resource.getTsFilePath().replace(".cross", ".tsfile")).exists());
            Assert.assertFalse((boolean)new File(resource.getTsFilePath().replace(".cross", ".tsfile") + ".resource").exists());
        }
        Assert.assertEquals((long)4L, (long)tsFileManager.getOrCreateSequenceListByTimePartition(0L).size());
        Assert.assertEquals((long)5L, (long)tsFileManager.getOrCreateUnsequenceListByTimePartition(0L).size());
        Assert.assertTrue((boolean)tsFileManager.isAllowCompaction());
    }

    @Test
    public void testHandleWithAllSourceFilesExistedAndTargetFilesMoved() throws Exception {
        this.registerTimeseriesInMManger(4, 5, false);
        this.createFiles(2, 2, 3, 300, 0, 0, 50, 50, false, true);
        this.createFiles(2, 4, 5, 300, 700, 700, 50, 50, false, true);
        this.createFiles(3, 3, 4, 200, 20, 10020, 30, 30, false, false);
        this.createFiles(2, 1, 5, 100, 450, 20450, 0, 0, false, false);
        TsFileManager tsFileManager = new TsFileManager(COMPACTION_TEST_SG, "0", SEQ_DIRS.getPath());
        tsFileManager.addAll(this.seqResources, true);
        tsFileManager.addAll(this.unseqResources, false);
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources);
        File compactionLogFile = new File(SEQ_DIRS, targetResources.get(0).getTsFile().getName() + ".cross-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(compactionLogFile);
        compactionLogger.logFiles(targetResources, "target");
        compactionLogger.logFiles(this.seqResources, "source");
        compactionLogger.logFiles(this.unseqResources, "source");
        ReadPointCompactionPerformer performer = new ReadPointCompactionPerformer(this.seqResources, this.unseqResources, targetResources);
        performer.setSummary(new CompactionTaskSummary());
        performer.perform();
        compactionLogger.close();
        CompactionUtils.moveTargetFile(targetResources, (boolean)false, (String)COMPACTION_TEST_SG);
        CompactionExceptionHandler.handleException((String)COMPACTION_TEST_SG, (File)compactionLogFile, targetResources, (List)this.seqResources, (List)this.unseqResources, (TsFileManager)tsFileManager, (long)0L, (boolean)false, (boolean)true);
        for (TsFileResource resource : this.seqResources) {
            Assert.assertTrue((boolean)resource.getTsFile().exists());
            Assert.assertTrue((boolean)new File(resource.getTsFilePath() + ".resource").exists());
        }
        for (TsFileResource resource : this.unseqResources) {
            Assert.assertTrue((boolean)resource.getTsFile().exists());
            Assert.assertTrue((boolean)new File(resource.getTsFilePath() + ".resource").exists());
        }
        for (TsFileResource resource : targetResources) {
            Assert.assertFalse((boolean)resource.getTsFile().exists());
            Assert.assertFalse((boolean)new File(resource.getTsFilePath().replace(".tsfile", ".cross")).exists());
            Assert.assertFalse((boolean)new File(resource.getTsFilePath().replace(".cross", ".tsfile") + ".resource").exists());
        }
        Assert.assertEquals((long)4L, (long)tsFileManager.getOrCreateSequenceListByTimePartition(0L).size());
        Assert.assertEquals((long)5L, (long)tsFileManager.getOrCreateUnsequenceListByTimePartition(0L).size());
        Assert.assertTrue((boolean)tsFileManager.isAllowCompaction());
    }

    @Test
    public void testHandleWithSomeSourceFilesExisted() throws Exception {
        this.registerTimeseriesInMManger(4, 5, false);
        this.createFiles(2, 2, 3, 300, 0, 0, 50, 50, false, true);
        this.createFiles(2, 4, 5, 300, 700, 700, 50, 50, false, true);
        this.createFiles(3, 3, 4, 200, 20, 10020, 30, 30, false, false);
        this.createFiles(2, 1, 5, 100, 450, 20450, 0, 0, false, false);
        TsFileManager tsFileManager = new TsFileManager(COMPACTION_TEST_SG, "0", SEQ_DIRS.getPath());
        tsFileManager.addAll(this.seqResources, true);
        tsFileManager.addAll(this.unseqResources, false);
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources);
        File compactionLogFile = new File(SEQ_DIRS, targetResources.get(0).getTsFile().getName() + ".cross-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(compactionLogFile);
        compactionLogger.logFiles(targetResources, "target");
        compactionLogger.logFiles(this.seqResources, "source");
        compactionLogger.logFiles(this.unseqResources, "source");
        ReadPointCompactionPerformer performer = new ReadPointCompactionPerformer(this.seqResources, this.unseqResources, targetResources);
        performer.setSummary(new CompactionTaskSummary());
        performer.perform();
        CompactionUtils.moveTargetFile(targetResources, (boolean)false, (String)COMPACTION_TEST_SG);
        for (TsFileResource resource : this.seqResources) {
            tsFileManager.getOrCreateSequenceListByTimePartition(0L).remove((Object)resource);
        }
        for (TsFileResource resource : this.unseqResources) {
            tsFileManager.getOrCreateUnsequenceListByTimePartition(0L).remove((Object)resource);
        }
        for (TsFileResource resource : targetResources) {
            tsFileManager.getOrCreateSequenceListByTimePartition(0L).keepOrderInsert(resource);
        }
        ((TsFileResource)this.seqResources.get(0)).getTsFile().delete();
        compactionLogger.close();
        CompactionExceptionHandler.handleException((String)COMPACTION_TEST_SG, (File)compactionLogFile, targetResources, (List)this.seqResources, (List)this.unseqResources, (TsFileManager)tsFileManager, (long)0L, (boolean)false, (boolean)true);
        for (TsFileResource resource : this.seqResources) {
            Assert.assertFalse((boolean)resource.getTsFile().exists());
        }
        for (TsFileResource resource : targetResources) {
            Assert.assertFalse((boolean)new File(resource.getTsFilePath().replace(".tsfile", ".cross")).exists());
            Assert.assertFalse((boolean)new File(resource.getTsFilePath().replace(".tsfile", ".cross") + ".resource").exists());
            Assert.assertTrue((boolean)resource.getTsFile().exists());
            Assert.assertTrue((boolean)new File(resource.getTsFilePath() + ".resource").exists());
        }
        Assert.assertEquals((long)4L, (long)tsFileManager.getOrCreateSequenceListByTimePartition(0L).size());
        Assert.assertEquals((long)0L, (long)tsFileManager.getOrCreateUnsequenceListByTimePartition(0L).size());
        Assert.assertTrue((boolean)tsFileManager.isAllowCompaction());
    }

    @Test
    public void testHandleWithoutAllSourceFilesAndModFilesExist() throws Exception {
        HashMap<String, Pair<Long, Long>> deleteMap;
        int i;
        this.registerTimeseriesInMManger(4, 5, false);
        this.createFiles(2, 2, 3, 300, 0, 0, 50, 50, false, true);
        this.createFiles(2, 4, 5, 300, 700, 700, 50, 50, false, true);
        this.createFiles(3, 3, 4, 200, 20, 10020, 30, 30, false, false);
        this.createFiles(2, 1, 5, 100, 450, 20450, 0, 0, false, false);
        TsFileManager tsFileManager = new TsFileManager(COMPACTION_TEST_SG, "0", SEQ_DIRS.getPath());
        tsFileManager.addAll(this.seqResources, true);
        tsFileManager.addAll(this.unseqResources, false);
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources);
        File compactionLogFile = new File(SEQ_DIRS, targetResources.get(0).getTsFile().getName() + ".cross-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(compactionLogFile);
        compactionLogger.logFiles(targetResources, "target");
        compactionLogger.logFiles(this.seqResources, "source");
        compactionLogger.logFiles(this.unseqResources, "source");
        ReadPointCompactionPerformer performer = new ReadPointCompactionPerformer(this.seqResources, this.unseqResources, targetResources);
        performer.setSummary(new CompactionTaskSummary());
        performer.perform();
        CompactionUtils.moveTargetFile(targetResources, (boolean)false, (String)COMPACTION_TEST_SG);
        compactionLogger.close();
        for (i = 0; i < this.seqResources.size(); ++i) {
            deleteMap = new HashMap<String, Pair<Long, Long>>();
            deleteMap.put(COMPACTION_TEST_SG + "." + "d0" + "." + "s0", new Pair((Object)((long)i * 10L), (Object)((long)i * 10L + 10L)));
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.seqResources.get(i), true);
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.seqResources.get(i), false);
        }
        for (i = 0; i < this.unseqResources.size(); ++i) {
            deleteMap = new HashMap();
            deleteMap.put(COMPACTION_TEST_SG + "." + "d1" + "." + "s1", new Pair((Object)((long)i * 10L), (Object)((long)i * 10L + 10L)));
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.unseqResources.get(i), true);
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.unseqResources.get(i), false);
        }
        CompactionUtils.combineModsInCrossCompaction((List)this.seqResources, (List)this.unseqResources, targetResources);
        for (TsFileResource resource : this.seqResources) {
            tsFileManager.getOrCreateSequenceListByTimePartition(0L).remove((Object)resource);
        }
        for (TsFileResource resource : this.unseqResources) {
            tsFileManager.getOrCreateUnsequenceListByTimePartition(0L).remove((Object)resource);
        }
        for (TsFileResource resource : targetResources) {
            tsFileManager.getOrCreateSequenceListByTimePartition(0L).keepOrderInsert(resource);
        }
        ((TsFileResource)this.seqResources.get(0)).remove();
        CompactionExceptionHandler.handleException((String)COMPACTION_TEST_SG, (File)compactionLogFile, targetResources, (List)this.seqResources, (List)this.unseqResources, (TsFileManager)tsFileManager, (long)0L, (boolean)false, (boolean)true);
        for (TsFileResource resource : this.seqResources) {
            Assert.assertFalse((boolean)resource.getTsFile().exists());
            Assert.assertFalse((boolean)resource.getCompactionModFile().exists());
            Assert.assertFalse((boolean)resource.getModFile().exists());
        }
        for (TsFileResource resource : this.unseqResources) {
            Assert.assertFalse((boolean)resource.getTsFile().exists());
            Assert.assertFalse((boolean)resource.getCompactionModFile().exists());
            Assert.assertFalse((boolean)resource.getModFile().exists());
        }
        for (TsFileResource resource : targetResources) {
            Assert.assertFalse((boolean)new File(resource.getTsFilePath().replace(".tsfile", ".cross")).exists());
            Assert.assertFalse((boolean)new File(resource.getTsFilePath().replace(".tsfile", ".cross") + ".resource").exists());
            Assert.assertTrue((boolean)resource.getTsFile().exists());
            Assert.assertTrue((boolean)new File(resource.getTsFilePath() + ".resource").exists());
            Assert.assertTrue((boolean)resource.getModFile().exists());
        }
        Assert.assertFalse((boolean)compactionLogFile.exists());
        Assert.assertEquals((long)4L, (long)tsFileManager.getOrCreateSequenceListByTimePartition(0L).size());
        Assert.assertEquals((long)0L, (long)tsFileManager.getOrCreateUnsequenceListByTimePartition(0L).size());
        Assert.assertTrue((boolean)tsFileManager.isAllowCompaction());
    }

    @Test
    public void testHandleWithAllSourcesFileAndCompactonModFileExist() throws Exception {
        int i;
        HashMap<String, Pair<Long, Long>> deleteMap;
        int i2;
        this.registerTimeseriesInMManger(4, 5, false);
        this.createFiles(2, 2, 3, 300, 0, 0, 50, 50, false, true);
        this.createFiles(2, 4, 5, 300, 700, 700, 50, 50, false, true);
        this.createFiles(3, 3, 4, 200, 20, 10020, 30, 30, false, false);
        this.createFiles(2, 1, 5, 100, 450, 20450, 0, 0, false, false);
        TsFileManager tsFileManager = new TsFileManager(COMPACTION_TEST_SG, "0", SEQ_DIRS.getPath());
        tsFileManager.addAll(this.seqResources, true);
        tsFileManager.addAll(this.unseqResources, false);
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources);
        File compactionLogFile = new File(SEQ_DIRS, targetResources.get(0).getTsFile().getName() + ".cross-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(compactionLogFile);
        compactionLogger.logFiles(targetResources, "target");
        compactionLogger.logFiles(this.seqResources, "source");
        compactionLogger.logFiles(this.unseqResources, "source");
        ReadPointCompactionPerformer performer = new ReadPointCompactionPerformer(this.seqResources, this.unseqResources, targetResources);
        performer.setSummary(new CompactionTaskSummary());
        performer.perform();
        CompactionUtils.moveTargetFile(targetResources, (boolean)false, (String)COMPACTION_TEST_SG);
        compactionLogger.close();
        for (i2 = 0; i2 < this.seqResources.size(); ++i2) {
            deleteMap = new HashMap<String, Pair<Long, Long>>();
            deleteMap.put(COMPACTION_TEST_SG + "." + "d0" + "." + "s0", new Pair((Object)((long)i2 * 10L), (Object)((long)i2 * 10L + 10L)));
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.seqResources.get(i2), true);
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.seqResources.get(i2), false);
        }
        for (i2 = 0; i2 < this.unseqResources.size(); ++i2) {
            deleteMap = new HashMap();
            deleteMap.put(COMPACTION_TEST_SG + "." + "d1" + "." + "s1", new Pair((Object)((long)i2 * 10L), (Object)((long)i2 * 10L + 10L)));
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.unseqResources.get(i2), true);
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.unseqResources.get(i2), false);
        }
        CompactionUtils.combineModsInCrossCompaction((List)this.seqResources, (List)this.unseqResources, targetResources);
        CompactionExceptionHandler.handleException((String)COMPACTION_TEST_SG, (File)compactionLogFile, targetResources, (List)this.seqResources, (List)this.unseqResources, (TsFileManager)tsFileManager, (long)0L, (boolean)false, (boolean)true);
        for (TsFileResource resource : this.seqResources) {
            Assert.assertTrue((boolean)resource.getTsFile().exists());
            Assert.assertTrue((boolean)new File(resource.getTsFilePath() + ".resource").exists());
        }
        for (TsFileResource resource : this.unseqResources) {
            Assert.assertTrue((boolean)resource.getTsFile().exists());
            Assert.assertTrue((boolean)new File(resource.getTsFilePath() + ".resource").exists());
        }
        for (TsFileResource resource : targetResources) {
            Assert.assertFalse((boolean)resource.getTsFile().exists());
            Assert.assertFalse((boolean)new File(resource.getTsFilePath().replace(".tsfile", ".cross")).exists());
            Assert.assertFalse((boolean)new File(resource.getTsFilePath() + ".resource").exists());
            Assert.assertFalse((boolean)resource.getModFile().exists());
        }
        for (i = 0; i < this.seqResources.size(); ++i) {
            ((TsFileResource)this.seqResources.get(i)).resetModFile();
            ModificationFile f = ((TsFileResource)this.seqResources.get(i)).getCompactionModFile();
            Assert.assertFalse((boolean)f.exists());
        }
        for (i = 0; i < this.unseqResources.size(); ++i) {
            ((TsFileResource)this.unseqResources.get(i)).resetModFile();
            Assert.assertFalse((boolean)((TsFileResource)this.unseqResources.get(i)).getCompactionModFile().exists());
        }
        for (TsFileResource resource : this.seqResources) {
            resource.resetModFile();
            Assert.assertTrue((boolean)resource.getModFile().exists());
            Assert.assertEquals((long)1L, (long)resource.getModFile().getModifications().size());
        }
        for (TsFileResource resource : this.unseqResources) {
            resource.resetModFile();
            Assert.assertTrue((boolean)resource.getModFile().exists());
            Assert.assertEquals((long)1L, (long)resource.getModFile().getModifications().size());
        }
        Assert.assertFalse((boolean)compactionLogFile.exists());
        Assert.assertEquals((long)4L, (long)tsFileManager.getOrCreateSequenceListByTimePartition(0L).size());
        Assert.assertEquals((long)5L, (long)tsFileManager.getOrCreateUnsequenceListByTimePartition(0L).size());
        Assert.assertTrue((boolean)tsFileManager.isAllowCompaction());
    }

    @Test
    public void testWhenTargetFileIsDeletedAfterCompactionAndSomeSourceFilesLost() throws Exception {
        this.createFiles(2, 2, 3, 300, 0, 0, 50, 50, false, true);
        this.createFiles(2, 4, 5, 300, 700, 700, 50, 50, false, true);
        this.createFiles(3, 3, 4, 200, 20, 10020, 30, 30, false, false);
        this.createFiles(2, 1, 5, 100, 450, 20450, 0, 0, false, false);
        TsFileManager tsFileManager = new TsFileManager(COMPACTION_TEST_SG, "0", SEQ_DIRS.getPath());
        tsFileManager.addAll(this.seqResources, true);
        tsFileManager.addAll(this.unseqResources, false);
        for (int device = 0; device < 3; ++device) {
            for (int measurement = 0; measurement < 4; ++measurement) {
                HashMap<String, Pair<Long, Long>> deleteMap = new HashMap<String, Pair<Long, Long>>();
                deleteMap.put(COMPACTION_TEST_SG + "." + "d" + device + "." + "s" + measurement, new Pair((Object)0L, (Object)300L));
                CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.seqResources.get(0), false);
                CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.unseqResources.get(0), false);
                CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.unseqResources.get(1), false);
            }
        }
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources);
        File compactionLogFile = new File(SEQ_DIRS, targetResources.get(0).getTsFile().getName() + ".cross-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(compactionLogFile);
        compactionLogger.logFiles(targetResources, "target");
        compactionLogger.logFiles(this.seqResources, "source");
        compactionLogger.logFiles(this.unseqResources, "source");
        compactionLogger.close();
        FastCompactionPerformer performer = new FastCompactionPerformer(this.seqResources, this.unseqResources, targetResources);
        performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        performer.perform();
        CompactionUtils.moveTargetFile(targetResources, (boolean)false, (String)COMPACTION_TEST_SG);
        CompactionUtils.combineModsInCrossCompaction((List)this.seqResources, (List)this.unseqResources, targetResources);
        ((TsFileResource)this.seqResources.get(0)).remove();
        CompactionExceptionHandler.handleException((String)COMPACTION_TEST_SG, (File)compactionLogFile, targetResources, (List)this.seqResources, (List)this.unseqResources, (TsFileManager)tsFileManager, (long)0L, (boolean)false, (boolean)true);
        Assert.assertTrue((boolean)tsFileManager.isAllowCompaction());
        for (TsFileResource resource : this.seqResources) {
            Assert.assertFalse((boolean)resource.getTsFile().exists());
            Assert.assertFalse((boolean)new File(resource.getTsFilePath() + ".resource").exists());
            Assert.assertFalse((boolean)resource.getModFile().exists());
            Assert.assertFalse((boolean)resource.getCompactionModFile().exists());
        }
        for (TsFileResource resource : this.unseqResources) {
            Assert.assertFalse((boolean)resource.getTsFile().exists());
            Assert.assertFalse((boolean)new File(resource.getTsFilePath() + ".resource").exists());
            Assert.assertFalse((boolean)resource.getModFile().exists());
            Assert.assertFalse((boolean)resource.getCompactionModFile().exists());
        }
        for (int i = 0; i < targetResources.size(); ++i) {
            TsFileResource resource;
            resource = targetResources.get(i);
            if (i == 0) {
                Assert.assertFalse((boolean)resource.getTsFile().exists());
                Assert.assertFalse((boolean)resource.resourceFileExists());
                continue;
            }
            Assert.assertTrue((boolean)resource.getTsFile().exists());
            Assert.assertTrue((boolean)resource.resourceFileExists());
            Assert.assertEquals((Object)TsFileResourceStatus.NORMAL, (Object)resource.getStatus());
        }
    }

    @Test
    public void testWhenTargetFileIsDeletedAfterCompactionAndAllSourceFilesExisted() throws Exception {
        this.createFiles(2, 2, 3, 300, 0, 0, 50, 50, false, true);
        this.createFiles(2, 4, 5, 300, 700, 700, 50, 50, false, true);
        this.createFiles(3, 3, 4, 200, 20, 10020, 30, 30, false, false);
        this.createFiles(2, 1, 5, 100, 450, 20450, 0, 0, false, false);
        TsFileManager tsFileManager = new TsFileManager(COMPACTION_TEST_SG, "0", SEQ_DIRS.getPath());
        tsFileManager.addAll(this.seqResources, true);
        tsFileManager.addAll(this.unseqResources, false);
        for (int device = 0; device < 3; ++device) {
            for (int measurement = 0; measurement < 4; ++measurement) {
                HashMap<String, Pair> deleteMap = new HashMap<String, Pair>();
                deleteMap.put(COMPACTION_TEST_SG + "." + "d" + device + "." + "s" + measurement, new Pair((Object)0L, (Object)300L));
                this.seqResources.forEach(x -> {
                    try {
                        CompactionFileGeneratorUtils.generateMods(deleteMap, x, false);
                    }
                    catch (IOException | IllegalPathException e) {
                        throw new RuntimeException(e);
                    }
                });
                this.unseqResources.forEach(x -> {
                    try {
                        CompactionFileGeneratorUtils.generateMods(deleteMap, x, false);
                    }
                    catch (IOException | IllegalPathException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources);
        File compactionLogFile = new File(SEQ_DIRS, targetResources.get(0).getTsFile().getName() + ".cross-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(compactionLogFile);
        compactionLogger.logFiles(targetResources, "target");
        compactionLogger.logFiles(this.seqResources, "source");
        compactionLogger.logFiles(this.unseqResources, "source");
        compactionLogger.close();
        FastCompactionPerformer performer = new FastCompactionPerformer(this.seqResources, this.unseqResources, targetResources);
        performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        performer.perform();
        CompactionUtils.moveTargetFile(targetResources, (boolean)false, (String)COMPACTION_TEST_SG);
        CompactionUtils.combineModsInCrossCompaction((List)this.seqResources, (List)this.unseqResources, targetResources);
        CompactionExceptionHandler.handleException((String)COMPACTION_TEST_SG, (File)compactionLogFile, targetResources, (List)this.seqResources, (List)this.unseqResources, (TsFileManager)tsFileManager, (long)0L, (boolean)false, (boolean)true);
        Assert.assertTrue((boolean)tsFileManager.isAllowCompaction());
        for (TsFileResource resource : this.seqResources) {
            Assert.assertTrue((boolean)resource.getTsFile().exists());
            Assert.assertTrue((boolean)new File(resource.getTsFilePath() + ".resource").exists());
            Assert.assertTrue((boolean)resource.getModFile().exists());
            Assert.assertFalse((boolean)resource.getCompactionModFile().exists());
        }
        for (TsFileResource resource : this.unseqResources) {
            Assert.assertTrue((boolean)resource.getTsFile().exists());
            Assert.assertTrue((boolean)new File(resource.getTsFilePath() + ".resource").exists());
            Assert.assertTrue((boolean)resource.getModFile().exists());
            Assert.assertFalse((boolean)resource.getCompactionModFile().exists());
        }
        for (TsFileResource resource : targetResources) {
            if (resource == null) continue;
            Assert.assertFalse((boolean)resource.getTsFile().exists());
            Assert.assertFalse((boolean)new File(resource.getTsFilePath().replace(".cross", ".tsfile")).exists());
            Assert.assertFalse((boolean)new File(resource.getTsFilePath().replace(".cross", ".tsfile") + ".resource").exists());
        }
    }

    @Test
    public void testCompactionLogIsDeletedAfterException() throws IOException {
        TsFileResource seqResource1 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqResource1);){
            writer.startChunkGroup("d1");
            writer.generateSimpleNonAlignedSeriesToCurrentDevice("s1", new TimeRange[][][]{{{new TimeRange(10L, 12L), new TimeRange(3L, 12L)}}}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        TsFileResource seqResource2 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqResource2);){
            writer.startChunkGroup("d1");
            writer.generateSimpleNonAlignedSeriesToCurrentDevice("s1", new TimeRange[]{new TimeRange(1L, 9L)}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        this.tsFileManager.addAll(this.seqResources, true);
        TsFileResource unseqResource1 = this.createEmptyFileAndResource(false);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(unseqResource1);){
            writer.startChunkGroup("d1");
            writer.generateSimpleNonAlignedSeriesToCurrentDevice("s1", new TimeRange[][][]{{{new TimeRange(10L, 12L), new TimeRange(3L, 12L)}}}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        TsFileResource unseqResource2 = this.createEmptyFileAndResource(false);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(unseqResource2);){
            writer.startChunkGroup("d1");
            writer.generateSimpleNonAlignedSeriesToCurrentDevice("s1", new TimeRange[]{new TimeRange(35L, 40L)}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        this.unseqResources.add(unseqResource1);
        this.unseqResources.add(unseqResource2);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionTask task = new CrossSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, this.unseqResources, (ICrossCompactionPerformer)new FastCompactionPerformer(true), 0L, 0L);
        Assert.assertFalse((boolean)task.start());
        Assert.assertFalse((boolean)new File(seqResource1.getTsFile().getAbsolutePath().replace("0-0.tsfile", "0-1.cross.cross-compaction.log")).exists());
        Assert.assertEquals((long)4L, (long)Objects.requireNonNull(seqResource1.getTsFile().getParentFile().listFiles()).length);
    }
}

