/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.CompactionTestFileWriter;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.TsFileGeneratorUtils;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.utils.validate.TsFileValidator;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.PlainDeviceID;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.write.chunk.AlignedChunkWriterImpl;
import org.apache.iotdb.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.VectorMeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TsFileValidationCorrectnessTests {
    final String dir = TestConstant.OUTPUT_DATA_DIR + "test-validation";

    @Before
    public void setUp() throws IOException {
        FileUtils.forceMkdir((File)new File(this.dir));
    }

    @After
    public void tearDown() throws IOException {
        File[] files = new File(this.dir).listFiles();
        if (files != null) {
            for (File f : files) {
                FileUtils.delete((File)f);
            }
        }
        FileUtils.forceDelete((File)new File(this.dir));
    }

    @Test
    public void testTsFileHasNoData() throws IOException {
        TsFileResource tsFileResource = new TsFileResource(new File(this.dir + File.separator + "test1.tsfile"));
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(tsFileResource);){
            writer.endFile();
        }
        boolean success = TsFileValidator.getInstance().validateTsFile(tsFileResource);
        Assert.assertFalse((boolean)success);
    }

    @Test
    public void testAlignedTsFileHasOnePageData() throws IOException {
        String path = this.dir + File.separator + "test2.tsfile";
        TsFileResource tsFileResource = new TsFileResource(new File(path));
        TsFileGeneratorUtils.generateSingleAlignedSeriesFile("d1", Collections.singletonList("s1"), new TimeRange[]{new TimeRange(1L, 100L)}, TSEncoding.PLAIN, CompressionType.SNAPPY, path);
        tsFileResource.updateStartTime((IDeviceID)new PlainDeviceID("d1"), 1L);
        tsFileResource.updateEndTime((IDeviceID)new PlainDeviceID("d1"), 100L);
        tsFileResource.serialize();
        boolean success = TsFileValidator.getInstance().validateTsFile(tsFileResource);
        Assert.assertTrue((boolean)success);
    }

    @Test
    public void testAlignedTsFileHasManyPage() throws IOException {
        String path = this.dir + File.separator + "test3.tsfile";
        TsFileResource tsFileResource = new TsFileResource(new File(path));
        TsFileGeneratorUtils.generateSingleAlignedSeriesFile("d1", Collections.singletonList("s1"), new TimeRange[]{new TimeRange(1L, 100L), new TimeRange(22L, 110L)}, TSEncoding.PLAIN, CompressionType.SNAPPY, path);
        tsFileResource.updateStartTime((IDeviceID)new PlainDeviceID("d1"), 1L);
        tsFileResource.updateEndTime((IDeviceID)new PlainDeviceID("d1"), 110L);
        tsFileResource.serialize();
        boolean success = TsFileValidator.getInstance().validateTsFile(tsFileResource);
        Assert.assertTrue((boolean)success);
    }

    @Test
    public void testAlignedTimestampRepeatedOrNotIncremented() throws IOException {
        String path = this.dir + File.separator + "test4.tsfile";
        TsFileResource tsFileResource = new TsFileResource(new File(path));
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(tsFileResource);){
            writer.startChunkGroup("d1");
            VectorMeasurementSchema vectorMeasurementSchema = new VectorMeasurementSchema("d1", new String[]{"s1"}, new TSDataType[]{TSDataType.INT32});
            AlignedChunkWriterImpl chunkWriter = new AlignedChunkWriterImpl(vectorMeasurementSchema);
            chunkWriter.getTimeChunkWriter().write(1L);
            chunkWriter.getTimeChunkWriter().write(2L);
            chunkWriter.getTimeChunkWriter().write(2L);
            chunkWriter.getTimeChunkWriter().write(3L);
            chunkWriter.sealCurrentPage();
            chunkWriter.writeToFileWriter(writer.getFileWriter());
            writer.endChunkGroup();
            writer.endFile();
        }
        boolean success = TsFileValidator.getInstance().validateTsFile(tsFileResource);
        Assert.assertFalse((boolean)success);
    }

    @Test
    public void testAlignedTimestampHasOverlapBetweenPages() throws IOException {
        String path = this.dir + File.separator + "test5.tsfile";
        TsFileResource tsFileResource = new TsFileResource(new File(path));
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(tsFileResource);){
            writer.startChunkGroup("d1");
            VectorMeasurementSchema vectorMeasurementSchema = new VectorMeasurementSchema("d1", new String[]{"s1"}, new TSDataType[]{TSDataType.INT32});
            AlignedChunkWriterImpl chunkWriter = new AlignedChunkWriterImpl(vectorMeasurementSchema);
            chunkWriter.getTimeChunkWriter().write(1L);
            chunkWriter.getTimeChunkWriter().write(2L);
            chunkWriter.getTimeChunkWriter().write(3L);
            chunkWriter.sealCurrentPage();
            chunkWriter.getTimeChunkWriter().write(3L);
            chunkWriter.getTimeChunkWriter().write(4L);
            chunkWriter.getTimeChunkWriter().write(5L);
            chunkWriter.sealCurrentPage();
            chunkWriter.writeToFileWriter(writer.getFileWriter());
            writer.endChunkGroup();
            writer.endFile();
        }
        boolean success = TsFileValidator.getInstance().validateTsFile(tsFileResource);
        Assert.assertFalse((boolean)success);
    }

    @Test
    public void testAlignedTimestampTimeChunkOffsetEqualsMetadata() throws IOException {
        String path = this.dir + File.separator + "test6.tsfile";
        TsFileResource tsFileResource = new TsFileResource(new File(path));
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(tsFileResource);){
            writer.startChunkGroup("d1");
            VectorMeasurementSchema vectorMeasurementSchema = new VectorMeasurementSchema("d1", new String[]{"s1"}, new TSDataType[]{TSDataType.INT32});
            AlignedChunkWriterImpl chunkWriter = new AlignedChunkWriterImpl(vectorMeasurementSchema);
            chunkWriter.getTimeChunkWriter().write(1L);
            chunkWriter.getTimeChunkWriter().write(2L);
            chunkWriter.getTimeChunkWriter().write(3L);
            chunkWriter.getValueChunkWriterByIndex(0).getPageWriter().write(1L, 1, false);
            chunkWriter.getValueChunkWriterByIndex(0).getPageWriter().write(2L, 1, false);
            chunkWriter.getValueChunkWriterByIndex(0).getPageWriter().write(3L, 1, false);
            chunkWriter.sealCurrentPage();
            chunkWriter.writeToFileWriter(writer.getFileWriter());
            writer.endChunkGroup();
            writer.endFile();
        }
        tsFileResource.updateStartTime((IDeviceID)new PlainDeviceID("d1"), 1L);
        tsFileResource.updateEndTime((IDeviceID)new PlainDeviceID("d1"), 3L);
        tsFileResource.serialize();
        boolean success = TsFileValidator.getInstance().validateTsFile(tsFileResource);
        Assert.assertTrue((boolean)success);
    }

    @Test
    public void testNonAlignedTsFileHasOnePageData() throws IOException {
        String path = this.dir + File.separator + "test7.tsfile";
        TsFileResource tsFileResource = new TsFileResource(new File(path));
        TsFileGeneratorUtils.generateSingleNonAlignedSeriesFile("d1", "s1", new TimeRange[]{new TimeRange(1L, 100L)}, TSEncoding.PLAIN, CompressionType.SNAPPY, path);
        tsFileResource.updateStartTime((IDeviceID)new PlainDeviceID("d1"), 1L);
        tsFileResource.updateEndTime((IDeviceID)new PlainDeviceID("d1"), 100L);
        tsFileResource.serialize();
        boolean success = TsFileValidator.getInstance().validateTsFile(tsFileResource);
        Assert.assertTrue((boolean)success);
    }

    @Test
    public void testNonAlignedTsFileHasManyPage() throws IOException {
        String path = this.dir + File.separator + "test8.tsfile";
        TsFileResource tsFileResource = new TsFileResource(new File(path));
        TsFileGeneratorUtils.generateSingleNonAlignedSeriesFile("d1", "s1", new TimeRange[]{new TimeRange(1L, 100L), new TimeRange(22L, 110L)}, TSEncoding.PLAIN, CompressionType.SNAPPY, path);
        tsFileResource.updateStartTime((IDeviceID)new PlainDeviceID("d1"), 1L);
        tsFileResource.updateEndTime((IDeviceID)new PlainDeviceID("d1"), 110L);
        tsFileResource.serialize();
        boolean success = TsFileValidator.getInstance().validateTsFile(tsFileResource);
        Assert.assertTrue((boolean)success);
    }

    @Test
    public void testNonAlignedTimestampRepeatedOrNotIncremented() throws IOException {
        String path = this.dir + File.separator + "test9.tsfile";
        TsFileResource tsFileResource = new TsFileResource(new File(path));
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(tsFileResource);){
            writer.startChunkGroup("d1");
            ChunkWriterImpl chunkWriter = new ChunkWriterImpl((IMeasurementSchema)new MeasurementSchema("s1", TSDataType.INT32));
            chunkWriter.getPageWriter().write(1L, 2);
            chunkWriter.getPageWriter().write(2L, 2);
            chunkWriter.getPageWriter().write(2L, 2);
            chunkWriter.getPageWriter().write(3L, 2);
            chunkWriter.sealCurrentPage();
            chunkWriter.writeToFileWriter(writer.getFileWriter());
            writer.endChunkGroup();
            writer.endFile();
        }
        boolean success = TsFileValidator.getInstance().validateTsFile(tsFileResource);
        Assert.assertFalse((boolean)success);
    }

    @Test
    public void testNonAlignedTimestampHasOverlapBetweenPages() throws IOException {
        String path = this.dir + File.separator + "test10.tsfile";
        TsFileResource tsFileResource = new TsFileResource(new File(path));
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(tsFileResource);){
            writer.startChunkGroup("d1");
            ChunkWriterImpl chunkWriter = new ChunkWriterImpl((IMeasurementSchema)new MeasurementSchema("s1", TSDataType.INT32));
            chunkWriter.getPageWriter().write(1L, 2);
            chunkWriter.getPageWriter().write(2L, 2);
            chunkWriter.getPageWriter().write(3L, 2);
            chunkWriter.sealCurrentPage();
            chunkWriter.getPageWriter().write(3L, 4);
            chunkWriter.getPageWriter().write(4L, 4);
            chunkWriter.writeToFileWriter(writer.getFileWriter());
            writer.endChunkGroup();
            writer.endFile();
        }
        boolean success = TsFileValidator.getInstance().validateTsFile(tsFileResource);
        Assert.assertFalse((boolean)success);
    }

    @Test
    public void testNonAlignedTimestampTimeChunkOffsetEqualsMetadata() throws IOException {
        String path = this.dir + File.separator + "test11.tsfile";
        TsFileResource tsFileResource = new TsFileResource(new File(path));
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(tsFileResource);){
            writer.startChunkGroup("d1");
            VectorMeasurementSchema vectorMeasurementSchema = new VectorMeasurementSchema("d1", new String[]{"s1"}, new TSDataType[]{TSDataType.INT32});
            AlignedChunkWriterImpl chunkWriter = new AlignedChunkWriterImpl(vectorMeasurementSchema);
            chunkWriter.getTimeChunkWriter().write(1L);
            chunkWriter.getTimeChunkWriter().write(2L);
            chunkWriter.getTimeChunkWriter().write(3L);
            chunkWriter.getValueChunkWriterByIndex(0).getPageWriter().write(1L, 1, false);
            chunkWriter.getValueChunkWriterByIndex(0).getPageWriter().write(2L, 1, false);
            chunkWriter.getValueChunkWriterByIndex(0).getPageWriter().write(3L, 1, false);
            chunkWriter.sealCurrentPage();
            chunkWriter.writeToFileWriter(writer.getFileWriter());
            writer.endChunkGroup();
            writer.endFile();
        }
        tsFileResource.updateStartTime((IDeviceID)new PlainDeviceID("d1"), 1L);
        tsFileResource.updateEndTime((IDeviceID)new PlainDeviceID("d1"), 3L);
        tsFileResource.serialize();
        boolean success = TsFileValidator.getInstance().validateTsFile(tsFileResource);
        Assert.assertTrue((boolean)success);
    }
}

