/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.AbstractCompactionTest;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.ICompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.FastCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.ReadChunkCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.InnerSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.CompactionTestFileWriter;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.TsFileGeneratorUtils;
import org.apache.iotdb.db.storageengine.dataregion.modification.Deletion;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.storageengine.dataregion.read.control.FileReaderManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.PlainDeviceID;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.write.chunk.AlignedChunkWriterImpl;
import org.apache.iotdb.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.iotdb.tsfile.write.chunk.IChunkWriter;
import org.apache.iotdb.tsfile.write.chunk.ValueChunkWriter;
import org.apache.iotdb.tsfile.write.page.TimePageWriter;
import org.apache.iotdb.tsfile.write.page.ValuePageWriter;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ReadChunkInnerCompactionTest
extends AbstractCompactionTest {
    @Override
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException, InterruptedException {
        super.setUp();
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkSize(512L);
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkPointNum(100L);
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        TSFileDescriptor.getInstance().getConfig().setMaxDegreeOfIndexNode(3);
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        super.tearDown();
        for (TsFileResource tsFileResource : this.seqResources) {
            FileReaderManager.getInstance().closeFileAndRemoveReader(tsFileResource.getTsFilePath());
        }
        for (TsFileResource tsFileResource : this.unseqResources) {
            FileReaderManager.getInstance().closeFileAndRemoveReader(tsFileResource.getTsFilePath());
        }
    }

    @Test
    public void testNonAlignedWithDifferentEncodingAndCompression() throws MetadataException, IOException {
        ArrayList<TimeRange> pages;
        ArrayList<PartialPath> timeseriesPath;
        List<CompressionType> compressionTypes;
        List<TSEncoding> encodings;
        List<TSDataType> dataTypes;
        int deviceIndex;
        ArrayList<PartialPath> timeserisPathList = new ArrayList<PartialPath>();
        ArrayList<TSDataType> tsDataTypes = new ArrayList<TSDataType>();
        int measurementNum = 20;
        TsFileResource resource = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());){
            for (deviceIndex = 0; deviceIndex < 10; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                timeseriesPath = new ArrayList<PartialPath>();
                for (int i = 0; i < measurementNum; ++i) {
                    timeseriesPath.add((PartialPath)new MeasurementPath(COMPACTION_TEST_SG + "." + "d" + deviceIndex + "." + "s" + i, dataTypes.get(i)));
                }
                pages = new ArrayList<TimeRange>();
                pages.add(new TimeRange(0L, 300L));
                pages.add(new TimeRange(500L, 600L));
                for (IChunkWriter iChunkWriter : TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, false)) {
                    TsFileGeneratorUtils.writeNonAlignedChunk((ChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 0L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 600L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        resource.serialize();
        this.seqResources.add(resource);
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(true);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < 12; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                timeseriesPath = new ArrayList();
                for (int i = 0; i < 5; ++i) {
                    timeseriesPath.add((PartialPath)new MeasurementPath(COMPACTION_TEST_SG + "." + "d" + deviceIndex + "." + "s" + i, dataTypes.get(i)));
                }
                pages = new ArrayList();
                pages.add(new TimeRange(900L, 1400L));
                pages.add(new TimeRange(1550L, 1700L));
                pages.add(new TimeRange(1750L, 2000L));
                for (IChunkWriter iChunkWriter : TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, false)) {
                    TsFileGeneratorUtils.writeNonAlignedChunk((ChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 900L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2000L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.seqResources.add(resource);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        Map<PartialPath, List<TimeValuePair>> sourceDatas = this.readSourceFiles(TsFileGeneratorUtils.createTimeseries(this.maxDeviceNum, this.maxMeasurementNum, false), tsDataTypes);
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, true, (ICompactionPerformer)new ReadChunkCompactionPerformer(), 0L);
        task.start();
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
    }

    @Test
    public void testAlignedWithDifferentEncodingAndCompression() throws MetadataException, IOException {
        ArrayList<Object> pages;
        List<IChunkWriter> iChunkWriters;
        List<PartialPath> timeseriesPath;
        ArrayList<Integer> measurementIndexes;
        List<CompressionType> compressionTypes;
        List<TSEncoding> encodings;
        List<TSDataType> dataTypes;
        int deviceIndex;
        ArrayList<PartialPath> timeserisPathList = new ArrayList<PartialPath>();
        ArrayList<TSDataType> tsDataTypes = new ArrayList<TSDataType>();
        int deviceNum = 10;
        int measurementNum = 10;
        TsFileResource resource = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());){
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList<Integer>();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList<TimeRange>();
                pages.add(new TimeRange(0L, 300L));
                pages.add(new TimeRange(500L, 600L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                ArrayList<TimeRange> timeRanges = new ArrayList<TimeRange>();
                timeRanges.add(new TimeRange(900L, 1199L));
                timeRanges.add(new TimeRange(1301L, 1400L));
                for (IChunkWriter iChunkWriter3 : iChunkWriters) {
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter3, timeRanges, true);
                    iChunkWriter3.writeToFileWriter(tsFileIOWriter);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 0L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 1400L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
                this.generateModsFile(timeseriesPath, resource, 500L, 600L);
            }
            tsFileIOWriter.endFile();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 5;
        measurementNum = 20;
        resource = this.createEmptyFileAndResource(true);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(1800L, 1900L));
                pages.add(new TimeRange(2150L, 2250L));
                pages.add(new TimeRange(2400L, 2500L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 1800L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2500L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
                this.generateModsFile(timeseriesPath, resource, 1840L, 1900L);
                this.generateModsFile(timeseriesPath, resource, 2150L, 2250L);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 15;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(true);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(2801L, 2850L));
                pages.add(new TimeRange(2851L, 2900L));
                pages.add(new TimeRange(3300L, 3400L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                pages.clear();
                pages.add(new TimeRange(3950L, 4100L));
                pages.add(new TimeRange(4200L, 4300L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2801L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 4300L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
                this.generateModsFile(timeseriesPath, resource, 2801L, 2850L);
                this.generateModsFile(timeseriesPath, resource, 3950L, 4100L);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.seqResources.add(resource);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        Map<PartialPath, List<TimeValuePair>> sourceDatas = this.readSourceFiles(TsFileGeneratorUtils.createTimeseries(this.maxDeviceNum, this.maxMeasurementNum, true), tsDataTypes);
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, true, (ICompactionPerformer)new ReadChunkCompactionPerformer(), 0L);
        task.start();
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
    }

    @Test
    public void testReadChunkPerformerWithEmptyTargetFile1() throws IOException {
        TsFileResource seqFile1 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqFile1);){
            writer.endFile();
        }
        TsFileResource seqFile2 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqFile2);){
            writer.endFile();
        }
        TsFileResource seqFile3 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqFile3);){
            writer.endFile();
        }
        this.seqResources.add(seqFile1);
        this.seqResources.add(seqFile2);
        this.seqResources.add(seqFile3);
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, true, (ICompactionPerformer)new ReadChunkCompactionPerformer(), 0L);
        Assert.assertTrue((boolean)task.start());
        Assert.assertEquals((long)0L, (long)this.tsFileManager.getTsFileList(true).size());
    }

    @Test
    public void testReadChunkPerformerWithEmptyTargetFile2() throws IOException {
        TsFileResource seqFile1 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqFile1);){
            writer.endFile();
        }
        TsFileResource seqFile2 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqFile2);){
            writer.endFile();
        }
        TsFileResource seqFile3 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqFile3);){
            writer.startChunkGroup("d1");
            writer.endChunkGroup();
            writer.endFile();
        }
        this.seqResources.add(seqFile1);
        this.seqResources.add(seqFile2);
        this.seqResources.add(seqFile3);
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, true, (ICompactionPerformer)new ReadChunkCompactionPerformer(), 0L);
        Assert.assertTrue((boolean)task.start());
        Assert.assertEquals((long)0L, (long)this.tsFileManager.getTsFileList(true).size());
    }

    @Test
    public void testReadChunkPerformerWithEmptyTargetFile3() throws IOException, IllegalPathException {
        TsFileResource seqFile1 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqFile1);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDevice(Arrays.asList("s1"), new TimeRange[]{new TimeRange(1L, 2L)}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        seqFile1.getModFile().write((Modification)new Deletion(new PartialPath("root.testsg.d1.s1"), Long.MAX_VALUE, Long.MAX_VALUE));
        seqFile1.getModFile().close();
        TsFileResource seqFile2 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqFile2);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDevice(Arrays.asList("s1"), new TimeRange[]{new TimeRange(5L, 6L)}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        seqFile2.getModFile().write((Modification)new Deletion(new PartialPath("root.testsg.d1.**"), Long.MAX_VALUE, Long.MAX_VALUE));
        seqFile2.getModFile().close();
        TsFileResource seqFile3 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqFile3);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDevice(Arrays.asList("s1"), new TimeRange[]{new TimeRange(10L, 20L)}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        seqFile3.getModFile().write((Modification)new Deletion(new PartialPath("root.testsg.d1.**"), Long.MAX_VALUE, Long.MAX_VALUE));
        seqFile3.getModFile().close();
        this.seqResources.add(seqFile1);
        this.seqResources.add(seqFile2);
        this.seqResources.add(seqFile3);
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, true, (ICompactionPerformer)new ReadChunkCompactionPerformer(), 0L);
        Assert.assertTrue((boolean)task.start());
        Assert.assertEquals((long)0L, (long)this.tsFileManager.getTsFileList(true).size());
    }

    @Test
    public void testReadChunkPerformerWithEmptyTargetFile4() throws IOException, IllegalPathException {
        TsFileResource seqFile1 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqFile1);){
            writer.startChunkGroup("d1");
            writer.generateSimpleNonAlignedSeriesToCurrentDevice("s1", new TimeRange[]{new TimeRange(1L, 2L)}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        seqFile1.getModFile().write((Modification)new Deletion(new PartialPath("root.testsg.d1.**"), Long.MAX_VALUE, Long.MAX_VALUE));
        seqFile1.getModFile().close();
        TsFileResource seqFile2 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqFile2);){
            writer.startChunkGroup("d1");
            writer.generateSimpleNonAlignedSeriesToCurrentDevice("s1", new TimeRange[]{new TimeRange(5L, 6L)}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        seqFile2.getModFile().write((Modification)new Deletion(new PartialPath("root.testsg.d1.**"), Long.MAX_VALUE, Long.MAX_VALUE));
        seqFile2.getModFile().close();
        TsFileResource seqFile3 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqFile3);){
            writer.startChunkGroup("d1");
            writer.generateSimpleNonAlignedSeriesToCurrentDevice("s1", new TimeRange[]{new TimeRange(10L, 20L)}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        seqFile3.getModFile().write((Modification)new Deletion(new PartialPath("root.testsg.d1.**"), Long.MAX_VALUE, Long.MAX_VALUE));
        seqFile3.getModFile().close();
        this.seqResources.add(seqFile1);
        this.seqResources.add(seqFile2);
        this.seqResources.add(seqFile3);
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, true, (ICompactionPerformer)new ReadChunkCompactionPerformer(), 0L);
        Assert.assertTrue((boolean)task.start());
        Assert.assertEquals((long)0L, (long)this.tsFileManager.getTsFileList(true).size());
    }

    @Test
    public void testReadChunkPerformerWithEmptyTargetFile5() throws IOException, IllegalPathException {
        TsFileResource seqFile1 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqFile1);){
            writer.startChunkGroup("d1");
            writer.generateSimpleNonAlignedSeriesToCurrentDevice("s1", new TimeRange[]{new TimeRange(1L, 2L)}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        seqFile1.getModFile().write((Modification)new Deletion(new PartialPath("root.**"), Long.MAX_VALUE, Long.MAX_VALUE));
        seqFile1.getModFile().close();
        TsFileResource seqFile2 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqFile2);){
            writer.startChunkGroup("d1");
            writer.generateSimpleNonAlignedSeriesToCurrentDevice("s1", new TimeRange[]{new TimeRange(5L, 6L)}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        seqFile2.getModFile().write((Modification)new Deletion(new PartialPath("root.**"), Long.MAX_VALUE, Long.MAX_VALUE));
        seqFile2.getModFile().close();
        TsFileResource seqFile3 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqFile3);){
            writer.startChunkGroup("d1");
            writer.generateSimpleNonAlignedSeriesToCurrentDevice("s1", new TimeRange[]{new TimeRange(10L, 20L)}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        seqFile3.getModFile().write((Modification)new Deletion(new PartialPath("root.testsg.**"), Long.MAX_VALUE, Long.MAX_VALUE));
        seqFile3.getModFile().close();
        this.seqResources.add(seqFile1);
        this.seqResources.add(seqFile2);
        this.seqResources.add(seqFile3);
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, true, (ICompactionPerformer)new ReadChunkCompactionPerformer(), 0L);
        Assert.assertTrue((boolean)task.start());
        Assert.assertEquals((long)0L, (long)this.tsFileManager.getTsFileList(true).size());
    }

    @Test
    public void testReadChunkPerformerWithEmptyTargetFile6() throws IOException, IllegalPathException {
        TsFileResource seqFile1 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqFile1);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDevice(Arrays.asList("s1"), new TimeRange[]{new TimeRange(1L, 2L)}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        seqFile1.getModFile().write((Modification)new Deletion(new PartialPath("root.**"), Long.MAX_VALUE, Long.MAX_VALUE));
        seqFile1.getModFile().close();
        TsFileResource seqFile2 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqFile2);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDevice(Arrays.asList("s1"), new TimeRange[]{new TimeRange(5L, 6L)}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        seqFile2.getModFile().write((Modification)new Deletion(new PartialPath("root.**"), Long.MAX_VALUE, Long.MAX_VALUE));
        seqFile2.getModFile().close();
        TsFileResource seqFile3 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqFile3);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDevice(Arrays.asList("s1"), new TimeRange[]{new TimeRange(10L, 20L)}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        seqFile3.getModFile().write((Modification)new Deletion(new PartialPath("root.testsg.**"), Long.MAX_VALUE, Long.MAX_VALUE));
        seqFile3.getModFile().close();
        this.seqResources.add(seqFile1);
        this.seqResources.add(seqFile2);
        this.seqResources.add(seqFile3);
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, true, (ICompactionPerformer)new ReadChunkCompactionPerformer(), 0L);
        Assert.assertTrue((boolean)task.start());
        Assert.assertEquals((long)0L, (long)this.tsFileManager.getTsFileList(true).size());
    }

    @Test
    public void testReadChunkPerformerWithNonEmptyTargetFile() throws IOException {
        TsFileResource seqFile1 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqFile1);){
            writer.endFile();
        }
        TsFileResource seqFile2 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqFile2);){
            writer.endFile();
        }
        TsFileResource seqFile3 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqFile3);){
            writer.startChunkGroup("d1");
            writer.generateSimpleNonAlignedSeriesToCurrentDevice("s1", new TimeRange[]{new TimeRange(1L, 2L)}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        this.seqResources.add(seqFile1);
        this.seqResources.add(seqFile2);
        this.seqResources.add(seqFile3);
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, true, (ICompactionPerformer)new ReadChunkCompactionPerformer(), 0L);
        Assert.assertTrue((boolean)task.start());
        Assert.assertEquals((long)1L, (long)this.tsFileManager.getTsFileList(true).size());
    }

    @Test
    public void testCompactionLogIsDeletedAfterException() throws IOException {
        TsFileResource seqResource1 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqResource1);){
            writer.startChunkGroup("d1");
            writer.generateSimpleNonAlignedSeriesToCurrentDevice("s1", new TimeRange[][][]{{{new TimeRange(10L, 12L), new TimeRange(3L, 12L)}}}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        TsFileResource seqResource2 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqResource2);){
            writer.startChunkGroup("d1");
            writer.generateSimpleNonAlignedSeriesToCurrentDevice("s1", new TimeRange[]{new TimeRange(1L, 9L)}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        this.tsFileManager.addAll(this.seqResources, true);
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, true, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertFalse((boolean)task.start());
        Assert.assertFalse((boolean)new File(seqResource1.getTsFile().getAbsolutePath().replace("0-0.tsfile", "1-0.inner.inner-compaction.log")).exists());
        Assert.assertEquals((long)4L, (long)Objects.requireNonNull(seqResource1.getTsFile().getParentFile().listFiles()).length);
    }

    @Test
    public void testCompactionWithAllEmptyValueChunks() throws IOException, IllegalPathException {
        ArrayList<PartialPath> timeserisPathList = new ArrayList<PartialPath>();
        ArrayList<TSDataType> tsDataTypes = new ArrayList<TSDataType>();
        int deviceNum = 10;
        int measurementNum = 10;
        TsFileResource resource = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());){
            for (int deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                List<TSDataType> dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                List<TSEncoding> encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                List<CompressionType> compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                ArrayList<Integer> measurementIndexes = new ArrayList<Integer>();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                List<PartialPath> timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                List<IChunkWriter> iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                ArrayList<TimeRange> pages = new ArrayList<TimeRange>();
                pages.add(new TimeRange(0L, 300L));
                pages.add(new TimeRange(500L, 600L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    if (deviceIndex == 0) {
                        this.writeEmptyAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                        continue;
                    }
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 0L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 1400L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
                if (deviceIndex != 0) continue;
                this.generateModsFile(timeseriesPath, resource, Long.MIN_VALUE, Long.MAX_VALUE);
            }
            tsFileIOWriter.endFile();
        }
        resource.serialize();
        this.seqResources.add(resource);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        Map<PartialPath, List<TimeValuePair>> sourceDatas = this.readSourceFiles(TsFileGeneratorUtils.createTimeseries(this.maxDeviceNum, this.maxMeasurementNum, true), tsDataTypes);
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, Collections.singletonList((TsFileResource)this.seqResources.get(0)), true, (ICompactionPerformer)new ReadChunkCompactionPerformer(), 0L);
        Assert.assertTrue((boolean)task.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
    }

    private void writeEmptyAlignedChunk(AlignedChunkWriterImpl alignedChunkWriter, TsFileIOWriter tsFileIOWriter, List<TimeRange> pages, boolean isSeq) throws IOException {
        TimePageWriter timePageWriter = alignedChunkWriter.getTimeChunkWriter().getPageWriter();
        for (TimeRange page : pages) {
            for (long timestamp = page.getMin(); timestamp <= page.getMax(); ++timestamp) {
                timePageWriter.write(timestamp);
            }
            alignedChunkWriter.getTimeChunkWriter().sealCurrentPage();
            for (ValueChunkWriter valueChunkWriter : alignedChunkWriter.getValueChunkWriterList()) {
                ValuePageWriter valuePageWriter = valueChunkWriter.getPageWriter();
                for (long timestamp = page.getMin(); timestamp <= page.getMax(); ++timestamp) {
                    this.writeEmptyAlignedPoint(valuePageWriter, timestamp, isSeq);
                }
                valueChunkWriter.sealCurrentPage();
            }
        }
        alignedChunkWriter.writeToFileWriter(tsFileIOWriter);
    }

    private void writeEmptyAlignedPoint(ValuePageWriter valuePageWriter, long timestamp, boolean isSeq) {
        switch (valuePageWriter.getStatistics().getType()) {
            case TEXT: {
                valuePageWriter.write(timestamp, new Binary(isSeq ? "seqText" : "unSeqText", TSFileConfig.STRING_CHARSET), true);
                break;
            }
            case DOUBLE: {
                valuePageWriter.write(timestamp, isSeq ? (double)timestamp + 0.01 : 100000.01 + (double)timestamp, true);
                break;
            }
            case BOOLEAN: {
                valuePageWriter.write(timestamp, isSeq, true);
                break;
            }
            case INT64: {
                valuePageWriter.write(timestamp, isSeq ? timestamp : 100000L + timestamp, true);
                break;
            }
            case INT32: {
                valuePageWriter.write(timestamp, isSeq ? (int)timestamp : (int)(100000L + timestamp), true);
                break;
            }
            case FLOAT: {
                valuePageWriter.write(timestamp, isSeq ? (float)timestamp + 0.1f : (float)(100000.1 + (double)timestamp), true);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown data type " + valuePageWriter.getStatistics().getType());
            }
        }
    }
}

